; $Id$
;###############################################################################
;+
; NAME:
;   wd_DAVETool
;
; PURPOSE:
;   The main user interface widget creation routine for the DAVE Main
;   Tool. This is essentially what the user sees when the tool is
;   launched.
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2005
;-
;###############################################################################


;===============================================================================
; wd_DAVETool__ParamPropSheet_AddData
; 
; PURPOSE:
;   Attept to automatically match data from a container to
;   visualization parameters.
; PARAMETERS
;   sPtr [in] - Pointer to a state structure
;
;   validDataTypes [in] - known valid data types assigned to plottable data containers
;   
;   plane [in]          - for Plot3D, the view plane from a 2D dataset
;   groupToView [in]    - for Plot3D, this specifies the group to be viewed from a 2D dataset
;
; KEYWORDS:
; 
; Return Value
;   Return the number of data-visualization parameter matches found
function wd_DAVETool_ParamPropSheet_AddData, sPtr, validDataTypes, plane, grouptoView
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'wd_DAVETool_ParamPropSheet_AddData: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle)
        catch, /cancel
        return, 0
    endif
endif

oSystem = _IDLitSys_GetSystem()
oPset = oSystem->GetByIdentifier((*sPtr).dataID)
oDataParent = GetMainDataObjectParent(oPset)

if (n_elements(validDataTypes) gt 0) then begin
   ; Does the parameterset's data type match one of the valid plottable data types?
   ; If not then try to search for one of the valid types within it.
   oPset->GetProperty, type=dataType
   void = where(dataType eq validDataTypes, validType)
   if (~validType) then begin
      ;; search for one of the valid types from pset
      nValid = n_elements(validDataTypes)
      j = 0
      repeat begin
         oRes = oPset->GetByType(validDataTypes[j],count=validType)
      endrep until (validType || ++j ge nValid)
      if (validType) then oPset = oRes
   endif
   
   if (~validType) then return, 0   ; failure
endif

(*sPtr)._oParamProp->GetProperty,vis_type=vis_index 
visType = strupcase((*sPtr).visidlist[vis_index]) ; currently selected visualization type
visPars = (*(*sPtr).paramid)
paramTypes = (*(*sPtr).paramTypes) ; res is a ptr array

plotLabel='' ;visType
matchFound = 0
;containerDataType = (*sPtr).dataType
oPset->GetProperty, type=containerDataType
switch containerDataType of
    'ASCIICOL':                 ; ASCII Column 
    'ASCIISPE':                 ; ASCII SPE
    'ASCIIGRP':                 ; ASCII Group
    'DAVE1COMMONSTR': begin     ; DAVE 1.x plottable dataset
        oChildren = oPset->Get(/ALL)

        if (visType eq 'PLOT3D') then begin
;            ;; Get the z-zxis data
;            oZ = oPset->GetByName('2')
;            if (~obj_valid(oZ)) then break
;            oE = oPset->GetByName('3')
;            errorPresent = (obj_valid(oE))? 1 : 0 
;            oX = oPset->GetByName('0')
;            if (~obj_valid(oX)) then break
;            oY = oPset->GetByName('1')
;            if (~obj_valid(oY)) then break
;            if (~oZ->GetData(zData)) then break
;            if (errorPresent) then void = oE->GetData(eData)
;            if (~oX->GetData(xData)) then break
;            if (~oY->GetData(yData)) then break
;            
;            nx = n_elements(xData)
;            ny = n_elements(yData)
;            zdim = size(zData,/dimensions)

            oDataParent->GetProperty, axis1Value=xData, axis2Value=yData, dataValue=zData, errorValue=eData
            errorPresent = (n_elements(eData) gt 0)? 1 : 0 
            nx = n_elements(xData)
            ny = n_elements(yData)
            zdim = size(zData,/dimensions)

            planeNotDefined = (n_elements(plane) eq 0)
            groupsNotDefined = (n_elements(groupToView) eq 0)
            if (planeNotDefined && groupsNotDefined) then begin
               ;; Should only happen when using the arrow button to assign data to vis params
               ;; When using the auto-create or auto-add context menus, the plane and
               ;; groups to view should already have been assigned in a previous 
               ;; instantiation of the plot3d options UI service!
               oPlot3DProps = oSystem->getByIdentifier('/Registry/Misc/Plot3D Options')
               if (~obj_valid(oPlot3dProps)) then return, 0
               
               oPlot3DProps->setProperty, nxgrps=nx, nygrps=ny
               if (~oSystem->doUIService('PropertySheet',oPlot3dProps)) then return, 0
                
               oPlot3DProps->GetProperty, grpIndices=groupsToView, plane=plane
               groupToView = groupsToView[0]
            endif

            iGrpIndex = groupToView - 1            ; convert to index

            ; Define the 2D line data; (x,y) values, Intensity, error
            case plane of
               0: begin    ; z-x plane
                   ;; get value of y group and make a y dataset of same size as x dataset
                   yData = replicate(yData[iGrpIndex],zdim[0])
                   plotLabel = 'y='+strtrim(string(yData[0]),2)

                   ;; retrieve appropriate data grp and assign to vis parameter 'Z'.
                   zData = reform(zData[*,iGrpIndex])
                   eData = reform(eData[*,iGrpIndex])
               end
               
               1: begin    ; z-y plane
                   ;; get value of x group and make an x dataset of same size as y dataset
                   xData = replicate(xData[iGrpIndex],zdim[1])
                   plotLabel = 'x='+strtrim(string(xData[0]),2)

                   ;; retrieve appropriate data grp and assign to vis parameter 'Z'.
                   zData = reform(zData[iGrpIndex,*])
                   eData = reform(eData[iGrpIndex,*])
               end
               
               else:          
            endcase

            ;; Elliminate non-finite (eg NaNs) data points
            finite_index = where(finite(zData))
            xData = xData[finite_index]
            yData = yData[finite_index]
            zData = zData[finite_index]
            eData = eData[finite_index]

        endif

        for i=0,n_elements(oChildren)-1 do begin
            newDataIsDefined = 0
            oDataItem = oChildren[i]
            oChildren[i]->getProperty, type=childDataType, name=childName, axisType=axisType
            if (n_elements(axisType) eq 0) then axisType = -1
            case visType of
             'PLOT': begin
;                    case strupcase(childName) of
               case axisType of
                   0: begin     ; assign to vis parameter 'X'
                     pind = where(visPars eq 'X')
                  end
                  
                  2: begin
                     pind = where(visPars eq 'Y')
                  end
                  
                  3: begin
                     pind = where(visPars eq 'Y_ERROR')
                  end
                  
                  else: pind = -1
               endcase
            end
            
            'PLOT3D': begin
               case axisType of
                  0: begin
                     pind = where(visPars eq 'X')
                     dataVals = xData
                     newDataIsDefined = 1

;                     if (plane eq 1) then begin ; z-y plane
;                         ;; get value of x group and make an x dataset of
;                         ;; same size as y dataset
;                         dataVals = replicate(xData[iGrpIndex],zdim[1])
;                         plotLabel = 'x='+strtrim(string(dataVals[0]),2)
;                         newDataIsDefined = 1
;                     endif
                  end
                  
                  1: begin
                     pind = where(visPars eq 'Y', pcnt)
                     dataVals = yData
                     newDataIsDefined = 1

;                     if (plane eq 0) then begin ; z-x plane
;                         ;; get value of y group and make a y dataset of
;                         ;; same size as x dataset
;                         dataVals = replicate(yData[iGrpIndex],zdim[0])
;                         plotLabel = 'y='+strtrim(string(dataVals[0]),2)
;                         newDataIsDefined = 1
;                     endif

                  end
                  
                  2: begin      ; assign to vis parameter 'Z'
                     pind = where(visPars eq 'Z',pcnt)
                     dataVals = zData
                     newDataIsDefined = 1
                     
;                     ;; Retrieve appropriate data grp and assign to
;                     ;; vis parameter 'Z'.
;                     dataVals = (plane eq 0)? zData[*,iGrpIndex] : zData[iGrpIndex,*]
;                     newDataIsDefined = 1
;                     dataVals = reform(dataVals)
                  end
                  
                  3: begin
                     pind = where(visPars eq 'Z_ERROR',pcnt)
                     dataVals = eData
                     newDataIsDefined = 1

;                     dataVals = (plane eq 0)? eData[*,iGrpIndex] : eData[iGrpIndex,*]
;                     newDataIsDefined = 1
;                     dataVals = reform(dataVals)
                  end
                  
                  else: pind = -1
               endcase
            end
            
            'IMAGE': begin
                case axisType of
                  0: begin
                     pind = where(visPars eq 'X')
                  end
                  
                  1: begin
                     pind = where(visPars eq 'Y')
                  end
                  
                  2: begin
                     pind = where(visPars eq 'IMAGEPIXELS')
                  end
                  
                  else: pind = -1
               endcase
            end
            
            'CONTOUR': begin
               case axisType of
                  0: begin
                     pind = where(visPars eq 'X')
                  end
                  
                  1: begin
                     pind = where(visPars eq 'Y')
                  end
                  
                  2: begin
                     pind = where(visPars eq 'Z')
                  end
                  
                  else: pind = -1
               endcase
            end
            
            'SURFACE': begin
               case axisType of
                  0: begin
                     pind = where(visPars eq 'X')
                  end
                  
                  1: begin
                     pind = where(visPars eq 'Y')
                  end
                  
                  2: begin
                     pind = where(visPars eq 'Z')
                  end
                  
                  else: pind = -1
               endcase
               if (pind lt 0) then break                    
            end
            
            else: pind = -1
         endcase

         if ((visType eq 'PLOT3D') && newDataIsDefined) then begin
             ;; Create temporal data (for duration of viz) to enable
             ;; creation of viz
             oChildren[i]->GetProperty, description=desc
             childDataType = partype(dataVals)
             childName = strtrim(childName)+strtrim(string(iGrpIndex+1),2)
             oDataItem = obj_new('IDLitDataDAVE',dataVals,name=childName,type=childDataType $
                             ,description=desc, axisType=axisType)
             oDataItem->SetProperty, /auto_delete ; tag for removal when no longer used
             if (oChildren[i]->GetMetaDataCount() gt 0) then begin
                 metaDataNames = oChildren[i]->GetMetaDataNames(count=metaCnt)
                 for mi=0,metaCnt-1 do begin
                     ok = oChildren[i]->GetMetaData(metaDataNames[mi],metaDataBuf)
                     if (ok) then $
                       oDataItem->AddMetaData, metaDataNames[mi], metaDataBuf
                 endfor
             endif
             oSystem->AddbyIdentifier,'/Data Manager',oDataItem
         endif

         if (pind lt 0) then continue ; to next iteration of loop
         visPar = visPars[pind]
         ;; datatype of data should be of type(s) expected by vis paramter
         void = where((*(paramTypes[pind])[0]) eq childDataType, count)
         if (count le 0) then continue
         ;; get  a 'long path style' name of the data
         fullChildName = cw_itParameterPropertysheet_GetDataName(oDataItem)
         ;; associate the data with the vis parameter
         (*sPtr)._oParamProp->SetPropertyByIdentifier, visPar, fullChildName
         ;; update prop sheet and state structure
         widget_control,(*sPtr).wProp, refresh_property=visPar
         (*(*sPtr).paramData)[pind] = fullChildName
         (*(*sPtr).paramDataID)[pind] = oDataItem->GetFullIdentifier()

         matchFound++
      endfor
      break
   end
   
   else: begin
      ;; handle single data items
      if ((*sPtr).dataPset ne 0) then break ; proceed only if not a parameterset
      
      ;; first determine axis type of data item
      oItem = oPset
      oItem->GetProperty, axisType = axisType, type=childDataType
      if (n_elements(axisType) eq 0) then axisType = -1
      case visType of
         'PLOT': begin
            case axisType of
               0: begin
                  pind = where(visPars eq 'X')
               end
               
               2: begin
                  pind = where(visPars eq 'Y')
               end
               
               3: begin
                  pind = where(visPars eq 'Y_ERROR')
               end
               
               else: pind = -1
            endcase
         end
         
         'PLOT3D': begin
            case axisType of
               0: begin
                  pind = where(visPars eq 'X')
               end
               
               1: begin
                  pind = where(visPars eq 'Y')
               end
               
               2: begin
                  pind = where(visPars eq 'Z')
               end
               
               3: begin
                  pind = where(visPars eq 'Z_ERROR')
               end
               
               else: pind = -1
            endcase
         end
         
         'IMAGE': begin
            case axisType of
               0: begin
                  pind = where(visPars eq 'X')
               end
               
               1: begin
                  pind = where(visPars eq 'Y')
               end
               
               2: begin
                  pind = where(visPars eq 'IMAGEPIXELS')
               end
               
               else: pind = -1
            endcase
         end
         
         'CONTOUR': begin
            case axisType of
               0: begin
                  pind = where(visPars eq 'X')
               end
               
               1: begin
                  pind = where(visPars eq 'Y')
               end
               
               2: begin
                  pind = where(visPars eq 'Z')
               end
               
               else: pind = -1
            endcase
         end
         
         'SURFACE': begin
            case axisType of
               0: begin
                  pind = where(visPars eq 'X')
               end
               
               1: begin
                  pind = where(visPars eq 'Y')
               end
               
               2: begin
                  pind = where(visPars eq 'Z')
               end
               
               else: pind = -1
            endcase
            if (pind lt 0) then break                    
         end

         else: pind = -1
      endcase

      if (pind lt 0) then break ; nothing to do!
      visPar = visPars[pind]
      ;; datatype of data should be of type(s) expected by vis paramter
      void = where((*(paramTypes[pind])[0]) eq childDataType, count)
      if (count le 0) then break
      ;; get fully qualified name of data
      fullChildName = cw_itParameterPropertysheet_GetDataName(oItem)
      ;; associate the data with the vis parameter
      (*sPtr)._oParamProp->SetPropertyByIdentifier, visPar, fullChildName
      ;; update prop sheet and state structure
      widget_control,(*sPtr).wProp, refresh_property=visPar
      (*(*sPtr).paramData)[pind] = fullChildName
      (*(*sPtr).paramDataID)[pind] = oItem->GetFullIdentifier()
      matchFound++

      break
   end

endswitch

;; Register plotlabel in state ptr of main widget
oTool = ((*sPtr).oUI)->GetTool()
if (obj_isa(oTool,'DAVETOOl')) then begin
   sPtrMain = oTool->GetStatePtr()
   (*sPtrMain).plotLabel = plotLabel
endif


return, matchFound

end
;-------------------------------------------------------------------------------

