; $Id$
;


;===============================================================================
; GenQFTool::GetSystem
; 
; PURPOSE:
;   Return the IDLitSystem object
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::GetSystem
compile_opt idl2

return, self->_GetSystem()

end


;===============================================================================
; GenQFTool::GetUI
; 
; PURPOSE:
;   Return the IDLitUI object for this tool
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::GetUI
compile_opt idl2

return, self._oUIConnection

end


;-------------------------------------------------------------------------------
pro GenQFTool::Cleanup
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'GenQFTool::Cleanup: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle)

        catch, /cancel
        ptr_free, Self.prefsPtr
        ptr_free, Self.historyPtr
        Self->IDLitTool::Cleanup
        Self->EnableUpdates
        return
    endif
endif

Self->DisableUpdates

; save session preferences
status = Self->SavePreferences()

ptr_free, Self.prefsPtr
ptr_free, Self.historyPtr

; Clean up samp container
oItems = Self.sampContRef->Get(/all, count=n)
if (n gt 0) then begin
   for i=0,n-1 do begin
      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
      if (ptr_valid(dataPtr)) then heap_free, dataPtr
   endfor
endif
obj_destroy, Self.sampContRef

;; Clean up samp container
;oItems = Self.bkgdContRef->Get(/all, count=n)
;if (n gt 0) then begin
;   for i=0,n-1 do begin
;      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
;      if (ptr_valid(dataPtr)) then heap_free, dataPtr
;   endfor
;endif


;obj_destroy, [Self.sampContRef,Self.bkgdContRef]

; Call base class cleanup
self->IDLitTool::Cleanup

Self->EnableUpdates

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; GenQFTool::savePreferences
;
; PURPOSE:
;   Update and save current user preferences
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function GenQFTool::SavePreferences, skip_filesave=skip_filesave
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'GenQFTool::savePreferences: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

; Save current user graphic customizations and preferences
if (Self->HasVisualizations()) then begin
   oWin = Self->GetCurrentWindow()
   oView = oWin->GetCurrentView()
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
   
   for j=nVis-1,0,-1 do begin
      oVis[j]->Select
      Self->saveVisProps, oVis[j]
   endfor
endif

Self->GetProperty, preferences=preferences

if keyword_set(skip_filesave) then return, 1

if (n_elements(preferences) gt 0) then $
   status = GenQFPreferences(preferences, /save)

return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; GenQFTool::Exit
;+
; PURPOSE:
;   Exit handler
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function GenQFTool::Exit
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'GenQFTool::Exit: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wd_GenQFTool_event, { WIDGET_KILL_REQUEST, ID:wTLB, TOP:wTLB, HANDLER:wTLB }

return, 1
end


;-------------------------------------------------------------------------------
pro GenQFTool::GetProperty, sf=sf, QQ=QQ, mass=mass, kc=kc, n0=n0, Temp=Temp $
  ,alpha2=alpha2, alpha4=alpha4, alpha6=alpha6, abar3=abar3, abar4=abar4, abar52=abar52, abar64=abar64 $
  ,u2=u2, u3=u3, u4=u4, u5=u5, u6=u6, smin=smin, smax=smax, sint=sint,AACompFlag=AACompFlag $
  ,overplotFlag=overplotFlag, blank=blank $
  ,kmin=kmin, kmax=kmax, kint=kint, ymin=ymin, ymax=ymax, yint=yint, oPSet=oPSet $
  ,nameTag=nameTag, prompt=prompt, prmptTitle=prmptTitle, prmptDesc=prmptDesc $
  ,data_directory=dataDir, daveTool=daveTool,logFlag=logFlag $
  ,preferences=preferences,history=history, modifiedStatus=modifiedStatus $
  ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
  ,funcFlag=funcFlag,xAxisVar=xAxisVar,yAxisVar=yAxisVar $
 ,errorbar_capsize=errorbar_capsize $
 ,transparency=transparency $
 ,antialias=antialias $
 ,color=color $
 ,errorbar_color=errorbar_color $
 ,use_default_color=use_default_color $
 ,sym_increment=sym_increment $
 ,sym_index=sym_index $
 ,sym_size=sym_size $
 ,sym_color=sym_color $
 ,sym_thick=sym_thick $
 ,y_errorbars=y_errorbars $
 ,linestyle=linestyle $
 ,thick=thick $
 ,sym_filled=sym_filled $
 ,sym_fill_color=sym_fill_color $
 ,font_name=font_name  $
 ,font_size=font_size $
 ,text_color=text_color  $
 ,_REF_EXTRA=etc
 ; ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag $
 ; ,maskedDets=maskedDets,monScaleValue=monScaleValue,multipleMsliceWinFlag=multipleMsliceWinFlag $
 ; ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag,calibParamsisSet=calibParamsisSet $
 ; ,fastFlag=fastFlag,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,effNormFlag=effNormFlag,mev2wnos=mev2wnos,fastparams=fastparams $
 ; ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag, chDelA4isSet=chDelA4isSet, curMaxDataLen=curMaxDataLen $
 ; ,sampContRef=sampContRef,bkgdContRef=bkgdContRef,fastContRef=fastContRef,phiOffset=phiOffset $
 ; ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
 ; ,bkgdSubVarFlag=bkgdSubVarFlag,bkgdSubVarTol=bkgdSubVarTol $
 ; ,constBinFlag=constBinFlag,useTempAverageFlag=useTempAverageFlag,oplotFastFitFlag=oplotFastFitFlag $
 ; ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
 ; ,sharedSettingsFlag=sharedSettingsFlag,settingIndex=settingIndex $
 ; ,oplotBkgdFlag=oplotBkgdFlag, ftpObject=ftpObject $
 ; ,latParamFlag=latParamFlag, latticeParameters=latticeParameters, qUnits=qUnits $
 ; ,minBinWidth=minBinWidth,binwidths=binWidths, funcs=funcs $
 ; ,exportIndex1=exportIndex1,exportIndex2=exportIndex2,exportIndex3=exportIndex3 $
 ; ,indepVar1List=indepVar1List,indepVar2List=indepVar2List,indepVar3List=indepVar3List $
 ; ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
 ; ,monCorFlag=monCorFlag, normalizeTo=normalizeTo ,mergeChannelsFlag=mergeChannelsFlag $
 ; ,selectedIDs=selectedIDs,nSelectedIDs=nSelectedIDs,selectedNames=selectedNames  $

compile_opt idl2

; daveTool
if (arg_present(daveTool)) then $
  daveTool = self.daveTool

if (arg_present(errorbar_capsize)) then errorbar_capsize=Self.errorbar_capsize
if (arg_present(transparency)) then transparency=Self.transparency
if (arg_present(antialias)) then antialias=Self.antialias
if (arg_present(color)) then color=Self.color
if (arg_present(errorbar_color)) then errorbar_color=Self.errorbar_color
if (arg_present(use_default_color)) then use_default_color=Self.use_default_color 
if (arg_present(sym_increment)) then sym_increment=Self.sym_increment 
if (arg_present(sym_index)) then sym_index=Self.sym_index 
if (arg_present(sym_size)) then sym_size=Self.sym_size 
if (arg_present(sym_color)) then sym_color=Self.sym_color 
if (arg_present(sym_thick)) then sym_thick=Self.sym_thick 
if (arg_present(y_errorbars)) then y_errorbars=Self.y_errorbars
if (arg_present(linestyle)) then linestyle=Self.linestyle
if (arg_present(thick)) then thick=Self.thick
if (arg_present(sym_filled)) then sym_filled=Self.sym_filled
if (arg_present(sym_fill_color)) then sym_fill_color=Self.sym_fill_color
if (arg_present(font_name)) then font_name=Self.font_name
if (arg_present(font_size)) then font_size=Self.font_size
if (arg_present(text_color)) then text_color=Self.text_color

if (arg_present(sf)) then sf = Self.sf 
if (arg_present(AACompFlag)) then AACompFlag=Self.AACompFlag
if (arg_present(QQ)) then QQ = Self.QQ
if (arg_present(mass)) then mass = Self.mass
if (arg_present(kc)) then kc = Self.kc
if (arg_present(n0)) then n0 = Self.n0
if (arg_present(Temp)) then Temp = Self.Temp
if (arg_present(alpha2)) then alpha2 = Self.alpha2
if (arg_present(alpha4)) then alpha4 = Self.alpha4
if (arg_present(alpha6)) then alpha6 = Self.alpha6
if (arg_present(abar3)) then abar3 = Self.abar3
if (arg_present(abar4)) then abar4 = Self.abar4
if (arg_present(abar52)) then abar52 = Self.abar52
if (arg_present(abar64)) then abar64 = Self.abar64
if (arg_present(u2)) then u2 = Self.u2
if (arg_present(u3)) then u3 = Self.u3
if (arg_present(u4)) then u4 = Self.u4
if (arg_present(u5)) then u5 = Self.u5
if (arg_present(u6)) then u6 = Self.u6
if (arg_present(smin)) then smin = Self.smin
if (arg_present(smax)) then smax = Self.smax
if (arg_present(sint)) then sint = Self.sint
if (arg_present(ymin)) then ymin = Self.ymin
if (arg_present(ymax)) then ymax = Self.ymax
if (arg_present(yint)) then yint = Self.yint
if (arg_present(kmin)) then kmin = Self.kmin
if (arg_present(kmax)) then kmax = Self.kmax
if (arg_present(kint)) then kint = Self.kint
if (arg_present(oPSet)) then oData = Self.oData
if (arg_present(overplotFlag)) then overplotFlag=Self.overplotFlag
if (arg_present(blank)) then blank=''


; Preferences structure
if (arg_present(preferences)) then begin
   if (ptr_valid(Self.prefsPtr)) then begin
      preferences = (*self.prefsPtr)

      ; update the preferences structure
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      for i=0,ntags-1 do begin
         status = Self->GetPropertyByIdentifier(tags[i], value)
         if (status) then preferences.(i) = strjoin(strtrim(string(value),2),',')
;         if (~status) then continue
;         if (strmatch(tags[i],'*color*',/fold_case)) then begin
;            ; for colors, first convert byte vector to a string eg [0,128,0] to '0,128,0'
;            preference.(i) = strjoin(value,',')
;         endif else $
;            preferences.(i) = value
      endfor
   endif
endif

; modifiedStatus
if (arg_present(modifiedStatus)) then modifiedStatus = self.modifiedFlag
; nameTag
if (arg_present(nameTag)) then nameTag = self.nameTag
; nameTag
if (arg_present(history)) then history = (*Self.historyPtr)
; prompt
if (arg_present(prompt)) then prompt = self.prompt
; prompt Title
if (arg_present(prmptTitle)) then prmptTitle = self.promptTitle
; prompt Desc
if (arg_present(prmptDesc)) then prmptDesc = self.promptDesc
;
if (arg_present(dataDir)) then dataDir = Self.dataDir
;
if (arg_present(funcFlag)) then funcFlag = Self.funcFlag
;
if (arg_present(xAxisVar)) then xAxisVar = Self.xAxisVar
;
if (arg_present(yAxisVar)) then yAxisVar = Self.yAxisVar
;
if (ARG_PRESENT(logFlag)) then logFlag = Self.logFlag
;;
;if (arg_present(constBinFlag)) then constBinFlag = Self.constBinFlag
;;
;if (arg_present(useTempAverageFlag)) then useTempAverageFlag = Self.useTempAverageFlag
;;
;if (arg_present(nSamp)) then nSamp = Self.nSamp
;;
;if (arg_present(nBkgd)) then nBkgd = Self.nBkgd
;;
;if (arg_present(nFast)) then nFast = Self.nFast
;;
;if (arg_present(sampSelected)) then sampSelected = Self.sampSelected
;;
;if (arg_present(bkgdSelected)) then bkgdSelected = Self.bkgdSelected
;;
;if (arg_present(fastSelected)) then fastSelected = Self.fastSelected
;;
;if (arg_present(sampContRef)) then sampContRef = Self.sampContRef
;;
;if (arg_present(bkgdContRef)) then bkgdContRef = Self.bkgdContRef
;;
;if (arg_present(fastContRef)) then fastContRef = Self.fastContRef
;;
;if (arg_present(nActiveDetectors)) then nActiveDetectors = Self.nActiveDetectors
;;
;if (arg_present(energyUnitFlag)) then energyUnitFlag = Self.energyUnitFlag
;;
;if (arg_present(maskedDets)) then maskedDets = Self.maskedDets
;;
;if (arg_present(fastparams)) then fastparams = Self.fastparams
;;
;if (arg_present(monScaleValue)) then monScaleValue = Self.monScaleValue
;;
;if (arg_present(monScaleFlag)) then monScaleFlag = Self.monScaleFlag
;;
;if (arg_present(sumSampFlag)) then sumSampFlag = Self.sumSampFlag
;;
;if (arg_present(sumBkgdFlag)) then sumBkgdFlag = Self.sumBkgdFlag
;;
;if (arg_present(maskFlag)) then maskFlag = Self.maskFlag
;;
;if (arg_present(bkgdFlag)) then bkgdFlag = Self.bkgdFlag
;;
;if (arg_present(bkgdSubVarFlag)) then bkgdSubVarFlag = Self.bkgdSubVarFlag
;;
;if (arg_present(bkgdSubVarTol)) then bkgdSubVarTol = Self.bkgdSubVarTol
;;
;if (arg_present(fastFlag)) then fastFlag = Self.fastFlag
;;
;if (arg_present(mev2wnos)) then mev2wnos = Self.mev2wnos
;;
;if (arg_present(oplotFastFitFlag)) then oplotFastFitFlag = Self.oplotFastFitFlag
;;
;if (arg_present(oplotBkgdFlag)) then oplotBkgdFlag = Self.oplotBkgdFlag
;;
;if (arg_present(ftpObject)) then ftpObject = Self.ftpObject
;;
;if (arg_present(latParamFlag)) then latParamFlag = Self.latParamFlag
;;
;if (arg_present(latticeParameters)) then latticeParameters = Self.latticeParameters
;;
;if (arg_present(detailedBalanceFlag)) then detailedBalanceFlag = Self.detailedBalanceFlag
;;
;if (arg_present(fastValue)) then fastValue = Self.fastValue
;;
;if (arg_present(resCorFlag)) then resCorFlag = Self.resCorFlag
;;
;if (arg_present(monCorFlag)) then monCorFlag = Self.monCorFlag
;;
;if (arg_present(normalizeTo)) then normalizeTo = Self.normalizeTo
;;
;if (arg_present(funcs)) then funcs = (*Self.funcs)
;;
;if (arg_present(qUnits)) then qUnits = Self.qUnits
;;
;if (arg_present(indepVar1List)) then indepVar1List = (*Self.indepVars1Ptr)
;;
;if (arg_present(indepVar12List)) then indepVar2List = (*Self.indepVars2Ptr)
;;
;if (arg_present(indepVar2List)) then indepVar2List = (*Self.indepVars2Ptr)
;;
;if (arg_present(indepVar3List)) then indepVar3List = (*Self.indepVars3Ptr)
;;
;if (arg_present(exportIndex1)) then exportIndex1 = (*Self.exportIndex1Ptr)
;;
;if (arg_present(exportIndex2)) then exportIndex2 = (*Self.exportIndex2Ptr)
;;
;if (arg_present(exportIndex3)) then exportIndex3 = (*Self.exportIndex3Ptr)
;;
;if (arg_present(calibParamsisSet)) then calibParamsisSet = Self.calibParamsisSet
;;
;if (ARG_PRESENT(multipleMsliceWinFlag)) then multipleMsliceWinFlag = Self.multipleMsliceWinFlag
;;
;if (arg_present(effNormFlag)) then effNormFlag = Self.effNormFlag
;;
;if (ARG_PRESENT(mergeChannelsFlag)) then mergeChannelsFlag = Self.mergeChannelsFlag
;;
;if (ARG_PRESENT(minBinWidth)) then minBinWidth = Self.minBinWidth
;;
;if (ARG_PRESENT(binWidths)) then binWidths = Self.binWidths
;;
;if (ARG_PRESENT(defaultIntensityFlag)) then defaultIntensityFlag = Self.defaultIntensityFlag
;;
;if (ARG_PRESENT(maxIntensity)) then maxIntensity = Self.maxIntensity
;;
;if (ARG_PRESENT(minIntensity)) then minIntensity = Self.minIntensity
;;
;if (ARG_PRESENT(phiOffset)) then phiOffset = Self.phiOffset
;;
;if (ARG_PRESENT(minChan)) then minChan = Self.minChan
;;
;if (ARG_PRESENT(maxChan)) then maxChan = Self.maxChan
;;
;if (ARG_PRESENT(minDPnt)) then minDPnt = Self.minDPnt
;;
;if (ARG_PRESENT(maxDPnt)) then maxDPnt = Self.maxDPnt
;;
;if (ARG_PRESENT(sharedSettingsFlag)) then sharedSettingsFlag = Self.sharedSettingsFlag
;;
;if (ARG_PRESENT(settingIndex)) then settingIndex = Self.settingIndex
;;
;if (ARG_PRESENT(dpntIndex)) then dpntIndex = Self.dpntIndex
;;
;if (arg_present(selectedIDs) || arg_present(nSelectedIDs) || arg_present(selectedNames)) then begin
;   oUI = Self->GetUI()
;   oUI->GetProperty, group_leader = wTLB
;   wChild = WIDGET_INFO(wTLB, /CHILD)
;   WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
;   ; retrieve list of all _selected_ datasets from the data manager
;   wDM = (*sPtr).wDM ; the data manager widget ID
;   widget_control, wDM, get_uvalue=sPtrDM ; the data manager state ptr
;   
;   oSampCont = Self.sampContRef
;   if (oSampCont->Count() eq 0) then begin
;      ; no data currently loaded
;      (*(*sPtrDM).pdataids) = ''
;      selectedIDs = ''
;      selectedNames = ''
;      nSelectedIDs = 0
;   endif else begin
;      selectedIDs = (*(*sPtrDM).pdataids)  ; currently selected identifiers
;      nSelectedIDs = n_elements(selectedIDs)
;      if (selectedIDs[0] eq '') then nSelectedIDs = 0
;      selectedNames = (nSelectedIDs eq 0)? '' :  strarr(nSelectedIDs)
;      for i=0,nSelectedIDs-1 do begin
;         (Self->GetByIdentifier(selectedIDs[i]))->GetProperty, name=name
;         selectedNames[i] = name
;      endfor
;   endelse
;endif
;
;if (arg_present(curMaxDataLen)) then begin
;   oSampCont = Self.sampContRef
;   curMaxDataLen = 1
;   if (obj_valid(oSampCont) && (oSampCont->Count() gt 0)) then begin
;      nSamp = oSampCont->Count()
;      for i = 0, nSamp-1 do begin
;         oI = oSampCont->Get(position=i)
;         status = oI->GetMetaData('NPTS',npts)
;         if (status) then curMaxDataLen = curMaxDataLen > npts
;      endfor
;   endif 
;
;endif

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::GetProperty, _EXTRA=etc

end


;-------------------------------------------------------------------------------
pro GenQFTool::SetProperty, sf=sf, QQ=QQ, mass=mass, kc=kc, n0=n0, Temp=Temp $
  ,alpha2=alpha2, alpha4=alpha4, alpha6=alpha6, abar3=abar3, abar4=abar4, abar52=abar52, abar64=abar64 $
  ,u2=u2, u3=u3, u4=u4, u5=u5, u6=u6, smin=smin, smax=smax, sint=sint, AACompFlag=AACompFlag $
  ,kmin=kmin, kmax=kmax, kint=kint, ymin=ymin, ymax=ymax, yint=yint,overplotFlag=overplotFlag,blank=blank $
  ,nameTag=nameTag, prompt=prompt,preferences=preferences, _EXTRA=etc $
  ,data_directory=dataDir, daveTool=daveTool, funcFlag=funcFlag,logFlag=logFlag,modifiedStatus=modifiedStatus $
  ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
 ,errorbar_capsize=errorbar_capsize $
 ,transparency=transparency $
 ,antialias=antialias $
 ,color=color $
 ,errorbar_color=errorbar_color $
 ,use_default_color=use_default_color $
 ,sym_increment=sym_increment $
 ,sym_index=sym_index $
 ,sym_size=sym_size $
 ,sym_color=sym_color $
 ,sym_thick=sym_thick $
 ,y_errorbars=y_errorbars $
 ,linestyle=linestyle $
 ,thick=thick $
 ,sym_filled=sym_filled $
 ,sym_fill_color=sym_fill_color $
 ,font_name=font_name  $
 ,font_size=font_size $
 ,text_color=text_color  
 ; ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag $
 ; ,maskedDets=maskedDets,monScaleValue=monScaleValue $
 ; ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag $
 ; ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag,effNormFlag=effNormFlag $
 ; ,fastFlag=fastFlag $
 ; ,bkgdSubVarFlag=bkgdSubVarFlag,bkgdSubVarTol=bkgdSubVarTol $
 ; ,constBinFlag=constBinFlag,useTempAverageFlag=useTempAverageFlag $
 ; ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
 ; ,sharedSettingsFlag=sharedSettingsFlag,settingIndex=settingIndex $
 ; ,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,fastparams=fastparams,phiOffset=phiOffset $
 ; ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
 ; ,oplotFastFitFlag=oplotFastFitFlag,oplotBkgdFlag=oplotBkgdFlag, typeCheck=typeCheck $
 ; ,minBinWidth=minBinWidth,binWidths=binWidths $
 ; ,exportIndex1=exportIndex1,exportIndex2=exportIndex2,exportIndex3=exportIndex3 $
 ; ,latParamFlag=latParamFlag, latticeParameters=latticeParameters $
 ; ,xAxisVar=xAxisVar,yAxisVar=yAxisVar,multipleMsliceWinFlag=multipleMsliceWinFlag $
 ; ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
 ; ,monCorFlag=monCorFlag, normalizeTo=normalizeTo,mergeChannelsFlag=mergeChannelsFlag $
 
compile_opt idl2

if n_elements(errorbar_capsize) then Self.errorbar_capsize=errorbar_capsize
if n_elements(transparency) then Self.transparency=transparency
if n_elements(antialias) then Self.antialias=antialias
if n_elements(color) then Self.color=color
if n_elements(errorbar_color) then Self.errorbar_color=errorbar_color
if n_elements(use_default_color) then Self.use_default_color=use_default_color 
if n_elements(sym_increment) then Self.sym_increment=sym_increment 
if n_elements(sym_index) then Self.sym_index=sym_index 
if n_elements(sym_size) then Self.sym_size=sym_size 
if n_elements(sym_color) then Self.sym_color=sym_color 
if n_elements(sym_thick) then Self.sym_thick=sym_thick 
if n_elements(y_errorbars) then Self.y_errorbars=y_errorbars
if n_elements(linestyle) then Self.linestyle=linestyle
if n_elements(thick) then Self.thick=thick
if n_elements(sym_filled) then Self.sym_filled=sym_filled
if n_elements(sym_fill_color) then Self.sym_fill_color=sym_fill_color
if n_elements(font_name) then Self.font_name=font_name
if n_elements(font_size) then Self.font_size=font_size
if n_elements(text_color) then Self.text_color=text_color

if (n_elements(sf)) then Self.sf = sf
if (n_elements(AACompFlag)) then Self.AACompFlag = AACompFlag
if (n_elements(QQ)) then Self.QQ = QQ
if (n_elements(mass)) then Self.mass = mass
if (n_elements(kc)) then Self.kc = kc
if (n_elements(n0)) then Self.n0 = n0
if (n_elements(Temp)) then Self.Temp = Temp
if (n_elements(alpha2)) then Self.alpha2 = alpha2
if (n_elements(alpha4)) then Self.alpha4 = alpha4
if (n_elements(alpha6)) then Self.alpha6 = alpha6
if (n_elements(abar3)) then Self.abar3 = abar3
if (n_elements(abar4)) then Self.abar4 = abar4
if (n_elements(abar52)) then Self.abar52 = abar52
if (n_elements(abar64)) then Self.abar64 = abar64
if (n_elements(u2)) then Self.u2 = u2
if (n_elements(u3)) then Self.u3 = u3
if (n_elements(u4)) then Self.u4 = u4
if (n_elements(u5)) then Self.u5 = u5
if (n_elements(u6)) then Self.u6 = u6
if (n_elements(smin)) then Self.smin = smin
if (n_elements(smax)) then Self.smax = smax
if (n_elements(sint)) then Self.sint = sint
if (n_elements(ymin)) then Self.ymin = ymin
if (n_elements(ymax)) then Self.ymax = ymax
if (n_elements(yint)) then Self.yint = yint
if (n_elements(kmin)) then Self.kmin = kmin
if (n_elements(kmax)) then Self.kmax = kmax
if (n_elements(kint)) then Self.kint = kint
if (n_elements(overplotFlag))  then Self.overplotFlag = overplotFlag
;
if (n_elements(dataDir)) then Self.dataDir = dataDir
;
if (n_elements(funcFlag)) then Self.funcFlag = funcFlag
;
if (n_elements(xAxisVar)) then Self.xAxisVar = xAxisVar
;
if (n_elements(yAxisVar)) then Self.yAxisVar = yAxisVar
;
if (N_ELEMENTS(maxIntensity) gt 0) then begin
  if (maxIntensity gt Self.minIntensity) then Self.maxIntensity = maxIntensity
endif
;
if (N_ELEMENTS(minIntensity) gt 0) then begin
  if (minIntensity lt Self.maxIntensity) then Self.minIntensity = minIntensity
endif
;
if (N_ELEMENTS(defaultIntensityFlag) gt 0) then Self.defaultIntensityFlag = defaultIntensityFlag
;
if (N_ELEMENTS(logFlag) gt 0) then Self.logFlag = logFlag

; DAVETool
if (n_elements(daveTool) && obj_valid(daveTool) && obj_isa(daveTool,'DAVETool')) then $
  Self.daveTool = daveTool

; Preferences
if (n_elements(preferences)) then begin
   if (strcmp(size(preferences,/tname),'STRUCT')) then begin
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      index = indgen(ntags)
      
      ; handle color tags - convert string to byte array, eg '0,128,255' to [0,128,255]
      spIndex = where(strmatch(tags,'*color*',/fold) eq 1, spCnt, complement=index, ncomplement=theRest)
      if (spCnt gt 0) then begin
         for i=0,spCnt-1 do begin
            strColor = preferences.(spIndex[i])
            bytColor = fix(strsplit(strColor,',',/extract))
            Self->SetPropertyByIdentifier, tags[spIndex[i]], bytColor
         endfor
      endif

      ; all other tags
      for i=0,theRest-1 do begin
         if (strcmp(tags[index[i]],'binWidths',/fold)) then begin
            ; another special case (binwidths) - convert string to 7 element float array
            strBW = preferences.(index[i])
            fltBW = float(strsplit(strBW,',',/extract))
            Self->SetPropertyByIdentifier, tags[index[i]], fltBW
         endif else $
            Self->SetPropertyByIdentifier, tags[index[i]], preferences.(index[i])
      endfor
      
      ; Need further to assign some userdef attribute for user-defined properties
      ; in order for property sheet to reflect updated value
      uProps = ['MASKEDDETS']
      n = n_elements(uProps)
      for i = 0,n-1 do begin
         index = where(strcmp(tags,uProps[i]), found)
         if (found) then $
            Self->SetPropertyAttribute, uProps[i],userdef=preferences.(index)
      endfor
      
      ; Finally, store the preferences structure
      if (ptr_valid(Self.prefsPtr)) then (*Self.prefsPtr) = preferences $
      else Self.prefsPtr = ptr_new(preferences)
   endif
   
   Self->UpdatePropertySheet
endif

; modifiedStatus
if (n_elements(modifiedStatus)) then Self.modifiedFlag = (fix(modifiedStatus) gt 0)? 1 : 0
; nameTag
if (n_elements(nameTag)) then Self.nameTag = strtrim(nameTag,2)
; prompt
if (n_elements(prompt)) then begin
   Self.prompt = prompt
   if (prompt eq 0) then Self._bDirty = 0
endif

;;
;if (n_elements(constBinFlag)) then Self.constBinFlag = constBinFlag
;;
;if (n_elements(useTempAverageFlag)) then Self.useTempAverageFlag = useTempAverageFlag
;;
;if (n_elements(nActiveDetectors)) then Self.nActiveDetectors = nActiveDetectors
;;
;if (n_elements(energyUnitFlag)) then Self.energyUnitFlag = energyUnitFlag
;;
;if (n_elements(maskedDets)) then Self.maskedDets = maskedDets
;;
;if (n_elements(fastparams)) then Self.fastparams = fastparams
;;
;if (n_elements(monScaleValue)) then Self.monScaleValue = (monScaleValue eq 0.0)? 1.0 : monScaleValue
;;
;if (n_elements(monScaleFlag)) then Self.monScaleFlag = monScaleFlag
;;
;if (n_elements(sumSampFlag)) then Self.sumSampFlag = sumSampFlag
;;
;if (n_elements(sumBkgdFlag)) then Self.sumBkgdFlag = sumBkgdFlag
;;
;if (n_elements(maskFlag)) then Self.maskFlag = maskFlag
;;
;if (n_elements(bkgdFlag)) then Self.bkgdFlag = bkgdFlag
;;
;if (n_elements(bkgdSubVarFlag)) then Self.bkgdSubVarFlag = bkgdSubVarFlag
;;
;if (n_elements(bkgdSubVarTol)) then Self.bkgdSubVarTol = bkgdSubVarTol
;;
;if (n_elements(fastFlag)) then Self.fastFlag = fastFlag
;;
;if (n_elements(nSamp)) then Self.nSamp = nSamp
;;
;if (n_elements(nBkgd)) then Self.nBkgd = nBkgd
;;
;if (n_elements(nFast)) then Self.nFast = nFast
;;
;if (n_elements(sampSelected)) then Self.sampSelected = sampSelected
;;
;if (n_elements(bkgdSelected)) then Self.bkgdSelected = bkgdSelected
;;
;if (n_elements(fastSelected)) then Self.fastSelected = fastSelected
;;
;if (n_elements(oplotFastFitFlag)) then Self.oplotFastFitFlag = oplotFastFitFlag
;;
;if (n_elements(oplotBkgdFlag)) then Self.oplotBkgdFlag = oplotBkgdFlag
;;
;if (n_elements(latParamFlag)) then  Self.latParamFlag = latParamFlag
;;
;if (n_elements(latticeParameters)) then  Self.latticeParameters = latticeParameters
;;
;if (n_elements(detailedBalanceFlag)) then Self.detailedBalanceFlag = detailedBalanceFlag
;;
;if (n_elements(fastValue)) then Self.fastValue = fastValue
;;
;if (n_elements(resCorFlag)) then Self.resCorFlag = resCorFlag
;;
;if (n_elements(monCorFlag)) then Self.monCorFlag = monCorFlag
;;
;if (n_elements(normalizeTo)) then Self.normalizeTo = normalizeTo
;;
;if (n_elements(minbinWidth)) then Self.minbinWidth = minbinWidth
;;
;if (n_elements(binWidths)) then Self.binWidths = binWidths
;;
;if (n_elements(minChan)) then Self.minChan = minChan > 1
;;
;if (n_elements(maxChan)) then Self.maxChan = maxChan
;;
;if (n_elements(minDPnt)) then Self.minDPnt = minDPnt > 1
;;
;if (n_elements(maxDPnt)) then Self.maxDPnt = maxDPnt
;;
;if (n_elements(dpntIndex)) then Self.dpntIndex = dpntIndex > 1
;;
;if (n_elements(sharedSettingsFlag)) then Self.sharedSettingsFlag = sharedSettingsFlag
;;
;if (n_elements(settingIndex)) then Self.settingIndex = settingIndex
;;
;if (n_elements(exportIndex1) gt 0) then (*Self.exportIndex1Ptr) = exportIndex1
;;
;if (n_elements(exportIndex2) gt 0) then (*Self.exportIndex2Ptr) = exportIndex2
;;
;if (n_elements(exportIndex3) gt 0) then (*Self.exportIndex3Ptr) = exportIndex3
;;
;if (n_elements(effNormFlag) gt 0) then Self.effNormFlag = effNormFlag 
;;
;if (N_ELEMENTS(multipleMsliceWinFlag) gt 0) then Self.multipleMsliceWinFlag = multipleMsliceWinFlag
;;
;if (N_ELEMENTS(mergeChannelsFlag) gt 0) then Self.mergeChannelsFlag = mergeChannelsFlag

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::SetProperty, _EXTRA=etc

end


;;===============================================================================
;; GenQFTool::loadSamp
;;
;; PURPOSE:
;;   Specify and load sample data file(s)
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;
;function GenQFTool::GetFileList, title, count, fromFTP=fromFTP, filter=filter $
;                                ,multiple_files=multiple_files, path=path, newPath=newPath
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;
;if (keyword_set(fromFTP)) then begin
;  Self->GetProperty, ftpObject=oFTP
;  if (n_elements(filter) eq 0) then filter = ['*.bt7','*.*']
;  files = Dialog_NCNRpublicData(oFTP,title=title,filter=filter,group_leader=wTLB,count=count)
;endif else begin
;  if (n_elements(filter) eq 0) then filter = '*.bt7'
;  if (n_elements(multiple_files) eq 0) then multiple_files=1
;  if (n_elements(path) eq 0) then Self->GetProperty, data_directory=path
;  if (n_elements(title) eq 0) then title='Specify files to load'
;  
;  files = dialog_pickfile(title=title,multiple_files=multiple_files,/must_exist, dialog_parent=wTLB $
;                         ,filter=filter,path=path, get_path=newPath)
;  
;  if (files[0] eq '') then begin
;     count = 0
;     return, ''
;  endif
;  
;  count = n_elements(files)
;  ;Self->SetProperty, data_directory=newPath
;endelse
;
;return, files
;
;end
;-------------------------------------------------------------------------------



;===============================================================================
; GenQFTool::refreshPropertySheet
;
; PURPOSE:
;   Refresh the propertysheet UI
;
; PARAMETERS:
;
; KEYWORDS:
;
pro GenQFTool::RefreshPropertySheet

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

widget_control, (*sPtr).wPS, /refresh_property

end
;-------------------------------------------------------------------------------


;===============================================================================
; GenQFTool::UpdateCalculation
;
; PURPOSE:
;   Update the PSD wavevector and energy transfer for the dataset
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;
function GenQFTool::AA, sf=sf, QQ=QQ, alpha2=alpha2, alpha4=alpha4, abar3=abar3, abar52=abar52 $
                 , ymin=ymin, ymax=ymax, yint=yint, AACompFlag=AACompFlag, _Extra=etc
compile_opt idl2

if (~isa(sf) || ~isa(QQ) || ~isa(alpha2) || ~isa(alpha4) || ~isa(abar3) || ~isa(abar52) || $
  ~isa(AACompFlag) || ~isa(ymin) || ~isa(ymax) || ~isa(yint)) then return, 0

u2 = alpha2
u3 = abar3/QQ
u4 = alpha4
u5 = abar52/QQ^3

y = ymin + findgen((ymax - ymin)/yint + 1)*yint

wd = y/sqrt(u2)
Jia= 1/sqrt(2*!pi*u2)*exp(-y^2/(2*u2))
J1 = -u3*wd/(2*u2^1.5)*(1 - (wd^2.0)/3)*Jia
J2 = u4/(8*u2^2)*(1 - 2*wd^2 + (wd^4.0)/3)*Jia
J3 = u5*wd/(8*u2^2.5)*(1 - 2/3*wd^2 + (wd^4.0)/15)*Jia

case AACompFlag of
  0: begin
    calc = Jia + J1 + J2 + J3
    name = "All Components"
  end
  1: begin
    calc = Jia  
    name = 'Gaussian Comp."
  end
  2: begin
    calc = J1
    name = '1st FS Correction.'
  end
  3: begin
    calc = J2
    name = 'Gaussian Correction.'
  end
  4: begin
    calc = J3
    name = '2nd FS Correction'
  end
  else: calc = Jia + J1 + J2 + J3
endcase
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='aa', name='AA '+ name

oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(y,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$y$'
oX->AddMetaData,'Units','$\AA^{-1}$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$J(Q,y)$'
oY->AddMetaData,'Units','$\AA$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1
end


;===============================================================================
function GenQFTool::Jqy1, sf=sf, u2=u2, u3=u3, u4=u4, u5=u5, u6=u6 $
                   , ymin=ymin, ymax=ymax, yint=yint, _Extra=etc
compile_opt idl2

if (~Isa(sf) || ~Isa(u2) || ~Isa(u3) || ~Isa(u4) || $
  ~Isa(u5) || ~Isa(u6) || $
  ~Isa(ymin) || ~Isa(ymax) || ~Isa(yint)) then Return, 0

SQ = 1.0
muPtr = Ptr_new({u2:u2,     $         ; [(1/A)**2]
                 u3:u3,     $         ; [(1/A)**3]
                 u4:u4,     $         ; [(1/A)**4]
                 u5:u5,     $         ; [(1/A)**5]
                 u6:u6})              ; [(1/A)**6]
y = ymin + findgen((ymax - ymin)/yint + 1)*yint
etc = Create_struct('y',y[0],'muPtr',muPtr)
n = N_elements(y)
amp = sf*SQ/!pi
if (n eq 1) then begin
  calc = amp * Qpint1d('CAJqys',0.0D,!values.d_infinity,functargs=etc,status=status,nfev=nfev)
endif else begin
  calc = Dblarr(n)
  for i=0,n-1 do begin
    etc.y = y[i]
    calc[i] = amp * Qpint1d('CAJqys',0.0D,!values.d_infinity,functargs=etc,status=status,nfev=nfev)
  endfor
endelse

error = 0.01*Max(calc) + Fltarr(N_elements(calc))

oPSet = Self.oPSet
oPSet->Setproperty, description='jqy1', name='$J(Q,y)$'
oX = oPSet->Getbyname('X',count=count)
if (count ne 1) then Return, 0
oY = oPSet->Getbyname('Y',count=count)
if (count ne 1) then Return, 0
oE = oPSet->Getbyname('Error',count=count)
if (count ne 1) then Return, 0

status = oX->SetData(y,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$y$'
oX->AddMetaData,'Units','$\AA^{-1}$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$J(Q,y)$'
oY->AddMetaData,'Units','$\AA$'
status = oE->SetData(error,/no_copy,/no_notify)

Return, 1

return, 0
end


;===============================================================================
function Genqftool::Jqs1, sf=sf, u2=u2, u3=u3, u4=u4, u5=u5, u6=u6 $
  , smin=smin, smax=smax, sint=sint, _Extra=etc
compile_opt idl2

if (~Isa(sf) || ~Isa(u2) || ~Isa(u3) || ~Isa(u4) || $
  ~Isa(u5) || ~Isa(u6) || $
  ~Isa(smin) || ~Isa(smax) || ~Isa(sint)) then Return, 0


muPtr = Ptr_new({u2:u2,     $         ; [(1/A)**2]
                 u3:u3,     $         ; [(1/A)**3]
                 u4:u4,     $         ; [(1/A)**4]
                 u5:u5,     $         ; [(1/A)**5]
                 u6:u6})              ; [(1/A)**6]
s = smin + findgen((smax - smin)/sint + 1)*sint
y = 0.0
calc = sf * CAJqys(s, y=y, muPtr=muPtr)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->Setproperty, description='jqs1', name='$J(Q,s)$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(s,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$s$'
oX->AddMetaData,'Units','$\AA$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$J(Q,s)$'
oY->AddMetaData,'Units','$\AA^{-1}$'
status = oE->SetData(error,/no_copy,/no_notify)

Return, 1
end


;===============================================================================
function Genqftool::Jqs2, sf=sf, QQ=QQ, kc=kc, mass=mass, Temp=T, n0=n0, alpha2=alpha2 $
                        , alpha4=alpha4, alpha6=alpha6, abar3=abar3, abar52=abar52, abar64=abar64 $
                        , smin=smin, smax=smax, sint=sint, _Extra=etc
compile_opt idl2

if (~Isa(sf) || ~Isa(QQ) || ~Isa(kc) || ~Isa(mass) || ~Isa(T) || ~Isa(n0) || $
  ~Isa(alpha2) || ~Isa(alpha4) || ~Isa(alpha6) || $
  ~Isa(abar3) || ~Isa(abar52) || ~Isa(abar64) || $
  ~Isa(smin) || ~Isa(smax) || ~Isa(sint)) then Return, 0

avalues = [alpha2,alpha4,alpha6]
bvalues = [abar3,abar52,abar64]
s = smin + findgen((smax - smin)/sint + 1)*sint

calc = sf * Gen_ns(s, aValues=aValues, bvalues=bvalues, T=T, kc=kc, n0=n0, mass=mass, uncondensedOnlyFlag=0)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='Jqs', name='$J(Q,s)$ incl. n(s) model'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(s,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$s$'
oX->AddMetaData,'Units','$\AA$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$J(Q,s)$'
oY->AddMetaData,'Units','$\AA^{-1}$'
status = oE->SetData(error,/no_copy,/no_notify)

Return, 1
end


;===============================================================================
function GenQFTool::Jqy2, sf=sf, QQ=QQ, kc=kc, mass=mass, Temp=T, n0=n0, alpha2=alpha2 $
                   , alpha4=alpha4, alpha6=alpha6, abar3=abar3, abar52=abar52, abar64=abar64 $
                   , ymin=ymin, ymax=ymax, yint=yint, calc=calc, _Extra=etc
compile_opt idl2

if (~isa(sf) || ~isa(QQ) || ~isa(kc) || ~isa(mass) || ~isa(T) || ~isa(n0) || $
    ~isa(alpha2) || ~isa(alpha4) || ~isa(alpha6) || $
    ~isa(abar3) || ~isa(abar52) || ~isa(abar64) || $
    ~isa(ymin) || ~isa(ymax) || ~isa(yint)) then return, 0

avalues = [alpha2,alpha4,alpha6]
bvalues = [abar3,abar52,abar64]
y = ymin + findgen((ymax - ymin)/yint + 1)*yint
calc = sf * Gen_jqy(y,aValues=aValues,bValues=bValues,T=T,kc=kc,n0=n0,Q=QQ,mass=mass)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='jqy2', name='$J(Q,y) incl. n(k) model$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(y,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$y$'
oX->AddMetaData,'Units','$\AA^{-1}$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$J(Q,y)$'
oY->AddMetaData,'Units','$\AA$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1
end


;===============================================================================
function GenQFTool::Rqs, sf=sf, QQ=QQ, abar3=abar3, abar52=abar52, abar64=abar64 $
                  , smin=smin, smax=smax, sint=sint, _Extra=etc  
compile_opt idl2

if (~isa(sf) || ~isa(QQ) || ~isa(abar3) || ~isa(abar52) || ~isa(abar64) || $
  ~isa(smin) || ~isa(smax) || ~isa(sint)) then return, 0

bvalues = [abar3,abar52,abar64]
s = smin + findgen((smax - smin)/sint + 1)*sint
calc = sf * Gen_rqs(s, QQ, bValues)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='rqs', name='$R(Q,s)$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(s,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$s$'
oX->AddMetaData,'Units','$\AA$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$R(Q,s)$'
oY->AddMetaData,'Units','$\AA^{-1}$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1
end


;===============================================================================
function GenQFTool::Rqy, sf=sf, QQ=QQ, abar3=abar3, abar52=abar52, abar64=abar64 $
                  , ymin=ymin, ymax=ymax, yint=yint, _Extra=etc
compile_opt idl2

if (~isa(sf) || ~isa(QQ) || ~isa(abar3) || ~isa(abar52) || ~isa(abar64) || $
    ~isa(ymin) || ~isa(ymax) || ~isa(yint)) then return, 0

bvalues = [abar3,abar52,abar64]
y = ymin + findgen((ymax - ymin)/yint + 1)*yint
calc = sf * Gen_rqy(y, QQ, bValues)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='rqy', name='$R(Q,y)$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(y,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$y$'
oX->AddMetaData,'Units','$\AA^{-1}$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$R(Q,y)$'
oY->AddMetaData,'Units','$\AA$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1
end


;===============================================================================
function GenQFTool::Fs, sf=sf, kc=kc, mass=mass, Temp=T, smin=smin, smax=smax, sint=sint, _Extra=etc
compile_opt idl2
if (~isa(sf) || ~isa(kc) || ~isa(mass) || ~isa(T) || ~isa(smin) || ~isa(smax) || ~isa(sint)) then return, 0

s = smin + findgen((smax - smin)/sint + 1)*sint

if (n_elements(B) eq 0 || n_elements(D) eq 0 || n_elements(F) eq 0) then begin
  if (~isa(mass)) then mass = 4.0026           ; rel a. mass of He4
  hbar = 1.0545919        ; *10**(-34) Js
  ec   = 1.6021917        ; *10**(-19) C
  amu  = 1.660531         ; *10**(-27) Kg
  kB   = 1.380622         ; *10**(-23) J/K
  rho  = 0.6022169/27.0   ; 1/A**3         He4 at SVP
  Vs   = 240              ; m/s            He4 at SVP
  B = mass*amu*Vs/(2.0*hbar*(2.0*!pi)^3*rho)/1000.0  ; A**2
  D = hbar*Vs/(2.0*kb*T)/10.0                    ; A
  F = 2.0*kc^2                                     ; (1/A)**2
endif

calc = sf * Fofs(s, nOrder = 1, kc=kc, T=T, B=B, D=D, F=F)  ; 1st moment of fofs i.e. when nOrder=1
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='fofs', name='$f(s)$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(s,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$s$'
oX->AddMetaData,'Units','$\AA$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$f(s)$'
oY->AddMetaData,'Units','$\AA^{-1}$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1

end


;===============================================================================
function GenQFTool::Nstars, sf=sf, kc=kc, mass=mass, Temp=T, n0=n0, alpha2=alpha2, alpha4=alpha4 $
                 ,alpha6=alpha6, smin=smin, smax=smax, sint=sint, _Extra=etc
compile_opt idl2

if (~isa(sf) || ~isa(kc) || ~isa(mass) || ~isa(T) || ~isa(n0) || ~isa(alpha2) || ~isa(alpha4) || $
  ~isa(alpha6) || ~isa(smin) || ~isa(smax) || ~isa(sint)) then return, 0

s = smin + findgen((smax - smin)/sint + 1)*sint
avalues = [alpha2,alpha4,alpha6]
calc = sf * Gen_ns(s, aValues=aValues, T=T, kc=kc, n0=n0, mass=mass, uncondensedOnlyFlag=1)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='nstars', name='$n*(s)$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(s,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$s$'
oX->AddMetaData,'Units','$\AA$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$n*(s)$'
oY->AddMetaData,'Units','$\AA^{-1}$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1
end


;===============================================================================
function GenQFTool::Ns, sf=sf, kc=kc, mass=mass, Temp=T, n0=n0, alpha2=alpha2, alpha4=alpha4 $
  ,alpha6=alpha6, smin=smin, smax=smax, sint=sint, _Extra=etc
compile_opt idl2

if (~isa(sf) || ~isa(kc) || ~isa(mass) || ~isa(T) || ~isa(n0) || ~isa(alpha2) || ~isa(alpha4) || $
  ~isa(alpha6) || ~isa(smin) || ~isa(smax) || ~isa(sint)) then return, 0

s = smin + findgen((smax - smin)/sint + 1)*sint
avalues = [alpha2,alpha4,alpha6]
calc = sf * Gen_ns(s, aValues=aValues, T=T, kc=kc, n0=n0, mass=mass, uncondensedOnlyFlag=0)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='ns', name='$n(s)$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(s,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$s$'
oX->AddMetaData,'Units','$\AA$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$n(s)$'
oY->AddMetaData,'Units','$\AA^{-1}$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1

end


;===============================================================================
function GenQFTool::Nstark, sf=sf, kc=kc, mass=mass, Temp=T, n0=n0, alpha2=alpha2, alpha4=alpha4 $
                 ,alpha6=alpha6, kmin=kmin, kmax=kmax, kint=kint, calc=calc, _Extra=etc
compile_opt idl2

if (~isa(sf) || ~isa(kc) || ~isa(mass) || ~isa(T) || ~isa(n0) || ~isa(alpha2) || ~isa(alpha4) || $
    ~isa(alpha6) || ~isa(kmin) || ~isa(kmax) || ~isa(kint)) then return, 0

k = kmin + findgen((kmax - kmin)/kint + 1)*kint
avalues = [alpha2,alpha4,alpha6]
calc = sf * Gen_nk(k, aValues=aValues, T=T, kc=kc, n0=n0, mass=mass)
error = 0.01*max(calc) + fltarr(n_elements(calc))

oPSet = Self.oPSet
oPSet->SetProperty, description='nstark', name='$n*(k)$'
oX = oPSet->GetByName('X',count=count)
if (count ne 1) then return, 0
oY = oPSet->GetByName('Y',count=count)
if (count ne 1) then return, 0
oE = oPSet->GetByName('Error',count=count)
if (count ne 1) then return, 0

status = oX->SetData(k,/no_copy,/no_notify)
oX->AddMetaData,'Long_name','$k$'
oX->AddMetaData,'Units','$\AA^{-1}$'
status = oY->SetData(calc,/no_copy,/no_notify)
oY->AddMetaData,'Long_name','$n(k)$'
oY->AddMetaData,'Units','$\AA^{3}$'
status = oE->SetData(error,/no_copy,/no_notify)

return, 1
end


;===============================================================================
; GenQFTool::UpdateCalculation
;
; PURPOSE:
;   Update the PSD wavevector and energy transfer for the dataset
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;
function GenQFTool::UpdateCalculation, oPSet
compile_opt idl2

Self->GetProperty, funcFlag=funcFlag
funcNames = Self.funcNames->ToArray()
funcName = funcNames[funcFlag]
funcParams = Self.funcParams
params = funcParams[funcName]
np = n_elements(params)
etc = []
for i = 0, np-1 do begin
  if (~Self->GetPropertyByIdentifier(params[i],value)) then continue
  print,params[i] + ' = ', string(value)
  etc = create_struct(etc,params[i],value)
endfor

; Evaluate the function using the appropriate method call
return, call_method( funcName, Self, calc=calc, _EXTRA=etc)

end
;-------------------------------------------------------------------------------



;;===============================================================================
;; GenQFTool::UpdateIntensityScale
;;+
;; PURPOSE:
;;   Update the intensity scale - switch between linear/logbase10 scales
;;
;; PARAMETERS:
;;   
;;
;; KEYWORDS:
;;-
;pro GenQFTool::UpdateIntensityScale
;compile_opt idl2
;
;Self->GetProperty, logFlag=logFlag, sampContRef=oCont, minIntensity=minval, maxIntensity=maxval
;
;; must be single crystal sample
;if (Self.funcFlag ne 1) then return
;
;nData = oCont->Count()
;if (nData eq 0) then return
; 
;oData = oCont->Get(/all)
;
;case logFlag of
;   0: begin ; switch to linear scale
;      minVal = 10.0^(minVal)  ; update max and min intensity to the same scale as the intensity
;      maxVal = 10.0^(maxVal)
;      for i = 0,nData-1 do begin
;         oZ = oData[i]->GetByName('Counts')
;         if (~obj_valid(oZ)) then continue
;         if (~oZ->GetMetaData('LinearCounts',counts)) then continue
;         status = oZ->SetData(counts,/no_copy);,/no_notify)      
;      endfor
;   end
;   
;   1: begin ; switch to log scale
;       minVal = (minVal gt 0.0)? alog10(minVal) : 0.0 ; update max and min intensity to the same scale as the intensity
;       maxVal = (maxVal gt 0.0)? alog10(maxVal) : 0.0 
;       for i = 0,nData-1 do begin
;         oZ = oData[i]->GetByName('Counts')
;         if (~obj_valid(oZ)) then continue
;         if (~oZ->GetMetaData('LinearCounts',counts)) then begin
;            ; probably data from an older session so create the metadata
;            status = oZ->Getdata(counts)
;            oZ->AddMetaData, 'linearCounts',counts
;         endif
;
;         index = where(counts le 0.0, nBad)
;         if (nBad gt 0) then counts[index] = !values.F_NAN
;         counts = alog10(temporary(counts))
;         status = oZ->SetData(counts,/no_copy);,/no_notify)      
;      endfor
;   
;   end
;   
;   else:
;endcase
;Self->SetProperty, minIntensity=minVal, maxIntensity=maxVal
;
;; Update the intensity range
;Self->UpdatePlotIntensityRange
;
;end
;-------------------------------------------------------------------------------


;;===============================================================================
;; GenQFTool::UpdatePlotIntensityRange
;;+
;; PURPOSE:
;;   Update the max and min intensity of the existing plot
;;
;; PARAMETERS:
;;   
;;
;; KEYWORDS:
;;-
;pro GenQFTool::UpdatePlotIntensityRange, oVis
;compile_opt idl2
;
;Self->GetProperty, defaultIntensityFlag=defIntFlag, funcFlag=funcFlag, maxIntensity=maxVal, minIntensity=minVal
;
;; must be single crystal sample
;if (Self.funcFlag ne 1) then return
;
;if (Self.defaultIntensityFlag eq 1) then begin  ;using default intensity range
;   Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel
;   if (nSel eq 0) then return   ; exit if no dataset is currently selected
;   ; Retrieve intensity of selected data
;   intensity = []
;   for i=0,nSel - 1 do begin
;      oTest = Self->GetByIdentifier(selIDs[i])
;      if (~isa(oTest,'IDLitParameterSet')) then continue
;      status = oTest->GetMetaData('funcFlag',sTypeFlag) ; only consider single crystal data to Mslice
;      if (sTypeFlag ne 1) then continue
;      oZ = oTest->GetByName('Counts')
;      status = oZ->GetData(counts)
;      intensity = [intensity,reform(counts,n_elements(counts))]
;   endfor
;   if (~isa(intensity)) then return
;   maxVal = max(intensity,min=minVal,/NAN)
;endif else begin
;   maxVal = Self.maxIntensity
;   minVal = Self.minIntensity
;endelse
;
;if (maxVal eq minVal) then return
;
;if (maxVal lt minVal) then begin
;   tempVal = maxVal
;   maxVal = minVal
;   minVal = tempVal
;endif
;
;if (obj_valid(oVis) && isa(oVis,'IDLitVisualization')) then begin
;   oVis->SetProperty, min_value=minVal, max_value=maxVal
;endif else begin
;   if (Self->HasVisualizations()) then begin
;      oWin = Self->GetCurrentWindow()
;      oView = oWin->GetCurrentView()
;      oLayer = oView->GetCurrentLayer()
;      oWorld = oLayer->GetWorld()
;      oDataSpace = oWorld->GetDataSpaces()
;      oVis = oDataSpace->GetVisualizations(count = nVis)
;   
;      for i=0, nVis-1 do oVis[i]->SetProperty, min_value=minVal, max_value=maxVal
;   endif
;endelse
;end
;-------------------------------------------------------------------------------


;;===============================================================================
;; GenQFTool::Mslice
;;+
;; PURPOSE:
;;   Launch Mslice tool with a copy of the currently selected data for further analysis. 
;;   If Mslice is already launched, update its data with the currently selected data.
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;-
;function GenQFTool::Mslice
;compile_opt idl2
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        if (widget_info(wB,/valid)) then widget_control, wB, /destroy
;        Self->StatusMessage, !ERROR_STATE.msg
;        catch, /cancel
;        return, 0
;    endif
;endif
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;
;; display dialog to let user select variables to be exported to Mslice 
;Self->GetProperty, daveTool=daveTool $
;                 , exportIndex1=exportIndex1, exportIndex2=exportIndex2, exportIndex3=exportIndex3  $
;                 ,indepVar1List=indepVar1List,indepVar2List=indepVar2List,indepVar3List=indepVar3List $
;                 ,selectedIDs=selIDs,nSelectedIDs=nSel, funcFlag=funcFlag
;if (nSel eq 0) then return, 0  ; exit if no dataset is currently selected
;
;case funcFlag of
;  0: begin 
;    exportList = indepVar2List
;    exportIndex = exportIndex2 
;  end; powder
;  1: begin 
;    exportList = indepVar1List 
;    exportIndex = exportIndex1
;  end; single crystal
;  2: begin 
;    exportList = indepVar3List 
;    exportIndex = exportIndex3
;  end; raw
;endcase
;
;; construct basic dialog
;title = 'Select Variables to Export'
;wB = widget_base(/col,title=title,/modal,group_leader=wTLB)
;wB1 = widget_base(wB,/col,grid=2,/frame,/nonexclusive,scr_xsize=200)
;wB2 = widget_base(wB,/row,/frame)
;
;n = n_elements(exportList)
;wButtons = lindgen(n)
;for i=0,n-1 do begin
;   wButtons[i] = widget_button(wB1,value=exportList[i],uname=exportList[i])
;   widget_control, wButtons[i], set_button=exportIndex[i]
;endfor
;wOK = widget_button(wB2,value='OK',uname='APPLY',/align_center)
;wCancel = widget_button(wB2,value='Cancel',uname='CANCEL',/align_center)
;
;statePtr = ptr_new({wButtons:wButtons,exportIndex:exportIndex,cancel:0})
;widget_control, wB, /realize, set_uvalue=statePtr
;
;xmanager, 'GenQFExport2Mslice', wB, event_handler='GenQFExport2Mslice_event'
;
;exportIndex = (*statePtr).exportIndex
;cancel = (*statePtr).cancel
;ptr_free, statePtr
;
;if (cancel) then return, 0
;
;if (funcFlag eq 0) then Self->SetProperty, exportIndex2=exportIndex
;if (funcFlag eq 1) then Self->SetProperty, exportIndex1=exportIndex
;if (funcFlag eq 2) then Self->SetProperty, exportIndex3=exportIndex
;
;index = where(exportIndex eq 1,nVar)
;if (nVar lt 2) then return, 0
;
;exportList = exportList[index]
;
;; Init Counts and Error
;z = []
;Err = []
;label = ['Intensity','Error']
;unit = ['','']
;unique = [0,0]
;
;oData = []
;
;case funcFlag of
;  0: begin
;    for i=0,nSel - 1 do begin
;      oTest = Self->GetByIdentifier(selIDs[i])
;      if (~isa(oTest,'IDLitParameterSet')) then continue
;      status = oTest->GetMetaData('funcFlag',sTypeFlag) ; must be powder data
;      if (sTypeFlag ne 0) then continue
;      oZ = oTest->GetByName('Counts')
;      status = oZ->GetMetaData('ProcessedCounts',counts)
;      status = oZ->GetMetaData('ProcessedErrors',error)
;      Z = [Z,reform(counts,n_elements(counts))]
;      Err = [Err,reform(error,n_elements(error))]
;      oData = [oData,oTest]
;    endfor
;    nSel = n_elements(oData)
;    npts = n_elements(Z)
;    if (npts eq 0) then return, 0
;    data = fltarr(npts,2+nVar)
;    data[*,0] = Z
;    data[*,1] = Err
;    binWidths = fltarr(2) + 0.1
;    ; Get the independent vars
;    for i=0,nVar-1 do begin
;      varName = exportList[i]
;      varData = []
;      for j=0,nSel-1 do begin
;        oVar = oData[j]->GetByName(varName)
;        if (~obj_valid(oVar)) then continue
;        if (j eq 0) then begin
;          status = oVar->GetMetaData('Long_name',varLab)
;          status = oVar->GetMetaData('Units',varUnit)
;          label = [label,varLab]
;          unit = [unit,varUnit]
;          unique = strcmp(varName,'E',/fold_case)? [unique,1] : [unique,0]
;          ;unique = [unique,1]
;        endif
;        oZ = oData[j]->GetByName('Counts')
;        metaName = (strcmp(varName,'|Q|'))? 'QTOT' : varName
;        if (strcmp(varName,'TEMP',/fold)) then begin
;          ; need to treat it specially
;          Self->GetProperty, useTempAverageFlag=useTempAverageFlag
;          metaName = (useTempAverageFlag)? 'TEMPAVERAGE' : 'TEMP'
;        endif
;        status = oZ->GetMetaData(metaName,iVarData) ; Get 2D variable values that have not been rebinned!
;        npts = n_elements(iVarData)
;        iVarData = reform(TEMPORARY(iVarData),npts)
;        varData = [vardata,iVarData]
;        if (i eq 0 || i eq 1) then begin
;          iVarData = ivardata[uniq(ivardata, sort(ivardata))] ; return a copy of the sorted array with duplicate adjacent elements removed
;          npts = n_elements(iVarData)
;          binWidths[i] = (npts gt 1)? $
;            max(abs(iVarData[1:npts-1] - iVarData[0:npts-2])) : $ ; use the max bin width
;            1.0
;          if (binWidths[i] lt 0.1) then binWidths[i] = 1.15*binWidths[i]
;        endif
;      endfor
;      data[*,i+2] = varData
;    endfor
;
;  end 
;
;  1: begin
;    for i=0,nSel - 1 do begin
;      oTest = Self->GetByIdentifier(selIDs[i])
;      if (~isa(oTest,'IDLitParameterSet')) then continue
;      status = oTest->GetMetaData('funcFlag',sTypeFlag) ; only export single crystal data to Mslice
;      if (sTypeFlag ne 1) then continue
;      oZ = oTest->GetByName('Counts')
;      if (~oZ->GetMetaData('LinearCounts',counts)) then status = oZ->GetData(counts)
;      Z = [Z,reform(counts,n_elements(counts))]
;      oErr = oTest->GetByName('Error')
;      status = oErr->GetData(error)
;      Err = [Err,reform(error,n_elements(error))]
;      oData = [oData,oTest]
;    endfor
;    nSel = n_elements(oData)
;    npts = n_elements(Z)
;    if (npts eq 0) then return, 0
;    data = fltarr(npts,2+nVar)
;    data[*,0] = Z
;    data[*,1] = Err
;    binWidths = fltarr(2) + 0.1
;    ; Get the independent vars
;    for i=0,nVar-1 do begin
;      varName = exportList[i]
;      varData = []
;      for j=0,nSel-1 do begin
;        oVar = oData[j]->GetByName(varName)
;        if (~obj_valid(oVar)) then continue
;        if (j eq 0) then begin
;          status = oVar->GetMetaData('Long_name',varLab)
;          status = oVar->GetMetaData('Units',varUnit)
;          label = [label,varLab]
;          unit = [unit,varUnit]
;          unique = strcmp(varName,'E',/fold_case)? [unique,1] : [unique,0]
;          ;unique = [unique,1]
;        endif
;        status = oVar->GetData(iVarData)
;        npts = n_elements(iVarData)
;        iVarData = reform(TEMPORARY(iVarData),npts)
;        varData = [vardata,iVarData]
;        if (i eq 0 || i eq 1) then begin
;          iVarData = ivardata[uniq(ivardata, sort(ivardata))] ; return a copy of the sorted array with duplicate adjacent elements removed
;          npts = n_elements(iVarData)
;          binWidths[i] = (npts gt 1)? $
;            max(abs(iVarData[1:npts-1] - iVarData[0:npts-2])) : $ ; use the max bin width
;            1.0
;          if (binWidths[i] lt 0.1) then binWidths[i] = 1.15*binWidths[i]
;        endif
;      endfor
;      data[*,i+2] = varData
;    endfor
;  end
;  
;  2: begin
;  end
;  
;  else:
;ENDCASE
;
;;; discriminate for any masked data
;;void = where(finite(data),complement=mskIndex,ncomplement=nMsk)
;;if (nMsk gt 0) then data[mskIndex] = -1.0e20
;
;
;; Determine the top-level base widget ID for the main DAVE window
;; and use this as the group_leader when Mslice is called. This way the Mslice instance will
;; be killed automatically only when DAVE goes down rather than if the BT7 reduction module is killed.
;oUIMain = daveTool->GetUI()
;oUIMain->GetProperty, group_leader = wTLBMain
;
;
;if (obj_valid(Self.objMslice) && (Self.multipleMsliceWinFlag eq 0)) then begin
;   Self.objMslice->Reset_data, data=data, label=tex2idl(label), instrument='BT7' $
;                             ,is_uniq=unique, unit=tex2idl(unit), /no_copy
;   ; initialize the stepsize params in the Mslice UI to values commensurate with the data
;   names = ['dispxstep','dispystep','cutstep']
;   values = [binWidths[0],binWidths[1],binWidths[0]]
;   ;values = [!values.F_NAN,!values.F_NAN,!values.F_NAN]
;   Self.objMslice->script,'set_parameter',name=names,value=values
;endif else begin
;   dataPtr = ptr_new({data:temporary(data),label:tex2idl(label),unit:tex2idl(unit),instrument:'BT7',is_uniq:unique},/no_copy)
;   Self->GetProperty, DAVETOOL=daveTool, DATA_DIRECTORY=dataDir, working_directory=workDir
;   dcs_mslice, dataPtr=dataPtr, obj_mslice=objMslice, group_leader=wTLBMain $
;             ,DAVETool=daveTool, workDir=workDir, dataDir=dataDir, /no_parmfile
;   Self.objMslice = objMslice
;   
;   ; initialize the stepsize params in the Mslice UI to values commensurate with the data
;   names = ['dispxstep','dispystep','cutstep']
;   values = [binWidths[0],binWidths[1],binWidths[0]]
;   ;values = [!values.F_NAN,!values.F_NAN,!values.F_NAN]
;   objMslice->script,'set_parameter',name=names,value=values
;endelse
;
;return, 0
;end
;-------------------------------------------------------------------------------


;;===============================================================================
;pro GenQFExport2Mslice_event, event
;compile_opt idl2
;uname = widget_info(event.id,/uname)
;widget_control, event.top, get_uvalue=statePtr
;
;case uname of
;   'APPLY': begin
;      exportIndex = widget_info((*statePtr).wButtons,/button_set)
;      (*statePtr).exportIndex = exportIndex
;      widget_control, event.top, /destroy  
;   end
;   
;   'CANCEL': begin
;      (*statePtr).cancel = 1
;      widget_control, event.top, /destroy  
;   end
;   
;   else:
;   
;endcase
;if (strcmp(uname,'APPLY')) then begin
;endif
;
;end
;-------------------------------------------------------------------------------


;===============================================================================
; GenQFTool::restoreDataVersion
;
; PURPOSE:
;   Restore the specified object to the latest version
;
; PARAMETERS:
;   oData [in|out] - object to be restored to the latest version
;
; KEYWORDS:
;
pro GenQFTool::restoreDataVersion, oData
compile_opt idl2

; restore to latest IDLitData version
oData->Restore

; Pull the data pointer structure and ensure it is up to data
currentVersion = Self.dataVersion

void = oData->GetMetaData('DATAPTRREF',tempPtr)
oldDataVersion = (*tempPtr).dataVersion

if (currentVersion gt oldDataVersion) then begin
   ; Update the data as necessary
endif

end



;===============================================================================
; GenQFTool::UpdatePropertySheet
;
; PURPOSE:
;   Update the propertysheet to reflect the current sample type
;
; PARAMETERS:
;
; KEYWORDS:
;
pro GenQFTool::UpdatePropertySheet
compile_opt idl2

Self->GetProperty, funcFlag=funcFlag
funcNames = Self.funcNames->ToArray()
funcName = funcNames[funcFlag]
funcParams = Self.funcParams
showParams = funcParams[funcName]
allParams = funcParams['ALL']

nAllParams = n_elements(allParams)
;nShowParams = n_elements(showParams)
for i = 0, nAllParams-1 do Self->SetPropertyAttribute, allParams[i] $
  ,hide=total(strcmp(showParams,allParams[i],/fold)) le 0.0 
;for i = 0, nShowParams-1 do Self->SetPropertyAttribute, showParams[i], hide=0

end
;-------------------------------------------------------------------------------


;;===============================================================================
;;+
;; GenQFTool::Plot
;;
;; PURPOSE:
;;   Generates a plot of the specified dataset
;;
;; PARAMETERS:
;;   oItem   - dataset to be plotted
;;   sPtr    - heap variable containing useful widget related info
;;   overPlotFlag  - is overplotting on (1) or off (0)
;;   lastPltFlag   - if overplotting, is this the last plot to be included
;;
;; KEYWORDS:
;;-
;pro GenQFTool::Plot, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
;compile_opt idl2
;
;print,'##############################################'
;print,'Please, Plot() is incomplete...'
;print,'##############################################'
;return
;
;end
;;-------------------------------------------------------------------------------


;===============================================================================
;+
; GenQFTool::Plot
;
; PURPOSE:
;   Generates a line or contour plot of the specified dataset for the case of a powder sample
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro GenQFTool::Plot, sPtr, overPlotFlag, lastPlotFlag
compile_opt idl2

oPSet = Self.oPSet
oX = oPSet->GetByName('X')
oY = oPSet->GetByName('Y')
oE = oPSet->GetByName('Error')

strparms = ['Y','X','Y ERROR','X ERROR','VERTICES','PALETTE','VERTEX_COLORS']
idparms = [oY->GetFullIdentifier() $
          ,oX->GetFullIdentifier() $
          ,'' $ ;oE->GetFullIdentifier() $
          ,'','','','']
visID = 'PLOT'
opID = 'Operations/Insert Visualization'
oRequester = (Self->GetByIdentifier(opID))->GetObjectInstance()
oRequester->_setTool, Self
oRequester->GetProperty, show_execution_ui = orig_showUI
oRequester->SetProperty, show_execution_ui = 0

oPSet->GetProperty, name=plotName   ; retrieve the dataset name as shown in the data manager and set it as plotname
oRequester->SetProperty, name=plotName, parameter_names=strParms, data_ids=idParms, visualization_id=visID

oWin = Self->GetCurrentWindow()
oView = oWin->GetCurrentView()
activateManip = 0
rangeChange = 0

Self->GetProperty, overPlotFlag = overPlotFlag
noOverPlot = 1 - overPlotFlag
;noOverplot = (keyword_set(overplotFlag))? overplotFlag : 1
if (Self->HasVisualizations() && noOverplot) then begin
   ;; store the active manipulator
   (*sPtr).manipID = (Self->GetCurrentManipulator())->GetFullIdentifier()
   activateManip = 1

   ;; ensure the existing visualization is selected
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
    
   ; retrieve current xrange and yrange to determine if user has zoomed plot
   oDataSpace->GetProperty, xrange=xr, yrange=yr
   xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1]) 
   yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1]) 
   rangeChange = xChange && yChange
   
   delID = 'Operations/Edit/Delete'
   oDelete = (Self->GetByIdentifier(delID))->GetObjectInstance()
   
   oDataSpace->Select
   void = oDelete->DoAction(Self)

   obj_destroy, [oVis,oDataSpace]
endif

; create the new vis
oCmd = oRequester->DoAction(Self)

;; Get the newly created vis
oLayer = oView->GetCurrentLayer()
oWorld = oLayer->GetWorld()
oDataSpace = oWorld->GetDataSpaces()
oVis = oDataSpace->GetVisualizations(count = nVis)

; TODO - fix vis cuztomization
; Customize it
Self->CustomizeVis, oVis[nVis-1], plotName, 'SAMPPLOT'


;oVis[nVis-1]->SetProperty, /fill $
;                 ,aspect_ratio=aspect_ratio $
;                 ,transparency = 5 $
;                 ,n_levels=15 $
;                 ,pal_color=1  ; => use palette for level colors
;status = oVis[nVis-1]->SetData(oDataRGB, parameter_name='PALETTE',/by_value)


;if ((nVis gt 1) && overplotFlag && lastplotFlag) then begin
;  ; if a multiplot and this is the last entry group all the plots together
;  ; to form a single entity in the property sheet view
;  ; And change the new group's name property to 'Contour'
;  for i=0,nVis-1 do oVis[i]->Select, additive=(i gt 0)
;  grpID = 'Operations/Edit/Grouping/Group'
;  oGrpOI = (Self->GetByIdentifier(grpID))->GetObjectInstance()
;  oGrpCmdSet = oGrpOI->DoAction(Self)
;  oGrpCmd = (oGrpCmdSet->Get(/all,count=nGrpCmd))[0]
;  if (isa(oGrpCmd,'IDLitCommand')) then begin
;    oGrpCmd->GetProperty, target_identifier=targID
;    (Self->GetByIdentifier(targID))->SetProperty, name='Contour'
;  endif
;endif
;oDataSpace->SetProperty, aspect_ratio=aspect_ratio
;if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only

;; customize axes
;oAxes = oDataSpace->GetAxes(/container)
;oAxes->SetProperty,axis_style=2  $    ; draw box axes
;                  ;,yTitle=ylabel, xTitle=xlabel $
;                  ,zTitle=zlabel

; Update Plot Title text to reflect name of dataset being plotted
; The plot title annotation was automatically created when visualization was first created so
; all we need to do is change the text string
annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
if (nAnn gt 0) then begin
  oText = Self->Getbyidentifier(annID[1])
  ;oItem->Getproperty, name=visname
  if (Isa(oText,'IDLitvisText')) then begin
    oText->Setproperty, string=plotName
  endif
endif

                  
if (activateManip) then Self->ActivateManipulator, (*sPtr).manipID
Self->RefreshCurrentWindow   ;oWin->Draw   ; force window to refresh

end
;-------------------------------------------------------------------------------


;===============================================================================
; GenQFTool::saveAsASCII
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::SaveAsASCII
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB


if (~Self->ExportSelection(asciiPtr, nameTag=nametag, /useTexlabels,/ascii)) then return, 0
if (ptr_valid(asciiPtr)) then begin

   Self->GetProperty, working_directory=workDir
   title = "Specify filename to store ASCII format data"
   ext = 'txt'
   filename = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
                          ,/overwrite_prompt, file=nameTag+'.txt',path=workDir, get_path=new_workDir)
                          
   if (~strcmp(filename,'')) then begin
      xvals = (*asciiPtr).xvals
      yvals = (*asciiPtr).yvals
      evals = (*asciiPtr).evals
      nd = n_elements(xvals)
      openw, lun, filename, /get_lun
      for i = 0,nd-1 do printf, lun, format='(3(F11.4,2X))',xvals[i],yvals[i],evals[i]
      
      free_lun, lun, /force
      
      if (file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir
   
      msg = 'Output stored in: '+filename
      Self->StatusMessage, msg
   endif
   
   ptr_free, asciiPtr
endif

return, 1
end


;===============================================================================
; GenQFTool::saveAsDave
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::SaveAsDave
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB


if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels,/dave)) then return, 0
if (ptr_valid(davePtr)) then begin

   Self->GetProperty, working_directory=workDir
   title = "Specify filename to store DAVE format data"
   ext = 'dave'
   filename = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
                          ,/overwrite_prompt, file=nameTag+'.dave',path=workDir, get_path=new_workDir)
                          
   if (~strcmp(filename,'')) then begin
      save, davePtr, filename=filename
      if (file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir
   
      msg = 'Output stored in: '+filename
      Self->StatusMessage, msg
   endif
   
   heap_free, davePtr
endif

return, 1
end


;===============================================================================
; GenQFTool::exportToDaveDM
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::exportToDaveDM
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels, /dave)) then return, 0

if (ptr_valid(davePtr)) then begin
   if ((n_elements(nameTag) le 0) || (strtrim(nameTag,2) eq '')) then nameTag='Untitled'
      
   ; Send data to DAVE Data Manager Folder
   Self.DAVETool->AddDavePtrToDataManager, davePtr, nameTag
   
   msg = "New extry '"+nameTag+"' created in DAVE Data Manager"
   Self->StatusMessage, msg

   heap_free, davePtr
endif

return, 1
end




;===============================================================================
; GenQFTool::ExportSelection
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::ExportSelection, davePtr, nameTag=nameTag, useTexLabels=useTexLabels $
                                    ,dave=dave, ascii=ascii
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

if (n_elements(useTexLabels) eq 0) then useTexLabels = 1
if (~keyword_set(dave) && ~keyword_set(ascii)) then dave = 1

oData = Self.oPSet

oData->GetProperty, description=nameTag

oX = oData->GetByName('X')
status = oX->GetData(xvals)
oZ = oData->GetByName('Y')
status = oZ->GetData(yvals)
oErr = oData->GetByName('Error')
status = oErr->GetData(evals)

;index = sort(xvals)
;xvals = xvals[index]
;yvals = yvals[index]
;evals = evals[index]

xLabel = ''
if (oX->GetMetaData('LONG_NAME',label)) then xLabel += label
xUnits = ''
if (oX->GetMetaData('UNITS',units)) then xUnits += units

yLabel = ''
if (oZ->GetMetaData('LONG_NAME',label)) then yLabel += label
yUnits = ''
if (oZ->GetMetaData('UNITS',units)) then yUnits += units


if (~keyword_set(useTexLabels)) then begin
  xLabel = tex2idl(xLabel)
  xUnits = tex2idl(xunits)
  yLabel = tex2idl(yLabel)
  yUnits = tex2idl(yunits)
endif

; convert to ASCII struct if required
if (keyword_set(ascii)) then begin
  struct = {xvals:xvals,yvals:yvals,evals:evals,xlabel:xlabel,xunits:xunits,ylabel:ylabel}
  davePtr = ptr_new(struct)
endif

; convert to davePtr struct if required
if (keyword_set(dave)) then begin
  status = create_dave_pointer(davePtr, qty=yvals, xvals=xvals, err=evals)
  if (~status) then begin
    msg = "Unable to allocate memory!"
    Self->StatusMessage, msg
    if (ptr_valid(davePtr)) then heap_free, davePtr
    return, 0
  endif

  (*(*davePtr).dataStrPtr).commonStr.instrument = 'Calculation'
  (*(*davePtr).dataStrPtr).commonStr.xlabel = xLabel
  (*(*davePtr).dataStrPtr).commonStr.xunits = xunits
  (*(*davePtr).dataStrPtr).commonStr.xtype = 'points'
  (*(*davePtr).dataStrPtr).commonStr.ylabel = ''
  (*(*davePtr).dataStrPtr).commonStr.yunits = ''
  (*(*davePtr).dataStrPtr).commonStr.ytype = 'points'

  (*(*davePtr).dataStrPtr).commonStr.histlabel = yLabel
  (*(*davePtr).dataStrPtr).commonStr.histunits = yUnits
  (*(*(*davePtr).dataStrPtr).commonStr.treatmentPtr) = 'Function evaluated using GenQF module in DAVE'

endif

return, 1

end


;===============================================================================
; GenQFTool::exportToPAN
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::ExportToPAN
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
notifyIDs = [wTLB,wTLB]
Self->GetProperty, working_directory=workDir, data_directory=dataDir

if (~Self->ExportSelection(davePtr, nameTag=nametag, useTexlabels=0, /dave)) then return, 0

; Determine in top-level base widget ID for the main DAVE window
; and use this as the group_leader when PAN is called. This way the PAN instance will
; be killed automatically only when DAVE goes down rather than if the BT7 reduction module is killed.
oUIMain = Self.daveTool->GetUI()
oUIMain->GetProperty, group_leader = wTLBMain

if (ptr_valid(davePtr)) then  begin
   oVoid = obj_new('OPAN',notifyID=[wTLBMain,wTLBMain],group_leader=wTLBMain $
                ,davePtr=davePtr,workDir=workDir,daveTool=Self.DAVETool,dataDir=dataDir)

   heap_free, davePtr
endif

return, 1
end


;===============================================================================
; GenQFTool::saveProperties
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function GenQFTool::SaveProperties
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'GenQFTool::saveProperties: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

print, 'properties saved...'

return, 1
end



;;===============================================================================
;;+
;; GenQFTool::WriteProjectAs
;;
;; PURPOSE:
;;   save project (data plus state) to file
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;-
;function GenQFTool::WriteProjectAs
;compile_opt idl2
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        ;;print, 'Error handled!'
;        eTitle = 'GenQFTool::writeProjectAs: Error encountered'
;        eMsg = 'An error or unusual condition was encountered!'
;        eMsg = [eMsg,'Please, report the following to the DAVE team:']
;        eMsg = [eMsg,!error_state.msg]
;        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
;        catch, /cancel
;        return, 0
;    endif
;endif
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;wChild = widget_info(wTLB, /child)
;widget_control, wChild, get_uvalue=sPtr
;
;Self->GetProperty, nSamp=_nSamp, working_directory=workDir
;if (_nSamp le 0) then begin
;   msg = 'No data in current session so cannot proceed with save action!'
;   Self->StatusMessage, msg
;   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
;   return, 0
;endif
;
;
;projName = file_basename(Self.projName,/fold_case,'.tisv')
;oSamp = Self.sampContRef->Get(position = 0)
;if (strcmp(projName,'Untitled',/fold_case) && obj_valid(oSamp)) then begin
;   oSamp->GetProperty, description=desc
;   projName = file_basename(desc,/fold_case,'.bt7')
;   ; replace spaces in filename with _
;   while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos
;endif
;title = "Specify filename to store session"
;ext = 'tisv'
;filter = ['*.tisv']
;projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
;                          ,dialog_parent=wTLB, /write $
;                          ,/overwrite_prompt, file=projName+'.tisv' $
;                          ,path=workDir, get_path=new_workDir)
;
;if (strcmp(projName,'')) then return, 0 
;
;return, Self->writeProject(/noPrompt, new_workDir=file_dirname(projName,/mark_dir), new_projName=file_basename(projName,/fold_case,'.tisv'))
;
;end


;;===============================================================================
;;+
;; GenQFTool::WriteProject
;;
;; PURPOSE:
;;   save project (data plus state) to file
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;-
;function GenQFTool::WriteProject, noPrompt=noPrompt, new_workDir=new_workDir,new_projName=new_projName 
;compile_opt idl2
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;wChild = widget_info(wTLB, /child)
;widget_control, wChild, get_uvalue=sPtr
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        ;;print, 'Error handled!'
;        eTitle = 'GenQFTool::writeProject: Error encountered'
;        eMsg = 'An error or unusual condition was encountered!'
;        eMsg = [eMsg,'Please, report the following to the DAVE team:']
;        eMsg = [eMsg,!error_state.msg]
;        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
;        catch, /cancel
;        return, 0
;    endif
;endif
;
;; save session preferences
;status = Self->SavePreferences(/skip_filesave)
;
;Self->GetProperty, funcFlag=_funcFlag, nSamp=_nSamp $ ;,nBkgd=_nBkgd,nFast=_nFast $
;                 , minIntensity=_minIntensity, maxIntensity=_maxIntensity $
;                 , preferences=_prefStr, working_directory=workDir
;noData = (_nSamp le 0) ;&& (_nBkgd le 0) && (_nFast le 0)
;if (noData) then begin
;   msg = 'No data in current session so cannot proceed with save action!'
;   Self->StatusMessage, msg
;   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
;   return, 0
;endif
;
;projName = (keyword_set(new_projName))? new_projName : Self.projName
;if (keyword_set(new_workDir)) then workDir = new_workDir
;
;if (keyword_set(noPrompt)) then begin
;   projName = workDir+projName+'.tisv'
;endif else begin
;   projName = Self.projName
;   oSamp = Self.sampContRef->Get(position = 0)
;   if (strcmp(projName,'Untitled',/fold_case) || strcmp(projName,'')) then begin
;      oSamp->GetProperty, description=desc
;      projName = file_basename(desc,/fold_case,'.bt7')
;      ; replace spaces in filename with _
;      while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos
;
;      title = "Specify filename to store session"
;      ext = 'tisv'
;      filter = ['*.tisv']
;      projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
;                                ,dialog_parent=wTLB, /write $
;                                ,/overwrite_prompt, file=projName+'.tisv' $
;                                ,path=workDir, get_path=new_workDir)
;      ;projName = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
;      ;                       ,/overwrite_prompt, file=projName+'.tisv',path=workDir, get_path=new_workDir)
;
;   endif else projName = workDir+projName+'.tisv'
;endelse
;                       
;if (~strcmp(projName,'')) then begin
;   if (_nSamp gt 0) then _datasets = (Self.sampContRef->Get(/all))[0:_nSamp-1]
;;   if (_nBkgd gt 0) then _datasets = (n_elements(_datasets) gt 0)? $
;;                                     [_datasets,(Self.bkgdContRef->Get(/all))[0:_nBkgd-1]] : $
;;                                     (Self.bkgdContRef->Get(/all))[0:_nBkgd-1]
;;   if (_nFast gt 0) then _datasets = (n_elements(_datasets) gt 0)? $
;;                                     [_datasets,(Self.fastContRef->Get(/all))[0:_nFast-1]] : $
;;                                     (Self.fastContRef->Get(/all))[0:_nFast-1]
;   nd = n_elements(_datasets)
;   _dataPtrs = ptrarr(nd)
;   for i=0,nd-1 do begin
;      void = _datasets[i]->GetMetaData('DATAPTRREF',dataPtr)
;      _dataPtrs[i] = dataPtr
;   endfor
;   
;   ; Get PSD calibration info
;   if (Self.calibParamsIsSet) then begin
;      _calibInfo = {calibParamsIsSet:Self.calibParamsIsSet $
;                   ,calibParamsFilename:Self.calibParamsFilename $
;                   ,calibParamsBaseFilename:Self.calibParamsBaseFilename $
;                   ,chDelA4:Self.chDelA4 $
;                   ,chDelEf:Self.chDelEf $
;                   ,chEff:Self.chEff $
;                   }
;   endif else _calibInfo = {calibParamsIsSet:Self.calibParamsIsSet}
;
;   save, _datasets, _dataPtrs, _nSamp, _prefStr, _calibInfo $  ; , _nBkgd, _nFast
;       , _minIntensity, _maxIntensity, _funcFlag $
;       , description = 'GenQF Data Reduction Session' $
;       , filename=projName, /compress
;   if (isa(new_workDir) && file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir
;
;   msg = 'Session stored in: '+projName
;   Self->StatusMessage, msg
;   
;   projName = file_basename(projName,/fold_case,'.tisv')
;   Self.projName = projName
;   Self->SetProperty, tool_filename=projName
;   
;   Self.modifiedFlag = 0
;endif
;
;return, 1
;end


;;===============================================================================
;; GenQFTool::readProject
;;
;; PURPOSE:
;;   export dataset to DAVE Data Manager
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;
;function GenQFTool::ReadProject
;compile_opt idl2
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;wChild = widget_info(wTLB, /child)
;widget_control, wChild, get_uvalue=sPtr
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        ;;print, 'Error handled!'
;        eTitle = 'GenQFTool::ReadProject: Error encountered'
;        eMsg = 'An error or unusual condition was encountered!'
;        eMsg = [eMsg,'Please, report the following to the DAVE team:']
;        eMsg = [eMsg,!error_state.msg]
;        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
;        catch, /cancel
;        if (obj_valid(oSave)) then obj_destroy, oSave
;        Self->EnableUpdates
;        return, 0
;    endif
;endif
;
;filter = '*.tisv'
;Self->GetProperty, working_directory=workDir
;if (n_elements(title) eq 0) then title='Specify session to load'
;
;filename = dialog_pickfile(title=title,/must_exist, dialog_parent=wTLB $
;                       ,filter=filter,path=workDir, get_path=newWorkDir)
;
;if (filename eq '') then return, 0
;Self->SetProperty, work_directory=newWorkDir
;
;oSave = obj_new('IDL_Savefile', filename)
;contents = oSave->Contents()
;obj_destroy, oSave
;expectedDesc='GenQF Session'
;if (~strcmp(contents.description,expectedDesc,/fold_case)) then begin
;   msg = 'Not a valid GenQF session file!'
;   Self->StatusMessage, msg
;   Self->ErrorMessage, msg, severity=1, title='Invalid file type!'   
;   return, 0
;endif
;
;restore, filename, restored_objects=oObj, /relaxed_structure_assignment
;nObj = n_elements(oObj)
;if (nObj le 0) then return, 0
;
;; Check whether or not to save current session before closing it
;if (Self.modifiedFlag) then begin
;   ; If our current state is dirty, prompt to save first.
;   Self->GetProperty, working_directory=workDir
;   outfile = workDir+Self.projName+'.tisv'
;   status = self->PromptUserYesNo( $
;       "Save changes to " + outfile + "?", $
;       answer, $
;       DEFAULT_NO=0, $
;       TITLE='Save', $
;       /CANCEL)
;
;   if (status && (answer eq 1)) then begin
;      void = Self->writeProject(/noPrompt)
;   endif
;
;endif
;
;Self->DisableUpdates
;
;; delete all datasets in current session
;void = Self->DeleteAllDatasets(/noPrompt)
;
;projName = file_basename(filename,/fold_case,'.tisv')
;Self.projName = projName
;
;; update preferences structure to most current definition
;status = GenQFPreferences(_prefStr,/updateVersion) 
;
;Self->SetProperty, preferences=_prefStr, tool_filename=projName $
;                 , maxIntensity=_maxIntensity, minIntensity=_minIntensity
;; PSD calibration stuff
;; Only alter current calib info if one was saved with the project file!
;if (_calibInfo.calibParamsIsSet) then begin
;   Self.calibParamsIsSet = _calibInfo.calibParamsIsSet
;   Self.calibParamsBaseFilename = _calibInfo.calibParamsBaseFilename
;   Self.calibParamsFilename = _calibInfo.calibParamsFilename
;   Self.chDelA4 = _calibInfo.chDelA4
;   Self.chDelEf = _calibInfo.chDelEf
;   Self.chEff = _calibInfo.chEff
;   Self->SetPropertyAttribute, 'calibParamsBaseFilename', userdef=Self.calibParamsBaseFilename
;endif
;Self->SetPropertyAttribute, 'effNormFlag', sensitive=_calibInfo.calibParamsIsSet
;
;
;Self->GetProperty, maskFlag=mF, fastFlag=fF, xAxisVar=xAxisVar $
;                 , binWidths=binWidths, defaultIntensityFlag=defIntFlag, funcFlag=funcFlag
;Self->SetProperty, minBinWidth = binwidths[xAxisVar]
;noHide = (defIntFlag eq 0) && (funcFlag eq 1)  ; don't hide if not using default intensity and single crystal sample
;Self->SetPropertyAttribute, 'maxIntensity', hide=~noHide
;Self->SetPropertyAttribute, 'minIntensity', hide=~noHide
;Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
;Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
;Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;
;; restore datasets
;nd = n_elements(_datasets)
;for i=0, nd-1 do begin
;   oData = _datasets[i]
;   Self->restoreDataVersion, oData
;   oData->GetProperty, type=dataType
;   case dataType of
;      'samp': begin
;         Self->AddByIdentifier, 'Sample Data Manager', oData, position=0
;         Self.sampContRef->Add, oData
;      end
;      
;      'bkgd': begin
;         Self->AddByIdentifier, 'Bkgd Data Manager', oData, position=0
;         Self.bkgdContRef->Add, oData
;      end
;      
;      else:
;   
;   endcase
;
;   ; If samTypeFlag variable was not saved (this would be case for projects save before July, 2012),
;   ; then get the value using the funcFlag property of the first dataset
;   if (n_elements(_funcFlag) eq 0) then begin
;      status = oData->GetMetaData('funcFlag',_funcFlag)
;   endif
;endfor
;Self->SetProperty, funcFlag=_funcFlag, typeCheck = 0
;
;
;Self.nSamp = _nSamp
;if (n_elements(_nBkgd) gt 0) then Self.nBkgd = _nBkgd
;
;
;;Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
;;
;;Self->SetPropertyAttribute, 'SUMBKGDFLAG', sensitive=(Self.nBkgd gt 0)
;;Self->SetPropertyAttribute, 'BKGDFLAG', sensitive=(Self.nBkgd gt 0)
;
;Self->refreshPropertySheet
;
;;; Select a dataset and plot it
;if (_nSamp gt 0) then begin
;   oItem = Self.sampContRef->Get(position = 0)
;   dataType='samp'
;endif else if (_nBkgd gt 0) then begin
;   oItem = Self.bkgdContRef->Get(position = 0)
;   dataType='bkgd'
;endif 
;
;if (obj_valid(oItem)) then begin
;   (*sPtr).itemID = oItem->GetFullIdentifier()
;   cw_GenQFdatamanager_setselect, (*sPtr).wDM, (*sPtr).itemID, /clear, dataType=dataType ; select it
;
;   wd_GenQFTool_sendPlotEvent, oUI, oItem  ; plot it
;endif
;
;Self.modifiedFlag = 0
;Self->EnableUpdates
;return, 1
;end


;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; GenQFTool::Init
;
; Purpose:
; The constructor of the GenQFTool object.
;
; Parameters:
; None.
;
function GenQFTool::Init, _REF_EXTRA=_EXTRA
compile_opt idl2

;; Call our super class
if (~self->IDLitTool::Init(_EXTRA=_extra)) then $
  return, 0

oSystem = self->_GetSystem()

; Specify current data version number
; Essentially, whevever the data structure used to store 
; datasets changes the version number should be incremented to reflect
; this. When the version number changes, restoreDataVersion() must also
; be modified to handle restoring older version datasets to the
; current version.
Self.dataVersion = 1

; Add a 'DAVEDATA_MANAGER' service
;self->AddService, OBJ_NEW("DAVEsrvDatamanager", name="DAVEDATA_MANAGER")

; Create the data manager folders
oSampFolder = Obj_New("IDLitDataManagerFolder", identifier='Sample Data Manager' $
                      ,name='Sample', description='Sample Data Manager Container',tool=self)
oBkgdFolder = Obj_New("IDLitDataManagerFolder", identifier='Bkgd Data Manager' $
                      ,name='Background', description='Bkgd Data Manager Container',tool=self)
self->Add, [oSampFolder,oBkgdFolder]


self->createfolders,'Operations/       ',NAME='', description='Horizontal Space'
;;---------------------------------------------------------------------
;;*** File Menu

;; create folders
self->createfolders,'Operations/File',NAME=IDLitLangCatQuery('Menu:File')

;self->RegisterOperation, 'Open Session', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='File/readProject'
;
;self->RegisterOperation, 'Save Session', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='File/writeProject'
;self->RegisterOperation, 'Save Session As', $
;  'DAVEopMenuItem',icon='Save_24', IDENTIFIER='File/writeProjectAs'
;

Self->RegisterOperation,'Export Graphics...' $
  ,'DAVEopExportGraphics' $
  ,identifier='File/Export' $
  ,ACCELERATOR='Ctrl+E' $
  ,writertypes=['IDLDEST','IDLIMAGE'] $
  ,icon='export';,/separator

self->RegisterOperation, IDLitLangCatQuery('Menu:File:PrintPreview'), $
  'IDLitopPrintPreview', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/PrintPreview', ICON='print'

self->RegisterOperation, IDLitLangCatQuery('Menu:File:Print'), $
  'IDLitopFilePrint', $
  ACCELERATOR='Ctrl+P', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/Print', ICON='print_24'


self->RegisterOperation, 'Save Preferences', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/savePreferences',/separator

self->RegisterOperation, 'Reset Preferences (Default Values)', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/resetPreferences'


self->RegisterOperation, 'Exit', 'DAVEopMenuItem', ACCELERATOR='Ctrl+Q', $
  IDENTIFIER='File/Exit', /SEPARATOR

self->RegisterOperation, 'ExitOp', 'DAVEopFileExit', IDENTIFIER='ExitOp'

;
;;-----------
;; Data Input Menu
;self->createfolders,'Operations/Input',NAME='Data Input'
;
;self->RegisterOperation, 'Load PSD Calibration Parameters file', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadCalibParams'
;
;
;self->RegisterOperation, 'Load Sample Data', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSamp', /separator
;
;self->RegisterOperation, 'Load Sample Data (NCNR ftp server)', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSampFtp'
;
;self->RegisterOperation, 'Load Background Data', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgd', /separator
;
;self->RegisterOperation, 'Load Background Data (NCNR ftp server)', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgdFtp'
;
;self->RegisterOperation, 'Delete All Loaded Data', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/deleteAllDatasets',/separator
;


;-----------
; Data Output Menu
self->createfolders,'Operations/Output',NAME='Output Calculation'
  
;self->RegisterOperation, 'Export Selection to Mslice (Single Crystal, powder)', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/Mslice'
self->RegisterOperation, 'Export to Data Manager', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/ExportToDaveDM'
self->RegisterOperation, 'Save as DAVE file', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveAsDave'
self->RegisterOperation, 'Save as ASCII file', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveAsASCII'
self->RegisterOperation, 'Fit in PAN', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToPAN',/separator




;;---------------------------------------------------------------------
;; Create our File toolbar container.
;;
;self->Register, "Open Session", $
;                PROXY='Operations/File/ReadProject', $
;                IDENTIFIER='Toolbar/File/ReadProject'
;self->Register, "Save Session", $
;                PROXY='Operations/File/WriteProject', $
;                IDENTIFIER='Toolbar/File/WriteProject'
;self->Register, "Save Session As", $
;                PROXY='Operations/File/WriteProjectAs', $
;                IDENTIFIER='Toolbar/File/WriteProjectAs'
self->Register, IDLitLangCatQuery('Menu:File:Print'), $
                PROXY='Operations/File/Print', $
                IDENTIFIER='Toolbar/File/Print'
self->Register, IDLitLangCatQuery('Menu:File:PrintPreview'), $
                PROXY='Operations/File/PrintPreview', $
                IDENTIFIER='Toolbar/File/PrintPreview'
self->Register, IDLitLangCatQuery('Menu:File:Export'), $
                PROXY='Operations/File/Export', $
                IDENTIFIER='Toolbar/File/Export'


;;---------------------------------------------------------------------
;;*** Edit Menu

self->createfolders,'Operations/Edit',NAME=IDLitLangCatQuery('Menu:Edit')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Undo'), $
  'IDLitopUndo', $
  ACCELERATOR='Ctrl+Z', $
  IDENTIFIER='Edit/Undo', ICON='undo', /disable, $
  /IGNORE_AVAILABILITY

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Redo'), $
  'IDLitopRedo', $
  ACCELERATOR='Ctrl+Y', $
  IDENTIFIER='Edit/Redo', ICON='redo',/disable, $
  /IGNORE_AVAILABILITY

;; Clipboard...note these are proxied from the system registry!

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Cut'), $
  PROXY="/REGISTRY/OPERATIONS/CUT",$
  IDENTIFIER='Edit/Cut'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Copy') , $
  PROXY='/REGISTRY/OPERATIONS/COPY', $
  IDENTIFIER='Edit/Copy'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Paste') , $
  PROXY='/REGISTRY/OPERATIONS/Paste', $
  IDENTIFIER='Edit/Paste'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:PasteSpecial') , $
  PROXY='/REGISTRY/OPERATIONS/PASTESPECIAL', $
  IDENTIFIER='Edit/PasteSpecial'

                                ;-----------------
self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Delete') , $
  PROXY='/REGISTRY/OPERATIONS/Delete', $
  IDENTIFIER='Edit/Delete'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SelectAll') , $
  'IDLitopSelectAll', $
  DESCRIPTION="Select all visualizations in the current view.", $
  IDENTIFIER='Edit/SelectAll', $
  ICON='select'


                                ;-----------------
self->createfolders,'Operations/Edit/Grouping', $
                    NAME=IDLitLangCatQuery('Menu:Edit:Grouping')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Group'), $
  'IDLitopGroup', $
  IDENTIFIER='Edit/Grouping/Group', $
  ICON='group', $
  /SEPARATOR

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Ungroup'), $
  'IDLitopUngroup', $
  IDENTIFIER='Edit/Grouping/Ungroup', $
  ICON='ungroup'

;self->createfolders,'Operations/Edit/Order', $
;                    NAME=IDLitLangCatQuery('Menu:Edit:Order')
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringToFront'), $
;  'IDLitopBringToFront', $
;  IDENTIFIER='Edit/Order/BringToFront', $
;  ICON='front'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendToBack'), $
;  'IDLitopSendToBack', $
;  IDENTIFIER='Edit/Order/SendToBack', $
;  ICON='back'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringForward'), $
;  'IDLitopBringForward', $
;  IDENTIFIER='Edit/Order/BringForward', $
;  ICON='front'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendBackward'), $
;  'IDLitopSendBackward', $
;  IDENTIFIER='Edit/Order/SendBackward', $
;  ICON='back'


;;---------------------------------------------------------------------
;;*** Format Menu

self->createfolders,'Operations/Edit/Style', $
                    NAME=IDLitLangCatQuery('Menu:Style')

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:ApplyStyle') , $
  PROXY='/REGISTRY/OPERATIONS/Apply Style', $
  IDENTIFIER='Edit/Style/Apply Style'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Style:CreateStylefromSelection'), $
  'IDLitopStyleCreate', $
  IDENTIFIER='Edit/Style/Create Style', $
  ICON='style'

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:StyleEditor'), $
  'IDLitopStyleEditor', $
  IDENTIFIER='Edit/Style/StyleEditor', $
  ICON='style'


self->RegisterOperation, 'Edit Parameters','IDLitopEditParameters'

Self->RegisterOperation, 'SaveProperties','DAVEopMenuItem',identifier='Edit/SaveProperties'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Properties'), $
  'IDLitopPropertySheet', $
  DESCRIPTION='Display the Property Sheet for the item', $
  IDENTIFIER='Edit/Properties', $
  ICON='propsheet'


;;---------------------------------------------------------------------
;; Create our Edit toolbar container.
;;
self->Register, IDLitLangCatQuery('Menu:Edit:Undo'), $
                PROXY='Operations/Edit/Undo', $
                IDENTIFIER='Toolbar/Edit/Undo'
self->Register, IDLitLangCatQuery('Menu:Edit:Redo'), $
                PROXY='Operations/Edit/Redo', $
                IDENTIFIER='Toolbar/Edit/Redo'
self->Register, IDLitLangCatQuery('Menu:Edit:Cut'), $
                PROXY="/REGISTRY/OPERATIONS/CUT",$
                IDENTIFIER='Toolbar/Edit/Cut'
self->Register, IDLitLangCatQuery('Menu:Edit:Copy'), $
                PROXY='/REGISTRY/OPERATIONS/COPY', $
                IDENTIFIER='Toolbar/Edit/Copy'
self->Register, IDLitLangCatQuery('Menu:Edit:Paste'), $
                PROXY='/REGISTRY/OPERATIONS/Paste', $
                IDENTIFIER='Toolbar/Edit/Paste'


;;---------------------------------------------------------------------
;;*** Insert menu

self->createfolders,'Operations/Insert', $
                    NAME=IDLitLangCatQuery('Menu:Insert')

;self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:Visualization'), 'IDLitopInsertVis', $
;;  IDENTIFIER='Insert/Visualization', ICON='view'

self->RegisterOperation, 'Insert Visualization','IDLitopInsertVis';, $
;  IDENTIFIER='Insert/Visualization', ICON='view'


self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:View'), $
  'IDLitopInsertView', $
  IDENTIFIER='Insert/View', ICON='view'

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:DataSpace'), $
  'IDLitopInsertDataSpace';, $
  ;IDENTIFIER='Insert/Data Space', ICON='mcr'

;self->createfolders,'Operations/Insert/Axis', NAME=IDLitLangCatQuery('Menu:Insert:Axis')

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:XAxis'), $
  'IDLitOpInsertAxisX';, IDENTIFIER='Insert/Axis/X Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:YAxis'), $
  'IDLitOpInsertAxisY';, IDENTIFIER='Insert/Axis/Y Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:ZAxis'), $
  'IDLitOpInsertAxisZ';, IDENTIFIER='Insert/Axis/Z Axis', ICON='mcr'


;;---------------------------------------------------------------------
;;*** Operations Menu
self->createfolders,'Operations/Operations', $
                    NAME=IDLitLangCatQuery('Menu:Operations')

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:OperationsBrowser'), $
;  'IDLitopBrowserOperation', $
;  IDENTIFIER='Operations/Operations Browser' ; ,ICON='mcr'

self->createfolders,'Operations/Operations/Macros', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Macros')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RunMacro'), $
  PROXY='/Registry/MacroTools/Run Macro', $
  IDENTIFIER='Operations/Macros/Run Macro'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StartRecording'), $
  PROXY='/Registry/MacroTools/Start Recording', $
  IDENTIFIER='Operations/Macros/Start Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StopRecording'), $
  PROXY='/Registry/MacroTools/Stop Recording', $
  IDENTIFIER='Operations/Macros/Stop Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:MacroEditor'), $
  PROXY='/Registry/MacroTools/Macro Editor', $
  IDENTIFIER='Operations/Macros/Macro Editor'

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:Statistics'), $
;  'IDLitopStatistics', $
;  DESCRIPTION='Display statistics for the selected item', $
;  IDENTIFIER='Operations/Statistics', ICON='sum', /SEPARATOR
;
;;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Histogram'), $
;;  'IDLitopHistogram', $
;;  DESCRIPTION='Perform the histogram operation on the selected item', $
;;  IDENTIFIER='Operations/Histogram', ICON='hist'
;
self->createfolders,'Operations/Operations/Filter', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Filter')

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:Convolution'), $
;  'IDLitopConvolution', $
;  DESCRIPTION='Perform the convolution operation on the selected item', $
;  IDENTIFIER='Operations/Filter/Convolution', ICON='sum'
;
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:Median'), $
  'IDLitopMedianFilter', $
  DESCRIPTION='Perform the median filter operation on the selected item', $
  IDENTIFIER='Operations/Filter/Median', ICON='sum'

self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Smooth'), $
  'IDLitopSmooth', $
  DESCRIPTION='Perform the smooth operation on the selected item', $
  IDENTIFIER='Operations/Filter/Smooth', ICON='sum'

self->createfolders,'Operations/Operations/Rotate', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Rotate')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateLeft'), $
  'IDLitopRotateLeft', $
  DESCRIPTION='Rotate left by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateLeft', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateRight'), $
  'IDLitopRotateRight', $
  DESCRIPTION='Rotate right by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateRight', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateByAngle'), $
  'IDLitopRotateByAngle', $
  DESCRIPTION='Rotate by a specified angle', $
  IDENTIFIER='Operations/Rotate/RotateByAngle', $
  ICON='rotate'



;;---------------------------------------------------------------------
;;*** Window Menu

self->createfolders,'Operations/Window', $
                    NAME=IDLitLangCatQuery('Menu:Window')


;;-----------------
Self->RegisterOperation, 'Reset to Default Data Range', 'IDLitopRangeReset' $
   ,description='Reset to default data range', identifier='Window/Resetrange' $
   ,icon='range_reset'

;;--
self->createfolders,'Operations/Toolbar/Dataspace',name='Dataspace'
self->Register, 'Reset to Default Data Range', $
                PROXY='Operations/Window/Resetrange', $
                IDENTIFIER='Toolbar/Dataspace/Resetrange'

self->createfolders,'Operations/Window/Canvas Zoom', $
                    NAME=IDLitLangCatQuery('Menu:Window:CanvasZoom')

self->RegisterOperation, '800%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/800%', $
  ICON='zoom', /CHECKED;, /SEPARATOR
self->RegisterOperation, '400%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/400%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '200%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/200%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '100%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/100%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '75%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/75%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '50%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/50%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '25%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/25%', $
  ICON='zoom', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:ZoomonResize'), $
  'IDLitopZoomResize', $
  ICON='zoom', $
  IDENTIFIER='Window/ZoomResize', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:Layout'), $
  'IDLitopWindowLayout', $
  IDENTIFIER='Window/Layout'

                                ;-----------------

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:FittoView'), $
  'IDLitopFitToView', $
  IDENTIFIER='Window/FitToView', $
  ICON='fitwindow', /SEPARATOR

;;---------------------------------------------------------------------
;;*** Help Menu
self->createfolders,'Operations/Help', $
                    NAME=IDLitLangCatQuery('Menu:Help')


self->RegisterOperation, "User's Manual", 'DAVEopHelp', $
  IDENTIFIER='Help/GenQFReductionManual',helptopic='GenQF_REDUCTION'
;-----------------

self->RegisterOperation, 'About GenQF Data Reduction', 'GenQFopHelpAbout', $
  IDENTIFIER='Help/About GenQF',/separator

self->RegisterOperation, 'About DAVE', 'DAVEopHelpAbout', $
  IDENTIFIER='Help/About DAVE',/separator






;;---------------------------------------------------------------------
;;*** Manipulators
self->RegisterManipulator, 'Arrow', 'IDLitManipArrow', $
  ICON='arrow', /DEFAULT, IDENTIFIER="ARROW", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Select')

self->RegisterManipulator, 'Rotate', 'IDLitManipRotate', $
  ICON='rotate', IDENTIFIER="ROTATE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Rotate')

self->RegisterManipulator, 'View Pan', 'IDLitManipViewPan', $
  ICON='hand', IDENTIFIER="VIEWPAN", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Pan')


;;---------------------------------------------------------------------
;;*** View Zoom Manipulator
self->RegisterManipulator, 'View Zoom', 'IDLitManipViewZoom', $
  IDENTIFIER='View/ViewZoom', ICON='zoom', $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:ViewZoom')

;;---------------------------------------------------------------------
;; *** View Zoom Combobox

                                ; Combobox is not available on True64 (OSF Alpha)
useCombobox = ~(!VERSION.os eq 'OSF')
self->Register, 'View Zoom', 'IDLitopViewZoom', $
                IDENTIFIER='Toolbar/View/ViewZoom', $
                DROPLIST_EDIT=useCombobox, $
                DROPLIST_ITEMS=['800%', $
                                '400%', $
                                '200%', $
                                '150%', $
                                '130%', $
                                '100%', $
                                '75%',  $
                                '50%',  $
                                '25%'], $
                DROPLIST_INDEX=4, $
                /SINGLETON

;;---------------------------------------------------------------------
;;*** Annotation Manipulators
self->RegisterManipulator, 'Text', 'IDLitAnnotateText', $
  ICON='text', IDENTIFIER="ANNOTATION/TEXT", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateText')

self->RegisterManipulator, 'Line', 'IDLitAnnotateLine', $
  ICON='line', IDENTIFIER="ANNOTATION/LINE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateLine')

self->RegisterManipulator, 'Rectangle', 'IDLitAnnotateRectangle', $
  ICON='rectangl', IDENTIFIER="ANNOTATION/RECTANGLE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateRectangle')

self->RegisterManipulator, 'Oval', 'IDLitAnnotateOval', $
  ICON='ellipse', IDENTIFIER="ANNOTATION/OVAL", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateOval')

self->RegisterManipulator, 'Polygon', 'IDLitAnnotatePolygon', $
  ICON='segpoly', IDENTIFIER="ANNOTATION/POLYGON", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotatePolygon')

self->RegisterManipulator, 'Freehand', 'IDLitAnnotateFreehand', $
  ICON='freehand', IDENTIFIER="ANNOTATION/FREEHAND", $
  DESCRIPTION='Click & drag to draw'



;;---------------------------------------------------------------------
;;*** DrawContext
;self->Register, 'Cut', $
;                PROXY="/REGISTRY/OPERATIONS/CUT",$
;                IDENTIFIER='ContextMenu/DrawContext/Cut'
;
;self->Register, 'Copy', $
;                PROXY='/REGISTRY/OPERATIONS/COPY', $
;                IDENTIFIER='ContextMenu/DrawContext/Copy'
;
;self->Register, 'Paste', $
;                PROXY='/REGISTRY/OPERATIONS/Paste', $
;                IDENTIFIER='ContextMenu/DrawContext/Paste'
;
;                                ;-----------------
self->Register, 'Delete', $
                PROXY='/REGISTRY/OPERATIONS/Delete', $
                IDENTIFIER='ContextMenu/DrawContext/Delete'

                                ;-----------------
self->Register, 'Group', $
                PROXY='Operations/Edit/Grouping/Group', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Group'

self->Register, 'Ungroup', $
                PROXY='Operations/Edit/Grouping/Ungroup', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Ungroup'

self->Register, 'Modify Properties...', $
                PROXY='Operations/Edit/Properties', $
                IDENTIFIER='ContextMenu/DrawContext/Properties'

;;---------------------------------------------------------------------
;;*** CropContext

Self.sampContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='SampContainer')
;Self.bkgdContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='BkgdContainer')

;; Initialise data and Register Properties
funcNames = ['aa','jqy1','jqy2','jqs1','jqs2','rqs','rqy','fs','nstars','ns','nstark']
funcEnums = ['J(Q,y) - Additive Approach']
funcEnums = [funcEnums,'J(Q,y) - Convolution Approach']
funcEnums = [funcEnums,'J(Q,y) - Conv. Appr. + model n(k)']
funcEnums = [funcEnums,'J(Q,s) - Conv. Approach']
funcEnums = [funcEnums,'J(Q,s) - Conv. Appr. + model n(k)']
funcEnums = [funcEnums,'R(Q,s) - Final State function']
funcEnums = [funcEnums,'R(Q,y) - Final State function']
funcEnums = [funcEnums,'f(s) - Peaking function']
funcEnums = [funcEnums,'n*(s) - uncondensed atoms']
funcEnums = [funcEnums,'n(s) - full']
funcEnums = [funcEnums,'n*(k) - uncondensed atoms']

Self.funcFlag = 8
Self->RegisterProperty, 'funcFlag', enumlist=funcEnums, name='Function', description='Function'

Self->RegisterProperty, 'AACompFlag', enumlist=['All Components' $
                       ,'Gaussian Comp.' $
                       ,'First FS Comp.' $
                       ,'Gaussian Correction Comp.' $
                       ,'Second FS Comp.'] $
                       , name='AA Component', hide=1
Self->RegisterProperty, 'sf', /float, name='Scale Factor', hide=1
Self->RegisterProperty, 'QQ', /float, name='Momentum Transfer [AA^(-1)]', hide=1
Self->RegisterProperty, 'mass', /float, name='Rel atomic mass', hide=1
Self->RegisterProperty, 'kc', /float, name='kc [AA^(-1)]', hide=1
Self->RegisterProperty, 'n0', /float, name='Condensate fraction', hide=1
Self->RegisterProperty, 'Temp', /float, name='Temperature [K]', hide=1
Self->RegisterProperty, 'alpha2', /float, name='alpha2 [AA^(-2)]', hide=1
Self->RegisterProperty, 'abar3', /float, name='abar3 [AA^(-2)]', hide=1
Self->RegisterProperty, 'abar4', /float, name='abar4 [AA^(-2)]', hide=1
Self->RegisterProperty, 'alpha4', /float, name='alpha4 [AA^(-4)]', hide=1
Self->RegisterProperty, 'abar52', /float, name='abar52 [AA^(-2)]', hide=1
Self->RegisterProperty, 'abar64', /float, name='abar64 [AA^(-4)]', hide=1
Self->RegisterProperty, 'alpha6', /float, name='alpha6 [AA^(-6)]', hide=1
Self->RegisterProperty, 'u2', /float, name='u2 [AA^(-2)]', hide=1
Self->RegisterProperty, 'u3', /float, name='u3 [AA^(-3)]', hide=1
Self->RegisterProperty, 'u4', /float, name='u4 [AA^(-4)]', hide=1
Self->RegisterProperty, 'u5', /float, name='u5 [AA^(-5)]', hide=1
Self->RegisterProperty, 'u6', /float, name='u6 [AA^(-6)]', hide=1
Self->RegisterProperty, 'smin',/float,name='s minimum required', hide=1
Self->RegisterProperty, 'smax',/float,name='s maximum required', hide=1
Self->RegisterProperty, 'sint',/float,name='s interval required', hide=1
Self->RegisterProperty, 'kmin',/float,name='k minimum required', hide=1
Self->RegisterProperty, 'kmax',/float,name='k maximum required', hide=1
Self->RegisterProperty, 'kint',/float,name='k interval required', hide=1
Self->RegisterProperty, 'ymin',/float,name='y minimum required', hide=1
Self->RegisterProperty, 'ymax',/float,name='y maximum required', hide=1
Self->RegisterProperty, 'yint',/float,name='y interval required', hide=1
Self->RegisterProperty, 'blank',/string,name=''
Self->RegisterProperty, 'overplotFlag',enumlist=['No','Yes'],name='Overplot?'

; associate params with functions in a hash
Self.funcNames = list()
Self.funcNames->Add, funcNames, /extract

funcParams = hash()
funcParams[funcNames[0]] = ['AACompFlag','sf','QQ','alpha2','abar3','alpha4','abar52','ymin','ymax','yint']
funcParams[funcNames[1]] = ['sf','u2','u3','u4','u5','u6','ymin','ymax','yint']
funcParams[funcNames[2]] = ['sf','QQ','kc','mass','Temp','n0','alpha2','abar3','alpha4','abar52','abar64','alpha6','ymin','ymax','yint']
funcParams[funcNames[3]] = ['sf','u2','u3','u4','u5','u6','smin','smax','sint']
funcParams[funcNames[4]] = ['sf','QQ','kc','mass','Temp','n0','alpha2','abar3','alpha4','abar52','abar64','alpha6','smin','smax','sint']
funcParams[funcNames[5]] = ['sf','QQ','abar3','abar52','abar64','smin','smax','sint']
funcParams[funcNames[6]] = ['sf','QQ','abar3','abar52','abar64','ymin','ymax','yint']
funcParams[funcNames[7]] = ['sf','kc','mass','Temp','smin','smax','sint']
funcParams[funcNames[8]] = ['sf','kc','mass','Temp','n0','alpha2','alpha4','alpha6','smin','smax','sint']
funcParams[funcNames[9]] = ['sf','kc','mass','Temp','n0','alpha2','alpha4','alpha6','smin','smax','sint']
funcParams[funcNames[10]] = ['sf','kc','mass','Temp','n0','alpha2','alpha4','alpha6','kmin','kmax','kint']
allParams = ['AACompFlag','sf','QQ','kc','mass','Temp','n0','alpha2','abar3','abar4','alpha4','abar52','abar64','alpha6'] 
allParams = [allParams,'u2','u3','u4','u5','u6','smin','smax','sint','ymin','ymax','yint','kmin','kmax','kint']
funcParams['ALL'] = allParams
Self.funcParams = funcParams

;Self.funcParams = hash()
;Self.funcParams[funcNames[0]] = ['AACompFlag','sf','QQ','alpha2','abar3','alpha4','abar52','ymin','ymax','yint']
;Self.funcParams[funcNames[1]] = ['sf','u2','u3','u4','u5','u6','ymin','ymax','yint']
;Self.funcParams[funcNames[2]] = ['sf','QQ','kc','mass','Temp','n0','alpha2','abar3','alpha4','abar5','abar64','alpha6','ymin','ymax','yint']
;Self.funcParams[funcNames[3]] = ['sf','QQ','abar3','abar52','abar64','smin','smax','sint']
;Self.funcParams[funcNames[4]] = ['sf','QQ','abar3','abar52','abar64','ymin','ymax','yint']
;Self.funcParams[funcNames[5]] = ['sf','kc','mass','Temp','smin','smax','sint']
;Self.funcParams[funcNames[6]] = ['sf','kc','mass','Temp','n0','alpha2','alpha4','alpha6','smin','smax','sint']
;Self.funcParams[funcNames[7]] = ['sf','kc','mass','Temp','n0','alpha2','alpha4','alpha6','smin','smax','sint']
;Self.funcParams[funcNames[8]] = ['sf','kc','mass','Temp','n0','alpha2','alpha4','alpha6','kmin','kmax','kint']
;allParams = ['AACompFlag','sf','QQ','kc','mass','Temp','n0','alpha2','abar3','abar4','alpha4','abar52','abar64','alpha6'] 
;allParams = [allParams,'u2','u3','u4','u5','u6','smin','smax','sint','ymin','ymax','yint','kmin','kmax','kint']
;Self.funcParams['ALL'] = allParams

; Update props to reflect default selected function
; ie only unhide function parameters for the selected function
showParams = funcParams[funcNames[Self.funcFlag]] ;Self.funcParams[funcNames[Self.funcFlag]]
np = n_elements(showParams)
for i = 0, np-1 do Self->SetPropertyAttribute, showParams[i], hide=0
Self.sf = 1.0
Self.QQ = 25.0
Self.mass = 4.0026
Self.kc = 0.5
Self.n0 = 0.07
Self.Temp = 1.60
Self.alpha2 = 0.897
Self.alpha4 = 0.46
Self.alpha6 = 0.38
Self.abar3 = 2.43
Self.abar4 = 0.0
Self.abar52 = 2558.0
Self.abar64 = 215.0
Self.ymin = -6.0
Self.ymax = 6.0
Self.yint = 0.1
Self.smin = 0.0
Self.smax = 6.0
Self.sint = 0.1
Self.kmin = 0.0
Self.kmax = 4.0
Self.kint = 0.1
Self.u2 = 0.897
;Self.u4 = 0.46
;Self.u6 = 0.4
Self.u3 = 0.1
Self.u4 = 0.46
Self.u5 = 0.1
Self.u6 = 0.4

Self.oPSet = obj_new('IDLitParameterSet',name='Calculation',description='Calculation',type='Calc')
; Add to the data manager
Self->AddByIdentifier, 'Sample Data Manager', Self.oPSet

; Independent data
oX = IDLitData(name='X',type='IDLVECTOR')
oX->AddMetaData,'Long_name','Independent Values'
oX->AddMetaData,'Units',''
; Error in Dependent data
oErr = IDLitData(name='Error',type='IDLVECTOR') ; NULL data to start
oErr->AddMetaData,'Long_name','Error'
oErr->AddMetaData,'Units',''
; Dependent data
oY = IDLitData(name='Y',type='IDLVECTOR')  ; NULL data to start
oY->AddMetaData,'Long_name','Dependent Values'
oY->AddMetaData,'Units',''
oY->AddMetaData,'Signal', 1

Self.oPSet->Add, [oX,oY,oErr], parameter_name=['X','Y','Error']


Self->SetPropertyAttribute, 'NAME', /hide
Self->SetPropertyAttribute, 'DESCRIPTION', /hide
Self.projName = ''

;; Finally, set the prompt property to 1 meaning display a warning dialog
;; before deleting this tool
Self.prompt = 0
Self.promptDesc = 'GenQF Function Evaluation Tool'
Self.promptTitle = 'Delete Window?'

return, 1

end


;-------------------------------------------------------------------------
; GenQFTool::SaveVisProps
;+
; Purpose:
;    Retrieve the curent vis properties and save them
;
; Parameters:
;    oVis     - The visualization whose properties are to be saved
;    
;-
pro GenQFTool::SaveVisProps, oVis
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'GenQFTool::SaveVisProps: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

;; store the vis props
vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
        ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
        ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']

nTags = n_elements(vTags)
etc = []
for i=0, nTags-1 do begin
   status = oVis->GetPropertyByIdentifier(vTags[i], value)
   if (status) then etc = create_struct(etc,vTags[i],value)
endfor
Self->SetProperty, _EXTRA=etc

;; store the axes props
vTags = ['font_name','font_size','text_color']
nTags = n_elements(vTags)
oDataSpace = oVis->GetDataSpace()
oAxes = oDataSpace->GetAxes(count=naxes)
etc = []
for i=0, nTags-1 do begin
   status = oAxes[0]->GetPropertyByIdentifier(vTags[i], value)
   if (status) then etc = create_struct(etc,vTags[i],value)
endfor
Self->SetProperty, _EXTRA=etc   

end




;-------------------------------------------------------------------------
; GenQFTool::customizeVis
;+
; Purpose:
;    Customize a newly created visualization using attributes obtained from the tool
;
; Parameters:
;    oVis     - The visualization to be customized
;    
;    plotname - a string name to be used to identify the visualization
;-
pro GenQFTool::CustomizeVis, oVis, plotName, plotDesc
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'wd_GenQFTool_customizeVis: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

;; Set the vis props
vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
        ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
        ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
nTags = n_elements(vTags)
etc = []
for i=0, nTags-1 do begin
   status = Self->GetPropertyByIdentifier(vTags[i], value)
   if (status) then etc = create_struct(etc,vTags[i],value)
endfor

if (float((strtok(!version.release,/extract))[0]) lt 8.0) then begin
   ; workaround for bug in IDL 7.1 or lower; use_default_color is not honoured for errorbar_color
   if (etc.use_default_color eq 1) then etc.errorbar_color = etc.color
endif

oVis->SetProperty, name=strupcase(plotName), description=plotDesc, _EXTRA=etc
oVis->SetPropertyAttribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account

;; Set the axes props
Self->GetProperty, overPlotFlag = overPlotFlag
if  (~overPlotFlag) then begin
  vTags = ['font_name','font_size','text_color']
  nTags = n_elements(vTags)
  oDataSpace = oVis->GetDataSpace()
  oDataSpace->Scale, 0.87,1.1,1
  oDataSpace->Translate, 0.12, 0.0, 0.0
  oAxes = oDataSpace->GetAxes(count=naxes)
  etc = []
  for i=0, nTags-1 do begin
     status = Self->GetPropertyByIdentifier(vTags[i], value)
     if (status) then etc = create_struct(etc,vTags[i],value)
  endfor
  for i=0,naxes-1 do oAxes[i]->SetProperty, _EXTRA=etc   
endif

end



;---------------------------------------------------------------------------
; GenQFTool::InitPreferences
;
; Purpose:
;   This method
;
pro GenQFTool::InitPreferences
compile_opt idl2

; Init working and data directory from the DAVETool values
daveTool = Self.daveTool
if (obj_valid(daveTool) and obj_isa(daveTool,'DAVETool')) then begin
   daveTool->GetProperty, data_directory=datDir, working_directory=workDir
   Self->SetProperty, data_directory=datDir, working_directory=workDir
endif

; Retrieve user settings on disk and initialise current session
status = GenQFPreferences(preferences)
if (status) then Self->SetProperty, preferences=preferences

Self->refreshPropertySheet

; Update title to reflect session name
; setting tool_filename generates a callback on the registered UI callback
Self->SetProperty, tool_filename=Self.projName

; Retrieve the graphics window
; and set auto-resize and zoom-on-resize to 1 so the graphics window behaves properly when its size is changed
oWin = Self->Getcurrentwindow()
oWin->Setproperty, auto_resize=1, zoom_on_resize=1

if (float((strtok(!version.release,/extract))[0]) ge 8.0) then begin
   ; For IDL 8.0 and newer, a title text is added to the graphics by default
   ; Customize it!

   idText = iGetID('*title*',tool=Self)
   oText = Self->GetByIdentifier(idText[0])
   if (isa(oText,'IDLitvisText')) then oText->setProperty, hide=0
   ;oWin = Self->GetCurrentWindow()
   ;oScene = oWin->GetScene()
   ;oView = oScene->GetCurrentView()
   ;atoms = oView->GetAll(count=natoms)
   ;for i=0,natoms-1 do begin
   ;   if (obj_isa(atoms[i],'IDLitvisText')) then atoms[i]->setProperty, hide=1
   ;endfor
   Self->RefreshCurrentWindow
endif

end


;---------------------------------------------------------------------------
; GenQFTool::resetPreferences
;
; Purpose:
;   This method
;
function GenQFTool::ResetPreferences
compile_opt idl2


; Retrieve user settings on disk and initialise current session
status = GenQFPreferences(preferences,/reset)
if (status) then Self->SetProperty, preferences=preferences


Self->refreshPropertySheet

end


;---------------------------------------------------------------------------
; GenQFTool::EditUserDefProperty
;
; Purpose:
;   This method
;
function GenQFTool::EditUserDefProperty, oTool, PropID
compile_opt idl2

;; The API requires the oTool arg. It is redundant here since it is Self!

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

case PropID of
;  'CALIBPARAMSBASEFILENAME': begin
;    status = Self->loadCalibParams()
;  end

   
  else:
endcase

Self->refreshPropertySheet

return, 1
end


;---------------------------------------------------------------------------
; GenQFTool__Define
;
; Purpose:
;   This method defines the GenQFTool class.
;
pro GenQFTool__Define
compile_opt idl2

bkgdSubVars = ['Not Applicable','A1','A2','A3','A4','A5','A6','H','K','L','E','Ei','Ef','Temp','Magfield']
void = { GenQFTool,                 $
         inherits IDLitTool        $   ; Provides iTool interface
         ,dataDir:''               $   ; data directory (Note: working_directory is defined by the base class
;         ,nSamp:0                  $   ; nos of valid Sample datasets
;         ,nBkgd:0                  $   ; nos of valid bkgd datasets
;;         ,nFast:0                  $   ; nof of valid fast bkgd datasets
         ,sampContRef:obj_new()    $   ; container for Sample datasets
;         ,bkgdContRef:obj_new()    $   ; container for bkgd datasets
;;         ,fastContRef:obj_new()    $   ; container for fast bkgd datasets
;         ,sampSelected:obj_new()   $   ; most recent selection from samp datasets
;         ,bkgdSelected:obj_new()   $   ; most recent selection from bkgd datasets
;;         ,fastSelected:obj_new()   $   ; most recent selection from fast datasets
;         ,oPlotBkgdFlag:0          $
         ,DAVETool:obj_new()       $   ; DAVETool object
         ,projName:''              $   ; name of current project
         ,nameTag:''               $   ; Tag to be used for identification purposes
         ,prompt:1                 $
         ,promptTitle:''           $
         ,promptDesc:''            $
;;         ,mev2wnos:8.065541        $   ; meV to wavenumber conversion factor
;;         ,nActiveDetectors:50      $   ; nos of active detectors
;;         ,energyUnitFlag:0         $   ; energy unit flag 0=meV, 1=cm-1
;         ,sumSampFlag:0            $   ; sum multiple sample files? 0=no, 1=yes
;         ,sumBkgdFlag:0            $   ; sum multiple bkgd files? 0=no, 1=yes
;         ,maskFlag:0               $
;         ,maskedDets:''            $   ; masked detectors (stored as a string)
;         ,latParamFlag:0           $   ; Use lattice parameter from: 0:raw data file 1:user specified
;;         ,qUnits:0                 $   ; Units for QX, QY variables: 0->1/A, 1->r.l.u
         ,xAxisVar:0               $   ; Variable to plotted as the x-axis
         ,yAxisVar:0               $   ; variable to be plotted as the y-axis
;         ,indepVars1Ptr:ptr_new()  $   ; list of valid sxtal independent variables ('QX','QY','E','|Q|','TEMP','MAGFIELD')
;         ,indepVars2Ptr:ptr_new()  $   ; list of valid powder x-axis independent variables ('2THETA','Q','DSPACE','TEMP','MAGFIELD','DATAPOINT')
;         ,indepVars3Ptr:ptr_new()  $   ; list of valid powder y-axis independent variables ('2THETA','Q','DSPACE')
;         ,exportIndex1Ptr:ptr_new() $   ; index specifying items in indepVars1Ptr to be exported
;         ,exportIndex2Ptr:ptr_new() $   ; index specifying items in indepVars2Ptr to be exported
;         ,exportIndex3Ptr:ptr_new() $   ; index specifying items in indepVars3Ptr to be exported
;         ,rawModesPtr:ptr_new()    $   ; list of possible viewing modes when Samp type is set to 'Raw Data'
;         ,latticeParameters:''     $   ; lattice parameters
;         ,monScaleValue:1.0        $   ; user specified mon scale factor
;         ,detailedBalanceFlag:0    $   ; apply detailed balance correction 1=yes, 0=no
;         ,bkgdFlag:0               $   ; subtract bkgd data  1=yes, 0=no
;         ,bkgdSubVarFlag:0        $   ; a key variable used to determine if a signal and bkgd dataset pair match for bkgd subtraction
;         ,bkgdSubVars:bkgdSubVars   $   ; unum lists of vars that can be used for pairing signal ad bkgd datasets - used by bkgdSubVarsFlag
;         ,bkgdSubVarTol:0.0       $   ; a tolerance threshold used to determine if two bkgdSubVar values match
;         ,fastFlag:0               $   ; apply fast bkgd correction? 1=yes, 0=no
;         ,fastValue:0.0            $   ; fast bkgd level in cnts/min
;         ,resCorFlag:0             $   ; apply resolution volume correction ? 1=yes, 0=no
;         ,monCorFlag:0             $   ; apply monitor correction (due to energy dependent change to incident flux)? 1=yes, 0=no
;         ,normalizeTo:0            $   ; normalize counts to: 0: Monitor, 1:Counting Time, 2: Nothing
         ,funcFlag:0           $   ; sample type: 1:single crystal, 0:powder
         ,prefsPtr:ptr_new()       $   ; points to preference structure
         ,historyPtr:ptr_new()     $
         ,modifiedFlag:0B          $   ; determines modification state of tool - unsufficient control over _bDirty property!
         ,dataVersion:0            $   ; current version number for dataset structure
;         ,ftpObject:obj_new()      $   ; DAVEftpURL() object used to access data on ftp://ftp.ncnr.nist.gov/pub/ncnrdata/
;         ,calibParamsFilename:''   $
;         ,calibParamsBaseFilename:'' $
;         ,calibParamsIsSet:0       $
;         ,chDelA4:fltarr(48)       $   ; Channel A4 deltas
;         ,chDelEf:fltarr(48)       $   ; Channel Ef deltas (or maybe just Channel Ef)
;         ,chEff:fltarr(48)         $   ; Channel efficiencies
;         ,effNormFlag:0            $
;         ,minBinWidth:0.01         $   ; user specified current bin width
;         ,binWidths:fltarr(7)      $   ; initial bin widths for various powder scan variables
         ,defaultIntensityFlag:0   $   ; use default intensity range 1 = yes, 0 = no
         ,maxIntensity:0.0         $
         ,minIntensity:0.0         $
;         ,phiOffset:0.0            $   ; A3 Correction or Phi Offset
         ,logFlag:0                $   ; use linear (0) or log (1) intensity scale
;         ,lolim:0                  $   ; low limit of range to sum (raw mode)
;         ,hilim:0                  $   ; high limit of range to sum (raw mode)
;         ,ConstBinFlag:0           $   ; Enforce constant bin width for powder data when rebinning
;         ,useTempAverageFlag:0     $   ; when set, take the everage temperature of the scan as the temperature at each point in the scan
;         ,minChan:0                $
;         ,maxChan:0                $
;         ,minDPnt:0                $
;         ,maxDPnt:0                $
;         ,dpntIndex:0              $
;         ,pMinDPnt:ptr_new()       $
;         ,pMaxDPnt:ptr_new()       $
;         ,pDpntIndex:ptr_new()     $      
;         ,sharedSettingsFlag:0     $
;         ,settingIndex:0           $

         ,sf:0.0                   $
         ,AACompFlag:0             $
         ,QQ:0.0                   $
         ,mass:0.0                 $
         ,kc:0.0                   $
         ,n0:0.0                   $
         ,Temp:0.0                 $
         ,alpha2:0.0               $
         ,alpha4:0.0               $
         ,alpha6:0.0               $
         ,abar3:0.0                $
         ,abar4:0.0                $
         ,abar52:0.0               $
         ,abar64:0.0               $
         ,u2:0.0                   $
         ,u3:0.0                   $
         ,u4:0.0                   $
         ,u5:0.0                   $
         ,u6:0.0                   $
         ,smin:0.0                 $
         ,smax:0.0                 $
         ,sint:0.0                 $
         ,ymin:0.0                 $
         ,ymax:0.0                 $
         ,yint:0.0                 $
         ,kmin:0.0                 $
         ,kmax:0.0                 $
         ,kint:0.0                 $
         ,funcParams:hash()        $
         ,funcNames:list()         $
         ,funcs:ptr_new()          $
         ,oPSet:obj_new()          $
         ,overplotFlag:0           $
         
;         ,ekFac:2.072194           $   ; Energy = ekFac * k^2
;         ,objMslice:obj_new()      $   ; place holder for Mslice object
;         ,multipleMsliceWinFlag:0  $   ; should multiple mslice windows be created?
;         ,mergeChannelsFlag:0      $   ; (powder) whether (1) or not (0) to combine PSD channels
;         ,sxtalOnlyPropsPtr:ptr_new() $   ;
;         ,powderOnlyPropsPtr:ptr_new() $  ;
;         ,sxtalPowderPropsPtr:ptr_new() $
;         ,rawOnlyPropsPtr:ptr_new()    $
         ,errorbar_capsize:    0.1 $
         ,transparency:        50 $
         ,antialias:           3 $
         ,color:               [0,0,255] $
         ,errorbar_color:      [0,0,255] $
         ,use_default_color:   1   $
         ,sym_increment:       1   $
         ,sym_index:           4   $
         ,sym_size:            1.0   $          ; 
         ,sym_color:           [0,0,255] $   ;
         ,sym_thick:           1.0 $            ;
         ,y_errorbars:         1 $              ; show y errors
         ,linestyle:           0 $              ; 
         ,nsum:                1 $              ; no point everaging
         ,thick:               2.0 $            ; line thickness
         ,sym_filled:          1   $            ; use filled symbols
         ,sym_fill_color:      [0,0,255] $   ; symbol fill color
         ,font_name:           'Helvetica'  $   ;
         ,font_size:           13 $             ;
         ,text_color:          [0,0,0]  $    ;

       }
end
