function getangle2hkl,hkl1,hkl2,latparm=latparm,degree=degree

;calculates angle between two HKL = [h,k,l] vectors

if n_elements(latparm) eq 0 then latparm=[2*!pi,2*!pi,2*!pi,90.,90.,90.]

v1 = HKLnorm(hkl1,latparm=latparm)
v2 = HKLnorm(hkl2,latparm=latparm)
v12 = HKLnorm(hkl1-hkl2,latparm=latparm)

tmp = chop(acos((v1^2+v2^2-v12^2)/(2*v1*v2)))

if keyword_set(degree) then return,tmp/!dtor else return,tmp

end