; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the DAVETool.
;
; CATEGORY:
;   DAVE Main Tool

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2004
;-
;###############################################################################





;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the FANSTool.
;
; CATEGORY:
;   FANS Reduction

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of FANSTool object
;
pro fans,  identifier=identifier, group_leader=gl, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

;Okay, launch the Main Tool
title = "FANS Data Reduction"
identifier = IDLITSYS_CREATETOOL("FANSMain", name="Preferences" $
                                 ,title=title $ ;  ,/debug
                                 ,dimensions=[700,530] $
                                 ,USER_INTERFACE="FANS Main Interface" $
                                )

oSystem = oDaveTool->GetSystem()
oFANSTool = oSystem->GetByIdentifier(identifier)

; Make widget hierarchy with this tool a child of the DAVETool
oFANSUI = oFANSTool->GetUI()
oFANSUI->GetProperty, group_leader=wFANSTLB
widget_control, wFANSTLB, group_leader=gl

; Set system preferences
oFANSTool->SetProperty, DAVETool=oDAVETool $
                      ,data_directory=dataDir $
                      ,working_directory=workDir $
                      ,name = 'Preferences'  ; b/c want the property sheet in main window to have this label
if (obj_valid(oFANSTool)) then  oFANSTool->InitPreferences

end
