; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEtool
;
; PURPOSE:
;   This file implements the non-interactive core of the DAVE application
;
; CATEGORY:
;   DAVE Main Tool
;
; SUPERCLASSES:
;   IDLitTool
;
; SUBCLASSES:
;
; CREATION:
;   See DAVEtool::Init
;
; METHODS:
;   AddDavePtrToDataManager
;   DelDAVEDataManagerContents
;   DelSystemDataManagerContents
;   DelVisTools
;   GetDaveDataManagerContents
;   GetStatePtr
;   GetSelectedData
;   GetSystem
;   GetSystemDataManagerContents
;   GetUI
;   SetVisToolObjRefs
;   GetVisToolObjRefs
;   SetVisIDCount
;   GetVisIDCount
;   MenuLayout
;   ModifyComponents
;   SetPreferences
;
; INTERFACES:
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2005
;-
;###############################################################################


;===============================================================================
; DAVEtool::MenuLayout
; 
; PURPOSE:
;   Specify custom menu layout (containers and items) for the
;   tool. Note that user interface itself is not created here as this
;   is done elsewhere.  
;
; PARAMETERS
;
; KEYWORDS:
;

function DAVETool::MenuLayout

xmlfile = file_which(!DAVE_AUXILIARY_DIR,'davemenus.xml')
doc = OBJ_NEW('IDLffXMLDOMDocument', filename=xmlfile)

; Ensure document has the "dave2_menu" element
element = doc->GetElementsByTagName("dave2_menu")
if (~obj_valid(element) || (element->GetLength() lt 1)) then return, 0

; Retrieve "folder" elements and create folders
foldList = doc->GetElementsByTagName("folder")
nFold = foldList->GetLength()

i = 0
while (nFold-- gt 0) do begin
   folder = foldList->Item(i++)
   attributeList = folder->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      identifier = ''
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'IDENTIFIER': identifier = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor

      if (strlen(identifier) gt 0) then self->CreateFolders, identifier, _EXTRA=etc
      
   endif
endwhile


; Retrieve "menu" elements and define application menu structure
menuList = doc->GetElementsByTagName("menu")
nMenu = menuList->GetLength()

i = 0
while (nMenu-- gt 0) do begin
   menu = menuList->Item(i++)
   attributeList = menu->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      types = ''
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'CLASS': class = attValue
            'TYPES': types = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      if (strlen(name) gt 0) then self->RegisterOperation, name, class, _EXTRA=etc

      void = where(tag_names(etc) eq 'IDENTIFIER',idPresent)
      if ((strlen(types) gt 0) && idPresent) then begin
         ;; Add the types property.
         ;; It since this mst be handled this way rather than set directly suring
         ;; the RegisterOperation call above! Perhaps a bug in rge resistration code?
         identifier = etc.identifier
         toks = strsplit(identifier,'/',/extract)
         identifier = (strcmp(toks[0],'Operations',/fold_case))? identifier : 'Operations/'+identifier

         objDesc = self->GetByIdentifier(identifier)
         if (obj_valid(objDesc)) then objDesc->SetProperty, types=strsplit(types,',',/extract)
      endif
      
   endif
endwhile


; Retrieve "toolbar" elements and define toolbar entries
tbarList = doc->GetElementsByTagName("toolbar")
ntbar = tbarList->GetLength()

i = 0
while (ntbar-- gt 0) do begin
   tbar = tbarList->Item(i++)
   attributeList = tbar->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      self->Register, name, _EXTRA=etc      
   endif
endwhile

obj_destroy, doc


return, 1
end





;function DAVEtool::MenuLayout
;compile_opt idl2
;
;;---------------------------------------------------------------------
;; Create the main containers that define the top-level 'directory'
;; hierarchy of the public interface of the Main Tool.
;; These are all created underneath the folder
;;      /Tools/DAVEMAIN/
;self->CreateFolders,['Operations/File' $
;                     ,'Operations/Edit' $ ; <-- NB: an Edit menu will not be included!
;                     ,'Operations/DataRed' $
;                     ,'Operations/DataIO' $
;                     ,'Operations/Visualization' $
;                     ,'Operations/Analysis' $
;                     ,'Operations/MiscTools' $
;                     ,'Operations/   ' $
;                     ,'Operations/Help' ]
;
;; Use a more sensible name for Data containers.
;oContainer = self->GetByIdentifier('Operations/DataRed')
;oContainer->SetProperty, name='Data Reduction'
;oContainer = self->GetByIdentifier('Operations/DataIO')
;oContainer->SetProperty, name='Data Input/Output'
;; Use a more sensible name for MiscTools container.
;oContainer = self->GetByIdentifier('Operations/MiscTools')
;oContainer->SetProperty, name='Tools' 
;
;
;
;
;
;
;
;;;---------------------------------------------------------------------
;;;*** File Menu Container
;self->RegisterOperation, 'Open Project', 'DAVEopFileOpen' $ 
;  ,DESCRIPTION='Open an existing DAVE project' $
;  ,IDENTIFIER='File/Open', ICON='open', readerNames='DAVE Project'
;
;
;;-----------------
;self->RegisterOperation, 'Save Project','DAVEopProjectSave',IDENTIFIER='File/Save' $
;  ,icon='save',description='Save current DAVE Project',writerTypes='DAVEISV'
;
;self->RegisterOperation, 'Save Project As','DAVEopProjectSaveAs',IDENTIFIER='File/SaveAs' $
;  ,icon='save',description='Save current DAVE Project',writerTypes='DAVEISV'
;
;
;
;self->Createfolders,'Operations/File/Macros', $
;                    NAME=IDLitLangCatQuery('Menu:Operations:Macros')
;
;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:RunMacro'), $
;  PROXY='/Registry/MacroTools/Run Macro', $
;  IDENTIFIER='File/Macros/Run Macro'
;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:StartRecording'), $
;  PROXY='/Registry/MacroTools/Start Recording', $
;  IDENTIFIER='File/Macros/Start Recording'
;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:StopRecording'), $
;  PROXY='/Registry/MacroTools/Stop Recording', $
;  IDENTIFIER='File/Macros/Stop Recording'
;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:MacroEditor'), $
;  PROXY='/Registry/MacroTools/Macro Editor', $
;  IDENTIFIER='File/Macros/Macro Editor'
;
;self->RegisterOperation, 'Preferences...','DAVEopBrowserPrefs' $
;  ,IDENTIFIER='File/Preferences',/SEPARATOR
;
;;-----------------
;self->RegisterOperation, 'Exit','IDLitopFileExit',IDENTIFIER='File/Exit',/SEPARATOR
;
;
;
;
;
;;;---------------------------------------------------------------------
;;; File Toolbar Container.
;self->Register, 'Open Project', proxy='Operations/File/Open' $
;                ,identifier='Toolbar/File/Open'
;self->Register, 'Save Project', proxy='Operations/File/Save' $
;                ,identifier='Toolbar/File/Save'
;
;
;;;---------------------------------------------------------------------
;;; Edit Container
;;; An Edit menu will not be created!
;;; However, the Undo/Redo operations have to be reg since other iTools
;;; framework components assumme their availablility.
;self->RegisterOperation,'Undo','IDLitopUndo' $
;  ,ACCELERATOR='Ctrl+Z' $
;  ,IDENTIFIER='Edit/Undo', ICON='undo', /disable,/IGNORE_AVAILABILITY
;
;self->RegisterOperation,'Redo','IDLitopRedo' $
;  ,ACCELERATOR='Ctrl+Y' $
;  ,IDENTIFIER='Edit/Redo', ICON='redo',/disable,/IGNORE_AVAILABILITY
;
;
;
;
;;;---------------------------------------------------------------------
;;; Edit Toolbar
;self->Register, 'Undo',proxy='Operations/Edit/Undo' $
;                ,identifier='Toolbar/Edit/Undo'
;self->Register, 'Redo',proxy='Operations/Edit/Redo' $
;                ,identifier='Toolbar/Edit/Redo'
;
;;;---------------------------------------------------------------------
;;;*** Reduction Container
;
;;; Note: registerOperations() prepends a 'Operations/' to the
;;; specified identifier.
;
;;; NCNR Instruments--------
;self->Createfolders,'Operations/DataRed/NCNR', name='NCNR'
;self->RegisterOperation,'DCS...','DAVEopLaunchApp',identifier='DataRed/NCNR/DCS Reduction'
;self->RegisterOperation,'FANS...','DAVEopLaunchApp',identifier='DataRed/NCNR/FANS Data Reduction'
;self->RegisterOperation,'HFBS...','DAVEopLaunchApp',identifier='DataRed/NCNR/HFBS Reduction'
;self->RegisterOperation,'NSE...','DAVEopLaunchApp',identifier='DataRed/NCNR/NSE Reduction'
;self->RegisterOperation,'TAS...','DAVEopLaunchApp',identifier='DataRed/NCNR/TAS Reduction'
;
;self->createfolders,'Operations/DataRed/PSI', name='PSI'
;
;
;
;
;;;---------------------------------------------------------------------
;;;*** Data Input/Outout Container
;
;;; Data Input----------
;self->Createfolders,'Operations/DataIO/Read', name='Read Dataset From'
;
;self->RegisterOperation, 'ASCII (txt,spe,...)', 'DAVEopFileOpen', ICON='open' $
;  ,DESCRIPTION='Open ASCII file(s)',IDENTIFIER='DataIO/Read/ASCII',readerNames='ASCII text'
;
;self->RegisterOperation, 'DAVE 1.x', 'DAVEopFileOpen', ICON='open' $
;  ,DESCRIPTION='Open DAVE 1.x file(s)',IDENTIFIER='DataIO/Read/READDAVE1',readerNames='DAVE1x'
;
;;; Data Output----------
;self->createfolders,'Operations/DataIO/Write', name='Write Dataset As'
;
;self->RegisterOperation, 'DAVE 1.x','DAVEopFileSave',IDENTIFIER='DataIO/Write/WRITEDAVE1' $
;  ,icon='save',description='Save selected dataset using DAVE 1.x format',writerTypes='DAVE1x'
;
;self->RegisterOperation, 'ASCII Column','DAVEopFileSave',IDENTIFIER='DataIO/Write/WRITEASCIICOL' $
;  ,icon='save',description='Save selected dataset using ASCII Column format',writerTypes='ASCIICOL'
;
;self->RegisterOperation, 'ASCII Group','DAVEopFileSave',IDENTIFIER='DataIO/Write/WRITEASCIIGRP' $
;  ,icon='save',description='Save selected dataset using ASCII Group format',writerTypes='ASCIIGRP'
;
;self->RegisterOperation, 'ASCII SPE','DAVEopFileSave',IDENTIFIER='DataIO/Write/WRITEASCIISPE' $
;  ,icon='save',description='Save selected dataset using ASCII SPE format',writerTypes='ASCIISPE'
;
;
;
;
;
;;;---------------------------------------------------------------------
;;;*** Analysis Container
;
;; After registration, do the following for each of the data analysis operation:
;; - retrieve the object descriptor 
;; - insert a value for the types property - the types property specifies the 
;;   data types for which the operation can be applied to. Normally, the types
;;   property would be specified in the Init method of the operation class.
;;   However, in an app such as DAVE where new data types are being created, it is
;;   not wise to expect developers to have to modify the operation classes whenever a 
;;   new data type is added. It makes more sense to make the assignment at a single
;;   location like here, during registration.
;
;;; Data Transform folder-------
;self->Createfolders,'Operations/Analysis/DataTrans', name='Data Transform'
;
;self->RegisterOperation, 'Scale','DAVEopDataScale' $
;  ,description='Apply Multiplicative Scalefactor to data' $
;  ,identifier='Analysis/DataTrans/ScaleFactor', ICON='sum'
;objDesc = self->GetByIdentifier('Operations/Analysis/DataTrans/ScaleFactor')
;objDesc->SetProperty, types=['IDLVECTOR','IDLARRAY2D','IDLARRAY3D','IDLIMAGE']
;
;self->RegisterOperation, 'Offset','DAVEopDataOffset' $
;  ,description='Apply Additive offset to data' $
;  ,identifier='Analysis/DataTrans/DataOffset', ICON='sum'
;objDesc = self->GetByIdentifier('Operations/Analysis/DataTrans/DataOffset')
;objDesc->SetProperty, types=['IDLVECTOR','IDLARRAY2D','IDLARRAY3D','IDLIMAGE']
;
;self->RegisterOperation, 'Transpose','DAVEopDataTranspose' $
;  ,description='Transpose dataset (swap independent axes)' $
;  ,identifier='Analysis/DataTrans/Transpose', ICON='sum'
;objDesc = self->GetByIdentifier('Operations/Analysis/DataTrans/Transpose')
;objDesc->SetProperty, types=['DAVE1COMMONSTR','ASCIISPE','ASCIIGRP']
;
;self->RegisterOperation, 'Rebin','DAVEopDataRebin' $
;  ,description='Rebin experimental data' $
;  ,identifier='Analysis/DataTrans/DataRebin', ICON='sum'
;objDesc = self->GetByIdentifier('Operations/Analysis/DataTrans/DataRebin')
;objDesc->SetProperty, types=['DAVE1COMMONSTR','ASCIISPE','ASCIICOL','ASCIIGRP']
;
;subDesc = 'Difference between two datasets taking into account statistical errors. '
;subDesc = subDesc+' Results are stored in first dataset!'
;self->RegisterOperation, 'Subtract','DAVEopDataSubtract', description=subDesc $
;  ,identifier='Analysis/DataTrans/DataSubtract', ICON='sum',/separator
;objDesc = self->GetByIdentifier('Operations/Analysis/DataTrans/DataSubtract')
;objDesc->SetProperty, types=['DAVE1DATASET','ASCIISPE','ASCIICOL','ASCIIGRP']
;
;sumDesc  = 'Sum two or more datasets taking into account statistical errors. '
;sumDesc += 'A choice of algorithms is available. "Simple Sum" simply sums the datasets '
;sumDesc += 'while in "Weighted Sum" an average weighted by the statistical errors is performed.'
;self->RegisterOperation, 'Sum','DAVEopDataSum', description=sumDesc $
;  ,identifier='Analysis/DataTrans/DataSum', ICON='sum'
;objDesc = self->GetByIdentifier('Operations/Analysis/DataTrans/DataSum')
;objDesc->SetProperty, types=['DAVE1DATASET','ASCIISPE','ASCIICOL','ASCIIGRP']
;
;; Add an operations browser
;self->RegisterOperation, 'Operations Browser', 'DAVEopBrowserOperation', $
;  IDENTIFIER='Analysis/Operations Browser', /separator
;
;
;;;---------------------------------------------------------------------
;;;*** Miscellaneous Tools Container
;
;;;---------------------------------------------------------------------
;;;*** Visualization Container
;
;
;
;
;;;---------------------------------------------------------------------
;;;*** Help Container
;
;self->RegisterOperation, "User's Manual", 'DAVEopHelp', $
;  IDENTIFIER='Help/DaveManual',helptopic='HELP_HOMEPAGE'
;;-----------------
;
;self->RegisterOperation, 'Help on Selected Item', 'DAVEopHelp', $
;  IDENTIFIER='Help/HelpSelection'
;self->RegisterOperation, "iTools User's Manual", 'DAVEopHelp', $
;  IDENTIFIER='Help/iToolsManual',helptopic='ITOOLSUSERMANUAL',/separator
;if (~lmgr(/vm) && ~lmgr(/runtime) && ~lmgr(/embedded)) then begin
;    ;; include link to full IDL manual if running from the DE
;    self->RegisterOperation, 'Help on iTools', 'IDLitopHelpiTools' $
;      ,IDENTIFIER='Help/HelpiTools'
;endif
;
;self->RegisterOperation, 'About DAVE', 'DAVEopHelpAbout', $
;  IDENTIFIER='Help/About DAVE',/separator
;
;
;;;---------------------------------------------------------------------
;oFile = self->GetByIdentifier("Operations/File")
;oFile->SetProperty,/Private
;
;return, 1
;
;end

