; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEopLaunchApp
;
; PURPOSE:
;   This file implements an operation that can launch a conventional
;   stand alone application from the DAVE Main Tool. The application
;   is launched using a UI Service for that application module which
;   should have been registered previously with the Main Tool.
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2005
;-
;###############################################################################


;===============================================================================
; DAVEopLaunchApp::init
; 
; PURPOSE:
;   Class initialization method
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopLaunchApp::Init, _REF_EXTRA=extra
compile_opt idl2

if (self->IDLitOperation::Init(_EXTRA=extra) eq 0) then $
  return, 0

return, 1

end


;===============================================================================
; DAVEopLaunchApp::doAction
; 
; PURPOSE:
;   Intantiate an independent application which has been previously
;   registered as a UI Service with the DAVE Main Tool.
;
; PARAMETER:
;   oTool   - The object ref of the tool from which this request originated
;
; KEYWORDS:
;
function DAVEopLaunchApp::DoAction, oTool
compile_opt idl2

;;oSystem = oTool->_GetSystem()
;self->GetProperty, IDENTIFIER=id
;name = STRMID(id, STRPOS(id, '/', /REVERSE_SEARCH) + 1)
;
;;call_procedure,name
;void = oTool->DoUIService(name,self)

;oSystem = oTool->_GetSystem()
self->GetProperty, IDENTIFIER=id
name = STRMID(id, STRPOS(id, '/', /REVERSE_SEARCH) + 1)

;initiate the LaunchApp UI Service
void = oTool->DoUIService('LaunchModule',self)






return, obj_new()

end


;===============================================================================
pro DAVEopLaunchApp__define
compile_opt idl2

struc = {DAVEopLaunchApp,            $
         inherits IDLitOperation    $
        }

end
