;$Id$
;###############################################################################
;
; NAME:
;  DIRAC_DELTA
;
; PURPOSE:
;  Implementation of the Dirac Delta function for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function dirac_delta,x,resolution,center
;RTA - change implementation
;area = int_tabulated(x,resolution)
;delta = resolution/area
;return,interpol(delta,x+center,x)
xRes = resolution.x
zRes = resolution.z

;return, interpol(zRes,xRes+center, x)
nx = n_elements(x)
con = fltarr(nx)                ; init to 0.0
nr = n_elements(xRes)
xr0 = xRes[0]
xrn = xRes[nr-1]
ind1 =  where(x ge xr0+center and x le xrn+center,cnt) ;,complement=ind2,ncomplement=ncnt)
if (cnt gt 0) then con[ind1] = interpol(zRes,xRes+center,x[ind1])

return,con
end
