; $Id$

function Gen_ns, s, aValues=aValues, bValues=bValues, T=T, kc=kc, n0=n0, mass=mass, uncondensedOnlyFlag=uncondensedOnlyFlag
compile_opt idl2

y = 0.0
; Setup default values for various parameters
if (n_elements(T) eq 0) then T = 1.0
if (n_elements(kc) eq 0) then kc=0.5
if (n_elements(Q) eq 0) then Q=25.0
if (n_elements(aValues) ne 3) then begin
  aValues = [0.897,0.46,0.38]
endif
if (n_elements(bValues) ne 3) then begin
  bValues = [0.0,0.0,0.0] ; [2.43,2558.0,215.0]
endif

muPtr = ptr_new({a2:aValues[0],     $         ; [(1/A)**2]
                 b3:bValues[0]/Q,   $         ; [(1/A)**3]
                 a4:aValues[1],     $         ; [(1/A)**4]
                 b4:0.0,            $         ; [(1/A)**4]
                 b5:bValues[1]/Q^3, $         ; [(1/A)**5]
                 a6:aValues[2],     $         ; [(1/A)**6]
                 b6:bValues[2]/Q^2})          ; [(1/A)**6]
if (n_elements(n0) eq 0) then n0=0.07
if (n_elements(B) eq 0 || n_elements(D) eq 0 || n_elements(F) eq 0) then begin
  if (~isa(mass)) then mass = 4.0026           ; rel a. mass of He4
  hbar = 1.0545919        ; *10**(-34) Js
  ec   = 1.6021917        ; *10**(-19) C
  amu  = 1.660531         ; *10**(-27) Kg
  kB   = 1.380622         ; *10**(-23) J/K
  rho  = 0.6022169/27.0   ; 1/A**3         He4 at SVP
  Vs   = 240              ; m/s            He4 at SVP
  B = mass*amu*Vs/(2.0*hbar*(2.0*!pi)^3*rho)/1000.0  ; A**2
  D = hbar*Vs/(2.0*kb*T)/10.0                    ; A
  F = 2.0*kc^2                                     ; (1/A)**2
endif

SQ = 1.0

I0 = Fofs(0.0, nOrder = 1, kc=kc, T=T, B=B, D=D, F=F)  ; 1st moment of fofs i.e. when nOrder=1
A = 1.0 - n0*(1 + I0)

etc = create_struct('y',0.0,'muPtr',muPtr,'n0',n0,'A',A,'kc',kc,'T',T,'B',B,'D',D,'F',F)

; Jqys - the full J(Q,s)
;        alpha*[n0*beta + n0*beta*f + A*gama]
;
; note: y=0 in call to JqyBeta()
if (uncondensedOnlyFlag) then begin
  ; essentially, n0 = 0 and A = 1
  calc = JqyAlpha(s,_Extra=etc)*JqyGamma(s, _Extra=etc)
endif else begin
  calc = JqyAlpha(s,_Extra=etc)*(n0*JqyBeta(s,_Extra=etc)*(1 +  Fofs(s,_Extra=etc)) $
                                + A*JqyGamma(s,_Extra=etc))
endelse

return, calc
  
end

