; $Id$
;###############################################################################
;
; NAME:
;  RMD_MAKEPOINTS
;
; PURPOSE:
;  Creates an array of equally-spaced points over a user-specified range.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;+
; NAME:
;       RMD_MAKEPOINTS
;
; PURPOSE:
;
;       Generates a vector of evenly spaced points between two limits.
;
; AUTHOR:
;
;       Robert M. Dimeo, Ph.D.
;		NIST Center for Neutron Research
;       100 Bureau Drive
;		Gaithersburg, MD 20899
;       Phone: (301) 975-8135
;       E-mail: robert.dimeo@nist.gov
;       http://www.ncnr.nist.gov/staff/dimeo
;
; CATEGORY:
;
;       Mathematics
;
; CALLING SEQUENCE:
;
;       Y = RMD_MAKEPOINTS(XLO = XLO, XHI = XHI, NPTS = NPTS)
;
; INPUT PARAMETERS:
;
;       X -	A numerical vector.
;
; RETURNS:
;
;   A vector of NPTS evenly spaced points between XLO and XHI.
;
;
; INPUT KEYWORDS:
;
;   XLO			-lower limit (default: 0.0)
;	XHI			-upper limit (default: 1.0)
;	NPTS		-number of points in resulting vector (default: 10)
;
; OUTPUT KEYWORDS:
;
;		NONE
;
; REQUIRED PROGRAMS:
;
;       NONE
;
; EXAMPLE
;
;	IDL>	phi = rmd_makepoints(xlo = 0.0,xhi = 360.0,npts = 100)
;	IDL>	plot,phi,cos(phi*!dtor)
;
; MODIFICATION HISTORY:
;
;       Written by Rob Dimeo, September 6, 2002.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function rmd_makepoints,xlo = xlo, $
                        xhi = xhi, $
                        npts = npts

if n_elements(xlo) eq 0 then xlo = 0.0
if n_elements(xhi) eq 0 then xhi = 1.0
if n_elements(npts) eq 0 then npts = 10
dx = (xhi-xlo)/(npts-1.0)
x = xlo+dx*findgen(npts)
return,x
end