; $Id$
;###############################################################################
;
; NAME:
;  PAN_ROUSE_SCALED
;
; PURPOSE:
;  Delta function for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_rouse_scaled,x,parms,$
                     parmnames = parmnames, twoDimFlag=twoDimFlag, initParms=initParms, $
                     resPtr = resPtr,$
                     rlimit = rlimit, $
                     canDraw = canDraw, $
                     drawMessage = drawMessage, $
                     _Extra = extra

canDraw = 0
if n_elements(extra) eq 0 then extra = {dummy:0L}
if n_params() eq 0 then begin
  parmnames = ['A','l2sqrtW']
  twodimflag = 0
  initParms = [1.0,1.0]
  return, -1
endif
A= parms[0] 
l2sqrtW = parms[1]
OmegaR=[0,0.001,0.00102329,0.00104713,0.00107152,0.00109648,0.00112202,0.00114815,0.0011749,0.00120226]
OmegaR=[OmegaR,0.00123027,0.00125893,0.00128825,0.00131826,0.00134896,0.00138038,0.00141254,0.00144544,0.00147911,0.00151356,0.00154882,0.00158489]
OmegaR=[OmegaR,0.00162181,0.00165959,0.00169824,0.0017378,0.00177828,0.0018197,0.00186209,0.00190546,0.00194984,0.00199526,0.00204174,0.0020893]
OmegaR=[OmegaR,0.00213796,0.00218776,0.00223872,0.00229087,0.00234423,0.00239883,0.00245471,0.00251189,0.0025704,0.00263027,0.00269153,0.00275423]
OmegaR=[OmegaR,0.00281838,0.00288403,0.00295121,0.00301995,0.0030903,0.00316228,0.00323594,0.00331131,0.00338844,0.00346737,0.00354813,0.00363078]
OmegaR=[OmegaR,0.00371535,0.00380189,0.00389045,0.00398107,0.0040738,0.00416869,0.0042658,0.00436516,0.00446684,0.00457088,0.00467735,0.0047863]
OmegaR=[OmegaR,0.00489779,0.00501187,0.00512861,0.00524807,0.00537032,0.00549541,0.00562341,0.0057544,0.00588844,0.0060256,0.00616595,0.00630957]
OmegaR=[OmegaR,0.00645654,0.00660693,0.00676083,0.00691831,0.00707946,0.00724436,0.0074131,0.00758578,0.00776247,0.00794328,0.00812831,0.00831764]
OmegaR=[OmegaR,0.00851138,0.00870964,0.00891251,0.00912011,0.00933254,0.00954993,0.00977237,0.01,0.0102329,0.0104713,0.0107152,0.0109648]
OmegaR=[OmegaR,0.0112202,0.0114815,0.011749,0.0120226,0.0123027,0.0125893,0.0128825,0.0131826,0.0134896,0.0138038,0.0141254,0.0144544]
OmegaR=[OmegaR,0.0147911,0.0151356,0.0154882,0.0158489,0.0162181,0.0165959,0.0169824,0.017378,0.0177828,0.018197,0.0186209,0.0190546]
OmegaR=[OmegaR,0.0194984,0.0199526,0.0204174,0.020893,0.0213796,0.0218776,0.0223872,0.0229087,0.0234423,0.0239883,0.0245471,0.0251189]
OmegaR=[OmegaR,0.025704,0.0263027,0.0269153,0.0275423,0.0281838,0.0288403,0.0295121,0.0301995,0.030903,0.0316228,0.0323594,0.0331131]
OmegaR=[OmegaR,0.0338844,0.0346737,0.0354813,0.0363078,0.0371535,0.0380189,0.0389045,0.0398107,0.040738,0.0416869,0.042658,0.0436516]
OmegaR=[OmegaR,0.0446684,0.0457088,0.0467735,0.047863,0.0489779,0.0501187,0.0512861,0.0524807,0.0537032,0.0549541,0.0562341,0.057544]
OmegaR=[OmegaR,0.0588844,0.060256,0.0616595,0.0630957,0.0645654,0.0660693,0.0676083,0.0691831,0.0707946,0.0724436,0.074131,0.0758578]
OmegaR=[OmegaR,0.0776247,0.0794328,0.0812831,0.0831764,0.0851138,0.0870964,0.0891251,0.0912011,0.0933254,0.0954993,0.0977237,0.1]
OmegaR=[OmegaR,0.102329,0.104713,0.107152,0.109648,0.112202,0.114815,0.11749,0.120226,0.123027,0.125893,0.128825,0.131826]
OmegaR=[OmegaR,0.134896,0.138038,0.141254,0.144544,0.147911,0.151356,0.154882,0.158489,0.162181,0.165959,0.169824,0.17378]
OmegaR=[OmegaR,0.177828,0.18197,0.186209,0.190546,0.194984,0.199526,0.204174,0.20893,0.213796,0.218776,0.223872,0.229087]
OmegaR=[OmegaR,0.234423,0.239883,0.245471,0.251189,0.25704,0.263027,0.269153,0.275423,0.281838,0.288403,0.295121,0.301995]
OmegaR=[OmegaR,0.30903,0.316228,0.323594,0.331131,0.338844,0.346737,0.354813,0.363078,0.371535,0.380189,0.389045,0.398107]
OmegaR=[OmegaR,0.40738,0.416869,0.42658,0.436516,0.446684,0.457088,0.467735,0.47863,0.489779,0.501187,0.512861,0.524807]
OmegaR=[OmegaR,0.537032,0.549541,0.562341,0.57544,0.588844,0.60256,0.616595,0.630957,0.645654,0.660693,0.676083,0.691831]
OmegaR=[OmegaR,0.707946,0.724436,0.74131,0.758578,0.776247,0.794328,0.812831,0.831764,0.851138,0.870964,0.891251,0.912011]
OmegaR=[OmegaR,0.933254,0.954993,0.977237,1,1.02329,1.04713,1.07152,1.09648,1.12202,1.14815,1.1749,1.20226]
OmegaR=[OmegaR,1.23027,1.25893,1.28825,1.31826,1.34896,1.38038,1.41254,1.44544,1.47911,1.51356,1.54882,1.58489]
OmegaR=[OmegaR,1.62181,1.65959,1.69824,1.7378,1.77828,1.8197,1.86209,1.90546,1.94984,1.99526,2.04174,2.0893]
OmegaR=[OmegaR,2.13796,2.18776,2.23872,2.29087,2.34423,2.39883,2.45471,2.51189,2.5704,2.63027,2.69153,2.75423]
OmegaR=[OmegaR,2.81838,2.88403,2.95121,3.01995,3.0903,3.16228,3.23594,3.31131,3.38844,3.46737,3.54813,3.63078]
OmegaR=[OmegaR,3.71535,3.80189,3.89045,3.98107,4.0738,4.16869,4.2658,4.36516,4.46684,4.57088,4.67735,4.7863]
OmegaR=[OmegaR,4.89779,5.01187,5.12861,5.24807,5.37032,5.49541,5.62341,5.7544,5.88844,6.0256,6.16595,6.30957]
OmegaR=[OmegaR,6.45654,6.60693,6.76083,6.91831,7.07946,7.24436,7.4131,7.58578,7.76247,7.94328,8.12831,8.31764]
OmegaR=[OmegaR,8.51138,8.70964,8.91251,9.12011,9.33254,9.54993,9.77237,10,10.2329,10.4713,10.7152,10.9648]
OmegaR=[OmegaR,11.2202,11.4815,11.749,12.0226,12.3027,12.5893,12.8825,13.1826,13.4896,13.8038,14.1254,14.4544]
OmegaR=[OmegaR,14.7911,15.1356,15.4882,15.8489,16.2181,16.5959,16.9824,17.378,17.7828,18.197,18.6209,19.0546]
OmegaR=[OmegaR,19.4984,19.9526,20.4174,20.893,21.3796,21.8776,22.3872,22.9087,23.4423,23.9883,24.5471,25.1189]
OmegaR=[OmegaR,25.704,26.3027,26.9153,27.5423,28.1838,28.8403,29.5121,30.1995,30.903,31.6228,32.3594,33.1131]
OmegaR=[OmegaR,33.8844,34.6737,35.4813,36.3078,37.1535,38.0189,38.9045,39.8107,40.738,41.6869,42.658,43.6516]
OmegaR=[OmegaR,44.6684,45.7088,46.7735,47.863,48.9779,50.1187,51.2861,52.4807,53.7032,54.9541,56.2341,57.544]
OmegaR=[OmegaR,58.8844,60.256,61.6595,63.0957,64.5654,66.0693,67.6083,69.1831,70.7946,72.4436,74.131,75.8578]
OmegaR=[OmegaR,77.6247,79.4328,81.2831,83.1764,85.1138,87.0964,89.1251,91.2011,93.3254,95.4993,97.7237,100]

f=[1,1,1,1,1,1,1,1,1,1]
f=[f,1,1,1,1,1,1,1,1,1,0.999999,0.999999,0.999999]
f=[f,0.999997,0.999997,0.999997,0.999997,0.999997,0.999997,0.999997,0.999996,0.999996,0.999996,0.999996,0.999996]
f=[f,0.999995,0.999995,0.999995,0.999995,0.999995,0.999994,0.999994,0.999994,0.999993,0.999993,0.999993,0.999992]
f=[f,0.999992,0.999992,0.999991,0.999991,0.99999,0.99999,0.99999,0.999989,0.999989,0.999988,0.999987,0.999987]
f=[f,0.999986,0.999986,0.999985,0.999984,0.999983,0.999983,0.999982,0.999981,0.99998,0.999979,0.999978,0.999977]
f=[f,0.999976,0.999975,0.999974,0.999973,0.999971,0.99997,0.999969,0.999967,0.999966,0.999964,0.999962,0.99996]
f=[f,0.999959,0.999957,0.999955,0.999952,0.99995,0.999948,0.999945,0.999943,0.99994,0.999937,0.999934,0.999931]
f=[f,0.999928,0.999925,0.999921,0.999918,0.999914,0.99991,0.999905,0.999901,0.999896,0.999892,0.999886,0.999881]
f=[f,0.999876,0.99987,0.999864,0.999857,0.999851,0.999844,0.999836,0.999829,0.999821,0.999812,0.999803,0.999794]
f=[f,0.999785,0.999775,0.999764,0.999753,0.999741,0.999729,0.999717,0.999704,0.99969,0.999675,0.99966,0.999644]
f=[f,0.999628,0.99961,0.999592,0.999573,0.999553,0.999532,0.999511,0.999488,0.999464,0.999439,0.999413,0.999386]
f=[f,0.999357,0.999327,0.999296,0.999263,0.999229,0.999193,0.999156,0.999117,0.999076,0.999033,0.998988,0.998941]
f=[f,0.998892,0.998841,0.998787,0.998731,0.998673,0.998612,0.998547,0.99848,0.99841,0.998337,0.998261,0.99818]
f=[f,0.998097,0.998009,0.997918,0.997822,0.997722,0.997618,0.997508,0.997394,0.997275,0.99715,0.99702,0.996884]
f=[f,0.996741,0.996593,0.996437,0.996275,0.996106,0.995928,0.995743,0.99555,0.995348,0.995137,0.994917,0.994687]
f=[f,0.994447,0.994196,0.993934,0.993661,0.993376,0.993078,0.992767,0.992442,0.992103,0.99175,0.991381,0.990996]
f=[f,0.990594,0.990175,0.989738,0.989282,0.988806,0.98831,0.987793,0.987254,0.986691,0.986105,0.985494,0.984857]
f=[f,0.984193,0.983502,0.982781,0.98203,0.981248,0.980433,0.979584,0.9787,0.97778,0.976822,0.975825,0.974787]
f=[f,0.973707,0.972583,0.971413,0.970197,0.968932,0.967616,0.966248,0.964826,0.963348,0.961812,0.960216,0.958557]
f=[f,0.956835,0.955046,0.953188,0.95126,0.949259,0.947182,0.945027,0.942792,0.940473,0.93807,0.935578,0.932995]
f=[f,0.93032,0.927547,0.924676,0.921704,0.918626,0.915442,0.912146,0.908738,0.905213,0.90157,0.897804,0.893913]
f=[f,0.889894,0.885743,0.881459,0.877038,0.872477,0.867773,0.862923,0.857925,0.852776,0.847473,0.842013,0.836394]
f=[f,0.830614,0.824669,0.818559,0.81228,0.805831,0.799209,0.792414,0.785443,0.778295,0.77097,0.763465,0.755781]
f=[f,0.747917,0.739872,0.731646,0.723241,0.714655,0.705891,0.696948,0.68783,0.678537,0.669071,0.659435,0.649633]
f=[f,0.639666,0.629539,0.619256,0.608821,0.598238,0.587514,0.576654,0.565663,0.554548,0.543317,0.531976,0.520533]
f=[f,0.508997,0.497375,0.485678,0.473913,0.462091,0.450222,0.438317,0.426385,0.414438,0.402487,0.390544,0.378621]
f=[f,0.366729,0.354881,0.343088,0.331363,0.319719,0.308168,0.296721,0.285392,0.274192,0.263134,0.252229,0.241489]
f=[f,0.230925,0.220548,0.210368,0.200395,0.190639,0.18111,0.171814,0.162761,0.153958,0.145411,0.137126,0.129108]
f=[f,0.121362,0.113891,0.106698,0.0997854,0.0931543,0.086805,0.0807374,0.0749502,0.0694414,0.0642086,0.0592482,0.054556]
f=[f,0.0501274,0.0459569,0.0420383,0.0383651,0.0349301,0.0317258,0.0287441,0.0259766,0.0234148,0.0210495,0.0188718,0.0168723]
f=[f,0.0150418,0.0133708,0.01185,0.0104701,0.00922201,0.00809675,0.00708554,0.00617986,0.00537149,0.00465249,0.00401527,0.0034526]
f=[f,0.00295763,0.00252387,0.00214525,0.00181609,0.00153109,0.00128538,0.00107444,0.000894149,0.000740748,0.000610827,0.000501309,0.000409434]
f=[f,0.000332739,0.00026904,0.000216406,0.000173144,0.000137778,0.000109026,8.57836E-05,6.71027E-05,5.21771E-05,4.03241E-05,3.09692E-05,2.36328E-05]
f=[f,1.79165E-05,0.000013492,1.00907E-05,7.49402E-06,5.52569E-06,4.04449E-06,2.93814E-06,2.11805E-06,1.51487E-06,1.07476E-06,7.56249E-07,5.27653E-07]
f=[f,3.64988E-07,2.50246E-07,1.7003E-07,1.14462E-07,7.63271E-08,5.04064E-08,3.29596E-08,2.13337E-08,1.36659E-08,8.66143E-09,5.43019E-09,3.36669E-09]
f=[f,2.06368E-09,1.25031E-09,7.48527E-10,4.42685E-10,2.58556E-10,1.49094E-10,8.48562E-11,4.7653E-11,2.63965E-11,1.44182E-11,7.7633E-12,4.11911E-12]
f=[f,2.15296E-12,1.10813E-12,5.61448E-13,2.79922E-13,1.37281E-13,6.62005E-14,3.13775E-14,1.4612E-14,6.68274E-15,3.00034E-15,1.32182E-15,5.71169E-16]
f=[f,2.41966E-16,1.00448E-16,4.08432E-17,1.62585E-17,6.33296E-18,2.41257E-18,8.98414E-19,3.26862E-19,1.16121E-19,4.02596E-20,1.36144E-20,4.48792E-21]
f=[f,1.44129E-21,4.5066E-22,1.37111E-22,4.05642E-23,1.16621E-23,3.25602E-24,8.82217E-25,2.31813E-25,5.90289E-26,1.45559E-26,3.47323E-27,8.01342E-28]
f=[f,1.78629E-28,3.84401E-29,7.97926E-30,1.59632E-30,3.07527E-31,5.69995E-32,1.01553E-32,1.73759E-33,2.85251E-34,4.48861E-35,6.76355E-36,9.74937E-37]
f=[f,1.34298E-37,1.766E-38,2.2145E-39,2.64508E-40,3.00602E-41,3.24661E-42,3.32842E-43,3.23512E-44,2.97745E-45,2.5915E-46,2.13031E-47,1.65175E-48]

xscaled=l2sqrtW/6*sqrt(x)
return, A*interpol(f,OmegaR,xscaled)

end
