; $Id$

function pan_meanfieldorderparameter_bsol,temp,p
    ;Tn,Jt,Nf,Bk=p
    ;print, 'bsol p ', p
    Tn=p(0) & Jt=p(1) & Nf=p(2)
    t=4.0*(Jt/(Jt+1.0))*Tn/temp
    ;print, t
    if (Tn le 0) or (Jt le 0) or  (temp ge Tn) then begin
        xout=0.0
    endif else begin
        xout=zbrentp(0.0,t,FUNC='pan_meanfieldorderparameter_bfun',temp=temp,myp=p,tol=1e-6)
	endelse
    return, xout
end;pan_meanfieldorderparameter_bsol

function pan_meanfieldorderparameter_brill,j,x
    ;print 'Tn=',Tn,' Jt=',Jt,' Nf=',Nf,' Bk=',Bk
    temp=(2*j+1.0)/2/j
    ;print x
    if x eq 0 then begin
        Br=0.0
    endif else begin
        Br=temp/tanh(temp*x)-1.0/tanh(x/2/j)/2/j
    endelse
    return, Br
end;pan_meanfieldorderparameter_brill


function pan_meanfieldorderparameter_bfun,x,T,p
;print, x
;print, T
;print, 'bfun p ',p
    Tn=p(0) & Jt=p(1) & Nf=p(2)
    if x eq 0.0 then begin
        B=-1.0;   /* so that it wont find solution at zero */
     endif else begin
        B=(x-3*pan_meanfieldorderparameter_brill(Jt,x)*(Jt/(Jt+1))*(Tn/T))
    endelse
    return, B
end;pan_meanfieldorderparameter_bfun

function pan_meanfieldorderparameter,T,parms,$
                        parmnames = parmnames, $
                        canDraw = canDraw, $
                        drawMessage = drawMessage, $
                        func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                        changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                        _Extra = extra
canDraw = 1
twoDimFlag = 0
 
if n_params() eq 0 then begin
  parmnames = ['Tm     ','J     ','Io     ','Bkgd Const','Bkgd Slope']
  return,-1
endif

drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag to set Tc and Bkgd Constant']
drawMessage[2:3] = ['Hold left mouse button down','and drag vertically to set Io']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  parms[0] = xMouseClick
  parms[3] = 0.0 ;yMouseClick
  parms[4] = 0.0
  parms[2] = 0.2*yMouseClick
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  parms[2] = 0.95 - xMouseClick/(xrange[1] - xrange[0])*0.9    ; Anywhere between 0.25 and 0.75
endif
 
Tn=parms[0]
Jt=parms[1]
Nf=parms[2]
bg=parms[3]
bs=parms[4]

npts = n_elements(T)
bout = fltarr(npts)
for i=0,npts-1 do begin
    bout[i] = Nf * (pan_meanfieldorderparameter_brill(Jt,pan_meanfieldorderparameter_bsol(T[i],parms)))^2
endfor

return, bout + bg + bs*T
end;pan_meanfieldorderparameter


pro testmeanfield
p=[50.0,0.5,100.0,0.0,0.0]
print, pan_meanfieldorderparameter(20.0,p)
T=findgen(100)+1
;Icalc=fltarr(n_elements(T))
;for i=0, n_elements(T)-1 do begin
;	Icalc(i)=Intensity(T(i),p)
;endfor
Icalc = pan_meanfieldorderparameter(T,p)

print, Icalc
print, T
plot, T,Icalc
end;testmeanfield