; $Id$
;###############################################################################
;
; NAME:
;  PAN_BIGAUSSIAN
;
; PURPOSE:
;  Gaussian distribution for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Richard Tumanjong Azuah
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_bigaussian,x,parms,$
                    	parmnames = parmnames, $
                    	canDraw = canDraw, $
                    	drawMessage = drawMessage, $
                      func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                      changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                      _Extra = extra
canDraw = 1
twoDimFlag = 0

if n_params() eq 0 then begin
  parmnames = ['area','center','fwhm1','fwhm2']
  return,-1
endif
drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function centroid']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change width']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  func_dataHash['ymax'] = yMouseClick
  fwhm = 0.05*(xrange[1]-xrange[0])
  sig = fwhm/Sqrt(8.0*Alog(2.0))
  parms[0] = yMouseClick*Sqrt(2.0*!dpi*sig^2)
  parms[1] = xMouseClick
  parms[2] = fwhm
  parms[3] = fwhm

endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  fwhm = 2.0*Abs(xMouseClick-parms[1])
  sig = fwhm/Sqrt(8.0*Alog(2.0))
  amp = parms[0]/Sqrt(2.0*!dpi*sig^2)
  area = func_dataHash['ymax']*Sqrt(2.0*!dpi*sig^2)
  parms[0] = area
  parms[2] = fwhm
  parms[3] = fwhm
endif

sig1 = parms[2]/2.35482
sig2 = parms[3]/2.35482
area = parms[0]
cen = parms[1]
yout = x*0.0
index1 = where(x lt cen, cnt1, COMPLEMENT=index2, NCOMPLEMENT=cnt2)
if (cnt1 gt 0) then yout[index1] = (area/sqrt(2.0*!dpi*sig1^2))*exp(-0.5*((x[index1]-cen)/sig1)^2)
if (cnt2 gt 0) then yout[index2] = (area/Sqrt(2.0*!dpi*sig2^2))*Exp(-0.5*((x[index2]-cen)/sig2)^2)

canDraw = 1
return,yout
end