; $Id$
;###############################################################################
;
; NAME:
;  PAN_TwoFoldJumpDiffusion_2D
;
; PURPOSE:
;  Implementation of the 2-fold jump diffusion for use in fitting
;  data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, surface fitting
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
;  Robert M. Dimeo, Ph.D.
;  NIST Center for Neutron Research
;  Phone: (301) 975-8135
;  E-mail: robert.dimeo@nist.gov
;  http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function PAN_TwoFoldJumpDiffusion_2D,x,parms,							$
  parmnames=parmnames, single_parmnames=single_parmnames, multi_parmnames=multi_parmnames,    $
  canDraw=canDraw, drawMessage=drawMessage, xrange=xrange, xunits=xunits, $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, initParms=initParms, $
  qvals=qvals,xVals=xVals,yVals=yVals,groupNumber=groupNumber,qGroup=qGroup, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, $
  resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
  _Extra = extra

nx = isa(x)? n_elements(x) : n_elements(xvals)
nq = n_elements(qvals)
ux = 1+bytarr(nx)
uq = 1+bytarr(nq)

canDraw = 0
twoDimFlag = 1
resolutionRequiredFlag = 1   ; does function require a resolution function to be defined 0=>No, 1=>Yes

extConvolFlag = 0           ; does function require external convolution? 0=>No, 1=>Yes
                            ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                            ; Also set to No, if you DO NOT wish any external convolution to be performed at all

if (n_params() eq 0) or (n_params() eq 1) then begin

  parmnames = ['Jump distance','Lorentzian FWHM', $
    'Intensity'+Strtrim(String(Indgen(nq)),2), $
    'Center'+Strtrim(String(Indgen(nq)),2)]
  single_parmnames = parmnames[0:1]
  multi_parmnames = ['Intensity','Center']

	if arg_present(initParms) then begin
	  intensity = Max(yVals,dimension = 1,index)
	  index = index - Indgen(nq)*nx ; index contains the 1D subscripts so need to reform
	  center = xvals[index]

	  ; assuming a single main peak then estimate FWHM for current group
    hm = 0.5*intensity[groupNumber-1]
    res = Where(yVals[*,groupNumber-1] ge hm, found)
    if (found gt 0) then begin
      fwhm = xvals[res[found-1]] - xvals[res[0]]
    endif

    radius = 1.0

		initParms = [radius,fwhm,intensity,center]
	endif
  return,-1
endif

if (~Isa(resPtr,'Pointer')) then Return, Fltarr(nx,nq)*0.0 ; can't proceed without a pointer to the resolution function
yres = (*resPtr).data
if (yres.ndim ne 2) then Return, yout   ; bail if resolution is not 2D

radius = parms[0]
gam = (0.5*parms[1])#uq
index = indgen(nq) + 2
intensity = ux#(parms[index])
center = ux#(parms[index+nq])

; the eisf*delta component
eisf = 0.5*(1.0+sph_bessel(qVals*radius,0))
pseudo_delta = Fltarr(2,nq)             ; delta-function parameters 
pseudo_delta[0,*] = eisf                ; area
pseudo_delta[1,*] = parms[index+nq]     ; location

; lorentzian component
lor = (1 - ux#eisf)*(ux#(gam/!dpi))/((x#uq-center)^2+(ux#gam)^2)

; perform convolution with resolution
; the lor is convoluted seperatedly as well as the delta and 
; a sum of the two is returned by pan_convolute()
yout = intensity*pan_convolute(x,resPtr,lor,pseudo_delta = pseudo_delta)

;xhi = max(x,min = xlo)
;dx = x[1]-x[0] & dy = y[1]-y[0]
;nshift = fix(0.5*((abs(xhi)-abs(xlo)))/dx)
;lineshape = eisf*ref_delta(xvals,center1,resolution,nx = nx,ny = ny)+$
;            scat_convolute(x,y,(1.0-eisf)*lorentzian,resolution) ;RTA change scat_convolve->scat_convolute
;yout = intensity*lineshape
return,yout
end
