; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;************************************************************************************************
;
; These procedures are used by the program "slab_ss"
;

;************************************************************************************************
pro slab_ss_2Plotter,event,redraw=redraw
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
if (n_elements(*(*pState).ssfPtr) eq 0) then begin
	res=dialog_message("There is nothing to plot.",/information)
	return
endif
;
wset,(*pState).winPix
if (keyword_set(redraw)) then redraw=1 else redraw=0
slab_ss_Plot,event,redraw=redraw
wset,(*pState).winVis
device,copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0,(*pState).winPix];***************************************************
widget_control,event.top,set_uvalue = pState
end


;************************************************************************************************
pro slab_ss_2Printer,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
if (n_elements(*(*pState).ssfPtr) eq 0) then begin
	res=dialog_message("There is no plot to be printed.",/information)
	return
endif
;
thisDevice = !d.name
device_keywords = PSConfig(Cancel=canceled,group_leader = event.top,$
    DefaultSetup="Centered (Landscape)")
if canceled ne 1 then begin
  SET_PLOT, 'PS'
  DEVICE, _Extra = device_keywords
	tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
	slab_ss_Plot,event,/redraw
	tvlct,(*pState).default_colors
  DEVICE, /CLOSE_FILE
  set_plot,thisDevice
endif
return
end


;************************************************************************************************
pro slab_ss_Plot,event,redraw=redraw
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
;
;
if (n_elements(*(*pState).ssfPtr) eq 0) then begin
	res=dialog_message("Nothing found to plot in SLAB_SS_PLOT",/information)
	return
endif
;
;	Define the abscissa.
absciss = *(*pState).phiPtr
nabsc=n_elements(absciss)
;
; Define ordinates.

plotwhat=(*pState).plotwhat
case plotwhat of
	0: begin
		ordinate =[[*(*pState).ssfPtr],[*(*pState).fcscPtr],[*(*pState).fccPtr],$
			[*(*pState).safPtr],[*(*pState).tsPtr],[*(*pState).tcPtr]]
	end
	1: begin
		res=dialog_message("Sorry, this feature is not yet available.")
	end
	2: begin
		res=dialog_message("Sorry, this feature is not yet available.")
		return
	end
endcase
;

if ((*pState).autoscale eq 1) then begin
  (*pState).xlo = min(absciss)
  (*pState).xhi = max(absciss)
  (*pState).ylo = 0.0
  (*pState).yhi = 1.2*max(ordinate)
endif
;
!x=(*pState).bangx
!y=(*pState).bangy
!p=(*pState).bangp
;
if ((*pState).show_sym) then psym=-dave_selsym(5) else psym=0
if ((*pState).small_sym) then symsize=0.667 else symsize=1.0
plot,absciss,ordinate[*,0],$
	xstyle=1,xrange=[(*pState).xlo,(*pState).xhi],$
	ystyle=1,yrange=[(*pState).ylo,(*pState).yhi],$
	xtitle='!32!4h!3 (degrees)',$
	psym=psym,symsize=symsize,$
	color=1,background=0,/nodata
	for k=0,5 do begin
		if ((*pState).toplot[k]) then begin
			oplot,absciss,ordinate[*,k],$
				psym=psym,symsize=symsize,$
				color=k+1
		endif
	endfor
;
labels=['f_S ("SSF")','f_{C,SC}','f_{C,C}','g ("SAF")','T_S','T_C']
label=''
color=0
nlines=0
for k=0,5 do begin
	if ((*pState).toplot[k]) then begin
		label=[label,labels[k]]
		color=[color,k+1]
		nlines=nlines+1
	endif
endfor
spacing=1.5
if (nlines gt 0) then begin
	legend,help=help,box=0,color=color[1:nlines<3],$
		textcolors=color[1:nlines<3],charsize=symsize,position=[0.15,0.95],$
		spacing=spacing,linestyle=intarr(nlines<3),psym=intarr(nlines<3)+psym
	legend,help=help,label[1:nlines<3],box=0,color=color[1:nlines<3],$
		textcolors=color[1:nlines<3],charsize=1.2,position=[0.185,0.95],$
		spacing=spacing
endif
if (nlines gt 3) then begin
	legend,help=help,box=0,color=color[4:nlines],$
		textcolors=color[4:nlines],charsize=symsize,position=[0.65,0.95],$
		spacing=spacing,linestyle=intarr(nlines-3),psym=intarr(nlines-3)+psym
	legend,help=help,label[4:nlines],box=0,color=color[4:nlines],$
		textcolors=color[4:nlines],charsize=1.2,position=[0.685,0.95],$
		spacing=spacing
endif
(*pState).bangx=!x
(*pState).bangy=!y
(*pState).bangp=!p
;
format='(f8.4)'
widget_control,(*pState).result_info_S,set_value=string((*pState).ts0,format=format)
widget_control,(*pState).result_info_C,set_value=string((*pState).tc0,format=format)
t=(*pState).tc0*(*pState).ts0*(*pState).tc0
widget_control,(*pState).result_info_T,set_value=string(t,format=format)
;
widget_control,event.top,set_uvalue = pState
;
return
end