; $Id$
;###############################################################################
;
; NAME:
;  DAVE_LAUNCH_E_NOTES
;
; PURPOSE:
;  Application launcher for the electronic notebook
;
; CATEGORY:
;  DAVE, electronic notebook
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dave_launch_e_notes,event
thisEvent = tag_names(event,/structure_name)
case thisEvent of
'WIDGET_TREE_SEL': $
   begin
      ; test for existence of web browser
      web_browser = (*!dave_defaults).web_browser
      if not file_test(web_browser) then begin
         ; Give the user the opportunity to search for
         ; a web browser.
         fdaveselbrowser,event
      endif
      dave_html,  notify_ids = [event.id,event.top],     $
                  group_leader = event.top,              $
                  directory = (*!dave_defaults).workDir,  $ ;rta - change datDir to workDir
                  web_browser = web_browser
   end
'WIDGET_BUTTON': $
   begin
      ; test for existence of web browser
      web_browser = (*!dave_defaults).web_browser
      if not file_test(web_browser) then begin
         ; Give the user the opportunity to search for
         ; a web browser.
         fdaveselbrowser,event
      endif
      dave_html,  notify_ids = [event.id,event.top],     $
                  group_leader = event.top,              $
                  directory = (*!dave_defaults).workDir,  $ ;rta - change datDir to workDir
                  web_browser = web_browser
   end
'E_NOTE_EVENT': $
   begin
      widget_control,event.top,iconify = 0
   end
   else:
endcase
end
