; $Id$
;###############################################################################
;
; NAME:
;  DAVE_HTML
;
; PURPOSE:
;  Main electronic notebook UI
;
; CATEGORY:
;  DAVE, electronic notebook
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################

;===============================================================================
; RTA
; dhtml_dialog_overwrite
pro dhtml_do_event, event
  compile_opt idl2
  
  uname = widget_info(event.id,/uname)
  widget_control, event.top, get_uvalue=sPtr

  case uname of
     'YES': begin
        (*sPtr).retVal = 1        
        widget_control, event.top, /destroy
     end

     'NO': begin
        (*sPtr).retVal = 0
        widget_control, event.top, /destroy
     end

     else:  begin
        (*sPtr).retVal = 0
        widget_control, event.top, /destroy
     end
  endcase
end

function dhtml_dialog_overwrite, msg, title=title, parent=parent
  compile_opt idl2
  
  if (n_elements(title) eq 0) then title='Question'
  if (n_elements(msg) eq 0) then $
     msg = [' ','File already exist! What do you want to do?',' ']
  
  modal = 1
  wTLB = widget_base(/col,title=title,group_leader=parent, modal=modal,/base_align_center) 
  
  for i=0,n_elements(msg)-1 do void = widget_label(wTLB,value=msg[i])
  
  cb = widget_base(wTLB,/row,/base_align_center)
  
  void = widget_button(cb,value='OVERWRITE IT',uname='YES')
  void = widget_button(cb,value='APPEND TO IT',uname='NO')
  
  sPtr=ptr_new({retVal:0})
  widget_control, wTLB, /realize, set_uvalue=sPtr
  
  xmanager,'DHTML_DIALOG_OVERWRITE',wTLB,event_handler='dhtml_do_event',no_block=modal
  
  retVal = (*sPtr).retVal
  ptr_free, sPtr
  return, retVal
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dave_html_cleanup,tlb
widget_control,tlb,get_uvalue = pstate
s = size((*pstate).notify_ids)
if s[0] ne 0 then begin
   enote_info = { E_NOTE_EVENT,                    $
                  id:(*pstate).notify_ids[0],      $
                  top:(*pstate).notify_ids[1],     $
                  handler:0L                       }
   if widget_info((*pstate).notify_ids[0],/valid_id) then begin
      widget_control,(*pstate).notify_ids[0],send_event = enote_info
   endif
endif
heap_free,pstate
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_get_plot,event
widget_control,event.top,get_uvalue = pstate
if ptr_valid(!dave_e_window) eq 0 then return
win_ids = *(!dave_e_window)
if not widget_info(win_ids[0],/valid_id) then begin
   strout = ['There is no window currently selected','Select the application '+ $
            'with the desired graphics ','and try again']
   void = dialog_message(dialog_parent = event.top,strout)
   return
endif
n_windows = n_elements(win_ids)
for i = 0,n_windows-1 do begin
   win_id = win_ids[i]
   widget_control,win_id,get_value = win_val
   win_type = size(win_val,/tname)
   if win_type eq 'LONG' then begin
      wset,win_val
      image = tvread()
      ret = dhtml_show_graphics(image,group_leader = event.top)
      if ret eq 0 then begin
         ; Save the file as a PNG
         ret = (*pstate).oenotes->get_property(web_dir = web_dir)
         fimage = strjoin(strsplit(systime(),/extract))
         image_filename = strjoin(strsplit(fimage,/extract,':'))+'.png'
         write_png,web_dir+image_filename,image
         ; Send the file into the HTML file
         ret = (*pstate).oenotes->add_image(web_dir+image_filename)
         (*pstate).new_lines = (*pstate).new_lines + 1L
      endif
   endif
   if win_type eq 'OBJREF' then begin
      ; Get the image out of the object reference
      oimage = win_val->read()
      oimage->getProperty, data=image
      obj_destroy,oimage
      ret = dhtml_show_graphics(image,group_leader = event.top)
      if ret eq 0 then begin
         ; Save the file as a PNG
         ret = (*pstate).oenotes->get_property(web_dir = web_dir)
         fimage = strjoin(strsplit(systime(),/extract))
         image_filename = strjoin(strsplit(fimage,/extract,':'))+'.png'
         write_png,web_dir+image_filename,image
         ; Send the file into the HTML file
         ret = (*pstate).oenotes->add_image(web_dir+image_filename)
         (*pstate).new_lines = (*pstate).new_lines + 1L
      endif
   endif
endfor
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_commit_entry,event
text_id = widget_info(event.top,find_by_uname = 'E_TEXT')
widget_control,text_id,get_value = text_value
widget_control,text_id,set_value = ''
n = n_elements(text_value)
widget_control,event.top,get_uvalue = pstate
for i = 0,n-1 do begin
   ret = (*pstate).oenotes->add_line(text_value[i],/strict)
endfor
(*pstate).new_lines = (*pstate).new_lines + 1L
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_write,event
widget_control,event.top,get_uvalue = pstate
title_id = widget_info(event.top,find_by_uname = 'E_NOTES_TITLE')
widget_control,title_id,get_value = title_val
title = title_val[0]
;id = widget_info(event.top,find_by_uname = 'E_NOTEBOOK_NAME')
;widget_control,id,get_value = name & name = name[0]
o = (*pstate).oenotes
; Now test if the file the user seeks to create exists already...
ret = o->get_property(web_dir = web_dir,html_filename = html_filename,  $
   saved = saved)
write_file = web_dir+html_filename
already_exists = file_test(write_file)

if already_exists then begin
   ; It already exists.

   if saved then begin
      ret = o->set_property(html_filename = name,heading = title)
      ret = o->create_html()
   endif else begin
;     RTA - replace dialog_message with dhtml_dialog_overwrite

;      strout = 'File already exists. Overwrite (YES=overwrite, NO=append)?'
;      answer = dialog_message(dialog_parent = event.top,strout, $
;               /question)
;      if strupcase(answer) eq 'NO' then begin
;         ret = o->append_html_file()
;      endif
      if (~dhtml_dialog_overwrite(parent=event.top)) then $
         ret = o->append_html_file()

      ret = o->set_property(html_filename = name,heading = title)
      ret = o->create_html()
   endelse

endif else begin
   ; It does not already exist so save it
   ret = o->set_property(html_filename = name,heading = title)
   ret = o->create_html()
endelse
(*pstate).new_lines = 0L
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_preview_notes,event
widget_control,event.top,get_uvalue = pstate
o = (*pstate).oenotes
ret = o->get_property(web_browser = web_browser,web_dir = web_dir,   $
   html_filename = html_filename)
web_browser = strjoin(strsplit(web_browser,'"',/extract))
if file_test(web_browser) then begin
   ret = o->view_web_page(ERRMSG = errmsg)
   if errmsg ne '' then void = dialog_message(dialog_parent = event.top,errmsg)
endif else begin
   strout = ['There appears to be a problem with your web browser.', $
      'Please try selecting a new browser from the main DAVE menu.']
   void = dialog_message(dialog_parent = event.top,strout)
endelse
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_quit,event
widget_control,event.top,get_uvalue = pstate
o = (*pstate).oenotes
ret = o->get_property(saved = saved)
if ((*pstate).new_lines gt 0L) then begin
   strout = 'Would you like to save your notebook before exiting?'
   answer = dialog_message(dialog_parent = event.top,strout,/question)
   if strupcase(answer) eq 'YES' then begin
      dhtml_write,event
   endif
endif
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_restore,event
widget_control,event.top,get_uvalue = pstate
title = 'Please select an existing .HTML file'
ret = (*pstate).oenotes->get_property(web_dir = web_dir)
file = dialog_pickfile(dialog_parent = event.top,/read, title = title, $
   filter = ['*.html','*.HTML','*.htm','*.HTM'], get_path = this_path, $
   path = web_dir)
if (file eq '') or (file eq ' ') or not file_test(file) then return
file_id = widget_info(event.top,find_by_uname = 'E_NOTEBOOK_NAME')
this_name = dtas_get_filename(file)
widget_control,file_id,set_value = this_path+this_name
ret = (*pstate).oenotes->set_property(web_dir = this_path,  $
   html_filename = this_name)

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_start_new,event
widget_control,event.top,get_uvalue = pstate
title = 'Please enter an .HTML file name (include .html extension)'
ret = (*pstate).oenotes->get_property(web_dir = web_dir)
file = dialog_pickfile(dialog_parent = event.top,/write, title = title, $
   filter = ['*.html','*.HTML','*.htm','*.HTM'], get_path = this_path, $
   path = web_dir)
if (file eq '') or (file eq ' ') then return
html_pos = strpos(strupcase(file),'*.HTML')
if html_pos[0] eq -1 then file = file+'.html'

file_id = widget_info(event.top,find_by_uname = 'E_NOTEBOOK_NAME')
this_name = dtas_get_filename(file)
widget_control,file_id,set_value = this_path+this_name
ret = (*pstate).oenotes->set_property(web_dir = this_path,  $
   html_filename = this_name)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_help,event

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'dhtml_help: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif

widget_control,event.top,get_uvalue = pstate
;pdf_file = file_which('e_notes_quick_start.pdf',/include_current_dir)
pdf_file = !DAVE_PDFHELP_DIR+'e_notes_quick_start.pdf'
void = launch_help(pdf_file,tlb = event.top)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dave_html_event,event
uname = widget_info(event.id,/uname)
case uname of
'EXIT':              dhtml_quit,event
'GET_PLOT':          dhtml_get_plot,event
'COMMIT_ENTRY':      dhtml_commit_entry,event
'WRITE_HTML':        dhtml_write,event
'PREVIEW':           dhtml_preview_notes,event
'START_NEW':         dhtml_start_new,event
'ADD_TO_EXISTING':   dhtml_restore,event
'HELP':              dhtml_help,event
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dave_html, group_leader = group_leader,                 $
               notify_ids = notify_ids,                     $
               directory = directory,                       $
               web_browser = web_browser
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(directory) eq 0 then begin
   cd,current = directory
   directory = directory+path_sep()
endif
if n_elements(web_browser) ne 0 then begin
   if strupcase(!version.os) eq 'WIN32' then $
      web_browser = '"'+web_browser+'"'
endif
if n_elements(web_browser) eq 0 then $
   web_browser = '"c:\Program Files\Internet Explorer\IEXPLORE.EXE"'
reg_name = 'DAVE_HTML'
if xregistered(reg_name) then return

web_dir = directory
oenotes = obj_new('dave_e_notes',web_dir = web_dir, web_browser = web_browser)

ret = oenotes->get_property(web_dir = web_dir,  $
   web_browser = web_browser, html_filename = html_filename)
; Check if this web browser resides on this computer
browser = strjoin(strsplit(web_browser,'"',/extract))
web = file_test(browser)

tlb = widget_base(group_leader = group_leader,/col,/tlb_frame_attr,  $
   title = 'DAVE Electronic Notebook Content Utility',   $
   uname = 'DAVE_E_NOTEBOOK',grid_layout = 0                         )

base = widget_base(tlb,/row)

tooltip = 'Start new e-notebook'
void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'new.bmp',/bitmap,  $
   tooltip = tooltip, uname = 'START_NEW')
tooltip = 'Open existing e-notebook'
void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'open.bmp', /bitmap,$
   uname = 'ADD_TO_EXISTING',tooltip = tooltip)
tooltip = 'Save e-notebook'
void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'save.bmp',uname = 'WRITE_HTML', $
   tooltip = tooltip,/bitmap)

if (web) then begin
   tooltip = 'Preview notebook with web browser'
   void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'image.bmp',uname = 'PREVIEW', $
      tooltip = tooltip,/bitmap)
endif
tooltip = 'Insert text typed in box above into e-notebook'
void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'text.bmp',/bitmap,  $
   tooltip = tooltip, uname = 'COMMIT_ENTRY')
tooltip = 'Get plot from active DAVE application'
void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'scatter.bmp',/bitmap,uname = 'GET_PLOT', $
   tooltip = tooltip)
tooltip = 'Launch quick-start help'
void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'help.bmp',/bitmap,uname = 'HELP', $
   tooltip = tooltip)
tooltip = 'Quit electronic notebook application'
void = widget_button(base,value = !DAVE_AUXILIARY_DIR+'exit.bmp',/bitmap,uname = 'EXIT', $
   tooltip = tooltip)


xsize = 70 & ysize = 5
void = cw_field(tlb,/col,value = 'DAVE Electronic Notebook',   $
   uname = 'E_NOTES_TITLE',title = 'Notebook Title',xsize = xsize)
annotate_base = widget_base(tlb,/col,/frame)
void = widget_label(annotate_base,value = 'E-notebook annotation')
void = widget_text(annotate_base,value = '', /editable, /wrap, $
   uname = 'E_TEXT',xsize = xsize,ysize = ysize,/scroll)

;row_base = widget_base(annotate_base,/row,/align_center)
;tooltip = 'Insert text typed in box above into e-notebook'
;void = widget_button(row_base,value = 'text.bmp',/bitmap,  $
;   tooltip = tooltip, uname = 'COMMIT_ENTRY')
;tooltip = 'Get plot from active DAVE application'
;void = widget_button(row_base,value = 'scatter.bmp',/bitmap,uname = 'GET_PLOT', $
;   tooltip = tooltip)
col_base = widget_base(tlb,/col)
cd,current = this_dir
void = cw_field(col_base,value = web_dir+html_filename,  $
   title = 'Electronic notebook name', $
   xsize = xsize,uname = 'E_NOTEBOOK_NAME',/col,/noedit)

widget_control,tlb,/realize
state = {notify_ids:notify_ids,oenotes:oenotes,new_lines:0L}
pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate
xmanager,reg_name,tlb,/no_block,event_handler = 'dave_html_event',   $
   cleanup = 'dave_html_cleanup'
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

