; $Id$

function readBT1Test_convertGSASFiles,fn,workdir=workdir,$
                                     defaultoutputfile=defaultoutputfile,$
                                     threeColASCII=threeColASCII,$
                                     davetool=davetool
;  fn = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\TAS\crs_combine\Data\pawel\Al6kb004.gsas'
  if n_elements(threeColASCII) eq 0 then threeColASCII = 0
  if n_elements(defaultoutputfile) eq 0 then defaultoutputfile = 1

  s = ''
;  print,n_elements(fn)

  for i=0,n_elements(fn)-1 do begin
  
            openr,lun,fn[i],/get_lun


;GET THE HEADER          
            readf,lun,s
          ;  print,s
            comment = s
          ;  print,'Comment = '+comment
          
            readf,lun,s
          ;  print,s
            segs = strsplit(s,':',/extract)
          ;  print,segs[1]
            instrumentFile = segs[1]
          ;  print,'Instrument file = '+instrumentFile

            readf,lun,s
            segs = strsplit(s,/extract)
          ;  print,segs
          
            bank = fix(segs[1])
            npts = fix(segs[2])
            dnw1 = fix(segs[3])
            astart = double(segs[5])/100.0
            astep  = double(segs[6])/100.0
            dnw2 = fix(segs[7])
            dnw3 = fix(segs[8])
            type = strupcase(segs[9])
;GET THE DATA          
            if type eq 'ESD' then begin
              data = dblarr(2*npts)
            endif else begin
              ;'STD' DATA
              data = dblarr(npts)
            endelse
          
            readf,lun,data
            free_lun,lun
          
            tth = astart + findgen(npts) * astep
          
            if type eq 'ESD' then begin
              qty = data[2*indgen(npts)]
              err = data[2*indgen(npts)+1]
            endif else begin
              ;'STD' DATA
              qty = data
              err = sqrt(data)
            endelse
          

;CREATE THE DAVEPTR            

            duh = create_dave_pointer(davePtr,instrument='BT1/GSAS',$
                                               qty=qty,$
                                               err=err,$
                                               QTUnits='Counts',$
                                               QTLabel='Intensity',$
                                               xLabel='Two Theta',$
                                               xunits='Degrees',$
                                               xvals=tth,$
                                               yvals=0.0,$
                                               ylabel='',$
                                               yunits='',$
                                               specificStr={comment:comment,instrumentFile:instrumentFile})

;ADD TO DAVETool IF AVAILABLE
            if obj_valid(DAVETool) gt 0 then begin
              DAVETool->AddDavePtrToDataManager, davePtr, file_basename(fn[i])
            endif

;NOW WRITE TO ASCII OR DAVE FILE
        ;NOW FOR WRITING THE FILES:
            if threeColASCII eq 0 then begin
              
    
              if defaultoutputfile eq 1 then begin
                filename = file_basename(fn[i])
                readbt1Test_addDotDave,filename
                filename = workdir+path_sep()+filename
              endif else begin
            
                filename = dialog_pickfile(/write,$
                                      title='BT-1 DAVE export file'+file_basename(fn[i])+': ',$
                                      path=workdir,$
                                      /overwrite_prompt,$
                                      dialog_parent=parent,$
                                      filter='*.dave')
              endelse                              
    
              if filename ne '' then begin
                readbt1Test_addDotDave,filename
                testfile = file_info(filename)
                save,filename=filename,davePtr
                void = dialog_message('Wrote: '+filename,/info)
              endif
            endif else begin ;threeColASCII 
    
    
              if defaultoutputfile eq 1 then begin
                filename = file_basename(fn[i])
;print,filename
                readbt1Test_addDotTXT,filename
;print,filename
                txtfilename = workdir+path_sep()+filename
              endif else begin
            
      
                txtfilename = dialog_pickfile(/write,$
                                    title='BT-1 ASCII export file'+file_basename(fn[i])+': ',$
                                    path=workdir,$
                                    /overwrite_prompt,$
                                    dialog_parent=parent,$
                                    filter='*.txt')
              endelse
              if txtfilename ne '' then begin
                readbt1Test_addDotTXT,txtfilename
                testfile = file_info(txtfilename)
                readbt1Test_writeASCII,davePtr,txtfilename
                void = dialog_message('Wrote: '+txtfilename,/info)
              endif;txtfilename
            endelse;threeColASCII


  endfor;i


  ;save,davePtr,filename=ofn
  return,1
end;readBT1Test_convertGSASFiles
