; $Id$
; ************************************ ;
; NAME:
;  IS_MISSOURITAS
;
; PURPOSE:
;  This function determines if the file specified
;  by the argument FILENAME is a valid Missouri TAS file
;  generated by TAS instruments(s) at the Missouri reactor
;
; CATEGORY:
;  DAVE, Data Reduction, TAS.
;
; AUTHOR:
;   Richard Tumanjong Azuah
;   NIST Center for Neutron Research
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
; ************************************ ;
function is_missouriTas,filename,errmsg = errmsg

errmsg = 'Not a valid Missouri TAS  file'
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   if n_elements(lun) ne 0 then free_lun,lun,/force
   errmsg = !error_state.msg
   return,0B
endif

if ~file_test(filename) then begin
   errmsg = 'File '+filename+' not found'
   return,0B
endif
dstring = ''

; B/c of unusual error resulting from running out of available logical units
; (probably a bug in get_lun); add the following 4 lines to force the use of 
; the same first available file unit every time
lun = 100
while ((fstat(lun)).open && (lun lt 129)) do begin
  lun++
endwhile

openr,lun,filename;,/get_lun
readf,lun,dstring
free_lun,lun,/force

; a valid Missouri Tas file has the keyword '# scan' on the first line of the file
split = strsplit(dstring,'=',/extract)
if (strcmp(strtrim(split[0],2),'# scan',/fold)) then begin
   errmsg = ''
   return,1B
endif

return,0B
end
