; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    spurion_2dlattice_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;METHODS:
;    spurion_2dlattice_data::calculate
;    spurion_2dlattice_data::draw
;    spurion_2dlattice_data::xrange
;    spurion_2dlattice_data::yrange
;    spurion_2dlattice_data::getproperty
;    spurion_2dlattice_data::setproperty
;    spurion_2dlattice_data::cleanup
;    spurion_2dlattice_data::init
;    spurion_2dlattice_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;###############################################################################
;
;NAME:
;        spurion_2dlattice_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_2dlattice_data::calculate,_ref_extra=extra

;NO CALCULATIONS SHOULD BE NECESSARY HERE.
;






end;calculate


;###############################################################################
;
;NAME:
;        spurion_2dlattice_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_2dlattice_data::draw,win,_ref_extra=extra


        self->calculate,_extra=extra
        wset,win

        device,get_decomposed=dc
        device,decomposed=1


        self->getproperty,x=px,y=py,sy=psy,strf=pstrf,color=color,psym=psym,$
                linestyle=linestyle,legend=legend,showdata=showdata,$
                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize

        if showdata ne 0 then begin

            x    = *px
            y    = *py
            strf = *pstrf

;            print,max(strf)
;            print,min(strf)


;            print,n_elements(strf)
            strf = (strf/max(strf))*255.0

;            print,max(strf)
;            print,min(strf)

            ;LOOP OVER THE LATTICE POINTS AND PLACE A MARK A
            ;COLOR-CODED OR SIZE CODED SYMBOL AT EACH LATTICE
            ;POINT.
setCircleSymbol

            for i=0,n_elements(strf)-1 do begin
                oplot,[x[i]],[y[i]],$
                      color = long(strf[i]),$
                      psym =  8,$;psym,$
                      linestyle=linestyle,$
                      symsize=symsize
            endfor;i

        endif;show

        device, decomposed = dc

end;spurion_2dlattice_data::draw




;###############################################################################
;
;NAME:
;        spurion_2dlattice_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_2dlattice_data::getproperty,$
                            strf=strf,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _ref_extra=extra



                if arg_present(strf) gt 0 then strf = self.strf

                self->cwo_drawplot_data::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _extra=extra


end;getproperty
;###############################################################################
;
;NAME:
;        spurion_2dlattice_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion_2dlattice_data::setcheckboxproperties,vals

;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$

    self.showdata = vals[0]
    ;ALSO COLOR CODING, RADIUS CODING,

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion_2dlattice_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_2dlattice_data::setproperty,$
                            strf=strf,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _extra=extra

                if n_elements(strf) gt 0 then self.strf = strf

end;setproperty




;###############################################################################
;
;NAME:
;        spurion_2dlattice_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_2dlattice_data::cleanup
    ;print,'spurion_2dlattice_data::cleanup'
    ptr_free,self.x
    ptr_free,self.y
    ptr_free,self.sy
    ptr_free,self.strf
end;spurion_2dlattice_data::cleanup
;###############################################################################
;
;NAME:
;        spurion_2dlattice_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion_2dlattice_data::init,x,y,sy,strf,legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,id=id,_ref_extra=extra


    ret = self->cwo_drawplot_data::init(x,y,sy,legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,id=id,_extra=extra)

    if ptr_valid(self.strf) gt 0 then ptr_free,self.strf


    ;print,strf
    self.strf = ptr_new([strf])

    self.ebshow = 0

    return,1

end;spurion_2dlattice_data

;###############################################################################
;
;NAME:
;        spurion_2dlattice_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_2dlattice_data__define,class

    class = {   spurion_2dlattice_data,$
                inherits cwo_drawplot_data,$
                strf:ptr_new()}

end;spurion_2dlattice_data__define
