; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    spurion2_spurions_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;METHODS:
;    spurion2_spurions_data::calculate
;    spurion2_spurions_data::draw
;    spurion2_spurions_data::xrange
;    spurion2_spurions_data::yrange
;    spurion2_spurions_data::getproperty
;    spurion2_spurions_data::setproperty
;    spurion2_spurions_data::cleanup
;    spurion2_spurions_data::init
;    spurion2_spurions_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;###############################################################################
;
;NAME:
;        spurion2_spurions_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_spurions_data::draw,win,_ref_extra=extra

        self->calculate,_extra=extra
        wset,win

        device,get_decomposed=dc
        device,decomposed=1

;        self->getproperty,x=px,y=py,sy=psy,strf=pstrf,color=color,psym=psym,$
;                linestyle=linestyle,legend=legend,showdata=showdata,$
;                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize

        if self.showdata ne 0 then begin

            x = *self.x
            y = *self.y
            data = *self.sy + 1

            evec = *self.evec
            hvec = *self.hvec
            kvec = *self.kvec
            lvec = *self.lvec

            if self.usexdata eq 1 then x=x;print,'x=',x
            if self.usehdata eq 1 then x=hvec
            if self.usekdata eq 1 then x=kvec
            if self.useldata eq 1 then x=lvec
            if self.useedata eq 1 then x=evec

;            print,'Spurion2_data::draw'
;            if self.usexdata eq 1 then print,'x=',x
;            if self.usehdata eq 1 then print,'hvec=',hvec
;            if self.usekdata eq 1 then print,'kvec=',kvec
;            if self.useldata eq 1 then print,'lvec=',lvec
;            if self.useedata eq 1 then print,'evec=',evec




            syms = *self.spursyms
            labels = *self.spurlabels
            colors = *self.spurcolors
            ;print,x
;            print,';**************************************************'
;            print,'SPURION LIST:'
            count = 0
            wset,win
            for i=0,n_elements(x)-1 do begin
                ;print,'Point #',i
                if y[i] ne 0 then begin
                    for j=0,y[i]-1 do begin
                        ;oplot,[x[i]],[0*x[i]],psym=8,color=self.color

                        if self->displayPoint(self.spurshow,labels[count]) ne 0 then begin
                            if self.energy eq 0 then begin
                                yval = [j + data[i]]
                            endif else begin
                                yval = [(*self.spurE)[count]]
                            endelse
                                oplot,[x[i]],$
                                      yval,$;[j],$
                                      psym=syms[count],$
                                      color=colors[count],$
                                      symsize = 2
                        endif
;                            print,count,labels[count],colors[count],syms[count]
                        ;print,count,labels[count]
                        count++
                    endfor;j
                endif
            endfor;i
        endif;showdata
        device, decomposed = dc

end;spurion2_spurions_data::draw

function Spurion2_spurions_data::displaypoint,show,label

    ret = 0
;print,'################'
;    print,show
;    print,label

    primary = '(1ki,1kf)'
    rl = 'RL'
    al = 'Al'
    incoh = 'incoherent'
    elastic = 'Elastic'

    if show[0] eq 1 then begin
        if stregex(label,primary,/fold_case,/boolean) gt 0 and $
            stregex(label,al,/fold_case,/boolean) gt 0 then $
                ret = 1
    endif
    if show[1] eq 1 then begin
        if stregex(label,primary,/fold_case,/boolean) eq 0 and $
            stregex(label,incoh,/fold_case,/boolean) eq 0 and $
                stregex(label,al,/fold_case,/boolean) gt 0 then $
                ret = 1
    endif
    if show[2] eq 1 then begin
        if stregex(label,incoh,/fold_case,/boolean) gt 0 and $
            stregex(label,al,/fold_case,/boolean) gt 0 then $
                ret = 1

    endif
    if show[3] eq 1 then begin
        if stregex(label,primary,/fold_case,/boolean) gt 0 and $
            stregex(label,elastic,/fold_case,/boolean) gt 0 then $
                ret = 1
    endif
    if show[4] eq 1 then begin
        if stregex(label,primary,/fold_case,/boolean) eq 0 and $
            stregex(label,incoh,/fold_case,/boolean) eq 0 and $
                stregex(label,elastic,/fold_case,/boolean) gt 0 then $
                    ret = 1
    endif
    if show[5] eq 1 then begin
        if stregex(label,primary,/fold_case,/boolean) gt 0 and $
            stregex(label,rl,/fold_case,/boolean) gt 0 then $
                ret = 1
    endif
    if show[6] eq 1 then begin
        if stregex(label,primary,/fold_case,/boolean) eq 0 and $
            stregex(label,incoh,/fold_case,/boolean) eq 0 and $
                stregex(label,rl,/fold_case,/boolean) gt 0 then $
                    ret = 1
    endif
    if show[7] eq 1 then begin
        if stregex(label,incoh,/fold_case,/boolean) gt 0 and $
            stregex(label,rl,/fold_case,/boolean) gt 0 then $
                ret = 1
    endif

    return,ret
end;displaypoint

;###############################################################################
;
;NAME:
;        spurion2_spurions_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_spurions_data::xrange
            x = *self.x
            evec = *self.evec
            hvec = *self.hvec
            kvec = *self.kvec
            lvec = *self.lvec
;            print,'Spurion2_data::draw'
            if self.usexdata eq 1 then x=x;print,'x=',x
            if self.usehdata eq 1 then x=hvec
            if self.usekdata eq 1 then x=kvec
            if self.useldata eq 1 then x=lvec
            if self.useedata eq 1 then x=evec

    return,[min(x),max(x)]

end;xrange
;###############################################################################
;
;NAME:
;        spurion2_spurions_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_spurions_data::yrange


    if self.energy eq 0 then begin
        y = [*self.y + *self.sy,*self.y - *self.sy]
    endif else begin
        y = *self.spurE
    endelse

    return,[min(y),max(y)]

end;yrange

;###############################################################################
;
;NAME:
;        spurion2_spurions_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_spurions_data::getproperty,$
                            x=x,$
                            y=y,$
                            spurlabels=spurlabels,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _ref_extra=extra

                if arg_present(spurlabels) gt 0 then spurlabels = self.spurlabels

;                self->cwo_drawplot_data::getproperty,$
                self->Spurion2_data::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _extra=extra


end;getproperty
;###############################################################################
;
;NAME:
;        spurion2_spurions_data::setcheckboxes
;
;PURPOSE:
;
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_spurions_data::setcheckboxes,vals

    ;print,vals
    self.spurshow = vals

end;setcheckboxes


;###############################################################################
;
;NAME:
;        spurion2_spurions_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_spurions_data::setcheckboxproperties,vals

;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$

    self.showdata = vals[0]
    ;ALSO COLOR CODING, RADIUS CODING,

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion2_spurions_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_spurions_data::setproperty,$
                            spurlabels=spurlabels,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _ref_extra=extra

;                self->cwo_drawplot_data::setproperty,$
                self->Spurion2_data::setproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _extra=extra

                if n_elements(spurlabels) gt 0 then self.spurlabels = spurlabels

end;setproperty

;###############################################################################
;
;NAME:
;        spurion2_spurions_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_spurions_data::cleanup
    ;print,'spurion2_spurions_data::cleanup'
    if ptr_valid(self.spurlabels) then ptr_free,self.spurlabels
    if ptr_valid(self.spursyms) then ptr_free,self.spursyms
    if ptr_valid(self.spurcolors) then ptr_free,self.spurcolors
    if ptr_valid(self.spurE) then ptr_free,self.spurE
    if ptr_valid(self.spurQ) then ptr_free,self.spurQ

    self->Spurion2_data::cleanup

end;spurion2_spurions_data::cleanup
;###############################################################################
;
;NAME:
;        spurion2_spurions_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_spurions_data::init,x,spurlabels,spursyms,spurcolors,$
                                 spurE,spurQ,sy,$;strf,$
                                 evec=evec,hvec=hvec,kvec=kvec,lvec=lvec,$
                                 xaxischoice=xaxischoice,$
                                 spurshow=spurshow,$
                                 usexdata=usexdata,$
                                 usehdata=usehdata,$
                                 usekdata=usekdata,$
                                 useldata=useldata,$
                                 useedata=useedata,$
                                 energy=energy,$
                                 legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,id=id,$
                                 hkl=hkl,invang=invang,hklunits=hklunits,$
                                 _ref_extra=extra

;help,/traceback
    if n_elements(spurlabels) gt 0 then self.spurlabels = ptr_new(spurlabels)
    if n_elements(spursyms) gt 0 then self.spursyms = ptr_new(spursyms)
    if n_elements(spurcolors) gt 0 then self.spurcolors = ptr_new(spurcolors)
    if n_elements(spurE) gt 0 then self.spurE = ptr_new(spurE)
    if n_elements(spurQ) gt 0 then self.spurQ = ptr_new(spurQ)

    y = x                       ;ARRAY OF NUMBER OF SPURIONS AT EACH POINT
    x = findgen(n_elements(x))  ;POINT NUMBER


    ;DETERMINE IF SPURIONS ARE FOR ENERGY PLOT
    if n_elements(energy) eq 0 then energy = 0
    self.energy = energy

    if n_elements(spurshow) eq 0 then spurshow = intarr(8) + 1
    self.spurshow = spurshow

    ;PUT DATA IN sy IF AVAILABLE.


;    ret = self->cwo_drawplot_data::init(x,y,sy,legend=legend,psym=psym,color=color,$
    ret = self->Spurion2_data::init(x,y,sy,$
                                 evec=evec,hvec=hvec,kvec=kvec,lvec=lvec,$
                                 xaxischoice=xaxischoice,$
                                 usexdata=usexdata,$
                                 usehdata=usehdata,$
                                 usekdata=usekdata,$
                                 useldata=useldata,$
                                 useedata=useedata,$
                                 legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,$
                                 id=id,_extra=extra)

    self.ebshow = 0

    return,1
end;spurion2_spurions_data

;###############################################################################
;
;NAME:
;        spurion2_spurions_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_spurions_data__define,class

    class = {   spurion2_spurions_data,$
                ;inherits cwo_drawplot_data,$
                inherits Spurion2_data,$
                spurlabels:ptr_new(),$
                spursyms:ptr_new(),$
                spurcolors:ptr_new(),$
                spurE:ptr_new(),$
                spurQ:ptr_new(),$
                spurshow:intarr(8),$
                energy:0}

end;spurion2_spurions_data__define
