; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    spurion2_scanqpoint_incoherent_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;   cwo_drawplot_data
;
;
;METHODS:
;    spurion2_scanqpoint_incoherent_data::calculate
;    spurion2_scanqpoint_incoherent_data::draw
;    spurion2_scanqpoint_incoherent_data::xrange
;    spurion2_scanqpoint_incoherent_data::yrange
;    spurion2_scanqpoint_incoherent_data::getproperty
;    spurion2_scanqpoint_incoherent_data::setproperty
;    spurion2_scanqpoint_incoherent_data::cleanup
;    spurion2_scanqpoint_incoherent_data::init
;    spurion2_scanqpoint_incoherent_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu Jun 01 20:34:13 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_scanqpoint_incoherent_data::calculate,rm,r0,Q,Q1,Q2,E,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy


end;calculate


;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_scanqpoint_incoherent_data::draw,win,xscale=xscale,yscale=yscale,_ref_Extra=Extra;,rm,r0,Q,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy

        if n_elements(xscale) eq 0 then xscale = 1.0
        if n_elements(yscale) eq 0 then yscale = 1.0

        self->calculate,_Extra=extra;,rm,r0,Q,Q1,Q2,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy
        wset,win

        device,get_decomposed=dc
        device,decomposed=1

        thick = 1

        black = 0L
        red = 255L
        green = 256L*red
        blue = 256L*green
        white = red + green + blue
        soothing = 120L + 120L*256L + 215L*256L*256L

        Qcolor = self.Qcolor;blue
        kicolor = self.kicolor;red+blue
        kfcolor = self.kfcolor;blue+green


;    self.kixincoherent = sqrt(kf[0]^2 + kf[1]^2)*ki[0]
;    self.kiyincoherent = sqrt(kf[0]^2 + kf[1]^2)*ki[1]
;
;    self.kfxincoherent = sqrt(ki[0]^2 + ki[1]^2)*kf[0]
;    self.kfyincoherent = sqrt(ki[0]^2 + ki[1]^2)*kf[1]
;
;    self.Qxanaincoherent = self.kix - self.kfxincoherent
;    self.Qyanaincoherent = self.kiy - self.kfyincoherent
;    self.Qxmonoincoherent = self.kixincoherent - self.kfx
;    self.Qymonoincoherent = self.kiyincoherent - self.kfy
;

    if self.showdata ne 0 then begin

        if self.showsymbol eq 1 then begin
            oplot,[*self.Qxanaincoherent]*xscale,$
                  [*self.Qyanaincoherent]*yscale,$
                  color=0L,psym=8,symsize=2
            oplot,[*self.Qxmonoincoherent]*xscale,$
                  [*self.Qymonoincoherent]*yscale,$
                  color=0L,psym=8,symsize=2
        endif


        if self.showq eq 1 then begin


            if self.showanaincoherent eq 1 then begin

                arrow,[0],[0],[(*self.Qxanaincoherent)[0]]*xscale,$
                              [(*self.Qyanaincoherent)[0]]*yscale,$
                              /data,color=qcolor,thick=thick

            endif

            if self.showmonoincoherent eq 1 then begin
                arrow,[0],[0],[(*self.Qxmonoincoherent)[0]]*xscale,$
                              [(*self.Qymonoincoherent)[0]]*yscale,$
                              /data,color=qcolor,thick=thick

            endif

            ;arrow,[0],[0],[self.Qx],[self.Qy],/data,color=qcolor,thick=thick
        endif;showq
        if self.showki eq 1 then begin

            if self.showmonoincoherent eq 1 then $
                arrow,[0],[0],[(*self.kixincoherent)[0]]*xscale,$
                              [(*self.kiyincoherent)[0]]*yscale,$
                              /data,color=kicolor,thick=thick


            if self.showmonoincoherent eq 1 then $
                arrow,[0],[0],[(*self.kix)[0]]*xscale,$
                              [(*self.kiy)[0]]*yscale,$
                              /data,color=kicolor,thick=thick

            ;arrow,[0],[0],[self.kix],[self.kiy],/data,color=kicolor,thick=thick
        endif;showki
        if self.showkf eq 1 then begin
            arrow,[(*self.kix)[0]]*xscale,$
                  [(*self.kiy)[0]]*yscale,$
                  [(*self.kix)[0]-(*self.kfxincoherent)[0]]*xscale,$
                  [(*self.kiy)[0]-(*self.kfyincoherent)[0]]*yscale,$
                  /data,color=kfcolor,thick=thick
            arrow,[(*self.kixincoherent)[0]]*xscale,$
                  [(*self.kiyincoherent)[0]]*yscale,$
                  [(*self.kixincoherent)[0]-(*self.kfx)[0]]*xscale,$
                  [(*self.kiyincoherent)[0]-(*self.kfy)[0]]*yscale,$
                  /data,color=kfcolor,thick=thick
        endif;showkf
    endif;showdata



;        endif;show

        device, decomposed = dc

end;spurion2_scanqpoint_incoherent_data::draw

;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_scanqpoint_incoherent_data::xrange

    x1 = *self.Qxanaincoherent
    x2 = *self.Qxmonoincoherent

    x = [0.0,x1,x2]

    return,[min(x),max(x)]

end;xrange
;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_scanqpoint_incoherent_data::yrange

    y1 = *self.Qyanaincoherent
    y2 = *self.Qymonoincoherent

    y = [0.0,y1,y2]

    return,[min(y),max(y)]

end;yrange

;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_scanqpoint_incoherent_data::getproperty,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            xy=xy,$
                            xw=xw,$
                            yw=yw,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            id=id,$
                            ;_extra=extra
                            _ref_extra=extra



                self->cwo_drawplot_data::getproperty,id=id,_extra=extra

                if arg_present(xproj) gt 0 then xproj = self.xproj
                if arg_present(yproj) gt 0 then yproj = self.yproj

                if arg_present(xcut) gt 0 then xcut = self.xcut
                if arg_present(ycut) gt 0 then ycut = self.ycut

                if arg_present(xy) gt 0 then xy = self.xy
                if arg_present(xw) gt 0 then xw = self.xw
                if arg_present(yw) gt 0 then yw = self.yw


                if arg_present(rm) gt 0 then rm = self.rm
                if arg_present(r0) gt 0 then r0 = self.r0
                if arg_present(Qx) gt 0 then Qx = self.Qx
                if arg_present(Qy) gt 0 then Qy = self.Qy
                if arg_present(kix) gt 0 then kix = self.kix
                if arg_present(kiy) gt 0 then kiy = self.kiy
                if arg_present(kfx) gt 0 then kfx = self.kfx
                if arg_present(kfy) gt 0 then kfy = self.kfy

;                if arg_present(Q) gt 0 then Q = self.Q
;                if arg_present(orient1) gt 0 then orient1 = self.orient1
;                if arg_present(orient2) gt 0 then orient2 = self.orient2
                if arg_present(E) gt 0 then E = self.E

;                if arg_present(astar) gt 0 then astar = self.astar
;                if arg_present(bstar) gt 0 then bstar = self.bstar
;                if arg_present(cstar) gt 0 then cstar = self.cstar
;
;                if arg_present(alphastar) gt 0 then alphstar = self.alphastar
;                if arg_present(betastar) gt 0 then betastar = self.betastar
;                if arg_present(gammastar) gt 0 then gammastar = self.gammastar

                if arg_present(showki) eq 1 then showki = self.showki
                if arg_present(showkf) eq 1 then showkf = self.showkf
                if arg_present(showQ) eq 1 then showQ = self.showQ
                if arg_present(showproj) eq 1 then showproj = self.showproj
                if arg_present(showcut) eq 1 then showcut = self.showcut
                if arg_present(showellipse) eq 1 then showellipse = self.showellipse
                if arg_present(showsymbol) eq 1 then showsymbol = self.showsymbol


                if arg_present(projcolor) gt 0 then projcolor = self.projcolor
                if arg_present(cutcolor) gt 0 then cutcolor = self.cutcolor

end;getproperty

;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_scanqpoint_incoherent_data::setcheckboxproperties,vals

;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$
    self.showQ  = vals[0]
    self.showki = vals[1]
    self.showkf = vals[2]
    self.showcut = vals[3]
    self.showproj = vals[4]
    self.showellipse = vals[5]
    self.showsymbol = vals[6]

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_scanqpoint_incoherent_data::setproperty,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            xw=xw,$
                            yw=yw,$
                            xy=xy,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            showdata=showdata,$
                            showki = showki,$
                            showkf = showkf,$
                            showQ = showQ,$
                            showproj = showproj,$
                            showcut = showcut,$
                            showellipse = showellipse,$
                            showsymbol = showsymbol,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,_extra=extra

                if n_elements(showdata) gt 0 then self.showdata = showdata

                if n_elements(xproj) gt 0 then self.xproj = xproj
                if n_elements(yproj) gt 0 then self.yproj = yproj

                if n_elements(xcut) gt 0 then self.xcut = xcut
                if n_elements(ycut) gt 0 then self.ycut = ycut

                if n_elements(xy) gt 0 then self.xy = xy
                if n_elements(xw) gt 0 then self.xw = xw
                if n_elements(yw) gt 0 then self.yw = yw


                if n_elements(rm) gt 0 then self.rm = rm
                if n_elements(r0) gt 0 then self.r0 = r0
                if n_elements(projcolor) gt 0 then self.projcolor = projcolor
                if n_elements(cutcolor) gt 0 then self.cutcolor = cutcolor

                if n_elements(Qx) eq 1 then self.Qx = Qx
                if n_elements(Qy) eq 1 then self.Qy = Qy
                if n_elements(kix) eq 1 then self.kix = kix
                if n_elements(kiy) eq 1 then self.kiy = kiy
                if n_elements(kfx) eq 1 then self.kfx = kfx
                if n_elements(kfy) eq 1 then self.kfy = kfy


                if n_elements(E) eq 1 then self.E = E

;                if n_elements(q)  ge 3 then self.Q  = q[0:2]
;                if n_elements(orient1) eq 3 then self.orient1 = orient1[0:2]
;                if n_elements(orient2) eq 3 then self.orient2 = orient2[0:2]
;
;                if n_elements(astar) eq 1 then self.astar = astar
;                if n_elements(bstar) eq 1 then self.bstar = bstar
;                if n_elements(cstar) eq 1 then self.cstar = cstar
;
;                if n_elements(alphastar) eq 1 then self.alphastar = alphastar
;                if n_elements( betastar) eq 1 then self.betastar  = betastar
;                if n_elements(gammastar) eq 1 then self.gammastar = gammastar

                if n_elements(showki) eq 1 then self.showki = showki
                if n_elements(showkf) eq 1 then self.showkf = showkf
                if n_elements(showQ) eq 1 then self.showQ = showQ
                if n_elements(showproj) eq 1 then self.showproj = showproj
                if n_elements(showcut) eq 1 then self.showcut = showcut
                if n_elements(showellipse) eq 1 then self.showellipse = showellipse
                if n_elements(showsymbol) eq 1 then self.showsymbol = showsymbol

                self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw
end;setproperty


;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_scanqpoint_incoherent_data::cleanup
    ;print,'spurion2_scanqpoint_incoherent_data::cleanup'

    ptr_free,self.kixincoherent
    ptr_free,self.kiyincoherent
    ptr_free,self.kfxincoherent
    ptr_free,self.kfyincoherent
    ptr_free,self.Qxanaincoherent
    ptr_free,self.Qyanaincoherent
    ptr_free,self.Qxmonoincoherent
    ptr_free,self.Qymonoincoherent
    ptr_free,self.Qx
    ptr_free,self.Qy
    ptr_free,self.kix
    ptr_free,self.kiy
    ptr_free,self.kfx
    ptr_free,self.kfy

    ptr_free,self.xproj
    ptr_free,self.yproj
    ptr_free,self.xcut
    ptr_free,self.ycut
    self->cwo_drawplot_data::cleanup

end;spurion2_scanqpoint_incoherent_data::cleanup
;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_scanqpoint_incoherent_data::init,$
                                    hvec,kvec,lvec,a,b,c,$
                                    alpha,beta,gamma,o1,o2,$
                                    Evec,Efix,Eif,$
                                    x,y,sy,nharm=nharm,$
                                    legend=legend,showdata=showdata,$
                                    showlegend=showlegend,$
                                    Qx=Qx,$            ;Qx,Qy IN THE u,v COORDINATES, i.e. IN THE SCATTERING PLANE.
                                    Qy=Qy,$
                                    kix=kix,$
                                    kiy=kiy,$
                                    kfx=kfx,$
                                    kfy=kfy,$
                                    kicolor=kicolor,$
                                    kfcolor=kfcolor,$
                                    Qcolor=Qcolor,$
                                    rm=rm,$
                                    r0=r0,$
                                    projcolor=projcolor,$
                                    xy=xy,$
                                    xw=xw,$
                                    yw=yw,$
                                    id=id,$
                                    showq=showq,$
                                    showki = showki,$
                                    showkf = showkf,$
                                    showproj = showproj,$
                                    showcut = showcut,$
                                    showellipse = showellipse,$
                                    showsymbol = showsymbol,$
                                    showmonoincoherent = showmonoincoherent,$
                                    showanaincoherent = showanaincoherent,$
                                    _ref_extra=extra


    if n_elements(kicolor) eq 0 then kicolor = self.blue+self.red else self.kicolor=kicolor
    if n_elements(kfcolor) eq 0 then kfcolor = self.blue+self.red else self.kfcolor=kfcolor
    if n_elements(Qcolor)  eq 0 then Qcolor = self.blue  else self.Qcolor=Qcolor

    if n_elements(showmonoincoherent) eq 0 then self.showmonoincoherent = 1 $
                    else self.showmonoincoherent = showmonoincoherent

    if n_elements(showanaincoherent) eq 0 then self.showanaincoherent = 1 $
                    else self.showanaincoherent = showanaincoherent


;
;NOW I HAVE TO CREATE TWO PAIRS OF X,Y VALUES
;ONE FOR MONO AND ONE FOR ANA
;
;
;I HAVE TO LOOP OVER THE h,k,l,e VEC VALUES TO CREATE THESE ARRAYS.


npts = n_elements(hvec)

kixincoherent = dblarr(npts)
kiyincoherent = dblarr(npts)
kfxincoherent = dblarr(npts)
kfyincoherent = dblarr(npts)
Qxanaincoherent = dblarr(npts)
Qyanaincoherent = dblarr(npts)
Qxmonoincoherent = dblarr(npts)
Qymonoincoherent = dblarr(npts)

Qx = dblarr(npts)
Qy = dblarr(npts)
kix = dblarr(npts)
kiy = dblarr(npts)
kfx = dblarr(npts)
kfy = dblarr(npts)


for i=0,npts-1 do begin

    h = hvec[i]
    k = kvec[i]
    l = lvec[i]
    e = evec[i]

    if eif eq 0 then begin
        init = 1
        final = 0
        Ei = Efix
        Ef = Ei - E
    endif else begin
        init = 0
        final = 1
        Ef = Efix
        Ei = E + Ef
    endelse

    Qxy = hkl_to_Qxy(h,k,l,a,b,c,alpha,beta,gamma,o1,o2,zhat_hkl=zhat_hkl)

    if Qxy[2] ne 0 then void = dialog_message('NOTE: Q not in scattering plane!')
    kikf = getkikf(Ei,Ef,Qxy)
    ki = kikf.ki
    kf = kikf.kf

    Qx[i]  = Qxy[0]
    Qy[i]  = Qxy[1]
    kix[i] = ki[0]
    kiy[i] = ki[1]
    kfx[i] = kf[0]
    kfy[i] = kf[1]

;ACCORDING TO MONA, THE MONOCHROMATOR AND ANALYZER INCOHERENT SCATTTERING IS
;THE Q VALUES FROM THE FOLLOWING:
;
;   Qana = |kf|*ki - kf
;   Qmon = ki - |ki|*kf
;
;   THIS IS ALSO IN Shirane 150-155.
;   THE HARMONICS ARE GENERALLY LESS SIGNIFICANT HERE.
;SOUNDS REASONABLE.

    kixincoherent[i] = sqrt(kf[0]^2 + kf[1]^2)*ki[0]/sqrt(ki[0]^2 + ki[1]^2)
    kiyincoherent[i] = sqrt(kf[0]^2 + kf[1]^2)*ki[1]/sqrt(ki[0]^2 + ki[1]^2)

    kfxincoherent[i] = sqrt(ki[0]^2 + ki[1]^2)*kf[0]/sqrt(kf[0]^2 + kf[1]^2)
    kfyincoherent[i] = sqrt(ki[0]^2 + ki[1]^2)*kf[1]/sqrt(kf[0]^2 + kf[1]^2)

    Qxanaincoherent[i] = kix[i] - kfxincoherent[i]
    Qyanaincoherent[i] = kiy[i] - kfyincoherent[i]
    Qxmonoincoherent[i] = kixincoherent[i] - kfx[i]
    Qymonoincoherent[i] = kiyincoherent[i] - kfy[i]

endfor;i

self.kixincoherent = ptr_new(kixincoherent)
self.kiyincoherent = ptr_new(kiyincoherent)

self.kfxincoherent = ptr_new(kfxincoherent)
self.kfyincoherent = ptr_new(kfyincoherent)

self.Qxanaincoherent = ptr_new(Qxanaincoherent)
self.Qyanaincoherent = ptr_new(Qyanaincoherent)
self.Qxmonoincoherent = ptr_new(Qxmonoincoherent)
self.Qymonoincoherent = ptr_new(Qymonoincoherent)

self.Qx  = ptr_new(Qx)
self.Qy  = ptr_new(Qy)
self.kix = ptr_new(kix)
self.kiy = ptr_new(kiy)
self.kfx = ptr_new(kfx)
self.kfy = ptr_new(kfy)


ret = self->cwo_drawplot_data::init(x,y,sy,legend=legend,showdata=showdata,id=id,$
                                        showlegend=showlegend,_extra=extra)

    if ret eq 1 then begin

        if n_elements(showki) eq 1 then self.showki = showki else  self.showki = 1
        if n_elements(showkf) eq 1 then self.showkf = showkf else  self.showkf = 1
        if n_elements(showQ) eq 1 then self.showQ = showQ else  self.showQ = 1
        if n_elements(showproj) eq 1 then self.showproj = showproj else  self.showproj = 1
        if n_elements(showcut) eq 1 then self.showcut = showcut else  self.showcut = 1
        if n_elements(showellipse) eq 1 then self.showellipse = showellipse else self.showellipse = 1
        if n_elements(showsymbol) eq 1 then self.showsymbol = showsymbol else self.showsymbol = 0



        ;SELECT DRAW PLANE OF OBJECT
        if n_elements(xy) eq 0 then xy = 0
        if n_elements(xw) eq 0 then xw = 0
        if n_elements(yw) eq 0 then yw = 0

        if xw eq 0 and yw eq 0 and xy eq 0 then xy = 1  ;DEFAULT CASE IS XY PLANE


        if xy+xw+yw gt 1 then begin

            void = dialog_message('spurion2_scanqpoint_incoherent_data::init  Multiple planes chosen, setting to x-y.')
            xw = 0
            yw = 0
            xy = 1                    ;DEFAULT IN
        endif


        self.xy = xy
        self.xw = xw
        self.yw = yw

        self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw

        return,1
    endif else begin
        return,ret
    endelse

end;spurion2_scanqpoint_incoherent_data

;###############################################################################
;
;NAME:
;        spurion2_scanqpoint_incoherent_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_scanqpoint_incoherent_data__define,class

    class = {   spurion2_scanqpoint_incoherent_data,$
                inherits cwo_drawplot_data,$
                xproj:ptr_new(),$
                yproj:ptr_new(),$
                xcut:ptr_new(),$
                ycut:ptr_new(),$
                ;
                ;THE NEXT 5 VALUES SHOULD BE SIMPLY PASSED INTO THE OBJECT
                ;AND CALCULATED IN THE ScanPoint OBJECT
                rm:dblarr(4,4),$
                r0:0.0,$
                Qx:ptr_new(),$;0.0,$            ;Qx,Qy IN THE u,v COORDINATES, i.e. IN THE SCATTERING PLANE.
                Qy:ptr_new(),$;0.0,$
                kix:ptr_new(),$;0.0,$
                kiy:ptr_new(),$;0.0,$
                kfx:ptr_new(),$;0.0,$
                kfy:ptr_new(),$;0.0,$
                kixincoherent:ptr_new(),$;0.0,$
                kiyincoherent:ptr_new(),$;0.0,$
                kfxincoherent:ptr_new(),$;0.0,$
                kfyincoherent:ptr_new(),$;0.0,$
                Qxanaincoherent:ptr_new(),$;0.0,$
                Qyanaincoherent:ptr_new(),$;0.0,$
                Qxmonoincoherent:ptr_new(),$;0.0,$
                Qymonoincoherent:ptr_new(),$;0.0,$
                E:0.0,$
                ;THE NEXT 5 ITEMS STAY IN THIS CLASS
                projcolor:0L,$
                cutcolor:0L,$
                kicolor:0L,$
                kfcolor:0L,$
                qcolor:0L,$
                xy:0,$
                xw:0,$
                yw:0,$
                showki:0,$
                showkf:0,$
                showQ:0,$
                showproj:0,$
                showcut:0,$
                showellipse:0,$
                showsymbol:0,$
                showmonoincoherent:0,$
                showanaincoherent:0}


;                ;THE NEXT 3 ITEMS SHOULD NOT BE USED IN THIS CLASS
;                Q: dblarr(3),$
;                orient1:dblarr(3),$
;                orient2:dblarr(3),$
;                ;THE NEXT 6 ITEMS SHOULD NOT BE USED IN THIS CLASS.
;                astar:0.0,$
;                bstar:0.0,$
;                cstar:0.0,$
;                alphastar:0.0,$
;                betastar:0.0,$
;                gammastar:0.0}
end;spurion2_scanqpoint_incoherent_data__define
