; $Id$

; Inherits cwo_drawplot_data
; Computes and draws, Al rings in scattering plane.

;THESE IS THE DATA CLASS FOR THE Al/Cu/Mo SAMPLE HOLDER RINGS THAT WILL BE DISPLAYED IN 
;THE SCATTERING PLANE.
;


;###############################################################################
;
;
;CLASS NAME:
;    spurion2_alspheres_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;METHODS:
;    spurion2_alspheres_data::calculate
;    spurion2_alspheres_data::getSpurions
;    spurion2_alspheres_data::draw
;    spurion2_alspheres_data::xrange
;    spurion2_alspheres_data::yrange
;    spurion2_alspheres_data::getproperty
;    spurion2_alspheres_data::setproperty
;    spurion2_alspheres_data::cleanup
;    spurion2_alspheres_data::init
;    spurion2_alspheres_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################


;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_alspheres_data::calculate,_ref_extra=extra

;NO CALCULATIONS SHOULD BE NECESSARY HERE.
;

end;calculate


;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::getSpurions
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
function spurion2_alspheres_data::getSpurions,qtol,etol,hvec,kvec,lvec,a,b,c,alpha,beta,gamma,$
                                                    o1,o2,evec,efix,eif,$
                                                    Qanaincoh=Qanaincoh,$
                                                    Qmonoincoh=Qmonoincoh,$
                                                    alspurindex=alspurindex,$
                                                    pointnumber=pointnumber,$
                                                    alspurq=alspurq,$
                                                    alspurincsym=alspurincsym,$
                                                    alspurcap=alspurcap,$
                                                    harmcheckboxstate=harmcheckboxstate,$
                                                    spurcheckboxstate=spurcheckboxstate,$
                                                    pointchoice=pointchoice

;print,'spurion2_alspheres_data::getSpurions pointchoice=',pointchoice
    if n_elements(pointchoice) eq 0 then pointchoice = -1   ;OPTIONAL INDEX FOR SELECTING ONLY ONE POINT FOR SPURION LISTING
                                                            ;THIS IS JEFF'S PREFERENCE

    ;if n_elements(pointnumber) eq 0 then pointnumber = -1


    alewald,g,hklal

npts = n_elements(hvec)
nrings = n_elements(g)

nharm = 4

if n_elements(harmcheckboxstate) eq 0 then harmcheckboxstate = intarr(nharm^2) + 1


pointnumber = intarr(npts)         ;PLACE NUMBER OF SPURIONS AT EACH POINT NUMBER HERE.
alspurcap = [''];Begin Spurions']    ;APPEND THE LATEST CAPTION AT END.
alspursym = [0]
alspurcolor = [0L]

alspurenergy = [0.0]
alspurq      = [0.0]
alspurelastic = [0.0]

red = 255L
green = 256L*red
blue = 256L*green
black = 0L
yellow = red + green
offyellow = 200L+256L*200L
yellow1 = 150L+256L*150L
yellow2 = 90L+256L*90L

purple = blue + green
violet = red + blue

harmcolor = [red,blue,green,black,yellow,$
              100L,100L*256L,100L*256L*256L,100L*256L*256L,$
              red,blue,green,purple,100L,100L*256L,100L*256L*256L]

spurioncolor = spurion2_spurion_colors()
spurionsymbol = spurion2_spurion_symbols()
spurionlabel = spurion2_spurion_labels()

;1) COUNT THE NUMBER OF SPURIONS FOR A GIVEN POINT NUMBER
;
;2)

for i=0,npts-1 do begin
    if (pointchoice eq i) or (pointchoice eq -1) then begin

                h = hvec[i]
                k = kvec[i]
                l = lvec[i]
                e = evec[i]
                                ;print,h
                                h = clearjunk(h)
                                ;print,h
                                k = clearjunk(k)
                                l = clearjunk(l)
                                e = clearjunk(e)

                Qxy = hkl_to_Qxy(h,k,l,$
                                 a,b,c,alpha,beta,gamma,o1,o2,$
                                 zhat_hkl=zhat_hkl,$
                                 /invang)

            ;    if eif eq 0 then init = 1
            ;    if eif eq 1 then final = 1

                if eif eq 0 then begin
                    init = 1
                    final = 0
                    ei = efix
                    ef = ei - e
                endif else begin
                    init = 0
                    final = 1
                    ef = efix
                    ei = e + ef
                endelse

                x = *self.x
                y = *self.y

                kikf = getkikf_from_efixed_etran(Efix,E,Qxy,init=init,final=final)
                ki = kikf.ki
                kf = kikf.kf

                if eif eq 0 then init = 1
                if eif eq 1 then final = 1

                list = ['Al Rings:']

            ;    alspurq = [0.0]

                x = *self.x
                theta = atan(Qxy[1],Qxy[0])
                for ii=0,n_elements(g)-1 do begin
            ;print,n_elements(alspurq)

                    for jj=1,4 do begin
                        for kk=1,4 do begin
            ;print,'TEST',ii,jj,kk
                            ;if jj*kk ne 1 then begin
                                ;ONLY COUNT FEATURES ABOVE THE SPECIFIC
                                if harmcheckboxstate[(jj-1) + nharm*(kk-1)] eq 1 then begin

                                    Q = jj*ki - kk*kf
                                    Eeff = (jj^2)*Ei - (kk^2)*Ef

                                    r = sqrt((Q[0]-g[ii]*cos(theta))^2 + (Q[1]-g[ii]*sin(theta))^2)
                                    if r le qtol then begin

                                        sh = strtrim(string(hklal[0,ii]),2)
                                        sk = strtrim(string(hklal[1,ii]),2)
                                        sl = strtrim(string(hklal[2,ii]),2)

                                        s = '     ('  +strtrim(string(jj),2)+ $
                                            'ki,'+strtrim(string(kk),2)+ $
                                            'kf) at Al['+sh+','+sk+','+sl+']'+ ', Qo = [' + $
                                    strtrim(string(h,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(k,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(l,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(e,format='(g7.3)'),2) + ']'
            ;print,i,ii,jj,kk,s
                                            pointnumber[i] += 1
                                            alspurcap = [alspurcap,s]
                                            alspursym = [alspursym,spurionsymbol[0]];8]
                                            alspurenergy = [alspurenergy,Eeff]
                                            alspurq      = [alspurq,sqrt(dotp(ki-kf,ki-kf))]


                        ;COLORS BY FEATURE, NOT HARMONIC????
                                            if jj eq 1 and kk eq 1 then begin
                                                alspurcolor = [alspurcolor,spurioncolor[0]];green];harmcolor[(jj-1)+(kk-1)*nharm]]
                                            endif else begin
                                                alspurcolor = [alspurcolor,spurioncolor[1]];violet];harmcolor[(jj-1)+(kk-1)*nharm]]
                                            endelse

                                        ;list = [list,s]
                                        ;alspurq = [alspurq,pointnumber]
                                    endif;r le qtol

                            ;endif;jj*kk eq 1
                            endif;harmcheckboxstate
                        endfor;kk
                    endfor;jj
                endfor;ii

                ;CROSSING ELASTIC LINE
                for jj=1,4 do begin
                    for kk=1,4 do begin
                        if harmcheckboxstate[(jj-1) + nharm*(kk-1)] eq 1 then begin
;print,'spurion2_alspheres_data::getSpurions HEY!!!!  i=',i
                        ;if jj*kk ne 1 then begin
                            ;ONLY COUNT FEATURES ABOVE THE SPECIFIC

                                Q = jj*ki - kk*kf
                                Eeff = (jj^2)*Ei - (kk^2)*Ef

                                deltae = abs(Eeff)
                                if deltae le etol then begin

                                    s = '     ('  +strtrim(string(jj),2)+ $
                                        'ki,'+strtrim(string(kk),2)+ $
                                        'kf) Elastic Crossing'+ ', Qo = [' + $
                                    strtrim(string(h,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(k,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(l,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(e,format='(g7.3)'),2) + ']'

                                        pointnumber[i] += 1
                                        alspurcap = [alspurcap,s]
                                        alspursym = [alspursym,spurionsymbol[3]];7]
                                        alspurenergy = [alspurenergy,Eeff]
                                        alspurq      = [alspurq,sqrt(dotp(ki-kf,ki-kf))]


                    ;COLORS BY FEATURE, NOT HARMONIC????
                                        if jj eq 1 and kk eq 1 then begin
                                            alspurcolor = [alspurcolor,spurioncolor[3]];offyellow];harmcolor[(jj-1)+(kk-1)*nharm]]
                                        endif else begin
                                            alspurcolor = [alspurcolor,spurioncolor[4]];yellow1];harmcolor[(jj-1)+(kk-1)*nharm]]
                                        endelse

                                    ;list = [list,s]
                                    ;alspurq = [alspurq,pointnumber]
                                endif;r le qtol

                        ;endif;jj*kk eq 1
                        endif;harmcheckboxstate
                    endfor;kk
                endfor;jj


                ;check incoherent spurions
                ;list = [list];,'   Incoherent spurions from Al:']
                calc_incoherent,ki,kf,Qana,Qmon
                for ii=0,n_elements(g)-1 do begin
                    r = sqrt((Qmon[0] - g[ii]*cos(theta))^2 + (Qmon[1] - g[ii]*sin(theta))^2)
                    if r le qtol then begin
                        sh = strtrim(string(hklal[0,ii]),2)
                        sk = strtrim(string(hklal[1,ii]),2)
                        sl = strtrim(string(hklal[2,ii]),2)
                        s = '     Qmono incoherent at Al['+sh+','+sk+','+sl+']'+ ', Q = [' + $
                                    strtrim(string(h,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(k,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(l,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(e,format='(g7.3)'),2) + ']'

                        pointnumber[i] += 1
                        alspurcap = [alspurcap,s]
                        alspursym = [alspursym,8]
                        alspurcolor = [alspurcolor,spurioncolor[2]];blue]
                        alspurenergy = [alspurenergy,0.0] ;NO ENERGY TRANSFER AT INCOHERENT POINTS
                        alspurq      = [alspurq,sqrt(dotp(ki-kf,ki-kf))]



            ;            list = [list,s]
            ;            alspurq = [alspurq,pointnumber]
                    endif
                    r = sqrt((Qana[0] - g[ii]*cos(theta))^2 + (Qana[1] - g[ii]*sin(theta))^2)
                    if r le qtol then begin
                        sh = strtrim(string(hklal[0,ii]),2)
                        sk = strtrim(string(hklal[1,ii]),2)
                        sl = strtrim(string(hklal[2,ii]),2)
                        s = '     Qana  incoherent at Al['+sh+','+sk+','+sl+']'+ ', Q = [' + $
                                    strtrim(string(h,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(k,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(l,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(e,format='(g7.3)'),2) + ']'
                        pointnumber[i] += 1
                        alspurcap = [alspurcap,s]
                        alspursym = [alspursym,spurionsymbol[2]];8]
                        alspurcolor = [alspurcolor,spurioncolor[2]];blue]
                        alspurenergy = [alspurenergy,0.0] ;NO ENERGY TRANSFER AT INCOHERENT POINTS
                        alspurq      = [alspurq,sqrt(dotp(ki-kf,ki-kf))]
            ;            list = [list,s]
            ;            alspurq = [alspurq,pointnumber]
                    endif
                endfor;ii


            ;;        r = sqrt((Qxy[0]-g[i]*cos(theta))^2 + (Qxy[1]-g[i]*sin(theta))^2)
            ;;        if r le qtol then begin
            ;;
            ;;            hkl = (hklal)[*,i]
            ;;            sh = strtrim(string(hkl[0]),2)
            ;;            sk = strtrim(string(hkl[1]),2)
            ;;            sl = strtrim(string(hkl[2]),2)
            ;;
            ;;            s = '['+sh+','+sk+','+sl+']'
            ;;            list = [list,s]
            ;;        endif
            ;;    endfor;i

    endif;pointchoice
endfor;i
if total(pointnumber) gt 0 then begin
    alspurCap = alspurCap[1:*]
    alspursym = alspursym[1:*]
    alspurcolor = alspurcolor[1:*]
    alspurenergy = alspurenergy[1:*]
    alspurq      = alspurq[1:*]

endif

return,{pointnumber:pointnumber,$
        alspurcap:alspurcap,$
        alspursym:alspursym,$
        alspurcolor:alspurcolor,$
        alspurenergy:alspurenergy,$
        alspurq:alspurq}

end;getSpurions



;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_alspheres_data::draw,xscale=xscale,yscale=yscale,win,_ref_extra=extra


        self->calculate,_extra=extra


        if n_elements(xscale) eq 0 then xscale = 1.0
        if n_elements(yscale) eq 0 then yscale = 1.0


        wset,win

        device,get_decomposed=dc
        device,decomposed=1


        self->getproperty,x=px,y=py,sy=psy,strf=pstrf,color=color,psym=psym,$
                linestyle=linestyle,legend=legend,showdata=showdata,$
                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize

        if showdata ne 0 then begin

            al    = *px

            theta = 2.0*!PI*findgen(361)/360.0

            wset,win
            for i=0,n_elements(al)-1 do begin

                x = al[i]*cos(theta)*xscale
                y = al[i]*sin(theta)*yscale

                ;oplot,x,y,psym=0,linestyle=i mod 5,color=self.color;256L*255L
                oplot,x,y,psym=0,linestyle=0,color=self.color,thick=0.1

            endfor;i

        endif;showdata

        device, decomposed = dc

end;spurion2_alspheres_data::draw
;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_alspheres_data::xrange

    x = *self.x

    return,[min(x),max(x)]

end;xrange
;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_alspheres_data::yrange

    y = *self.x

    return,[min(y),max(y)]

end;yrange

;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_alspheres_data::getproperty,$
                            strf=strf,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _ref_extra=extra



                if arg_present(strf) gt 0 then strf = self.strf

                self->cwo_drawplot_data::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _extra=extra


end;getproperty
;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_alspheres_data::setcheckboxproperties,vals

;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$

    self.showdata = vals[0]
    ;ALSO COLOR CODING, RADIUS CODING,

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_alspheres_data::setproperty,$
                            strf=strf,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _extra=extra

                if n_elements(strf) gt 0 then self.strf = strf

end;setproperty




;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_alspheres_data::cleanup
    ;print,'spurion2_alspheres_data::cleanup'
    ;ptr_free,self.x
    ;ptr_free,self.y
    ;ptr_free,self.sy
    ptr_free,self.strf
    ptr_free,self.hklal
    self->cwo_drawplot_data::cleanup


end;spurion2_alspheres_data::cleanup
;###############################################################################
;
;NAME:
;        spurion2_alspheres_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_alspheres_data::init,$;x,y,sy,strf,$
                                 o1,o2,a,b,c,alpha,beta,gamma,$
                                 cu=cu,mo=mo,$
                                 legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,id=id,$
                                 hkl=hkl,invang=invang,hklunits=hklunits,$
                                 _ref_extra=extra


    ;IF I GET THIS WORKING RIGHT, THEN I CAN CONVERT
    ;Al POWDER RINGS AND Ki,Kf INTO Q SPACE.



    ;THIS IS THE ONLY SPOT IN THIE PROGRAM WHERE I USE alewald.
    if n_elements(cu) eq 0 then cu = 0
    if n_elements(mo) eq 0 then mo = 0



    alewald,al,hklal,cu=cu,mo=mo

    x = al
    y = 0*x
    sy = 0*y

    self.hklal = ptr_new(hklal)

    ret = self->cwo_drawplot_data::init(x,y,sy,legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,$
                                 id=id,_extra=extra)

    self.ebshow = 0

    return,1
end;spurion2_alspheres_data
;###############################################################################
;
;NAME:
;        spurion2_alspheres_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_alspheres_data__define,class

    class = {   spurion2_alspheres_data,$
                inherits cwo_drawplot_data,$
                hklal:ptr_new(),$
                strf:ptr_new()}

end;spurion2_alspheres_data__define
