; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro qellipse, rm, COORDTITLE=coordtitle


 if n_elements (coordtitle) eq 0 then coordtitle=''
;setup for multiple plots
;!P.Multi=[0,3,2,1]
 !p.noerase=1
 axiscolor=10
 y_i=0.6
 y_f=0.75
 ;plot qxwellipse

 th = findgen(1001) * (0.001 *2.0 *!pi)
 p1=rm[2,2]-rm[2,1]^2/rm[1,1]
 p2=rm[0,0]-rm[0,1]^2/rm[1,1]
 p3=2*(rm[2,0]-rm[2,1]*rm[0,1]/rm[1,1])
 rt=sqrt(2*alog(2)/(p1*cos(th)^2+p2*sin(th)^2+p3*sin(th)*cos(th)))
 y=rt*cos(th)
 x=rt*sin(th)
 title=textoidl("q_x - \omega")
 xtitle=textoidl("q_x")
 ytitle=textoidl("\omega")
 plotPosition = [0.4,y_i,0.65,y_f]
 plot,x,y, title=title, xtitle=xtitle, ytitle=ytitle $
 , color=axiscolor, position=plotposition, charsize=.9
 polyfill,x,y,color=150
 rc=sqrt(2*alog(2)/(rm[2,2]*cos(th)^2+rm[0,0]*sin(th)^2 $
 +2*rm[2,0]*sin(th)*cos(th)))
 y1=rc*cos(th)
 x1=rc*sin(th)
 oplot, x1, y1




;plot qywellipse
th = findgen(1001) * (0.001 *2.0 *!pi)
p1=rm[2,2]-rm[2,0]^2/rm[0,0]
p2=rm[1,1]-rm[0,1]^2/rm[0,0]
p3=2*(rm[2,1]-rm[2,0]*rm[0,1]/rm[0,0])
rt=sqrt(2*alog(2)/(p1*cos(th)^2+p2*sin(th)^2+p3*sin(th)*cos(th)))
y=rt*cos(th)
x=rt*sin(th)
title=textoidl("q_y - \omega")
xtitle=textoidl("q_y")
ytitle=textoidl("\omega")
plotPosition = [0.72,y_i,0.97,y_f]
plot,x,y, title=title, xtitle=xtitle, ytitle=ytitle, charsize=.9 $
,position=plotPosition, color=axiscolor
polyfill,x,y,color=150
rc=sqrt(2*alog(2)/(rm[2,2]*cos(th)^2+rm[1,1]*sin(th)^2 $
+2*rm[2,1]*sin(th)*cos(th)))
y1=rc*cos(th)
x1=rc*sin(th)
oplot, x1, y1





;plot qxqy ellipse
th = findgen(1001) * (0.001 *2.0 *!pi)
p1=rm[0,0]-rm[2,0]^2/rm[2,2]
p2=rm[1,1]-rm[2,1]^2/rm[2,2]
p3=2*(rm[0,1]-rm[2,0]*rm[2,1]/rm[2,2])
rt=sqrt(2*alog(2)/(p1*cos(th)^2+p2*sin(th)^2+p3*sin(th)*cos(th)))
x=rt*cos(th)
y=rt*sin(th)
title=textoidl("q_x - q_y")
xtitle=textoidl("q_x")
ytitle=textoidl("q_y")
xmax=max(x)
ymax=max(y)
xrange=[0.1,1.0]
realmax=max([xmax,ymax])
xrange[0]=-realmax
xrange[1]=realmax
yrange=xrange
;plotPosition = ASPECT(2.0/3.0)
plotPosition = [0.075,y_i,0.325,y_f]
plot,x,y, title=title, xtitle=xtitle, ytitle=ytitle,XRange=xrange, YRange=yrange $
,Position=plotPosition, color = axiscolor, charsize=.9
polyfill,x,y,color=150
;Calculate for w=0
rc=sqrt(2*alog(2)/(rm[0,0]*cos(th)^2+rm[1,1]*sin(th)^2 $
+2*rm[0,1]*sin(th)*cos(th)))
x1=rc*cos(th)
y1=rc*sin(th)
oplot, x1, y1

rmstring=string(rm[0,*])
rmstring=[string(rm[0,0]),string(9b), string(rm[0,1])]

XYOutS, /Normal, 0.4, 0.9, coordtitle, Alignment=0.0, Charsize=1.5, color=4
XYOutS, /Normal, 0.1, 0.4, 'R-Matrix:', Alignment=0.0, Charsize=1.5, color=10
XYOutS, /Normal, 0.1, 0.3, rm[0,0], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.3, 0.3, rm[0,1], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.5, 0.3, rm[0,2], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.1, 0.2, rm[1,0], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.3, 0.2, rm[1,1], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.5, 0.2, rm[1,2], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.1, 0.1, rm[2,0], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.3, 0.1, rm[2,1], Alignment=0.0, Charsize=1.0, color=10
XYOutS, /Normal, 0.5, 0.1, rm[2,2], Alignment=0.0, Charsize=1.0, color=10
!p.noerase=0

end