; $Id$
;###############################################################################
;
;CLASS NAME:
;    pro ooEcho__define
;
;PURPOSE:
;
;CATEGORY:
;
;SUPERCLASSES:
;
;METHODS:
;    ooEcho::doNothingToCommit
;    ooEcho::resIndex
;    ooEcho::outputEchoDataItems
;    ooEcho::calculateIup_downVals
;    ooEcho::calculateIQT2DatOnly;
;    ooEcho::calculateIQT2DatBkg
;    ooEcho::calculateIQT2DatRes
;    ooEcho::getInterpBkg
;    ooEcho::getInterpsBkg
;    ooEcho::calculateIQT2DatBkgRes
;    ooEcho::calculateIQT2
;    ooEcho::fitIQT
;    ooEcho::calculateIQT
;    ooEcho::calculateArcsQMatrix
;    ooEcho::sumQArcs
;    ooEcho::SQ1D
;    ooEcho::calculateQVals
;    ooEcho::calculateQVals_orig
;    ooEcho::readSampleHeader
;    ooEcho::HandleTheError
;    ooEcho::deadTime
;    ooEcho::read
;    ooEcho::display
;    ooEcho::bin
;    ooEcho::report_timeaverage_state
;    ooEcho::do_t_ave
;    ooEcho::writeFitparmsToFile
;    ooEcho::statsMask
;    ooEcho::maskify
;    ooEcho::chirpFun
;    ooEcho::startParms
;    ooEcho::dBx
;    ooEcho::dBy
;    ooEcho::dBz
;    ooEcho::dBxAll
;    ooEcho::dByAll
;    ooEcho::dBzAll
;    ooEcho::fitphasevTau
;    ooEcho::fitAmpvTau
;    ooEcho::signalvTau
;    ooEcho::phaseArray
;    ooEcho::matches
;    ooEcho::contourEcho
;    ooecho::Tau
;    ooecho::term
;    ooEcho::chirpMean
;    ooEcho::ChiSqWeightedAveWidth
;    ooEcho::chirp
;    ooEcho::chirpAll
;    ooEcho::chirpPhasesAll
;    ooEcho::chirpPhases
;    ooEcho::chirpMasked
;    ooEcho::chirpPhasesMasked
;    ooEcho::chirpMaskedAll
;    ooEcho::defaultMask
;    ooEcho::chirpPhasesMaskedAll
;    ooEcho::chirpShadow
;    ooEcho::chirpPhasesShadow
;    ooEcho::chirpExtrema
;    ooEcho::chirpExtremaMasked
;    ooEcho::chirpIdown
;    ooEcho::chirpIup
;    ooEcho::checkHydrogenated
;    ooEcho::chirpOffset
;    ooEcho::chirpAmplitude
;    ooEcho::chirpAmplitudePhases
;    ooEcho::chisq
;    ooEcho::fitvals
;    ooEcho::chirpFit9ChiSq
;    ooEcho::pegRefit
;    ooEcho::stuckRefit
;    ooEcho::chirpFit
;    ooEcho::chirpAmpOffsetReFit
;    ooEcho::chirpAmpReFit
;    ooEcho::chirpPhaseReFit
;    ooEcho::check360a
;    ooEcho::check360
;    ooEcho::raise360
;    ooEcho::lower360
;    ooEcho::fitAllFixedPhase
;    ooEcho::fitAll4
;    ooEcho::fitAll4a
;    ooEcho::fitAllUnpeg
;    ooEcho::calculateIndexMatrix
;    ooEcho::createProgress
;    ooEcho::pegCheck
;    ooecho::newStartParmsArcFit
;    ooecho::setChisq
;    ooEcho::storeFitparms
;    ooEcho::revertFitparms
;    ooEcho::setFixed
;    ooecho::getFixVaryState
;    ooEcho::fixParm
;    ooecho::setStartParms
;    ooEcho::neighborCheck
;    ooEcho::spiralFit
;    ooEcho::chirpFitSpiral
;    ooEcho::calculateSpiralMatrix
;    ooEcho::arcFit
;    ooEcho::chirpFitArcs
;    ooEcho::readOneAmpFonFoff
;    ooEcho::readOneAmp
;    ooEcho::readOneFon
;    ooEcho::readOneFoff
;    ooEcho::checkAmp
;    ooEcho::checkQArcs
;    ooEcho::check180Fit
;    ooEcho::fitAll3
;    ooEcho::fitAll3a
;    ooEcho::fitAll
;    ooEcho::phiVTauTest
;    ooEcho::chiSqCheck
;    ooEcho::checkLineFit
;    ooEcho::check180
;    ooEcho::check90Fit
;    ooEcho::gradDotRSurface
;    ooEcho::gradDotUSurface
;    ooEcho::previousPointU
;    ooEcho::twoPointsPreviousU
;    ooEcho::previousPoint
;    ooEcho::twoPointsPrevious
;    ooEcho::checkGradientFit
;    ooEcho::surfFit
;    ooEcho::layerFit
;    ooEcho::checkAndRefit
;    ooEcho::grabPhasesFrom
;    ooEcho::closestTau
;    ooEcho::closestTauIndex
;    ooEcho::proximity1D
;    ooEcho::proximity1DAll
;    ooEcho::setMask1D
;    ooEcho::getMask1D
;    ooEcho::getMask2d
;    ooEcho::setMask2d
;    ooEcho::getfitdisplaymask
;    ooEcho::setfitdisplaymask
;    ooEcho::getInterpPhasesFrom
;    ooEcho::addTreatment
;    ooEcho::setWidth
;    ooEcho::setPeriod
;    ooEcho::getProperty
;    ooEcho::setProperty
;    ooEcho::cleanup
;    ooEcho::orderEm
;    ooEcho::blankObj
;    ooEcho::mergeSet
;    ooEcho::merge
;    ooEcho::removeFourierTime
;    ooEcho::clone
;    ooEcho::writeIQTASCII
;    ooEcho::writeIQTIgor
;    ooEcho::writeDave
;    ooEcho::writeComparisonData
;    ooEcho::readState
;    ooecho::nse_createtempvar
;    ooecho::NSE_createvar
;    ooEcho::writeState
;    ooEcho::cloneSet
;    ooEcho::removeT
;    ooEcho::init
;    ooEcho__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
; WRITTEN BY LARRY KNELLER
;
; PURPOSE:      THE PURPOSE OF THIS PROGRAM IS TO READ IN THE
;               DATA FROM A .echo FILE AND CREATE AN OBJECT
;               CONTAINING ALL OF THE INFORMATION FROM THIS FILE.
;               THE GOAL IS TO ORGANIZE IT AND MAKE ALL OF THE
;               DATA AND ASSOCIATED FUNCTIONALITY EASILY ACCESSIBLE.
;
; CURRENT VERSION:
;   ??/??/??
;
; UPDATES:
;
;   10/28/03    Added setProperty and getProperty methods
;   10/29/03    Incorporated displayEcho procedure in a display method.
;               Produces massive memory leak!
;               Additionally, the destroy method leaves a lot
;               of memory leaks.
;
;
;   10/30/03-   Adding binning, masking and fitting methods.
;   0?/??/04    Fixing memory leak issue (traced to ptr_valid(ptr) gt '1'
;               instead of '0')
;
;
;
;   01/29/04    UPDATED FITTING ROUTINES TO PRODUCE CHI-SQUARED
;               AND ASSIGN TO self.chisq
;
;
;   01/03/05    THE PROJECT CONTINUES.  AWAITING FEEDBACK FROM DOBRIN
;               THIS WEEK WHILE HE IS HERE.
;
;   01/12/05    IMPLEMENTED FOURIER TIME SELECTION AND REMOVAL VIA cloneSet.
;
;
;;;
;
;SOME PROGRAMMING QUIRKS TO NOTE:
;
;   THE OMEGA FIT PARAMETER IS USED AS OMEGA HERE, BUT IT IS
;   CONVERTED TO A PERIOD (IN DEGREES) IN ooDisplayEcho.
;
;   IN THE DATA MATRICES THE DETECTOR PIXELS ARE REPORTED AS A
;   1D MATRIX TO MAKE MANY MATRIX OPERATIONS EASIER.
;   e.g.    DATA MATRIX e[#detpixels,#phases,#tau], AND THE
;           detpixels DIMENSION GETS REBINNED INTO A 2x2 MATRIX.
;
;
;



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::doNothingToCommit,_Extra=extra
;
;NAME:
;        ooEcho::doNothingToCommit
;
;PURPOSE:
;           Do nothing.
;PARAMETERS:
;           none
;KEYWORDS:
;           none

    self->addTreatment,'ooEcho::doNothingToCommit'


end;doNothingToCommit
function ooEcho::resIndex,ft,resobj,_Extra=extra
;
;NAME:
;        ooEcho::resIndex
;
;PURPOSE:
;           Return the Fourier time index in resobj which matches ft in self.
;           This used to find matching times in res and bkg objs.
;PARAMETERS:
;           ft      The Fourier time to match
;           resobj  The object to get the matching ft index from.
;KEYWORDS:
;           none
;RETURN VALUE:
;           i   The Fourier time index
;           -1  No match


    ;self->addTreatment,'ooEcho::resIndex'



;   071604
;
;   return the index of the matching fourier time in the
;   resolution data file given an input fourier time.
;   return -1 if there is no match.
;
;   USE A 1% TOLERANCE FOR THE FOURIER TIME SELECTION.
;
;   THIS FUNCTION WILL GENERALLY BE USED TO MATCH UP
;   FOURIER TIMES IN THE CALCULATION OF I(Q,t).
;

;072004
;
;THIS METHOD SHOULD WORK FOR ANY OF THE OBJECTS.
;USE IT FOR THE BACKGROUND DATA AS WELL.
;print,'TESTING ooEcho::resIndex,ft,resobj'

    resft = *(resobj->getProperty(tag='fourierTime'))

;    print,(10.0^9)*resft
;    print,(10.0^9)*ft
    for i=0,n_elements(resft)-1 do begin
        ;print,ft,resft[i],abs((resft[i]-ft)/ft)

;053006
;EXPANDING THE RANGE OF ACCEPTIBILITY TO 4% SINCE
;2% IS OFTEN TOO CONSTRAINED AND 4% SHOULD NOT BE TOO WIDE
;BECAUSE THE STEPS IN THE FOURIER TIMES ARE TYPICALLY
;LOGORITHMIC.
;        if abs((ft-resft[i])/ft) lt 0.02 then begin
        if abs((ft-resft[i])/ft) lt 0.04 then begin
            return,i
        endif

    endfor

    ;RETURN -1 IF THERE WAS NO MATCH IN THE FOR LOOP.
    return,-1

end;resIndex
pro ooEcho::outputEchoDataItems,filename=filename,_Extra=extra
;
;NAME:
;        ooEcho::outputEchoDataItems
;
;PURPOSE:
;           Output some useful data values for testing fit options.
;PARAMETERS:
;           none
;KEYWORDS:
;           filename
;


        ext1 = ['Data','Mask','Phase','Times']
        ext2 = ['32x32','16x16','08x08','04x04','02x02']


        fn = dialog_pickfile(title='Enter Data Filename (Includes up/down):')
        if fn ne '' then begin
            e   = (*(self.e))[*,*,*]
            openw,lun,fn,/get_lun
            printf,lun,e
            free_lun,lun
        endif
        fn = dialog_pickfile(title='Enter Data Filename (No up/down):')
        if fn ne '' then begin
            e   = (*(self.e))[*,0:self->term()-1,*]
            openw,lun,fn,/get_lun
            printf,lun,e
            free_lun,lun
        endif
        fn = dialog_pickfile(title='Enter Mask Filename:')
        if fn ne '' then begin
            mask= *(self.mask2d)
            wh = where(mask le 0,count)
            if count gt 0 then mask[wh] = 0

            openw,lun,fn,/get_lun
            printf,lun,mask
            free_lun,lun
        endif
        fn = dialog_pickfile(title='Enter Fourier Time Filename:')
        if fn ne '' then begin

            t = *self.fourierTime
            openw,lun,fn,/get_lun
            printf,lun,t
            free_lun,lun
        endif
        fn = dialog_pickfile(title='Enter Phase Filename:')
        if fn ne '' then begin

            phase = (*self.phase)[0:self->term()-1]

            openw,lun,fn,/get_lun
            printf,lun,phase
            free_lun,lun
        endif


end;outputEchoData

pro ooEcho::calculateIup_downVals,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::calculateIup_downVals
;
;PURPOSE:
;           Calculate all of the Iup an Idown values (flipper on/off)
;PARAMETERS:
;           none
;KEYWORDS:
;           none

    ;self->addTreatment,'ooEcho::calculateIup_downVals'

    ;EXPLICIT CALCULATION OF Iup,down VALUES IN
    ;CASE THESE WERE NOT CALCULATED DURING FITTING

    ;GET tavestate SO IT CAN BE PASSED TO chirpIup/down
    
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()
;LRK 041409 -- THE NEXT LINE WAS THE SOURCE OF MICHI'S MISSING tmax BUG!!!!  NOW IT IS FIXED!!!!
    nt = self->getProperty(tag='no_of_fourier_times'); - 1
;b = widget_base(title=file_basename(self.filename))
;centertlb,b
;;p = cw_progress(b,title = ['Iup/down Calc'],value = [nt-1])
;p = nse_progress(b,title = ['Iup/down Calc'],value = [nt-1]);,dialog_parent=self.atlb)
;widget_control,b,/realize
;print,'ooEcho::calculateIup_downVals nt,sz(e)=',nt,size(*self.e)

    duh = checkforobjinstance('oodisplayecho',ref=ref)
    if duh ge 1 then begin
      dialog_parent = ref[0]->getproperty(/atlb)
    endif
    prog = nse_cwo_progress(labels=['Fourier Time:'],$
                           startvalues=[0L],$
                           endvalues=[long(nt)],$
                           values=[0L],$
                           steps=[1L],$
                           obj=progobj,$
                           title='Iup/down Calculation:   ',$
                           dialog_parent=dialog_parent)


    for k=0,nt-1 do begin
        ;widget_control,p,set_value=[k]
        progobj->set,0,k
        stopped = progobj->checkstop()
        if stopped ne 0 then begin
          widget_control,prog,/destroy
          return
        endif
        ;LRK - 05/26/09
        ;USING THE FOLLOWING COMMAND IN PLACE OF THE if/else BLOCK BELOW IT:
        self->newCalcChirpIupIdown,tauind=k
;        if self.magnetic ne 0 then begin
;          ;LEAVE MAGNETIC CALCS AS BEFORE
;          for j=0,self->getProperty(tag='y_dim')-1 do begin
;              for i=0,self->getProperty(tag='x_dim')-1 do begin
;                  dum = self->chirpIup(i,j,k,tavestate=tavestate)
;                  dum = self->chirpIdown(i,j,k,tavestate=tavestate)
;              endfor;i
;          endfor;j
;        endif else begin
;          ;UPDATE NON-MAGNETIC CASE
;          
;          self->newCalcChirpIupIdown,tauind = k
;;          for j=0,self->getProperty(tag='y_dim')-1 do begin
;;              for i=0,self->getProperty(tag='x_dim')-1 do begin
;;                  dum = self->chirpIup(i,j,k,tavestate=tavestate)
;;                  dum = self->chirpIdown(i,j,k,tavestate=tavestate)
;;              endfor;i
;;          endfor;j
;;        endelse
    endfor;k

;widget_control,b,/destroy
widget_control,prog,/destroy
    self.IupdownSwitch = 1
end;calculateIup_downVals



pro ooEcho::calculateIQT2DatOnly,echoAverageOpt = echoAverageOpt,_Extra=extra
;
;NAME:
;        ooEcho::calculateIQT2DatOnly;
;
;PURPOSE:
;           Calculate I(Q,t) when only data object is availble.
;           This is also used when only a resolution object is available.
;PARAMETERS:
;           none
;KEYWORDS:
;           echoAverageOpt  Option to replace the IupDown Normalization with Echo Average (G. Ehlers)

   ;self->addTreatment,'ooEcho::calculateIQT2DatOnly'

    ;072204
    ;
    ;CALCULATE THE POINT-BY-POINT I(Q,t) VALUES FOR
    ;THE CASE WHERE THERE IS ONLY A DATA OBJECT.
    ;
    ;PERHAPS THIS SHOULD BECOME A FUNCTION THAT
    ;RETURNS THE Sbar_dat SO THAT IT IS AVAILABLE
    ;FOR ALL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;120204
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

print,'ooEcho::calculateIQT2DatOnly'

        if n_elements(echoAverageOpt) eq 0 then echoAverageOpt = 0

        if self->getProperty(tag='QValsSwitch') eq 0 then begin
            ;print,self->getProperty(tag='QValsSwitch')
            self->calculateQVals
        endif
        if self->getProperty(tag='IupdownSwitch') eq 0 then begin
            self->calculateIup_downVals
        endif

        Tdat = self->getProperty(tag='transmission')
        Adat = (*(self->getProperty(tag='fitparms')))[1,*,*]
        sAdat = (*(self->getProperty(tag='fitparms')))[7,*,*]
        Iupdat = (*(self->getProperty(tag='Iup')))
        sIupdat = (*(self->getProperty(tag='sIup')))
        Idowndat = (*(self->getProperty(tag='Idown')))
        sIdowndat = (*(self->getProperty(tag='sIdown')))
        mondat = ((self->getProperty(tag='preset')))
;print,'509 ooEcho::calculateIQT2DatOnly mondat=',mondat

        volfracdat = self->getProperty(tag='volfrac')
;051205
;VOLFRAC CHANGE TO IGOR STYLE FOR DIRECT INSERTION
;INTO THE CODE COPIED FROM IGOR.
;
        volfracdat = 1.0d - volfracdat




    szdat = size(Adat)
;    szbkg = size(Abkg)
;    szres = size(Ares)

    Sbar_dat = dblarr(szdat[2],szdat[3])
    sSbar_dat = dblarr(szdat[2],szdat[3])
;    Sbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
;    sSbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    S = dblarr(szdat[2],szdat[3])
    sS = dblarr(szdat[2],szdat[3])


;033105
;THE NEXT LINE IS NOT USED IN THIS PROCEDURE.
;MASKING IS APPLIED IN THE sumQArcs PROCEDURE.
;COMMENT THE NEXT LINE
;    maskdat = (*(self->getProperty(tag='mask2d')))




    taudat = *(self->getProperty(tag='fourierTime'))
    for k=0,szdat[3]-1 do begin
;        RnumSteve = (double(mondat)/double(monbkg))*Tdat/Tbkg
;        R = volfracdat*RnumSteve

;        kbkg = self->resIndex(taudat[k],bkgobj)
;        kres = self->resIndex(taudat[k],resobj)


        Amp = (Adat[0,*,k]); - RnumSteve*Abkg[0,*,kbkg])

        dAmp = sAdat[0,*,k]^2; + (RnumSteve*sAbkg[0,*,kbkg])^2

        if echoAverageOpt ne 0 then begin
            ;SPECIAL OPTION FOR GEORG EHLERS
            DN = (*(self->getProperty(tag='fitparms')))[0,*,k]
        endif else begin
            ;THE STANDARD METHOD AS USED IN Igor
            DN = (Idowndat[*,k]-Iupdat[*,k])
        endelse

;print,k,DN[36]
        SigDiffe_S = sqrt(sIdowndat[*,k]^2 + sIupdat[*,k]^2)

        dDN = SigDiffe_S^2

        IQTe = dAmp/Amp^2 + dDN/DN^2

        ;06/21/05
        ;FACTOR OF 2 BUG DISCOVERED BY SUMMER SCHOOL STUDENT.
        IQT = 2.0*Amp/DN

        IQTe = sqrt(IQTe)*IQT

        ;110804
        S[*,k] = IQT
        sS[*,k] = IQTe
    endfor;k

    if ptr_valid(self.S) then ptr_free,self.S
    self.S = ptr_new(S)

    if ptr_valid(self.sS) then ptr_free,self.sS
    self.sS = ptr_new(sS)

    ;THIS MUST GO INTO THE DATA OBJECT ---> IT DOES DUE TO CALL FROM
                                           ;calculateIQT2 BELOW!!!


end;calculateIQT2DatOnly
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::calculateIQT2DatBkg,bkgObj,echoAverageOpt = echoAverageOpt,_Extra=extra

;
;NAME:
;        ooEcho::calculateIQT2DatBkg
;
;PURPOSE:
;           Calculate I(Q,t) when only dat and bkg available.
;PARAMETERS:
;           bkgobj
;KEYWORDS:
;           echoAverageOpt  Option to use Echo Average for normalization instead of Iup/Down (G. Ehlers)


    ;self->addTreatment,'ooEcho::calculateIQT2DatBkg'

    ;072204
    ;
    ;CALCULATE THE POINT-BY-POINT I(Q,t) VALUES FOR
    ;THE CASE WHERE THERE ARE ONLY DATA AND
    ;BACKGROUND OBJECTS.
    ;
    ;PERHAPS THIS SHOULD BECOME A FUNCTION THAT
    ;RETURNS THE Sbar_dat SO THAT IT IS AVAILABLE
    ;FOR ALL THE CASES

print,'ooEcho::calculateIQT2DatBkg'
    if n_elements(echoAverageOpt) eq 0 then echoAverageOpt = 0


        if self->getProperty(tag='QValsSwitch') eq 0 then begin
            ;print,self->getProperty(tag='QValsSwitch')
            self->calculateQVals
        endif
        if self->getProperty(tag='IupdownSwitch') eq 0 then begin
            self->calculateIup_downVals
        endif

        Tdat = self->getProperty(tag='transmission')
        Adat = (*(self->getProperty(tag='fitparms')))[1,*,*]
        sAdat = (*(self->getProperty(tag='fitparms')))[7,*,*]
        Iupdat = (*(self->getProperty(tag='Iup')))
        sIupdat = (*(self->getProperty(tag='sIup')))
        Idowndat = (*(self->getProperty(tag='Idown')))
        sIdowndat = (*(self->getProperty(tag='sIdown')))
        mondat = ((self->getProperty(tag='preset')))
;print,'509 ooEcho::calculateIQT2DatBkg mondat=',mondat

        volfracdat = self->getProperty(tag='volfrac')
;051205
;VOLFRAC CHANGE TO IGOR STYLE FOR DIRECT INSERTION
;INTO THE CODE COPIED FROM IGOR.
;
        volfracdat = 1.0d - volfracdat


        if bkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
            bkgObj->calculateQVals
        endif
        if bkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            bkgObj->calculateIup_downVals
        endif
        Tbkg = bkgobj->getProperty(tag='transmission')
        Abkg = (*(bkgobj->getProperty(tag='fitparms')))[1,*,*]
        sAbkg = (*(bkgobj->getProperty(tag='fitparms')))[7,*,*]
        Iupbkg = (*(bkgobj->getProperty(tag='Iup')))
        sIupbkg = (*(bkgobj->getProperty(tag='sIup')))
        Idownbkg = (*(bkgobj->getProperty(tag='Idown')))
        sIdownbkg = (*(bkgobj->getProperty(tag='sIdown')))
        monbkg = ((bkgobj->getProperty(tag='preset')))
        volfracbkg = bkgobj->getProperty(tag='volfrac')
;print,'529 ooEcho::calculateIQT2DatBkg monbkg=',monbkg




    szdat = size(Adat)
    szbkg = size(Abkg)
;    szres = size(Ares)

    Sbar_dat = dblarr(szdat[2],szdat[3])
    sSbar_dat = dblarr(szdat[2],szdat[3])
    Sbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    sSbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    S = dblarr(szdat[2],szdat[3])
    sS = dblarr(szdat[2],szdat[3])


;    ;033105
;    ;THE NEXT TWO LINES ARE NOT APPLIED IN THIS CASE
;    ;SINCE THE BACKGROUND MASK WILL NOT BE USED IN THE CALCULATION.
;    maskdat = (*(self->getProperty(tag='mask2d')))
;    if min(maskdat) eq -1 then $
;        maskdat[where(maskdat eq -1)] = 0
;;    maskbkg = (*(bkgobj->getProperty(tag='mask2d')))
;;    maskbkg[where(maskdat eq -1)] = 0



    taudat = *(self->getProperty(tag='fourierTime'))
    for k=0,szdat[3]-1 do begin
        RnumSteve = (double(mondat)/double(monbkg))*Tdat/Tbkg
        R = volfracdat*RnumSteve

        kbkg = self->resIndex(taudat[k],bkgobj)

;        ;033105
;        ;APPLY TOTAL MASK HERE.  THE RESULTS WILL BE CAUGHT IN ooEcho::sumQArcs
;        (*self.mask2d)[*,k] = maskdat[*,k]*maskbkg[*,kbkg]

        ;IF kbkg eq -1 THEN GET INTERP BKG(taudat[k],bkgobj)
        ;Iup,down;sIup,down = zeroth ONES.
        if kbkg ne -1 then begin
            AbkgNew = Abkg[0,*,kbkg]
            sAbkgNew = sAbkg[0,*,kbkg]
            IdownbkgNew = Idownbkg[*,kbkg]
            IupbkgNew = Iupbkg[*,kbkg]
            sIdownbkgNew = sIdownbkg[*,kbkg]
            sIupbkgNew = sIupbkg[*,kbkg]
        endif else begin
            print,'Interpolating background, getting zeroth values for Iup,down'
            AbkgNew = self->getInterpBkg(taudat[k],bkgobj)
            sAbkgNew = self->getInterpsBkg(taudat[k],bkgobj)
            IdownbkgNew = Idownbkg[*,0]
            IupbkgNew = Iupbkg[*,0]
            sIdownbkgNew = sIdownbkg[*,0]
            sIupbkgNew = sIupbkg[*,0]
        endelse




;        kres = self->resIndex(taudat[k],resobj)


        Amp = (Adat[0,*,k] - RnumSteve*AbkgNew[0,*,0])

        dAmp = sAdat[0,*,k]^2 + (RnumSteve*sAbkgNew[0,*,0])^2


        ;021706
        ;I DON'T THINK I CAN USE THE echoAverageOpt HERE
        ;AT THE VERY LEAST IS IS COMPLICATED.

        ;THE STANDARD CASE
        DN = ((Idowndat[*,k]-Iupdat[*,k]) - $
                    R*(IdownbkgNew[*,0]-IupbkgNew[*,0]))

        SigDiffe_S = sqrt(sIdowndat[*,k]^2 + sIupdat[*,k]^2)
        SigDiffe_C = sqrt(sIdownbkgNew[*,0]^2 + sIupbkgNew[*,0]^2)
        ;SigDiffe_R = sqrt(sIdownres[*,kres]^2 + sIupres[*,kres]^2)
        ;SigDiff_R = Idownres[*,kres] - Iupres[*,kres]
        ;Amp_R = Ares[0,*,kres]

        dDN = SigDiffe_S^2 + (R*SigDiffe_C)^2

        IQTe = dAmp/Amp^2 + dDN/DN^2 ;+ $
            ;(sAres[0,*,kres]/Ares[0,*,kres])^2 + (SigDiffe_R/SigDiff_R)^2

        ;06/21/05
        ;FACTOR OF 2 BUG DISCOVERED BY SUMMER SCHOOL STUDENT.
        IQT = 2.0*Amp/DN;(Amp*SigDiff_R)/(DN*Amp_R)
;        IQT = Amp/DN;(Amp*SigDiff_R)/(DN*Amp_R)

        IQTe = sqrt(IQTe)*IQT
;        print,'634 ooEcho::calculateIQT2DatBkg k,kbkg=',k,kbkg
;        print,'635 ooEcho::calculateIQT2DatBkg IQT[',k,']='
;        print,reform(IQT,8,8)

        ;110804
        S[*,k] = IQT
        sS[*,k] = IQTe




;        Amp = (Adat[0,*,k] - RnumSteve*Abkg[0,*,kbkg])
;
;        dAmp = sAdat[0,*,k]^2 + (RnumSteve*sAbkg[0,*,kbkg])^2
;
;        DN = ((Idowndat[*,k]-Iupdat[*,k]) - $
;                    R*(Idownbkg[*,kbkg]-Iupbkg[*,kbkg]))
;
;        SigDiffe_S = sqrt(sIdowndat[*,k]^2 + sIupdat[*,k]^2)
;        SigDiffe_C = sqrt(sIdownbkg[*,k]^2 + sIupbkg[*,k]^2)
;        ;SigDiffe_R = sqrt(sIdownres[*,kres]^2 + sIupres[*,kres]^2)
;        ;SigDiff_R = Idownres[*,kres] - Iupres[*,kres]
;        ;Amp_R = Ares[0,*,kres]
;
;        dDN = SigDiffe_S^2 + (R*SigDiffe_C)^2
;
;        IQTe = dAmp/Amp^2 + dDN/DN^2 ;+ $
;            ;(sAres[0,*,kres]/Ares[0,*,kres])^2 + (SigDiffe_R/SigDiff_R)^2
;
;        IQT = Amp/DN;(Amp*SigDiff_R)/(DN*Amp_R)
;
;        IQTe = sqrt(IQTe)*IQT
;;        print,'634 ooEcho::calculateIQT2DatBkg k,kbkg=',k,kbkg
;;        print,'635 ooEcho::calculateIQT2DatBkg IQT[',k,']='
;;        print,reform(IQT,8,8)
;
;        ;110804
;        S[*,k] = IQT
;        sS[*,k] = IQTe
    endfor;k

    if ptr_valid(self.S) then ptr_free,self.S
    self.S = ptr_new(S)

    if ptr_valid(self.sS) then ptr_free,self.sS
    self.sS = ptr_new(sS)

    ;THIS MUST GO INTO THE DATA OBJECT ---> IT DOES DUE TO CALL FROM
                                           ;calculateIQT2 BELOW!!!



end;calculateIQT2DatBkg
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::calculateIQT2DatRes,resObj,echoAverageOpt = echoAverageOpt,_Extra=extra
;
;NAME:
;        ooEcho::calculateIQT2DatRes
;
;PURPOSE:
;           Calculate I(Q,t) for all pixels when only dat and res available.
;PARAMETERS:
;           resObj
;KEYWORDS:
;           ,echoAverageOpt Option to Normalize by Echo Average instead of IUp/Down (for G. Ehlers)

    ;self->addTreatment,'ooEcho::calculateIQT2DatRes'


    ;072204
    ;
    ;CALCULATE THE POINT-BY-POINT I(Q,t) VALUES FOR
    ;THE CASE WHERE THERE ARE ONLY DATA AND
    ;BACKGROUND OBJECTS.
    ;
    ;PERHAPS THIS SHOULD BECOME A FUNCTION THAT
    ;RETURNS THE Sbar_dat SO THAT IT IS AVAILABLE
    ;FOR ALL THE CASES

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;120204
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;print,'DAMMIT!, DID I COME TO THIS METHOD, ooEcho::calculateIQT2DatRes?????'
;Print,'echoAverageOpt=',echoAverageOpt
print,'ooEcho::calculateIQT2DatRes'

        if n_elements(echoAverageOpt) then echoAverageOpt = 0

        if self->getProperty(tag='QValsSwitch') eq 0 then begin
            ;print,self->getProperty(tag='QValsSwitch')
            self->calculateQVals
        endif
        if self->getProperty(tag='IupdownSwitch') eq 0 then begin
            self->calculateIup_downVals
        endif

        Tdat = self->getProperty(tag='transmission')
        Adat = (*(self->getProperty(tag='fitparms')))[1,*,*]
        sAdat = (*(self->getProperty(tag='fitparms')))[7,*,*]
        Iupdat = (*(self->getProperty(tag='Iup')))
        sIupdat = (*(self->getProperty(tag='sIup')))
        Idowndat = (*(self->getProperty(tag='Idown')))
        sIdowndat = (*(self->getProperty(tag='sIdown')))
;        mondat = (*(self->getProperty(tag='monitors')))
        mondat = ((self->getProperty(tag='preset')))
;print,'509 ooEcho::calculateIQT2DatRes mondat=',mondat

        volfracdat = self->getProperty(tag='volfrac')

;051205
;VOLFRAC CHANGE TO IGOR STYLE FOR DIRECT INSERTION
;INTO THE CODE COPIED FROM IGOR.
;
        volfracdat = 1.0d - volfracdat



        if resObj->getProperty(tag='QValsSwitch') eq 0 then begin
            resObj->calculateQVals
        endif
        if resObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            resObj->calculateIup_downVals
        endif
        Tres = resobj->getProperty(tag='transmission')
        Ares = (*(resobj->getProperty(tag='fitparms')))[1,*,*]
        sAres = (*(resobj->getProperty(tag='fitparms')))[7,*,*]
        Iupres = (*(resobj->getProperty(tag='Iup')))
        sIupres = (*(resobj->getProperty(tag='sIup')))
        Idownres = (*(resobj->getProperty(tag='Idown')))
        sIdownres = (*(resobj->getProperty(tag='sIdown')))
        monres = ((resobj->getProperty(tag='preset')))
        volfracres = resobj->getProperty(tag='volfrac')



    szdat = size(Adat)
;    szbkg = size(Abkg)
    szres = size(Ares)

    Sbar_dat = dblarr(szdat[2],szdat[3])
    sSbar_dat = dblarr(szdat[2],szdat[3])
    Sbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    sSbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    S = dblarr(szdat[2],szdat[3])
    sS = dblarr(szdat[2],szdat[3])


;;033005
;;CONVERT USER MASKED PIXELS TO 0
;;CALCULATE PRODUCT AFTER resIndex()
;    maskdat = (*(self->getProperty(tag='mask2d')))
;    if min(maskdat) eq -1 then $
;        maskdat[where(maskdat eq -1)] = 0
;    maskres = (*(resobj->getProperty(tag='mask2d')))
;    if min(maskres) eq -1 then $
;        maskres[where(maskres eq -1)] = 0



    taudat = *(self->getProperty(tag='fourierTime'))
    for k=0,szdat[3]-1 do begin
;        RnumSteve = (double(mondat)/double(monbkg))*Tdat/Tbkg
;        R = volfracdat*RnumSteve

;        kbkg = self->resIndex(taudat[k],bkgobj)
        kres = self->resIndex(taudat[k],resobj)

        if kres lt 0 then begin
            S[*,k] = double('Nan')
            sS[*,k] = double('Nan')
        endif else begin

    ;        ;033105
    ;        ;APPLY TOTAL MASK HERE.  THE RESULTS WILL BE CAUGHT IN ooEcho::sumQArcs
    ;        (*self.mask2d)[*,k] = maskdat[*,k]*maskres[*,kres]

            Amp = (Adat[0,*,k]); - RnumSteve*Abkg[0,*,kbkg])

            dAmp = sAdat[0,*,k]^2; + (RnumSteve*sAbkg[0,*,kbkg])^2

            if echoAverageOpt ne 0 then begin
                ;SPECIAL OPTION FOR GEORG EHLERS
                print,'GEORG OPTION IN EFFECT! DAMMIT!'
                DN = (*(self->getProperty(tag='fitparms')))[0,*,k]
            endif else begin
                ;THE STANDARD WAY
                DN = ((Idowndat[*,k]-Iupdat[*,k])); - $
                            ;R*(Idownbkg[*,kbkg]-Iupbkg[*,kbkg]))
            endelse


            SigDiffe_S = sqrt(sIdowndat[*,k]^2 + sIupdat[*,k]^2)
            ;SigDiffe_C = sqrt(sIdownbkg[*,k]^2 + sIupbkg[*,k]^2)
            SigDiffe_R = sqrt(sIdownres[*,kres]^2 + sIupres[*,kres]^2)

            if echoAverageOpt ne 0 then begin
                ;SPECIAL OPTION FOR GEORG EHLERS
                SigDiff_R = (*(resobj->getProperty(tag='fitparms')))[0,*,kres]
            endif else begin
                ;THE STANDARD WAY
                SigDiff_R = Idownres[*,kres] - Iupres[*,kres]
            endelse
            Amp_R = Ares[0,*,kres]

            dDN = SigDiffe_S^2; + (R*SigDiffe_C)^2

            IQTe = dAmp/Amp^2 + dDN/DN^2 + (sAres[0,*,kres]/Ares[0,*,kres])^2 + (SigDiffe_R/SigDiff_R)^2



;051105
;TRY MULTIPLYING BY PRESET RATIO:  THIS MESSES UP EARLIER RESULTS e.g. C4N4OS0\0p08\Dead\Test051105
            ;IQT = (double(mondat)/double(monres))*(Amp*SigDiff_R)/(DN*Amp_R)
            IQT = (Amp*SigDiff_R)/(DN*Amp_R)

;            print,'_______________________________________________'
;            print,k
;            print,'IQTe'
;            print,reform(IQTe,8,8)
;
;
            IQTe = sqrt(IQTe)*IQT


;            print,'dAmp/Amp^2'
;            print,reform(dAmp/Amp^2,8,8)
;            print,'1/IQTe^2'
;            print,reform(1/IQTe^2,8,8)
;            print,'dDN/DN^2'
;            print,reform(dDN/DN^2,8,8)
;            print,'_______________________________________________'
;

    ;        print,'634 ooEcho::calculateIQT2DatRes k,kbkg,kres=',k,kres
    ;        print,'635 ooEcho::calculateIQT2DatRes IQT[',k,']='
    ;        print,reform(IQT,8,8)

            ;110804
            S[*,k] = IQT
            sS[*,k] = IQTe
        endelse
    endfor;k

    ;print,'HELLO!?!'

    if ptr_valid(self.S) then ptr_free,self.S
    self.S = ptr_new(S)

    if ptr_valid(self.sS) then ptr_free,self.sS
    self.sS = ptr_new(sS)

    ;THIS MUST GO INTO THE DATA OBJECT ---> IT DOES DUE TO CALL FROM
                                           ;calculateIQT2 BELOW!!!




end;calculateIQT2DatRes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ooEcho::getInterpBkg,t,bkgobj,_Extra=extra
;
;NAME:
;        ooEcho::getInterpBkg
;
;PURPOSE:
;           Calculate an interpolated background when not
;           measured at the selected Fourier time.
;PARAMETERS:
;           t       The Fourier time
;           bkgobj  The background data object.
;KEYWORDS:
;
    ;self->addTreatment,'ooEcho::getInterpBkg'

;
;032205
;
;USE THE SPLINE OPTION FOR INTERPOLATION.
;

;help,t
        ft = *(bkgobj->getProperty(tag='fourierTime'))
;help,ft
        Abkg = (*(bkgobj->getProperty(tag='fitparms')))[1,*,*]
        ;sAbkg = (*(bkgobj->getProperty(tag='fitparms')))[7,*,*]

        sz=size(Abkg)
;help,sz
        Anew = fltarr(1,sz[2],1)


        ;print,sz[3]
        ;print,sz[2]
        for i=0,sz[2]-1 do begin
            ;print,i
            line = reform(ABkg[0,i,*],sz[3])
            if n_elements(ft) ge 4 then spline = 1 else spline = 0
;print,i,'########################################################'
;if i gt 250 then begin
;    help,line,ft,t,sz,spline
;    print,line,ft,t,sz,spline
;endif

;print,sz
            if spline eq 1 then begin
;                print,'SPLINE!!!!!!'
                temp = interpol(line,ft,t,spline=spline)
;                print,'temp=',temp
            endif else begin
                temp = interpol(line,ft,t)
            endelse

;print,'temp=',temp

            ;help,temp
            Anew[0,i,0] = temp
        endfor

    return,ANew
end;getInterpBkg
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ooEcho::getInterpsBkg,t,bkgobj,_Extra=extra
;
;NAME:
;        ooEcho::getInterpsBkg
;
;PURPOSE:
;           Calculate interpolated background error bars when
;           background not measured at the selected Fourier time.
;PARAMETERS:
;           t       The Fourier time
;           bkgobj  The background data object.
;KEYWORDS:
;


    ;self->addTreatment,'ooEcho::getInterpsBkg'


;
;032205
;
;USE A SPLINE INTERPOLATION
;

        ft = *(bkgobj->getProperty(tag='fourierTime'))

        sAbkg = (*(bkgobj->getProperty(tag='fitparms')))[7,*,*]

        sz=size(sAbkg)

        Anew = fltarr(1,sz[2],1)


        for i=0,sz[2]-1 do begin
            line = reform(sABkg[0,i,*],sz[3])
            if n_elements(ft) ge 4 then spline = 1 else spline = 0
            if spline ne 0 then begin
                Anew[0,i,0] = interpol(line,ft,t,/spline)
            endif else begin
                Anew[0,i,0] = interpol(line,ft,t)
            endelse
        endfor

    return,ANew
end;getInterpsBkg


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::calculateIQT2DatBkgResResbkg,bkgObj,resObj,resbkgObj,echoAverageOpt = echoAverageOpt,_Extra=extra
;
;NAME:
;        ooEcho::calculateIQT2DatBkgResResbkg
;
;PURPOSE:
;           Calculate I(Q,t) for each pixel when data, cell and resolution objects
;           are all available.
;PARAMETERS:
;           bkgObj  The background object
;           resObj  The resolution object
;           resbkgObj  A background object specific to the resolution
;KEYWORDS:
;           echoAverageOpt  Option to use echo average for normalization in place if Iup-Idown (G. Ehlers request)

    ;self->addTreatment,'ooEcho::calculateIQT2DatBkgRes'


;FOR TRANSLATION TO IGOR:
;
;dat    data        Sample
;bkg    background  Cell
;res    resolution  Resolution

    ;072204
    ;
    ;CALCULATE THE POINT-BY-POINT I(Q,t) VALUES FOR
    ;THE CASE WHERE THERE ARE ONLY DATA AND
    ;BACKGROUND OBJECTS.
    ;
    ;PERHAPS THIS SHOULD BECOME A FUNCTION THAT
    ;RETURNS THE Sbar_dat SO THAT IT IS AVAILABLE
    ;FOR ALL THE CASES
print,'ooEcho::calculateIQT2DatBkgResResBkg'
    if n_elements(echoAverageOpt) eq 0 then echoAverageOpt = 0

        if self->getProperty(tag='QValsSwitch') eq 0 then begin
            self->calculateQVals
        endif
        if self->getProperty(tag='IupdownSwitch') eq 0 then begin
            self->calculateIup_downVals
        endif

        Tdat = self->getProperty(tag='transmission')
        Adat = (*(self->getProperty(tag='fitparms')))[1,*,*]
        sAdat = (*(self->getProperty(tag='fitparms')))[7,*,*]
        Iupdat = (*(self->getProperty(tag='Iup')))
        sIupdat = (*(self->getProperty(tag='sIup')))
        Idowndat = (*(self->getProperty(tag='Idown')))
        sIdowndat = (*(self->getProperty(tag='sIdown')))
        mondat = ((self->getProperty(tag='preset')))
;print,'509 ooEcho::calculateIQT2DatBkgRes mondat=',mondat

        volfracdat = self->getProperty(tag='volfrac')

;051205
;VOLFRAC CHANGE TO IGOR STYLE FOR DIRECT INSERTION
;INTO THE CODE COPIED FROM IGOR.
;
        volfracdat = 1.0d - volfracdat


        if bkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
            bkgObj->calculateQVals
        endif
        if bkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            bkgObj->calculateIup_downVals
        endif
        Tbkg = bkgobj->getProperty(tag='transmission')
        Abkg = (*(bkgobj->getProperty(tag='fitparms')))[1,*,*]
        sAbkg = (*(bkgobj->getProperty(tag='fitparms')))[7,*,*]
        Iupbkg = (*(bkgobj->getProperty(tag='Iup')))
        sIupbkg = (*(bkgobj->getProperty(tag='sIup')))
        Idownbkg = (*(bkgobj->getProperty(tag='Idown')))
        sIdownbkg = (*(bkgobj->getProperty(tag='sIdown')))
        monbkg = ((bkgobj->getProperty(tag='preset')))
        volfracbkg = bkgobj->getProperty(tag='volfrac')
;print,'529 ooEcho::calculateIQT2DatBkgRes monbkg=',monbkg

        if resObj->getProperty(tag='QValsSwitch') eq 0 then begin
            resObj->calculateQVals
        endif
        if resObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            resObj->calculateIup_downVals
        endif
        Tres = resobj->getProperty(tag='transmission')
        Ares = (*(resobj->getProperty(tag='fitparms')))[1,*,*]
        sAres = (*(resobj->getProperty(tag='fitparms')))[7,*,*]
        Iupres = (*(resobj->getProperty(tag='Iup')))
        sIupres = (*(resobj->getProperty(tag='sIup')))
        Idownres = (*(resobj->getProperty(tag='Idown')))
        sIdownres = (*(resobj->getProperty(tag='sIdown')))
        monres = ((resobj->getProperty(tag='preset')))
        volfracres = resobj->getProperty(tag='volfrac')

        volfracres = 1.0d - volfracres



;GET RESBKG INFORMATION
        if resbkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
            resbkgObj->calculateQVals
        endif
        if resbkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            resbkgObj->calculateIup_downVals
        endif
        Tresbkg = resbkgobj->getProperty(tag='transmission')
        Aresbkg = (*(resbkgobj->getProperty(tag='fitparms')))[1,*,*]
        sAresbkg = (*(resbkgobj->getProperty(tag='fitparms')))[7,*,*]
        Iupresbkg = (*(resbkgobj->getProperty(tag='Iup')))
        sIupresbkg = (*(resbkgobj->getProperty(tag='sIup')))
        Idownresbkg = (*(resbkgobj->getProperty(tag='Idown')))
        sIdownresbkg = (*(resbkgobj->getProperty(tag='sIdown')))
        monresbkg = ((resbkgobj->getProperty(tag='preset')))
        volfracresbkg = resbkgobj->getProperty(tag='volfrac')







    szdat = size(Adat)
    szbkg = size(Abkg)
    szres = size(Ares)
    szresbkg = size(Aresbkg)
    ;print,'971 ooEcho::calculateIQT2DatBkgRes szdat=',szdat
    ;print,'972 ooEcho::calculateIQT2DatBkgRes szbkg=',szbkg
    ;print,'973 ooEcho::calculateIQT2DatBkgRes szres=',szres

    Sbar_dat = dblarr(szdat[2],szdat[3])
    sSbar_dat = dblarr(szdat[2],szdat[3])
    Sbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    sSbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    S = dblarr(szdat[2],szdat[3])
    sS = dblarr(szdat[2],szdat[3])


    taudat = *(self->getProperty(tag='fourierTime'))
    for k=0,szdat[3]-1 do begin
        RnumSteve = (double(mondat)/double(monbkg))*Tdat/Tbkg
        R = volfracdat*RnumSteve

        ;LRK - ADD FOR ANTONIO AND MATHS RESBKG SUBTRACTION
        RnumSteveResBkg = (double(monres)/double(monresbkg))*Tres/Tresbkg
        RResBkg = volfracres*RnumSteveResBkg



        kbkg = self->resIndex(taudat[k],bkgobj)

        ;IF kbkg eq -1 THEN GET INTERP BKG(taudat[k],bkgobj)
        ;Iup,down;sIup,down = zeroth ONES.
        if kbkg ne -1 then begin
            AbkgNew = Abkg[0,*,kbkg]
            sAbkgNew = sAbkg[0,*,kbkg]
            IdownbkgNew = Idownbkg[*,kbkg]
            IupbkgNew = Iupbkg[*,kbkg]
            sIdownbkgNew = sIdownbkg[*,kbkg]
            sIupbkgNew = sIupbkg[*,kbkg]
        endif else begin
            print,'Interpolating background, getting zeroth values for Iup,down'
            AbkgNew = self->getInterpBkg(taudat[k],bkgobj)
            sAbkgNew = self->getInterpsBkg(taudat[k],bkgobj)
            IdownbkgNew = Idownbkg[*,0]
            IupbkgNew = Iupbkg[*,0]
            sIdownbkgNew = sIdownbkg[*,0]
            sIupbkgNew = sIupbkg[*,0]
        endelse


        ;LRK - ADD FOR ANTONIO AND MATHS RESBKG SUBTRACTION
        kresbkg = resobj->resIndex(taudat[k],resbkgobj)
        if kresbkg ne -1 then begin
            AresbkgNew = Aresbkg[0,*,kresbkg]
            sAresbkgNew = sAresbkg[0,*,kresbkg]
            IdownresbkgNew = Idownresbkg[*,kresbkg]
            IupresbkgNew = Iupresbkg[*,kresbkg]
            sIdownresbkgNew = sIdownresbkg[*,kresbkg]
            sIupresbkgNew = sIupresbkg[*,kresbkg]
        endif else begin
            print,'Interpolating background, getting zeroth values for Iup,down'
            AresbkgNew = resobj->getInterpBkg(taudat[k],resbkgobj)
            sAresbkgNew = resobj->getInterpsBkg(taudat[k],resbkgobj)
            IdownresbkgNew = Idownresbkg[*,0]
            IupresbkgNew = Iupresbkg[*,0]
            sIdownresbkgNew = sIdownresbkg[*,0]
            sIupresbkgNew = sIupresbkg[*,0]
        endelse




        kres = self->resIndex(taudat[k],resobj)


        if (kres lt 0) then begin;or (kbkg lt 0) then begin
            ;print,'kres,kbkg = ',kres,kbkg
            ;040805
            S[*,k] = double('Nan')
            sS[*,k] = double('Nan')
        endif else begin



            ;
            ;
            ;print,taudat[k]
            ;help,AbkgNew
            Amp = (Adat[0,*,k] - RnumSteve*AbkgNew[0,*,0])

            dAmp = sAdat[0,*,k]^(2.0d) + (RnumSteve*sAbkgNew[0,*,0])^(2.0d)

            SigDiff_S = Idowndat[*,k]-Iupdat[*,k]
            SigDiff_C = IdownbkgNew[*,0]-IupbkgNew[*,0]
            DN = SigDiff_S - R*SigDiff_C

            SigDiffe_S = sqrt(sIdowndat[*,k]^2 + sIupdat[*,k]^2)
            SigDiffe_C = sqrt(sIdownbkgNew[*,0]^2 + sIupbkgNew[*,0]^2)


        ;LRK - CHANGE THIS FOR ANTONIO AND MATHS RESBKG SUBTRACTION
    
            SigDiffe_R = sqrt(sIdownres[*,kres]^2 + sIupres[*,kres]^2)
            SigDiffe_RC = sqrt(sIdownresbkgNew[*,0]^2 + sIupresbkgNew[*,0]^2)

            SigDiff_R = Idownres[*,kres] - Iupres[*,kres]
            SigDiff_RC = IdownresbkgNew[*,0]-IupresbkgNew[*,0]

;if k eq 0 then begin
;  print,'k=',k
;  print,'kres=',kres
;  print,'kbkg=',kbkg
;  print,'kresbkg=',kresbkg
;  help,Adat,Ares,Abkg,Aresbkg
;  help,sigdiff_S,sigdiff_c
;  help,sigdiff_R,sigdiff_RC
;endif


            ;Amp_R = Ares[0,*,kres]
            Amp_RC = (Ares[0,*,kres] - RnumSteveResBkg*AresbkgNew[0,*,0])

            dAmp_RC = sAres[0,*,kres]^(2.0d) + (RnumSteveResBkg*sAbkgNew[0,*,0])^(2.0d)
            DN_RC = SigDiff_R - RResBkg*SigDiff_RC



            dDN = SigDiffe_S^2 + (R*SigDiffe_C)^2
            dDN_RC = SigDiffe_R^2 + (RResBkg*SigDiffe_RC)^2

            ;IQTe = dAmp/Amp^2 + dDN/DN^2 + (sAres[0,*,kres]/Ares[0,*,kres])^2 + (SigDiffe_R/SigDiff_R)^2
            IQTe = dAmp/Amp^2 + dDN/DN^2 + dAmp_RC/Amp_RC^2 + dDN_RC/DN_RC^2

            ;IQT = (Amp*SigDiff_R)/(DN*Amp_R)
            IQT = (Amp/DN)*(DN_RC/Amp_RC)

            IQTe = sqrt(IQTe)*IQT


            ;110804
            S[*,k] = IQT

            sS[*,k] = IQTe
        endelse
    endfor;k

    if ptr_valid(self.S) then ptr_free,self.S
    self.S = ptr_new(S)

    if ptr_valid(self.sS) then ptr_free,self.sS
    self.sS = ptr_new(sS)

    ;THIS MUST GO INTO THE DATA OBJECT ---> IT DOES DUE TO CALL FROM
                                           ;calculateIQT2 BELOW!!!



end;calculateIQT2DatBkgResResbkg


pro ooEcho::calculateIQT2DatResResbkg,resObj,resbkgObj,echoAverageOpt = echoAverageOpt,_Extra=extra
;
;NAME:
;        ooEcho::calculateIQT2DatResResbkg
;
;PURPOSE:
;           Calculate I(Q,t) for each pixel when data, cell and resolution objects
;           are all available.
;PARAMETERS:
;           bkgObj  The background object
;           resObj  The resolution object
;           resbkgObj  A background object specific to the resolution
;KEYWORDS:
;           echoAverageOpt  Option to use echo average for normalization in place if Iup-Idown (G. Ehlers request)

    ;self->addTreatment,'ooEcho::calculateIQT2DatBkgRes'


;FOR TRANSLATION TO IGOR:
;
;dat    data        Sample
;bkg    background  Cell
;res    resolution  Resolution

print,'ooEcho::calculateIQT2DatResResBkg'
    if n_elements(echoAverageOpt) eq 0 then echoAverageOpt = 0

        if self->getProperty(tag='QValsSwitch') eq 0 then begin
            self->calculateQVals
        endif
        if self->getProperty(tag='IupdownSwitch') eq 0 then begin
            self->calculateIup_downVals
        endif

        Tdat = self->getProperty(tag='transmission')
        Adat = (*(self->getProperty(tag='fitparms')))[1,*,*]
        sAdat = (*(self->getProperty(tag='fitparms')))[7,*,*]
        Iupdat = (*(self->getProperty(tag='Iup')))
        sIupdat = (*(self->getProperty(tag='sIup')))
        Idowndat = (*(self->getProperty(tag='Idown')))
        sIdowndat = (*(self->getProperty(tag='sIdown')))
        mondat = ((self->getProperty(tag='preset')))
;print,'509 ooEcho::calculateIQT2DatBkgRes mondat=',mondat

        volfracdat = self->getProperty(tag='volfrac')

;051205
;VOLFRAC CHANGE TO IGOR STYLE FOR DIRECT INSERTION
;INTO THE CODE COPIED FROM IGOR.
;
        volfracdat = 1.0d - volfracdat


;        if bkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
;            bkgObj->calculateQVals
;        endif
;        if bkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
;            bkgObj->calculateIup_downVals
;        endif
;        Tbkg = bkgobj->getProperty(tag='transmission')
;        Abkg = (*(bkgobj->getProperty(tag='fitparms')))[1,*,*]
;        sAbkg = (*(bkgobj->getProperty(tag='fitparms')))[7,*,*]
;        Iupbkg = (*(bkgobj->getProperty(tag='Iup')))
;        sIupbkg = (*(bkgobj->getProperty(tag='sIup')))
;        Idownbkg = (*(bkgobj->getProperty(tag='Idown')))
;        sIdownbkg = (*(bkgobj->getProperty(tag='sIdown')))
;        monbkg = ((bkgobj->getProperty(tag='preset')))
;        volfracbkg = bkgobj->getProperty(tag='volfrac')
;;print,'529 ooEcho::calculateIQT2DatBkgRes monbkg=',monbkg

        if resObj->getProperty(tag='QValsSwitch') eq 0 then begin
            resObj->calculateQVals
        endif
        if resObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            resObj->calculateIup_downVals
        endif
        Tres = resobj->getProperty(tag='transmission')
        Ares = (*(resobj->getProperty(tag='fitparms')))[1,*,*]
        sAres = (*(resobj->getProperty(tag='fitparms')))[7,*,*]
        Iupres = (*(resobj->getProperty(tag='Iup')))
        sIupres = (*(resobj->getProperty(tag='sIup')))
        Idownres = (*(resobj->getProperty(tag='Idown')))
        sIdownres = (*(resobj->getProperty(tag='sIdown')))
        monres = ((resobj->getProperty(tag='preset')))
        volfracres = resobj->getProperty(tag='volfrac')

        volfracres = 1.0d - volfracres



;GET RESBKG INFORMATION
        if resbkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
            resbkgObj->calculateQVals
        endif
        if resbkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            resbkgObj->calculateIup_downVals
        endif
        Tresbkg = resbkgobj->getProperty(tag='transmission')
        Aresbkg = (*(resbkgobj->getProperty(tag='fitparms')))[1,*,*]
        sAresbkg = (*(resbkgobj->getProperty(tag='fitparms')))[7,*,*]
        Iupresbkg = (*(resbkgobj->getProperty(tag='Iup')))
        sIupresbkg = (*(resbkgobj->getProperty(tag='sIup')))
        Idownresbkg = (*(resbkgobj->getProperty(tag='Idown')))
        sIdownresbkg = (*(resbkgobj->getProperty(tag='sIdown')))
        monresbkg = ((resbkgobj->getProperty(tag='preset')))
        volfracresbkg = resbkgobj->getProperty(tag='volfrac')







    szdat = size(Adat)
;    szbkg = size(Abkg)
    szres = size(Ares)
    szresbkg = size(Aresbkg)
    ;print,'971 ooEcho::calculateIQT2DatBkgRes szdat=',szdat
    ;print,'972 ooEcho::calculateIQT2DatBkgRes szbkg=',szbkg
    ;print,'973 ooEcho::calculateIQT2DatBkgRes szres=',szres

    Sbar_dat = dblarr(szdat[2],szdat[3])
    sSbar_dat = dblarr(szdat[2],szdat[3])
    Sbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    sSbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    S = dblarr(szdat[2],szdat[3])
    sS = dblarr(szdat[2],szdat[3])


    taudat = *(self->getProperty(tag='fourierTime'))
    for k=0,szdat[3]-1 do begin
        ;LRK - THESE WILL NOT BE USED IN THE CASE OF NO BKG
        ;RnumSteve = (double(mondat)/double(monbkg))*Tdat/Tbkg  
        ;R = volfracdat*RnumSteve

        ;LRK - ADD FOR ANTONIO AND MATHS RESBKG SUBTRACTION
        RnumSteveResBkg = (double(monres)/double(monresbkg))*Tres/Tresbkg
        RResBkg = volfracres*RnumSteveResBkg



;        kbkg = self->resIndex(taudat[k],bkgobj)
;
;        ;IF kbkg eq -1 THEN GET INTERP BKG(taudat[k],bkgobj)
;        ;Iup,down;sIup,down = zeroth ONES.
;        if kbkg ne -1 then begin
;            AbkgNew = Abkg[0,*,kbkg]
;            sAbkgNew = sAbkg[0,*,kbkg]
;            IdownbkgNew = Idownbkg[*,kbkg]
;            IupbkgNew = Iupbkg[*,kbkg]
;            sIdownbkgNew = sIdownbkg[*,kbkg]
;            sIupbkgNew = sIupbkg[*,kbkg]
;        endif else begin
;            print,'Interpolating background, getting zeroth values for Iup,down'
;            AbkgNew = self->getInterpBkg(taudat[k],bkgobj)
;            sAbkgNew = self->getInterpsBkg(taudat[k],bkgobj)
;            IdownbkgNew = Idownbkg[*,0]
;            IupbkgNew = Iupbkg[*,0]
;            sIdownbkgNew = sIdownbkg[*,0]
;            sIupbkgNew = sIupbkg[*,0]
;        endelse


        ;LRK - ADD FOR ANTONIO AND MATHS RESBKG SUBTRACTION
        ;kresbkg = self->resIndex(taudat[k],resbkgobj)  :NOTE THE USE OF resobj HERE:
        kresbkg = resobj->resIndex(taudat[k],resbkgobj)
        if kresbkg ne -1 then begin
            AresbkgNew = Aresbkg[0,*,kresbkg]
            sAresbkgNew = sAresbkg[0,*,kresbkg]
            IdownresbkgNew = Idownresbkg[*,kresbkg]
            IupresbkgNew = Iupresbkg[*,kresbkg]
            sIdownresbkgNew = sIdownresbkg[*,kresbkg]
            sIupresbkgNew = sIupresbkg[*,kresbkg]
        endif else begin
            print,'Interpolating res background, getting zeroth values for Iup,down'
            AresbkgNew = resobj->getInterpBkg(taudat[k],resbkgobj)
            sAresbkgNew = resobj->getInterpsBkg(taudat[k],resbkgobj)
            IdownresbkgNew = Idownresbkg[*,0]
            IupresbkgNew = Iupresbkg[*,0]
            sIdownresbkgNew = sIdownresbkg[*,0]
            sIupresbkgNew = sIupresbkg[*,0]
        endelse

        kres = self->resIndex(taudat[k],resobj)

        if (kres lt 0) then begin;or (kbkg lt 0) then begin
            ;print,'kres,kbkg = ',kres,kbkg
            ;040805
            S[*,k] = double('Nan')
            sS[*,k] = double('Nan')
        endif else begin
            ;print,taudat[k]
            ;help,AbkgNew
            Amp = (Adat[0,*,k]); - RnumSteve*AbkgNew[0,*,0])

            dAmp = sAdat[0,*,k]^(2.0d); + (RnumSteve*sAbkgNew[0,*,0])^(2.0d)

            SigDiff_S = Idowndat[*,k]-Iupdat[*,k]
            ;SigDiff_C = IdownbkgNew[*,0]-IupbkgNew[*,0]
            DN = SigDiff_S; - R*SigDiff_C

            SigDiffe_S = sqrt(sIdowndat[*,k]^2 + sIupdat[*,k]^2)
            ;SigDiffe_C = sqrt(sIdownbkgNew[*,0]^2 + sIupbkgNew[*,0]^2)


        ;LRK - CHANGE THIS FOR ANTONIO AND MATHS RESBKG SUBTRACTION
    
            SigDiffe_R = sqrt(sIdownres[*,kres]^2 + sIupres[*,kres]^2)
            SigDiffe_RC = sqrt(sIdownresbkgNew[*,0]^2 + sIupresbkgNew[*,0]^2)

            SigDiff_R = Idownres[*,kres] - Iupres[*,kres]
            SigDiff_RC = IdownresbkgNew[*,0]-IupresbkgNew[*,0]

            ;Amp_R = Ares[0,*,kres]
            Amp_RC = (Ares[0,*,kres] - RnumSteveResBkg*AresbkgNew[0,*,0])

            dAmp_RC = sAres[0,*,kres]^(2.0d) + (RnumSteveResBkg*sAresbkgNew[0,*,0])^(2.0d)
            DN_RC = SigDiff_R - RResBkg*SigDiff_RC



            dDN = SigDiffe_S^2; + (R*SigDiffe_C)^2
            dDN_RC = SigDiffe_R^2 + (RResBkg*SigDiffe_RC)^2

            ;IQTe = dAmp/Amp^2 + dDN/DN^2 + (sAres[0,*,kres]/Ares[0,*,kres])^2 + (SigDiffe_R/SigDiff_R)^2
            IQTe = dAmp/Amp^2 + dDN/DN^2 + dAmp_RC/Amp_RC^2 + dDN_RC/DN_RC^2

            ;IQT = (Amp*SigDiff_R)/(DN*Amp_R)
            IQT = (Amp/DN)*(DN_RC/Amp_RC)

            IQTe = sqrt(IQTe)*IQT


            ;110804
            S[*,k] = IQT

            sS[*,k] = IQTe
        endelse
    endfor;k

    if ptr_valid(self.S) then ptr_free,self.S
    self.S = ptr_new(S)

    if ptr_valid(self.sS) then ptr_free,self.sS
    self.sS = ptr_new(sS)

    ;THIS MUST GO INTO THE DATA OBJECT ---> IT DOES DUE TO CALL FROM
                                           ;calculateIQT2 BELOW!!!



end;calculateIQT2DatResResbkg



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::calculateIQT2DatBkgRes,bkgObj,resObj,echoAverageOpt = echoAverageOpt,_Extra=extra
;
;NAME:
;        ooEcho::calculateIQT2DatBkgRes
;
;PURPOSE:
;           Calculate I(Q,t) for each pixel when data, cell and resolution objects
;           are all available.
;PARAMETERS:
;           bkgObj  The background object
;           resObj  The resolution object
;KEYWORDS:
;           echoAverageOpt  Option to use echo average for normalization in place if Iup-Idown (G. Ehlers request)

    ;self->addTreatment,'ooEcho::calculateIQT2DatBkgRes'


;FOR TRANSLATION TO IGOR:
;
;dat    data        Sample
;bkg    background  Cell
;res    resolution  Resolution

    ;072204
    ;
    ;CALCULATE THE POINT-BY-POINT I(Q,t) VALUES FOR
    ;THE CASE WHERE THERE ARE ONLY DATA AND
    ;BACKGROUND OBJECTS.
    ;
    ;PERHAPS THIS SHOULD BECOME A FUNCTION THAT
    ;RETURNS THE Sbar_dat SO THAT IT IS AVAILABLE
    ;FOR ALL THE CASES
print,'ooEcho::calculateIQT2DatBkgRes'
    if n_elements(echoAverageOpt) eq 0 then echoAverageOpt = 0

        if self->getProperty(tag='QValsSwitch') eq 0 then begin
            self->calculateQVals
        endif
        if self->getProperty(tag='IupdownSwitch') eq 0 then begin
            self->calculateIup_downVals
        endif

        Tdat = self->getProperty(tag='transmission')
        Adat = (*(self->getProperty(tag='fitparms')))[1,*,*]
        sAdat = (*(self->getProperty(tag='fitparms')))[7,*,*]
        Iupdat = (*(self->getProperty(tag='Iup')))
        sIupdat = (*(self->getProperty(tag='sIup')))
        Idowndat = (*(self->getProperty(tag='Idown')))
        sIdowndat = (*(self->getProperty(tag='sIdown')))
        mondat = ((self->getProperty(tag='preset')))
;print,'509 ooEcho::calculateIQT2DatBkgRes mondat=',mondat

        volfracdat = self->getProperty(tag='volfrac')

;051205
;VOLFRAC CHANGE TO IGOR STYLE FOR DIRECT INSERTION
;INTO THE CODE COPIED FROM IGOR.
;
        volfracdat = 1.0d - volfracdat


        if bkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
            bkgObj->calculateQVals
        endif
        if bkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            bkgObj->calculateIup_downVals
        endif
        Tbkg = bkgobj->getProperty(tag='transmission')
        Abkg = (*(bkgobj->getProperty(tag='fitparms')))[1,*,*]
        sAbkg = (*(bkgobj->getProperty(tag='fitparms')))[7,*,*]
        Iupbkg = (*(bkgobj->getProperty(tag='Iup')))
        sIupbkg = (*(bkgobj->getProperty(tag='sIup')))
        Idownbkg = (*(bkgobj->getProperty(tag='Idown')))
        sIdownbkg = (*(bkgobj->getProperty(tag='sIdown')))
        monbkg = ((bkgobj->getProperty(tag='preset')))
        volfracbkg = bkgobj->getProperty(tag='volfrac')
;print,'529 ooEcho::calculateIQT2DatBkgRes monbkg=',monbkg

        if resObj->getProperty(tag='QValsSwitch') eq 0 then begin
            resObj->calculateQVals
        endif
        if resObj->getProperty(tag='IupdownSwitch') eq 0 then begin
            resObj->calculateIup_downVals
        endif
        Tres = resobj->getProperty(tag='transmission')
        Ares = (*(resobj->getProperty(tag='fitparms')))[1,*,*]
        sAres = (*(resobj->getProperty(tag='fitparms')))[7,*,*]
        Iupres = (*(resobj->getProperty(tag='Iup')))
        sIupres = (*(resobj->getProperty(tag='sIup')))
        Idownres = (*(resobj->getProperty(tag='Idown')))
        sIdownres = (*(resobj->getProperty(tag='sIdown')))
        monres = ((resobj->getProperty(tag='preset')))
        volfracres = resobj->getProperty(tag='volfrac')


    szdat = size(Adat)
    szbkg = size(Abkg)
    szres = size(Ares)
    ;print,'971 ooEcho::calculateIQT2DatBkgRes szdat=',szdat
    ;print,'972 ooEcho::calculateIQT2DatBkgRes szbkg=',szbkg
    ;print,'973 ooEcho::calculateIQT2DatBkgRes szres=',szres

    Sbar_dat = dblarr(szdat[2],szdat[3])
    sSbar_dat = dblarr(szdat[2],szdat[3])
    Sbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    sSbar_res = dblarr(szdat[2],szdat[3]) ; SAME SIZE AS DATA Sbar
    S = dblarr(szdat[2],szdat[3])
    sS = dblarr(szdat[2],szdat[3])


;    ;033105
;    ;GET MASKS HERE AND APPLY AFTER resIndex BELOW
;    maskdat = (*(self->getProperty(tag='mask2d')))
;    if min(maskdat) eq -1 then $
;        maskdat[where(maskdat eq -1)] = 0
;    maskres = (*(resobj->getProperty(tag='mask2d')))
;    if min(maskres) eq -1 then $
;        maskres[where(maskres eq -1)] = 0


    taudat = *(self->getProperty(tag='fourierTime'))
    for k=0,szdat[3]-1 do begin
        RnumSteve = (double(mondat)/double(monbkg))*Tdat/Tbkg
        R = volfracdat*RnumSteve

        kbkg = self->resIndex(taudat[k],bkgobj)

        ;IF kbkg eq -1 THEN GET INTERP BKG(taudat[k],bkgobj)
        ;Iup,down;sIup,down = zeroth ONES.
        if kbkg ne -1 then begin
            AbkgNew = Abkg[0,*,kbkg]
            sAbkgNew = sAbkg[0,*,kbkg]
            IdownbkgNew = Idownbkg[*,kbkg]
            IupbkgNew = Iupbkg[*,kbkg]
            sIdownbkgNew = sIdownbkg[*,kbkg]
            sIupbkgNew = sIupbkg[*,kbkg]
        endif else begin
            print,'Interpolating background, getting zeroth values for Iup,down'
            AbkgNew = self->getInterpBkg(taudat[k],bkgobj)
            sAbkgNew = self->getInterpsBkg(taudat[k],bkgobj)
            IdownbkgNew = Idownbkg[*,0]
            IupbkgNew = Iupbkg[*,0]
            sIdownbkgNew = sIdownbkg[*,0]
            sIupbkgNew = sIupbkg[*,0]
        endelse

        kres = self->resIndex(taudat[k],resobj)



        if (kres lt 0) then begin;or (kbkg lt 0) then begin
            ;print,'kres,kbkg = ',kres,kbkg
            ;040805
            S[*,k] = double('Nan')
            sS[*,k] = double('Nan')
        endif else begin
            ;print,taudat[k]
            ;help,AbkgNew
            Amp = (Adat[0,*,k] - RnumSteve*AbkgNew[0,*,0])

            dAmp = sAdat[0,*,k]^(2.0d) + (RnumSteve*sAbkgNew[0,*,0])^(2.0d)

            SigDiff_S = Idowndat[*,k]-Iupdat[*,k]
            SigDiff_C = IdownbkgNew[*,0]-IupbkgNew[*,0]

;            DN = ((Idowndat[*,k]-Iupdat[*,k]) - $
;                        R*(IdownbkgNew[*,0]-IupbkgNew[*,0]))
            DN = SigDiff_S - R*SigDiff_C

            SigDiffe_S = sqrt(sIdowndat[*,k]^2 + sIupdat[*,k]^2)

        ;031005 FIXED INDEX PROBLEM HERE
            SigDiffe_C = sqrt(sIdownbkgNew[*,0]^2 + sIupbkgNew[*,0]^2)
            SigDiffe_R = sqrt(sIdownres[*,kres]^2 + sIupres[*,kres]^2)
            SigDiff_R = Idownres[*,kres] - Iupres[*,kres]
            Amp_R = Ares[0,*,kres]

            dDN = SigDiffe_S^2 + (R*SigDiffe_C)^2

;051905
;if k eq 0 then print,dDN,format='(16f10.2)'
;if k eq 0 then begin
;    print,SigDiffe_C,format='(16f10.2)'
;    print,"R         ",R
;    print,"Volfrac   ",volfracdat
;    print,"SamMon    ",mondat   ;THESE WERE int SO mondat/monbkg eq 1 ALWAYS!!!
;    print,"CellMon   ",monbkg   ;THIS WAS THE FINAL MISTAKE!!!! IT IS NOW FIXED!!!
;    print,"SamTrans  ",Tdat
;    print,"CellTrans ",Tbkg
;
;endif
;
;if k eq 0 then print,SigDiffe_C,format='(16f10.2)'
            IQTe = dAmp/Amp^2 + dDN/DN^2 + (sAres[0,*,kres]/Ares[0,*,kres])^2 + (SigDiffe_R/SigDiff_R)^2
;if k eq 0 then begin
;print,'dAmp         ',dAmp[8+8*16]
;print,'Amp          ',Amp[8+8*16]
;print,'dDN          ',dDN[8+8*16]
;print,'DN           ',DN[8+8*16]
;print,'sAres        ',sAres[0,8*16+8,kres]
;print,'Ares         ',Ares[0,8*16+8,kres]
;print,'SigDiffe_R   ',SigDiffe_R[8+8*16]
;print,'SigDiff_R    ',SigDiff_R[8+8*16]
;print,'IQTe         ',IQTe[8+8*16]
;endif

            IQT = (Amp*SigDiff_R)/(DN*Amp_R)

            IQTe = sqrt(IQTe)*IQT

;if k eq 0 then begin
;print,'IQT          ',IQT[8+8*16]
;print,'IQTe         ',IQTe[8+8*16]
;endif

            ;110804
            S[*,k] = IQT

            sS[*,k] = IQTe
        endelse
    endfor;k

    if ptr_valid(self.S) then ptr_free,self.S
    self.S = ptr_new(S)

    if ptr_valid(self.sS) then ptr_free,self.sS
    self.sS = ptr_new(sS)

    ;THIS MUST GO INTO THE DATA OBJECT ---> IT DOES DUE TO CALL FROM
                                           ;calculateIQT2 BELOW!!!



end;calculateIQT2DatBkgRes
pro ooEcho::calculateIQT2,bkgObj = bkgObj,$
                          resObj = resObj,$
                          resBkgObj = resBkgObj,$
                          datObj = datObj,$
                          echoAverageOpt = echoAverageOpt,$
                          failure=failure,$
                          fitParBuf = fitParBuf, $
                          daveVer=daveVer, $
                          _Extra=extra

;
;NAME:
;        ooEcho::calculateIQT2
;
;PURPOSE:
;           Call the appropriate I(Q,t) calculation function.
;PARAMETERS:
;           none
;KEYWORDS:
;           bkgobj  ooEcho objects to be used in calculation.
;           resobj
;           datobj
;           echoAverageOpt  Option to use the echo average for I(Q,t) Normalization.  (for G. Ehlers)



if n_elements(echoAverageOpt) eq 0 then EchoAverageOpt = 0
failure=0
if ~isa(daveVer) then daveVer=''
;DETERMINE WHICH OBJECTS ARE AVAILABLE AND SEND TO
;PROPER CALCULATION ROUTINE TO PROCESS.
logBuf = 'NIST Center for Neutron Research'
logBuf = [logBuf,'NSE Reduction Module']
logBuf = [logBuf,'Data Analysis and Visialization Environment']
logBuf = [logBuf,'https://www.ncnr.nist.gov/dave/download.html']
logBuf = [logBuf,'DAVE Version '+daveVer,' ']
logBuf = [logBuf,'Session log for reduced I(Q,t) output']
logBuf = [logBuf,'Timestamp: '+systime()]
logBuf = [logBuf,' ']

logBuf = [logBuf,'2D Detector Details:']
logBuf = [logBuf,'--------------------']
logBuf = [logBuf,('  Center x: ' + string(self.x_cen))]
logBuf = [logBuf,('  Center y: ' + string(self.y_cen))]
;logBuf = [logBuf,'Detector binning factor: ']
logBuf = [logBuf,'  Nos of pixels, x: '+string(self.x_dim,format='(I2)')]
logBuf = [logBuf,'  Nos of pixels, y: '+string(self.y_dim,format='(I2)')]

logBuf = [logBuf,' ']
logBuf = [logBuf,'  Detector pixel masking (1 => pixel was used in calculation): ']
logBuf = [logBuf,'  Pixels can be masked out. Pixel masks may be different for each fourier time']
logBuf = [logBuf,'  Hence the fourier times associated with each pixel mask map are specified']
mfm = '(4X,'+Strtrim(String(self.x_dim,format='(I2)'),2)+'(I2,1X))'

mask2D = (*self.mask2d)
nft = self.no_of_fourier_times
ftimes = (*self.fouriertime)
ind = Indgen(self.x_dim)

    
; Repeat until all ftimes are processed
; - find ftimes with same mask and display the mask in the logfile
nProcessed = 0
indicesTP = indgen(nft) ; indices to process
while (nProcessed lt nft) do Begin
  sameFT = indicesTP[0]
  notSameFT = []
  nTP = indicesTP.length
  maskIndex = indicesTP[0]
  if (nTP eq 1) then begin
    ftfm = '(F6.3)'
    logBuf = [logBuf,'  Pixel mask for Fourier times:'+String(ftimes[sameFT]*1e9, format=ftfm) + ' nanoseconds']
    nProcessed++
  endif else begin
    for i=1,nTP-1 do if (mask2D[*,indicesTP[0]].Equals(mask2D[*,indicesTP[i]])) then $
        sameFT = [sameFT,indicesTP[i]] else $
        notSameFT = [notSameFT,indicesTP[i]]
    nProcessed += sameFT.length
    ftfm = '('+Strtrim(String(sameFT.length,format='(I2)'),2)+'(F6.3,1X))'
    logBuf = [logBuf,'  Pixel mask for Fourier times:'+String(ftimes[sameFT]*1e9, format=ftfm) + ' nanoseconds']
    indicesTP = notSameFT
  endelse
  for i=0,self.y_dim-1 do logBuf = [logBuf,String(mask2D[ind+i*self.y_dim,maskIndex], format=mfm)]
endwhile
    
logBuf = [logBuf,' ']
logBuf = [logBuf,'  Detector echo phase masking (1 => phase point was included in echo fits): ']
logBuf = [logBuf,'  The echo (intensity vs phase plot) at each pixel and fourier time is fitted']
logBuf = [logBuf,'  At each fourier time, any particular phase point can be masked out']
logBuf = [logBuf,'  The map below indicates which phase points, if any were masked (has value 0)']
logBuf = [logBuf,' ']
logBuf = [logBuf,'  Fourier time            Mask value for each phase point']
phasePointMask = []
for i=0,nft-1 do begin
  phasePointMask = [phasePointMask, string(ftimes[i]*1e9,(*self.mask1d)[*,i], format='(6X,F7.4,2X,24(I1,1X))')]
endfor
logBuf = [logBuf,phasePointMask]

logBuf = [logBuf,' ']

situation = 0
if n_elements(datobj) gt 0 then begin
  ;033105
  ;COMMENT OUT THE NEXT LINE
  ;void = dialog_message('RESULTS WILL BE PLACED INTO THE DATA OBJECT.',/information)
  Tsamp = datobj->Getproperty(tag='transmission')
  VFsamp = datobj->Getproperty(tag='volfrac')
  mon    = datobj->Getproperty(tag='preset')
  logBuf = [logBuf,'Raw datasets utilized for this reduction:']
  logBuf = [logBuf,'-----------------------------------------']
  logBuf = [logBuf,'Sample dataset(s):']
  logBuf = [logBuf,'  Filename = ' + file_basename(datObj->getProperty(tag='filename'))]
  logBuf = [logBuf,'  Title = '+datObj->getProperty(tag='comment')]
  logBuf = [logBuf,'  Mon Preset = '+string(mon)]
  logBuf = [logBuf,'  Transmission: '+string(Tsamp)]
  logBuf = [logBuf,'  Volume fraction: '+string(VFsamp)]
  if datObj->getProperty(tag='QValsSwitch') eq 0 then begin
      ;print,datObj->getProperty(tag='QValsSwitch')
      datObj->calculateQVals
  endif
  if datObj->getProperty(tag='IupdownSwitch') eq 0 then begin
      datObj->calculateIup_downVals
  endif
  situation = situation + 4
  
  ; Retrieve the fit parameters as a string array
  datObj->writeFitParmsToString, sampfitParBuf, /noMask
endif else begin
  void = dialog_message('PLEASE SELECT A VALID DATA OBJECT FOR I(Q,t) CALCULATION.',/error)
  return
endelse

if n_elements(bkgobj) gt 0 then begin
  Tcell = bkgobj->Getproperty(tag='transmission')
  VFcell = bkgobj->Getproperty(tag='volfrac')
  mon = bkgobj->Getproperty(tag='preset')
  logBuf = [logBuf,'Background dataset(s):']
  logBuf = [logBuf,'  Filename = ' + file_basename(bkgObj->Getproperty(tag='filename'))]
  logBuf = [logBuf,'  Title = '+bkgObj->Getproperty(tag='comment')]
  logBuf = [logBuf,'  Monitor preset: '+string(mon)]
  logBuf = [logBuf,'  Transmission: '+String(Tcell)]
  logBuf = [logBuf,'  Volume fraction: '+string(VFcell)]
    if bkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
        ;print,bkgObj->getProperty(tag='QValsSwitch')
        bkgObj->calculateQVals
    endif
    if bkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
        bkgObj->calculateIup_downVals
    endif
    situation = situation + 1
    
    ; Retrieve the fit parameters as a string array
    bkgObj->Writefitparmstostring, bkgdFitParBuf, /noMask
endif

if n_elements(resobj) gt 0 then begin
  Tres   = resObj->Getproperty(tag='transmission')
  VFres  = resObj->Getproperty(tag='volfrac')
  mon    = resObj->Getproperty(tag='preset')
  logBuf = [logBuf,'Resolution dataset(s):']
  logBuf = [logBuf,'  Filename = ' + file_basename(resObj->Getproperty(tag='filename'))]
  logBuf = [logBuf,'  Title = '+resObj->Getproperty(tag='comment')]
  logBuf = [logBuf,'  Monitor preset: '+String(mon)]
  logBuf = [logBuf,'  Transmission: '+string(Tres)]
  logBuf = [logBuf,'  Volume fraction: '+string(VFres)]
    if resObj->getProperty(tag='QValsSwitch') eq 0 then begin
        ;print,datObj->getProperty(tag='QValsSwitch')
        resObj->calculateQVals
    endif
    if resObj->getProperty(tag='IupdownSwitch') eq 0 then begin
        resObj->calculateIup_downVals
    endif
    situation = situation + 2
    ; Retrieve the fit parameters as a string array
    resObj->Writefitparmstostring, resFitParBuf, /noMask
endif

if n_elements(resbkgobj) gt 0 then begin
  Trescell   = resbkgobj->Getproperty(tag='transmission')
  VFrescell  = resbkgobj->Getproperty(tag='volfrac')
  mon  = resbkgobj->Getproperty(tag='preset')
  logBuf = [logBuf,'Resolution Background dataset(s):']
  logBuf = [logBuf,'  Filename = ' + file_basename(resbkgObj->Getproperty(tag='filename'))]
  logBuf = [logBuf,'  Title = '+resbkgObj->Getproperty(tag='comment')]
  logBuf = [logBuf,'  Monitor preset: '+string(mon)]
  logBuf = [logBuf,'  Transmission: '+String(Trescell)]
  logBuf = [logBuf,'  Volume fraction: '+string(VFrescell)]
    if resbkgObj->getProperty(tag='QValsSwitch') eq 0 then begin
        ;print,datObj->getProperty(tag='QValsSwitch')
        resbkgObj->calculateQVals
    endif
    if resbkgObj->getProperty(tag='IupdownSwitch') eq 0 then begin
        resbkgObj->calculateIup_downVals
    endif
    situation = situation + 20
    ; Retrieve the fit parameters as a string array
    resbkgObj->Writefitparmstostring, resBkgdFitParBuf, /noMask
endif
    
narcs = datobj->getProperty(tag='narcs')
lambda = 1e10 * datobj->Getproperty(tag='lambda')
qvals = (*(datObj->getProperty(tag='qvals')))[*,0]
qmin = min(qvals)
qmax = max(qvals)
qstep = (qmax - qmin)/(narcs-1)
qindices = round((qvals-qmin)/qstep)
qarcs1 = fltarr(narcs)
qarcs2 = Fltarr(narcs)
mask = (*self.mask2d)[*,0]  ; use the first ft
for i = 0,narcs-1 do begin
  index = where((qindices eq i), nIndex)
  if (nIndex gt 0) then begin
    qarcs1[i] = total(qvals[index])/nIndex
  endif
  index = Where((qindices eq i) and (mask eq 1), nIndex)
  if (nIndex gt 0) then begin
    qarcs2[i] = Total(qvals[index])/nIndex
  endif
endfor

logBuf = [logBuf,' ','Momentum transfer details:']
logBuf = [logBuf,    '--------------------------']
logBuf = [logBuf,'  Wavelength: '+string(lambda,format='(F6.3)')+' angstrom']
logBuf = [logBuf,'  Wavevector: '+String(Self.qactual,format='(F6.3)')+' 1/angstrom']
logBuf = [logBuf,'  Number of pixels in 2D detector:'+string(n_elements(qvals),format='(I3)')]
logBuf = [logBuf,'  Minimum Q (2D detector): '+string(qmin,format='(F6.4)')]
logBuf = [logBuf,'  Maximum Q (2D detector): '+string(qmax,format='(F6.4)')]
logBuf = [logBuf,'  Nmber of Q Arcs/Zones within detector: '+string(narcs,format='(I5)')]
logBuf = [logBuf,'  Therefore Q step/bin: '+string(qstep,format='(F6.4)')+' 1/angstrom']
logBuf = [logBuf,'  Mean Q value for each zone (without mask): '+string(qarcs1,format='(5(F6.4,2X))')]
logBuf = [logBuf,'  Mean Q value for each zone (with masking): '+String(qarcs2,format='(5(F6.4,2X))')]

; Append the fit parameters to a running a fit parameter buffer
fitParBuf = []
if (isa(sampFitParBuf)) then fitParBuf = [fitParBuf,sampFitParBuf]
if (Isa(bkgdFitParBuf)) then fitParBuf = [fitParBuf,' ',bkgdFitParBuf]
if (Isa(resFitParBuf)) then fitParBuf = [fitParBuf,' ',resFitParBuf]
if (Isa(resBkgdFitParBuf)) then fitParBuf = [fitParBuf,' ',resBkgdFitParBuf]

;120204
;THE NEXT THREE FUNCTIONS NEED TO BE UPDATED TO
;MATCH THE
case situation of
4:begin
    ;print,'I(Q,t) DATA ONLY'
    datObj->calculateIQT2DatOnly,echoAverageOpt = echoAverageOpt
end;4
5:begin
    ;print,'I(Q,t) DATA AND BACKGROUND ONLY'
    datObj->calculateIQT2DatBkg,bkgObj,echoAverageOpt = echoAverageOpt
end;5
6:begin
    ;print,'I(Q,t) DATA AND RESOLUTION ONLY'
    datObj->calculateIQT2DatRes,resObj,echoAverageOpt = echoAverageOpt
end;6
7:begin
    ;print,'I(Q,t) DATA, BACKGROUND AND RESOLUTION'
    datObj->calculateIQT2DatBkgRes,bkgObj,resObj,echoAverageOpt = echoAverageOpt
end;7
else:begin
    if obj_valid(datobj) ne 0 $
      and obj_valid(bkgobj) ne 0 $
       and obj_valid(resObj) ne 0 $
         and obj_valid(resbkgObj) ne 0 then begin
            datObj->calculateIQT2DatBkgResResBkg,bkgObj,resObj,resbkgobj,echoAverageOpt = echoAverageOpt
          
    endif else begin
      if obj_valid(datobj) ne 0 $
         and obj_valid(resObj) ne 0 $
           and obj_valid(resbkgObj) ne 0 then begin
              datObj->calculateIQT2DatResResBkg,resObj,resbkgobj,echoAverageOpt = echoAverageOpt
            
      endif else begin
        print,'1758 ooEcho::calculateIQT2 Confused by available objects in Sbar calculation.'
        void = dialog_message('ooEcho::calculateIQT2      Confused by that set of input data.')
        failure=1
        return
      endelse
    endelse

end;else
endcase

if ptr_valid(self.IQTInfo) then ptr_free,self.IQTInfo
self.IQTInfo = ptr_new(logBuf)
end;calculateIQT2


function ooEcho::fitIQT,stretchExp=stretchExp,$
                        expDecay=expDecay,$
                        custom=custom,$
                        apparentdiffusion=apparentdiffusion,$
                        dumparms_error=dumparms_error,$
                        _Extra=extra
;
;NAME:
;        ooEcho::fitIQT
;
;PURPOSE:
;           FIT THE I(Q,t) DATA WITH THE FUNCTION OF THE USER'S CHOICE AND
;           RET
;PARAMETERS:
;           none
;KEYWORDS:
;           stretchExp      FUNCTIONAL SELECTIONS FOR
;           expDecay
;           apparentDiffusion   SAME AS EXP DECAY BUT WITH t*Q^2 AS THE INDEPENDENT VARIABLE.
;           custom              SET UP FOR HANDLING OF A FUTURE CUSTOM OPTION.
;           dumparms_error      THE SIGMAS FOR THE FIT PARAMETERS.
;_EXTRA - is used to catch unhandled keywords.
;
;RETURN VALUE:
;               AN ARRAY OF I(Q,t) VALUES  --- DO I WANT TO RETURN THE PARAMETERS?
;
;USAGE:
;           dumfit = ooEchoRef->fitIQT(stretchExp=0,expDecay=0,custom='P[0]+P[1]*exp(-1.0*P[2]*t)')
;

    ;self->addTreatment,'ooEcho::fitIQT'



    ;NEED TO STORE FITPARMS AND ATTACH TO THE LEGEND WHEN THEY ARE AVAILABLE.
    ;MAYBE THESE SHOULD BE STORED IN THE DATA OBJECT AND THEN RETRIEVED AS
    ;NEEDED IN THE DRAW METHOD.


    sorig = *self.IQTinfo
    sfit = ['# Fitparms','#']

    fitchoice = 0
    if n_elements(stretchexp) eq 0 then stretchexp=0
    if n_elements(expdecay) eq 0 then expdecay=0
    if n_elements(apparentdiffusion) eq 0 then apparentdiffusion = 0



    if stretchexp eq 0 then begin
        if apparentdiffusion eq 0 then begin
            fitchoice = 0   ;exp decay
        endif else begin
            fitchoice = 2   ;apparentDiffusion
        endelse
    endif else begin
        fitchoice = 1       ;stretched exponontial
    endelse


    ;print,'fitchoice=',fitchoice

    case fitchoice of
    0:begin;EXP DECAY
        ;print,'EXP DECAY'
        sfit = [sfit,'# 0 Exponential Decay','# q              A                              1/Tau       chisq',$
                     '# begin']
        FORMAT = '("# ",d6.4,"     ",d6.4," +/- ",d6.4,"     ",e11.4," +/- ",e11.4,"     ",d8.4)'

        sz = size(*self.IQT)

        nparms = 2

        dumfits = dindgen(sz[1],nparms)
        ;if arg_present(dumparms_error) gt 0 then
        dumparms_error = 0.0d*dumfits

        dumfits[*,0] = 1.0
        dumfits[*,1] = 10.0^(13.0)

        for i=0,sz[1]-1 do begin
            x = *self.fourierTime ;*(((*self.qarcs)[i])^2.0)
            y = (*self.IQT)[i,*]
            sy = (*self.sIQT)[i,*]
;            print,'x=',x
;            print,'y=',transpose(y)
;            print,'sy=',transpose(sy)

            ny = where(y ne double('Nan'))
            if ny[0] ne -1 then begin
                x = x[where(y ne double('Nan'))]
                y = y[where(y ne double('Nan'))]
                sy = sy[where(sy ne double('Nan'))]
            endif

            nz  = where(sy eq 0.0)
            if nz[0] ne -1 then begin
                sy[where(sy eq 0.0)] = 1.0d
            endif

            start = [1.0d,100000000.0d]

            parinfo = replicate({value:0.0d,$
                                 fixed:0,$
                                 limited:[0,0], $
                                 limits:[0.0d,0.0d],$
                                 parname:'',tied:''},$
                                 2)
            parinfo[*].value = start
            parinfo[*].fixed = 0
            parinfo[0].limits = [0.00000001d,1000.0d]
            parinfo[1].limits = [0.00000001d,100000000000000000000000.0d]
            perror = dindgen(2)
            dumfits[i,*] = mpfitfun('nse_expdecay',x,y,sy,parinfo=parinfo,/quiet,perror=perror,bestnorm=bestnorm)
            if n_elements(bestnorm) eq 0 then bestnorm = n_elements(x)*100000000.0000
            chisq = bestnorm/double(n_elements(x)-2)
            dumparms_error[i,*] = perror

            if strtrim(chisq,2) eq '-NaN' or strtrim(chisq,2) eq 'NaN' then begin
                dumfits[i,*] = double('nan')
                dumparms_error[i,*]  = double('nan')
            endif


;            dumfits[i,*] = mpfitfun('nse_expdecay',x,y,sy,parinfo=parinfo,perror=dumparms_error[i,*])
;            print,i,transpose(dumfits[i,*])
;            print,i,transpose(dumparms_error[i,*])
;            print,(*self.Qarcs)[i],dumfits[i,0],dumparms_error[i,0],$
;                                   dumfits[i,1],dumparms_error[i,1],$
;                                   format=FORMAT
            sadd = string((*self.Qarcs)[i],dumfits[i,0],dumparms_error[i,0],$
                                   dumfits[i,1],dumparms_error[i,1],chisq,$
                                   format=FORMAT)
;            print,sadd
            sfit = [sfit,sadd]
        endfor;i
        sfit = [sfit,'# end']
    end; 0 exp decay
    1:begin;STRETCHED EXPONENTIAL
        sfit = [sfit,'# 1 Stretched Exponential',$
                    '# q              A                           1/Tau                                            Beta      chisq',$
                    '# begin']

        FORMAT = '("# ",d6.4,"     ",d5.3," +/- ",d5.3,"     ",e11.4," +/- ",e11.4,"     ",d5.3," +/- ",d5.3,"     ",d8.4)'

        ;print,'ooecho::fitIQT stretched'
        sz = size(*self.IQT)

        nparms = 3

        dumfits = dindgen(sz[1],nparms)
        if arg_present(dumparms_error) gt 0 then dumparms_error = 0.0*dumfits

        dumfits[*,0] = 1.0d
        dumfits[*,1] = 10.0d^(9.0d)
        dumfits[*,2] = 0.8d
        for i=0,sz[1]-1 do begin
            x = (*self.fourierTime)*(((*self.qarcs)[i])^2.0)
            y = (*self.IQT)[i,*]
            sy = (*self.sIQT)[i,*]

            ny = where(y ne double('Nan'))
            if ny[0] ne -1 then begin
                x = x[where(y ne double('Nan'))]
                y = y[where(y ne double('Nan'))]
                sy = sy[where(sy ne double('Nan'))]
            endif


            nz  = where(sy eq 0.0)
            if nz[0] ne -1 then begin
                sy[where(sy eq 0.0)] = 1.0d
            endif

        ;function nse_stretchexpdecay,X,P;INDEPENDENT VAR IS t*Q^2
            start = [1.0d,1000000000.0d,1.0d]

            parinfo = replicate({value:0.0d,$
                                 fixed:0,$
                                 limited:[0,0], $
                                 limits:[0.0d,0.0d],$
                                 parname:'',tied:''},$
                                 3)
            parinfo[*].value = start
            parinfo[*].fixed = 0
            parinfo[0].limits = [0.00000001d,1000.0d]
            parinfo[1].limits = [0.00000001d,100000000000000000000000.0d]
            parinfo[2].limits = [0.0001,100.0]

            perror = dindgen(3)
            dumfits[i,*] = mpfitfun('nse_stretchexpdecay',x,y,sy,parinfo=parinfo,/quiet,perror=perror,bestnorm=bestnorm);dumparms_error[i,*])
            if n_elements(bestnorm) eq 0 then bestnorm = double('Nan');n_elements(x)*100000000.0000
            chisq = bestnorm/double(n_elements(x)-3)
            dumparms_error[i,*] = perror
            if strtrim(chisq,2) eq '-NaN' or strtrim(chisq,2) eq 'NaN' then begin
                dumfits[i,*] = double('nan')
                dumparms_error[i,*]  = double('nan')
            endif



;            print,i,transpose(dumfits[i,*])
;            print,i,transpose(dumparms_error[i,*])
;            print,(*self.Qarcs)[i],dumfits[i,0],dumparms_error[i,0],$
;                                   dumfits[i,1],dumparms_error[i,1],$
;                                   dumfits[i,2],dumparms_error[i,2],$
;                                   format=FORMAT

            sadd = string((*self.Qarcs)[i],dumfits[i,0],dumparms_error[i,0],$
                                   dumfits[i,1],dumparms_error[i,1],$
                                   dumfits[i,2],dumparms_error[i,2],chisq,$
                                   format=FORMAT)
            ;print,sadd
            sfit = [sfit,sadd]
        endfor;i
        sfit = [sfit,'# end']

    end
    2:begin;APPARENT DIFFUSION
        ;print,'ooecho::apparentdiffusion'
        sfit = [sfit,'# 2 Apparent Diffusion',$
                    '# q              A                              D             chisq','# begin']

        FORMAT = '("# ",d6.4,"     ",d5.3," +/- ",d5.3,"     ",e11.4," +/- ",e11.4,"     ",d8.4)'


        sz = size(*self.IQT)

        nparms = 2

        dumfits = dindgen(sz[1],nparms)
        if arg_present(dumparms_error) gt 0 then dumparms_error = 0.0d*dumfits

        dumfits[*,0] = 1.0
        dumfits[*,1] = 10.0^(13.0)

        for i=0,sz[1]-1 do begin
            x = *self.fourierTime*(((*self.qarcs)[i])^2.0)
            y = (*self.IQT)[i,*]
            sy = (*self.sIQT)[i,*]

            ny = where(y ne double('Nan'))
            if ny[0] ne -1 then begin
                x = x[where(y ne double('Nan'))]
                y = y[where(y ne double('Nan'))]
                sy = sy[where(sy ne double('Nan'))]
            endif


            nz  = where(sy eq 0.0)
            if nz[0] ne -1 then begin
                sy[where(sy eq 0.0)] = 1.0d
            endif


        ;function nse_expdecay,X,P;INDEPENDENT VAR IS t*Q^2
            start = [1.0d,100000000.0d]

            parinfo = replicate({value:0.0d,$
                                 fixed:0,$
                                 limited:[0,0], $
                                 limits:[0.0d,0.0d],$
                                 parname:'',tied:''},$
                                 2)
            parinfo[*].value = start
            parinfo[*].fixed = 0
            parinfo[0].limits = [0.00000001d,1000.0d]
            parinfo[1].limits = [0.00000001d,100000000000000000000000.0d]

            perror = dindgen(2)
            dumfits[i,*] = mpfitfun('nse_expdecay',x,y,sy,parinfo=parinfo,/quiet,perror=perror,bestnorm=bestnorm)
            ;print,bestnorm
            if n_elements(bestnorm) eq 0 then bestnorm = n_elements(x)*100000000.0000
            chisq = bestnorm/double(n_elements(x)-2)
            ;print,'perror=',perror
            dumparms_error[i,*] = perror
            if strtrim(chisq,2) eq '-NaN' or strtrim(chisq,2) eq 'NaN' then begin
                dumfits[i,*] = double('nan')
                dumparms_error[i,*]  = double('nan')
            endif

;            print,i,transpose(dumfits[i,*])
;            print,i,transpose(dumparms_error[i,*])

;            print,(*self.Qarcs)[i],dumfits[i,0],dumparms_error[i,0],$
;                                   dumfits[i,1],dumparms_error[i,1],$
;                                   format=FORMAT
            sadd =  string((*self.Qarcs)[i],dumfits[i,0],dumparms_error[i,0],$
                                   dumfits[i,1],dumparms_error[i,1],chisq,$
                                   format=FORMAT)
            ;print,sadd
            sfit = [sfit,sadd]
        endfor;i
        sfit = [sfit,'# end']
    end;2 - APPARENT DIFFUSION
    else:begin
        ;print,'NO FIT CHOSEN - FITTING TO EXP DECAY.'
        sfit = [sfit,'# 0 Exponential Decay',$
                    '# q              A                              1/Tau','# begin']

        FORMAT = '("# ",d6.4,"     ",d5.3," +/- ",d5.3,"     ",e11.4," +/- ",e11.4,"     ",d8.4)'

        sz = size(*self.IQT)

        nparms = 2

        dumfits = dindgen(sz[1],nparms)
        if arg_present(dumparms_error) gt 0 then dumparms_error = 0.0*dumfits

        dumfits[*,0] = 1.0
        dumfits[*,1] = 10.0^(13.0)
        for i=0,sz[1]-1 do begin
            x = *self.fourierTime
            y = (*self.IQT)[i,*]
            sy = (*self.sIQT)[i,*]
            ny = where(y ne double('Nan'))
            nsy = where(sy ne double('Nan'))

            if ny[0] ne -1 then begin
                x = x[where(y ne double('Nan'))]
                y = y[where(y ne double('Nan'))]
                sy = sy[where(sy ne double('Nan'))]
            endif


            nz  = where(sy eq 0.0)
            if nz[0] ne -1 then begin
                sy[where(sy eq 0.0)] = 1.0d
            endif


            ;function nse_expdecay,X,P;INDEPENDENT VAR IS t*Q^2
            start = [1.0d,100000000.0d]

            parinfo = replicate({value:0.0d,$
                                 fixed:0,$
                                 limited:[0,0], $
                                 limits:[0.0d,0.0d],$
                                 parname:'',tied:''},$
                                 2)
            parinfo[*].value = start
            parinfo[*].fixed = 0
            parinfo[0].limits = [0.00000001d,1000.0d]
            parinfo[1].limits = [0.00000001d,100000000000000000000000.0d]
            perror = dindgen(2)
            dumfits[i,*] = mpfitfun('nse_expdecay',x,y,sy,parinfo=parinfo,/quiet,perror=perror,bestnorm=bestnorm)
            if n_elements(bestnorm) eq 0 then bestnorm = n_elements(x)*100000000.0000
            chisq = bestnorm/double(n_elements(x)-2)
            dumparms_error[i,*] = perror
            if strtrim(chisq,2) eq '-NaN' or strtrim(chisq,2) eq 'NaN' then begin
                dumfits[i,*] = double('nan')
                dumparms_error[i,*]  = double('nan')
            endif
            ;print,i,transpose(dumfits[i,*])
            ;print,i,transpose(dumparms_error[i,*])

            sadd = string((*self.Qarcs)[i],dumfits[i,0],dumparms_error[i,0],$
                                   dumfits[i,1],dumparms_error[i,1],chisq,$
                                   format=FORMAT)
            ;print,sadd
            sfit = [sfit,sadd]
        endfor;i
        sfit = [sfit,'# end']
    end
    endcase;fitchoice


    info = *self.IQTinfo
    fitparmbeginindex = where(stregex(info,'# Fitparms',/boolean))
    ;print,fitparmbeginindex
    if fitparmbeginindex ne -1 then info = info[0:fitparmbeginindex-1]

    info = [info,sfit]
    if ptr_valid(self.IQTinfo) then ptr_free,self.IQTinfo
    self.IQTinfo = ptr_new(info)

    ;print,transpose(info)


    cpdumfits = dumfits
    if ptr_valid(self.IQTFitparms) then ptr_free,self.IQTFitparms
    self.IQTFitparms = ptr_new(cpdumfits)

    return,dumfits
end;fitIQT




pro ooEcho::calculateIQT,bkgObj = bkgObj,$
                         resObj = resObj,$
                         datObj = datObj,_Extra=extra
;
;NAME:
;        ooEcho::calculateIQT
;
;PURPOSE:
;           Call the apropriate I(Q,t) calculation.
;           This version is no longer used and has been replaced with ooEcho::calculateIQT2
;PARAMETERS:
;           none
;KEYWORDS:
;           bkgobj
;           resobj
;           datobj


    ;self->addTreatment,'ooEcho::calculateIQT'

    ;
    ;060404
    ;
    ;PROBLEM WITH THIS METHOD IS THAT IT DOES NOT
    ;ACCOUNT FOR UNEQUAL DATA SET SIZES!!!
    ;
    ;THE INTERPOLATION OF DATA (e.g. LARGER RESOLUTION THAN DATA)
    ;TO MATCH THE DATA SET CHOSEN FOR THE I(Q,t) CALCULATION.
    ;



    ;CALCULATE S(Q,t)/S(Q) FOR SEVERAL CASES:
    ;
    ;1) ONLY self IS AVAILABLE
    ;2) self AND Abkg ARE AVAILABLE
    ;3) self AND Ares ARE AVAILABLE
    ;4) self, Ares AND Abkg ARE AVAILABLE

;
;071404
;
;SITUATIONS 2),4) AND POSSIBLY 3) SHOULD REQUIRE
;CORRECTIONS FOR MONITOR
;
;SITUATIONS 2) AND 4) SHOULD REQUIRE CORRECTIONS FOR
;THE MONITOR, TRANSMISSION AND VOLUME FRACTION.
;
;

    ;071404
    ;
    ;GET THE TRANSMISSION, MONITOR AND VOLUME FRACTION
    ;FROM THE RESPECTIVE OBJECTS.
    ;

    Tdat = 1.0
    Tbkg = 1.0      ;TRANSMISSIONS FOR BACKGROUND AND RESOLUTION.
    Tres = 1.0

;    mondat = 8
;    monbkg = 8      ;MONITORS FOR BACKGROUND AND RESOLUTION.
;    monres = 8

    volfrac = 1.0   ;VOLUME FRACTION OF SOLVENT IN SAMPLE CELL.



    ;SET UP Q VALUE ARRAY VALID FOR ALL SETS
    self->calculateQVals


    situation = 1   ;INITIALIZE VARIABLE
    ;GET VALUES FOR THE CALCULATIONS BELOW FROM THE DATA OBJECTS.
    if n_elements(resObj) eq 0 and $
        n_elements(bkgObj) eq 0 then begin
            situation = 1
    endif;situation 1

    if n_elements(resObj) gt 0 and $
        n_elements(bkgObj) eq 0 then begin
            situation = 2

            ;060404
            ;
            ;THESE VALUES SHOULD BE INTERPOLATED FROM THE RESOLUTION
            ;FILE.  THIS MEANS THAT THE FUNCTION FORM OF THE
            ;INTERPOLATION METHOD IS NECESSARY FOR THE AMPLITUDE
            ;PARAMETERS!!!
            Tres = resObj->getProperty(tag='transmission')
            Ares = (*(resObj->getProperty(tag='fitparms')))[1,*,*]
            sAres = (*(resObj->getProperty(tag='fitparms')))[7,*,*]
            ;REFORM TO A 2D ARRAY
            sz = size(Ares)
            Ares = reform(Ares,sz[2],sz[3])
            sAres = reform(sAres,sz[2],sz[3])

            Qres = (*(resObj->getProperty(tag='QVals')))[1,*,*]
            taures = (*(resObj->getProperty(tag='fourierTime')))
            Iupres = (*(resObj->getProperty(tag='Iup')))
            sIupres = (*(resObj->getProperty(tag='sIup')))
            Idownres = (*(resObj->getProperty(tag='Idown')))
            sIdownres = (*(resObj->getProperty(tag='sIdown')))
            maskres =  (*(resObj->getProperty(tag='mask2d')))
;            monres = (*(resObj->getProperty(tag='monitors')))
            monres = ((resObj->getProperty(tag='preset')))

    endif;situation 2

    if n_elements(resObj) eq 0 and $
        n_elements(bkgObj) gt 0 then begin
            situation = 3
            Tbkg = bkgObj->getProperty(tag='transmission')
            Abkg = (*(bkgObj->getProperty(tag='fitparms')))[1,*,*]
            sAbkg = (*(bkgObj->getProperty(tag='fitparms')))[7,*,*]
            ;REFORM TO A 2D ARRAY
            sz = size(Abkg)
            Abkg = reform(Abkg,sz[2],sz[3])
            sAbkg = reform(sAbkg,sz[2],sz[3])
            Qbkg = (*(bkgObj->getProperty(tag='QVals')))[1,*,*]
            taubkg = (*(bkgObj->getProperty(tag='fourierTime')))
            Iupbkg = (*(bkgObj->getProperty(tag='Iup')))
            sIupbkg = (*(bkgObj->getProperty(tag='sIup')))
            Idownbkg = (*(bkgObj->getProperty(tag='Idown')))
            sIdownbkg = (*(bkgObj->getProperty(tag='sIdown')))
            maskbkg =  (*(bkgObj->getProperty(tag='mask2d')))
;            monbkg = (*(bkgObj->getProperty(tag='monitors')))
            monbkg = ((bkgObj->getProperty(tag='preset')))

    endif;situation 3

    if n_elements(resObj) gt 0 and $
        n_elements(bkgObj) gt 0 then begin
            situation = 4
            Tres = resObj->getProperty(tag='transmission')
            Ares = (*(resObj->getProperty(tag='fitparms')))[1,*,*]
            sAres = (*(resObj->getProperty(tag='fitparms')))[7,*,*]
            ;REFORM TO A 2D ARRAY
            sz = size(Ares)
            Ares = reform(Ares,sz[2],sz[3])
            sAres = reform(sAres,sz[2],sz[3])
            Qres = (*(resObj->getProperty(tag='QVals')))[1,*,*]
            taures = (*(resObj->getProperty(tag='fourierTime')))
            Iupres = (*(resObj->getProperty(tag='Iup')))
            Idownres = (*(resObj->getProperty(tag='Idown')))
            sIupres = (*(resObj->getProperty(tag='sIup')))
            sIdownres = (*(resObj->getProperty(tag='sIdown')))
            maskres =  (*(resObj->getProperty(tag='mask2d')))
;            monres = (*(resObj->getProperty(tag='monitors')))
            monres = ((resObj->getProperty(tag='preset')))


            Tbkg = bkgObj->getProperty(tag='transmission')
            Abkg = (*(bkgObj->getProperty(tag='fitparms')))[1,*,*]
            sAbkg = (*(bkgObj->getProperty(tag='fitparms')))[7,*,*]
            ;REFORM TO A 2D ARRAY
            sz = size(Abkg)
            Abkg = reform(Abkg,sz[2],sz[3])
            sAbkg = reform(sAbkg,sz[2],sz[3])
            Qbkg = (*(bkgObj->getProperty(tag='QVals')))[1,*,*]
            taubkg = (*(bkgObj->getProperty(tag='fourierTime')))


            ;NEED ERROR BARS FOR Iup/down
            Iupbkg   = (*(bkgObj->getProperty(tag='Iup')))
            Idownbkg = (*(bkgObj->getProperty(tag='Idown')))
            sIupbkg =  (*(bkgObj->getProperty(tag='sIup')))
            sIdownbkg =(*(bkgObj->getProperty(tag='sIdown')))

            maskbkg  = (*(bkgObj->getProperty(tag='mask2d')))
;            monbkg = (*(bkgObj->getProperty(tag='monitors')))
            monbkg = ((bkgObj->getProperty(tag='preset')))

    endif;situation 4


    ;GET INFORMATION FROM THE DATA OBJECT
    if n_elements(datObj) gt 0 then begin
        datObj=datObj
    endif else begin
        datObj = self
    endelse


    ;IF self.type eq <data>
    Tdat = datObj->getProperty(tag='transmission')
    Adat = (*(datObj->getProperty(tag='fitparms')))[1,*,*]
    sAdat = (*(datObj->getProperty(tag='fitparms')))[7,*,*]
    ;REFORM TO A 2D ARRAY
    sz = size(Adat)
    Adat = reform(Adat,sz[2],sz[3])
    sAdat = reform(sAdat,sz[2],sz[3])
    Qdat = (*(datObj->getProperty(tag='QVals')))[1,*,*]
    taudat = (*(datObj->getProperty(tag='fourierTime')))
    ;NEED ERROR BARS FOR Iupdat AND Idowndat
    Iupdat = (*(datObj->getProperty(tag='Iup')))
    Idowndat = (*(datObj->getProperty(tag='Idown')))
    sIupdat = (*(datObj->getProperty(tag='sIup')))
    sIdowndat = (*(datObj->getProperty(tag='sIdown')))
    maskdat =  (*(datObj->getProperty(tag='mask2d')))
;    mondat = (*(datObj->getProperty(tag='monitors')))
    mondat = ((datObj->getProperty(tag='preset')))



    ;NEED TO CATCH POSSIBLE ERROR WHEN Iup/down ARE EQUAL
    ;OR BOTH CONTAIN ZEROS.
    ;
    ;
    ;LOOK AT MASKS AND SET EVERYTHING TO 1.0 IF IT IS MASKED
    ;
    ;DATA MASK SHOULD DETERMINE THE OVERALL MASK.
    ;
    ;NEED TO CHECK THAT ALL ARRAY SIZES ARE THE SAME TOO.
    ;
    ;
    ;NEED TO GET NUMBER OF Q ARCS AND SUM WITHIN THOSE ARCS TO
    ;PRODUCE I(Q,t)
    ;
    ;NEED TO DISPLAY I(Q,t)
    ;
    ;NEED ERROR BAR ARRAY

    ;GET MASK THAT REMOVES ALL PIXELS WITH ZEROS

    if n_elements(resObj) gt 0 then begin
        mask = maskdat*maskres
        mask=maskdat
        Sbar_res = 0.0*Ares + 1.0 ; INITIALIZE WITH CORRECT DIMENSIONS AN NONZERO VALUES
        S = Sbar_res
        sSbar_res = 0.0*Sbar_res
        sS = 0.0*Sbar_res
    endif else begin
        mask = maskdat
    endelse

    ;help,mask
    ;help,*self.QVals

    ;USE FOR LOOPS TO DO THE CALCULATIONS AND
    ;AVOID DIVIDE BY ZERO

    Sbar_data = 0.0*Adat ; INITIALIZE WITH CORRECT DIMENSIONS
    S = Sbar_data
    sSbar_data = 0.0*Sbar_data
    sS = 0.0*Sbar_data


    ;sIupDat = 0.0*IupDat
    ;sIdownDat = 0.0*IdownDat

    sz = size(Adat)
    for i=0,sz[1]-1 do begin
        for j=0,sz[2]-1 do begin
            if mask[i,j] ne 0 then begin

                if (Iupdat[i,j] ne Idowndat[i,j]) then begin
                    Sbar_data[i,j] = 2.0*(Adat[i,j])/$
                            (Idowndat[i,j] - Iupdat[i,j])
                    sSbar_data[i,j] = $
                        2.0*sqrt((sAdat[i,j]/(Idowndat[i,j] - Iupdat[i,j]))^2 $
                        +Adat[i,j]*$
                        (sIupdat[i,j]^2 + sIdowndat[i,j]^2)/$
                        (Idowndat[i,j] - Iupdat[i,j])^2);sqrt
                endif else begin
                    Sbar_data[i,j] = 0
                    sSbar_data[i,j] = 0
                endelse
            endif
        endfor;j
    endfor;i

    case situation of
    1:begin
            print,'No background or resolution, calculating Ibar.'
            S = Sbar_data
            sS = sSbar_data
        end
    2:begin
            print,'No background, calculating I without background subtraction.'

    ;DO I NEED A MONITOR CORRECTION???
    ;
    ;SEEMS LIKE I SHOULD CORRECT RESOLUTION BY
    ;A FACTOR OF mondat/monres.
    ;
    ;THEN THERE IS STILL THE ISSUE OF INTERPOLATING AMPLITUDES.
    ;WHAT DO I DO THERE?
    ;

    ;
    ;THE RESOLUTION DATA MUST BE COLLECTED FOR THE SAME
    ;FOURIER TIME AS FOR THE DATA.  IF THERE IS NO AVAILABLE
    ;RESOLUTION DATA FOR THE GIVEN FOURIER TIME THEN THE
    ;DATA SHOULD BE DROPPED.  THIS INFO CAME FROM DOBRIN
    ;ON 071504.
    ;
    ;
            Sbar_res = 0.0*Adat+1.0 ; INITIALIZE WITH CORRECT DIMENSIONS
            sSbar_res = 0.0*Adat+1.0
            sz = size(Adat)
            for i=0,sz[1]-1 do begin
                for j=0,sz[2]-1 do begin

                    jres = self->resIndex(taudat[j],resobj)
                    ;print,jres
                    ;ONLY CALCULATE I(Q,t) IF THERE IS A RESOLUTION
                    ;SET FOR THE SELECTED FOURIER TIME.
                    if jres ne -1 then begin

                    if mask[i,j] ne 0 then begin
                        if (Iupres[i,jres] ne Idownres[i,jres]) then begin
                            Sbar_res[i,j] = 2.0*Ares[i,jres]/$
                                    (Idownres[i,jres] - Iupres[i,jres])
                            sSbar_res[i,j] = $
                                2.0*sqrt((sAres[i,jres]/$
                                (Idownres[i,jres] - Iupres[i,jres]))^2 $
                                +Ares[i,jres]*$
                                (sIupres[i,jres]^2 + sIdownres[i,jres]^2)/$
                                (Idownres[i,jres] - Iupres[i,jres])^2);sqrt

;071404
;THIS NEXT LINE SHOULD BE OK,
;UNLESS A MONITOR CORRECTION
;AND/OR A TRANSMISSION CORRECTION
;ARE NEEDED.

;071504
;
;NEED TO CHECK THAT THE RESOLUTION AND DATA FOURIER
;TIMES ARE THE SAME.  PRESUMABLY THERE WILL BE MORE
;THAN ONE RESOLUTION TIME TO EACH DATA TIME, BUT THE
;MATCHING TIMES WILL BE WITHIN <1%.  CREATE A FUNCTION
;TO ESTABLISH THE TIME MATCH TO WITHIN 1%.  RETURN THE
;MATCHING FOURIER TIME INDEX IN THE FUNCTION.
;
;
;replace Sbar_res[i,j] with Sbar_res[i,self->resIndex(ft(data),resobj)]
                            ;fmon = monres[0].m1/mondat[0].m1
                            fmon = monres/mondat
                            S[i,j] = fmon*Sbar_data[i,j]/Sbar_res[i,j]

                            sS[i,j] = fmon*sqrt((sSbar_data[i,j]/Sbar_res[i,j])^2 $
                             +(Sbar_data[i,j]*sSbar_res[i,j]/Sbar_res[i,j]^2)^2)
                        endif else begin
                            ;FIX THIS OPTION
                            S[i,j] = 0.0
                            sS[i,j] = 0.0
                        endelse


                    endif;mask[i,j]
                    endif;jres
                endfor;j
            endfor;i


            ;062504
            ;NEED TO INCORPORATE MONITOR AND TRANSMISSIONS PROPERLY



            ;NEED TO LOOK FOR ZEROS!!!

            ;USE MASK VALUES
        end
    3:begin
            print,'No resolution, calculating Ibar without resolution data.
            Sbar_data = Adat ; INITIALIZE WITH CORRECT DIMENSIONS
            sSbar_data = Adat
            sz = size(Adat)

            ;071404
            ;
            ;TRANSMISSION RATIO
            T = Tdat/Tbkg
            ;ASSUME ONE MONITOR VALUE FOR ALL DATA
;            M = mondat[0].m1/monbkg[0].m1
            M = mondat/monbkg
            ;ONLY ONE VOLUME FRACTION TO DEAL WITH
            V = volfrac

            R = V*M*T

            ;print,'R= ',R

            for i=0,sz[1]-1 do begin
                for j=0,sz[2]-1 do begin
                    if mask[i,j] ne 0 then begin

                        jbkg = self->resIndex(taudat[j],bkgobj)
                        if ((Iupdat[i,j] - Idowndat[i,j]) ne $
                            R*(Iupbkg[i,jbkg] - Idownbkg[i,jbkg])) $
                                then begin


                            Sbar_data[i,j] = 2.0*(Adat[i,j] - R*Abkg[i,jbkg])/$
                                ((Idowndat[i,j] - Iupdat[i,j]) - R*$
                                            (Idownbkg[i,jbkg] - Iupbkg[i,jbkg]))
                            S[i,j] = Sbar_data[i,j]

                            ss1d = ((Idowndat[i,j] - Iupdat[i,j]) $
                                        - R*(Idownbkg[i,jbkg] - Iupbkg[i,jbkg]))


                            ss1n = sAdat[i,j]^2
                            ss2n = (R*sAbkg[i,jbkg])^2
                            ss3n = sIupdat[i,j]^2/ss1d
                            ss4n = sIdowndat[i,j]^2/ss1d
                            ss5n = R*sIupbkg[i,jbkg]^2/ss1d
                            ss6n = R*sIdownbkg[i,j]^2/ss1d

                            sS[i,j] = sqrt((ss1n + ss2n + ss3n + ss4n $
                                            + ss5n + ss6n)/ss1d)

                        endif else begin
                            ;FIX THIS OPTION
                            S[i,j] = 0.0
                            sS[i,j] = 0.0
                        endelse

                ;CALCULATE CORRECT ERROR BARS HERE
                ;AND COPY INTO SITUATION 4 BELOW.
                    endif
                endfor;j
            endfor;i
        end
    4:begin
            print,'Calculating I.'
            Sbar_res = 0.0*Adat + 1.0 ; INITIALIZE WITH CORRECT DIMENSIONS
            Sbar_bkg = 0.0*Adat


            ;071404
            ;
            ;TRANSMISSION RATIO
            T = Tdat/Tbkg
            ;print,'T:',T

            ;ASSUME ONE MONITOR VALUE FOR ALL DATA
;            M = mondat[0].m1/monbkg[0].m1
            M = mondat/monbkg
            ;print,'M:',M


            ;WHY ARE THESE COMING UP AS 52????? --- /extract IN strsplit!!!!
            ;print,mondat
            ;print,monbkg


            ;ONLY ONE VOLUME FRACTION TO DEAL WITH
            V = volfrac
            ;print,'V= ',V

            R = V*M*T


            ;print,'R= ',R


            ;print,'R:',R
            sz = size(Adat)
            for i=0,sz[1]-1 do begin
                for j=0,sz[2]-1 do begin

                    jres = self->resIndex(taudat[j],resobj)
                    jbkg = self->resIndex(taudat[j],bkgobj)
                    ;print,jres
                    ;ONLY CALCULATE I(Q,t) IF THERE IS A RESOLUTION
                    ;SET FOR THE SELECTED FOURIER TIME.
                    if jres ne -1 then begin
                    if mask[i,j] ne 0 then begin

                        if (((Iupdat)[i,j] - (Idowndat)[i,j]) ne $
                         R*(Iupbkg[i,jbkg] - Idownbkg[i,jbkg])) and $
                         ((Iupres[i,jres] - Idownres[i,jres]) ne 0) and $
                         (Ares[i,jres] ne 0) then begin


                            Sbar_res[i,j] = 2.0*Ares[i,jres]/(Idownres[i,jres] - Iupres[i,jres])
                            sSbar_res[i,j] = $
                                2.0*sqrt((sAres[i,jres]/$
                                (Idownres[i,jres] - Iupres[i,jres]))^2 $
                                +Ares[i,jres]*$
                                (sIupres[i,jres]^2 + sIdownres[i,jres]^2)/$
                                (Idownres[i,jres] - Iupres[i,jres])^2);sqrt

                            Sbar_data[i,j] = 2.0*(Adat[i,j] - R*Abkg[i,jbkg])/$
                                ((Idowndat[i,j] - Iupdat[i,j]) - R*$
                                        (Idownbkg[i,jbkg] - Iupbkg[i,jbkg]))


                ;072004
                ;
                ;UPDATED WITH MONITOR
                ;
;                            fmon = monres[0].m1/mondat[0].m1
                            fmon = monres/mondat

                            S[i,j] = fmon*Sbar_data[i,j]/Sbar_res[i,j]


;                            S[i,j] = Sbar_data[i,j]/Sbar_res[i,j]


                            ;FIX ERROR BAR CALCULATION ONCE
                            ;VISUALIZATION IS COMPLETE.
                            ss1d = abs((((Iupdat)[i,j] - (Idowndat)[i,j]) $
                                    - R*(Idownbkg[i,jbkg] - Iupbkg[i,jbkg])))
                            ;print,ss1d

                            ss1n = sAdat[i,j]^2
                            ss2n = (R*sAbkg[i,jbkg])^2
                            ss3n = (sIupdat)[i,j]^2/ss1d
                            ss4n = (sIdowndat)[i,j]^2/ss1d
                            ss5n = R*sIupbkg[i,jbkg]^2/ss1d
                            ss6n = R*sIdownbkg[i,jbkg]^2/ss1d

                            sSbar_data[i,j] = sqrt((ss1n + ss2n + ss3n + ss4n $
                                            + ss5n + ss6n)/ss1d)

                            sS[i,j] = fmon*sqrt((sSbar_data[i,j]/Sbar_res[i,j])^2 $
                             +(Sbar_data[i,j]*sSbar_res[i,j]/Sbar_res[i,j]^2)^2)
                        endif else begin    ;ZERO DENOMINATORS
                            ;FIX THIS OPTION
                            S[i,j] = 0.0
                            sS[i,j] = 0.0
                        endelse
                    endif;mask[i,j]
                    endif;jres
                endfor;j
            endfor;i

;072104
;
;WHY IS sbar_data SO MESSED UP?????  ---- HERE AND IN OTHER CALCULATIONS ABOVE!!!!
;
;            print,'sbar_data[*,0]= ',sbar_data[*,0]
;            print,'sbar_data[*,1]= ',sbar_data[*,1]
;            print,'sbar_data[*,2]= ',sbar_data[*,2]
;            print,'sbar_data[*,3]= ',sbar_data[*,3]
;            print,'sbar_data[*,4]= ',sbar_data[*,4]
;            print,'Sbar_res:'
;            print,Sbar_res
        end
    else:begin
            print,'1387 ooecho::calculateIQT: I am confused on the calculation of I(Q,t).'
        end
    endcase
;    print,'S'
;    ;print,S
;    sz = size(S)
;    print,reform(S,sqrt(sz[1]),sqrt(sz[1]),sz[2])

    if ptr_valid(self.S) gt 0 then ptr_free,self.S
    self.S = ptr_new(S)

    if ptr_valid(self.sS) gt 0 then ptr_free,self.sS
    self.sS = ptr_new(sS)

    ;print,'*self.sS'
    sz = size(*self.sS)
    ;print,reform(*self.sS,sqrt(sz[1]),sqrt(sz[1]),sz[2])

;IT LOOKS LIKE I DID THE ERROR BAR CALCULATIONS FOR
;S (WHICH IS COMMONLY CALLED I(Q,t)), BUT I DID NOT
;STICK THESE VALUES IN self.IQT or self.sIQT!!!


    ;print,reform(mask*(*self.S),sqrt(sz[1]),sqrt(sz[1]),sz[2])
;    print,size(*self.S)
;    help,self
    ;print,'mask=',reform(mask,sqrt(sz[1]),sqrt(sz[1]),sz[2])
end;calculateIQT
pro ooEcho::calculateArcsQMatrix,narcs=narcs,arcmat=arcmat,_Extra=extra
;
;NAME:
;        ooEcho::calculateArcsQMatrix
;
;PURPOSE:
;           Create an index showing the arc index at each pixel.
;           This is useful for displaying the arcs on the image
;           in ooDisplayEcho.
;PARAMETERS:
;           narcs   The number of Q arcs.
;           arcmat  The matrix is passed back to the calling program via arcmat
;KEYWORDS:
;


    ;self->addTreatment,'ooEcho::calculateArcsQMatrix'


    ;CREATE A MATRIX INDEXING THE PIXELS BASED ON THE
    ;Q-ARCS.

    ;USE THE NEXT CALL TO SIMPLY SET THE Q-ARCS VALUES
    ;print,'ooecho::calculateQArcs size(*self.qvals)=',size(*self.qvals)
    self->calculateQVals
    ;print,'ooecho::calculateQArcs size(*self.qvals)=',size(*self.qvals)

    if n_elements(narcs) gt 0 then self.narcs = narcs

    sd = [4.476,4.35,4.50]          ;DETECTOR DISTANCES
    xpixsz = [0.0031,0.01,0.01]     ;DETECTOR PIXEL SIZES
    ypixsz = [0.003157,0.01,0.01]

    qc = sqrt((self.qy)^(2.0d) + (self.qactual)^(2.0d));q)^2)

    ;print,qc

    lambda = 10.0^10*self.lambda    ;CONVERT TO ANGSTROMS
    ;ARE THE q VALUES LISTED IN THE FILES ALWAYS AT THE
    ;DETECTOR CENTER?
    ;
    ;IF SO, WHERE DO THE 0.16 VALUES COME FROM?
    ;IS IT (16 pixels)*(0.01 m/pixel)?


;101404
;
;STEVE SIMPLY SETS THE VALUES OF qmin AND qmax TO BE
;THE MINIMUM AND MAXIMUM QVALUES IN THE QArray.
 qmin = min(*self.QVals)
 qmax = max(*self.QVals)


    if self.narcs ne 0 and self.narcs gt 1 then begin
        qstep = (qmax - qmin)/(self.narcs-1)
        ;print,'qstep=',qstep
        qarcs = dblarr(self.narcs)
        for i=0,n_elements(qarcs)-1 do begin
            qarcs[i] = qmin + qstep*double(i)
        endfor
;print,'ooEcho::calculateArcsQMatrix ',qarcs
;print,'ooEcho::calculateArcsQMatrix ',*self.qarcs

;
;        ;CREATE self.qarcs AT THE CENTERS OF EACH OF THE Q BINS.
;        for ii=0,n_elements(*self.qarcs)-1 do begin
;            (*self.qarcs)[ii] = qmin + qstep*(double(ii)+0.5)
;            print,'*self.qarcs',*self.qarcs
;        endfor



        sz = [2,self.x_dim,self.y_dim]
        arcmat = intarr(sz[1],sz[2])
        for k = 0,self.narcs-1 do begin
            Q1 = qarcs[k] - qstep/2.0
            Q2 = qarcs[k] + qstep/2.0

            for j=0,sz[2]-1 do begin
                for i=0,sz[1]-1 do begin

                    ;STEVE'S IMPLEMENTATION IS:
                    kq = round(((*self.qvals)[i+j*self.x_dim]-qmin)/qstep)
                    arcmat[i,j] = kq
                endfor;i
            endfor;j
        endfor;k
    endif else begin
        if self.narcs eq 1 then begin
            sz = [2,self.x_dim,self.y_dim]
            arcmat = intarr(sz[1],sz[2])
            ;072005
            ;void = dialog_message('Update ooEcho::calculateQArcsMatrix for narcs = 1.',/info)

;            for j=0,sz[2]-1 do begin
;                for i=0,sz[1]-1 do begin
;                    arcmat[i,j] = 0
;                endfor;i
;            endfor;j
        endif else begin
            void = dialog_message('narcs = 0!  IQT not calculated')
        endelse

    endelse

;print,'ooEcho::calculateArcsQMatrix arcmat=',arcmat
    arcmat = reform(arcmat,sz[1]*sz[2]) ;RETURNED VIA THE KEYWORD.
end;calculateArcsQMatrix


pro ooEcho::setIQT,IQT=IQT,sIQT=sIQT,QArcs=QArcs,qmax=qmax,qmin=qmin,_Extra=extra

      help,*self.IQT,*self.sIQT,*self.QArcs

;        if ptr_valid(self.IQT) then ptr_free,self.IQT
;        self.IQT = ptr_new(IQT)
;        if ptr_valid(self.sIQT) then ptr_free,self.sIQT
;        self.sIQT = ptr_new(sIQT)
;
;        qstep = (qmax - qmin)/double(self.narcs-1)
;
;        ;UPDATE self.qarcs
;        if ptr_valid(self.qarcs) gt 0 then ptr_free,self.qarcs
;        self.qarcs = ptr_new(dblarr(self.narcs))

end;ooEcho::setIQT


pro ooEcho::sumQArcs,narcs = narcs, $
                     bkgObj = bkgObj,$
                     resObj = resObj,$
                     datObj = datObj,$
                     fitParBuf=fitParBuf, $
                     writeFile = writeFile,$
                     _Extra=extra
;
;NAME:
;        ooEcho::sumQArcs
;
;PURPOSE:
;           Sum the I(Q,t) values over the entire image at all Fourier times.
;           The sum is done weighted by 1/sIQT^2, and the bins are done by
;           Q arc.
;PARAMETERS:
;           none
;KEYWORDS:
;           narcs       Number of Q arcs.
;           bkgobj      Object references to put the data into.
;           resobj
;           datobj

;print,'ooEcho::sumQArcs'

;self->addTreatment,'ooEcho::sumQarcs'

;THIS METHOD WILL SUM ALL OF THE DATA POINTS
;ASSOCIATED WITH EACH OF THE Q RANGES ON THE
;DETECTOR AND THEN PRODUCE A 2D ARRAY OF I(Q,t)
;FOR ALL OF THE DATA.

if n_elements(narcs) gt 0 then self.narcs = narcs
if n_elements(writeFile) eq 0 then writeFile = 0
lun = -1
format='(7g15.7)'
if writeFile ne 0 then begin
  fn = dialog_pickfile(title='Choose I(Q,t) Pixel File:',path=self.workdir,/overwrite_prompt)
    
  if fn[0] ne '' then begin
    openw,lun,fn[0],/get_lun
    printf,lun,'# ;FOR THE INITIAL SUMMING LOOP OVER i,j FOR UNMASKED PIXELS ONLY:' 
    printf,lun,'# qmin = min(theQVals);min(*self.QVals)'
    printf,lun,'# qmax = max(theQVals);(*self.QVals)'        
    printf,lun,'# qstep = (qmax - qmin)/double(self.narcs-1)'
    printf,lun,'# kq = round(((theQVals)[i,0]-qmin)/qstep)'
    printf,lun,'# '
    printf,lun,'# IQT[kq,j] = IQT[kq,j] + (*self.S)[i,j]/((*self.sS)[i,j])^2'
    printf,lun,'# sIQT[kq,j] = sIQT[kq,j] + 1.0d/((*self.sS)[i,j])^2'
    printf,lun,'#        
    printf,lun,'# ;THEN AFTER SUMMATION COMPLETE:'
    printf,lun,'# IQT = IQT/sIQT'
    printf,lun,'# sIQT = 1.0d/sqrt(sIQT)'               
    printf,lun,'#        '
    printf,lun,'# Output Format:
    printf,lun,"# format='(5g15.7)'"
    printf,lun,"# printf,lun,kq,theQVals[i,0],theTVals[j],(*self.S)[i,j],(*self.sS)[i,j], format=format"
    printf,lun,'#        '
    printf,lun,'#          i   ','j','kq','qval','FourierTime','I(q,t)_pixel','sI(q,t)_pixel',format='(7A15)'
  endif else begin
    lun = -1
  endelse
endif;writeFile

sd = [4.476d,4.35d,4.50d]          ;DETECTOR DISTANCES
xpixsz = [0.0031d,0.01d,0.01d]     ;DETECTOR PIXEL SIZES
ypixsz = [0.003157d,0.01d,0.01d]

;qc = sqrt((self.qy*1.0e-10)^2 + (self.q*1.0e-10)^2)

;print,'ooEcho::QArcs'
;print,self.qy
;print,self.qactual
qc = sqrt((self.qy)^2 + (self.qactual)^2);(self.q)^2)

;    print,qc

lambda = (10.0d^10.0d)*self.lambda    ;CONVERT TO ANGSTROMS
;ARE THE q VALUES LISTED IN THE FILES ALWAYS AT THE
;DETECTOR CENTER?
;
;IF SO, WHERE DO THE 0.16 VALUES COME FROM?
;IS IT (16 pixels)*(0.01 m/pixel)?

;;    qmin = (4.0*!PI/lambda) $
;;                * sin(asin(qc*lambda/(4.0*!PI)) $
;;                - 0.5*atan(0.16/sd[2]))
;;    qmax = (4.0*!PI/lambda) $
;;                * sin(asin(qc*lambda/(4.0*!PI)) $
;;                + 0.5*atan(0.16/sd[2]))


;052005
;Igor SEEMS TO ALWAYS USE THE RESOLUTION OBJECT AS THE SOURCE OF THE Q VALUES.
;help,resObj
if n_elements(resObj) eq 1 then begin
    theQVals = (*(resObj->getProperty(tag='QVals')))[*,0]
endif else begin
    theQVals = (*(self->getProperty(tag='QVals')))[*,0]
endelse
theTVals = (*(self->getProperty(tag='fourierTime'))) ; LRK 08/12/09 - USED ONLY FOR WRITING A TEST OUTPUT FILE.

;101404
;
;STEVE SIMPLY SETS THE VALUES OF qmin AND qmax TO BE
;THE MINIMUM AND MAXIMUM QVALUES IN THE QArray.
 qmin = min(theQVals);min(*self.QVals)
 qmax = max(theQVals);(*self.QVals)
;help,*self.QVals
;print,'QValues'
;for iiii=0,15 do begin
;    print,((theQVals)[iiii*16+0:(iiii)*16+15,0])
;endfor;iiii


;    qmin = (4.0*!PI/lambda) $
;                * sin(asin(qc*lambda/(4.0*!PI)) $
;                - 0.5*atan(0.16/sd))
;    qmax = (4.0*!PI/lambda) $
;                * sin(asin(qc*lambda/(4.0*!PI)) $
;                + 0.5*atan(0.16/sd))


;    print,'qmin=',qmin
;    print,'qmax=',qmax
if self.narcs ne 0 and self.narcs gt 1 then begin
    qstep = (qmax - qmin)/double(self.narcs-1)
    ;print,'qstep=',qstep
    ;print,'In sumQArcs qstep=',qstep

    ;UPDATE self.qarcs
    if ptr_valid(self.qarcs) gt 0 then ptr_free,self.qarcs
    self.qarcs = ptr_new(dblarr(self.narcs))


    ;STEVE SEEMS TO CALCULATE THE AVERAGE Q-VALUES FROM THE
    ;Q-VALUES OF EACH OF THE PIXELS.
    ;
    ;DO THIS BELOW.

  ;
  ;        ;CREATE self.qarcs AT THE CENTERS OF EACH OF THE Q BINS.
  ;        for ii=0,n_elements(*self.qarcs)-1 do begin
  ;            (*self.qarcs)[ii] = qmin + qstep*(double(ii)+0.5)
  ;            print,'*self.qarcs',*self.qarcs
  ;        endfor



  sz = size(*self.S)
  
  ;print,sz
  IQT = dblarr(self.narcs,sz[2]);self.no_of_fourier_times)
  sIQT = dblarr(self.narcs,sz[2]);self.no_of_fourier_times)
  IQTcount = intarr(self.narcs,sz[2]) ;NO OF PIXELS IN THIS Q BIN
  sumQs = dblarr(self.narcs,sz[2])
  
  IQTcount1d = intarr(self.narcs)
  sumQs1d = dblarr(self.narcs)


  ;print,'IQT[8+8*16,0]=',(*self.S)[8+16*8,0]

  for k = 0,self.narcs-1 do begin
    ;Q1 = qmin + k*qstep
    Q1 = (*self.qarcs)[k] - qstep/2.0d
    ;060404
    ;FIXING THE NEXT LINE SO THAT THE
    ;RANGES ARE PROPERLY SELECTED.
    ;Q2 = qmin + (k+1)*qstep;Q1 + (k+1)*qstep
    Q2 = (*self.qarcs)[k] + qstep/2.0d



    ;print,'Q1,Q2 = ',Q1,Q2
    ;print,'1591 ooEcho::sumQArcs sz=',sz
    for j=0,sz[2]-1 do begin      ;LOOP OVER TIMES
      for i=0,sz[1]-1 do begin  ;LOOP OVER Q/PIXELS
        ;ONLY USE mask2d=1 POINTS
        ;print,k,i,j

        ;STEVE'S IMPLEMENTATION IS:
        kq = round(((theQVals)[i,0]-qmin)/qstep)
        ;kq = round(((*self.qvals)[i,j]-qmin)/qstep)

        ;033105
        ;SUM ALL UNMASKED POINTS. --- HOW IS MASK CHOSEN?  DAT ONLY????
        ;  FIX THIS TO INCLUDE BOTH DATA AND RES!!!!

        ;CHECK FOR BOTH DEFAULT MASK (0) AND USER MASK (-1)
        if (*self.mask2d)[i,j] ne 0 and $
          (*self.mask2d)[i,j] ne -1 and $;then begin
          (*self.S)[i,j] ne double('Nan') and $;then begin   ;condition added 051105
          kq eq k then begin  ;condition added 052005 to eliminate multiple counting
          ;051205
          ;MY ORIGINAL WAY
          ;                         IQT[kq,j] = IQT[kq,j] + (*self.S)[i,j]
          ;                        sIQT[kq,j] = sIQT[kq,j] + $
          ;                                        ((*self.sS)[i,j])^2
        
          ;IGOR DOES THIS SUM BY WEIGHTING BY 1/sS^2!!!
          ;THE IGOR WAY
          if lun ne -1 then printf,lun,i mod self.x_dim,i/self.x_dim ,kq,theQVals[i,0],theTVals[j],(*self.S)[i,j],(*self.sS)[i,j],format=format
          IQT[kq,j] = IQT[kq,j] + (*self.S)[i,j]/((*self.sS)[i,j])^2
          sIQT[kq,j] = sIQT[kq,j] + 1.0d/((*self.sS)[i,j])^2
          ;print,'ooEcho::sumQArcs     ((*self.sS)[i,j])^2=',((*self.sS)[i,j])^2
          ;091205
          ;
          ;ANTONIO AND I ARE DISCUSSING CHANGING THE ABOVE LINES TO INSTEAD WEIGHT THE SUMMATION
          ;BY THE RELATIVE ERRORS INSTEAD OF THE ABSOLUTE ERRORS.
          
          ;A TRIAL
          ;                         IQT[kq,j] = IQT[kq,j] + (*self.S)[i,j]/((*self.sS)[i,j]/(*self.S)[i,j])^2
          ;                        sIQT[kq,j] = sIQT[kq,j] + $
          ;                                        1.0d/((*self.sS)[i,j]/(*self.S)[i,j])^2
          IQTcount[kq,j] = IQTcount[kq,j] + 1
          sumQs[kq,j] += theQVals[i,0];(*self.QVals)[i,j]
          IQTcount1d[kq] = IQTcount1d[kq] + 1
          sumQs1d[kq] += theQVals[i,0];(*self.QVals)[i,j]
        endif;self.mask2d
        ;                    if (*self.mask2d)[i,j] ne 0 then begin
        ;
        ;
        ;                        ;SUM OVER EACH RANGE OF THE Q ARCS
        ;                        if ((*self.QVals)[i,j] ge Q1) and $
        ;                           ((*self.QVals)[i,j] lt Q2) then begin
        ;
        ;                             IQT[k,j] = IQT[k,j] + (*self.S)[i,j]
        ;                            sIQT[k,j] = sIQT[k,j] + $
        ;                                            ((*self.sS)[i,j])^2
        ;                            ;print,sIQT[k,j]
        ;
        ;                            IQTcount[k,j] = IQTcount[k,j] + 1
        ;                            ;print,(*self.S)[i,j]
        ;                        endif;IN Q RANGE
        ;
        ;
        
        
        ;                            print,k,i,j,Q1,Q2,(*self.QVals)[i,j],$
        ;                                                IQTcount[k,j],$
        ;                                                IQT[k,j]
      endfor;i
    endfor;j
  endfor;k


  ;THE COUNTS TOTAL TO MORE THAN THE NUMBER OF PIXELS!!!
  ;
  ;WHY IS THAT??????
  ;print,'IQTcount='
  ;print,IQTcount


  ;SET THE AVERAGE Q-VALUES FOR EACH OF THE BINS.
  ;        print,'IQTcount1d=',IQTcount1d
  ;        print,'sumQs1d=',sumQs1d
  for ii=0,n_elements(*self.qarcs)-1 do begin
      if IQTcount1d[ii] eq 0 then begin
          (*self.qarcs)[ii] = qmin + qstep*(double(ii)+0.5)
      endif else begin
          (*self.qarcs)[ii] = sumQs1d[ii]/double(IQTcount1d[ii])
      endelse
  endfor;ii
  ;051205
  ;MY ORIGINAL WAY
  ;        sz = size(IQTcount)
  ;        for i = 0,sz[1]-1 do begin
  ;            for j=0,sz[2]-1 do begin
  ;                if IQTcount[i,j] ne 0 then begin
  ;                    IQT[i,j] = IQT[i,j]/double(IQTcount[i,j])
  ;                    sIQT[i,j] = sqrt(sIQT[i,j])/double(IQTcount[i,j])
  ;                endif
  ;            endfor;j
  ;        endfor;i
  
  ;IGOR WAY
  
  ;for iiii=0,self.narcs-1 do begin
  ;    print,transpose(IQT[iiii,*])
  ;endfor;iiii
  ;help,*self.S
  ;print,'IQT1d      ',IQT[0,0]

  IQT = IQT/sIQT
  sIQT = 1.0d/sqrt(sIQT)
  if ptr_valid(self.IQT) then ptr_free,self.IQT
  self.IQT = ptr_new(IQT)
  if ptr_valid(self.sIQT) then ptr_free,self.sIQT
  self.sIQT = ptr_new(sIQT)

  ;ASSIGN THE IQT MATRIX TO THE RESOLUTION AND
  ;BACKGROUND DATA OBJECTS.
  if n_elements(resObj) gt 0 then begin
    presiqt = resObj->getProperty(tag='IQT')
    if ptr_valid(presiqt) $
                then ptr_free,presiqt
    resObj->setProperty,'IQT',ptr_new(IQT)
    pressiqt = resObj->getProperty(tag='sIQT')
    if ptr_valid(pressiqt) $
                then ptr_free,pressiqt
    resObj->setProperty,'sIQT',ptr_new(sIQT)
  endif
  if n_elements(bkgObj) gt 0 then begin
    pbkgiqt = bkgObj->getProperty(tag='IQT')
    if ptr_valid(pbkgiqt) $
                then ptr_free,pbkgiqt
    bkgObj->setProperty,'IQT',ptr_new(IQT)
    pbkgsiqt = bkgObj->getProperty(tag='sIQT')
    if ptr_valid(pbkgsiqt) $
                then ptr_free,pbkgsiqt
    bkgObj->setProperty,'sIQT',ptr_new(sIQT)
  endif
endif else begin
  ;A SINGLE Q ARC
  if self.narcs eq 1 then begin
    ;072005
    ;SET UP FOR 1 ARC
    if self.narcs gt 1 then begin
        ;STEVE'S IMPLEMENTATION IS:
        kq = round(((theQVals)[i,0]-qmin)/qstep)
    endif else begin
        kq = 0
    endelse

    qstep = (qmax - qmin)
    ;qstep = (qmax - qmin)/double(self.narcs-1)
    ;print,'qstep=',qstep
    ;print,'In sumQArcs qstep=',qstep

    ;UPDATE self.qarcs
    if ptr_valid(self.qarcs) gt 0 then ptr_free,self.qarcs
    self.qarcs = ptr_new(dblarr(2))
    (*self.qarcs)[1] = double('nan')
    sz = size(*self.S)
    IQT = dblarr(2,sz[2]);self.no_of_fourier_times)
    sIQT = dblarr(2,sz[2]);self.no_of_fourier_times)
    IQT[1,*] = double('nan')
    sIQT[1,*] = double('nan')

    IQTcount = intarr(2,sz[2]) ;NO OF PIXELS IN THIS Q BIN
    IQTcount[1,*] = 64;fix('nan')

    sumQs = dblarr(2,sz[2])
    sumQs[1,*] = double('nan')

    IQTcount1d = intarr(2)
    sumQs1d = dblarr(2)
    IQTcount1d[1] = 64;fix('nan')
    sumQs1d[1] = double('nan')

    for k = 0,self.narcs-1 do begin
      Q1 = (*self.qarcs)[k] - qstep/2.0d

      Q2 = (*self.qarcs)[k] + qstep/2.0d


      for j=0,sz[2]-1 do begin
        for i=0,sz[1]-1 do begin

          ;;STEVE'S IMPLEMENTATION IS:
          ;kq = round(((theQVals)[i,0]-qmin)/qstep)
          kq = 0
  
          ;CHECK FOR BOTH DEFAULT MASK (0) AND USER MASK (-1)
          if (*self.mask2d)[i,j] ne 0 and $
            (*self.mask2d)[i,j] ne -1 and $;then begin
            (*self.S)[i,j] ne double('Nan') and $;then begin   ;condition added 051105
            kq eq k then begin  ;condition added 052005 to eliminate multiple counting
            if lun ne -1 then printf,lun,i mod self.x_dim,i/self.x_dim ,kq,theQVals[i,0],theTVals[j],(*self.S)[i,j],(*self.sS)[i,j],format=format
            ;if lun ne -1 then printf,lun,kq,theQVals[i,0],theTVals[j],(*self.S)[i,j],(*self.sS)[i,j],format=format
           

            IQT[kq,j] = IQT[kq,j] + (*self.S)[i,j]/((*self.sS)[i,j])^2
            sIQT[kq,j] = sIQT[kq,j] + $
                          1.0d/((*self.sS)[i,j])^2


            IQTcount[kq,j] = IQTcount[kq,j] + 1
            sumQs[kq,j] += theQVals[i,0];(*self.QVals)[i,j]

            IQTcount1d[kq] = IQTcount1d[kq] + 1
            sumQs1d[kq] += theQVals[i,0];(*self.QVals)[i,j]
          endif;self.mask2d
        endfor;i
      endfor;j
    endfor;k

    for ii=0,n_elements(*self.qarcs)-1 do begin
        if IQTcount1d[ii] eq 0 then begin
            (*self.qarcs)[ii] = qmin + qstep*(double(ii)+0.5)
        endif else begin
            (*self.qarcs)[ii] = sumQs1d[ii]/double(IQTcount1d[ii])
        endelse
    endfor;ii
    IQT = IQT/sIQT
    sIQT = 1.0d/sqrt(sIQT)
    if ptr_valid(self.IQT) then ptr_free,self.IQT
    self.IQT = ptr_new(IQT)
    if ptr_valid(self.sIQT) then ptr_free,self.sIQT
    self.sIQT = ptr_new(sIQT)

    ;ASSIGN THE IQT MATRIX TO THE RESOLUTION AND
    ;BACKGROUND DATA OBJECTS.
    if n_elements(resObj) gt 0 then begin
        presiqt = resObj->getProperty(tag='IQT')
        if ptr_valid(presiqt) $
                    then ptr_free,presiqt
        resObj->setProperty,'IQT',ptr_new(IQT)
        pressiqt = resObj->getProperty(tag='sIQT')
        if ptr_valid(pressiqt) $
                    then ptr_free,pressiqt
        resObj->setProperty,'sIQT',ptr_new(sIQT)

    endif
    if n_elements(bkgObj) gt 0 then begin

        pbkgiqt = bkgObj->getProperty(tag='IQT')
        if ptr_valid(pbkgiqt) $
                    then ptr_free,pbkgiqt
        bkgObj->setProperty,'IQT',ptr_new(IQT)

        pbkgsiqt = bkgObj->getProperty(tag='sIQT')
        if ptr_valid(pbkgsiqt) $
                    then ptr_free,pbkgsiqt
        bkgObj->setProperty,'sIQT',ptr_new(sIQT)
    endif

  endif else begin
      void = dialog_message('narcs = 0!  IQT not calculated')
  endelse
endelse
if lun ne -1 then free_lun,lun ; LRK - 08/12/09  IF AN OUTPUT FILE WAS WRITTEN 

;; Update the treatment log
logBuf = (*Self.iqtinfo)

; append I(Q,t) to the log file
index = where(finite(IQT[*,0]),nIndex)
q1 = (*Self.qarcs)[index]
iqt1 = IQT[index,*]
siqt1 = SIQT[index,*]
t1 = (*self.fouriertime)
logBuf = [logBuf,'','Reduced data; The Intemediate Scattering Function, I(Q,t)']
logBuf = [logBuf,   '---------------------------------------------------------']
line = ' t(ns)   '
fmt1 = '(F6.3,2X)'
fmt2 = '(G10.4,2X)'
for i=0,nIndex-1 do line = line + 'I('+string(q1[i],f='(F5.3)')+',t)  error   ' ; title
logBuf = [logBuf,line]
for j=0,n_elements(t1)-1 do begin ; loop FT
  line = string(t1[j]*1e9,f=fmt1)
  for i=0,nIndex-1 do line = line+string(iqt1[i,j],f=fmt2)+string(siqt1[i,j],f=fmt2)  ; loop Q and write Iqt, error for each
  logBuf = [logBuf,line]
endfor


; append the previously determined (passed in here as input) fitparameters
logBuf = [logBuf,' ']
logBuf = [logBuf,'Reduction Procedure for generating I(Q,t):']
logBuf = [logBuf,'------------------------------------------']
logBuf = [logBuf,'Consult the NSE Data Reduction manual for more details']
logBuf = [logBuf,'Use the "Help->Help on NSE" menu to open the PDF manual']
logBuf = [logBuf,' ']
logBuf = [logBuf,'1) Fit echo at each time and pixel to a damped Cosine function:']
logBuf = [logBuf,'  P[0] - P[1]*Exp(-1.0*((X-P[2]-P[5])/(Sqrt(2.0)*P[3]))^2)*Cos(P[4]*(!PI/180.0)*(X - P[2]-P[5]))']
logBuf = [logBuf,'  where']
logBuf = [logBuf,'    X is the phase current and P[] parameters to be fitted']
logBuf = [logBuf,'    P[0] = Av       [mean count/amplitude]']
logBuf = [logBuf,'    P[1] = A        [Amplitude]']
logBuf = [logBuf,'    P[2] = PH       [echo point]']
logBuf = [logBuf,'    P[3] = W        [width of Gaussian envelope]']
logBuf = [logBuf,'    P[4] = T        [period of Cosine]']
logBuf = [logBuf,'    P[5] = PHoffset [arbitrary offset]']
logBuf = [logBuf,'  to determine the amplitude, A, at each echo and Fourier time.']
logBuf = [logBuf,'  The amplitude, A, contains all the information necessary to determine I(Q,t)']
logBuf = [logBuf,'2) Determine the polarization of the scattered beam due to the sample at each point using:  ']
logBuf = [logBuf,'  Pz_S = 2A/(Ndown - Nup)  where']
logBuf = [logBuf,'    A = fitted amplitude']
logBuf = [logBuf,'    Nup = measured count rates with pi/2 flippers off']
logBuf = [logBuf,'    Ndown = measured count rates with pi/2 flippers on']
logBuf = [logBuf,'3) Determine the same polarization as above but for a purely elastic scatterer rather than the sample.']
logBuf = [logBuf,'  This is denoted as Pz_E. It is also refered to as the resolution measurement.']
logBuf = [logBuf,'  Pz_E = 2A_E/(Ndown_E - Nup_E)']
logBuf = [logBuf,'  Pz_E corrects for inhomogeneities in the magnetic field that are sample-independent']
logBuf = [logBuf,'4) Determine the dynamic scattering from all sample-independent sources by making a background measurement.']
logBuf = [logBuf,'  In this case it is the sample holder, including any pure solvents, that are measured.']
logBuf = [logBuf,'5) The normalized intermediate scattering function at each detector pixel is given by.']
logBuf = [logBuf,'  I = Pz_S_corrected/Pz_E where']
logBuf = [logBuf,'    Pz_S_corrected = 2(A - T.A_B)/((Ndown - Nup) - T.(1-vf)(Ndown_B - Nup_B)) and']
logBuf = [logBuf,'    T      = ratio of sample to background transmission']
logBuf = [logBuf,'    (1-vf) = volume fraction of solvent sample']
logBuf = [logBuf,'    all quantities with a "_B" postfix refer to background equivalents']
logBuf = [logBuf,'6) Finally, group the scattering from individual pixels into zones within the 2D detector to obtain ']
logBuf = [logBuf,'   I(Q,t) at a few fixed Q values. The number of Q zones/arcs are user-specified.']
logBuf = [logBuf,' ']
logBuf = [logBuf,'All the fitted parameters used in determining I(Q,t) according to this outlined procedure are included below']

logBuf = [logBuf,' ']
logBuf = [logBuf,'Fitted Parameters:']
logBuf = [logBuf,'------------------']
logBuf = [logBuf,'All the fitted parameters obtained during the reduction procedure are listed below.']
logBuf = [logBuf,'I(Q,t) is obtained using the procedure outlined above and these fitted parameters']
logBuf = [logBuf,'']
logBuf = [logBuf,'']
logBuf = [logBuf,fitParBuf]

(*Self.iqtinfo) = logBuf

end;sumQArcs



function ooEcho::SQ1D,narcs = narcs,qcount=qcount,_Extra=extra;
;NAME:
;        ooEcho::SQ1D
;
;PURPOSE:
;           CALCULATE A 1D S(Q,t=0) FOR PLOTTING IN cw_nse_sqplot.
;PARAMETERS:
;           none
;KEYWORDS:
;           narcs       Number of Q arcs.
;RETURNS:
;           struct  A structure containing pointer to the S(Q,t=0),sS, q
;
    ;self->addTreatment,'ooEcho::SQ1D'

    if n_elements(narcs) eq 0 then narcs = self.narcs


    ;GET THE DATA AND THE 2D MASK
    e = *(self->getproperty(tag='e'))
    mask = *(self->getproperty(tag='mask2d'))


    sze = size(e)
    szm = size(mask)

    whrmask = where(mask le 0,count)
    if count ne 0 then begin
        mask[whrmask] = 0
    endif

;040306

    etot = total(e[*,0:self->term()-1,*],2)
    setot = sqrt(etot)

;040606
;FIRST MAKE SURE THAT Iup/Down ARE CALCULATED.


    self->calculateArcsQMatrix,narcs=narcs,arcmat=mat

    theQvals = *(self->getproperty(tag='Qvals'))

    s = dblarr(narcs)
    sS = dblarr(narcs)
    q = dblarr(narcs)
    qcount = intarr(narcs)

    sz = size(etot)
    for i=0,sz[1]-1 do begin
        for j=0,sz[2]-1 do begin
            for k=0,narcs-1 do begin
                if mat[i] eq k and mask[i,j] ne 0 then begin
                    s[k] += etot[i,j]/setot[i,j]^2
                    ss[k] += 1.0d/setot[i,j]^2

                    q[k] += theQVals[i,j]
                    qcount[k] += 1
                endif
            endfor;k
        endfor;j
    endfor;i


    qmin = min(theqvals)
    qmax = max(theqvals)

    for i=0,narcs-1 do begin
        if qcount[i] ne 0 then begin
            s[i] = s[i]/ss[i]
            ss[i] = 1.0d/sqrt(ss[i])
            q[i] = q[i]/double(qcount[i])
        endif else begin
            s[i] = 0.0
            ss[i] = 0.0
            if narcs ne 1 then begin
                qstep = (qmax-qmin)/double(narcs-1)
                q[i] = qmin + (double(i)+0.5)*qstep
            endif else begin
                q[i] = self->getproperty(tag='q')
            endelse
        endelse
    endfor;i

    s = s/double(self.preset)
    ss = ss/double(self.preset)

    struct = {s:ptr_new(s),ss:ptr_new(ss),q:ptr_new(q)}

    return,struct

end;SQ1D
;101705
;ADD THE NEXT OPTIONS
pro ooEcho::calculateQVals,dire=dire,nArcs=nArcs,detdist=detdist,xpixel=xpixel,ypixel=ypixel,_Extra=extra
;
;NAME:
;        ooEcho::calculateQVals
;
;PURPOSE:
;           Calculate the Q values array.
;PARAMETERS:
;       none
;KEYWORDS:
;       dire        A directory to work with
;       nArcs       The number of Q arcs on the detector.
;       detdist     Sample to detector distance
;       xpixel      Physical size of a detector pixel in the x-direction in meters
;       ypixel      Physical size of a detector pixel in the y-direction in meters
;


    ;self->addTreatment,'ooEcho::calculateQVals'

    ;101304
    ;COPYING FROM THE IGOR CODE
    ;
    ;SINCE THERE SHOULD BE NO REASON TO WANT TO
    ;CALCULATE Q AND NOT WANT TO CALCULATE I(Q,t)
    ;I SHOULD COMPLETE THE I(Q,t) CALCULATION
    ;HERE AS AN EXACT COPY OF STEVE'S.


    wl = double(self.lambda)
    ;newQ       ---WHAT IS THIS?
;newQ and Fshift ARE USED TO CALCULATE THE Q VALUES
;FOR EACH OF THE ARCS ON THE DETECTOR, SO THEY ARE
;VERY IMPORTANT.  WHAT ARE THEY?????


;VARIABLES
;    detdist = 4.35d
;    xpixel = 0.01
;    ypixel = 0.01

;101705
;DEFINE THE PIXEL SIZES AND DETECTOR DISTANCE
    if n_elements(detdist) eq 0 then detdist = 4.35d
    if n_elements(xpixel) eq 0 then xpixel = 0.01d
    if n_elements(ypixel) eq 0 then ypixel = 0.01d


    qmin = 0.0d & qpix = 0.0d $
    & qc = 0.0d & qstep = 0.0d & il = 0 $
    & jl = 0 & iq = 0 $
    & qlmin = 0.0d & qlmax = 0.0d $
    & it = 0 & nt = 0

    qx = 0.0d & qy = 0.0d $
    & Fshift = 0 & filenum = 0

    if n_elements(dire) eq 0 then begin
        curPath = self.workdir
    endif else curPath = dire

    fn = file_basename(self.filename)
;    substr = strmid(fn,1,6)

    ;101705
    ;MAKE THE FOLLOWING CHANGES IN CASE SOMEONE CHANGED THE FILENAME
    period = strpos(fn,'.')
    substr = strmid(fn,1,period-1)
    ;print,'substr=',substr
    if strlen(substr) le 6 then begin
        if fn ne 'null' then begin
            filenum = fix(substr)
        endif else begin
            filenum = 1771;0    ;NEED THIS CHANGE DUE TO PEOPLE RENAMING FILES.
        endelse
    endif else begin
        filenum = 1771;WHENEVER FILE NUMBER IS TOO LONG, ASSUME MOST CURRENT VALUES.
                      ;THIS COULD BE PUT INTO THE .nse PARM FILE!!!!!
    endelse
;print,'filenum=',filenum

    if (filenum lt 1770 and filenum ge 1300) then begin
        detdist = 4.476d
        xpixel=0.0031d
        ypixel=0.003157d
    endif else begin
        if filenum lt 1300 then begin
            detdist=4.5d
            xpixel = 0.01d
            ypixel = 0.01d
        endif else begin

;101705
;IF THERE ARE INPUTS VALUES THEN WE ACCEPT THEM,
;AND IF THERE ARE NO INPUTS, BUT THE FILENUMBER SATISFIES THESE CRITERIA
;THEN WE WILL ACCEPT THE DEFAULTS.


            ;ACCEPT DEFAULTS/INPUTS AND PRINT THEM.
;        ;101705
;        ;NOW IF THE VALUES WERE PASSED IN FROM OUTSIDE THEY WILL BE PRESERVED HERE.
;        print,'DEFAULTS'
;        print,'detdist=',detdist
;        print,'xpixel=',xpixel
;        print,'ypixel=',ypixel

;            ;filenum ge 1770    ;DEFAULT VALUES
;            detdist=4.35d
;            xpixel = 0.01d
;            ypixel = 0.01d
        endelse;gt 1770

;101705
;NEXT BLOCK REPLACED WITH ABOVE BLOCK
;        if filenum gt 1770 then begin
;            detdist=4.35d
;            xpixel = 0.01d
;            ypixel = 0.01d
;        endif else begin
;            ;filenum lt 1300
;            detdist=4.5d
;            xpixel = 0.01d
;            ypixel = 0.01d
;        endelse;gt 1770
    endelse

    ;THESE ARE NOT NECESSARY IN MY CONVENTIONS
    blockx = self.x_dim_orig/self.x_dim
    blocky = self.y_dim_orig/self.y_dim

    block = double(blockx)

    DetSizeX = self.x_dim_orig
    DetSizeY = self.y_dim_orig

    maxx = DetSizeX/blockx  ;=self.x_dim
    maxy = DetSizeY/blocky  ;=self.y_dim

    IQT = *self.IQT
    IQTe = *self.sIQT

    ;THE NEXT ASSIGNMENT IS DUE TO THE CONFUSION BETWEEN
    ;X,Y,HORIZONTAL AND VERTICAL.  THESE VALUES ARE READ
    ;FROM THE "SCAN" HEADER.


    ;030805
    ;UPDATE THE NEXT LINE TO USE self.qactual

    ;052005
    ;UPDATE THE NEXT LINE TO USE qy NOW THAT qy IS BEING READ FROM THE 6th SEGMENT
    ;OF THE Q LINE, AS IT IS IN IGOR.
    qcy = double(self.qy);double(self.qactual);self.q
    ;print,'qcy=',qcy
    qcx = double(self.qy)   ;VARIABLE IS NOT USED!!!!
    ;print,'qcx=',qcx
    ft=double(*self.fourierTime)
    DetCenX = double(self.x_cen_orig)
    DetCenY = double(self.y_cen_orig)

    nt = n_elements(ft)

;121505
    if n_elements(nArcs) eq 0 then nArcs = self.narcs
    if nArcs lt 1 or nArcs gt 16 then begin
        nArcs = 7
        self.narcs = 7
    endif


    IQT1d = dblarr(nArcs,nt)
    IQT1de = dblarr(nArcs,nt)
    Qs = dblarr(nArcs) & $
    NQs = dblarr(nArcs) & $
    sumQs = dblarr(nArcs)


    QArray = dblarr(maxx,maxy)



    hDetCen = double(self.x_cen_orig)
    vDetCen = double(self.y_cen_orig)

    hIndex = maxx
    vindex = maxy




;032806
;IT LOOKS AS THOUGH THERE IS A MISTAKE IN THE IGOR CODE FROM
;WHICH THIS CODE WAS COPIED.  FOR SMALL ANGLES, Q VALUES
;WERE BASICALLY CORRECT SINCE QY (PERP TO INCIDENT BEAM)
;WAS NEARLY 100% OF THE TOTAL Q, WHILE Qx WAS SMALL, SO THE PROBLEM WAS NEGLIGIBLE.
;HOWEVER, FOR LARGE Q, SUCH AS THOSE USED IN MAGNETIC EXPERIMENTS,
;THE MISTAKE WAS NOTICEABLE, WITH THE CENTRAL Q VALUE APPEARING NEAR THE
;EDGE OF THE DETECTOR.
;
;I DISCUSSED THIS WITH ANTONIO, AND HE AGREES WITH MY ASSESSMENT.
;WE WILL DISCUSS IT FURTHER WITH STEVE AND JASON TOMORROW, BUT I AM
;NOW CHANGING THE Q VALUES USED IN THE CALCULATION (qcy) TO BE
;self.qactual (= sqrt(qx^2 + qy^2) = 4*!PI*sin(phi/2)/lambda)
;
;NOTE THAT ERROR BARS COULD BE CALCULATED FOR Q BASED ON THE
;RANGE OF LAMBDA IF theta = phi/2 IS USED FOR THE Q CALCULATION.
;BUT THIS IS A MATTER FOR ANOTHER TIME.


;print,'ooEcho::calculateQVals'
;print,self.filename
;print,'qcy=',qcy
;print,'self.qy=',self.qy
;print,'self.q=',self.q
;print,'self.qactual=',self.qactual

;032806
;040606
;MINUS SIGN NEEDED SINCE -y DIRECTION IS IN POSITIVE Q HERE AT NCNR (AS OPPOSED TO JULICH).
;THIS WAS DISCOVERED BY BOB LEHENY'S GROUP WHEN THEY NOTICED
;THEIR DYNAMICS WERE _INCREASING_ WITH Q!!!

qcy = -1.0*self.qactual



;    print,'wl = ',wl
;    print,'qcy = ',qcy
;    print,'hDetCen=',hDetCen
;    print,'block=',block
;    print,'xpixel=',xpixel
;    print,'detdist=',detdist

;    print,'vDetCen=',vDetCen
;    print,'ypixel=',ypixel

    for il=0,hIndex-1 do begin
        for jl=0,vindex-1 do begin
;            hQ = sin(asin(qcy*1.0e10*wl/4.0/!PI)-atan((hDetCen-block*il)*xPixel/detdist)/2.0)*4.0*!PI/wl
;            vQ = sin(atan((block*jl- vDetCen)*yPixel/detdist)/2.0)*4.0*!PI/wl

;SO THE ONLY QUESTION AT THIS POINT IS, DO I WANT Q'S
;CALCULATED FOR CENTER OF PIXELS OR LOWER LEFT CORNERS???
;USE CENTER FOR NOW UNTIL CONSULTING STEVE.


;110404
;SHIFT PIXEL POSITIONS BY 1.0 THEN COMPARE WITH STEVE'S RESULTS.
;USE il+=1 FOR THE INCREMENTS AS IN HIS for LOOPS.

;110504
;
;THERE APPEARS TO BE AN ORIENTATION REVERSAL (LEFT-RIGHT) IN THE
;INDEXING.  SET UP AND INDEX TO FIX THIS.
;
;RECALL: THE HARDWARE DEFINES +X AS UP AND -Y AS POSITIVE Q.
;
;THIS IS IMPORTANT WHEN DEFINING DETECTOR CENTER POSITIONS
;RELATIVE TO THE INDIVIDUAL PIXELS

            ilflip = double(self.x_dim - il)
            hDetCenflip = double(self.x_dim_orig - hDetCen)
            jlflip = double(jl)
            vDetCenflip = double(vDetCen)





;            hQ = sin(asin(qcy*1.0e10*wl/4.0/!PI)- $
;            atan((hDetCen-block*(il+1.0))*xPixel/detdist)/2.0)*4.0*!PI/wl

            hQ = sin(asin((-1.0d)*qcy*double((10.0d)^(10.0d))*wl/4.0d/!DPI)- $
            atan((hDetCenflip-block*(ilflip))*xPixel/detdist)/2.0d)*4.0d*!DPI/wl
            vQ = sin(atan((block*(jlflip)- $
                vDetCenflip)*yPixel/detdist)/2.0d)*4.0d*!DPI/wl

            totQ = sqrt(vQ^2 + hQ^2)
            QArray[il,jl] = totQ/((10.0d)^(10.0d))   ;CONVERT TO 1/ANG
        endfor;jl
    endfor;il
    qmin = min(QArray)
    qmax = max(QArray)

;print, "qcy			%10.4f\r",qcy
;print, "wl			%10.4f\r",wl
;print, "pi			%10.4f\r",!PI
;print, "hDetCen			%10.4f\r",hDetCen
;print, "block			%10.4f\r",block
;print, "detDist			%10.4f\r",detDist
;print, "vDetCen			%10.4f\r",vDetCen
;print, "xPixel				%10.4f\r",xPixel
;print, "xPixel				%10.4f\r",xPixel



;    print,'ooEcho::CalculateQVals QArray'
;    print,QArray
;    print,'ooEcho::CalculateQVals *self.qarcs'
;    print,*self.qarcs
;    print,'QArray=',QArray
    ;REFORM Q-ARRAY TO 1-D ARRAY!!!
    sz = size(QArray)

    ;print,10.0^10.0

;    print,sz
    QArray = transpose(reform(QArray,sz[n_elements(sz)-1]))

    if self.no_of_fourier_times gt 1 then begin
        QArrayNew = [QArray]
        for i=0,self.no_of_fourier_times-2 do begin
            QArrayNew = [QArrayNew,Qarray]
        endfor
    endif ;$
;    $   ;041105
;    $   ;ADDING THE NEXT ELSE STATEMENT.  THIS MAY CRASH OTHER THINGS!!!
;    $
;    else begin
;        ;print,self.no_of_fourier_times
;
;
;        QArrayNew = [QArray]
;        ;print,size(QArray)
;    endelse
    QArray = transpose(QArrayNew)

    if ptr_valid(self.QVals) ne 0 then ptr_free,self.QVals
    self.QVals = ptr_new(QArray)
;
;IS THIS ALL THAT IS NEEDED HERE?  IF SO,
;MAYBE I SHOULD JUST ADD THE I(Q,t) CALCULATION TO MAKE IT
;THE SAME AS THE IGOR VERSION.
;

end;calculateQVals
pro ooEcho::calculateQVals_orig,_Extra=extra
;
;NAME:
;        ooEcho::calculateQVals_orig
;
;PURPOSE:
;           Calculate Q values for the image.
;           This may no longer be used.
;PARAMETERS:
;           none
;KEYWORDS:
;           none

    ;self->addTreatment,'ooEcho::calculateQVals_orig'


    ;`
    ;NEED CENTER, QVALUE OF CENTER
    ;
    ;


    sd = [4.476,4.35,4.50]          ;DETECTOR DISTANCES IN METERS
    xpixsz = [0.0031,0.01,0.01]     ;DETECTOR PIXEL SIZES IN METERS
    ypixsz = [0.003157,0.01,0.01]

    ;qc = sqrt((self.qy*1.0e-10)^2 + (self.q*1.0e-10)^2)


    ;CONVERT THE NEXT LINE TO USE THE ACTUAL Q VALUE FROM THE PHYSICS PARAMETERS HEADER
    ;INSTEAD OF THE NOMINAL Q VALUE.
    ;qc = sqrt((self.qy)^2 + (self.q)^2)
    qc = sqrt((self.qy)^2 + (self.qactual)^2)

    ;print,qc

    lambda = 10.0^10*self.lambda
    ;ARE THE q VALUES LISTED IN THE FILES ALWAYS AT THE
    ;DETECTOR CENTER?
    ;
    ;IF SO, WHERE DO THE 0.16 VALUES COME FROM?
    ;IS IT (16 pixels)*(0.01 m/pixel)?

    ;DOES THIS CALCULATION ACCOUNT FOR BINNING??!!??
    ;YES.

    qmin = (4.0*!PI/lambda) $
                * sin(asin(qc*lambda/(4.0*!PI)) $
                - 0.5*atan(0.16/sd))
    qmax = (4.0*!PI/lambda) $
                * sin(asin(qc*lambda/(4.0*!PI)) $
                + 0.5*atan(0.16/sd))
    if (qc lt 0.01) then begin
        qmin = (4.0*!PI/lambda)*sin(0.5*atan(0.06/sd))
        qmax = (4.0*!PI/lambda)*sin(0.5*atan(0.16/sd))
    endif

    ;print,'In calculateQVals, qmin=',qmin
    ;print,'In calculateQVals, qmax=',qmax

    sz = size(*self.QVals)
    qvals = 0.0*(*self.QVals)

    xdim = self.x_dim
    ydim = self.y_dim

    xdimorig = self.x_dim_orig
    ydimorig = self.y_dim_orig


    xfactor = self.x_dim_orig/self.x_dim
    yfactor = self.y_dim_orig/self.y_dim

    ;INITIALIZE THE DETECTOR CENTER VALUES FOR TESTING
    ;self.x_cen_orig = 16.0
    ;self.y_cen_orig = 15.0


;
;THE CREATION OF THESE ARRAYS MAKE THE
;CALCULATION OF Q VALUES MORE CONCISE, THOUGH
;POSSIBLE LESS READABLE.
;
;THE INDEXING SEEMS TO WORK OUT HERE, ALTHOUGH
;IN LIGHT OF STEVE'S UNDERSTANDING OF HORIZONTAL
;AND VERTICAL DIRECTIONS IN THE IGOR SOFTWARE,
;PERHAPS THE INDICES ARE NO LONGER APPROPRIATE
;IN THIS FORM.
;
;
;

    ;PIXEL NUMBERS IN THE X AND Y DIRECTIONS
    il = double(indgen(sz[1]) mod self.x_dim)
    jl = double(indgen(sz[1])/self.y_dim)

    ;help,il
    ;print,reform(il,sqrt(n_elements(il)),sqrt(n_elements(il)))
    ;help,jl


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;IT TURNS OUT THAT, ACCORDING TO STEVE KLINE,
;THE Q AXES FOR THE DATA ARE DESCRIBED AS
;FOLLOWS:
;
;MOVING THE DETECTOR TO LARGER Q-VALUE IS
;(-)Qy, AND NOT Qx AS EXPECTED.
;
;Qcx (VERTICAL) IN THE SOFTWARE IS REALLY MEANINGLESS,
;SINCE THE X-LOCATION OF THE BEAM CENTER IS MEASURED.
;
;SO STEVE HAS CHOSEN TO RE-WRITE THE IGOR CODE
;TO REFLECT "VERTICAL" AND "HORIZONTAL" DIRECTONS
;ON THE DETECTOR.
;
;

    ;THE NEXT COMMAND MUST BE TAILORED SO THAT INCREASING
    ;Qx CORRESPONDS TO THE CORRECT DIRECTION.
    ;
    ;CHECK I(Q,t) DATA AFTERWARD TO DETERMINE CORRECT
    ;CALCULATION OF Q.

;
;101204
    ;THE NEXT LINE WAS CUT OFF ON STEVE'S PRINTOUT.
    ;NEED TO REPLACE THE '....' WITH THE CORRECT VALUE.

;;
;;  for il=0,self.x_dim_orig/xfactor-1 do begin
;;   for jl=0,self.y_dim_orig/yfactor-1 do begin
;;    hq = sin(asin(qcy*lambda/(4.0*!PI)) -$
;;                atan((self.x_cen_orig - xfactor*il)*(....)   )
;;    vq = sin(0.5*atan((yfactor*jl - self.y_cen_orig)*ypixsz[2]/sd[2])*4* .... )
;;
;;
;;   endfor;jl
;;  endfor;il
;
;NEXT, DO A FOR LOOP WHERE THE qVals ARE SET TO
;sqrt(vq^2 + hq^2)
;


    qx = (4.0*!PI/lambda)*$
            sin(asin(qc*lambda/(4.0*!PI)) - $
                0.5*atan((xfactor*il-self.x_cen_orig)* $
                (xpixsz[2]/sd[2]))$
                )




    ;THE qy CALCULATION SEEMS TO ASSUME THAT qy=0 IS ALONG THE CENTER
    ;LINE OF THE DETECTOR.
    qy = (4.0*!PI/lambda)*$
            sin($
                0.5*atan((yfactor*jl-self.y_cen_orig)*(ypixsz[2]/sd[2]))$
                )
    ;help,qx
    ;help,qy

    for i=0,sz[2]-1 do begin
        qvals[*,i] = sqrt(qx^2 + qy^2)
    endfor;i

    ;help,qvals
    sz = size(qvals)
    ;print,reform(qvals[*,0],sqrt(sz[1]),sqrt(sz[1]))
    if ptr_valid(self.qvals) gt 0 then ptr_free,self.qvals
    self.qvals = ptr_new(qvals)

    self.QValsSwitch = 1
end;calculateQVals_orig

;;
;FILE READER METHODS
;;;
pro ooEcho::readSampleHeader,lun,sampleHeader,_Extra=extra
;
;NAME:
;        ooEcho::readSampleHeader
;
;PURPOSE:
;
;PARAMETERS:
;       lun             The file unit number to read from.
;       sampleHeader    The variable to hold the sampleHeader.
;KEYWORDS:
;       none
;self->addTreatment,'ooEcho::readSampleHeader'

;READ IN THE SAMPLE HEADER SECTION OF A .echo FILE

line = ""
readf,lun,sampleHeader
repeat begin
  readf,lun,line
  sampleHeader = [sampleHeader,line]
  ;segs = strsplit(line,/extract)
  ;sampleHeaderSize++
endrep until (stregex(line,'eof',/boolean))
;endrep until (segs[0] eq "eof") ;SHOULD CHANGE THIS TO USE stregex
                                ;SINCE segs DOESN'T MATTER HERE.
                                ;e.g.
                                ; until(stregex(line,'eof',/boolean))

;THESE READF's MAY BE A PROBLEM FOR ABORTED FILES.
readf,lun,line  ;READ BLANK LINE AFTER eof LINE
sampleHeader = [sampleHeader,line]
;sampleHeaderSize++

end;readSampleHeader

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::HandleTheError,_Extra=extra
;
;NAME:
;        ooEcho::HandleTheError
;
;PURPOSE:
;           A method to call when an error happens and nothing is to be done.
;PARAMETERS:
;           none
;KEYWORDS:
;           none
;_EXTRA - is used to pass keywords meant for the superclass.
    ;self->addTreatment,'ooEcho::HandleTheError'

    print,'3079 ooEcho::HandleTheError IOError occurred.'
end;HandleTheError
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

function ooEcho::deadTime,im,counter0,counter4,preset,counter1,counter2,counter3,_Extra=extra
;        ims = self->deadTime(ims,counters[0,i,j],counter[4],preset)

;
;NAME:
;        ooEcho::deadTime
;
;PURPOSE:
;           PERFORM THE DEADTIME AND MONITOR CORRECTIONS FOR A SINGLE DETECTOR IMAGE.
;PARAMETERS:
;           im      A SINGLE DETECTOR IMAGE TO CORRECT.
;KEYWORDS:
;           none
;RETURN VALUE:
;           THE CORRECTED DETECTOR IMAGE.
;;

    ;self->addTreatment,'ooEcho::deadTime'
print,'________________'
print,'ooEcho::deadTime'

;counters[*,i,j] = double(segs[1:10])
;counters    42448.0       0.0       0.0       0.0  184792.0       0.0       0.0       0.0       0.0       0.0

    ;042505
    ;VALUES HERE ARE TAKEN DIRECTLY FROM IGOR CODE

;111505
;
;IF counter4 is 0, THEN COUNTS ARE RECORDED IN

;LATER ADD TEST FOR FILE NUMBER OR OTHER PARAMETERS.
filename = file_baseName(self.filename)
sfilenum = strmid(filename,1,strpos(filename,'.'))
filenum = fix(sfilenum)
if filenum ge 4158 then begin
    if counter4 eq 0 then begin
        counter4 = counter0
        counter0 = counter3
    endif
endif
    ;SCALE DATA TO ACTUAL NUMBER OF MONITOR COUNTS.
    monitorscale = (double(preset)/double(counter4))
    DeadTime = 0.7e-6

;    CountRate = double(double(total(long64(im*preset/counter4)))/double((double(counter0)/9871.5d)))


;countrate = ave_counts_per_pixel*npixels/(totaltime_in_cycles/(frequency_meter_rate))
    CountRate = mean(im*monitorscale)*double(n_elements(im))/(double(counter0)/9871.5d)
    deadScale = 1.0/(1-DeadTime*CountRate)
;print,'preset,counter4,monitorscale, counter0, deadScale'
;print,preset,counter4,monitorscale, counter0, deadScale
    newim = long(im*deadScale)

    return,newim
end;deadTime
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;read IS A RATHER LENGTHY METHOD FOR READING IN
;THE ECHO DATA FROM A .echo FILE
;
;
;UPDATE THIS METHOD TO HANDLE MORE SUDDEN ENDS OF FILES
;
;UTILIZE THE REGULAR EXPRESSIONS METHODS SUCH AS stregex
;TO AVERT PROBLEMS DUE TO ONE LINE OFF ISSUES.
;
;
;;;
function ooEcho::read,filename=filename,magnetic=magnetic,_Extra=extra
;
;NAME:
;        ooEcho::read
;
;PURPOSE:
;       Read in a raw .echo file.
;PARAMETERS:
;       none
;KEYWORDS:
;       filename    An optional filename to open.
;RETURN VALUE:
;       1 for success
;       0 for failure

    ;self->addTreatment,'ooEcho::read'



;;
;READ IN AN ECHO FILE.  TURN THIS INTO A FUNCTION
;WHICH WILL RETURN A STRUCTURE CONTAINING ALL OF
;THE IMPORTANT PARAMETERS FROM THE FILE.
;
;
;;
;
;USES THE ooEcho::readSampleHeader METHOD
;
;;;

;print,'##################################################'
;print,'I SHOULD NEVER GET HERE FROM ooEchoMagnetic!!!!!'
;print,'##################################################'

;INITIALIZE SOME USEFUL VARIABLES
scanHeaderSize = 27
sampleHeaderSize = 11   ;THIS FINAL VALUE WILL CHANGE
                        ;DEPENDING ON COMMENT SIZE
techHeaderSize = 54
physicsHeaderSize = 16
physicsParametersHeaderSize = 45
phaseHeaderSize = 4
no_of_phases = 27
point_to_down = 19
point_to_up = 24
phase_step = 45.0

fn = ''
line = ""
segs = ["test1","test2"]

;INITIALIZE GENERAL HEADERS
scanHeader = strarr(scanHeaderSize)
sampleHeader = strarr(sampleHeaderSize) ;17

;SELECT FILE TO OPEN
if (n_elements(filename) ne 0) then begin
    fn = filename
endif else begin
    fn=dialog_pickfile(/read,filter='*.echo',/must_exist)
endelse

to = systime(1,/seconds)


CATCH, Error_status
;HANDLE INITIAL ERRORS IN READING THE DATA
;FILE.
IF (Error_status NE 0) THEN BEGIN
  free_lun,lun,/force
  print,'2165 ooEcho::read DATA FILE IS INCOMPLETE.'
  CATCH, /CANCEL
  return,0
ENDIF


;READ FILE'S SAMPLE AND SCAN HEADERS
if (fn eq '') then begin
  ;if (err ne 0) then begin
  print,'2174 ooEcho::read ', !error_state.msg
  return, 0
endif

openr,lun,fn,/get_lun,error = err
self.filename = fn
;print,lun
;print,'        readf,lun,scanHeader'
readf,lun,scanHeader

if (ptr_valid(self.scanHeader) gt 1) then ptr_free,self.scanHeader
self.scanHeader = ptr_new(scanHeader)
;NEED TO READ sampleHeader IN TWO PARTS DUE TO UNCERTAIN
;LENGTH OF COMMENT
;print,systime(1,/seconds)-to
;print,'        self->readSampleHeader,lun,sampleHeader'
self->readSampleHeader,lun,sampleHeader
;print,systime(1,/seconds)-to
sampleHeaderSize = n_elements(sampleHeader)

;EXTRACT SAMPLE COMMENT
segsTemp = strsplit(sampleHeader[12],/extract)
self.comment = segsTemp[1]
for ii = 2,n_elements(segsTemp)-1 do begin
  self.comment = self.comment + ' ' + segsTemp[ii]
endfor;ii


if (ptr_valid(self.sampleHeader) gt 1) then ptr_free,self.sampleHeader
self.sampleHeader = ptr_new(sampleHeader)


;EXTRACT SOME IMPORTANT PARAMETERS FOR READING REST OF FILE

;THIS IS THE MONITOR VALUE
preset = long((double((strsplit(scanHeader[8],/extract))[2])))
no_of_phases = fix((strsplit(scanHeader[9],/extract))[2])
point_to_down = fix((strsplit(scanHeader[10],/extract))[2])
point_to_up = fix((strsplit(scanHeader[11],/extract))[2])
phase_step = float((strsplit(scanHeader[12],/extract))[2])

;040805
;
;IF THE SCAN TYPE IS "MIXED" THEN THE no_of_fourier_times WILL BE
;IN THE 11th POSITION INSTEAD OF THE 10th AS IS THE CASE WITH THE
;USUAL "phys" SCAN TYPE.
;
scantype = (strsplit(scanHeader[18],/extract))[2]
;print,'        scantype = (strsplit(scanHeader[18],/extract))[2]'
case scantype of
  'phys':begin
    no_of_fourier_times_index = 9
  end

  'tech':begin
    void = dialog_message('"'+scantype+'" type not recognized.  Email kneller@nist.gov for assistance.')
    return,0
  end

  'mixed':begin
    no_of_fourier_times_index = 10
  end

  'slave':begin
    void = dialog_message('"'+scantype+'" type not recognized.  Email kneller@nist.gov for assistance.')
    return,0
  end

  else:begin
    void = dialog_message('"'+scantype+'" type not recognized.  Email kneller@nist.gov for assistance.')
    return,0
  end

endcase

no_of_fourier_times = fix((strsplit(scanHeader[23],/extract))[no_of_fourier_times_index]);9])
if no_of_fourier_times le 1 then begin
  void = dialog_message('Less than 2 Fourier times not currently supported.  Email kneller@nist.gov for assistance.')
  return,0
endif

;101304
;
;STEVE DISCOVERED THAT X,Y,HORIZONTAL,VERTICAL, ARE ALL
;CONFUSED WITH THE NSE.

;BUT STICK WITH THE NEXT VERSION AND MAKE THE CORRECTION IN
;THE METHOD ooEcho::calculateQVals
;
q = double((strsplit(scanHeader[23],/extract))[3])


;        ;UPDATE 040804
;        qy = double((strsplit(scanHeader[23],/extract))[4])
;        ;print,q

;031705
;UPDATE BELOW IN PHYSICS PARAMETERS HEADER TO GET qy ACTUAL


;NOTE THAT THE ACTUAL VALUE OF Q IS LISTED IN THE
;PHYSICS PARAMETERS HEADER.  --- SEE THE READ OF PHYSICS PARAMETERS HEADER BELOW
;FOR THE ACQUISITION OF THAT VALUE.

self.q = q

;031705
;SEE UPDATE BELOW FOR READ OF qy
;        ;UPDATE 040804
;        self.qy = qy



;DEFINE AND INITIALIZE HEADERS THAT OCCUR FOR EACH FOURIER TIME
techHeader = strarr(techHeaderSize,no_of_fourier_times)
physicsHeader = strarr(physicsHeaderSize,no_of_fourier_times)

;THIS ARRAY'S SIZE WILL VARY FROM FILE TO FILE!!!
;
;DO LINE-BY-LINE READ FIRST TIME THROUGH SINCE
;THE SIZE OF THIS HEADER VARIES FROM FILE TO FILE.
;
;DEFINE THIS ARRAY DURING THE FIRST PASS IN j LOOP
;        physicsParametersHeader = strarr(physicsParametersHeaderSize,$
;                                        no_of_fourier_times)

;DEFINE PARAMETERS THAT OCCUR FOR EACH PHASE
;PHASE HEADERS OCCUR WITH EACH PHASE VALUE
phaseHeader = strarr(phaseHeaderSize,$
no_of_phases,$
no_of_fourier_times)
phase = findgen(no_of_phases,no_of_fourier_times)
fourierTime = fltarr(no_of_fourier_times)


;040804: THE NEXT INITIALIZATION WILL NEED TO
;        BE FIXED FOR 128x64 DETECTORS, ETC.

;INITIALIZE THE etemp ARRAY
etemp = lindgen(1024,no_of_phases,no_of_fourier_times)
iec_multimeter = {NSE_METERS_STRUCT,$
  Temperatur:0.0,$
  BSpiy:0.0,$
  BSpi21x:0.0,$
  BSpi21z:0.0,$
  BSpi22y:0.0,$
  BSpix:0.0,$
  BSpiz:0.0,$
  BSpi21y:0.0,$
  BSpi22x:0.0,$
  BSpi22z:0.0 $
  }
meters=replicate(iec_multimeter,no_of_phases,no_of_fourier_times)
for iiec=0,n_elements(meters)-1 do begin
  ;meters[iiec].BSpi22y = 0.0
  for jiec = 0,9 do begin
    meters[iiec].(jiec) = 0.0
  endfor
endfor;iiec
counters=dblarr(10,no_of_phases,no_of_fourier_times)
monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}
monitors=replicate(monitor_struct,no_of_fourier_times)

;;
;DEFINE THIS CATCH STATEMENT TO TAKE CARE OF
;SUDDEN END OF FILE
;;;

CATCH, Error_status
;This statement begins the error handler:
IF (Error_status NE 0) THEN BEGIN
  ;PRINT, 'Error index: ', Error_status
  ;PRINT, 'Error message: ', !ERROR_STATE.MSG
  ;print,!ERROR_STATE
  
  ; Handle the error by extending A:
  ;A=FLTARR(12)
  
  ;close,lun,/force
  free_lun,lun,/force
  ;print,i,j,systime(1,/seconds)-to
  help,self.e,output=out,struct=0
  if stregex(out,'NULL',/fold_case,/boolean) then begin
    print,'2295 ooEcho::read INSUFFICIENT DATA IN FILE'
    return,0
  endif else begin
    print,'2298 ooEcho::read FILE READ AS WELL AS I COULD!'
    return,1
  endelse
  
  ;print,"THIS ERROR WAS HANDLED!  RETURNING VALUE."
  CATCH, /CANCEL
  return,1
ENDIF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
self.preset = preset
self.no_of_phases = no_of_phases
self.point_to_down = point_to_down
self.point_to_up = point_to_up
self.phase_step = phase_step
self.no_of_fourier_times = no_of_fourier_times
self.no_of_pixels = 0  ;INITIALIZE HERE
;self.q = q
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;
;MAIN READ LOOPS
;;;
for j=0,no_of_fourier_times-1 do begin

  ;READ techHeader
  ;print,"READING TECH HEADER:"
  lines = strarr(techHeaderSize)
  readf,lun,lines
  techHeader[*,j] = lines
  ;print,'    techHeader[*,j] = lines'
  ;lines 43-45???
  
  ;GET THE MONITOR VALUES FROM EACH TECH HEADER
  
  
  ;
  ;071304
  ;
  ;THIS COULD BE DONE BY STREGEX'ING THE TECH HEADER
  ;FOR THE WORD 'monitors' AND READING THE NEXT 3 LINES.
  
  for nn=0,n_tags(monitor_struct)-1 do begin;42,44 do begin  
    segs = strtrim(strsplit(techHeader[43+nn,j],/extract),2)
    monitors[j].(nn) = long(segs[3])  
  endfor;nn

  ;READ physicsHeader
  ;print,"READING PHYSICS HEADER:"
  lines = strarr(physicsHeaderSize)
  readf,lun,lines
  physicsHeader[*,j] = lines
  ;print,'    physicsHeader[*,j] = lines'

  ;EXTRACT LAMBDA AND DLAMBDA VALUES FROM DATA
  lambdaSegs = strsplit(physicsHeader[3,j],/extract)
  dlambdaSegs = strsplit(physicsHeader[4,j],/extract)
  self.lambda = double(lambdaSegs[2])
  self.dlambda = double(dlambdaSegs[2])

  ;READ physicsParametersHeader
  ;print,"READING PHYSICS PARAMETERS HEADER:"

  ;lines = strarr(physicsParametersHeaderSize)
  ;readf,lun,lines

  ;NOTE THAT PHYSICS PARAMETERS HEADERS ARE OF CONSTANT LENGTH
  ;WITHIN A FILE, BUT MAY DIFFER FROM FILE TO FILE,
  ;SO THE FOLLOWING IS NECESSARY TO GET AROUND THIS.
  qActualIndex = 14
  fourierTimeIndex = 28
  lines = ""
  line = ""
  if (j eq 0) then begin
    segs = strsplit(line,/extract)
    n = 0
    while (segs[0] ne 'eof') do begin
      readf,lun,line
      n = n+1
      ;print,n_elements(lines)," ",n," ",line
      lines = [lines,line]
      ;print,lines
      segs = strsplit(line,/extract)
      if (n_elements(segs) gt 1) then begin
        ;if (segs[0] eq 'q') then qActualIndex = n-1
        ;if (segs[0] eq 'fouriertime') then fourierTimeIndex = n-1
  
        case segs[0] of
          'fouriertime':begin
            fourierTimeIndex = n-1
          end

          'q':begin
            qActualIndex = n-1
          end

          else:begin
          end
        endcase
  
        ;print,fourierTimeIndex," ",segs
        ;print,n-1
      endif
    endwhile
    readf,lun,line   ;READ BLANK LINE
  
    ;print,n_elements(lines)," ",line
    physicsParametersHeaderSize = n_elements(lines)
    physicsParametersHeader = strarr(physicsParametersHeaderSize,no_of_fourier_times)
  endif else begin
    lines = strarr(physicsParametersHeaderSize)
    line = ""
    readf,lun,lines
    ;readf,lun,line
  endelse
  physicsParametersHeader[*,j] = lines
  ;    print,j," READ physicsParametersHeader"

  ;GET THE ACTUAL CURRENT FOURIER TIME FROM THE PHYSICS PARAMETERS HEADER
  ;print,physicsParametersHeader[fourierTimeIndex,j]

  if (j eq 0) then begin
    qsegs = strsplit(physicsParametersHeader[qActualIndex+1,j],/extract)
    tsegs = strsplit(physicsParametersHeader[fourierTimeIndex+1,j],/extract)
  endif else begin
    tsegs = strsplit(physicsParametersHeader[fourierTimeIndex,j],/extract)
  endelse
  fourierTime[j] = double(tsegs[2])
  qactual = double(qsegs[2])/(10.0d^10.0d)
  self.qactual = qactual
  ;print,qsegs[5]

  ;052005
  ;IT TURNS OUT THAT THE qy INDEX IS 6 DUE TO THE '/m' SEG!!!!!
  qy = double(qsegs[6])/(10.0d^10.0d)
  ;031705
  self.qy = qy
  ;print,fourierTime[j]


  ;;
  ;READ IN ALL PHASES FOR THE jTH FOURIER TIME
  ;;;
  lines = strarr(phaseHeaderSize)     ;phaseHeaderSize is 4
  for i=0,no_of_phases-1 do begin
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;
    ;READ THE PHASE HEADER
    ;;;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
    ;READ PHASE HEADER ASSOCIATED WITH THIS PHASE
    segs[0] = ""
    readf,lun,lines
    phaseHeader[*,i,j] = lines
    ;print,lines
    ;030805
    ;
    ;THERE IS A FEATURE IN THE NSE CONTROL SOFTWARE THAT CAUSES IT
    ;TO WRITE THE TECH, PHYSICS AND PHYSICS PARAMETERS HEADERS MULTIPLE
    ;TIMES IF THE IS A GLITCH IN A HARDWARE COMPONENT.
    ;ACCOUNT FOR THAT HERE BY TESTING THE FIRST LINE OF THE PHASE
    ;HEADER FOR 'phase' AND 3 SEGMENTS.
  
    segs = strsplit(phaseHeader[0,i,j],/extract)
    if n_elements(segs) ne 2 or segs[0] ne 'phase' then begin
      print,'THERE WAS A PROBLEM WITH THE PHASE HEADER, PROBABLY A HARDWARE GLITCH.'
      print,'3033 ooEcho::read    I "fixed" the glitch.'
      glitchline = ''
      postglitchline = strarr(3)
      while segs[0] ne 'phase' do begin
          readf,lun,glitchline
          segs = strsplit(glitchline,/extract)
      endwhile
      ;NOW GET THE REST OF THE CORRECT PHASE HEADER.
      phaseheader[0,i,j] = glitchline
      readf,lun,postglitchline
      phaseheader[1:*,i,j] = postglitchline
    endif
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;
    ;PARSE THE PHASE HEADER INFORMATION
    ;;;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    
    ;GET THE PHASE FOR THIS PHASE
    segs = strsplit(phaseHeader[0,i,j],/extract)
  
    ;TAKE CARE OF INITIALIZATION OF THE ARRAY AT THIS POINT TO AVOID
    ;STRAY FLIPPER OFF POINT.
    if j eq 0 then begin
        phase[i,*] = float(segs[1])
    endif else begin
        phase[i,j] = float(segs[1])
    endelse
    ;print,'phase=',phase
    ;print,phase[i,j]
    ;GET THE COUNTERS FOR THIS PHASE
    segs = strsplit(phaseHeader[1,i,j],/extract)
    counters[*,i,j] = double(segs[1:10])
  
    ;;
    ;GET THE METER VALUES FOR THIS PHASE
    ;;;
    segs = strsplit(phaseHeader[2,i,j],/extract)
    ;METERS MAY NOT INCLUDE A TEMPERATURE VALUE
    if (segs[1] ne 'Temperatur') then begin
      meters_offset = 2
    endif else begin
      meters_offset = 1
    endelse
    for ii=0,n_tags(iec_multimeter)-meters_offset do begin
      meters[i,j].(ii) = float(segs[3*ii+2])     ;REFER TO TAG BY ELEMENT INDEX
      ;print,segs[3*ii+2]
    endfor

    ;GET THE NUMBER OF PIXELS IN DETECTOR
    segs = strsplit(phaseHeader[3,i,j],/extract)
    no_of_pixels = fix(segs[1])  
  
    ;10/20/04
    ;
    ;THIS IS ONE OF THE CRITICAL POINTS WHERE THE OPTION
    ;FOR DIFFERENT DETECTOR SIZES WOULD NEED TO BE ENABLED.
    case no_of_pixels of
      1024:begin
           self.x_dim_orig = 32 & self.y_dim_orig = 32
        end;1024

      else:begin
           self.x_dim_orig = 32 & self.y_dim_orig = 32
        end;else
    endcase;no_of_pixels
  
    ;THEN REPLACE THE SQUARE ROOTS BELOW WITH self.x,y_dim_orig
  
    ;DECLARE e (THE 3-D DATA MATRIX) THE FIRST TIME THROUGH
    if ((j eq 0) and (i eq 0)) then begin
      ;etemp = lindgen(no_of_pixels,no_of_phases,no_of_fourier_times)
      etemp = lonarr(no_of_pixels,no_of_phases,no_of_fourier_times)
      if ptr_valid(self.e) gt 0 then ptr_free,self.e
  
      ;040804: DATA ARRAY SIZE _IS_ SET WHEN NECESSARY
      self.e = ptr_new(etemp,/no_copy)
      mask2dtemp = intarr(self.x_dim_orig,$
                          self.y_dim_orig,$
                          no_of_fourier_times)+1
  
      if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
      self.mask2d = ptr_new(mask2dtemp)
      ;self->setProperty,'mask2d',ptr_new(mask2dtemp,/no_copy)
      mask1dtemp = intarr(no_of_phases,no_of_fourier_times) + 1
      if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
      self.mask1d = ptr_new(mask1dtemp)
      ;self->setProperty,'mask1d',ptr_new(mask1dtemp,/no_copy)
  
      ;self->setProperty,'eorig',ptr_new(etemp)
    endif
  
    ;        ims = lindgen(no_of_pixels)
    ims = lonarr(no_of_pixels)
    readf,lun,ims
    ;print,i,j,total(ims)
    ;print,counters[0:4,i,j] 
    ;help,ims
    ims = self->deadTime(ims,counters[0,i,j],counters[4,i,j],preset,$
                            counters[1,i,j],counters[2,i,j],counters[3,i,j])
  
    (*self.e)[*,i,j] = ims
    ;help,ims
   
    ;SET OBJECT MEMBER VALUES BEFORE FINAL LINE READ
    ;
    if ptr_valid(self.phase) gt 0 then ptr_free,self.phase
    self.phase = ptr_new(phase)  
    if ptr_valid(self.meters) gt 0 then ptr_free,self.meters
    self.meters = ptr_new(meters)  
    if ptr_valid(self.counters) gt 0 then ptr_free,self.counters
    self.counters = ptr_new(counters) 
    if ptr_valid(self.monitors) gt 0 then ptr_free,self.monitors
    self.monitors = ptr_new(monitors)  
    self->setProperty,'no_of_phases',no_of_phases
    self->setProperty,'point_to_down',point_to_down
    self->setProperty,'point_to_up',point_to_up
    self->setProperty,'phase_step',phase_step
    self->setProperty,'no_of_fourier_times',no_of_fourier_times
    self->setProperty,'no_of_pixels',no_of_pixels
    self->setProperty,'q',q
    self->setProperty,'qactual',qactual
    self->setProperty,'qy',qy
    if (ptr_valid(self.fourierTime) gt 0) then $
                                ptr_free,self.fourierTime
    self.fourierTime = ptr_new(fourierTime)
    self.qactual = qactual
    if (ptr_valid(self.techHeader) gt 0) then $
                                ptr_free,self.techHeader
    self.techHeader = ptr_new(techHeader)
    if (ptr_valid(self.physicsHeader) gt 0) then $
                                ptr_free,self.physicsHeader
    self.physicsHeader = ptr_new(physicsHeader)
    if (ptr_valid(self.physicsParametersHeader) gt 0) then $
                                ptr_free,self.physicsParametersHeader
    self.physicsParametersHeader = ptr_new(physicsParametersHeader)
    if (ptr_valid(self.phaseHeader) gt 0) then $
                                ptr_free,self.phaseHeader
    self.phaseHeader = ptr_new(phaseHeader)
    ;print,i,j,systime(1,/seconds)-to

    ;040105
    ;ooEcho::read CRASHES OUT HERE ON LAST FOURIER TIME AND ERROR IS CAUGHT ABOVE.
    ;IS IT NECESSARY TO DO IT THIS WAY?
    ;
    ;PLACING THE SETTING OF POINTERS/VALUES ABOVE THIS LINE TAKES CARE OF THE
    ;READ PROBLEM FOR THE FIELDS.

    ;READ BLANK LINE --- THIS IS PROBABLY WHERE THE READ CRASHES
    readf,lun,line

    ;;print,i,j,systime(1,/seconds)-to

  endfor;i
endfor;j

free_lun,lun,/force

return,1
end;ooEcho::read
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;DISPLAY PROCEDURES
;;;
;;
;display WRAPS THE PROCEDURE displayEcho PREVIOUSLY WRITTEN
;
;THIS CAN WRAP ANY DISPLAY PROGRAM WE CHOOSE TO USE LATER
;LEAVING FLEXIBILITY FOR BETTER INTERFACES.
;;;
;
;
;
;
;
pro ooEcho::display,_Extra=extra
;
;NAME:
;        ooEcho::display
;
;PURPOSE:
;       THIS WAS THE ORIGINAL DISPLAY METHOD FOR ooEcho, BUT IT HAS BEEN REPLACED
;       BY ooDisplayEcho AND IS NO LONGER USED.
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
    ;self->addTreatment,'ooEcho::display'


    void = dialog_message("Use 'ooDisplayEcho' for display."+$
                          "DisplayEcho is obsolete.  "+$
                          "onew = obj_new('ooDisplayEcho',echoObj)")
    ;;
    ;displayEcho is obsolete.
    ;;;
    ;displayEcho,self

end;ooEcho::display
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;OPERATIONS METHODS
;
;
;bin
;maskify
;
;;;
;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::bin,xfactor=xfactor,yfactor=yfactor,factor=factor,_Extra=extra
;
;NAME:
;        ooEcho::bin
;
;PURPOSE:
;           Bin the echo data set.
;PARAMETERS:
;           None.
;KEYWORDS:
;           factor      Binning factor applied to both dimensions.  If present it overrides x,yfactor.
;           xfactor     Binning factors appplied specifically to each dimension.
;           yfactor
;           _Extra      Catch any extra keywords.

    ;self->addTreatment,'ooEcho::bin'


    ;;
    ;THIS IS A BINNING METHOD.
    ;IT ALWAYS STARTS FROM INITIAL DETECTOR THAT
    ;IS READ IN FROM FILE.  ANOTHER REBIN METHOD MAY BE
    ;USEFUL SO THAT THE CURRENT STATE CAN BE REBINNED.
    ;
    ;;;

    ;;
    ;NOTE!!!!!! CURRENTLY bin REQUIRES x/y/factor TO DIVIDE EVENLY INTO
    ;           THE DIMENSIONS OF THE DATA ARRAY
    ;;;

        ;SET UP DEFAULTS IN CASE ARGUMENT IS MISSING
        ;TO PREVENT DIVIDE-BY-ZERO ERRORS
        ;
        ;NOW THAT BINNING IS ACCOMPLISHED,
        ;SET THE RIGHT VALUES TO GO TO DISPLAY
        ; NAMELY e VS eorig

    ;051205
    ;ALTER THE NEXT FEW LINES SLIGHTLY IN PROCESS OF HANDLING
    ;UNEVEN (BUT STILL POWER OF 2) BINNING.
        if (n_elements(xfactor) eq 0) then begin
            xfactor = 1
        endif
    ;    if (n_elements(xfactor) ne 0) then begin
    ;;        print,"XFACTOR PRESENT"
    ;    endif else begin
    ;        xfactor = 1
    ;    endelse
        if (n_elements(yfactor) eq 0) then begin
            yfactor = 1
        endif
    ;    if (n_elements(yfactor) ne 0) then begin
    ;;        print,"YFACTOR PRESENT"
    ;    endif else begin
    ;        yfactor = 1
    ;    endelse

        ;IF FACTOR IS PRESENT USE ONLY FACTOR
        if (n_elements(factor) ne 0) then begin
     ;       print,"FACTOR PRESENT: FACTOR TRUMPS ALL OTHER FACTORS"
            xfactor = factor & yfactor = factor
        endif

    ;112805
    ;
    ;NOW IF THE FACTOR DOES NOT CHANGE THE CURRENT BINNING OF THE DATA
    ;OBJECT, THEN DO NOTHING!!!!
    ;
    current_xfactor = self.x_dim_orig/self.x_dim
    current_yfactor = self.y_dim_orig/self.y_dim

    if xfactor eq current_xfactor and yfactor eq current_yfactor then begin
        ;do nothing
    endif else begin

        if (xfactor eq 1 and yfactor eq 1) then begin
    ;        print,'NOTE: LARGE DATA IMAGES WILL SLOW THIS PROCESS'
            rmbin = (*self.eorig)
            self.x_dim = self.x_dim_orig
            self.y_dim = self.y_dim_orig
            self.x_cen = self.x_cen_orig
            self.y_cen = self.y_cen_orig

        endif else begin
            ;REFORM 3-D MATRIX INTO 4-D FOR BINNING
    ;        help,(*self.eorig)[*,*,*]
    ;        print,self.no_of_phases
    ;        print,self.no_of_fourier_times
    ;        print,self.x_dim_orig
    ;        print,self.y_dim_orig


    ;        help,*self.eorig
    ;        print,'self.no_of_phases=',self.no_of_phases
    ;        print,'self.x_dim_orig=',self.x_dim_orig
    ;        print,'self.y_dim_orig=',self.y_dim_orig
    ;        print,'self.no_of_fourier_times=',self.no_of_fourier_times
            m = reform((*self.eorig)[*,*,*],self.x_dim_orig,self.y_dim_orig,$
                    self.no_of_phases,self.no_of_fourier_times)

            ;SET DIMENSIONS OF BINNED AREA DETECTOR
            self.x_dim = self.x_dim_orig/xfactor
            self.y_dim = self.y_dim_orig/yfactor
            self.x_cen = self.x_cen_orig/double(xfactor)
            self.y_cen = self.y_cen_orig/double(yfactor)

            ;REBIN 4-D MATRIX INTO THE SELECTED SIZE
    ;        mbin = rebin(m,self.x_dim,self.y_dim,$
    ;                self.no_of_phases,self.no_of_fourier_times)

            mbin = larrebin(m,self.x_dim,self.y_dim,$
                    self.no_of_phases,self.no_of_fourier_times)





            ;CREATE NEW MASK MATRIX BASED ON REBINNED DATA
            ;(NOTE THAT MASKS ARE ALWAYS 2D SO THE Nx2D MASK DOES NOT
            ; NEED TO BE REFORMED.)
            ;maskmbin =  reform(mbin[*,*,0,*],self.x_dim,self.y_dim,self.no_of_fourier_times)

            ;maskmbin = intarr(self.x_dim,self.y_dim,self.no_of_fourier_times)+1

            ;THE NEXT STEP IS REALLY SLOW FOR BIG MATRICES
            ;(e.g FOR factor=1)
            ;REFORM INTO 3-D MATRIX FOR FUTURE PROCESSING
            rmbin = reform(mbin,(self.x_dim)*(self.y_dim),$
                     self.no_of_phases,self.no_of_fourier_times)

        endelse


    ;021605
    ;REBIN MASKS AND ASSUME THEY CANNOT BE RECOVERED AFTER A BIN OPERATION.
    ;    print,'In ooEcho::bin ',self.x_dim,self.y_dim
        maskmbin = intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)
        maskmbinold = intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)

        fitdisplaymaskmbin = intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)
        fitdisplaymaskmbinold = intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)
    ;print,'ooecho::bin before value set'
    ;help,maskmbin

        ;063004
        ;
        ;UPDATE maskmbin WITH THE DEFAULT MASK.
        ;
        ;
        ;function ooEcho::defaultMask,bin
        ;
        ;THE IMPLEMENTATAION WILL BE A FOR LOOP:
        for m = 0,self.no_of_fourier_times-1 do begin
           maskmbin[*,m] = self->defaultMask(binfactor=factor,xfactor=xfactor,yfactor=yfactor)
           maskmbinold[*,m] = self->defaultMask(binfactor=factor,xfactor=xfactor,yfactor=yfactor)
        endfor;m
        ;
        ;   IS THIS ALL THERE IS TO IT?????? --- YES!!!

    ;print,'ooecho::bin after value set'
    ;help,maskmbin

        if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
        self.mask2d = ptr_new(maskmbin)
        if ptr_valid(self.mask2dold) gt 0 then ptr_free,self.mask2dold
        self.mask2dold = ptr_new(maskmbinold)
        ;self->setProperty,'mask2d',ptr_new(maskmbin)

        if ptr_valid(self.fitdisplaymask) gt 0 then ptr_free,self.fitdisplaymask
        self.fitdisplaymask = ptr_new(fitdisplaymaskmbin)
        if ptr_valid(self.fitdisplaymaskold) gt 0 then ptr_free,self.fitdisplaymaskold
        self.fitdisplaymaskold = ptr_new(fitdisplaymaskmbinold)



        ;CLEAR self.e POINTER TO PREVENT MEMORY LEAK AND TO REDEFINE
        ptr_free,self.e
        ptr_free,self.emask
    ;    ptr_free,self.mask2d
    ;    ptr_free,self.fitdisplaymask

        ;SET NEW VALUE OF self.emask
        self.e = ptr_new(rmbin)
        self.emask = ptr_new(rmbin)                 ;APPLY MASK TO emask HERE
                                                    ;WHEN MASKING IS READY

        ;070104
        ;REPLACE statsMask WITH defaultMask ABOVE.
        ;maskmbin = self->statsMask()
        ;
        ;
        ;
        ;NOTE:  REMOVING THE statsMask STEP HAS RESULTED
        ;       IN A TREMENDOUS PERFORMANCE IMPROVEMENT
        ;       WHEN READING IN THE DATA FILES!!! YES!!!
        ;
    ;
    ;
    ;
    ;    if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
    ;    self.mask2d = ptr_new(maskmbin)
    ;    ;self->setProperty,'mask2d',ptr_new(maskmbin)
    ;
    ;    if ptr_valid(self.fitdisplaymask) gt 0 then ptr_free,self.fitdisplaymask
    ;    self.fitdisplaymask = ptr_new(fitdisplaymaskmbin)


        sz = size(*(self.e))

        ;PRINT SIZE OF DATA MATRIX
        ;print,sz
    ;    ptr_free,self.fitparms
    ;    ptr_free,self.chisq
    ;    ptr_free,self.fitparmsOld
    ;    ptr_free,self.chisqOld


        newfixed = intarr(6,sz[1],sz[3])
        fixedtmp = (*self.fixed)[*,0,0]
        newfixed[0,*,*] = fixedtmp[0]
        newfixed[1,*,*] = fixedtmp[1]
        newfixed[2,*,*] = fixedtmp[2]
        newfixed[3,*,*] = fixedtmp[3]
        newfixed[4,*,*] = fixedtmp[4]
        newfixed[5,*,*] = fixedtmp[5]
        if ptr_valid(self.fixed) gt 0 then ptr_free,self.fixed
        self.fixed = ptr_new(newfixed)

        newparms = dblarr(12,sz[1],sz[3])+1.0
        newparms[0,*,*] = 200.0
        newparms[1,*,*] = 100.0
        newparms[2,*,*] = 200.0
        newparms[3,*,*] = 702.0
        newparms[4,*,*] = 1.0
        newparms[5,*,*] = 0.0
        newparmsOld = newparms
        newchisq = $
            dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times) + 100000000.0
        newchisqOld = newchisq

        if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        self.fitparms = ptr_new(newparms)
        if ptr_valid(self.chisq) gt 0 then ptr_free,self.chisq
        self.chisq = ptr_new(newchisq)
        if ptr_valid(self.fitparmsOld) gt 0 then ptr_free,self.fitparmsOld
        self.fitparmsOld = ptr_new(newparmsOld)
        if ptr_valid(self.chisqOld) gt 0 then ptr_free,self.chisqOld
        self.chisqOld = ptr_new(newchisqOld)

        if ptr_valid(self.Iup) gt 0 then ptr_free,self.Iup
        self.Iup = ptr_new(dblarr(sz[1],sz[3])+1.0)
        if ptr_valid(self.Idown) gt 0 then ptr_free,self.Idown
        self.Idown = ptr_new(dblarr(sz[1],sz[3])+1.0)
        if ptr_valid(self.sIup) gt 0 then ptr_free,self.sIup
        self.sIup = ptr_new(dblarr(sz[1],sz[3])+1.0)
        if ptr_valid(self.sIdown) gt 0 then ptr_free,self.sIdown
        self.sIdown = ptr_new(dblarr(sz[1],sz[3])+1.0)
        if ptr_valid(self.S) gt 0 then ptr_free,self.S
        self.S = ptr_new(dblarr(sz[1],sz[3])+1.0)
        if ptr_valid(self.sS) gt 0 then ptr_free,self.sS
        self.sS = ptr_new(dblarr(sz[1],sz[3])+1.0)
        if ptr_valid(self.QVals) gt 0 then ptr_free,self.QVals
        self.QVals = ptr_new(dblarr(sz[1],sz[3])+self.qactual);q)

        self.reduced = 0        ;INDICATE THAT THE DATA ARE NO LONGER REDUCED
        self.reducedOld = 0
        self.QValsSwitch = 0    ;INDICATE THAT QValues ARE NOT CALCULATED
        self.IupdownSwitch = 0  ;INDICATE THAT Iup,down ARE NOT CALCULATED
    ;print,*p

    endelse;new factor ne old factor
end;ooEcho::bin

function ooEcho::report_timeaverage_state,_Extra=extra
;
;NAME:
;        ooEcho::report_timeaverage_state
;
;PURPOSE:
;           Report the state of time averaging for this object
;PARAMETERS:
;           None.
;KEYWORDS:
;           None.


;help,/traceback
    ;FIRST DO THE TIME AVERAGING OVER ALL TIMES IN FULL self.eorig
    ;
    ;GET THE CURRENT self.e
    ;
    ;COMPARE AT THE CURRENT INDEX.
    ;
    ;IF THEY ARE ALL EQUAL, THEN RETURN TRUE, ELSE FALSE.
    ;
  
    if ptr_valid(self.extensions) gt 0 then begin
    
      tags = tag_names(*self.extensions)
      
  
  
      wh = where(stregex(tags,'TAVESTATE',/fold_case,/boolean) ne 0,tcount)
      if tcount ne 0 then begin
        tavestate = (*self.extensions).tavestate
      endif else begin
  
            ;GET INDICES FOR THE SPECIFIC POINT COMPARISON
            term = self->term()
            xindex = self.x_dim/2
            yindex = self.y_dim/2
            index = xindex + yindex*self.x_dim
        
        
            m_new = self->do_t_ave(1,/justCheck);/noTaveExtension)
        
            m_new = reform(m_new,self.x_dim_orig,self.y_dim_orig,$
                                 self.no_of_phases,self.no_of_fourier_times)
        ;t0 = systime(/seconds)
        ;print,systime(/seconds)-t0
            mbin = larrebin(m_new,self.x_dim,self.y_dim,$
                    self.no_of_phases,self.no_of_fourier_times)
        ;print,systime(/seconds)-t0
        
        
            mbin = reform(mbin,self.x_dim*self.y_dim,$
                               self.no_of_phases,$
                               self.no_of_fourier_times)
        
        
            tave_array = mbin[index,term,*]
            test_array = (*(self.e))[index,term,*]
        
            wh = where((tave_array eq test_array),count)
        
            tavestate = (count eq self.no_of_fourier_times)
        
            self->checkAndUpdateExtensionsPtr,tavestate=tavestate,$
                                              _Extra=extra
      endelse                                              
    endif else begin
      self->checkAndUpdateExtensionsPtr,tavestate=tavestate,$
                                            _Extra=extra
    endelse
    return,tavestate
end;report_time_average_state


function ooEcho::do_t_ave,timeaverage,_Extra=extra
;
;NAME:
;        ooEcho::do_t_ave
;
;PURPOSE:
;           Calculate a version of self.eorig with the XYZUp/Down or IUp/Down time-averaged.
;PARAMETERS:
;           Timeaverage FLAG TO DO (1) OR NOT DO (0) THEW TIME AVERAGING.
;KEYWORDS:
;           None.
;03/31/06

        m = (*self.eorig)[*,*,*]    ;[npix,nphs,nt]
        m_new = m


        ;THE NEXT LINE CAUSES AND INFINITE RECURSIVE LOOP!!!  
        ;JUST ASSUME THE SWITCH NEEDS TO BE CHANGED!!!!!!!!!
        ;if timeaverage ne self->report_timeaverage_state() then begin
              self.IupdownSwitch = 0  ;INDICATE THAT Iup,down ARE NOT CALCULATED          
        ;endif

        ;IF TIME AVERAGING SET THEN DO IT, OTHERWISE JUST RETURN *self.eorig
        if timeaverage eq 1 then begin
            term = self->term()
            msz = size(m)

            mask1d = *self.mask1d   ;[nphs,nt]
            t = lonarr(msz[1],msz[2])
            t_ave = t

            ;THIS AVERAGE SHOULD ACCOUNT FOR THE CURRENT 1d MASKING!!!!
            tcount = intarr(msz[2])
            tcount[0:term-1] = 1    ;SET THESE TO 1 SINCE THEY WILL NOT BE USED BELOW.

            for i=term,msz[2]-1 do begin
                for j=0,msz[3]-1 do begin
                    if mask1d[i,j] eq 1 then begin ;mask1d eq 1 means unmasked
                        tcount[i] = tcount[i] + 1
                        t[*,i] = t[*,i] + m[*,i,j]
                    endif
                endfor;j
            endfor;i
            ;print,'tcount=',tcount

            for i=term,msz[2]-1 do begin
                t_ave[*,i] = t[*,i]/tcount[i]   ;THE eb CALCULATIONS SHOULD CHANGE BASED ON THE
                                                ;T_AVE SWITCH (i.e. THEY SHOULD NOT SIMPLY BE SQUARE ROOTS!
                                                ;THIS IS PROBABLY THE DIFFERENCE IN GEORG'S AND MY ERROR BARS.)
            endfor;i
            ;LOOK FOR INSTANCES WHERE THERE ARE NO VALUES IN THE SUM FOR THE AVERAGE CALCULATION
            ;AND ZERO THESE OUT.
            whtzero = where(tcount eq 0,tzerocount)
            if tzerocount ne 0 then begin
                t_ave[*,whtzero] = 0
            endif


            for j=0,msz[3]-1 do begin
                for i=term,msz[2]-1 do begin
                    m_new[*,i,j] = t_ave[*,i]
                endfor;i
            endfor;j
        endif;timeaverage eq 1
        self->checkAndUpdateExtensionsPtr,tavestate=timeaverage
    
    return,m_new

end;do_t_ave


pro ooEcho::writeFitparmsToFile,filename=filename,nomasked=nomasked,_Extra=extra
;
;NAME:
;        ooEcho::writeFitparmsToFile
;
;PURPOSE:
;       Write all fit parameters to a formatted file.
;PARAMETERS:
;       none
;KEYWORDS:
;       filename    Optional filename
;       nomasked    Flag to omit masked points
;04/03/06

;print,'nomasked=',nomasked
if n_elements(nomasked) eq 0 then nomasked = 0
if n_elements(filename) eq 0 then begin
    ;print,'TEST'
    fn = dialog_pickfile(path = self.workdir,title='Select Fit Parameters File:', $
                         /overwrite_prompt,/write)
    if fn eq '' then begin
        void = dialog_message('No output file selected.')
        return
    endif
endif else begin
    fn = filename
endelse

openw,lun,fn,/get_lun

fitparms = *self.fitparms
times = (10.0^9)*(*self.fourierTime)

;CHANGE FROM OMEGA TO PERIOD.
omega  = fitparms[4,*,*]
somega = fitparms[10,*,*]
fitparms[4,*,*]  = 360.0/omega
fitparms[10,*,*] = (somega/omega)*fitparms[4,*,*]

mask = *self.mask2d
theQVals = (*(self->getProperty(tag='QVals')))[*,0]
form1 =  '( 2(A5), 18(A10,2X))'
form2 = '(2(I4,","), 17(g11.5,","), g11.5)'

printf,lun,self.filename
printf,lun,self.comment
tit = ['xpos','ypos','time', 'Q','Iup','SIup','Idown','SIdown', 'Av' , 'dAv' , 'A' , 'dA' , 'PH' ,'dPH' , 'W' ,'dW' , 'T' ,'dT' , 'PHoffset' , 'dPHoffset']
printf,lun,tit,format=form1
for k=0,self.no_of_fourier_times-1 do begin
    for i=0,self.x_dim-1 do begin
        for j=0,self.y_dim-1 do begin
            if nomasked eq 1 then begin
              if mask[self.x_dim*j+i,k] gt 0 then begin
                printf,lun,i,j,times[k],theQVals[self.x_dim*j+i],$
                  (*Self.iup)[self.x_dim*j+i,k],(*Self.siup)[self.x_dim*j+i,k],(*Self.idown)[self.x_dim*j+i,k],(*Self.sidown)[self.x_dim*j+i,k], $
                  fitparms[0,self.x_dim*j+i,k],fitparms[6,self.x_dim*j+i,k],$
                  fitparms[1,self.x_dim*j+i,k],fitparms[7,self.x_dim*j+i,k],$
                  fitparms[2,self.x_dim*j+i,k],fitparms[8,self.x_dim*j+i,k],$
                  fitparms[3,self.x_dim*j+i,k],fitparms[9,self.x_dim*j+i,k],$
                  fitparms[4,self.x_dim*j+i,k],fitparms[10,self.x_dim*j+i,k],$
                  fitparms[5,self.x_dim*j+i,k],fitparms[11,self.x_dim*j+i,k],$
                  format=form2
              endif
            endif else begin
              printf,lun,i,j,times[k],theQVals[self.x_dim*j+i],$
                  (*Self.iup)[self.x_dim*j+i,k],(*Self.siup)[self.x_dim*j+i,k],(*Self.idown)[self.x_dim*j+i,k],(*Self.sidown)[self.x_dim*j+i,k], $
                  fitparms[0,self.x_dim*j+i,k],fitparms[6,self.x_dim*j+i,k],$
                  fitparms[1,self.x_dim*j+i,k],fitparms[7,self.x_dim*j+i,k],$
                  fitparms[2,self.x_dim*j+i,k],fitparms[8,self.x_dim*j+i,k],$
                  fitparms[3,self.x_dim*j+i,k],fitparms[9,self.x_dim*j+i,k],$
                  fitparms[4,self.x_dim*j+i,k],fitparms[10,self.x_dim*j+i,k],$
                  fitparms[5,self.x_dim*j+i,k],fitparms[11,self.x_dim*j+i,k],$
                  format=form2
            endelse
        endfor;j
    endfor;i
endfor;k
free_lun,lun
end;writeFitParmsToFile


pro Ooecho::writeFitparmsToString,sBuffer,nomasked=nomasked,_Extra=extra
;
;NAME:
;        ooEcho::writeFitparmsToString
;
;PURPOSE:
;       Write all fit parameters to a formatted string buffer.
;PARAMETERS:
;       none
;KEYWORDS:
;       sBuffer    string array to write to
;       nomasked    Flag to omit masked points
;04/03/06

;print,'nomasked=',nomasked
if N_elements(nomasked) eq 0 then nomasked = 0

fitparms = *self.fitparms
times = (10.0^9)*(*self.fouriertime)

;CHANGE FROM OMEGA TO PERIOD.
omega  = fitparms[4,*,*]
somega = fitparms[10,*,*]
fitparms[4,*,*]  = 360.0/omega
fitparms[10,*,*] = (somega/omega)*fitparms[4,*,*]

mask = *self.mask2d

theQVals = (*(self->Getproperty(tag='QVals')))[*,0]
form1 = '( 2(A5), 3(A7), 17(A9,2X))'                    ; '( 2(A5), 18(A9,2X))'
form2 = '(2(I4,","),3(F6.3,","),16(G10.4,","),G10.4)'   ;'(2(I4,","), 17(g10.4,","), g10.4)'

sBuffer = 'Fitted Parameters for: '+self.filename
;    printf,lun,'xpos,ypos,time, Q, Av � dAv , A � dA , PH � dPH , W � dW , T � dT , PHoffset � dPHoffset'
tit = ['xpos','ypos','time', 'Q','ChiSq','Iup','SIup','Idown','SIdown', 'Av' , 'dAv' , 'A' , 'dA', 'Pz' , 'PH' ,'dPH' , 'W' ,'dW' , 'T' ,'dT' , 'PHoffset' , 'dPHoffset']
sBuffer = [sBuffer,string(tit,format=form1)]
for k=0,self.no_of_fourier_times-1 do begin
  for i=0,self.x_dim-1 do begin
    for j=0,self.y_dim-1 do begin
      if nomasked eq 1 then begin
        if mask[self.x_dim*j+i,k] gt 0 then begin
          newline = string(i,j,times[k],theQVals[self.x_dim*j+i],(*self.chisq)[self.x_dim*j+i,k],$
            (*Self.iup)[self.x_dim*j+i,k],(*Self.siup)[self.x_dim*j+i,k],(*Self.idown)[self.x_dim*j+i,k],(*Self.sidown)[self.x_dim*j+i,k], $
            fitparms[0,self.x_dim*j+i,k],fitparms[6,self.x_dim*j+i,k],$
            fitparms[1,self.x_dim*j+i,k],fitparms[7,self.x_dim*j+i,k],$
            2.0*fitparms[1,self.x_dim*j+i,k]/((*Self.idown)[self.x_dim*j+i,k] - (*Self.iup)[self.x_dim*j+i,k]), $
            fitparms[2,self.x_dim*j+i,k],fitparms[8,self.x_dim*j+i,k],$
            fitparms[3,self.x_dim*j+i,k],fitparms[9,self.x_dim*j+i,k],$
            fitparms[4,self.x_dim*j+i,k],fitparms[10,self.x_dim*j+i,k],$
            fitparms[5,self.x_dim*j+i,k],fitparms[11,self.x_dim*j+i,k],$
            format=form2)
          sBuffer = [sBuffer,newline]
        endif
      endif else begin
        newline = string(i,j,times[k],theQVals[self.x_dim*j+i],(*self.chisq)[self.x_dim*j+i,k],$
          (*Self.iup)[self.x_dim*j+i,k],(*Self.siup)[self.x_dim*j+i,k],(*Self.idown)[self.x_dim*j+i,k],(*Self.sidown)[self.x_dim*j+i,k], $
          fitparms[0,self.x_dim*j+i,k],fitparms[6,self.x_dim*j+i,k],$
          fitparms[1,self.x_dim*j+i,k],fitparms[7,self.x_dim*j+i,k],$
          2.0*fitparms[1,self.x_dim*j+i,k]/((*Self.idown)[self.x_dim*j+i,k] - (*Self.iup)[self.x_dim*j+i,k]), $
          fitparms[2,self.x_dim*j+i,k],fitparms[8,self.x_dim*j+i,k],$
          fitparms[3,self.x_dim*j+i,k],fitparms[9,self.x_dim*j+i,k],$
          fitparms[4,self.x_dim*j+i,k],fitparms[10,self.x_dim*j+i,k],$
          fitparms[5,self.x_dim*j+i,k],fitparms[11,self.x_dim*j+i,k],$
          format=form2)
        sBuffer = [sBuffer,newline]
      endelse
    endfor;j
  endfor;i
endfor;k

end;writeFitParmsToString


function ooEcho::statsMask,_Extra=extra
;
;NAME:
;        ooEcho::statsMask
;
;PURPOSE:
;       Mask all pixels with poor statistics at all Fourier times.
;       This simply looks for pixels with zeroes in the echo.
;PARAMETERS:
;       none
;KEYWORDS:
;       none
;RETURN VALUE:
;       theMask The mask for all of the data.
    ;self->addTreatment,'ooEcho::statsMask'


    ;CREATE AND RETURN AN ARRAY OF 2D MASKS BASED ON THE
    ;DATA STATISTICS, NAMELY IF THERE ARE ZERO COUNT POINTS
    ;IN AN ECHO, 0 THE MASK THERE.

    theMask = intarr(self.x_dim,self.y_dim,self.no_of_fourier_times) + 1
;    print,'ooEcho::statsMask'
    ;help,theMask
    ;k = 0
    for k=0,self.no_of_fourier_times-1 do begin
        for j = 0,self.y_dim-1 do begin
            for i = 0,self.x_dim-1 do begin
                ;060404
                ;WHY DOESN'T THIS CATCH ALL OF THE ZEROS?????
                if (min(self->chirp(i,j,k)) le 0) then begin
                    theMask[i,j,k] = 0
                endif ;else begin
;                    theMask[i,j,k] = 1
;                endelse
            endfor;i
        endfor;j
    endfor;k

    ;DOING THE NEXT STEP IS NECESSARY DUE TO THE LONG TIMES
    ;REQUIRED TO LOOP THROUGH THE DATA  --- PERHAPS THIS WILL
    ;HAVE TO BE MODIFIED IF THERE IS A PROBLEM WITH TRYING
    ;TO FIT IMAGES WITH ALL ZEROS AT k>0.  WORRY ABOUT THAT
    ;LATER. . .
;    print,'NOTE: THIS MASK STEP MAY CAUSE PROBLEMS IF THERE ARE ALL ZERO IMAGES'

    ;060404
    ;REMOVE THIS STEP SINCE LOOP OVER k IS DONE ABOVE.
;    for k=1,self.no_of_fourier_times-1 do begin
;        theMask[*,*,k] = theMask[*,*,0]
;    endfor;k


    ;REFORM MASK INTO 1-D DETECTOR FORMAT
    theMask = reform(theMask,self.x_dim*self.y_dim,self.no_of_fourier_times)

    return,theMask
end;statsMask
function ooEcho::defaultMask,binFactor=binFactor,xfactor=xfactor,yfactor=yfactor,_Extra=extra
;
;NAME:
;        ooEcho::defaultMask
;
;PURPOSE:
;           Return the default mask for the selected binning.
;PARAMETERS:
;               binFactor   The binning factor.  Must be a multiple of 2.
;KEYWORDS:
;               xfactor     Optional keywords for asymmetric images.
;               yfactor
;RETURN VALUE:
;               The mask.


    ;self->addTreatment,'ooEcho::defaultMask'

    ;
    ;063004
    ;
    ;PRODUCE DEFAULT MASKS FOR EACH OF THE 32x32 BASED DETECTORS.

    ;RETURNS A 1D MASK REPRESENTING THE 2D IMAGE REFORMED INTO A
    ;1D ARRAY.

    ;IN CASE binFactor IS PASSED TO THE FUNCTION AS A 1 ELEMENT ARRAY.
    if n_elements(binFactor) eq 0 then begin
        binFactor = 1
        asymswitch = 1
    endif else asymswitch = 0

    bf = binFactor[0]
    if n_elements(xfactor) eq 0 then xfactor = -1
    if n_elements(yfactor) eq 0 then yfactor = -1


    fullMask = $
      [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]


    case bf of
    1: begin
        theMask = fullMask;$
;      [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
;       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
;       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,$
;       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
;       0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
;       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]

    end;1
    2: begin
        theMask =  [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
                    0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,$
                    0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,$
                    0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,$
                    0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,$
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]

    end;2
    4: begin    ;101504 - CHANGING MASK SLIGHTLY
                ;NOW IT WILL BE SYMMETRIC
        theMask = [0,0,0,0,0,0,0,0,$
                   0,1,1,1,1,1,1,0,$
                   1,1,1,1,1,1,1,1,$
                   1,1,1,1,1,1,1,1,$
                   1,1,1,1,1,1,1,1,$
                   1,1,1,1,1,1,1,1,$
                   0,1,1,1,1,1,1,0,$
                   0,0,0,0,0,0,0,0]
    end;4
    8: begin
        theMask = [1,1,1,1,$
                   1,1,1,1,$
                   1,1,1,1,$
                   1,1,1,1]
    end;8
    16: begin
        theMask = [1,1,$
                   1,1]
    end;16
    else: return,0
    endcase

    if (xfactor ne -1) and (yfactor ne -1) and (asymswitch eq 1) then begin
            theMask = reform(rebin(reform(fullMask,32,32),32/xfactor,32/yfactor),$
                                                            (32/xfactor)*(32/yfactor))
    endif

    return,theMask
end;defaultMask

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::maskify,mask=mask,_Extra=extra
;
;NAME:
;        ooEcho::maskify
;
;PURPOSE:
;       Set the emask array.
;PARAMETERS:
;       none
;KEYWORDS:
;       mask    The input mask.
    ;self->addTreatment,'ooEcho::maskify'

;;
;MASK DATA SET BY DOING ELEMENT-BY-ELEMENT MULTIPLICATION
;OF THE MASK ARRAY AND THE AREA DETECTOR ELEMENTS
;
;;;

    ;m = *(self->getProperty(tag='e'))
    ;
    ;CONVERT TO 4D MATRIX --- CREATE A FUNCTION FOR THIS!?!
    ;
    ;THIS MAY GET CONFUSING IF IT'S NOT MORE NOTICEABLE
    ;
    ;
    m = reform((*self.e)[*,*,*],self.x_dim,self.y_dim,$
                self.no_of_phases,self.no_of_fourier_times)

    mm = m
    for i=0,no_of_phases-1 do begin
        mm = m[*,*,i,*]*self.mask[*,*,*]
    endfor;i
    mm = reform(mm,s[1]*s[2],s[3],s[4])

    if ptr_valid(emask) gt 0 then ptr_free,self.emask
    self->setProperty,'emask',ptr_new(m,/no_copy)

;
;    s = size(m)
;    ;print,s
;
;    ;DESTROY POINTER HERE AND RENEW IT AT THE END.
;    ;ptr_free,self->getProperty(tag='e')
;
;    ;FOR TESTING
;    ;PREPARE A 'ONE' MASK
;    if (n_elements(mask) eq 0) then begin
;        mask = m[*,*,self.currentPhaseIndex,self.currentFourierTimeIndex]
;        smask = size(mask)
;    endif else begin
;
;        smask = size(mask)
;
;        ;CHECK DIMENSIONS AND PRINT WARNING IF NECESSARY
;        if (smask[0] ne 2) then print,'MASK DIMENSIONS = '+string(smask[0])
;        if (smask[1] ne s[1]) then print,'X-DIMENSIONS DIFFERENT IN maskify'
;        if (smask[2] ne s[2]) then print,'Y-DIMENSIONS DIFFERENT IN maskify'
;
;    endelse
;
;    ;TEST MASK
;    for i=0,smask[1]-1 do begin
;        for j=0,smask[2]-1 do begin
;            if (i eq j) then begin
;                mask[i,j] = 1
;            endif else begin
;                mask[i,j] = 0
;            endelse
;        endfor
;    endfor
;
;    for i=0,s[3]-1 do begin
;        for j=0,s[4]-1 do begin
;            ;print,i,j
;            ;print,m[*,*,i,j]
;            m[*,*,i,j] = m[*,*,i,j]*mask
;        endfor
;    endfor
;
;    ;CONVERT MASKED DATA TO 3-D MATRIX
;    m = reform(m,s[1]*s[2],s[3],s[4])
;
;    self->setProperty,'emask',ptr_new(m,/no_copy)

end;ooEcho::maskify
;;;;;;;;;;;;;;;;;;;;;

;;
;FITTING METHODS
;
;chirpFun
;startParms
;fitChirp
;
;
;;;
;;;;;;;;;;;;;;;;;;;;;
;function chirpFun,X,P
;    ;NEED THIS DEFINITION TO SATISFY EXECUTE STATEMENT IN mpfitfun
;    return,P[0] - $
;            P[1]*exp(-1.0*((X-P[2]-P[5])/(2.0*P[3]))^2)*$
;            cos(P[4]*(!PI/180.0)*(X - P[2]-P[5]))
;end
function ooEcho::chirpFun,P,tauInd,_Extra=extra
;
;NAME:
;        ooEcho::chirpFun
;
;PURPOSE:
;           Return the echo calculated at the phase values.
;PARAMETERS:
;           P
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;           The calculated echo.
    ;self->addTreatment,'ooEcho::chirpFun'


    X = self->chirpPhases(tauInd)
;    return,P[0] - $
;            P[1]*exp(-1.0*((X-P[2]-P[5])/(2.0*P[3]))^2)*$
;            cos(P[4]*(!PI/180.0)*(X - P[2]-P[5]))
    return,P[0] - $
            P[1]*exp(-1.0*((X-P[2]-P[5])/(sqrt(2.0)*P[3]))^2)*$
            cos(P[4]*(!PI/180.0)*(X - P[2]-P[5]))

end;chirpFun
function ooEcho::startParms,i,j,k,fixed=fixed,$
                                startparms=startparms,$
                                sigma=sigma,$
                                hydrogenated=hydrogenated,$
                                noborrow=noborrow,$
                                tavestate=tavestate,$
                                _Extra=extra
;
;NAME:
;        ooEcho::startParms
;
;PURPOSE:
;        Get approximate starting parameters for fitting.
;PARAMETERS:
;       i
;       j
;       k
;KEYWORDS:
;       fixed
;       startparms
;       sigma
;       hydrogenated
;RETURN VALUE:
;       the starting parameters.

    ;self->addTreatment,'ooEcho::startparms'

    ;PRODUCE A SET OF PARAMETERS TO BEGIN FITTING
    ;FOR EACH INDIVIDUAL ECHO
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(noborrow) eq 0 then noborrow = 0
    if n_elements(hydrogenated) eq 0 then hydrogenated = 0

    ;GET SOME INFORMATION FROM THE DATA

    x = self->chirpPhases(k)
    y = self->chirp(i,j,k)
    sy= sqrt(y)


;083105
;CHECKING FOR HYDROGENATED SAMPLES.
;PLACING THIS HERE MAY ELIMINATE THE NEED FOR
;Iup,down CALCULATIONS IN THE INDIVIDUAL
;chirpFit METHODS.
        dum_up = self->chirpIup(i,j,k,tavestate=tavestate);xind,yind,tauind)
        dum_down = self->chirpIdown(i,j,k,tavestate=tavestate);xind,yind,tauind)
        if dum_up gt dum_down then begin
            hydrogenated = 1
        endif else hydrogenated = 0



    ;CALCULATE AMPLITUDE STARTING POINT
    if (n_elements(fixed) gt 0) then begin
        if(fixed[1] eq 1 and n_elements(startparms) gt 0) then begin
            ampStart = startparms[1]
        endif else begin
            ampstart = (*self.fitparms)[1,self.x_dim*j+i,k]
        endelse
    endif else begin
        ampStart = self->chirpAmplitude(i,j,k,hydrogenated=hydrogenated)
    endelse


    if hydrogenated eq 1 then begin
        if ampstart gt 0.0 then ampstart = -1.0*ampstart
    endif

    ;CALCULATE OFFSET STARTING POINT
    if (n_elements(fixed) gt 0) then begin
        if(fixed[0] eq 1 and n_elements(startparms) gt 0) then begin
            offsetStart = startparms[0]
        endif else begin
            offsetStart = (*self.fitparms)[0,self.x_dim*j+i,k]
        endelse
    endif else begin
        offsetStart = self->chirpOffset(i,j,k,hydrogenated=hydrogenated)
    endelse


    if noborrow eq 0 then begin
        ;SELECT A POSSIBILITY FOR THE PHASE
        if (n_elements(fixed) gt 0) then begin
            if(fixed[2] eq 1 and n_elements(startparms) gt 0) then begin
                phaseStart = startparms[2]
            endif else begin
                phaseStart = (*self.fitparms)[2,self.x_dim*j+i,k]
            endelse
        endif else begin
            if hydrogenated eq 1 then begin
                dum = max(y,phaseStartIndex)
            endif else begin
                dum = min(y,phaseStartIndex)
            endelse
            phaseStart = x[phaseStartIndex]
            ;print,'phaseStart = ',phaseStart
        endelse
    endif;noborrow

    if (n_elements(fixed) gt 0) then begin
        if(fixed[4] eq 1 and n_elements(startparms) gt 0) then begin
            omegaStart = startparms[4]
        endif else begin
            omegaStart = (*self.fitparms)[4,self.x_dim*j+i,k]
        endelse
    endif else begin
        omegaStart = 360.0/360.0
    endelse


    if n_elements(sigma) eq 0 then begin
        if (n_elements(fixed) gt 0) then begin
            if(fixed[4] eq 1 and n_elements(startparms) gt 0) then begin
                sigmaStart = startparms[3]
            endif else begin
                sigmaStart = (*self.fitparms)[3,self.x_dim*j+i,k]
            endelse
        endif else begin
            sigmaStart = 702.0
        endelse
    endif else begin
        sigmaStart = sigma
    endelse

;    if i*j*k eq 1 then print,'sigmaStart = ',sigmaStart

    if (n_elements(fixed) gt 0) then begin
        if(fixed[5] eq 1 and n_elements(startparms) gt 0) then begin
            ;IF startparms ARE PASSED AND PARM IS FIXED USE THAT ONE
            dphaseStart = startparms[5]
        endif else begin
            ;IF startparms ARE NOT PASSED AND NOT FIXED,
            ;USE CURRENT VALUE IN ARRAY
            dphaseStart = (*self.fitparms)[5,self.x_dim*j+i,k]
        endelse
    endif else begin
        ;
        dphaseStart = 0.0
    endelse

    parms = [offsetStart, ampStart, phaseStart, sigmaStart, omegaStart,dphaseStart]
    (*self.fitparms)[0:5,self.x_dim*j+i,k] = parms

    return,parms
end;startParms
function ooEcho::dBx,tauind,_Extra=extra
;
;NAME:
;        ooEcho::dBx
;
;PURPOSE:
;       Return the Bz magnetic field changes for plotting.
;PARAMETERS:
;       tauind  The Fourier time.
;KEYWORDS:
;       none
;RETURN VALUE:
;       The bz field changes.
    ;;self->addTreatment,'ooEcho::dBx'


    ;RETURN SAMPLE MAGNETIC FIELD IN X-DIRECTION
    meterTags = tag_names((*(self->getProperty(tag='meters')))[0,0])

;121905
;    meters = (*(self->getProperty(tag='meters')))[0:self.point_to_down-1,tauind]
    meters = (*(self->getProperty(tag='meters')))[0:self->term()-1,tauind]
    metersx = meters.(where(meterTags eq 'BSPIX'))
    ;metersxshift = [metersx[0],metersx[0:n_elements(metersx)-2]]
    return,metersx-metersx[0]
end;dBx
function ooEcho::dBy,tauind,_Extra=extra
;
;NAME:
;        ooEcho::dBy
;
;PURPOSE:
;       Return the Bz magnetic field changes for plotting.
;PARAMETERS:
;       tauind  The Fourier time.
;KEYWORDS:
;       none
;RETURN VALUE:
;       The bz field changes.
    ;;self->addTreatment,'ooEcho::dBy'


    ;RETURN SAMPLE MAGNETIC FIELD IN Y-DIRECTION
    meterTags = tag_names((*(self->getProperty(tag='meters')))[0,0])
    ;print,meterTags
;121905
;    meters = (*(self->getProperty(tag='meters')))[0:self.point_to_down-1,tauind]
    meters = (*(self->getProperty(tag='meters')))[0:self->term()-1,tauind]

    ;032505
    ;CHANGE THE NEXT LINE TO USE A FIELD THAT SEEMS TO AGREE WITH THE IGOR
    ;PLOT OF THE FIELD.
    metersy = meters.(where(meterTags eq 'BSPI22Y'));BSPIY'))
    ;print,meters.(4)-(meters.(4))[0]
    ;metersyshift = [metersy[0],metersy[0:n_elements(metersy)-2]]
    return,metersy-metersy[0]
end;dBy
function ooEcho::dBz,tauind,_Extra=extra
;
;NAME:
;        ooEcho::dBz
;
;PURPOSE:
;       Return the Bz magnetic field changes for plotting.
;PARAMETERS:
;       tauind  The Fourier time.
;KEYWORDS:
;       none
;RETURN VALUE:
;       The bz field changes.
    ;;self->addTreatment,'ooEcho::dBz'


    ;RETURN SAMPLE MAGNETIC FIELD IN Z-DIRECTION
    meterTags = tag_names((*(self->getProperty(tag='meters')))[0,0])
;121905
;    meters = (*(self->getProperty(tag='meters')))[0:self.point_to_down-1,tauind]
    meters = (*(self->getProperty(tag='meters')))[0:self->term()-1,tauind]

    metersz = meters.(where(meterTags eq 'BSPIZ'))
    ;meterszshift = [metersz[0],metersz[0:n_elements(metersz)-2]]
    return,metersz-metersz[0]
end;dBz
function ooEcho::dBxAll,tauind,_Extra=extra
;
;NAME:
;        ooEcho::dBxAll
;
;PURPOSE:
;       Return the Bz magnetic field changes for plotting.
;PARAMETERS:
;       tauind  The Fourier time.
;KEYWORDS:
;       none
;RETURN VALUE:
;       The bz field changes.
    ;;self->addTreatment,'ooEcho::dBxAll'


    ;RETURN SAMPLE MAGNETIC FIELD IN X-DIRECTION
    meterTags = tag_names((*(self->getProperty(tag='meters')))[0,0])
    meters = (*(self->getProperty(tag='meters')))[*,tauind];[0:self.point_to_down-1,tauind]
    metersx = meters.(where(meterTags eq 'BSPIX'))
    ;metersxshift = [metersx[0],metersx[0:n_elements(metersx)-2]]
    return,metersx-metersx[0]
end;dBxAll
function ooEcho::dByAll,tauind,_Extra=extra
;
;NAME:
;        ooEcho::dByAll
;
;PURPOSE:
;       Return the By magnetic field changes for plotting.
;PARAMETERS:
;       tauind  The Fourier time.
;KEYWORDS:
;       none
;RETURN VALUE:
;       The by field changes.
    ;;self->addTreatment,'ooEcho::dByAll'


    ;RETURN SAMPLE MAGNETIC FIELD IN Y-DIRECTION
    meterTags = tag_names((*(self->getProperty(tag='meters')))[0,0])
    ;print,meterTags
    meters = (*(self->getProperty(tag='meters')))[*,tauind];[0:self.point_to_down-1,tauind]

    ;032505
    ;CHANGE THE NEXT LINE TO USE A FIELD THAT SEEMS TO AGREE WITH THE IGOR
    ;PLOT OF THE FIELD.
    metersy = meters.(where(meterTags eq 'BSPI22Y'));BSPIY'))
    ;print,meters.(4)-(meters.(4))[0]
    ;metersyshift = [metersy[0],metersy[0:n_elements(metersy)-2]]
    return,metersy-metersy[0]
end;dByAll
function ooEcho::dBzAll,tauind,_Extra=extra
;
;NAME:
;        ooEcho::dBzAll
;
;PURPOSE:
;       Return the Bz magnetic field changes for plotting.
;PARAMETERS:
;       tauind  The Fourier time.
;KEYWORDS:
;       none
;RETURN VALUE:
;       The bz field changes.
    ;;self->addTreatment,'ooEcho::dBzAll'


    ;RETURN SAMPLE MAGNETIC FIELD IN Z-DIRECTION
    meterTags = tag_names((*(self->getProperty(tag='meters')))[0,0])
    ;print,meterTags
    meters = (*(self->getProperty(tag='meters')))[*,tauind];[0:self.point_to_down-1,tauind]
    metersz = meters.(where(meterTags eq 'BSPIZ'));'BSPIZ'))
    ;meterszshift = [metersz[0],metersz[0:n_elements(metersz)-2]]
    return,metersz-metersz[0]
end;dBzAll
function ooEcho::IvPhasevTau,xind,yind,_Extra=extra
;
;NAME:
;        ooEcho::IvPhasevTau
;
;PURPOSE:
;           return a 2d array of Intensity(phase,tau) from the e matrix.  Useful for contourPlot.
;PARAMETERS:
;           xind, yind are the pixel indices
;KEYWORDS:
;           none
;RETURN VALUE:
;           the Intensity array

    ;;self->addTreatment,'ooEcho::IvPhasevTau'


    ;help,*self.e
    ;print,self.x_dim
    ;print,self.y_dim

    if xind ge self.x_dim then begin
        void = dialog_message('ooecho::IvPhasevTau xind is too big, setting to '+string(self.x_dim-1) )
    endif
    if yind ge self.y_dim then begin
        void = dialog_message('ooecho::IvPhasevTau yind is too big, setting to '+string(self.y_dim-1) )
    endif


    m=(*self.e)[xind+yind*self.x_dim,*,*]
    sz=size(m)
    ;print,sz

    m=reform(m,sz[2],sz[3])

;121905
;    m=m[0:min([self.point_to_up,self.point_to_down])-1,*]
    m=m[0:self->term()-1,*]


    return,m
end;
function ooEcho::fitphasevTau,xind,yind,_Extra=extra
;
;NAME:
;        ooEcho::fitphasevTau
;
;PURPOSE:
;       Return the fit phase v. Tau for plotting.
;PARAMETERS:
;       xind
;       yind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The 1-d array of fit phase v Fourier time.
    ;;self->addTreatment,'ooEcho::fitphasevTau'

    f = (*self.fitparms)[2,xind+yind*self.x_dim,*]
    return,reform(f,n_elements(f))
end;fitphasevTau
function ooEcho::fitAmpvTau,xind,yind,_Extra=extra
;
;NAME:
;        ooEcho::fitAmpvTau
;
;PURPOSE:
;       Return the fit amp v tau for plotting.
;PARAMETERS:
;       xind
;       yind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The 1-d array of fit Amplitude v Fourier time.
    ;;self->addTreatment,'ooEcho::fitAmpvTau'


    f = (*self.fitparms)[1,xind+yind*self.x_dim,*]
    return,reform(f,n_elements(f))
end;fitphasevTau
function ooEcho::signalvTau,xind,yind,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::signalvTau
;
;PURPOSE:
;       Return the signal v tau for plotting.
;PARAMETERS:
;       xind
;       yind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The 1-d array of signal v Fourier time.
    ;;self->addTreatment,'ooEcho::signalvTau'

if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    amp = (*self.fitparms)[1,xind+yind*self.x_dim,*]
    samp = (*self.fitparms)[7,xind+yind*self.x_dim,*]

    nt = self->getproperty(tag='no_of_fourier_times')
t0 = systime(1,/seconds)
;print,'t_test=',systime(1,/seconds)-t0

    for k=0,nt-1 do begin
                dum = self->chirpIup(xind,yind,k,tavestate=tavestate)
                dum = self->chirpIdown(xind,yind,k,tavestate=tavestate)
    endfor;k
;print,'t_test2=',systime(1,/seconds)-t0


    Idown = (*self.Idown)[xind+yind*self.x_dim,*]
    sIdown = (*self.sIdown)[xind+yind*self.x_dim,*]
    Iup = (*self.Iup)[xind+yind*self.x_dim,*]
    sIup = (*self.sIup)[xind+yind*self.x_dim,*]




    f = 2.0*amp/(Idown-Iup)
    return,reform(f,n_elements(f))
end;fitphasevTau
function ooEcho::signalvTauOneTime,xind,yind,tauind,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::signalvTauOneTime
;
;PURPOSE:
;       Return the signal at one tau.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       Signal at Fourier time.


    amp = (*self.fitparms)[1,xind+yind*self.x_dim,tauind]
    samp = (*self.fitparms)[7,xind+yind*self.x_dim,tauind]

    nt = self->getproperty(tag='no_of_fourier_times')

;print,'ooEcho::signalvtauonetime'

t0 = systime(1,/seconds)
;print,'t_test onetime=',systime(1,/seconds)-t0
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()

                dum = self->chirpIup(xind,yind,tauind,tavestate=tavestate)
                dum = self->chirpIdown(xind,yind,tauind,tavestate=tavestate)
;print,'t_test2 onetime=',systime(1,/seconds)-t0

    Idown = (*self.Idown)[xind+yind*self.x_dim,tauind]
    sIdown = (*self.sIdown)[xind+yind*self.x_dim,tauind]
    Iup = (*self.Iup)[xind+yind*self.x_dim,tauind]
    sIup = (*self.sIup)[xind+yind*self.x_dim,tauind]

    f = 2.0*amp/(Idown-Iup)
    return,f
end;SignalvTauOneTime

function ooEcho::phaseArray,_Extra=extra
;
;NAME:
;        ooEcho::phaseArray
;
;PURPOSE:
;       Return the phase fit parameters.  Used for the phase import for fitting sample and cell data.
;PARAMETERS:
;       none
;KEYWORDS:
;       none
;RETURN VALUE:
;       The array of fit phases.
    ;;self->addTreatment,'ooEcho::phaseArray'


    return,(*self.fitparms)[2,*,*]
end;fitphasevTau
function ooEcho::matches,ooEchoObj,_Extra=extra
;
;NAME:
;        ooEcho::matches
;
;PURPOSE:
;       To check to see if an object matches self for the purposes of
;       phase set substitution in fitting.
;PARAMETERS:
;       ooEchoObj   The object to test with self.
;KEYWORDS:
;       none
;RETURN VALUE:
;       1 for match
;       0 for no match


    ;self->addTreatment,'ooEcho::matches'

    ;THIS FUNCTION IS USED TO DETERMINE WHETHER ooEchoObj
    ;IS COMPATIBLE WITH self FOR THE PURPOSE OF SUBSTITUTION
    ;OF THE PHASE SET FOR FITTING.


    ;060404
    ;UPDATE THIS IF STATEMENT TO REFLECT THE NEW CAPABILITY
    ;OF PHASE IMPORTATION.

    if ((self.q eq ooEchoObj->getProperty(tag='q')) $
        and (self.x_dim eq ooEchoObj->getProperty(tag='x_dim')) $
            and (self.y_dim eq ooEchoObj->getProperty(tag='y_dim')) $
                $;and (self.no_of_fourier_times eq $
                $;    ooEchoObj->getProperty(tag='no_of_fourier_times')) $
                $;    and (self.no_of_phases eq $
                )$;        ooEchoObj->getProperty(tag='no_of_phases'))) $
                            then begin
                                return,1    ;THIS IS A POSSIBLE MATCH
    endif else begin
        return,0    ;THIS OBJECT DOES NOT MATCH
    endelse
end;matches

pro ooecho::contourEcho,xind,yind,tauind,winid=winid,title=title,_Extra=_Extra
;
;NAME:
;        ooecho::contourecho
;
;PURPOSE:
;       Create a contour plot of the entire echo at all times with the
;       phase fit values shown.
;PARAMETERS:
;       xind    The pixel indices.
;       yind
;       tauind
;KEYWORDS:
;       winid   The optional window to draw to.
;       title   Title of the plot
    ;;self->addTreatment,'ooEcho::contourEcho'



    if n_elements(xind) eq 0 then xind = 8
    if n_elements(yind) eq 0 then yind = 8
device,get_decomposed = dc
if dc eq 0 then tvlct,r,g,b,/get
device,decomposed = 0
    loadct,3;11
    tvlct,rnow,gnow,bnow,/get

        mo = self->IvPhasevTau(xind,yind)
        phvt = self->fitphasevtau(xind,yind)
        t = *(self->getProperty(tag='fourierTime'))
        ph = *(self->getProperty(tag='phase'))

        sz = size(mo)

        m = bytscl(mo,top=253)+1B
        rnew = rnow & gnew = gnow & bnew = bnow
        rnew[0] = 255L & rnew[255] = 0L
        gnew[0] = 255L & gnew[255] = 0L
        bnew[0] = 255L & bnew[255] = 0L


;042505
;ELIMINATE THE NEXT LINE SINCE IT APPEARS THAT CONTOUR CANNOT EASILY BE TRICKED
;INTO DRAWING BLACK AXES ON A WHITE BACKGROUND WITHOUT SETTING THE LOWEST
;DATA LEVEL TO WHITE.
;tvlct,rnew,gnew,bnew

        ph = ph[0:sz[1]-1]
        x=ph#(dblarr(sz[2])+1.d)
        y=(dblarr(sz[1])+1.d)#t

        if n_elements(winid) eq 1 then begin
            ;window,0
            wset,winid

            impos = [0.24,0.20,0.9,0.9]
            cbpos = [0.20,0.13,0.9,0.16]

            contour,m,x,((10.0d)^(9.0d))*y,/fill,xtitle='phase',ytitle='t (ns)',$
                    xrange=[min(phvt),max(phvt)],$;background = 255L, color = 0L,$
                    max_value = 255, min_value = 0,$
                    position = impos,$
                    title=title,_Extra=_Extra;,/ylog

            colorbar,range=[min(mo),max(mo)],$;bottom=bottomcolor,$
                     $;background = 255L, color = 0L,$
                     /vertical,format='(I7)',charsize=0.75,$
                     position = cbpos

tvlct,rnow,gnow,bnow
device,decomposed=1

            for i=0,n_elements(phvt)-1 do begin
                plots,phvt[i],((10.0d)^(9.0d))*t[i],psym=4,symsize=2.0,color = 256L*256L*255L
            endfor

            plots,phvt[tauind],((10.0d)^(9.0d))*t[tauind],psym=2,symsize=3.0,color=256L*255L
            nse_legend,winid,0.4,0.9,'Fit Phases',color = 256L*256L*255L,$
                            psym=4,symsize=2,_extra=extra

device,decomposed=0

            ;window,1
            ;surface,m,x,y,/ylog
        endif

if dc eq 0 then tvlct,r,g,b
device,decomposed = dc

end;contourEcho
function ooecho::Tau,_Extra=extra
;
;NAME:
;        ooecho::Tau
;
;PURPOSE:
;           Get the array of Fourier times.
;PARAMETERS:
;           none
;KEYWORDS:
;           none
;RETURN VALUE:
;           The array of Fourier times.
    ;;self->addTreatment,'ooEcho::Tau'


    ;RETURN ARRAY OF FOURIER TIMES
    return,*self.fourierTime
end;Tau
function ooEcho::term,_Extra=extra
;
;NAME:
;        ooEcho::term
;
;PURPOSE:
;       Return the "term" value of the data, i.e. the first point_to_up/down
;       value after the data.
;
;       This method overrides the ooEcho term method.
;       point_to_up/down_x,y,z not available in superclass
;       so I must override here.
;PARAMETERS:
;       none.
;KEYWORDS:
;       none
;RETURN VALUE:
;   The term value.
;

        term = min([self.point_to_down,self.point_to_up])
if term le 0 then term = 1
        return,term
end;term


function ooEcho::chirpMean,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpMean
;
;PURPOSE:
;       Return the mean value of the echo.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The mean value of the echo.
    ;self->addTreatment,'ooEcho::chirpMean'

    ;
    ;072904
    ;
    ;THIS FUNCTION RETURNS THE AVERAGE VALUE FOR THE ECHO DATA
    ;('CHIRP') FOR A GIVEN DETECTOR PIXEL AT A GIVEN FOURIER TIME
    ;

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

    ssz = size(s)

    ;051805
    ;CORRECTING THE NEXT SECTION TO REFLECT THE POSSIBILITY THAT point_to_up COULD OCCUR FIRST.


        term = self->term();min([self.point_to_down,self.point_to_up])

        ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
        ys = s[xind,yind,0:term-1,tauind];self.point_to_down-1,tauind]

        ;RETURN THE SLICE AS A 1D ARRAY
        return,mean(reform(ys,term));self.point_to_down))
;    endelse
end;chirpMean
function ooEcho::ChiSqWeightedAveWidth,_Extra=extra
;
;NAME:
;        ooEcho::ChiSqWeightedAveWidth
;
;PURPOSE:       Calculate the weighted average of the Gaussian width from
;               the fit of all of the echoes.  This would primarily be used for
;               finding the average echo width when the full echo is measured.
;
;PARAMETERS:
;               none
;KEYWORDS:
;               none
;RETURN VALUE:
;               the average echo width.
    ;self->addTreatment,'ooEcho::ChiSqWeightedAveWidth'

    width = (*(self.fitparms))[3,*,*]
    chisq = (*(self.chisq))[*,*]
    sz = size(chisq)
    width = reform(width,sz[1],sz[2])

    mask2d = (*(self.mask2d))[*,*]

    mask2dpoints = where(mask2d le 0)
    if mask2dpoints[0] ne -1 then $
        mask2d[mask2dpoints] = 0

    width = width*mask2d
    chisq = chisq*mask2d

    chisqpts = where(chisq ne 0)

    if chisqpts[0] ne -1 then begin

        width = width[chisqpts]
        chisq = chisq[chisqpts]

        width_ave = total(width/chisq)/total(1.0/chisq)

    endif else begin
        width_ave = double('Nan')
    endelse


    return,width_ave
end;ChiSqWeightedAveWidth


function ooEcho::chirp,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirp
;
;PURPOSE:
;       Return the echo  values.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The echo values.
    ;;self->addTreatment,'ooEcho::chirp'

    ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
    ;DETECTOR PIXEL AT A GIVEN FOURIER TIME
    ;

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)



    ;061804
    ;THIS FAILS WHEN THERE ARE NO DATA IN THE FILE

    ;
    ;
    ;COME BACK TO THIS
    ;

    ;CHECK SIZE OF s IN CASE OF BAD INPUT FILE
    ;
    ;THE RESULT OF THIS TEST WILL HAVE TO PROPAGATE
    ;TO THE init METHOD.
    ssz = size(s)
;    if ssz[1] lt self.point_to_down then begin
;        print,'SIZE PROBLEM in ooEcho::chirp!!!'
;        return,0
;    endif else begin


;092705
;MAKE THE FOLLOWING UPDATE TO HANDLE CASES WHERE POINT_TO_UP lt POINT TO DOWN!!!
term = self->term();min([self.point_to_down,self.point_to_up])


    ;THIS IS THE CRASHING POINT FOR PROBLEM FILES.
        ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
;        ys = s[xind,yind,0:self.point_to_down-1,tauind]
        ys = s[xind,yind,0:term-1,tauind]

        ;RETURN THE SLICE AS A 1D ARRAY
;        return,reform(ys,self.point_to_down)
        return,reform(ys,term)

;    endelse
end;chirp
function ooEcho::chirpAll,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpAll
;
;PURPOSE:
;       Return the echo and Iup,down values.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The echo values.
    ;;self->addTreatment,'ooEcho::chirpAll'
    ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
    ;DETECTOR PIXEL AT A GIVEN FOURIER TIME INCLUDING THE
    ;FLIPPER UP/DOWN DATA USED TO CALCULATE THE AMPLITUDES.

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
    ys = s[xind,yind,0:*,tauind]

    ;RETURN THE SLICE AS A 1D ARRAY
    return,reform(ys,self.no_of_phases)
end;chirpAll
function ooEcho::chirpPhasesAll,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpPhasesAll
;
;PURPOSE:
;       Return the echo and Iup,down x values.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The echo x values.
    ;;self->addTreatment,'ooEcho::chirpPhasesAll'

;print,'_________________________'
;print,'ooEcho::chirpPhasesAll'

    ;GET PHASE VALUES (X-VALUES) FOR A SELECTED FOURIER TIME

    ;help,*(self.phase)
    ;print,self.no_of_phases
    s = (*(self.phase))[*,tauind]
    return,(reform(s,self.no_of_phases))
end;chirpPhasesAll
function ooEcho::chirpPhases,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpPhases
;
;PURPOSE:
;       Return the echo x values.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The echo x values.
    ;;self->addTreatment,'ooEcho::chirpPhases'


    ;GET PHASE VALUES (X-VALUES) FOR A SELECTED FOURIER TIME

    ;help,*self.phase
;092705
term = self->term();min([self.point_to_up,self.point_to_down])

    s = (*self.phase)[*,tauind]
;    return,(reform(s,self.no_of_phases))[0:self.point_to_down-1]
    return,(reform(s,self.no_of_phases))[0:term-1]
    ;return,(reform((*self.phase)[*,tauind],self.no_of_phases))[0:self.point_to_down-1]
end;chirpPhases
;function ooEcho::chirpPhases,tauind
;    ;GET PHASE VALUES (X-VALUES) FOR A SELECTED FOURIER TIME
;
;    s = (*self.phase)[*,tauind]
;    return,(reform(s,self.no_of_phases))[0:self.point_to_down-1]
;    ;return,(reform((*self.phase)[*,tauind],self.no_of_phases))[0:self.point_to_down-1]
;end;chirpPhases
function ooEcho::chirpMasked,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpMasked
;
;PURPOSE:
;       Return the echo without the masked points.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The echo without the masked points.
    ;;self->addTreatment,'ooEcho::chirpMasked'


;print,'_________________________'
;print,'ooEcho::chirpMasked'

    ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
    ;DETECTOR PIXEL AT A GIVEN FOURIER TIME
    ;
    ;THIS FUNCTION APPLIES THE CURRENT mask1d TO THE DATA

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

;092705
term = self->term();min([self.point_to_up,self.point_to_down])

    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
;    ys = reform(s[xind,yind,0:self.point_to_down-1,tauind],self.point_to_down)
    ys = reform(s[xind,yind,0:term-1,tauind],term)

    ysmask = 0

    ;113005
    ;NO LOOPS:
    unmasked = where((*self.mask1d)[0:term-1,tauind] gt 0,count)
    if count gt 0 then begin
        return,ys[unmasked]
    endif else begin
        return,ys;[0:term-1]
    endelse

end;chirpMasked
function ooEcho::chirpPhasesMasked,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpPhasesMasked
;
;PURPOSE:
;       Return the masked echo.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The echo phases with Iup,down points.

    ;;self->addTreatment,'ooEcho::chirpPhasesMasked'
    ;GET PHASE VALUES (X-VALUES) FOR A SELECTED FOURIER TIME
    ;
    ;THIS FUNCTION APPLIES THE CURRENT mask1d TO THE DATA
    ;
    term = self->term();min([self.point_to_up,self.point_to_down])

    ys = (*self.phase)[*,tauind]


    ;113005
    ;NO LOOPS:
    unmasked = where((*self.mask1d)[0:term-1,tauind] gt 0,count)
;    print,'_________________________'
;    print,'ooEcho::chirpPhasesMasked'
;    print,'count=',count
;    print,'unmasked=',unmasked
    if count gt 0 then begin
        return,ys[unmasked]
    endif else begin
        return,ys;[0:term-1]
    endelse

end;chirpPhasesMasked
function ooEcho::chirpMaskedAll,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpMaskedAll
;
;PURPOSE:
;       Return the masked echo with Iup,down points.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The echo with Iup,down points.

    ;;self->addTreatment,'ooEcho::chirpMaskedAll'

;print,'_________________________'
;print,'ooEcho::chirpMaskedAll'

    ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
    ;DETECTOR PIXEL AT A GIVEN FOURIER TIME
    ;
    ;THIS FUNCTION APPLIES THE CURRENT mask1d TO THE DATA

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
    ys = reform(s[xind,yind,0:self.no_of_phases-1,tauind], $
                                        self.no_of_phases)


    ysmask = 0


unmasked = where((*self.mask1d)[*,tauind] gt 0,count)
;print,'_________________________'
;print,'ooEcho::chirpPhasesMasked'
;print,'count=',count
;print,'unmasked=',unmasked
if count gt 0 then begin
    return,ys[unmasked]
endif else begin
    return,ys;[0:term-1]
endelse



end;chirpMaskedAll

function ooEcho::chirpPhasesMaskedAll,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpPhasesMaskedAll
;
;PURPOSE:
;       Return the non-masked chirp x-values.  "All" implies that Iup,down values are included.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   ysmask  The non-masked chirp x values.

    ;;self->addTreatment,'ooEcho::chirpPhasesMaskedAll'

    ;GET PHASE VALUES (X-VALUES) FOR A SELECTED FOURIER TIME
    ;
    ;THIS FUNCTION APPLIES THE CURRENT mask1d TO THE DATA
    ;

;113005
    ys = (*self.phase)[*,tauind]

;113005
    ;NO LOOPS:
    unmasked = where((*self.mask1d)[*,tauind] gt 0,count)
;    print,'_________________________'
;    print,'ooEcho::chirpPhasesMaskedAll'
;    print,'count=',count
;    print,'unmasked=',unmasked
    if count gt 0 then begin
        return,ys[unmasked]
    endif else begin
        return,ys;[0:term-1]
    endelse


end;chirpPhasesMaskedAll

function ooEcho::chirpShadow,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpShadow
;
;
;PURPOSE:
;           Give the echo points that are masked.
;PARAMETERS:
;           tauind  The Fourier time index where the 1d mask will be taken.
;KEYWORDS:
;           none
;RETURN VALUE:
;       ysshadow    The masked values of the echo.

    ;;self->addTreatment,'ooEcho::chirpShadow'


    ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
    ;DETECTOR PIXEL AT A GIVEN FOURIER TIME
    ;
    ;THIS FUNCTION APPLIES THE CURRENT mask1d TO THE DATA

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)
;print,'__________________________'
;print,'ooEcho::chirpShadow'
;092705
term = self->term();min([self.point_to_up,self.point_to_down])


    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
;    ys = s[xind,yind,0:self.point_to_down-1,tauind]
    ys = s[xind,yind,0:term-1,tauind]
;
;    ysshadow = 0
;;    for i = 0,self.point_to_down-1 do begin
;    for i = 0,term-1 do begin
;        if (*self.mask1d)[i,tauind] eq 0 then begin
;            ysshadow = [ysshadow,ys[i]]
;        endif
;    endfor
;
;    ;RETURN THE SLICE AS A 1D ARRAY
;    return,ysshadow[1:n_elements(ysshadow)-1]
;113005
    ;NO LOOPS:
    masked = where((*self.mask1d)[*,tauind] eq 0,count)
;    print,'_________________________'
;    print,'ooEcho::chirpPhasesMaskedAll'
;    print,'count=',count
;    print,'masked=',masked
    if count gt 0 then begin
        return,ys[masked]
    endif else begin
        return,ys;[0:term-1]
    endelse





end;chirpShadow
function ooEcho::chirpPhasesShadow,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpPhasesShadow
;
;PURPOSE:
;           Give the x values for echo points that are masked.
;PARAMETERS:
;           tauind  The Fourier time index where the 1d mask will be taken.
;KEYWORDS:
;           none
;RETURN VALUE:
;       ysshadow    The masked x values of the echo.

   ;;self->addTreatment,'ooEcho::chirpPhasesShadow'


    ;GET PHASE VALUES (X-VALUES) FOR A SELECTED FOURIER TIME
    ;
    ;THIS FUNCTION APPLIES THE CURRENT mask1d TO THE DATA
    ;
print,'_______________________________'
print,'ooEcho::chirpPhasesShadow'

;092705
term = self->term();min([self.point_to_up,self.point_to_down])

    ys = (*self.phase)[*,tauind]
    ysshadow = 0
;    for i = 0,self.point_to_down-1 do begin
    for i = 0,term-1 do begin
        ;print,'test',i,(*self.mask1d)[i,tauind]
        if (*self.mask1d)[i,tauind] eq 0 then begin
            ysshadow = [ysshadow,ys[i]]
            ;print,'test'
        endif
    endfor

    ;RETURN THE SLICE AS A 1D ARRAY
    return,ysshadow[1:n_elements(ysshadow)-1]
end;chirpPhasesShadow


function ooEcho::chirpExtrema,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpExtrema
;
;PURPOSE:
;           Return both Iup and Idown in one call.
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;           A 2 element array with the down and up values.

    ;;self->addTreatment,'ooEcho::chirpExtrema'


    ;GET THE DATA VALUES IN A CHIRP FOR THE FLIPPER DOWN
    ;AND FLIPPER UP STATES.
    ;RETURN A 2D VECTOR OF THE AVERAGES OF THESE DATA

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
    ;FOR UP OR DOWN VALUES


    ;080504
    ;THE NEXT LINE CRASHES WHEN EITHER THE up OR down
    ;VALUES ARE MISSING.
    ;
    ;NEED TO FIX THIS ISSUE SINCE IT COULD COME UP ELSEWHERE
    ;FOR ANY DATA SET.


;092705
;PLACE NEXT CONDITIONAL TO TEST WHERE UP AND DOWN BEGIN.
if self.point_to_down lt self.point_to_up then begin
    ysdown = s[xind,yind,self.point_to_down:self.point_to_up-1,tauind]
    ysup = s[xind,yind,self.point_to_up:*,tauind]

    ;REFORM SLICES INTO 1D MATRICES
    ysdown1d = reform(ysdown,(self.point_to_up - self.point_to_down))
    ysup1d = reform(ysup,(self.no_of_phases - self.point_to_up))
endif else begin
    ysdown = s[xind,yind,self.point_to_up:self.point_to_down-1,tauind]
    ysup = s[xind,yind,self.point_to_down:*,tauind]

    ;REFORM SLICES INTO 1D MATRICES
    ysdown1d = reform(ysdown,(self.point_to_down - self.point_to_up))
    ysup1d = reform(ysup,(self.no_of_phases - self.point_to_down))

endelse


    ;GET MEAN VALUES OF UP AND DOWN
    ydown = mean(ysdown1d)
    yup = mean(ysup1d)

    return,[ydown,yup]
end;chirpExtrema
function ooEcho::chirpExtremaMasked,xind,yind,tauind,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::chirpExtremaMasked
;
;PURPOSE:
;           Return both Iup and Idown with masking taken into account in one call.
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;           A 2 element array with the down and up values.
    ;;self->addTreatment,'ooEcho::chirpExtremaMasked'


    yup = self->chirpIup(xind,yind,tauind,tavestate=tavestate)
    ydown = self->chirpIdown(xind,yind,tauind,tavestate=tavestate)

    return,[ydown,yup]
end;chirpExtremaMasked
function ooEcho::chirpIdown,xind,yind,tauind,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::chirpIdown
;
;PURPOSE:   Calculate the Idown (F_on) values and their error bars and
;           store them in the
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;           The flipper on value.

    ;self->addTreatment,'ooEcho::chirpIdown'



    ;GET THE DATA VALUES IN A CHIRP FOR THE FLIPPER DOWN
    ;STATE.
    ;RETURN THIS VALUE

;052104
;
;ELIMINATED 5 SEMICOLON LINES AND REPLACED THEM WITH
;THE UNCOMMENTED CODE

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
;;;;;    s=reform(*self.emask,self.x_dim,self.y_dim,$
;;;;;        self.no_of_phases,self.no_of_fourier_times)


    ;APPLY 1D MASK HERE

    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
    ;FOR UP OR DOWN VALUES
;;;;;    ysdown = s[xind,yind,self.point_to_down:self.point_to_up-1,tauind]
;;;;;
;;;;;    ;REFORM SLICES INTO 1D MATRICES
;;;;;    ysdown1d = reform(ysdown,(self.point_to_up - self.point_to_down))

;if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()

;print,'tavestate=',tavestate

    ;GET ALL OF THE CHIRP VALUES
    yarr = self->chirpAll(xind,yind,tauind)

    ;GET THE MASK VALUES
    ymask = self->getMask1D(tauind)

    ;CREATE AN ARRAY OF THE UNMASKED VALUES
    meanarr = [0]

    ;042505
    ;ADD THE NEXT STATEMENT TO ALLOW FOR Iup,Idown TO BE IN
    ;EITHER ORDER IN THE DATA
    i1 = self.point_to_down
    if self.point_to_down lt self.point_to_up then begin
        i2 = self.point_to_up-1
    endif else begin
        i2 = self.no_of_phases-1
    endelse
    for i=i1,i2 do begin;self.point_to_down,self.point_to_up-1 do begin
        if ymask[i] ne 0 then begin
            meanarr = [meanarr,yarr[i]]
        endif
    endfor;i
    if n_elements(meanarr) gt 1 then begin
        meanarr = meanarr[1:*]
        ydown = mean(meanarr)
        if n_elements(meanarr) gt 1 then begin
            ;051305
            ;THE FOLLOWING LINE HAS BEEN CHANGED TO MATCH THE IGOR EB CALCULATIONS
            sydown = sqrt(total(meanarr))/n_elements(meanarr);stddev(meanarr)


        endif else begin
            sydown = sqrt(ydown)
        endelse
    endif else begin
        ydown = 0.0
        sydown = 1.0
    endelse


    ;GET MEAN VALUES OF UP AND DOWN
;;;;;    ydown = mean(ysdown1d)
;;;;;    sydown = stddev(ysdown1d)

    (*self.Idown)[xind+yind*self.x_dim,tauind] = ydown
    (*self.sIdown)[xind+yind*self.x_dim,tauind] = sydown

    return,ydown
end;chirpIdown
function ooEcho::chirpIup,xind,yind,tauind,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::chirpIup
;
;PURPOSE:
;           Return the Iup (flipper off) value
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;       The Iup (flipper off) value at this pixel

    ;self->addTreatment,'ooEcho::chirpIup'


    ;GET THE DATA VALUES IN A CHIRP FOR THE FLIPPER
    ;UP STATE.
    ;RETURN THIS VALUE

;052104
;
;REPLACE THE 5 SEMICOLON CODE WITH NEW CODE THAT
;ALLOWS MASKING OF THE UP AND DOWN VALUES

;;;;;    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
;;;;;    s=reform(*self.emask,self.x_dim,self.y_dim,$
;;;;;        self.no_of_phases,self.no_of_fourier_times)
;;;;;
;;;;;    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
;;;;;    ;FOR UP OR DOWN VALUES
;;;;;    ysup = s[xind,yind,self.point_to_up:*,tauind]
;;;;;
;;;;;    ;REFORM SLICES INTO 1D MATRICES
;;;;;    ysup1d = reform(ysup,(self.no_of_phases - self.point_to_up))
;;;;;
;;;;;    ;GET MEAN VALUES OF UP AND DOWN
;;;;;    yup = mean(ysup1d)
;;;;;    syup = stddev(ysup1d)
;;;;;
;;;;;    (*self.Iup)[xind+yind*self.x_dim,tauind] = yup
;;;;;    (*self.sIup)[xind+yind*self.x_dim,tauind] = syup
;;;;;    return,yup

;if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()

    ;GET ALL OF THE CHIRP VALUES
    yarr = self->chirpAll(xind,yind,tauind)

    ;GET THE MASK VALUES
    ymask = self->getMask1D(tauind)

    ;CREATE AN ARRAY OF THE UNMASKED VALUES
    meanarr = [0]

    ;042505
    ;ADD THE NEXT STATEMENT TO ALLOW FOR Iup,Idown TO BE IN
    ;EITHER ORDER IN THE DATA
    i1 = self.point_to_up
    if self.point_to_up lt self.point_to_down then begin
        i2 = self.point_to_down-1
    endif else begin
        i2 = self.no_of_phases-1
    endelse


    for i=i1,i2 do begin;self.point_to_up,self.no_of_phases-1 do begin
        if ymask[i] ne 0 then begin
            meanarr = [meanarr,yarr[i]]
        endif
    endfor;i

    ;GET MEAN VALUES OF UP AND DOWN
    if n_elements(meanarr) gt 1 then begin
        meanarr = meanarr[1:*]
        yup = mean(meanarr)
        if n_elements(meanarr) gt 1 then begin
            ;051305
            ;THE FOLLOWING LINE HAS BEEN CHANGED TO MATCH THE IGOR EB CALCULATIONS
            syup = sqrt(total(meanarr))/n_elements(meanarr);stddev(meanarr)
        endif else begin
            syup = sqrt(yup)
        endelse
    endif else begin
        yup = 0.0
        syup = 1.0
    endelse

    (*self.Iup)[xind+yind*self.x_dim,tauind] = yup
    (*self.sIup)[xind+yind*self.x_dim,tauind] = syup

    return,yup
end;chirpIup
function ooEcho::checkHydrogenated,x,y,t,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::checkHydrogenated
;
;PURPOSE:
;           Check whether this is a hydrogenated sample.
;PARAMETERS:
;           x
;           y
;           t
;RETURN VALUE:
;       1 for hydrogenated, 0 for not.

        if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

        dum_up = self->chirpIup(x,y,t,tavestate=tavestate)
        dum_down = self->chirpIdown(x,y,t,tavestate=tavestate)
        if dum_up ge dum_down then hydrogenated = 1 else hydrogenated = 0

    return, hydrogenated
end;checkHydrogenated
function ooEcho::chirpOffset,xind,yind,tauind,hydrogenated = hydrogenated,_Extra=extra
;
;NAME:
;        ooEcho::chirpOffset
;
;PURPOSE:
;           Get the offset based onthe Iup (flipper off) and Idown (flipper on) values.
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           hydrogenated    Flag for hydrogenated samples where spin flip scattering dominates.
;RETURN VALUE:
;       The calculated offset.

    ;self->addTreatment,'ooEcho::chirpOffset'

    if n_elements(hydrogenated) eq 0 then hydrogenated = 0

    ;GET THE DATA VALUES IN A CHIRP FOR THE FLIPPER DOWN
    ;AND FLIPPER UP STATES.
    ;RETURN THE MIDPOINT OF THE AVERAGES OF THESE DATA

    ;USE Iup,Idown HERE SO THAT I VALUES ARE SET
    ;


;083105
;THE NEXT COMMAND IS UNNECESSARY SINCE THE OFFSET VALUE
;IS ESTIMATED FROM THE MEAN OF THE ECHO.

;    ydown = self->chirpIdown(xind,yind,tauind)
;    yup = self->chirpIup(xind,yind,tauind)

;083105
;
;WHY ARE THESE up,down VALUES CALCULATED HERE TOO????
;HOW MANY TIMES IS THIS DONE?  THIS MUST CAUSE A BIT OF A
;PERFORMANCE HIT.

;
;;063004
;;
;;PROBLEM HERE ON SWITCH FROM 32x32 TO 16x16 BINNED DATA OBJECT.
;
;    ;RETURN MIDPOINT OF TWO VALUES
;    return,yup + ((ydown - yup)/2.0)

;042005
;THE FOLLOWING WILL GIVE THE SAME STARTING PARAMETER AS IGOR.
    return,mean(self->chirpMasked(xind,yind,tauind))



end;chirpOffset
function ooEcho::chirpAmplitude,xind,yind,tauind,hydrogenated=hydrogenated,_Extra=extra
;
;NAME:
;        ooEcho::chirpAmplitude
;
;PURPOSE:
;       Return the diffference between the flipper on (Idown) and flipper off (Iup) states.
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The difference between the flipper on and flipper off states.
;       i.e.

    ;self->addTreatment,'ooEcho::chirpAmplitude'

;091205
;WHY NOT REPLACE ALL OF NEXT BLOCK WITH THE TWO LINES THAT FOLLOW????
;;;;;    if n_elements(hydrogenated) eq 0 then hydrogenated = 0
;;;;;
;;;;;    ;GET THE DATA VALUES IN A CHIRP FOR THE FLIPPER DOWN
;;;;;    ;AND FLIPPER UP STATES.
;;;;;    ;RETURN THE DIFFERENCE OF THE AVERAGES OF THESE DATA
;;;;;
;;;;;    ;GET UP AND DOWN VALUES FOR SELECTED INDICES
;;;;;    arr = self->chirpExtrema(xind,yind,tauind)
;;;;;    ydown = arr[0] & yup = arr[1]
;;;;;
;;;;;;083105
;;;;;    amp = (ydown-yup)/2.0
;;;;;
;;;;;    if amp eq 0.0 then begin
;;;;;        ech = self->chirpMasked(xind,yind,tauind)
;;;;;        amp = (max(ech) - min(ech))/2.0
;;;;;
;;;;;    endif

;print,'091205 ooecho::chirpamplitude'
    ech = self->chirpMasked(xind,yind,tauind)
    amp = (max(ech) - min(ech))/2.0


    return,amp;(ydown - yup)/2.0
end;chirpAmplitude
function ooEcho::chirpAmplitudePhases,tauind,_Extra=extra
;
;NAME:
;        ooEcho::chirpAmplitudePhases
;
;PURPOSE:
;       Get the phase array where the "Amplitude"  (i.e. the
;       difference between flipper on (Idown) and flipper off (Iup) values)
;       is calculated.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The phases at which the amplitude is calculated.
    ;;self->addTreatment,'ooEcho::chirpAmplitudePhases'



;051805
;Updating to
    start = min([self.point_to_up,self.point_to_down])

    return,(reform((*self.phase)[*,tauind],self.no_of_phases))[start:*];[self.point_to_down:*]


end;chirpAmplitudePhases
function ooEcho::chisq,y,sy,tauind,parms,nfree,_Extra=extra
;
;NAME:
;        ooEcho::chisq
;
;PURPOSE:
;       Calculate chi squared.
;PARAMETERS:
;       y       The data values of the echo.
;       sy      The eb in the data values
;       tauind  The Fourier time index
;       parms   The fit parameters associated with this echo.
;       nfree   The number of free parameters
;KEYWORDS:
;       none
;RETURN VALUE:
;       The Chisq value.

    ;self->addTreatment,'ooEcho::chisq'

    ;041305
    ;PREVENT INFINITE CHISQ FROM sy = 0. ---- IS THIS CORRECT TO DO SO???
        wsy = where(sy eq 0.0)
        if (wsy[0] ne -1) then sy[wsy] = 1.0


        factor = n_elements(y) - nfree - 1

        x = self->chirpPhasesMasked(tauind)
        chirp = chirpFun(x,parms)

        residuals = total((y - chirp)^2 * abs(1/(sy^2)))

;        residuals = total((y - self->chirpFun(parms,tauind))^2 * $
;                                                    abs(1/(sy^2)))


        return,residuals/factor
end;chisq


function ooEcho::chisqTest,y,sy,tauind,parms,nfree,_Extra=extra
;
;NAME:
;        ooEcho::chisqTest
;
;PURPOSE:
;       Calculate chi squared.
;PARAMETERS:
;       y       The data values of the echo.
;       sy      The eb in the data values
;       tauind  The Fourier time index
;       parms   The fit parameters associated with this echo.
;       nfree   The number of free parameters
;KEYWORDS:
;       none
;RETURN VALUE:
;       The Chisq value.

    ;self->addTreatment,'ooEcho::chisq'

    ;041305
    ;PREVENT INFINITE CHISQ FROM sy = 0. ---- IS THIS CORRECT TO DO SO???
        wsy = where(sy eq 0.0)
        if (wsy[0] ne -1) then sy[wsy] = 1.0


        factor = n_elements(y) - nfree - 1

        x = self->chirpPhasesMasked(tauind)
        chirp = chirpFun(x,parms)

        residuals = total((y - chirp)^2 * abs(1/(sy^2)))

;        residuals = total((y - self->chirpFun(parms,tauind))^2 * $
;                                                    abs(1/(sy^2)))


        return,residuals/factor
end;chisqTest


function ooEcho::fitvals,xind,yind,tauind,_Extra=extra
;
;NAME:
;        ooEcho::fitvals
;
;PURPOSE:
;       Return the current values of the fit parameters for the selected indices.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The fit parameters at the selected indices.
    ;;self->addTreatment,'ooEcho::fitvals'


;    ;051704 THERE MAY BE A PROBLEM HERE ON REBINNING!!!!
;    ;print,'xind,yind,tauind = ',xind,yind,tauind
;    if xind ge self.x_dim then xind = self.x_dim-1
;    if yind ge self.y_dim then yind = self.y_dim-1
;    if tauind ge self.no_of_fourier_times then $
;                tauind = self.no_of_fourier_times-1

    ;THIS PROBLEM SHOULD BE INTERCEPTED BEFORE CALLING THIS ROUTINE.
    ;CHECK ALL OF THE INDICES AT THE CALLING FUNCTIONS!!!


    return,(*self.fitparms)[*,self.x_dim*yind+xind,tauind]
end;fitvals
function ooEcho::chirpFit9ChiSq,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            parinfo = parinfo,$
                            tavestate=tavestate,$
                            _Extra=extra
;
;NAME:
;        ooEcho::chirpFit9ChiSq
;
;PURPOSE:
;       Fit the central pixel with 9 different phase values centered around the
;       expected starting point as the starting points and accept the one with
;       the lowest chisq.  This is used to start the expand fitting process.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       fixed
;       limited
;       startparms
;       parmlims
;       parinfo
;RETURN VALUE:
;       result  Fit parms
;       0       Failure

    ;self->addTreatment,'ooEcho::chirpFit9ChiSq'


    ;PREPARE A FIT ROUTINE TO CALCULATE 9
    ;VALUES AROUND THE INPUT PHASE AND USE FIT
    ;WITH MINIMUM CHI-SQUARED TO START OFF
    ;THE PHASE FITS FOR A GIVEN TAU.
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 


;    x = self->chirpPhases(tauind)
;    y = self->chirp(xind,yind,tauind)
    x = self->chirpPhasesMasked(tauind)
    y = self->chirpMasked(xind,yind,tauind)
    sy= sqrt(y)


;083105
;COMMENT OUT THE NEXT TWO LINES SINCE THEY ARE SUPERCEDED BY CALL
;TO startParms
;
;
;    dum = self->chirpIup(xind,yind,tauind)
;    dum = self->chirpIdown(xind,yind,tauind)


    ;SET STARTING PARAMETERS FOR THIS ECHO AND INITIALIZE
    ;THE ERROR ARRAY FOR THIS SET OF PARAMETERS
    parms = self->startParms(xind,yind,tauind,hydrogenated=hydrogenated,tavestate=tavestate)
    ;print,parms
;print,'hydrogenated = ',hydrogenated
    perror = parms


;;;092104
;;;    lims = [[5.0d,5000.0d], [0.1,20000.0d], [-1999.0d,2000.0d],$
;;;            [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;
;;    lims = [[5.0d,5000.0d], [0.1,40000.0d], [-1999.0d,2000.0d],$
;;            [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]


;091205
;
;COMMENT OUT THE NEXT SECTION.
;
;;;;;;092204
;;;;;;
;;;;;;USE AN IF STATEMENT TO GENERATE A REASONABLE SET OF LIMITS BASED
;;;;;;ON THE DATA.
;;;;;if max(y) ge 10000 then begin
;;;;;    lims = [[50.0d,500000.0d], [10.0,1000000.0d], [-1999.0d,2000.0d],$;, [10.0,1000000.0d], [-1999.0d,2000.0d],$
;;;;;            [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;;;;endif else begin
;;;;;    if max(y) le 10.0 then begin
;;;;;        lims = [[0.1d,200.0d], [0.1,200.0d], [-1999.0d,2000.0d],$
;;;;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;;;;    endif else begin
;;;;;        ;DEFAULT CASE
;;;;;        lims = [[1.0d,5000.0d], [0.1,20000.0d], [-1999.0d,2000.0d],$
;;;;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;;;;    endelse
;;;;;endelse

;091205
;ALTER THE LIMITS TO ALLOW SLIGHTLY NEGATIVE AMPLITUDES FOR
;TRADITIONAL SAMPLES.
if self.type eq 2 or self.type eq 3 then begin
    minamp = -30.0d - mean(y)/30.0d
endif else begin
    minamp = 0.001;-30.0d - mean(y)/30.0d
endelse

    lims = [[0.01d,10000000.0d], [minamp,1000000000.0d], [-10000.0d,10000.0d],$
            [0.01d,2000.0d], [0.001d,200000.0d], [-1999.0d,2000.0d]]
;083005
        if hydrogenated eq 1 then begin
            temp = -1.0*lims[0,1]
            lims[0,1] = -1.0*lims[1,1]
            lims[1,1] = temp
        endif





    ;PREVENT CRASH DUE TO BAD STATS
    if (min(sy) gt 0.0) then begin
        names = ['OFFSET','AMPLITUDE','CENTER','SIGMA','OMEGA','PHASE']

        if (n_elements(startparms) ne 6) then begin
            ;SELECT STARTING PARAMETERS BASED ON INFORMATION
            ;IN DATA.
            start = parms
        endif else begin
            start = startparms
        endelse

        if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)
        endif

        parinfo[*].value = start
        if (n_elements(fixed) ne 6) then begin
            parinfo[*].fixed = [0,0,0,1,1,1]
        endif else begin
            parinfo[*].fixed = fixed
        endelse


        if (n_elements(fixed) eq 6) then begin
            for iii = 0,5 do begin
                (*self.fixed)[iii,xind+yind*self.x_dim,tauind] = fixed[iii]
            endfor;iii
        endif


        parinfo[*].parname = names
        parinfo[*].limits = lims

        npts = 11
        chiSqTemp = dblarr(npts)
        phaseTemp = dblarr(npts)

        start2Orig = start[2]

        ;PERFORM FIT AND CALCULATE CHI SQ VALUES FOR GIVEN TAU.
        for i=-(npts/2),(npts/2) do begin
            phaseTemp[i+(npts/2)] = start2Orig +i*360.0
            start[2] = phaseTemp[i+(npts/2)]

            parms = mpfitfun('chirpFun', x, y, sy, start, $
                                            parinfo = parinfo, $
                                            perror=perror, /QUIET)


            ;print,parms
            phaseTemp[i+(npts/2)] = parms[2]

            nfree = 6 - total((*self.fixed)[*,xind+yind*self.x_dim,tauind])
            chiSqTemp[i+(npts/2)] = self->chisqtest(y,sy,tauind,parms,nfree)

        endfor;i

        ;print,'chisq=',chiSqTemp
        ;print,'phaseTemp=',phaseTemp


        ;LOCATE MINIMUM CHISQ INDEX
        ;print,min(chiSqTemp,minChiSqInd)
        dummy = min(chiSqTemp,minChiSqInd)
        ;print,minChiSqInd
        ;print,phaseTemp[minChiSqInd]


        ;PERFORM FIT AT PHASE WITH MIN CHISQ
        start[2] = phaseTemp[minChiSqInd]
        parms = mpfitfun('chirpFun', x, y, sy, start, $
                                        parinfo = parinfo, $
                                        perror=perror, /QUIET)

        nfree = 6 - total((*self.fixed)[*,xind+yind*self.x_dim,tauind])
        chiSqTemp[minChiSqInd] = self->chisqtest(y,sy,tauind,parms,nfree)

        result = [parms,perror]

        ;SET VALUE OF CHI-SQUARED FOR THIS PIXEL,TAU
        (*self.chisq)[yind*self.x_dim + xind,tauind]$
                            = self->chisqtest(y,sy,tauind,parms,nfree)

        ;ASSIGN RESULTS OF INDIVIDUAL FITS TO fitparms
        ;ELEMENT AS FITS ARE DONE
        (*self.fitparms)[*,self.x_dim*yind+xind,tauind] = result

        self->setfitdisplaymask,xind,yind,tauind,value=1

        return,result
    endif else begin
        ;IN CASE OF POOR STATISTICS
        self->setfitdisplaymask,xind,yind,tauind,value=0
        return,0
    endelse
end;chirpFit9ChiSq


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::pegRefit,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            parinfo=parinfo,_Extra=extra
;
;NAME:
;        ooEcho::pegRefit
;
;PURPOSE:
;       The idea was to check over all of the resulting fit
;       parameters and refit if any of them were pegged at
;       their limits.
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

    ;self->addTreatment,'ooEcho::pegReFit'

    ;IF PEGGED, RESET THE START PARAMETERS AND REFIT.


end;pegRefit
pro ooEcho::stuckRefit,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            parinfo=parinfo,_Extra=extra
;
;NAME:
;        ooEcho::stuckRefit
;
;PURPOSE:
;           This was an idea that wasn't used.  It was meant to
;           raise the error bars on the data by a factor of 10 when
;           statistics were "too good" and the fitting routine
;           got stuck.
;PARAMETERS:
;
;KEYWORDS:
;

    ;self->addTreatment,'ooEcho::stuckReFit'


    ;10/19/04
    ;
    ;IF STUCK MULTIPLY THE DATA EB BY A FACTOR OF 10 AND REFIT.
    ;



end;stuckRefit
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   NOTE:   ooEcho::chirpFit is overridden in ooEchoMagnetic::chirpFit.
;
;           The overridden method is in ooEchoMagnetic__bin.pro.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ooEcho::chirpFit,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            parinfo=parinfo,$
                            suppress=suppress,$
                            hydrogenated=hydrogenated,$
                            allownegamp = allownegamp,$
                            noborrow=noborrow,$
                            tavestate=tavestate,$
                            _Extra=extra

;NOTE:::::
;
;______________________________________________
;THIS METHOD IS OVERRIDDEN IN ooEchoMagnetic
;______________________________________________
;
;NAME:
;        ooEcho::chirpFit
;
;PURPOSE:
;           Fit a single echo and update the fitdisplaymask.
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           suppress    Flag to suppres treatment line.
;RETURN VALUE:
;       result  Fitparms
;       0       Failure
;print,'ooEcho::chirpFit'
    if n_elements(noborrow) eq 0 then noborrow = 0
    if n_elements(suppress) eq 0 then suppress = 0
    if n_elements(allownegamp) eq 0 then allownegamp = 1

    ;if suppress eq 0 then self->addTreatment,'ooEcho::chirpFit'


    ;FITTING FOR A SINGLE ECHO
    ;   KEYWORDS:
    ;   startparms IS A 6 ELEMENTS ARRAY OF THE INPUT STARTING PARAMETERS
    ;   fixed IS A 6 ELEMENTS ARRAY OF 1's AND 0's

;042005
;CHANGE THE NEXT LINE TO REFLECT THE USER MASKED MASK VALUE OF -1
;if ((*(self.mask2d))[yind*self.x_dim+xind,tauind] ne 0) then begin

if ((*(self.mask2d))[yind*self.x_dim+xind,tauind] gt 0) then begin


    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;CHANGE HERE TO USE MASKED 1D ARRAYS
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;    x = self->chirpPhases(tauind)
;    y = self->chirp(xind,yind,tauind)
    x = self->chirpPhasesMasked(tauind)
    y = self->chirpMasked(xind,yind,tauind)
    sy= sqrt(double(y))

    ;THE FOLLOWING STEP WILL WEIGHT PIXELS WITH
    ;ZERO COUNTS WITH A 1 IN THE FIT!!!!!

    ;SET sy[] = 1 AT ZERO VALUES
    for ii = 0,n_elements(sy)-1 do begin
        if sy[ii] eq 0.0 then sy[ii] = 1.0
    endfor;ii
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 
    dum_up = self->chirpIup(xind,yind,tauind,tavestate=tavestate)
    dum_down = self->chirpIdown(xind,yind,tauind,tavestate=tavestate)

    if dum_up gt dum_down then begin
        hydrogenated = 1
    endif else hydrogenated = 0


;051305
;ALLOW SMALL NEGATIVE AMPLITUDES FOR SAMPLE/CELL AS IGOR DOES.


;073008
;ALLOW NEG AMPLITUDE AT USER DISCRETION FOR ALL TYPES OF DATA SETS.

;if self.type eq 2 or self.type eq 3 then begin
;if ((self.type eq 2) or $
;   (self.type eq 3)) or $
;   (self.type eq 0) then begin



    ;081406
    if allownegamp eq 1 then begin
        minamp = -30.0d - mean(y)/30.0d
    endif else begin
        minamp = 0.001;-30.0d - mean(y)/30.0d
    endelse
;endif else begin
;    minamp = 0.001;-30.0d - mean(y)/30.0d
;endelse

    lims = [[0.01d,10000000.0d], [minamp,1000000000.0d], [-10000.0d,10000.0d],$
            [0.01d,2000.0d], [0.001d,200000.0d], [-1999.0d,2000.0d]]
;print,'hydrogenated=',hydrogenated

;083005
        if hydrogenated eq 1 then begin
            temp = -1.0*lims[0,1]
            lims[0,1] = -1.0*lims[1,1]
            lims[1,1] = temp
        endif


    ;PREVENT CRASH DUE TO BAD STATS
    if (min(sy) gt 0.0) then begin
        names = ['OFFSET','AMPLITUDE','CENTER','SIGMA','OMEGA','PHASE']

        if (n_elements(startparms) ne 6) then begin
            ;SELECT STARTING PARAMETERS BASED ON INFORMATION
            ;IN DATA.
            start = self->startParms(xind,yind,tauind,noborrow=noborrow,tavestate=tavestate)
            perror = 0.0*start
        endif else begin
            start = startparms
            perror = 0.0*start
        endelse


        ;I SHOULDN'T HAVE TO CREATE THIS EACH TIME!!!  IF I PASS
        ;IT IN AS AN ARGUMENT THEN I CAN AVOID THIS CALL EVERY TIME
        ;WITH AN IF STATEMENT
        if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)
        endif
;110104
fixed = (*self.fixed)[*,xind+yind*self.x_dim,tauind]
        parinfo[*].value = start
        if (n_elements(fixed) ne 6) then begin
            parinfo[*].fixed = [0,0,0,1,1,1]
        endif else begin
            parinfo[*].fixed = fixed
        endelse


;111405
;NEED TO SAVE THE PHASE AND PERIOD IN CASE THEY ARE FIXED
;DURING THE FIT PROCESS.
savephase = parinfo[2].value
if fixed[2] eq 1 then savephase = parinfo[2].value
if fixed[4] eq 1 then saveperiod = parinfo[4].value



;110104
        ;(*self.fixed)[*,xind+yind*self.x_dim,tauind] = fixed
        nfree = 6 - total((*self.fixed)[*,xind+yind*self.x_dim,tauind])


;       parinfo[*].limited = [[1,1],[1,1],[0,0],[1,0],[1,1],[0,0]]
        ;parinfo[*].limited = [[1,1],[1,1],[1,1],[1,1],[1,1],[1,1]]
        if (n_elements(parmlims) ne 12) then begin
            parinfo[*].limits = lims
        endif else begin
            parinfo[*].limits = parmlims
        endelse

        parinfo[*].parname = names
        ;parinfo[5].tied = 'P[2]'   ;ACCORDING TO GEORG EHLERS WE MAY WANT
                                    ;P[2] AND P[5] TO BE INDEPENDENT

;       parinfo[0] =   {value:300.0,fixed:0,limited:[1,1],$
;                       limits:[200.0,350.0],parname:'OFFSET',$
;                       $;step:0, relstep:0, $
;                       $;mpside:-1,mpminstep:10.0,mpmaxstep:100.0,tied:2.0*p[1]$
;                       }


;101904 testing


        ;041405
        ;DON'T TRY TO FIT IF ALL PARMS ARE FIXED!!!

;        PRINT,parinfo.limits
;        print,parinfo.limited
;        print,start
;        print,parinfo.value
;print,hydrogenated
        if total(parinfo[*].fixed) ne 6 then begin
            parms = mpfitfun('chirpFun', x, y, sy, start, $
                                                parinfo = parinfo, $
                                                perror=perror, /QUIET)
;print,parinfo[*].limits


        ;I THINK ORIGINALLY I CHOSE NOT TO ADD THIS TYPE OF
        ;THING TO THE chirpFit METHOD.  FOR NOW I WILL ADD
        ;IT TO ATTEMPT TO GET THE FITTING MORE RELIABLE.
        ;

            ;082304
            ;
            ;DO A SIMPLE PARAMETER CHECK HERE FOR THE MOST COMMON
            ;PEGGING VALUES OF THE FIT PARAMETERS

            ;FIRST CHECK, AMPLITUDE/PHASE
            if parms[1] eq minamp then begin ;0.1 or parms[1] eq -0.1 then begin
                start = parms
                start[0] = self->chirpMean(xind,yind,tauind)
                if hydrogenated eq 0 then begin
                    start[1] = self->chirpMean(xind,yind,tauind)
                endif else begin
                    start[1] = -1.0*self->chirpMean(xind,yind,tauind)
                endelse


                ;start[2] = phsstart
                if noborrow eq 0 then begin
                    dum = min(y,phaseStartIndex)
                    phaseStart = x[phaseStartIndex]
                endif else phaseStart = savephase

;111405
;NEED TO SAVE THE PHASE AND PERIOD IN CASE THEY ARE FIXED
;DURING THE FIT PROCESS.
if fixed[2] eq 1 then phaseStart = savephase
if fixed[4] eq 1 then parinfo[4].value = saveperiod



                start[2] = phaseStart
                ;print,'Start after changes:',xind,yind,tauind,start

                parinfo[0].value = start[0]
                parinfo[1].value = start[1]
                parinfo[2].value = start[2]
                ;savefixed = parinfo[2].fixed
                ;parinfo[2].fixed = 0


                parms = mpfitfun('chirpFun', x, y, sy, start, $
                                                    parinfo = parinfo, $
                                                    perror=perror, /QUIET)

                ;parinfo[2].fixed = savefixed


;091205 CHANGES
                if parms[1] eq -0.1 then begin
;                    print,xind,yind,tauind
;                    print,parms,perror
;                    print,startparms
;                    print,parinfo[*].value

;111405
;NEED TO SAVE THE PHASE AND PERIOD IN CASE THEY ARE FIXED
;DURING THE FIT PROCESS.
if fixed[2] eq 1 then start[2] = savephase
if fixed[4] eq 1 then start[4] = saveperiod


                    parms = mpfitfun('chirpFun', x, y, sy, start, $
                                                        parinfo = parinfo, $
                                                        perror=perror, quiet = 1)



                endif


                ;041205
                if ((parms[4] gt 360.0/300.0) or (parms[4] lt 360.0/420.0)) and fixed[4] ne 1 then begin

;111405
;NEED TO SAVE THE PHASE IN CASE IT IS FIXED
;DURING THE FIT PROCESS.
if fixed[2] eq 1 then start[2] = savephase

                    ;FIT WITH PERIOD FIXED THEN FIT WITH PERIOD ALLOWED TO VARY
                    parinfo[*].value = start
                    parinfo[4].fixed = 1

                    parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
                    parinfo[4].fixed = 0
                    parinfo[*].value = parms

;111405
;NEED TO SAVE THE PHASE IN CASE IT IS FIXED
;DURING THE FIT PROCESS.
if fixed[2] eq 1 then parinfo[2].value = savephase


                    parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
                endif
                ;041205

            endif;parms[1] eq 0.1

        endif else begin
            parms = start
        endelse

        result = [parms,perror]



        ;ASSIGN RESULTS OF INDIVIDUAL FITS TO fitparms
        ;ELEMENT AS FITS ARE DONE
        (*self.fitparms)[*,self.x_dim*yind+xind,tauind] = result

;073008
;AFTER DISCUSSION WITH ANTONIO, WE ARE ELIMINATING THE NEXT STEP.  
;THE RESULT IS VERY ARTIFICIAL UNLESS IT IS PROVIDED AS THE STARTING POINT
;TO A FIT.
;
;        dum = self->checkAmp(xind,yind,tauind,tavestate=tavestate)
;        result[1] = dum


        ;SET VALUE OF CHI-SQUARED FOR THIS PIXEL,TAU
        (*self.chisq)[yind*self.x_dim + xind,tauind] $
                            = self->chisqtest(y,sy,tauind,parms,nfree)


;THIS SHOULD NEVER BE CALLED SINCE THE HAS BEEN SUPPLANTED BY ooEchoMagnetic__bin VERSION OF THIS ROUTINE.
if xind eq 11 and yind eq 6 then begin

    print,'##################################################'
    print,'Chisq[11,6] = ',self->chisqtest(y,sy,tauind,parms,nfree)
    help,/traceback

endif
        self->setfitdisplaymask,xind,yind,tauind,value=1
        return,result

    endif else begin
        ;IN CASE OF POOR STATISTICS

        self->setfitdisplaymask,xind,yind,tauind,value=0
        return,0
    endelse
endif else begin;mask2d
        return,0
endelse
end;chirpFit
function ooEcho::chirpAmpOffsetReFit,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            parmlims=parmlims,_Extra=extra
;
;NAME:
;        ooEcho::chirpAmpOffsetReFit
;
;PURPOSE:
;       Redo the fit with new Amp and offset starting points.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       fixed
;       limited
;       parmlims
;RETURN VALUE:
;       result  Fit parameters
;       0       Failure
    ;self->addTreatment,'ooEcho::chirpAmpOffsetReFit'

    if (*self.chisq)[yind*self.x_dim + xind,tauind] gt 100.0 then begin

        ;GET THE DATA
        x = self->chirpPhases(tauind)
        y = self->chirp(xind,yind,tauind)
        sy= sqrt(y)

        ;SET STARTING PARAMETERS FOR THIS ECHO AND INITIALIZE
        ;THE ERROR ARRAY FOR THIS SET OF PARAMETERS
        ;
        ;GET THE VALUES FROM THE PREVIOUS FIT
        parms = (*self.fitparms)[0:5,self.x_dim*yind+xind,tauind]
        ;print,parms
        perror = (*self.fitparms)[6:11,self.x_dim*yind+xind,tauind]

        ;GET ORIGINAL AMPLITUDE STARTING POINT
        ampStart = self->chirpAmplitude(xind,yind,tauind)
        offsetStart = self->chirpOffset(xind,yind,tauind)
        ;PUT THE AMPLITUDE STARTING VALUE INTO THE STARTING PARAMETERS ARRAY
        parms[1] = ampStart
        parms[0] = offsetStart

;;        ;DEFINE LIMITS JUST IN CASE THE LIMITS ARE ON BUT UNDEFINED
;;;        lims = [[5.0d,5000.0d], [5.0,20000.0d], [-1999.0d,2000.0d],$
;;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;        lims = [[5.0d,5000.0d], [5.0,40000.0d], [-1999.0d,2000.0d],$
;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]

;092204
;
;USE AN IF STATEMENT TO GENERATE A REASONABLE SET OF LIMITS BASED
;ON THE DATA.
if max(y) ge 10000 then begin
    lims = [[50.0d,500000.0d], [10.0,1000000.0d], [-10000.0d,10000.0d],$
            [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
endif else begin
    if max(y) le 10.0 then begin
        lims = [[0.1d,200.0d], [0.1,200.0d], [-10000.0d,10000.0d],$
                [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
    endif else begin
        ;DEFAULT CASE
        lims = [[1.0d,5000.0d], [0.1,20000.0d], [-10000.0d,10000.0d],$
                [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
    endelse
endelse



        ;PREVENT CRASH DUE TO BAD STATS
        if (min(sy) gt 0.0) then begin
            names = ['OFFSET','AMPLITUDE','CENTER','SIGMA','OMEGA','PHASE']

            ;SET THE START ARRAY
            start = parms

            ;print,start
            ;INITIALIZE THE parinfo ARRAY
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)


            parinfo[*].value = start

            ;ASSIGN THE SELECTED PARAMETERS TO BE FIXED.
            if (n_elements(fixed) ne 6) then begin
                parinfo[*].fixed = [0,0,0,1,1,1]
            endif else begin
                parinfo[*].fixed = fixed
            endelse


            if (n_elements(parmlims) ne 12) then begin
                parinfo[*].limits = lims
            endif else begin
                parinfo[*].limits = parmlims
            endelse

            parinfo[*].parname = names


            ;RUN THE FIT
            parms = mpfitfun('chirpFun', x, y, sy, start, $
                                            parinfo = parinfo, $
                                            perror=perror, /QUIET)



            result = [parms,perror]


            ;CHECK RESULTING CHISQ.
            if self->chisqtest(y,sy,tauind,parms) lt $
                    (*self.chisq)[yind*self.x_dim + xind,tauind] then begin

                ;print,'SUCCESSFULLY LOWERED CHISQ'

            endif

            ;SET VALUE OF CHI-SQUARED FOR THIS PIXEL,TAU
            (*self.chisq)[yind*self.x_dim + xind,tauind]$
                                = self->chisqtest(y,sy,tauind,parms)

            ;ASSIGN RESULTS OF INDIVIDUAL FITS TO fitparms
            ;ELEMENT AS FITS ARE DONE
            (*self.fitparms)[*,self.x_dim*yind+xind,tauind] = result
            self->setfitdisplaymask,xind,yind,tauind,value=1

            return,result
        endif else begin
            ;IN CASE OF POOR STATISTICS
            self->setfitdisplaymask,xind,yind,tauind,value=0

            return,0
        endelse
    endif else begin
        ;print,"Stats not too bad."
    endelse

end;chirpAmpOffsetReFit
function ooEcho::chirpAmpReFit,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            parmlims=parmlims,$
                            tavestate=tavestate,$
                            _Extra=extra
;
;NAME:
;        ooEcho::chirpAmpReFit
;
;PURPOSE:
;       Check that the amplitude fit parameter is reasonable, and if it is not
;       refit the echo.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       fixed
;       limited
;       parmlims
;RETURN VALUE:
;       result  Fit results
;       0       Failure
    ;self->addTreatment,'ooEcho::chirpAmpReFit'


    ;REFIT SELECTED ECHO BY ASSUMING ALL BUT ONE PARAMETER IS
    ;CORRECT.  THIS FUNCTION IS ONLY CALLED WHEN THE
    ;(*self.chisq)[yind*self.x_dim + xind,tauind] VALUE IS
    ;GREATER THAN SOME THRESHOLD.
    ;FOR NOW ASSUME THAT VALUE IS 100.
    ;
    ;SHOULD CHECK BEVINGTON'S chisq TABLE TO SEE WHAT VALUE WOULD
    ;BE REASONABLE BASED ON PROBABILITIES, BUT ANY FIT THAT IS BAD
    ;USUALLY HAS A VERY HIGH CHISQ.  100 SHOULD BE A REASONABLE
    ;CUTOFF.
    ;
    ;
    ;1) ASSUME THE BAD PARAMETER IS THE AMPLITUDE.
    ;2) GET A NEW STARTING AMPLITUDE AND USE THE OTHER PARAMETERS AS-IS.
    ;3) REFIT WITH THIS SET OF STARTING PARAMETERS.
    ;
    ;

    if (*self.chisq)[yind*self.x_dim + xind,tauind] gt 100.0 then begin

        ;GET THE DATA
        x = self->chirpPhases(tauind)
        y = self->chirp(xind,yind,tauind)
        sy= sqrt(y)

        ;SET STARTING PARAMETERS FOR THIS ECHO AND INITIALIZE
        ;THE ERROR ARRAY FOR THIS SET OF PARAMETERS
        ;
        ;GET THE VALUES FROM THE PREVIOUS FIT
        parms = (*self.fitparms)[0:5,self.x_dim*yind+xind,tauind]
        perror = (*self.fitparms)[6:11,self.x_dim*yind+xind,tauind]

        ;GET ORIGINAL AMPLITUDE STARTING POINT
        ampStart = self->chirpAmplitude(xind,yind,tauind)

        ;PUT THE AMPLITUDE STARTING VALUE INTO THE STARTING PARAMETERS ARRAY
        parms[1] = ampStart

        ;DEFINE LIMITS JUST IN CASE THE LIMITS ARE ON BUT UNDEFINED
;;;        lims = [[5.0d,5000.0d], [5.0,20000.0d], [-1999.0d,2000.0d],$
;;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;        lims = [[5.0d,5000.0d], [5.0,40000.0d], [-1999.0d,2000.0d],$
;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]


;092204
;
;USE AN IF STATEMENT TO GENERATE A REASONABLE SET OF LIMITS BASED
;ON THE DATA.
if max(y) ge 10000 then begin
    lims = [[50.0d,500000.0d], [10.0,1000000.0d], [-10000.0d,10000.0d],$
            [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
endif else begin
    if max(y) le 10.0 then begin
        lims = [[0.1d,200.0d], [0.1,200.0d], [-10000.0d,10000.0d],$
                [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
    endif else begin
        ;DEFAULT CASE
        lims = [[1.0d,5000.0d], [0.1,20000.0d], [-10000.0d,10000.0d],$
                [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
    endelse
endelse



        ;PREVENT CRASH DUE TO BAD STATS
        if (min(sy) gt 0.0) then begin
            names = ['OFFSET','AMPLITUDE','CENTER','SIGMA','OMEGA','PHASE']

            ;SET THE START ARRAY
            start = parms

            ;print,start
            ;INITIALIZE THE parinfo ARRAY
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)


            parinfo[*].value = start

            ;ASSIGN THE SELECTED PARAMETERS TO BE FIXED.
            if (n_elements(fixed) ne 6) then begin
                parinfo[*].fixed = [0,0,0,1,1,1]
            endif else begin
                parinfo[*].fixed = fixed
            endelse

            nfree = total(parinfo[*].fixed)

            if (n_elements(parmlims) ne 12) then begin
                parinfo[*].limits = lims
            endif else begin
                parinfo[*].limits = parmlims
            endelse

            parinfo[*].parname = names


            ;RUN THE FIT
            parms = mpfitfun('chirpFun', x, y, sy, start, $
                                            parinfo = parinfo, $
                                            perror=perror,/QUIET)



            result = [parms,perror]


            ;CHECK RESULTING CHISQ.
            if self->chisqtest(y,sy,tauind,parms,nfree) lt $
                    (*self.chisq)[yind*self.x_dim + xind,tauind] then begin

                ;print,'SUCCESSFULLY LOWERED CHISQ'

            endif

            ;SET VALUE OF CHI-SQUARED FOR THIS PIXEL,TAU
            (*self.chisq)[yind*self.x_dim + xind,tauind]$
                                = self->chisqtest(y,sy,tauind,parms,nfree)

            ;ASSIGN RESULTS OF INDIVIDUAL FITS TO fitparms
            ;ELEMENT AS FITS ARE DONE
            (*self.fitparms)[*,self.x_dim*yind+xind,tauind] = result

            self->setfitdisplaymask,xind,yind,tauind,value=1
            return,result
        endif else begin
            ;IN CASE OF POOR STATISTICS
            self->setfitdisplaymask,xind,yind,tauind,value=0
            return,0
        endelse
    endif else begin
        ;print,"Stats not too bad."
    endelse

end;chirpAmpReFit
function ooEcho::chirpPhaseReFit,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            parmlims=parmlims,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::chirpPhaseReFit
;
;PURPOSE:
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       fixed
;       limited
;       parmlims
;RETURN VALUE:
;       result  Resulting fit parameters
;       0       Indicate failure.

    ;self->addTreatment,'ooEcho::chirpPhaseRefit'


    ;REFIT SELECTED ECHO BY ASSUMING ALL BUT ONE PARAMETER IS
    ;CORRECT.  THIS FUNCTION IS ONLY CALLED WHEN THE
    ;(*self.chisq)[yind*self.x_dim + xind,tauind] VALUE IS
    ;GREATER THAN SOME THRESHOLD.
    ;FOR NOW ASSUME THAT VALUE IS 100.
    ;
    ;SHOULD CHECK BEVINGTON'S chisq TABLE TO SEE WHAT VALUE WOULD
    ;BE REASONABLE BASED ON PROBABILITIES, BUT ANY FIT THAT IS BAD
    ;USUALLY HAS A VERY HIGH CHISQ.  100 SHOULD BE A REASONABLE
    ;CUTOFF.
    ;
    ;
    ;1) ASSUME THE BAD PARAMETER IS THE AMPLITUDE.
    ;2) GET A NEW STARTING AMPLITUDE AND USE THE OTHER PARAMETERS AS-IS.
    ;3) REFIT WITH THIS SET OF STARTING PARAMETERS.
    ;
    ;


    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if (*self.chisq)[yind*self.x_dim + xind,tauind] gt 100.0 then begin

        ;GET THE DATA
        x = self->chirpPhases(tauind)
        y = self->chirp(xind,yind,tauind)
        sy= sqrt(y)

        ;SET STARTING PARAMETERS FOR THIS ECHO AND INITIALIZE
        ;THE ERROR ARRAY FOR THIS SET OF PARAMETERS
        ;
        ;GET THE VALUES FROM THE PREVIOUS FIT
        parms = (*self.fitparms)[0:5,self.x_dim*yind+xind,tauind]
        perror = (*self.fitparms)[6:11,self.x_dim*yind+xind,tauind]

        ;GET ORIGINAL AMPLITUDE STARTING POINT
        ampStart = self->chirpAmplitude(xind,yind,tauind,tavestate=tavestate)

        ;PUT THE AMPLITUDE STARTING VALUE INTO THE STARTING PARAMETERS ARRAY
        parms[1] = ampStart

        ;DEFINE LIMITS JUST IN CASE THE LIMITS ARE ON BUT UNDEFINED
;;;        lims = [[5.0d,5000.0d], [5.0,20000.0d], [-1999.0d,2000.0d],$
;;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;        lims = [[5.0d,5000.0d], [5.0,40000.0d], [-1999.0d,2000.0d],$
;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]


;092204
;
;USE AN IF STATEMENT TO GENERATE A REASONABLE SET OF LIMITS BASED
;ON THE DATA.
if max(y) ge 10000 then begin
    lims = [[50.0d,500000.0d], [10.0,1000000.0d], [-10000.0d,10000.0d],$
            [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
endif else begin
    if max(y) le 10.0 then begin
        lims = [[0.1d,200.0d], [0.1,200.0d], [-10000.0d,10000.0d],$
                [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
    endif else begin
        ;DEFAULT CASE
        lims = [[1.0d,5000.0d], [0.1,20000.0d], [-10000.0d,10000.0d],$
                [100.0d,2000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
    endelse
endelse



        ;PREVENT CRASH DUE TO BAD STATS
        if (min(sy) gt 0.0) then begin
            names = ['OFFSET','AMPLITUDE','CENTER','SIGMA','OMEGA','PHASE']

            ;SET THE START ARRAY
            start = parms


            ;INITIALIZE THE parinfo ARRAY
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)


            parinfo[*].value = start

            ;ASSIGN THE SELECTED PARAMETERS TO BE FIXED.
            if (n_elements(fixed) ne 6) then begin
                parinfo[*].fixed = [0,0,0,1,1,1]
            endif else begin
                parinfo[*].fixed = fixed
            endelse


            if (n_elements(parmlims) ne 12) then begin
                parinfo[*].limits = lims
            endif else begin
                parinfo[*].limits = parmlims
            endelse

            parinfo[*].parname = names


            ;RUN THE FIT
            parms = mpfitfun('chirpFun', x, y, sy, start, $
                                                parinfo = parinfo, $
                                                perror=perror, /QUIET)


            result = [parms,perror]


            ;CHECK RESULTING CHISQ.
            if self->chisqtest(y,sy,tauind,parms) lt $
                    (*self.chisq)[yind*self.x_dim + xind,tauind] then begin

                ;print,'SUCCESSFULLY LOWERED CHISQ'

            endif

            ;SET VALUE OF CHI-SQUARED FOR THIS PIXEL,TAU
            (*self.chisq)[yind*self.x_dim + xind,tauind]$
                                = self->chisqtest(y,sy,tauind,parms)

            ;ASSIGN RESULTS OF INDIVIDUAL FITS TO fitparms
            ;ELEMENT AS FITS ARE DONE
            (*self.fitparms)[*,self.x_dim*yind+xind,tauind] = result

            self->setfitdisplaymask,xind,yind,tauind,value=1
            return,result
        endif else begin
            ;IN CASE OF POOR STATISTICS
            self->setfitdisplaymask,xind,yind,tauind,value=0
            return,0
        endelse
    endif else begin
        ;print,"Stats not too bad."
    endelse

end;chirpPhaseReFit
pro ooEcho::check360a,i,j,k,io,jo,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::check360a
;
;PURPOSE:
;           AFTER A FIT IS COMPLETE, FUN THROUGH ALL
;           OF THE PHASES IN 360deg MULTIPLES AND SEE
;           WHICH GIVES THE BEST chisq
;PARAMETERS:
;       i   pixel indices
;       j
;       k   Fourier time index
;       io  Center indices
;       jo
;KEYWORDS:
;       none

    ;self->addTreatment,'ooEcho::check360a'
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 


    ;AFTER A FIT IS COMPLETE, FUN THROUGH ALL
    ;OF THE PHASES IN 360deg MULTIPLES AND SEE
    ;WHICH GIVES THE BEST chisq

    ;print,i,j,k
    startparms = (self->fitvals(i,j,k))[0:5]
    phase1 = startparms[2]
    x = self->chirpPhases(k)
    y = self->chirp(i,j,k)
    sy= sqrt(y)

    csq = dblarr(7)+1.0
    for n=-3,3 do begin

        startparms[2] = phase1 + n*360.0
        if (startparms[2] ge min(x) and startparms[2] le max(x)) then begin
            temp = self->chirpFit(i,j,k,fixed=fixed,startparms=startparms,tavestate=tavestate)
            if(n_elements(temp) gt 1) then begin
                csq[n+3] = self->chisqtest(y,sy,k,temp)
            endif else begin
                csq[n+3] = 1.0
            endelse
        endif else begin
            csq[n+3] = 1000000.0
        endelse

    endfor
    csqmin = min(csq,minIndex)
    if (csqmin eq 1.0) then begin
        startparms[2] = 0
    endif else begin
        startparms[2] = phase1 + (minIndex-3)*360.0
        temp = self->chirpFit(i,j,k,fixed=fixed,startparms=startparms,tavestate=tavestate)
    endelse


end;check360a

pro ooEcho::check360,i,j,k,io,jo,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::check360
;
;PURPOSE:
;       Check that phases are within 360deg of the next closer one to the center.
;       NOTE: This may no longer be used, but use the treatment pointer to check.
;PARAMETERS:
;       i   pixel indices
;       j
;       k   Fourier time index
;       io  Center indices
;       jo
;KEYWORDS:
;       none

    ;self->addTreatment,'ooEcho::check360'

    if (i lt io) then itemp = i+1
    if (i gt io) then itemp = i-1
    if (i eq io) then itemp = io
    if (j lt jo) then jtemp = j+1
    if (j gt jo) then jtemp = j-1
    if (j eq jo) then jtemp = jo


    phaseo = (*self.fitparms)[2,self.x_dim*jtemp+itemp,k]
    phase1 = (*self.fitparms)[2,self.x_dim*j+i,k]


    if (phase1 - phaseo) gt 180.0 then phase1 = phase1 - 360.0
    if (phase1 - phaseo) lt -180.0 then phase1 = phase1 + 360.0

    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k]
    startparms[2] = phase1
    temp = self->chirpFit(i,j,k,fixed=fixed,startparms=startparms,tavestate=tavestate)


end;check360


pro ooEcho::raise360,tauind=tauind,_Extra=extra
;
;NAME:
;        ooEcho::raise360
;
;PURPOSE:
;       Raise the values of the phases stored in fitparms by 360deg prior to refit
;       when the values appear to be 360deg too low.
;PARAMETERS:
;       none
;KEYWORDS:
;       none

    ;self->addTreatment,'ooEcho::raise360'

    ;RAISE ALL PHASES IN fitparms BY 360deg
    ;FOR GLOBAL REFIT
    self->storefitparms
    sz = size(*self.fitparms)


    if n_elements(tauind) eq 0 then begin
        (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] + 360.0
        (*self.fitparms)[8,*,*] = 0.0
    endif else begin
        if tauind ge sz[3] then begin
            void = dialog_message('Fourier time index is too high, shifting all phases.')
            (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] + 360.0
            (*self.fitparms)[8,*,*] = 0.0
        endif else begin
            (*self.fitparms)[2,*,tauind] = (*self.fitparms)[2,*,tauind] + 360.0
            (*self.fitparms)[8,*,tauind] = 0.0
        endelse

    endelse
end;raise360
pro ooEcho::lower360,tauind=tauind,_Extra=extra
;
;NAME:
;        ooEcho::lower360
;
;PURPOSE:
;       Lower the values of the phases stored in fitparms by 360deg prior to refit
;       when the values appear to be 360 deg too high.
;PARAMETERS:
;       none
;KEYWORDS:
;       none
    ;self->addTreatment,'ooEcho::lower360'

    ;LOWER ALL PHASES IN fitparms BY 360deg
    ;FOR GLOBAL REFIT
    self->storefitparms
;    (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] - 360.0
;    (*self.fitparms)[8,*,*] = 0.0
    sz = size(*self.fitparms)


    if n_elements(tauind) eq 0 then begin
        (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] - 360.0
        (*self.fitparms)[8,*,*] = 0.0
    endif else begin
        if tauind ge sz[3] then begin
            void = dialog_message('Fourier time index is too high, shifting all phases.')
            (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] - 360.0
            (*self.fitparms)[8,*,*] = 0.0
        endif else begin
            (*self.fitparms)[2,*,tauind] = (*self.fitparms)[2,*,tauind] - 360.0
            (*self.fitparms)[8,*,tauind] = 0.0
        endelse

    endelse
end;lower360

pro ooEcho::fitAllFixedPhase,objFrom,$
                            tauind=tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            obj=obj,$
                            phaseoffset=phaseoffset,$
                            fitphaseoffset=fitphaseoffset,$
                            allownegamp=allownegamp,$
                            forcenegamp=forcenegamp,$
                            tavestate=tavestate,$
                            _Extra=extra
;
;NAME:
;        ooEcho::fitAllFixedPhase
;
;PURPOSE:
;           Fit everything with an imported set of phases and optionally periods.
;           The phases and/or the periods can be fixed during the fitting.
;PARAMETERS:
;           objFrom     The source of the phases (and periods.)
;KEYWORDS:
;            tauind         Optional specific Fourier time index.
;            fixed          Fitting information.
;            limited
;            startparms
;            parmlims
;            obj            Display object.
;            phaseoffset    Optional offset for the fitting
;            fitphaseoffset Flag to tell method to fit the phase offset at the central pixel(s)
;                           and apply that as a fixed parameter to all fits for the selected Fourier
;                           time.
;            allownegamp    Flag to tell tell method whether to allow small opposite-sign
;                           amplitudes in the fitting.
;            _Extra

    ;self->addTreatment,'ooEcho::fitAllFixedPhase'
;print,'ooEcho::fitAllFixedPhase'

    ;110304
    ;
    ;UPDATE THIS METHOD TO HAVE OPTION TO FIT OR
    ;NOT FIT THE PHASE OFFSET.  TYPICALLY STEVE WOULD CHOOSE
    ;TO SET THE PHASE OFFSET TO BE ZERO.  THIS OPTION
    ;SHOULD BE CHOOSABLE FROM THE GUI SO THAT THE
    ;FIXED/VARY DROPLIST ALLOWS THE USER TO DECIDE.

    ;IN THIS CASE fitAll001110 RECEIVES A PHASE SET
    ;FROM ANOTHER DATA OBJECT AND IT FITS THE CENTER PIXEL
    ;ALONE FIRST.
    ;ONCE THIS IS DONE, IT WILL SET fixed=[0,0,1,1,1,1]
    ;AND PROCEED WITH FITTING AS USUAL.
    ;THIS HAS THE EFFECT OF SIMPLY SHIFTING THE ENTIRE
    ;INPUT PHASE SURFACE BY THE AMOUNT GIVEN BY THE FIT
    ;AT THE CENTER PIXEL.

    ;PHASES ARE TRANSFERRED IN ooDisplayEcho::listEvents,event
    ;CALLED BY AN EVENT FROM THE phaseImportDialog USING THE
    ;PROCEDURE objTo->getInterpPhasesFrom,objFrom.
    ;SO WHEN THE PROGRAM GETS TO THE CURRENT METHOD,
    ;THE PHASES ARE ALREADY IN THE fitparms ARRAY.

    ;help,startParms
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    sz = size(*(self.e))
    if (n_elements(tauind) gt 0) then begin
        kend = tauind & kbegin = tauind
    endif else begin
        kend = sz[3]-1 & kbegin = 0
    endelse

    io = fix(self.x_dim/2) & jo = fix(self.y_dim/2)

    if n_elements(fixed) eq 6 then begin
        periodimport = fixed[4]
    endif else begin
        periodimport = 0
    endelse

    if n_elements(allownegamp) eq 0 then allownegamp = 1
    if n_elements(forcenegamp) eq 0 then forcenegamp = 0

    self->getInterpPhasesFrom,objFrom,periodimport = periodimport

    if forcenegamp eq 1 then begin
        print,'FORCE NEG AMP!!!!!'
        ;(*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] - 180.0
    endif


    ;PROGRESS BAR
;    b1 = widget_base(title='Fit with Imported Phases',xsize=200, $
;                             xoffset=400,yoffset=400)
;;    p1 = cw_progress(b1,value=[2,self.x_dim-1,self.y_dim-1,kend], $
;;                        title=['Step =','i =','j =','k ='])
;    p1 = nse_progress(b1,value=[2,self.x_dim-1,self.y_dim-1,kend], $
;                        title=['Step =','i =','j =','k =']);,dialog_parent=self.atlb)
;    widget_control,b1,/realize
;    ;xmanager,'cw_progress',p1,event_handler='cw_progress_event_pro'

    duh = checkforobjinstance('oodisplayecho',ref=ref)
    if duh ge 1 then begin
      dialog_parent = ref[0]->getproperty(/atlb)
    endif
    prog = nse_cwo_progress(labels=['Step:','i:','j:','k:'],$
                           startvalues=[0,0,0,0L],$
                           endvalues=[2,self.x_dim,self.y_dim,kend],$
                           values=[0,0,0,0L],$
                           steps=[1L,1,1,1],$
                           obj=progobj,$
                           title='Fit with Imported Phases:   ',$
                           dialog_parent=dialog_parent)






    ;DEFAULT IS TO FIX
    ;print,fixed
    ;print,n_elements(fixed)
    ;dum = dialog_message('n_elements(fixed)='+string(n_elements(fixed)))
    ;dum = dialog_message('fixed=['+string(fixed)+']')

    if n_elements(fixed) ne 6 then begin
        ;dum= dialog_message('Changing values of fixed to [0,0,1,0,1,1]')
        fixed = [0,0,1,0,1,1]
    endif

    ;dum = dialog_message('fixed=['+string(fixed)+']')
    for iv=0,5 do begin
        (*self.fixed)[iv,*,*] = fixed[iv]
    endfor;iv

    ;ALWAYS FIX PHASES TO IMPORTED VALUES IN THIS METHOD
;021705
;CHANGE NEXT LINE TO WORK WITH USER CHOICE.
    (*self.fixed)[2,*,*] = fixed[2] ;1
    (*self.fitparms)[8,*,*] = 0.0   ;SET dPHASE TO 0
    (*self.fitparms)[11,*,*] = 0.0  ;SET dPHASEOFFSET TO 0


    if n_elements(omega) eq 0 then omega = 1.0
    ;SET ALL OMEGAS TO SAME VALUE PRIOR TO FIT
;021705
;CHANGE NEXT LINE TO WORK WITH USER CHOICE.
;IF periodimport IS 1 THEN USE IMPORTED PERIODS.
    (*self.fixed)[4,*,*] = fixed[4] ;1
    if periodimport eq 0 then begin
        (*self.fitparms)[4,*,*] = omega
    endif

    (*self.fitparms)[10,*,*] = 0.0

    if n_elements(phaseoffset) eq 0 then phaseoffset = 0.0
    ;SET ALL PHASE OFFSETS TO SAME VALUE PRIOR TO FIT
    (*self.fitparms)[5,*,*] = phaseoffset
    (*self.fitparms)[11,*,*] = 0.0

    if n_elements(fitphaseoffset) eq 0 then fitphaseoffset = 0
    if fitphaseoffset eq 1 then fixed[5] = 0

;NEED TO SET UP TO FIT THE PHASE OFFSET FOR THE CENTRAL PIXEL
;FOR EACH FOURIER TIME.

            ;SET ALL PHASE OFFSETS TO SAME VALUE
            (*self.fitparms)[5,*,*] = 0.0;$
                            ;(*self.fitparms)[5,self.x_dim*jo+io,k]
            (*self.fitparms)[11,*,*] = 0.0;$
                            ;(*self.fitparms)[11,self.x_dim*jo+io,k]


        ;CHECK PHASES AND FLIP BY 180 FROM RESOLUTION IF NECESSARY
        tempparms = self->startparms(io,jo,0,fixed=fixed,$
                                     startparms=startparms,$
                                     hydrogenated=hydrogenated,tavestate=tavestate)

;        if hydrogenated eq 1 and allownegamp eq 0 then begin
;;            (*self.fitparms)[1,*,*] = -abs((*self.fitparms)[1,*,*])
;            (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] - 180.0
;        endif


    ;FIT CENTRAL PIXEL(S) WITH PHASE OFFSET VARIED
    ;ONLY IF PHASE OFFSET IS NOT CHOSEN TO BE FIXED
    ;
    ;SET ALL PHASE OFFSET VALUES HERE IF THIS STATEMENT IS
    ;EXECUTED.
    if fixed[5] eq 0 then begin
        for k=kbegin,kend do begin

            if fitphaseoffset eq 0 then begin
                ;print,'fitphaseoffset=',fitphaseoffset
                ;SET ALL PHASE OFFSETS TO SAME VALUE (namely 0.0)
                (*self.fitparms)[5,*,k] = 0.0;$
                                ;(*self.fitparms)[5,self.x_dim*jo+io,k]
                (*self.fitparms)[11,*,k] = 0.0;$
                                ;(*self.fitparms)[11,self.x_dim*jo+io,k]
                fixed = (*self.fixed)[*,io+jo*self.x_dim,k]
                parms = self->startparms(io,jo,k,fixed=fixed,startparms=startparms,hydrogenated=hydrogenated,tavestate=tavestate)
                temp = self->chirpFit(io,jo,k,fixed=fixed,$
                            startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k],$
                            /suppress,hydrogenated=hydrogenated,$
                            allownegamp = allownegamp,$
                            forcenegamp=forcenegamp,tavestate=tavestate)
            endif else begin
                ;print,'fitphaseoffset=',fitphaseoffset
                ;FIT PHASE OFFSET
                fixed[5] = 0    ;VARY PHASE OFFSET
                fixed[2] = 1    ;FIX PHASE
                ;fixed[4] = 1    ;FIX PERIOD
                ;print,fixed

                ;FIT CENTRAL 4 PIXELS TO GET THE OFFSET.
                theoffsets = dblarr(4)
                theoffsetsweights = dblarr(4)

;THE EXTRA CONTORTIONS TO SET THE fixed VALUES AT EACH PIXEL ARE NECESSARY
;DUE TO THE FACT THAT chirpFit GETS THE fixed VALUES FROM THE (*self.fixed)
;ARRAY INSTEAD OF FROM THE fixed=fixed KEYWORD.  THIS WAS DONE TO
;PROTECT fixed FROM HAVING ne 6 ELEMENTS.
                ;io,jo
                fixedo = (*self.fixed)[*,io+jo*self.x_dim,k]
                (*self.fixed)[*,io+jo*self.x_dim,k] = fixed
                temp = self->chirpFit(io,jo,k,fixed=fixed,$
                            startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k],$
                            /suppress,$
                            hydrogenated=hydrogenated,$
                            allownegamp = allownegamp,$
                            forcenegamp=forcenegamp,tavestate=tavestate)
                ;print,temp
                (*self.fixed)[*,io+jo*self.x_dim,k] = fixedo

                ;io-1,jo
                fixedo = (*self.fixed)[*,io-1+jo*self.x_dim,k]
                (*self.fixed)[*,io-1+jo*self.x_dim,k] = fixed

                if n_elements(temp) lt 6 then begin
                    theoffsets[0] = 0.0
                    theoffsetsweights[0] = 1.0e-12
                endif else begin
                    theoffsets[0] = temp[5]
                    theoffsetsweights[0] = temp[11]
                endelse
                temp = self->chirpFit(io-1,jo,k,fixed=fixed,$
                            startparms = (*self.fitparms)[0:5,self.x_dim*jo+io-1,k],$
                            /suppress,$
                            hydrogenated=hydrogenated,$
                            allownegamp = allownegamp,$
                            forcenegamp=forcenegamp,tavestate=tavestate)
                ;print,temp
                (*self.fixed)[*,io-1+jo*self.x_dim,k] = fixedo


                ;io,jo-1
                fixedo = (*self.fixed)[*,io+(jo-1)*self.x_dim,k]
                (*self.fixed)[*,io+(jo-1)*self.x_dim,k] = fixed

                if n_elements(temp) lt 6 then begin
                    theoffsets[1] = 0.0
                    theoffsetsweights[1] = 1.0e-12
                endif else begin
                    theoffsets[1] = temp[5]
                    theoffsetsweights[1] = temp[11]
                endelse
                temp = self->chirpFit(io,jo-1,k,fixed=fixed,$
                            startparms = (*self.fitparms)[0:5,self.x_dim*(jo-1)+io,k],$
                            /suppress,$
                            hydrogenated=hydrogenated,$
                            allownegamp = allownegamp,$
                            forcenegamp=forcenegamp,tavestate=tavestate)
                ;print,temp
                (*self.fixed)[*,io+(jo-1)*self.x_dim,k] = fixedo

                ;io-1,jo-1
                fixedo = (*self.fixed)[*,io-1+(jo-1)*self.x_dim,k]
                (*self.fixed)[*,io-1+(jo-1)*self.x_dim,k] = fixed

                if n_elements(temp) lt 6 then begin
                    theoffsets[2] = 0.0
                    theoffsetsweights[2] = 1.0e-12
                endif else begin
                    theoffsets[2] = temp[5]
                    theoffsetsweights[2] = temp[11]
                endelse
                temp = self->chirpFit(io-1,jo-1,k,fixed=fixed,$
                            startparms = (*self.fitparms)[0:5,self.x_dim*(jo-1)+io-1,k],$
                            /suppress,hydrogenated=hydrogenated,$
                            allownegamp = allownegamp,$
                            forcenegamp=forcenegamp,tavestate=tavestate)
                ;print,temp
                (*self.fixed)[*,io-1+(jo-1)*self.x_dim,k] = fixedo

                if n_elements(temp) lt 6 then begin
                    theoffsets[3] = 0.0
                    theoffsetsweights[1] = 1.0e-12
                endif else begin
                    theoffsets[3] = temp[5]
                    theoffsetsweights[3] = temp[11]
                endelse

;                (*self.fixed)[2,io+jo*self.x_dim,k] = 1
;                (*self.fixed)[5,io+jo*self.x_dim,k] = 1
                (*self.fixed)[2,*,k] = 1
                (*self.fixed)[5,*,k] = 1
                fixed = (*self.fixed)[*,io+jo*self.x_dim,k]

;LRK - 05/30/12  UPDATE TO USE WEIGHTED AVERAGE FOR PHASE OFFSET CALCULATION
;                momt = moment(theoffsets)

                theweights = 1.0/theoffsetsweights^2
                momtnew = total(theoffsets*theweights)/total(theweights)
                smomtnew = sqrt(total((theoffsets*theweights)^2))/total(theweights)

;                ;print,momt[0],'+/-',sqrt(momt[1])
;                (*self.fitparms)[5,*,k]  = momt[0]
;                (*self.fitparms)[11,*,k] = sqrt(momt[1])

;LRK - 05/30/12  UPDATED TO USE WEIGHTED AVERAGE FOR PHASE OFFSET CALCULATION
                (*self.fitparms)[5,*,k]  = momtnew
                (*self.fitparms)[11,*,k] = smomtnew



                temp = self->chirpFit(io,jo,k,fixed=fixed,$
                            startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k],$
                            /suppress,hydrogenated=hydrogenated,$
                            allownegamp = allownegamp,$
                            forcenegamp=forcenegamp,tavestate=tavestate)

            endelse;fitphaseoffset ne 0

        endfor;k
        ;UPDATE PROGRESS
        ;widget_control,p1,set_value=[1,0,0,0]
        ;widget_control,p1,set_value=[1]
        progobj->set,0,1
        stopped = progobj->checkstop()
        if stopped ne 0 then begin
          widget_control,prog,/destroy
          return
        endif
        
    endif;fixed[5] eq 0


    ;FIX PHASE OFFSET AT THIS POINT.
;    fixed = [0,0,1,1,1,1]
    phaseoffsetfixedold = fixed[5]
    (*self.fixed)[5,*,*] = 1
    for k=kbegin,kend do begin
        ;io = fix(self.x_dim/2) & jo = fix(self.y_dim/2)

;        ;LRK - 06/29/09
;        ;LOOK AT THE SPECIAL CASE WHERE fixed eq [0,0,1,1,1,1]
;        fixed = (*self.fixed)[*,io+jo*self.x_dim,k]
;        if fixed[0] eq 0 and fixed[1] eq 0 and fixed[2] eq 1 and fixed[3] eq 1 and fixed[4] eq 1 and fixed[5] eq 1 then begin
;          help,*self.e,*self.phase
;          
;        endif else begin;06/29/09



                      ;GET ROUGH STARTING PARAMETERS FROM DATA
                      for i=0,self.x_dim-1 do begin
                          for j=0,self.y_dim-1 do begin
                              fixed = (*self.fixed)[*,i+j*self.x_dim,k]
                              ;print,'4704 ooecho::fitallfixedphase fixed=',fixed
              
              ;021705
              ;ELIMINATE THIS NEXT BLOCK AND ITS ACCOMPANYING endelse
              ;SINCE IT IS NOT NEEDED FOR IMPORTED PHASES.
              ;
              ;                if(i eq io and j eq jo) then begin
              ;                    ;IN CASE A PARAMETER IS PEGGED AT CENTRAL PIXEL
              ;                    self->fitAllUnpeg,io,jo,io,jo,k,$
              ;                                fixed,limited,parmlims
              ;                    ;do nothing
              ;                endif else begin
              
              
              ;111405
              ;THE NEXT LINE SHOULD BE GT 0 SINCE USER MASKING HAS VALUE eq -1!!!
                                  if ((*(self.mask2d))[j*self.x_dim+i,k] gt 0) then begin;ne 0) then begin
              
              ;021705
              ;ADD THE NEXT STATEMENT SINCE THE NEXT ONE RESETS THE STARTING PARAMETERS
              ;IN self.fitparms!!!!
              
                                      startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k]
                                      savestartparms = (*self.fitparms)[0:5,self.x_dim*j+i,k]
                                      parms = $
                                              self->startparms(i,j,k,fixed=fixed,$
                                                                  startparms=startparms,hydrogenated=hydrogenated,tavestate=tavestate)
                                      startparms[0] = parms[0]
                                      startparms[1] = parms[1]
                                      startparms[2] = savestartparms[2]
                                      startparms[3] = parms[3]
                                      if periodimport eq 0 then begin
                                          startparms[4] = parms[4]
                                      endif else begin
                                          startparms[4] = savestartparms[4]
                                      endelse
                                      startparms[5] = parms[5]
              
                                      (*self.fitparms)[0:5,self.x_dim*j+i,k] = startparms
              
                                      temp = self->chirpFit(i,j,k,fixed=fixed,$
                                                            startparms = $
                                                            (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                                                            /suppress,$
                                                            hydrogenated=hydrogenated,$
                                                            allownegamp = allownegamp,$
                                                            forcenegamp=forcenegamp,tavestate=tavestate)
              
              
              
              
                                      ;widget_control,p1,set_value=[1,i,j,k]
                                      progobj->set,1,i
                                      progobj->set,2,j
                                      progobj->set,3,k
                                      stopped = progobj->checkstop()
                                      if stopped ne 0 then begin
                                        widget_control,prog,/destroy
                                        return
                                      endif

                                  endif;mask2d
              ;                endelse
                          endfor;j
                      endfor;i
 ;       endelse;06/29/09
        ;UPDATE PROGRESS
        ;widget_control,p1,set_value=[1,self.x_dim-1,self.y_dim-1,k]
        progobj->set,1,self.x_dim
        progobj->set,2,self.y_dim
        progobj->set,3,k
        stopped = progobj->checkstop()
        if stopped ne 0 then begin
          widget_control,prog,/destroy
          return
        endif


        ;REINSTATE ERROR BARS FOR THE OFFSET FOR ALL PIXELS
        ;SINCE THEY ARE LOST IN THE FIT PROCEDURE WHEN
        ;THE PARAMETERS ARE NOT VARIED
        (*self.fitparms)[11,*,k] = (*self.fitparms)[11,self.x_dim*jo+io,k]

        ;RESTORE fixed VALUE FOR PHASE OFFSET
        (*self.fixed)[5,*,*] = phaseoffsetfixedold

        ;UPDATE OBJECT DISPLAY IF AVAILABLE
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

        ;THERE ARE NO CHANGES TO THE PHASE SURFACE, SO THERE
        ;IS NO REASON TO CHECK IT FURTHER.

    endfor;k

    ;widget_control,p1,set_value=[2,self.x_dim-1,self.y_dim-1,kend]
    progobj->set,1,self.x_dim
    progobj->set,2,self.y_dim
    progobj->set,3,kend
    widget_control,prog,/destroy


    ;widget_control,b1,/destroy
    self.reduced = 1    ;INDICATE THAT THE FILE HAS BEEN REDUCED
    self.IupdownSwitch = 1
;help,/traceback
end;fitAllFixedPhase


pro ooEcho::fitAll4,chiswitch,$;,tauind=tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            obj=obj,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::fitAll4
;
;PURPOSE:
;       Fit everything using expand method.
;PARAMETERS:
;       chiswtich
;KEYWORDS:
;        fixed
;        limited
;        startparms
;        parmlims
;        obj

    ;self->addTreatment,'ooEcho::fitAll4'
if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

;print,'ooEcho::fitAll4'
    sz = size(*(self.e))
    kend = sz[3]-1 & kbegin = 0
    parinfo = replicate({value:0.0d,$
                        fixed:0,$
                        limited:[1,1], $
                        limits:[0.0d,0.0d],$
                        parname:'',tied:''},$
                        6)



    ;FIT k=0 CENTRAL PIXEL --- THIS IS DONE IN THE IGOR SOFTWARE.
    io = fix(self.x_dim/2) & jo = fix(self.y_dim/2)
    if chiswitch gt 0 then begin
        parms = self->startparms(io,jo,0,fixed=fixed,startparms=startparms,tavestate=tavestate)
        temp = self->chirpFit9ChiSq(io,jo,0,fixed=fixed,$
                startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,0],$
                parinfo=parinfo,tavestate=tavestate)
    endif;chiswitch

    ;FIT ALL PIXELS

    if checkforobjinstance('oodisplayecho',ref=notifyobj) gt 0 then begin
        notifyme = notifyobj->getproperty(/atlb)
    endif else notifyme = 0L

    ;PROGRESS BAR
    b1 = widget_base(title='Phase v Pixel',xsize=200, $
                             xoffset=400,yoffset=400)
    ;p1 = cw_progress(b1,value=[kend],title=['Tau Index ='],notify_id=notifyme);,/stopbutton)
    p1 = nse_progress(b1,value=[kend],title=['Tau Index ='],notify_id=notifyme);,dialog_parent=self.atlb);,/stopbutton)

    widget_control,b1,/realize

to = systime(1,/seconds)
    ;BEGIN FIT LOOP

    ;FIT 0th FOURIER TIME
    self->fitAll3a,tauind=0,$
            fixed=fixed,$
            limited=limited,$
            startparms=startparms,$
            parmlims=parmlims,$
            obj=obj,parinfo=parinfo,tavestate=tavestate

    if sz[3] gt 1 then begin
        for k=1,kend do begin
            widget_control,p1,set_value=[k]

;                if widget_info(b1,/valid_id) gt 0 then begin
;                    e = widget_event(b1,/nowait)
;                endif else break
;                if tag_names(e,/structure_name) eq 'WIDGET_BUTTON' then $
;                    testbounce_event,e

            ;IMPORT PHASE SURFACE FROM k-1 FOURIER TIME.
            (*(self.fitparms))[2,*,k] = (*(self.fitparms))[2,*,k-1]
            self->fitAll4a,tauind=k,$
                    fixed=fixed,$
                    limited=limited,$
                    startparms=startparms,$
                    parmlims=parmlims,$
                    obj=obj,parinfo=parinfo,tavestate=tavestate
;print,systime(1,/seconds)-to

        endfor;k
    endif

    widget_control,b1,/destroy


    self.reduced = 1    ;INDICATE THAT THE FILE HAS BEEN REDUCED









end;fitAll4

pro ooEcho::fitAll4a,tauind=tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            obj=obj,parinfo=parinfo,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::fitAll4a
;
;PURPOSE:
;       Fitall method for a selected Fourier time index.
;PARAMETERS:
;           tauind
;           fixed
;           limited
;           startparms
;           parmlims
;           obj
;           parinfo
;KEYWORDS:
;           none

    ;self->addTreatment,'ooEcho::fitAll4a'


    ;;
    ;START FITTING AT CENTER AND THEN MOVE
    ;OUT FROM THERE USING EACH FIT RESULTS AS
    ;THE STARTING PARAMETERS FOR THE NEXT FIT.
    ;;;

    if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)
    endif



    sz = size(*(self.e))
    if (n_elements(tauind) gt 0) then begin
        kend = tauind & kbegin = tauind
    endif else begin
        kend = sz[3]-1 & kbegin = 0
    endelse



    for k=kbegin,kend do begin

        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;TAKE A STEP BACK AND JUST PUT THE STARTING
        ;FIT PARMS IN THE FIT PARM MATRIX BASED ON THE
        ;amplitude, offset and

;        print,'GETTING ROUGH FIT PARAMETERS',k,': using self->startParms'
        io = self.x_dim/2-1 & jo = self.y_dim/2-1



        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                ;GET ROUGH STARTING PARAMETERS FROM DATA
                if i eq io and j eq jo then begin
                endif else begin
                    parms = self->startparms(i,j,k,fixed=fixed,startparms=startparms,tavestate=tavestate)
                endelse
            endfor;j
        endfor;i

        ;GET PHASES FROM THE k-1 PHASE SURFACE.
        (*(self.fitparms))[2,*,k] = (*(self.fitparms))[2,*,k-1]


        ;UPDATE OBJECT DISPLAY OF AVAILABLE
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

        ;void = dialog_message('Pause')
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        ;FIT CENTRAL PIXEL AND ASSIGN TO startparms FOR NEXT LAYER
        ;LET chirpFit CHOOSE startparms
        io = self.x_dim/2-1 & jo = self.y_dim/2-1
        temp = self->chirpFit(io,jo,k,fixed=fixed,$
                                limited=limited,$
                                parmlims=parmlims,/suppress,tavestate=tavestate)




;;;;;        self->check180,io,jo,k
;;;;;        if (n_elements(obj) gt 0) then begin
;;;;;            obj->draw
;;;;;        endif
;;;;;        ;void = dialog_message('Pause')
;;;;;;        print,'READJUSTING ROUGH FIT PARAMETERS',k,': using self->check180'
;;;;;        self->check180,io,jo,k
;;;;;        if (n_elements(obj) gt 0) then begin
;;;;;            obj->draw
;;;;;        endif
;;;;;        ;void = dialog_message('Pause')
;;;;;
;;;;;
;;;;;
;;;;;;        print,'FITTING ECHOS FROM READJUSTED PARAMETERS',k,': using self->chirpFit'
        if kbegin eq kend then begin
            beven = widget_base(xoffset=200,yoffset=200)
;            peven = cw_progress(beven,value=[self.x_dim-1,self.y_dim-1,4],$
;                            title=['X Index =','Y Index =','Check ='])
            peven = nse_progress(beven,value=[self.x_dim-1,self.y_dim-1,4],$
                            title=['X Index =','Y Index =','Check =']);,dialog_parent=self.atlb)

            widget_control,beven,/realize
        endif;kbegin eq kend

        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                if i eq io and j eq jo then begin
                endif else begin
                    if ((*(self.mask2d))[j*self.x_dim+i,k] ne 0) then begin
                        temp = self->chirpFit(i,j,k,fixed=fixed,$
                                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                                    parinfo=parinfo,/suppress,tavestate=tavestate)
                        ;temp = self->chirpAmpReFit(i,j,k,fixed=fixed)

;                        if (*self.mask2d)[j*self.x_dim + i,k] ne 0 then begin
                          if (*self.chisq)[j*self.x_dim + i,k] gt 100.0 then begin
                            ;062304
                            ;CORRECT AMPLITUDE AND PHASE IF FIT IS BAD.
                            startparms = (*(self.fitparms))[0:5,j*self.x_dim + i,k]
                            if k gt 0 then begin
                                startparms[1,j*self.x_dim + i,k] = startparms[1,j*self.x_dim + i,k-1]
                                startparms[2,j*self.x_dim + i,k] = startparms[2,j*self.x_dim + i,k-1]
                            endif

                            temp = self->chirpFit(i,j,k,fixed=fixed,$
                                                    limited=limited,$
                                                    parmlims=parmlims,$
                                                    startparms=startparms,/suppress,tavestate=tavestate)
                            ;for n=0,1 do begin
                            ;    if (*self.chisq)[j*self.x_dim + i,k] gt 100.0 $

        ;082304
        ;STICK THIS HERE TO CHECK THAT PARAMETERS ARE NOT PEGGED.
            self->fitAllUnpeg,io,jo,i,j,k,fixed,limited,parmlims,tavestate=tavestate

    ;;COMMENTED OUT 082304
    ;;                            choke = 0
    ;;                            while( ((*(self.chisq))[j*self.x_dim + i,k] gt 100.0) $
    ;;                                    or ((*(self.fitparms))[1,j*self.x_dim + i,k] lt 1.0) $
    ;;                                        or (abs((*(self.fitparms))[2,j*self.x_dim + i,k]) gt 1000.0) $
    ;;                                        and choke lt 10) $
    ;;                                        do begin;then begin
    ;;                                        choke = choke + 1
    ;;
    ;;
    ;;                                ;JUST CORRECT AMPLITUDE IF FIT IS STILL BAD
    ;;                                startparms = (*(self.fitparms))[0:5,j*self.x_dim + i,k]
    ;;
    ;;                ;072904
    ;;                ;CREATE AN AVERAGE FUNCTION FROM THE self->chirp FUNCTION
    ;;
    ;;                                ;IN CASE CONSTANT IS PEGGED
    ;;                                if ((*(self.fitparms))[6,j*self.x_dim + i,k] eq 0.0) or $
    ;;                                   ((*(self.fitparms))[0,j*self.x_dim + i,k] eq 5.0) then $
    ;;                                        startparms[0] = self->chirpMean(i,j,k)
    ;;                                ;IN CASE AMPLITUDE PEGGED
    ;;                                if ((*(self.fitparms))[7,j*self.x_dim + i,k] eq 0.0) or $
    ;;                                   ((*(self.fitparms))[1,j*self.x_dim + i,k] eq 0.1) then $
    ;;                                        startparms[1] = self->chirpMean(i,j,k)
    ;;                                ;startparms[1] = 100.0
    ;;                                ;IN CASE PHASE PEGGED
    ;;                                if abs((*(self.fitparms))[2,j*self.x_dim + i,k]) gt 1000.0 then $
    ;;                                     startparms[2] = (*(self.fitparms))[2,jo*self.x_dim + io,k]
    ;;                                ;print,i,j,k
    ;;                                temp = self->chirpFit(i,j,k,fixed=fixed,$
    ;;                                                        limited=limited,$
    ;;                                                        parmlims=parmlims,$
    ;;                                                        startparms=startparms,/suppress)
    ;;
    ;;                        endwhile
                            ;    endif
                            ;endfor;n
                          endif;chisq
                    endif;self.mask2d



                    ;UPDATE POSSIBLE STATUS BAR
                    if widget_info(peven,/valid_id) ne 0 then begin
                        widget_control,peven,set_value=[i,j,0]
                    endif;peven valid

                endelse
            endfor;j
        endfor;i
        ;UPDATE OBJECT DISPLAY OF AVAILABLE
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

        ;void = dialog_message('Pause')



;;;;;    ;
;;;;;    ;
;;;;;    ;
;;;;;    ;CHECK180FIT IS VERY SLOW!!!!!!!!
;;;;;    ;
;;;;;    ;
;;;;;;        print,'ADJUSTING FITTED ECHO POINTS AND REFITTING AS NECESSARY',k,': using self->check180Fit'
;;;;;        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo
;;;;;        if (n_elements(obj) gt 0) then begin
;;;;;            obj->draw
;;;;;        endif
;;;;;        ;UPDATE POSSIBLE STATUS BAR
;;;;;        if widget_info(peven,/valid_id) ne 0 then begin
;;;;;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,1]
;;;;;        endif;peven valid
;;;;;;        print,'DOUBLE-CHECKING AND REFITTING AS NECESSARY',k,': using self->check180Fit'
;;;;;        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo
;;;;;        if (n_elements(obj) gt 0) then begin
;;;;;            obj->draw
;;;;;        endif
;;;;;        ;UPDATE POSSIBLE STATUS BAR
;;;;;        if widget_info(peven,/valid_id) ne 0 then begin
;;;;;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,2]
;;;;;        endif;peven valid
;;;;;;        print,'TRIPLE-CHECKING AND REFITTING AS NECESSARY',k,': using self->check180Fit'
;;;;;        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo
;;;;;        if (n_elements(obj) gt 0) then begin
;;;;;            obj->draw
;;;;;        endif
;;;;;        ;UPDATE POSSIBLE STATUS BAR
;;;;;        if widget_info(peven,/valid_id) ne 0 then begin
;;;;;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,3]
;;;;;        endif;peven valid
;;;;;
;;;;;;        print,'FOURPLE-CHECKING AND REFITTING AS NECESSARY',k,': using self->check180Fit'
;;;;;        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo
;;;;;        if (n_elements(obj) gt 0) then begin
;;;;;            obj->draw
;;;;;        endif
        ;UPDATE POSSIBLE STATUS BAR
        if widget_info(peven,/valid_id) ne 0 then begin
            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,4]
        endif;peven valid



;;;;;        ;READJUST WITH NO FIT
;;;;;        self->check180,io,jo,k
;;;;;        if (n_elements(obj) gt 0) then begin
;;;;;            obj->draw
;;;;;        endif
;;;;;
;;;;;;        print,'FITTING ECHOS FROM READJUSTED PARAMETERS',k,': using self->chirpFit'
;;;;;        for i=0,self.x_dim-1 do begin
;;;;;            for j=0,self.y_dim-1 do begin
;;;;;                if i eq io and j eq jo then begin
;;;;;                endif else begin
;;;;;                    temp = self->chirpFit(i,j,k,fixed=fixed,$
;;;;;                                startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
;;;;;                                parinfo=parinfo,/suppress)
;;;;;                endelse
;;;;;            endfor;j
;;;;;        endfor;i

        ;DESTROY POSSIBLE STATUS WINDOW
        if widget_info(beven,/valid_id) gt 0 then begin
            widget_control,beven,/destroy
        endif
    endfor;k


    self.reduced = 1    ;INDICATE THAT THE FILE HAS BEEN REDUCED

end;fitAll4a

pro ooEcho::fitAllUnpeg,io,jo,i,j,k,fixed,limited,parmlims,noborrow=noborrow,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::fitAllUnpeg
;
;PURPOSE:
;       Refit pixels with pegged fitparms.
;
;       NOTE: THIS FITS A SINGLE ECHO CURVE.
;
;PARAMETERS:
;       io      Central pixel indices
;       jo
;       i       Pixel indices
;       j
;       k       Fourier time index
;       fixed
;       limited
;       parmlims
;KEYWORDS:
;       none

    ;self->addTreatment,'ooEcho::fitAllUnpeg'
if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 
if n_elements(noborrow) eq 0 then noborrow = 0
;print,'FitAllUnpeg'

;112706
szfixed = size(fixed)

case szfixed[0] of
1:begin
    myfixed = fixed
end;1
2:begin
    myfixed = reform(fixed[*,j*self.x_dim + i],6)
end;2
3:begin
    myfixed = reform(fixed[*,j*self.x_dim + i,k],6)
end;3
else:
endcase

;LEAVE AS IS, JUST IN CASE THERE ARE SOME BAD CASES COMING THROUGH.
if n_elements(myfixed) ne 6 then begin
    print,'ooEcho::fitAllUnpeg --- INCORRECT NUMBER OF ELEMENTS IN "fixed".'
    print,'ooEcho::fitAllUnpeg --- SETTING fixed = [0,0,0,1,0,1]
    myfixed = [0,0,0,1,0,1]

endif




        choke = 0
        while( ((*(self.chisq))[j*self.x_dim + i,k] gt 100.0) $
            or ((*(self.fitparms))[1,j*self.x_dim + i,k] lt 1.0) $
                or (abs((*(self.fitparms))[2,j*self.x_dim + i,k]) gt 1000.0) $
                or (abs((*(self.fitparms))[0,j*self.x_dim + i,k]) eq 5.0) $
                or (abs((*(self.fitparms))[4,j*self.x_dim + i,k]) eq 0.1) $
                and choke lt 5) $
                do begin;then begin
                choke = choke + 1


        ;JUST CORRECT AMPLITUDE IF FIT IS STILL BAD
        startparms = (*(self.fitparms))[0:5,j*self.x_dim + i,k]

        ;072904
        ;CREATE AN AVERAGE FUNCTION FROM THE self->chirp FUNCTION

        ;IN CASE CONSTANT IS PEGGED
        if ((*(self.fitparms))[6,j*self.x_dim + i,k] eq 0.0) or $
           ((*(self.fitparms))[0,j*self.x_dim + i,k] eq 5.0) then $
                startparms[0] = self->chirpMean(i,j,k)
        if ((*(self.fitparms))[0,j*self.x_dim + i,k] eq 5.0) then $
                startparms[0] = self->chirpMean(i,j,k)
        if ((*(self.fitparms))[6,j*self.x_dim + i,k] eq 0.0) then $
                startparms[0] = self->chirpMean(i,j,k)
        ;IN CASE AMPLITUDE PEGGED
        if ((*(self.fitparms))[7,j*self.x_dim + i,k] eq 0.0) or $
           ((*(self.fitparms))[1,j*self.x_dim + i,k] eq 0.1) then $
                startparms[1] = self->chirpMean(i,j,k)
        if ((*(self.fitparms))[1,j*self.x_dim + i,k] eq 0.1) then $
                startparms[1] = self->chirpMean(i,j,k)
        if ((*(self.fitparms))[7,j*self.x_dim + i,k] eq 0.0) then $
                startparms[1] = self->chirpMean(i,j,k)
        ;startparms[1] = 100.0
        ;IN CASE PHASE PEGGED

        if noborrow eq 0 then begin
            if myfixed[2] ne 1 then begin
                if abs((*(self.fitparms))[2,j*self.x_dim + i,k]) gt 1000.0 then $
                     startparms[2] = (*(self.fitparms))[2,jo*self.x_dim + io,k]
            endif;fixed[2]
        endif
        if myfixed[4] ne 1 then begin
            ;IN CASE PERIOD IS PEGGED
            if ((*(self.fitparms))[10,j*self.x_dim + i,k] eq 0.0)   or $
               ((*(self.fitparms))[4,j*self.x_dim + i,k] eq 0.1)    or $
                ((*(self.fitparms))[1,j*self.x_dim + i,k] lt 0.857) or $
                ((*(self.fitparms))[1,j*self.x_dim + i,k] gt 1.2)   then $
                    startparms[4] = 1.0
        endif;myfixed[4]

        ;print,i,j,k
        temp = self->chirpFit(i,j,k,fixed=myfixed,$
                limited=limited,$
                parmlims=parmlims,$
                startparms=startparms,/suppress,tavestate=tavestate)

    endwhile
end;fitAllUnpeg
;

pro ooEcho::calculateIndexMatrix,QValues=QValues,mat=mat,_Extra=extra
;
;NAME:
;        ooEcho::calculateIndexMatrix
;
;PURPOSE:
;       Calculate a matrix of indices of Q values.
;PARAMETERS:
;       none
;KEYWORDS:
;       QValues The array of Q values.
;       mat     The return matrix

    ;self->addTreatment,'ooEcho::calculateIndexMatrix'



;CALCULATES AN INDEX MATRIX FOR SELECTION
;OF INPUT PHASES FROM THE CENTER LINE OF PIXELS.


;SET THIS UP TO CALCULATE BOTH Q VALUES AND THE
;INDEX MATRIX GIVEN THE NECESSARY INPUT PARAMETERS????

;SET THE INDEX MATRIX TO VALUES BASED ON THE
;HORIZONTAL CENTRAL AXIS.  MOD THE QValues
;WITH THE CENTRAL HORIZON VALUES.


;CALCULATE QValues IF NOT GIVEN

    if n_elements(QValues) eq 0 then begin

        ;Print,'TEST'
        ;sz = [2,8,8]
        icen = self.x_cen_orig
        jcen = self.y_cen_orig
        ;print,'[icen,jcen]=',icen,jcen
        lambda = self.lambda
        ;print,'lambda=',lambda
        qo = self.qactual;q
        ;print,'qo=',qo
        mToAng = (10.0d)^(10.0d)

        szQVals = size(*self.QVals)

        ;GET 1-D MATRIX FROM self
        qvals = (*self.QVals)[*,0,*]
        ;help,qvals

        qvals = reform(qvals,self.x_dim,self.y_dim)

        thetao = asin(lambda*mToAng * qo/(4.0*!PI))
        sz = size(qvals)
        QValues = dblarr(sz[1],sz[2]) + qo
        bin = 32/sz[1]


        ;GET THE FILE NUMBER
        fn = file_basename(self.filename)
        filenum = fix(strmid(fn,1,6))
        ;print,'ooEcho::calculateIndexMatrix filenum=',filenum

        sd = [4.476,4.35,4.50]          ;DETECTOR DISTANCES IN METERS
        xpixel = [0.0031,0.01,0.01]     ;DETECTOR PIXEL SIZES IN METERS
        ypixel = [0.003157,0.01,0.01]

        if filenum lt 1770 and filenum ge 1300 then begin
            lindex = 0
        endif else begin
            if filenum ge 1770 then begin
                lindex = 1
            endif else begin
                lindex = 2
            endelse
        endelse



        ;CALCULATE THE QVALUES
        for i=0,sz[1]-1 do begin
            for j=0,sz[2]-1 do begin

                ;VERSION OF SELECTING PIXELS STEVE USES
                ;IN THE I(Q,t) SUMMATION IN THE IGOR CODE.

                ;CALCULATE HORIZONTAL AND VERTICAL Q-VALUES
                hl = (double(i)*bin-icen)*xpixel[lindex]
                h_thetatot = thetao + atan(hl/sd[lindex])/2.0
                hq = (4.0*!PI/lambda)*sin(h_thetatot)

                hl = (double(j)*bin-jcen)*ypixel[lindex]
                v_thetatot = atan(hl/sd[lindex])/2.0
                vq = (4.0*!PI/lambda)*sin(v_thetatot)

                ;CALCULATE THE TOTAL Q
                QValues[i,j] = sqrt(hq^2 + vq^2)
                ;print,QValues[i,j]
            endfor;j
       endfor;i
    endif;N_elements(QValues)

    ;print,QValues

    sz = size(QValues)

    qmin = min(QValues)
    qmax = max(QValues)


    qstep = (qmax-qmin)/sz[1]


    ;INITIALIZE THE INDEX MATRIX
    mat = intarr(sz[1],sz[2])

    for i=0,sz[1]-1 do begin
       for j=0,sz[2]-1 do begin

        ;SET UP THE COMPARISON VALUE FOR SETTING THE
        ;PHASE INDICES
         rnd = round((QValues[i,j]-qmin)/qstep)
         if rnd lt 0 then rnd = 0
         if rnd ge sz[1] then rnd = sz[1] - 1

         mat[i,j] = rnd
       endfor;j
    endfor;i

;    print,mat
    ;print,'ooEcho::calculateIndexMatrix mat='
    ;print,mat

    ;REFORM BACK TO THE STANDARD 1D ARRAY FORMAT
    mat = reform(mat,szQVals[1])
    ;print,'ooEcho::calculateIndexMatrix mat=',mat

end;calculateIndexMatrix

function ooEcho::createProgress,kend,$
                            kbegin=kbegin,$
                            title = title,$
                            xtitle=xtitle,$
                            stopbutton=stopbutton,$
                            notify_id=notify_id,_Extra=extra
;
;NAME:
;        ooEcho::createProgress
;
;PURPOSE:
;   Create a progress meter.
;PARAMETERS:
;   kend    The end values array.
;KEYWORDS:
;   kbegin  array
;   title   array
;   xtitle  array
;   notify_id
;RETURN VALUE:
;   The base for the progress

    ;061602
    ;SORT OUT stopbutton EVENTS AFTER THE SUMMER SCHOOL.
    ;if n_elements(stopbutton) eq 0 then stopbutton = 0
    stopbutton = 0


    if n_elements(title) eq 1 then title = title else title = 'PROGRESS'

    if n_elements(xtitle) ne n_elements(kend) then $
                        xtitle = strarr(n_elements(kend))
    for i=0,n_elements(xtitle)-1 do $
        xtitle[i] = 'i'+strtrim(string(i),2)+': '


    if checkforobjinstance('oodisplayecho',ref=notifyref) gt 0 then begin
        notify_id = notifyref[0]->getproperty(/atlb)
    endif else notify_id=0L


    ;PROGRESS BAR
    if notify_id ne 0L then begin
        atlbgeom = widget_info(notify_id,/geom)
        xoffset = atlbgeom.xoffset+atlbgeom.xsize/3
        yoffset = atlbgeom.yoffset+atlbgeom.ysize/3
        b1 = widget_base(title=title,xsize=200, $
                         xoffset=xoffset,yoffset=yoffset,$
                         /floating,group_leader=notify_id)
    endif else begin
        b1 = widget_base(title=title,xsize=200, $
                                 xoffset=400,yoffset=400)
    endelse
    ;p1 = cw_progress(b1,value=[kend],title=[xtitle],notify_id=notify_id,stopbutton=stopbutton)
    ;p1 = nse_progress(b1,value=[kend],title=[xtitle],notify_id=notify_id,stopbutton=stopbutton,dialog_parent=notify_id);self.atlb)
    p1 = nse_progress(b1,value=[kend],title=[xtitle],stopbutton=stopbutton)
;help,p1
    if n_elements(kbegin) ne 0 then widget_control,p1,set_value=[kbegin]
    widget_control,b1,/realize

    return,b1



end;createProgress

pro ooEcho::pegCheck,xind,yind,tauind,$
                    pegged=pegged,stuck=stuck,chitest=chitest,_Extra=extra
;
;NAME:
;        ooEcho::pegCheck
;
;PURPOSE:
;       Check for parameter pegging and refit as necessary.
;PARAMETERS:
;   xind
;   yind
;   tauind
;KEYWORDS:
;   pegged
;   stuck
;   chitest
    ;self->addTreatment,'ooEcho::pegCheck'


    ;
    ;10/19/04
    ;
    ;CHECK FOR FIT PEGGING AND GETTING STUCK, AND CHECK CHI-SQUARED.



    start = self->startParms(xind,yind,tauind)

    parms = (*self.fitparms)[*,self.x_dim*yind+xind,tauind]

    ;ONLY CHECK P0-3 FOR STICKING.
    stuck = 0
    for i=0,3 do begin
        if parms[i] eq parms[6+i] then stuck++
    endfor;i
    if stuck ge 1 then stuck = 1
    if stuck eq 1 then print,'5346 ooecho::pegcheck FIT IS STUCK:',xind,yind,tauind


    pegged = 0
    if parms[0] eq 5.0 then pegged += 1
    if parms[1] eq 0.1 then pegged += 1
    if parms[2] eq .1 or parms[2] eq 1.0 or parms[2] eq 10.0 $
        then pegged += 1
    if pegged ge 1 then begin
        pegged = 1
        print,'5356 ooecho::pegcheck FIT IS PEGGED:',xind,yind,tauind
    endif;pegged


    ;SET VALUE OF CHI-SQUARED FOR THIS PIXEL,TAU
    chisq = (*self.chisq)[yind*self.x_dim + xind,tauind]

    chitest=0
    if (chisq/self.point_to_down) gt 100 then begin
        chitest +=1
        print,'5366 ooecho::pegcheck CHI SQUARED IS LARGE:',xind,yind,tauind
    endif;chitest


;        ;FIRST CHECK, AMPLITUDE/PHASE
;        if parms[1] eq 0.1 then begin
;            start = parms
;            start[0] = self->chirpMean(xind,yind,tauind)
;            start[1] = self->chirpMean(xind,yind,tauind)
;            ;start[2] = phsstart
;
;            dum = min(y,phaseStartIndex)
;            print,y
;            print,phaseStartIndex
;            phaseStart = x[phaseStartIndex]
;
;
;
;            start[2] = phaseStart
;            print,'Start after changes:',xind,yind,tauind,start
;        endif
;
;
;


    ;return,start
end;pegCheck
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ooecho::newStartParmsArcFit,i,j,k,mat,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooecho::newStartParmsArcFit
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    jcen = self.x_dim/2
    startparms = ((*self.fitparms)[0:5,j*self.x_dim+i,k])
    if startparms[1] eq 0.1 $
        or startparms[1] eq 1.0 $
        or startparms[1] eq 10.0 then begin
        dum = self->startparms(i,j,k,tavestate=tavestate)
        startparms[0] = dum[0]
        startparms[1] = dum[1]
        startparms[2] = $
        ((*self.fitparms)[2,jcen*self.x_dim+mat[i+j*self.x_dim],k])
    endif

    return,startparms
end;newStartParmsArcFit(i,j,k)



function ooecho::setChisq,i,j,k,_Extra=extra
;
;NAME:
;        ooecho::setChisq
;
;PURPOSE:
;   Calculate and set the chisq value.
;PARAMETERS:
;   i   pixel indices
;   j
;   k   Fourier time index
;KEYWORDS:
;   none
;RETURN VALUE:
;   chsq
    ;self->addTreatment,'ooEcho::setChisq'

    ;SET VALUE OF CHI-SQUARED FOR THIS PIXEL,TAU
    x = self->chirpPhasesMasked(k)
    y = self->chirpMasked(i,j,k)
    sy= sqrt(double(y))
    parms = (*self.fitparms)[*,i+j*self.x_dim,k]
    nfree = 6 - total((*self.fixed)[*,i+j*self.x_dim,k])


catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooEcho::setChiSQ!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    catch, /cancel
    return,-1
endif

    chsq = self->chisqTest(y,sy,k,parms,nfree)
    ;chsq = self->chisq(y,sy,k,parms,nfree)

;072905
;UPDATE TO SET MASKED PIXELS TO HAVE CHISQ VALUES OF 'nan'
;    if (*self.mask2d)[i+j*self.x_dim,k] gt 0 then begin
        (*self.chisq)[j*self.x_dim + i,k] = chsq;/n_elements(x)
;    endif else begin
;        (*self.chisq)[j*self.x_dim + i,k] = double('nan')
;    endelse

        ;REDUCED chisq IS NOW CALCULATED CORRECTLY IN self->chisq

    return, chsq
end;setChisq


pro ooEcho::storeFitparms,_Extra=extra
;
;NAME:
;        ooEcho::storeFitparms
;
;PURPOSE:
;       Store the fitparms before going forward.
;PARAMETERS:
;       none
;KEYWORDS:
;       none

    ;self->addTreatment,'ooEcho::storeFitparms'


    ;STORE FITPARMS FROM PREVIOUS FIT.

    parmstemp = *self.fitParms
    chisqtemp = *self.chisq
    fitdisplaymasktemp = *self.fitdisplaymask
    mask2dtemp = *self.mask2d


;    print,'5433 ooEcho::storeFitparms ptr_valid(self.chisq)=',ptr_valid(self.chisq)
;
    ;PLACE CURRENT VALUES INTO SAVED STATE
    if ptr_valid(self.fitparmsOld) ne 0 then ptr_free,self.fitparmsOld
    self.fitparmsOld = ptr_new(parmstemp)

;    print,'5439 ooecho::storefitparms ptr_valid(self.chisqOld)=', $
;                                    ptr_valid(self.chisqOld)

    if ptr_valid(self.chisqOld) ne 0 then ptr_free,self.chisqOld
    self.chisqOld = ptr_new(chisqtemp)


    if ptr_valid(self.fitdisplaymaskOld) then ptr_free,self.fitdisplaymaskOld
    self.fitdisplaymaskOld = ptr_new(fitdisplaymasktemp)

    if ptr_valid(self.mask2dOld) then ptr_free,self.mask2dOld
    self.mask2dOld = ptr_new(mask2dtemp)

;    print,'5445 ooecho::storefitparms ptr_valid(self.chisqOld)=', $
;                                    ptr_valid(self.chisqOld)


    self.reducedold = self.reduced

    ;SHOULD ALSO SAVE THE MASK AND FITMASK AND REVERT THEM AS WELL.
    ;
    ;MASK IS IMPORTANT BECAUSE AN ECHO'S FIT CAN BE REJECTED
    ;DUE TO POOR STATISTICS, PARAMETER PEGGING, POOR CHISQ, ETC.




end;storeFitparms

pro ooEcho::revertFitparms,_Extra=extra
;
;NAME:
;        ooEcho::revertFitparms
;
;PURPOSE:
;   Restore the fitparms from before the most recent operation.
;   NOTE:   THIS MAY NOT BE WORKING AS EXPECTED SINCE THE PARMS
;           MAY BE ALTERED ON THE FITTING OF INDIVIDUAL PIXELS,
;           EVEN WHEN A FITALL IS CALLED!!!!!
;PARAMETERS:
;   none
;KEYWORDS:
;   none
    ;self->addTreatment,'ooEcho::revertFitparms'



    ;RETURNS FITPARMS TO PREVIOUS VALUES

    ;I WILL ALMOST CERTAINLY HAVE TO REVISIT THIS LATER.

    print,'5460 ooEcho::fitparms'
    parmstemp = *self.fitparms
    ;help,parmstemp
    if ptr_valid(self.fitParmsOld) gt 0 then begin
        print,'self.fitParmsOld is valid'
        parmstempOld = *self.fitParmsOld
        ;help,parmstempOld
        ptr_free,self.fitParmsOld
        self.fitParmsOld = ptr_new(parmstemp)
        ptr_free,self.fitparms
        self.fitparms = ptr_new(parmstempOld)
    endif
;    if ptr_valid(self.fitparms) ne 0 then ptr_free,self.fitparms
;    self.fitparms = ptr_new(parmstempOld)



    chisqtemp = *self.chisq
    ;help,chisqtemp
    if ptr_valid(self.chisqOld) gt 0 then begin
        print,'self.chisqOld is valid'
        chisqtempOld = *self.chisqOld ; BECAME DEREFERENCED LATER IN THIS METHOD
        ptr_free,self.chisqOld
        self.chisqOld = ptr_new(chisqtemp)
        ptr_free,self.chisq
        self.chisq = ptr_new(chisqtempOld)
    endif
;    if ptr_valid(self.chisq) ne 0 then ptr_free,self.chisq
;    self.chisq = ptr_new(chisqtempOld)


    fitdisplaymasktemp = *self.fitdisplaymask
    ;help,fitdisplaymasktemp
    if ptr_valid(self.fitdisplaymaskOld) gt 0 then begin
        print,'self.fitdisplaymaskOld is valid'
        fitdisplaymasktempOld = *self.fitdisplaymaskOld
        ptr_free,self.fitdisplaymaskOld
        self.fitdisplaymaskOld = ptr_new(fitdisplaymasktemp)
        ptr_free,self.fitdisplaymask
        self.fitdisplaymask = ptr_new(fitdisplaymasktempOld)
    endif


    mask2dtemp = *self.mask2d
    ;help,mask2dtemp
    if ptr_valid(self.mask2dOld) gt 0 then begin
        print,'self.mask2dOld is valid'
        mask2dtempOld = *self.mask2dOld
        ptr_free,self.mask2dOld
        self.mask2dOld = ptr_new(mask2dtemp)
        ptr_free,self.mask2d
        self.mask2d = ptr_new(mask2dtempOld)
    endif

    temp = self.reduced
    self.reduced = self.reducedold
    self.reducedold = temp


end;revertFitparms

pro ooEcho::setFixed,fixed,x=x,y=y,t=t,_Extra=extra
;
;NAME:
;        ooecho::setFixed
;
;PURPOSE:
;       Set the fix state and values for selected parm
;PARAMETERS:
;       fixed   A 6 element array of 1's and 0's.
;KEYWORDS:
;       x       The selected pixel/time.
;       y
;       t


;INITIALLY ALLOW ONLY ONE PIXEL AT ONE T
;
;    if n_elements(x) eq 0 and n_elements(y) eq 0 then begin
;        if n_elements(t) eq 0 then begin
;
;        endif
;    endif else begin

;FORCE REQUIREMENT OF x,y,t TO BE DEFINED
    if n_elements(x) eq 0 then x = self.x_dim+1
    if n_elements(y) eq 0 then y = self.y_dim+1
    if n_elements(t) eq 0 then t = self.no_of_fourier_times+1

        if x lt self.x_dim and $
             y lt self.y_dim and $
              t lt self.no_of_fourier_times then begin
                if n_elements(fixed) eq 6 then begin
                        (*(self->getProperty(tag= $
                                'fixed')))[*,x+y*self.x_dim,t] = fixed
                endif else begin
                        void = dialog_message('ooEcho::setFixed requires 6 elements for argument "fixed"')
                endelse
        endif else begin
                void = dialog_message('ooEcho::setFixed x or y or t is out of range')
        endelse


end;setFixed

function ooEcho::getFixVaryState,x,y,t,_Extra=extra
;
;NAME:
;        ooecho::getFixVaryState
;
;PURPOSE:
;       Get the Fix/vary state in a form suitable for the display object.
;PARAMETERS:
;       x       The selected pixel/time.
;       y
;       t
;KEYWORDS:
;       none
;RETURN:
;       6 element array of integers 0-7.
;           0   vary this pixel, this t
;           1   vary this pixel, all t
;           2   vary all pixel, this t
;           3   vary all pixel all t
;           4   Fix this pixel, this t
;           5   Fix this pixel, all t
;           6   Fix all pixel, this t
;           7   Fix all pixel, all t


    state = intarr(6) - 1

    fixed = *self.fixed

    ;CHECK EACH PARAMETER
    for i=0,5 do begin
        ;FIRST CHECK ALL PIXEL, ALL t
        mx = max(fixed[i,*,*])
        mn = min(fixed[i,*,*])

        if mn eq 1 then state[i] = 7
        if mx eq 0 then state[i] = 0

        ;IF THIS DIDN'T FIND STATE THEN CONTINUE

        ;ALL PIXEL THIS t
        if state[i] eq -1 then begin
            mx = max(fixed[i,*,t])
            mn = min(fixed[i,*,t])
            if mn eq 1 then state[i] = 6
            if mx eq 0 then state[i] = 2
        endif;ALL PIXEL THIS t


        ;THIS PIXEL ALL t
        if state[i] eq -1 then begin
            mx = max(fixed[i,y*self.x_dim+x,*])
            mn = min(fixed[i,y*self.x_dim+x,*])
            if mn eq 1 then state[i] = 5
            if mx eq 0 then state[i] = 1
        endif;THIS PIXEL ALL t

        ;THIS PIXEL THIS t
        if state[i] eq -1 then begin
            mx = max(fixed[i,y*self.x_dim+x,t])
            mn = min(fixed[i,y*self.x_dim+x,t])
            if mn eq 1 then state[i] = 5
            if mx eq 0 then state[i] = 1
        endif;THIS PIXEL THIS t
    endfor;i


    return,state
end;getFixVaryState

pro ooEcho::fixParm,parmindex,parmstate,x=x,y=y,t=t,value=value,_Extra=extra
;
;NAME:
;        ooecho::fixParm
;
;PURPOSE:
;       Set the fix state and values for selected parm
;PARAMETERS:
;       parmindex   The index of the parameter to affect
;       parmstate   The state of the fixing.
;KEYWORDS:
;       x       The selected pixel/time.
;       y
;       t
;       value   The value to set the parms to.


    parmstemp = *self.fitparms
    fixed = *self.fixed
    


;                pfixed = ref->getProperty(tag='fixed')
;                (*pfixed)[n,self.xindex+self.yindex*self.detxdim,t] = $
;                                                            self.fixed[n]


;NOW FOR THE SELECTED PIXEL, 
;
;    1) GET THE STATE FOR THE SELECTED PIXEL
      reduced = self.reduced
;    2) SEE IF THE "NEW" STATE IS A CHANGE
;       a) IF IT IS A CHANGE 
            ;---  I HAVE NO WAY OF KNOWING IF THIS IS A CHANGE.  ONLY AN ARRAY OF 
            ;---  FIX/VARY VALUES IS KEPT FOR THE DATA SET
;
;
;       b) IF IT IS NOT A CHANGE DO NOTHING
;
;          ;--- SEE 2a)
;
;    3) CHECK TO SEE IF THE _VALUE_ IS CHANGED FOR ANYTHING
;    
;           ;THIS IS DOABLE BUT POTENTIALLY SLOW.
;           ;I WOULD HAVE TO MAKE A TEMP COPY, MAKE THE CHANGE AND COMPARE WITH THE ORIGINAL.
;           
;    
;       a) IF IT IS A CHANGED, SET fit STATE TO "not fit"


;SET STATE TO self.reduced = 0 FOR ANY OF THESE EVENTS.

       case parmstate of
        0:begin
;            print,'Vary this pixel this t',parmindex
            if n_elements(x) eq 0 or n_elements(y) eq 0 or n_elements(t) eq 0 then begin
                void = dialog_message('x,y, or t not set in ooEcho::fixParm')
            endif else begin
                ;GET THE PIXEL INDEX
                pixelindex = y*self.x_dim+x
                self.reducedOld = self.reduced
                self.reduced = 0
                ;SET THE fixed VALUE
                fixed[parmindex,pixelindex,t] = 0
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,pixelindex,t] = value
                endif
            endelse
        end;0
        1:begin
;            print,'Vary this pixel all t ',parmindex

            if n_elements(x) eq 0 or n_elements(y) eq 0 then begin
                void = dialog_message('x or y not set in ooEcho::fixParm')
            endif else begin
                ;GET THE PIXEL INDEX
                pixelindex = y*self.x_dim+x
                self.reducedOld = self.reduced
                self.reduced = 0
                ;SET THE fixed VALUE
                fixed[parmindex,pixelindex,*] = 0
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,pixelindex,*] = value
                endif
            endelse
        end;1
        2:begin
;            print,'Vary all pixel this t ' ,parmindex
            if n_elements(t) eq 0 then begin
                void = dialog_message('t not set in ooEcho::fixParm')
            endif else begin
                ;SET THE fixed VALUE
                fixed[parmindex,*,t] = 0
                self.reducedOld = self.reduced
                self.reduced = 0
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,*,t] = value
                endif
            endelse
        end;2
        3:begin
;            print,'Vary all pixel all t ',parmindex
                ;SET THE fixed VALUE
                fixed[parmindex,*,*] = 0
                self.reducedOld = self.reduced
                self.reduced = 0
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,*,*] = value
                endif
        end;3
        4:begin
;            print,'Fix this pixel this t',parmindex
            if n_elements(x) eq 0 or n_elements(y) eq 0 or n_elements(t) eq 0 then begin
                void = dialog_message('x,y, or t not set in ooEcho::fixParm')
            endif else begin
                ;GET THE PIXEL INDEX
                pixelindex = y*self.x_dim+x
                self.reducedOld = self.reduced
                self.reduced = 0
                ;SET THE fixed VALUE
                fixed[parmindex,pixelindex,t] = 1
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,pixelindex,t] = value
                endif
            endelse
        end;4
        5:begin
;            print,'Fix this pixel all t ',parmindex

            if n_elements(x) eq 0 or n_elements(y) eq 0 then begin
                void = dialog_message('x or y not set in ooEcho::fixParm')
            endif else begin
                ;GET THE PIXEL INDEX
                pixelindex = y*self.x_dim+x
                self.reducedOld = self.reduced
                self.reduced = 0
                ;SET THE fixed VALUE
                fixed[parmindex,pixelindex,*] = 1
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,pixelindex,*] = value
                endif
            endelse
        end;5
        6:begin
;            print,'Fix all pixel this t ' ,parmindex
            if n_elements(t) eq 0 then begin
                void = dialog_message('t not set in ooEcho::fixParm')
            endif else begin
                ;SET THE fixed VALUE
                fixed[parmindex,*,t] = 1
                self.reducedOld = self.reduced
                self.reduced = 0
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,*,t] = value
                endif
            endelse
        end;6
        7:begin
;            print,'Fix all pixel all t ',parmindex
                ;SET THE fixed VALUE
                fixed[parmindex,*,*] = 1
                self.reducedOld = self.reduced
                self.reduced = 0
                ;UPDATE THE VALUE IF NECESSARY
                if n_elements(value) ne 0 then begin
                    parmstemp[parmindex,*,*] = value
                endif
        end;7
        8:begin
;            print,'Fix all to Orig Vals',parmindex
                ;SET THE fixed VALUE
                fixed[parmindex,*,*] = 1
                self.reducedOld = self.reduced
                self.reduced = 0
                ;DON'T CHANGE THE PARAMETER VALUES.
        end;
        else:print,'ooEcho::fixParm   Unknown FIX choice for parm #',parmindex
        endcase

        if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        if ptr_valid(self.fixed) gt 0 then ptr_free, self.fixed

        self.fitparms = ptr_new(parmstemp)
        self.fixed = ptr_new(fixed)


;
;    ;help,parmstemp
;    if ptr_valid(self.fitParmsOld) gt 0 then begin
;        print,'self.fitParmsOld is valid'
;        parmstempOld = *self.fitParmsOld
;        ;help,parmstempOld
;        ptr_free,self.fitParmsOld
;        self.fitParmsOld = ptr_new(parmstemp)
;        ptr_free,self.fitparms
;        self.fitparms = ptr_new(parmstempOld)
;    endif
;;    if ptr_valid(self.fitparms) ne 0 then ptr_free,self.fitparms
;;    self.fitparms = ptr_new(parmstempOld)
;
;
;
;    chisqtemp = *self.chisq
;    ;help,chisqtemp
;    if ptr_valid(self.chisqOld) gt 0 then begin
;        print,'self.chisqOld is valid'
;        chisqtempOld = *self.chisqOld ; BECAME DEREFERENCED LATER IN THIS METHOD
;        ptr_free,self.chisqOld
;        self.chisqOld = ptr_new(chisqtemp)
;        ptr_free,self.chisq
;        self.chisq = ptr_new(chisqtempOld)
;    endif
;;    if ptr_valid(self.chisq) ne 0 then ptr_free,self.chisq
;;    self.chisq = ptr_new(chisqtempOld)
;
;
;    fitdisplaymasktemp = *self.fitdisplaymask
;    ;help,fitdisplaymasktemp
;    if ptr_valid(self.fitdisplaymaskOld) gt 0 then begin
;        print,'self.fitdisplaymaskOld is valid'
;        fitdisplaymasktempOld = *self.fitdisplaymaskOld
;        ptr_free,self.fitdisplaymaskOld
;        self.fitdisplaymaskOld = ptr_new(fitdisplaymasktemp)
;        ptr_free,self.fitdisplaymask
;        self.fitdisplaymask = ptr_new(fitdisplaymasktempOld)
;    endif
;
;
;    mask2dtemp = *self.mask2d
;    ;help,mask2dtemp
;    if ptr_valid(self.mask2dOld) gt 0 then begin
;        print,'self.mask2dOld is valid'
;        mask2dtempOld = *self.mask2dOld
;        ptr_free,self.mask2dOld
;        self.mask2dOld = ptr_new(mask2dtemp)
;        ptr_free,self.mask2d
;        self.mask2d = ptr_new(mask2dtempOld)
;    endif
;
;    temp = self.reduced
;    self.reduced = self.reducedold
;    self.reducedold = temp







end;fixparm


pro ooecho::setStartParms,_Extra=extra
;
;NAME:
;        ooecho::setStartParms
;
;PURPOSE:
;       Fit the central line and set starting parameters for everything.
;PARAMETERS:
;       none
;KEYWORDS:
;       none

    ;self->addTreatment,'ooEcho::setStartParms'


    ;SET THE START PARMS FOR THIS OBJECT.
    ;
    ;THIS IS A STEP TOWARD SETTING THE OFFSET VALUES
    ;BEFORE USING THEM AS A FIXED PARAMETER IN THE
    ;FITS.


;
;FINALLY, A PROGRESS METER IS NECESSARY!!!
;


    ;SAVE FITPARMS IN CASE NEXT STEP IS A MISTAKE.
    self->storeFitparms

    ;FIT FOR ALL FOURIER TIMES BY DEFAULT
    if n_elements(tauind) eq 0 then begin
        kbegin = 0
        kend = self.no_of_fourier_times-1
    endif else begin
        kbegin = tauind
        kend = tauind
    endelse

    ;GET THE Q-ARC INDICES FOR THE DATA.
    self->calculateIndexMatrix,mat=mat


    duh = checkforobjinstance('oodisplayecho',ref=ref)
    if duh ge 1 then begin
      dialog_parent = ref[0]->getproperty(/atlb)
    endif
    prog = nse_cwo_progress(labels=['Fourier Time:'],$
                           startvalues=[kbegin],$
                           endvalues=[kend],$
                           values=[kbegin],$
                           steps=[1L],$
                           obj=progobj,$
                           title='StartParm Progress:   ',$
                           dialog_parent=dialog_parent)


;    ;SET UP PROGRESS WINDOW.
;    pbase = self->createProgress([kend],$
;                                kbegin=[kbegin],$
;                                title='StartParm Progress',$
;                                xtitle=['t'])
;    prog = widget_info(pbase,/child)


    ;NOW GET STARTPARMS FOR ALL LINES
    ;AND FIT ONLY THE CENTRAL LINE.
    for k=kbegin,kend do begin
        ;widget_control,prog,set_value=[k]
        progobj->set,0,k
        stopped = proobj->checkstop()
        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                start = self->startParms(i,j,k)
                chsq = self->setChisq(i,j,k)
            endfor;j
        endfor;i
    endfor;k

    widget_control,prog,/destroy

end;setStartParms

function ooEcho::neighborCheck,c,t,mat,previousmatval,_Extra=extra
;
;NAME:
;        ooEcho::neighborCheck
;
;PURPOSE:
;       Get the previous pixel along the matrix for spiral fitting.
;PARAMETERS:
;       c
;       t
;       mat
;       previousmatval
;KEYWORDS:
;       none
;RETURN VALUE:
;   previousMatVal  The next matrix value available along the spiral.
    ;;self->addTreatment,'ooEcho::neighborCheck'


;
;CHECK THAT THE STARTING PHASE IS TAKEN FROM THE
;NEAREST NEIGHBOR THAT IS UNMASKED.  IF THE PREVIOUS
;INDEXED PIXEL IS MASKED THEN MOVE BACKWARD IN THE
;INDEX MATRIX UNTIL THE MOST RECENT, NEIGHBORING, UNMASKED
;PIXEL IS FOUND.
;
; c = current index matrix value
; t = Fourier time index
; mat = the spiral index matrix
; previousmatval = the previous index used in the spiral
;                  (value may be returned based on check)

    mask = (*(self.mask2d))[*,t]

    mask=reform(mask,self.x_dim,self.y_dim)

    ;I THINK THE NEXT TWO LINES SHOULD BE:
    i = where(mat eq c) mod self.x_dim
    j = where(mat eq c)/self.x_dim


    ;I THINK THE NEXT TWO LINES SHOULD BE:
    iprev = where(mat eq previousmatval) mod self.x_dim
    jprev = where(mat eq previousmatval)/self.y_dim

    dist = max([i-iprev,j-jprev])

    ;print,'ooEcho::neighborCheck previousmatval=',previousmatval
    if previousmatval gt 0 then begin
        if (mask[iprev,jprev] eq 0) or (dist gt 1) then begin


;;;;;            ;LOOK ONLY AT NEIGHBORS
;;;;;
;;;;;
;;;;;            ;1) CHECK WHETHER NEIGHBORS ARE MASKED.
;;;;;            possiblematval = [0]
;;;;;            ;CHECK [i +/- 1,j-1],[i +/- 1,j],[i +/- 1,j+1]
;;;;;            for jj = -1,1 do begin
;;;;;                if i+1 lt self.x_dim and j+jj lt self.y_dim and j+jj ge 0 then begin
;;;;;                    if mask[i+1,j+jj] eq 1 then possiblematval = [possiblematval,mat[i+1,j+jj]]
;;;;;                endif
;;;;;                if i-1 ge 0 and j+jj lt self.y_dim and j+jj ge 0 then begin
;;;;;                    if mask[i-1,j+jj] eq 1 then possiblematval = [possiblematval,mat[i-1,j+jj]]
;;;;;                endif
;;;;;            endfor;jj
;;;;;
;;;;;            ;CHECK [i,j-1],[i,j+1]
;;;;;            if mask[i,j+1] eq 1 then possiblematval = [possiblematval,mat[i,j+1]]
;;;;;            if mask[i,j-1] eq 1 then possiblematval = [possiblematval,mat[i,j-1]]
;;;;;


            return,self->neighborCheck(c,t,mat,previousmatval-1)


        endif else begin
            return,previousmatval
        endelse
    endif else begin
        return,previousmatval ;eq 0 AT THIS POINT.
    endelse

end;neighborCheck

pro ooEcho::spiralFit,fit=fit,tphase=tphase,$
                            tauind = tauind,$
                            fixed=fixed,$
                            sigma=sigma,$
                            period=period,$
                            minus360=minus360,$
                            plus360 = plus360,$
                            obj=obj, noborrow=noborrow,$
                            tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::spiralFit
;
;PURPOSE:
;       Fit everything using neighboring pixels along the spiral as
;       the basis for limiting phases.
;PARAMETERS:
;        none
;KEYWORDS:
;        fit
;        tphase
;        tauind
;        fixed
;        sigma
;        period
;        minus360
;        plus360
;        obj=obj
;        noborrow   Flag to not borrow phases from neighboring t

    ;self->addTreatment,'ooEcho::spiralFit'



;121704
;
;THIS WILL BE A COPY OF THE SPIRAL FITTING METHOD USED IN
;THE IGOR CODE AT THE NCNR.
;


;110404
;
;ADD OPTIONS TO DO +/- 360 FITS BASED ON PREVIOUS PARAMETERS
;AND USING THIS METHOD.

if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    ;THIS IS MEANT TO BECOME A fitAll
    ;ROUTINE WHICH WORKS FAST AND WELL.
    ;

    ;SAVE FITPARMS IN CASE NEXT STEP IS A MISTAKE.
    self->storeFitparms


;FOR ONE PIXEL, THIS FUNCTION SHOULD NOT BE CALLED,
;SO startparms SHOULD NEVER BE A NECESSARY KEYWORD.
;- - -  INSTEAD, startparms SHOULD BE A KEYWORD FOR
;       chirpfitArcs BELOW AND THAT SHOULD BE CALLED.
;
;
;FOR A SINGLE t, THIS FUNCTION SHOULD BE CALLED WITH A VALUE FOR tauind.
;
;FOR FIT ALL t, THIS FUNCTION SHOULD BE CALLED.
;
;
;IF obj IS AVAILABLE THEN
;       if n_elements(obj) ne 0 then obj->draw
;   TO UPDATE DISPLAY FROM STEP TO STEP.
;

;print,'1',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))
    if n_elements(noborrow) eq 0 then noborrow = 0

    if n_elements(fit) eq 0 then fit = 1    ;DEFAULT IS TO DO FIT.

    if n_elements(tphase) eq 0 then tphase = 1  ;DEFAULT WILL BE TO BORROW
                                                ;PHASES FROM PREVIOUS t

    if n_elements(fixed) eq 6 then begin
        for k=0,5 do begin
            (*(self.fixed))[k,*,*] = fixed[k]
        endfor;k
    endif
    if n_elements(sigma) ne 0 then begin
        self->setWidth,sigma
    endif
    if n_elements(period) ne 0 then begin
        self->setPeriod,period
    endif

;##############################################################
;072805
;IF tauind IS SET, THEN USE THAT AS A KEYWORD TO raise/lower360
;THE +/-360 BUTTON HANDLER HAS TO SEND THE CURRENT FOURIER TIME
;AS AN ARGUMENT AS WELL AS THE plus/minus360 KEYWORD.
;##############################################################
    if n_elements(minus360) ne 0 then begin
        ;SHIFT ALL PHASES BY -360
        self->lower360,tauind=tauind
    endif else minus360 = 0
    if n_elements(plus360) ne 0 then begin
        ;SHIFT ALL PHASES BY -360
        self->raise360,tauind=tauind
    endif else plus360 = 0



    ;FIT FOR ALL FOURIER TIMES BY DEFAULT
    if n_elements(tauind) eq 0 then begin
        kbegin = 0
        kend = self.no_of_fourier_times-1
    endif else begin
        kbegin = tauind
        kend = tauind
    endelse

;print,'2',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

;    ;GET THE SPIRAL INDICES FOR THE DATA.
    self->calculateSpiralMatrix,mat=mat

    mat = reform(mat,self.x_dim,self.y_dim)
;print,'3',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))


;    ;SET UP PROGRESS WINDOW.
;    pbase = self->createProgress([kend],$
;                                kbegin=[kbegin],$
;                                title='spiralFit Progress',$
;                                xtitle=['time'])
;    prog = widget_info(pbase,/child)

    duh = checkforobjinstance('oodisplayecho',ref=ref)
    if duh ge 1 then begin
      dialog_parent = ref[0]->getproperty(/atlb)
    endif
    prog = nse_cwo_progress(labels=['Fourier Time:'],$
                           startvalues=[kbegin],$
                           endvalues=[kend],$
                           values=[kbegin],$
                           steps=[1L],$
                           obj=progobj,$
                           title='SpiralFit Progress:   ',$
                           dialog_parent=dialog_parent)




;print,'4',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

    ;NOW GET STARTPARMS FOR ALL LINES
    ;BUT FIT ONLY THE CENTRAL PIXEL.
    for k=kbegin,kend do begin
;print,'4',','+strtrim(string(k),2),transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))
        ;widget_control,prog,set_value=[k]
        if obj_valid(progobj) gt 0 then progobj->set,0,k
        stopped = progobj->checkStop()
        if stopped ne 0 then return
        
        if n_elements(obj) ne 0 then obj->draw

        if noborrow eq 0 then begin
            ;BORROW PHASES INITIALLY
            if k gt kbegin then begin
                ((*self.fitparms)[2,*,k]) = $
                    ((*self.fitparms)[2,*,k-1])

                ((*self.fitparms)[8,*,k]) = 0.0d
            endif
        endif;noborrow
;print,'4',','+strtrim(string(k),2)+'a',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

        for i=0,self.x_dim-1 do begin
            ;jcen = self.y_dim/2


            ;GET THE STARTING PARAMETERS AND FIT THE CENTRAL PIXEL
            for j=0,self.y_dim-1 do begin

;                if self.reduced eq 0 then begin
;                    start = self->startParms(i,j,k,sigma=sigma);,no_set=1)
;                endif else begin
;                    ;THIS STEP SAVES THE CASE WHERE PHASES ARE SHIFTED +/- 360deg FOR REFIT.
;                    start = ((*self.fitparms)[0:5,i+j*self.x_dim,k])
;                endelse
;
;

                if plus360 eq 1 or minus360 eq 1 or noborrow eq 1 then begin
                    start = ((*self.fitparms)[0:5,i+j*self.x_dim,k])
                endif else begin
                    ;THIS STEP SAVES THE CASE WHERE PHASES ARE SHIFTED +/- 360deg FOR REFIT.
                    start = self->startParms(i,j,k,sigma=sigma,tavestate=tavestate);,no_set=1)
                endelse

;                if j eq jcen then begin $
                if mat[i,j] eq 0 then begin
                    ;FIT CENTRAL PIXEL ONLY.

                    ;MAYBE RUN chirpFit9ChiSq HERE.
                    icen = i
                    jcen = j
                    temp = self->chirpFitArcs(i,j,k,fixed=fixed,$
                                                startparms=start,/suppress,tavestate=tavestate)

;                    temp = self->chirpFit9ChiSq(i,j,k,fixed=fixed,$
;                                            startparms=start)

                    chsq = self->setChisq(i,j,k)
                endif
            endfor;j
        endfor;i
;print,'4',','+strtrim(string(k),2)+'b',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))


        mask = (*(self.mask2d))[*,k]
        mask=reform(mask,self.x_dim,self.y_dim)

        ;RUN THE SPIRAL.
        for i=1,n_elements(mat)-1 do begin


;NEED TO STORE PREVIOUS INDEX WITH NO MASK, i.e THE LAST PHASE
;CALCULATED
;

        ;i IS THE CURRENTLY SELECTED PIXEL VALUE IN THE SPIRAL MATRIX.
        ;currentindex IS THE 1-d INDEX FOR THAT VALUE
        ;previousmatval IS THE NEXT LOWER USABLE VALUE IN THE SPIRAL MATRIX.
        ;previousindex IS THE 1-d INDEX FOR THAT VALUE


        currentindex = where(mat eq i)
        icurr = currentindex mod self.x_dim
        jcurr = currentindex/self.x_dim

        if mask(icurr,jcurr) ne 0 then begin

            previousmatval=i-1
            previousindexo = where(mat eq previousmatval)

            previousmatval = self->neighborCheck(currentindex,k,mat,i-1)

            previousindex = where(mat eq previousmatval)
            iprev = previousindex mod self.x_dim
            jprev = previousindex/self.x_dim

            spiralneighborphase = ((*self.fitparms)[2,iprev+jprev*self.x_dim,k])
            if noborrow eq 0 then begin
                if k gt kbegin then begin
                    tneighborphase = ((*self.fitparms)[2,icurr+jcurr*self.x_dim,k-1])
                endif else begin
                    tneighborphase = spiralneighborphase
                endelse

                if k eq kbegin then begin
                    ;GET START PHASE FROM NEIGHBOR ALONG SPIRAL
                    startphase = spiralneighborphase
                endif else begin
                    ;GET PHASES FROM PREVIOUS FOURIER TIME
                    startphase = tneighborphase
                endelse
            endif else begin
                ;NO BORROWING SO SET THESE ALL THE SAME SO THEY WILL PASS THE CONDITIONS BELOW.
                startphase = ((*self.fitparms)[2,icurr+jcurr*self.x_dim,k])     ;noborrow
                tneighborphase = startphase
                spiralneighborphase = startphase

            endelse


        ;FOR THIS STEP, A USEFUL ORDER MIGHT INVOLVE FIXING ALL
        ;BUT AMPLITUDE AND PHASE, THEN VARY OFFSET AS WELL, AND
        ;AND FINALLY THE PERIOD.
        ;
        ;OR BETTER STILL 2-3 STEPS:
        ;   fixed = [0,0,0,1,1,1]
        ;   fixed = [0,0,0,1,0,1]
        ;   fixed = [0,0,0,0,0,1]
        ;   WHEN PHASES ARE NOT IMPORTED.  WHEN THEY ARE IMPORTED, fixed[2] = 1 FOR EACH OF THESE.
        ;

                dum = self->chirpFitSpiral(icurr,jcurr,k,startphase,$
                                            /quiet,fixed=fixed,/suppress,tavestate=tavestate)

    ;            if (abs(dum[2] - startphase) gt 270.0) then begin
                if (abs(dum[2] - tneighborphase) gt 270.0) or (abs(dum[2] - spiralneighborphase) gt 270.0) then begin
    ;                print,dum[2]
                    if dum[2] gt startphase then begin
                        dum = self->chirpFitSpiral(icurr,jcurr,k,dum[2]-360.0,$
                                                    /quiet,fixed=fixed,/suppress,tavestate=tavestate)
                    endif else begin
                        dum = self->chirpFitSpiral(icurr,jcurr,k,dum[2]+360.0,$
                                                    /quiet,fixed=fixed,/suppress,tavestate=tavestate)
                    endelse
    ;                print,dum[2]
                endif
                if k gt kbegin and dum[2] gt startphase and icurr gt self.x_dim/4 then  $
                    dum = self->chirpFitSpiral(icurr,jcurr,k,dum[2]-360.0,/quiet,fixed=fixed,/suppress,tavestate=tavestate)
                if dum[4] gt 1.3 or dum[4] lt 0.7 then begin
                    ((*self.fitparms)[2,icurr+jcurr*self.x_dim,k]) = startphase
                    ((*self.fitparms)[4,icurr+jcurr*self.x_dim,k]) = 1.0
                    dum = self->chirpFitSpiral(icurr,jcurr,k,startphase,/quiet,fixed=fixed,/suppress,tavestate=tavestate)
                endif
            endif;mask
        endfor;i

    endfor;k
;print,'5',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))



    self.IupdownSwitch = 1
    self.reduced = 1

;;;;
;
;TO THIS POINT EVERYTHING WAS LIFTED DIRECTLY FROM arcFit
;
;;;;;;

;121704
;AT THIS POINT I HAVE ALL OF THE CENTRAL PIXELS FIT AND
;STARTPARMS FOR ALL OF THE PIXELS.
;

;
;THE NEXT STEP IS TO MAKE THE PHASES CONTINUOUS ALONG THE
;CENTRAL PIXEL VS. TAU LINE,
;BUT WAIT!!!!!!! I BORROW PHASES FROM ONE FOURIER TIME
;TO THE NEXT, SO HOPEFULLY THIS ISN'T NECESSARY.
;IMPLEMENT THIS LAST.
;

;
;THEN DO THE FITS AROUND THE SPIRAL.

;NOTE THAT THE xind,yind VALUES FOR THE SPIRAL CAN
;BE EXTRACTED WITH A COMMAND LIKE:
;   yind = mat(i,j)/self.detxdim
;   xind = mat(i,j) mod self.detxdim
;
;



    ;widget_control,pbase,/destroy
    widget_control,prog,/destroy
end;spiralFit
function ooEcho::chirpFitSpiral,xind,yind,tauind,$
                                startphase,$
                                fixed=fixed,$
                                limited=limited,$
                                startparms=startparms,$
                                parmlims=parmlims,$
                                parinfo=parinfo,$
                                perror = perror,$
                                quiet = quiet,$
                                smallerr = smallerr,$
                                suppress = suppress,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::chirpFitSpiral
;
;PURPOSE:
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;       startphase
;KEYWORDS:
;        fixed
;        limited
;        startparms
;        parmlims
;        parinfo
;        perror
;        quiet
;        smallerr
;        suppress
;RETURN VALUE:
;       The fit parameters.

if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(suppress) eq 0 then suppress = 0
    ;if suppress eq 0 then $
        ;self->addTreatment,'ooEcho::chirpFitSpiral'



;121704
;
;INITIALLY THIS IS BORROWED DIRECTLY FROM chirpFitArcs
;
;
;121704
;IT WILL BE MODIFIED FOR SPIRAL FIT, INCLUDING
;_1-DIMENSIONAL INDEXING_ SO THAT THE where FUNCTION
;CAN EASILY BE USED TO SELECT THE NEXT PIXEL IN THE
;ORDER.
;
;121704
;ALMOST EVERYTHING IN THIS FUNCTION SHOULD WORK AS-IS
;WITH "xind + yind*self.x_dim" REPLACED WITH A
;SINGLE 1D "index" EXCEPT AS NOTED BELOW.
;
;
;121704
;NEED TO ADD A PHASE ARGUMENT FOR SPIRAL FITTING.
;



    ;FITTING FOR A SINGLE ECHO
    ;   KEYWORDS:
    ;   startparms IS A 6 ELEMENTS ARRAY OF THE INPUT STARTING PARAMETERS
    ;   fixed IS A 6 ELEMENTS ARRAY OF 1's AND 0's





    if n_elements(quiet) eq 0 then quiet = 1
    if n_elements(smallerr) eq 0 then smallerr = 0

;121704
;NEED TO CHANGE FOR 1D INDEXING
;    parms = self->startParms(xind,yind,tauind)

;083105
    parms = self->startParms(xind,yind,tauind,hydrogenated=hydrogenated,tavestate=tavestate)
    ;print,hydrogenated


;READY FOR 1D INDEXING
    if n_elements(fixed) eq 6 then begin
        for iii = 0,5 do begin
            (*self.fixed)[iii,xind+yind*self.x_dim,tauind] = fixed[iii]
        endfor;iii
    endif


;READY FOR 1D INDEXING
;042005
;CHANGE THE NEXT LINE TO REFLECT THE USER MASKED MASK VALUE OF -1
;    if ((*(self.mask2d))[yind*self.x_dim+xind,tauind] ne 0) then begin
    if ((*(self.mask2d))[yind*self.x_dim+xind,tauind] gt 0) then begin
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;CHANGE HERE TO USE MASKED 1D ARRAYS
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        x = self->chirpPhasesMasked(tauind)

;NEED TO CHANGE FOR 1D INDEXING
        y = self->chirpMasked(xind,yind,tauind)
        sy= sqrt(double(y))


;##################################################
;072805
;THERE NEEDS TO BE A FLAG HERE IN THE CASE OF
;MAGNETIC NSE SO THAT chirpIup/down ARE NOT
;CALLED SINCE THEY WILL BE CALCULATED WHEN THE
;POLARIZATION ANALYSIS FILE IS READ.
;##################################################


;083105
;ELIMINATE THE NEXT TWO LINES SINCE THEY ARE DONE IN startParms
;        dum = self->chirpIup(xind,yind,tauind)
;        dum = self->chirpIdown(xind,yind,tauind)


        ;SET sy[] = 1 AT ZERO VALUES AND CHECK FOR smallerr FLAG
        for ii = 0,n_elements(sy)-1 do begin
            if sy[ii] eq 0.0 then sy[ii] = 1.0

            ;ALTER EB IF THERE MAY BE A PROBLEM
            if smallerr eq 1 then sy[ii] = 1.0 + 0.1*y[ii]

        endfor;ii

        ;SET STARTING PARAMETERS FOR THIS ECHO AND INITIALIZE
        ;THE ERROR ARRAY FOR THIS SET OF PARAMETERS


;121704
;NEED TO CHANGE FOR 1D INDEXING
        parms = self->startParms(xind,yind,tauind,hydrogenated=hydrogenated,tavestate=tavestate)
;----WHY IS THIS CALLED A 2nd TIME??????


        if n_elements(startparms) eq 6 then parms = startparms
        perror = 0.0*parms

        start = parms


    ;NEED parinfo


;091205
;COMMENT OUT NEXT BLOCK
;;;;;        if max(y) ge 5000 then begin
;;;;;            lims = [[50.0d,500000.0d], [10.0,1000000.0d], [-1999.0d,2000.0d],$
;;;;;                [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;;;;        endif else begin
;;;;;            if max(y) le 10.0 then begin
;;;;;                lims = [[0.1d,200.0d], [0.1,200.0d], [-1999.0d,2000.0d],$
;;;;;                    [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;;;;            endif else begin
;;;;;            ;DEFAULT CASE
;;;;;                lims = [[1.0d,5000.0d], [0.1,20000.0d], [-1999.0d,2000.0d],$
;;;;;                    [100.0d,1000.0d], [0.1d,2000.0d], [-1999.0d,2000.0d]]
;;;;;            endelse
;;;;;        endelse

        if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                 fixed:0,$
                                 limited:[1,1], $
                                 limits:[0.0d,0.0d],$
                                 parname:'',tied:''},$
                                 6)
        endif


;091205
;ALTER THE LIMITS TO ALLOW SLIGHTLY NEGATIVE AMPLITUDES FOR
;TRADITIONAL SAMPLES.
if self.type eq 2 or self.type eq 3 then begin
    minamp = -30.0d - mean(y)/30.0d
endif else begin
    minamp = 0.001;-30.0d - mean(y)/30.0d
endelse

    lims = [[0.01d,10000000.0d], [minamp,1000000000.0d], [-10000.0d,10000.0d],$
            [0.01d,2000.0d], [0.001d,200000.0d], [-1999.0d,2000.0d]]
;083005
        if hydrogenated eq 1 then begin
            temp = -1.0*lims[0,1]
            lims[0,1] = -1.0*lims[1,1]
            lims[1,1] = temp
        endif


        parinfo[*].limits = lims
        parinfo[*].value = start
        parinfo[2].value = startphase
        ;if n_elements(fixed) ne 6 then fixed = [0,0,0,1,1,1]

;110104
fixed = (*self.fixed)[*,xind+yind*self.x_dim,tauind]
;IS THIS THE 2nd RETRIEVAL OF fixed??????


        parinfo[*].fixed = fixed

;        if quiet eq 0 then $
;            print,xind,yind,tauind,'parms =',parms,'perror = ',perror

      if total(fixed) ne 6 then begin



;        ;041205
;        ;FIT WITH PERIOD FIXED THEN FIT WITH PERIOD ALLOWED TO VARY
;        parinfo[4].fixed = 1
;        parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=quiet)
;        parinfo[4].fixed = fixed[4]
;        parinfo[*].value = parms
;        ;041205

        parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)

        ;041205
        if ((parms[4] gt 360.0/300.0) or (parms[4] lt 360.0/420.0)) and fixed[4] ne 1 then begin
            ;FIT WITH PERIOD FIXED THEN FIT WITH PERIOD ALLOWED TO VARY
            parinfo[*].value = start
            parinfo[4].fixed = 1
            parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
            parinfo[4].fixed = 0
            parinfo[*].value = parms
            parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
        endif
        ;041205




;        if quiet eq 0 then $
;            print,xind,yind,tauind,'parms =',parms,'perror = ',perror
        ;parms = mpfitfun('chirpFun', x, y, sy, start, perror=perror,/quiet)


        ((*self.fitparms)[*,yind*self.x_dim+xind,tauind]) = [parms,perror]

        parms[1] = self->checkAmp(xind,yind,tauind,hydrogenated=hydrogenated,tavestate=tavestate)



;121704
;NEED TO UPDATE THE NEXT METHOD TO WORK WITH 1D INDEXING.
        self->setfitdisplaymask,xind,yind,tauind,value=1
        chsq = self->setChisq(xind,yind,tauind)

        ;SET CHISQ HERE.

      endif;total(fixed)
    endif;mask2d


    return,parms

end;chirpFitSpiral
pro ooEcho::calculateSpiralMatrix,mat=mat,_Extra=extra
;
;NAME:
;        ooEcho::calculateSpiralMatrix
;
;PURPOSE:
;       Return the spiral for spiralFit via mat.
;PARAMETERS:
;       none
;KEYWORDS:
;       mat     NOTE: THIS IS THE METHOD OF RETURNING THE MATRIX!!!
    ;self->addTreatment,'ooEcho::calculateSpiralMatrix'



    ;RETURN THE MATRIX OF THE ORDER OF FITTING FOR THE SPIRAL FIT METHOD.
    ;PHASES ARE BORROWED FROM THE (n-1)th PIXEL FOR THE nth PIXEL.

    ;TO RUN THROUGH THE INDICES IN ORDER, USE AN EXPRESSION
    ;WITH PSEUDOCODE LIKE:
    ;
    ;spiralMat,mat=mat
    ;fit(0,start_phase = center_pix_phase)
    ;for i=1,63 do begin
    ;   previous_index = where(mat eq i-1)
    ;   next_index = where(mat eq i)
    ;
    ;   start_phase = get_phase(i-1)
    ;
    ;   fit(i,start_phase = start_phase)
    ;endfor;i
    ;

    xbin = self.x_dim_orig/self.x_dim
    ybin = self.y_dim_orig/self.y_dim

    if xbin eq ybin then begin
        bin = xbin
    endif else begin
        bin = 0
    endelse


    case bin of
    1:begin

        mat =  [[ 975, 974, 973, 972, 971, 970, 969, 968, 967, 966, 965, 964, 963, 962, 961,1023,1022,1021,1020,1019,1018,1017,1016,1015,1014,1013,1012,1011,1010,1009,1008,1007],$
                [ 976, 854, 853, 852, 851, 850, 849, 848, 847, 846, 845, 844, 843, 842, 841, 960, 959, 958, 957, 956, 955, 954, 953, 952, 951, 950, 949, 948, 947, 946, 945, 944],$
                [ 977, 855, 741, 740, 739, 738, 737, 736, 735, 734, 733, 732, 731, 730, 729, 840, 839, 838, 837, 836, 835, 834, 833, 832, 831, 830, 829, 828, 827, 826, 825, 943],$
                [ 978, 856, 742, 636, 635, 634, 633, 632, 631, 630, 629, 628, 627, 626, 625, 728, 727, 726, 725, 724, 723, 722, 721, 720, 719, 718, 717, 716, 715, 714, 824, 942],$
                [ 979, 857, 743, 637, 539, 538, 537, 536, 535, 534, 533, 532, 531, 530, 529, 624, 623, 622, 621, 620, 619, 618, 617, 616, 615, 614, 613, 612, 611, 713, 823, 941],$
                [ 980, 858, 744, 638, 540, 450, 449, 448, 447, 446, 445, 444, 443, 442, 441, 528, 527, 526, 525, 524, 523, 522, 521, 520, 519, 518, 517, 516, 610, 712, 822, 940],$
                [ 981, 859, 745, 639, 541, 451, 369, 368, 367, 366, 365, 364, 363, 362, 361, 440, 439, 438, 437, 436, 435, 434, 433, 432, 431, 430, 429, 515, 609, 711, 821, 939],$
                [ 982, 860, 746, 640, 542, 452, 370, 296, 295, 294, 293, 292, 291, 290, 289, 360, 359, 358, 357, 356, 355, 354, 353, 352, 351, 350, 428, 514, 608, 710, 820, 938],$
                [ 983, 861, 747, 641, 543, 453, 371, 297, 231, 230, 229, 228, 227, 226, 225, 288, 287, 286, 285, 284, 283, 282, 281, 280, 279, 349, 427, 513, 607, 709, 819, 937],$
                [ 984, 862, 748, 642, 544, 454, 372, 298, 232, 174, 173, 172, 171, 170, 169, 224, 223, 222, 221, 220, 219, 218, 217, 216, 278, 348, 426, 512, 606, 708, 818, 936],$
                [ 985, 863, 749, 643, 545, 455, 373, 299, 233, 175, 125, 124, 123, 122, 121, 168, 167, 166, 165, 164, 163, 162, 161, 215, 277, 347, 425, 511, 605, 707, 817, 935],$
                [ 986, 864, 750, 644, 546, 456, 374, 300, 234, 176, 126,  84,  83,  82,  81, 120, 119, 118, 117, 116, 115, 114, 160, 214, 276, 346, 424, 510, 604, 706, 816, 934],$
                [ 987, 865, 751, 645, 547, 457, 375, 301, 235, 177, 127,  85,  52,  51,  50,  49,  80,  79,  78,  77,  76, 113, 159, 213, 275, 345, 423, 509, 603, 705, 815, 933],$
                [ 988, 866, 752, 646, 548, 458, 376, 302, 236, 178, 128,  86,  53,  27,  26,  25,  48,  47,  46,  45,  75, 112, 158, 212, 274, 344, 422, 508, 602, 704, 814, 932],$
                [ 989, 867, 753, 647, 549, 459, 377, 303, 237, 179, 129,  87,  54,  28,  10,   9,  24,  23,  22,  44,  74, 111, 157, 211, 273, 343, 421, 507, 601, 703, 813, 931],$
                [ 990, 868, 754, 648, 550, 460, 378, 304, 238, 180, 130,  88,  55,  29,  11,   1,   8,   7,  21,  43,  73, 110, 156, 210, 272, 342, 420, 506, 600, 702, 812, 930],$
                [ 991, 869, 755, 649, 551, 461, 379, 305, 239, 181, 131,  89,  56,  30,  12,   2,   0,   6,  20,  42,  72, 109, 155, 209, 271, 341, 419, 505, 599, 701, 811, 929],$
                [ 992, 870, 756, 650, 552, 462, 380, 306, 240, 182, 132,  90,  57,  31,  13,   3,   4,   5,  19,  41,  71, 108, 154, 208, 270, 340, 418, 504, 598, 700, 810, 928],$
                [ 993, 871, 757, 651, 553, 463, 381, 307, 241, 183, 133,  91,  58,  32,  14,  15,  16,  17,  18,  40,  70, 107, 153, 207, 269, 339, 417, 503, 597, 699, 809, 927],$
                [ 994, 872, 758, 652, 554, 464, 382, 308, 242, 184, 134,  92,  59,  33,  34,  35,  36,  37,  38,  39,  69, 106, 152, 206, 268, 338, 416, 502, 596, 698, 808, 926],$
                [ 995, 873, 759, 653, 555, 465, 383, 309, 243, 185, 135,  93,  60,  61,  62,  63,  64,  65,  66,  67,  68, 105, 151, 205, 267, 337, 415, 501, 595, 697, 807, 925],$
                [ 996, 874, 760, 654, 556, 466, 384, 310, 244, 186, 136,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 150, 204, 266, 336, 414, 500, 594, 696, 806, 924],$
                [ 997, 875, 761, 655, 557, 467, 385, 311, 245, 187, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 203, 265, 335, 413, 499, 593, 695, 805, 923],$
                [ 998, 876, 762, 656, 558, 468, 386, 312, 246, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 264, 334, 412, 498, 592, 693, 804, 922],$
                [ 999, 877, 763, 657, 559, 469, 387, 313, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 333, 411, 497, 591, 693, 803, 921],$
                [1000, 878, 764, 658, 560, 470, 388, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 410, 496, 590, 692, 802, 920],$
                [1001, 879, 765, 659, 561, 471, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 495, 589, 691, 801, 919],$
                [1002, 880, 766, 660, 562, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 588, 690, 800, 918],$
                [1003, 881, 767, 661, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 689, 799, 917],$
                [1004, 882, 768, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 798, 916],$
                [1005, 883, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 915],$
                [1006, 884, 885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 913, 914]]

        mat = reform(mat,1024)
    end
    2:begin
        mat =  [[231, 230, 229, 228, 227, 226, 225, 255, 254, 253, 252, 251, 250, 249, 248, 247],$
                [232, 174, 173, 172, 171, 170, 169, 224, 223, 222, 221, 220, 219, 218, 217, 216],$
                [233, 175, 125, 124, 123, 122, 121, 168, 167, 166, 165, 164, 163, 162, 161, 215],$
                [234, 176, 126,  84,  83,  82,  81, 120, 119, 118, 117, 116, 115, 114, 160, 214],$
                [235, 177, 127,  85,  52,  51,  50,  49,  80,  79,  78,  77,  76, 113, 159, 213],$
                [236, 178, 128,  86,  53,  27,  26,  25,  48,  47,  46,  45,  75, 112, 158, 212],$
                [237, 179, 129,  87,  54,  28,  10,   9,  24,  23,  22,  44,  74, 111, 157, 211],$
                [238, 180, 130,  88,  55,  29,  11,   1,   8,   7,  21,  43,  73, 110, 156, 210],$
                [239, 181, 131,  89,  56,  30,  12,   2,   0,   6,  20,  42,  72, 109, 155, 209],$
                [240, 182, 132,  90,  57,  31,  13,   3,   4,   5,  19,  41,  71, 108, 154, 208],$
                [241, 183, 133,  91,  58,  32,  14,  15,  16,  17,  18,  40,  70, 107, 153, 207],$
                [242, 184, 134,  92,  59,  33,  34,  35,  36,  37,  38,  39,  69, 106, 152, 206],$
                [243, 185, 135,  93,  60,  61,  62,  63,  64,  65,  66,  67,  68, 105, 151, 205],$
                [244, 186, 136,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 150, 204],$
                [245, 187, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 203],$
                [246, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202]]

        mat = reform(mat,256)
    end
    4:begin
        mat =  [[49,27,26,25,48,47,46,45],$
                [50,28,10, 9,24,23,22,44],$
                [51,29,11, 1, 8, 7,21,43],$
                [52,30,12, 2, 0, 6,20,42],$
                [53,31,13, 3, 4, 5,19,41],$
                [54,32,14,15,16,17,18,40],$
                [55,33,34,35,36,37,38,39],$
                [56,57,58,59,60,61,62,63]]

        mat = reform(mat,64)
    end
    8:begin
        mat =  [[ 9, 8, 7, 6],$
                [10, 1, 0, 5],$
                [11, 2, 3, 4],$
                [12,13,14,15]]

        mat = reform(mat,16)
    end
    16:begin
        mat = [[1,0],$
               [2,3]]

        mat = reform(mat,4)
    end
    else:begin
        mat = 0
    end
    endcase
end;calculateSpiralMatrix


pro progresshandler_event,event,_Extra=extra
    print,tag_names(event)
    print,event
end;

pro ooEcho::arcFit,fit=fit,tphase=tphase,$
                            tauind = tauind,$
                            fixed=fixed,$
                            sigma=sigma,$
                            period=period,$
                            minus360=minus360,$
                            plus360 = plus360,$
                            obj=obj,noborrow=noborrow,$
                            tavestate=tavestate,$
                            _Extra=extra
;
;NAME:
;        ooEcho::arcFit
;
;PURPOSE:
;       Fit everything with the starting point that all phases along a constant Q arc
;       should be similar.
;PARAMETERS:
;       none
;KEYWORDS:
;       fit
;       tphase
;       tauind
;       fixed
;       sigma       Gaussian width
;       period      period
;       minus360    Switches to shift all phases by 360 and refit everything.
;       plus360
;       obj         Display obj to update during fitting.
;       noborrow    Flag to tell method not to borrow phases from neighboring times.

    ;self->addTreatment,'ooEcho::arcFit'


;print,'0',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

;110404
;
;ADD OPTIONS TO DO +/- 360 FITS BASED ON PREVIOUS PARAMETERS
;AND USING THIS METHOD.


    ;THIS IS MEANT TO BECOME A fitAll
    ;ROUTINE WHICH WORKS FAST AND WELL.
    ;
    ;IF IT IS GOOD ENOUGH IT WILL BE _THE_ FITALL ROUTINE.

    ;SAVE FITPARMS IN CASE NEXT STEP IS A MISTAKE.
    self->storeFitparms

;FOR ONE PIXEL, THIS FUNCTION SHOULD NOT BE CALLED,
;SO startparms SHOULD NEVER BE A NECESSARY KEYWORD.
;- - -  INSTEAD, startparms SHOULD BE A KEYWORD FOR
;       chirpfitArcs BELOW AND THAT SHOULD BE CALLED.
;
;
;FOR A SINGLE t, THIS FUNCTION SHOULD BE CALLED WITH A VALUE FOR tauind.
;
;FOR FIT ALL t, THIS FUNCTION SHOULD BE CALLED.
;
;
;IF obj IS AVAILABLE THEN
;       if n_elements(obj) ne 0 then obj->draw
;   TO UPDATE DISPLAY FROM STEP TO STEP.
;
;FINALLY, A PROGRESS METER IS NECESSARY!!!
;

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(noborrow) eq 0 then noborrow = 0

    if n_elements(fit) eq 0 then fit = 1    ;DEFAULT IS TO DO FIT.

    if n_elements(tphase) eq 0 then tphase = 1  ;DEFAULT WILL BE TO BORROW
                                                ;PHASES FROM PREVIOUS t

    if n_elements(fixed) eq 6 then begin
        for k=0,5 do begin
            (*(self.fixed))[k,*,*] = fixed[k]
        endfor;k
    endif
    if n_elements(sigma) ne 0 then begin
        self->setWidth,sigma
;        (*(self.fitparms))[3,*,*] = sigma
;        (*(self.fitparms))[9,*,*] = 0.0
;        dum=dialog_message('ooEcho::arcfit sigma='+string(sigma))
    endif
    if n_elements(period) ne 0 then begin
        self->setPeriod,period
    endif

    if n_elements(minus360) ne 0 then begin
        ;SHIFT ALL PHASES BY -360
        self->lower360,tauind=tauind
    endif

    if n_elements(plus360) ne 0 then begin
        self->raise360,tauind=tauind
    endif



    ;FIT FOR ALL FOURIER TIMES BY DEFAULT
    if n_elements(tauind) eq 0 then begin
        kbegin = 0
        kend = self.no_of_fourier_times-1
    endif else begin
        kbegin = tauind
        kend = tauind
    endelse

    if n_elements(obj) ne 0 then obj->draw

    ;GET THE Q-ARC INDICES FOR THE DATA.
    self->calculateIndexMatrix,mat=mat
Seconds = SYSTIME( 1,/SECONDS )
;print,SYSTIME( 1,/SECONDS )-seconds
    ;SET UP PROGRESS WINDOW.
    duh = checkforobjinstance('oodisplayecho',ref=ref)
    if duh ge 1 then begin
      dialog_parent = ref[0]->getproperty(/atlb)
    endif
    prog = nse_cwo_progress(labels=['Initial Pass:','Refinement:'],$
                           startvalues=[kbegin,kbegin],$
                           endvalues=[kend,kend],$
                           values=[kbegin,kbegin],$
                           steps=[1L,1],$
                           obj=progobj,$
                           title='Arcfit Progress:   ',$
                           dialog_parent=dialog_parent)

;
;
;    pbase = self->createProgress([kend,kend],$
;                                kbegin=[kbegin,kbegin],$
;                                title='arcFit Progress',$
;                                xtitle=['t0','t1'],/stopbutton)
;    prog = widget_info(pbase,/child)

;    pbase = nse_cwo_progress(labels=['Fourier Time:'],ranges=[[kbegin,kbegin],[kend,kend]],values=[kbegin,kbegin],steps=[1,1,1],obj=counterobj)

;print,'1:',SYSTIME( 1,/SECONDS )-seconds

    ;xmanager,'progresshandler',pbase,/no_block

;print,'1',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

;print,'ooEcho::arcFit'
;print,'WHY ARE THE *self.fitparms WIDTH VALUES SET TO THE OLD VERSION HERE?'
;print,'i.e. in the line below:                     start = ((*self.fitparms)[0:5,i+j*self.x_dim,k])'
;print,''
;print,'MOST OF THE TIME THIS MAKES SENSE, BUT IF THE FIT IS CALLED FROM THE '
;print,'FILE TREE CONTEXT MENU, THEN THE WIDTH AND PERIOD VALUES SHOULD BE CALLED '
;print,'FROM THE GENERAL TAB BEFORE PROCEEDING.'
;print,''
;print,'BUT, WHY ARE THESE NOT SET PROPERLY WHEN THE VALUES ARE UPDATED'
;print,'VIA A RETURN EVENT IN THE WIDTH FIELD?????'           


    ;NOW GET STARTPARMS FOR ALL LINES
    ;AND FIT ONLY THE CENTRAL LINE.
    for k=kbegin,kend do begin
        if obj_valid(progobj) gt 0 then progobj->set,0,k
        progstopped =  progobj->checkStop()
        if progstopped eq 1 then begin
          print,'Stopped by user.'
          widget_control,prog,/destroy
          return
;          break
        endif
        ;if widget_info(prog,/valid_id) ne 0 then widget_control,prog,set_value=[k,kbegin]



        for i=0,self.x_dim-1 do begin
            jcen = self.y_dim/2
            for j=0,self.y_dim-1 do begin
                ;PROTECT IN CASE FIT WAS DONE AND WE NEED 360 DEG SHIFT.
                if self.reduced eq 0 then begin
                    start = self->startParms(i,j,k,sigma=sigma,tavestate=tavestate)
                endif else begin
           
                    start = ((*self.fitparms)[0:5,i+j*self.x_dim,k])
                endelse

                if j eq jcen then begin $
                    temp = $
                            self->chirpFitArcs(i,j,k,fixed=fixed,$
                                                startparms=start,/suppress,tavestate=tavestate);,/test);$
;                            self->chirpFit(i,j,k,fixed=fixed,startparms=start,/suppress);$
;                                            $
;                                            parinfo=parinfo)
                    chsq = self->setChisq(i,j,k)
                    
                endif
;print,SYSTIME( 1,/SECONDS )-seconds
            endfor;j
        endfor;i
;        print,SYSTIME( 1,/SECONDS )-seconds

    endfor;k
;print,'2:',SYSTIME( 1,/SECONDS )-seconds

;print,'2',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

;ADD A CONTINUITY CHECK FOR THE CENTRAL LINE HERE.

    ;1) SET t[0] CENTER LINE (  DONE ABOVE WITH NO
    ;                           LATERAL CONTINUITY CHECK )
    io = jcen*self.x_dim
    tmparr = ((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])
    for i=self.x_dim/2+1,self.x_dim-1 do begin
            if (abs(tmparr[i]-tmparr[i-1]) gt 180.0) then begin
                if tmparr[i-1] le tmparr[i] then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]-360.0
                endif else begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]+360.0
                endelse
            endif
            ;RESET tmparr TO REFLECT CHANGES
            tmparr = ((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])
            if (abs(tmparr[i]-tmparr[i-1]) gt 180.0) then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = $
                        ((*self.fitparms)[2,io+i-1,kbegin])
            endif

    ;DO THE FIT
            start = ((*self.fitparms)[0:5,io+i,kbegin])
            temp = $
                self->chirpFitArcs(i,jcen,kbegin,$
                            fixed=fixed,startparms=start,/suppress,tavestate=tavestate);$
        ;DOES temp GET ASSIGNED TO self.fitparms? - - - YES.
    endfor;i



;print,'3',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

;print,'3:',SYSTIME( 1,/SECONDS )-seconds
    for j=0,self.x_dim/2-1 do begin
            i=self.x_dim/2-1-j
            ;;print,'CHECK',i

            if (abs(tmparr[i+1]-tmparr[i]) gt 180.0) then begin
                if tmparr[i] le tmparr[i+1] then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]+360.0
                endif else begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]-360.0
                endelse
            endif
            ;RESET tmparr TO REFLECT CHANGES
            tmparr = ((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])
            if (abs(tmparr[i+1]-tmparr[i]) gt 180.0) then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = $
                        ((*self.fitparms)[2,io+i+1,kbegin])
            endif
            start = ((*self.fitparms)[0:5,io+i,kbegin])
            temp = $
                self->chirpFitArcs(i,jcen,kbegin,$
                                    fixed=fixed,startparms=start,/suppress,tavestate=tavestate)
    endfor;j

;print,'4',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

;print,'4:',SYSTIME( 1,/SECONDS )-seconds

;    print,'((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])=',$
;            ((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])

;CHECKING PHASES FROM ONE t TO NEXT SECTION
;SHOULD BE SUPERFLUOUS SINCE ALL PHASES ARE BORROWED
;FROM ONE t TO NEXT LATER
;
;
;;;;;;    ;2) COMPARE t[k>0] LINES WITH t[i-1]
;;;;;;
;;;;;;    if kbegin ne kend then begin
;;;;;;        for k=kbegin+1,kend do begin
;;;;;;            tmparrprev = ((*self.fitparms)[2,io:io+self.x_dim-1,k-1])
;;;;;;            tmparr = ((*self.fitparms)[2,io:io+self.x_dim-1,k])
;;;;;;            for i=0,n_elements(tmparr)-1 do begin
;;;;;;                if (abs(tmparrprev[i]-tmparr[i]) gt 180.0) then begin
;;;;;;                    if tmparrprev[i] le tmparr[i] then begin
;;;;;;                        ((*self.fitparms)[2,io+i,k]) = tmparr[i]-360.0
;;;;;;                    endif else begin
;;;;;;                        ((*self.fitparms)[2,io+i,k]) = tmparr[i]+360.0
;;;;;;                    endelse
;;;;;;                endif else begin
;;;;;;                    ;DO NOTHING, PHASES CLOSE ENOUGH
;;;;;;                endelse
;;;;;;            endfor;i
;;;;;;            ;print,k
;;;;;;            ;print,transpose(tmparr)
;;;;;;        endfor;k
;;;;;;    endif;kbegin ne kend


;print,'5:',SYSTIME( 1,/SECONDS )-seconds

    ;NEXT SET ALL PHASES ON A GIVEN Q-ARC
    ;TO BE IDENTICAL (WITHIN 180deg) AND DO THE FITS IF REQUESTED
;print,'5',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

    for k=kbegin,kend do begin
        ;if widget_info(prog,/valid_id) ne 0 then widget_control,prog,set_value=[kend,k]
        if obj_valid(progobj) gt 0 then progobj->set,1,k
        progstopped =  progobj->checkStop()
        if progstopped eq 1 then begin
          print,'Stopped by user.'
          widget_control,prog,/destroy
          return
;          break
        endif

        if k eq kbegin then begin
                for i=0,self.x_dim-1 do begin
                    jcen = self.y_dim/2
                    for j=0,self.y_dim-1 do begin
                       
                        if j ne jcen then begin

                            phase = ((*self.fitparms)[2,j*self.x_dim+i,k])
                            if noborrow eq 0 then begin
                                phasecomp = $
                                        ((*self.fitparms)[2,jcen*self.x_dim+mat[i+j*self.x_dim],k])
                                if abs(phase - phasecomp) gt 180.0 then $
                                ((*self.fitparms)[2,j*self.x_dim+i,k]) = phasecomp
                            endif

                            if fit ne 0 then begin
                                startparms = $
                                ((*self.fitparms)[0:5,j*self.x_dim+i,k])

                                perror = 0.0*startparms

                                ;FIT THE DATA
                                temp = $
                                    self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate)


                                ;PLACE RESULT IN FITPARMS
                                ((*self.fitparms)[*,j*self.x_dim+i,k]) = $
                                                    [temp,perror]


                                ;REFIT IF PERIOD TOO BIG.  ----> NEED TO LIMIT PERIOD AT SOME POINT.
                                if temp[4] gt 1.3 or temp[4] lt 0.7 then begin
                                    startparms = $
                                    ((*self.fitparms)[0:5,j*self.x_dim+i,k])

                                    perror = 0.0*startparms
                                    ((*self.fitparms)[2,i+j*self.x_dim,k]) = startparms[2]
                                    ((*self.fitparms)[4,i+j*self.x_dim,k]) = 1.0
                                    temp = $
                                        self->chirpFitArcs(i,j,k,$
                                                        fixed=fixed,$
                                                        startparms=startparms,$
                                                        perror=perror,/suppress,tavestate=tavestate)
                                endif


                                ;CALCULATE chi-squared AND CHECK FIT
                                chsq = self->setChiSq(i,j,k)
                                if chsq gt 80.0 then begin

                                    startparms = self->newStartParmsArcFit(i,j,k,mat,tavestate=tavestate)

    ;                                print,i,j,k,'HIGH CHISQ',((*self.fitparms)[*,j*self.x_dim+i,k])
                                    dum = $
                                        self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate);,quiet=0)
                                                    ;perror=perror,/smallerr)
                                    chsq = self->setChiSq(i,j,k)

                                endif;chsq
    ;print,SYSTIME( 1,/SECONDS )-seconds


                            endif;fit

                        endif;j ne jcen
                    endfor;j
                endfor;i
;print,'6',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))
        endif else begin ;k eq kbegin

    ;BORROW PHASES FROM NEIGHBORING t - - -

    ;THIS WORKS AMAZINGLY WELL!!!
;print,'6:',SYSTIME( 1,/SECONDS )-seconds

                if noborrow eq 0 then begin
                    ((*self.fitparms)[2,*,k]) = ((*self.fitparms)[2,*,k-1])
                endif;noborrow

                for i=0,self.x_dim-1 do begin
                    jcen = self.y_dim/2
                    for j=0,self.y_dim-1 do begin
                            ;print,'i,j,k=',i,j,k
                            if fit ne 0 then begin
                                startparms = $
                                ((*self.fitparms)[0:5,j*self.x_dim+i,k])

                                perror = 0.0*startparms

                                ;FIT THE DATA
                                temp = $
                                    self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate)
        ;                        print,i,j,k,temp,perror
                                ;print,temp,perror

                                ;PLACE RESULT IN FITPARMS
                                ((*self.fitparms)[*,j*self.x_dim+i,k]) = $
                                                    [temp,perror]

                                chsq = self->setChiSq(i,j,k)

                                ;CHECK FIT QUALITY AND REDO AS NECESSARY
                                if chsq gt 80.0 then begin

        ;                            startparms = self->newStartParmsArcFit(i,j,k,mat)
        ;                            print,i,j,k,'HIGH CHISQ',((*self.fitparms)[*,j*self.x_dim+i,k])
                                    startparms = self->startParms(i,j,k,tavestate=tavestate)
                                    startparms[2] = ((*self.fitparms)[2,j*self.x_dim+i,k-1])
                                    dum = $
                                        self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate);,quiet=0)
                                                    ;perror=perror,/smallerr)

                                    chsq = self->setChiSq(i,j,k)

                                endif

                            endif;fit
                    endfor;j
                endfor;i
;print,'7',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))

        endelse;k eq kbegin
;print,'7:',SYSTIME( 1,/SECONDS )-seconds

    endfor;k
;print,'8',transpose(((*self.fitparms)[2,(self.x_dim/2)+(self.y_dim/2)*self.x_dim,*]))




;THIS ADDED CHECK DOES NOT ALWAYS IMPROVE THINGS!!!!


;INCORPORATE THE OPTIONS FROM cwo_pickmethod
;   IF USER CHOOSES, THIS CAN BE RUN. COMMENT OUT UNTIL
;   THE cwo HAS THAT CAPABILITY.

;;CHECK THE PHASE v t HERE
;    for i=0,self.x_dim-1 do begin
;;        jcen = self.y_dim/2
;        for j=0,self.y_dim-1 do begin
;             widget_control,prog,set_value=[kend,kend,j+i*self.y_dim]
;
;                ;print,'i,j,k=',i,j,k
;                if fit ne 0 then begin
;
;          ;get the original phase v tau
;                   phorig = ((*self.fitparms)[2,j*self.x_dim+i,*])
;          ;CHECK SLOPES AND DECIDE WHETHER TO REFIT
;                   phnew = checkslopes(phorig,flag=refitflag,positions=positions)
;                   if refitflag eq 1 then begin
;                     for k=0,self.no_of_fourier_times-1 do begin
;                ;ONLY REFIT WHERE PHASES HAS CHANGED
;                      if positions[k] ne 0 then begin
;                          startparms = $
;                          ((*self.fitparms)[0:5,j*self.x_dim+i,k])
;
;                    startparms[2] = phnew[k]
;                          perror = 0.0*startparms
;
;                          ;FIT THE DATA
;                          temp = $
;                              self->chirpFitArcs(i,j,k,$
;                                              fixed=fixed,$
;                                              startparms=startparms,$
;                                              perror=perror,/suppress)
;      ;                    print,i,j,k,temp,perror
;                          ;print,temp,perror
;
;                          ;PLACE RESULT IN FITPARMS
;                          ((*self.fitparms)[*,j*self.x_dim+i,k]) = $
;                                              [temp,perror]
;
;                          chsq = self->setChiSq(i,j,k)
;
;                          ;CHECK FIT QUALITY AND REDO AS NECESSARY
;                          if chsq gt 80.0 then begin
;
;;                              startparms = self->newStartParmsArcFit(i,j,k,mat)
;   ;                           print,i,j,k,'HIGH CHISQ',((*self.fitparms)[*,j*self.x_dim+i,k])
;                              startparms = self->startParms(i,j,k)
;                              startparms[2] = phnew[k]
;                              dum = $
;                                  self->chirpFitArcs(i,j,k,$
;                                              fixed=fixed,$
;                                              startparms=startparms,$
;                                              perror=perror);,quiet=0)
;                                              ;perror=perror,/smallerr,/suppress)
;
;                              chsq = self->setChiSq(i,j,k)
;
;                          endif;chsq
;                   endif;positions[k]
;               endfor;k
;             endif;refitflag
;
;                endif;fit
;        endfor;j
;    endfor;i
;print,'8',SYSTIME( 1,/SECONDS )-seconds

;    if widget_info(pbase,/valid_id) ne 0 then widget_control,pbase,/destroy
    if widget_info(prog,/valid_id) ne 0 then widget_control,prog,/destroy
    self.IupdownSwitch = 1
    self.reduced = 1
end;arcFit


function ooEcho::chirpFitArcs,xind,yind,tauind,$
                                fixed=fixed,$
                                limited=limited,$
                                startparms=startparms,$
                                parmlims=parmlims,$
                                parinfo=parinfo,$
                                perror = perror,$
                                quiet = quiet,$
                                smallerr = smallerr,$
                                suppress = suppress,$
                                test = test,obj=obj,$
                                tavestate=tavestate,$
                                _Extra=extra
;
;NAME:
;        ooEcho::chirpFitArcs
;
;PURPOSE:
;           Fir a single echo for the arcFit method.
;PARAMETERS:
;       xind    The pixel indices
;       yind
;       tauind  The Fourier time index
;KEYWORDS:
;        fixed
;        limited
;        startparms
;        parmlims
;        parinfo
;        perror
;        quiet
;        smallerr
;        suppress
;        test
;        obj    Display Object
;RETURN VALUE:
;   parms   The resulting fi parameters.

;    if n_elements(suppress) eq 0 then suppress = 0
;    if suppress eq 0 then $
;        ;self->addTreatment,'ooEcho::chirpFitArcs'


    ;FITTING FOR A SINGLE ECHO
    ;   KEYWORDS:
    ;   startparms IS A 6 ELEMENTS ARRAY OF THE INPUT STARTING PARAMETERS
    ;   fixed IS A 6 ELEMENTS ARRAY OF 1's AND 0's

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(test) eq 0 then test = 0
    if n_elements(quiet) eq 0 then quiet = 1
    if n_elements(smallerr) eq 0 then smallerr = 0

    parms = self->startParms(xind,yind,tauind,hydrogenated=hydrogenated,tavestate=tavestate)
    ;print,hydrogenated


    if n_elements(fixed) eq 6 then begin
        for iii = 0,5 do begin
            (*self.fixed)[iii,xind+yind*self.x_dim,tauind] = fixed[iii]
        endfor;iii
    endif



;042005
;CHANGE THE NEXT LINE TO REFLECT THE USER MASKED MASK VALUE OF -1
;    if ((*(self.mask2d))[yind*self.x_dim+xind,tauind] ne 0) then begin
    if ((*(self.mask2d))[yind*self.x_dim+xind,tauind] gt 0) then begin
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;CHANGE HERE TO USE MASKED 1D ARRAYS
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        x = self->chirpPhasesMasked(tauind)
        y = self->chirpMasked(xind,yind,tauind)
        sy= sqrt(double(y))


;;083005
;;PREPARE FOR HYDROGENATED SAMPLES WHICH _PHYSICALLY_ HAVE
;;NEGATIVE AMPLITUDES
;
;        dum_up = self->chirpIup(xind,yind,tauind)
;        dum_down = self->chirpIdown(xind,yind,tauind)
;        if dum_up gt dum_down then begin
;            hydrogenated = 1
;        endif else hydrogenated = 0

        ;SET sy[] = 1 AT ZERO VALUES AND CHECK FOR smallerr FLAG
        for ii = 0,n_elements(sy)-1 do begin
            if sy[ii] eq 0.0 then sy[ii] = 1.0

            ;ALTER EB IF THERE MAY BE A PROBLEM
            if smallerr eq 1 then sy[ii] = 1.0 + 0.1*y[ii]

        endfor;ii

        ;SET STARTING PARAMETERS FOR THIS ECHO AND INITIALIZE
        ;THE ERROR ARRAY FOR THIS SET OF PARAMETERS


;083005
        parms = self->startParms(xind,yind,tauind,hydrogenated=hydrogenated,tavestate=tavestate)

        if n_elements(startparms) eq 6 then parms = startparms
        perror = 0.0*parms

        start = parms


        if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                 fixed:0,$
                                 limited:[1,1], $
                                 limits:[0.0d,0.0d],$
                                 parname:'',tied:''},$
                                 6)
        endif


;091205
;ALTER THE LIMITS TO ALLOW SLIGHTLY NEGATIVE AMPLITUDES FOR
;TRADITIONAL SAMPLES.
if self.type eq 2 or self.type eq 3 then begin
    minamp = -30.0d - mean(y)/30.0d
endif else begin
    minamp = 0.001;-30.0d - mean(y)/30.0d
endelse

    lims = [[0.01d,10000000.0d], [minamp,1000000000.0d], [-10000.0d,10000.0d],$
            [0.01d,2000.0d], [0.001d,200000.0d], [-1999.0d,2000.0d]]
;083005
        if hydrogenated eq 1 then begin
            temp = -1.0*lims[0,1]
            lims[0,1] = -1.0*lims[1,1]
            lims[1,1] = temp
        endif

        parinfo[*].limits = lims
        parinfo[*].value = start
        if n_elements(fixed) ne 6 then fixed = [0,0,0,1,1,1]

;110104
fixed = (*self.fixed)[*,xind+yind*self.x_dim,tauind]



        parinfo[*].fixed = fixed

;        if quiet eq 0 then $
;            print,xind,yind,tauind,'parms =',parms,'perror = ',perror

      if total(fixed) ne 6 then begin

;;        ;041205
;;        ;FIT WITH PERIOD FIXED THEN FIT WITH PERIOD ALLOWED TO VARY
;;        parinfo[4].fixed = 1
;;        parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=quiet)
;;        parinfo[4].fixed = fixed[4]
;;        parinfo[*].value = parms
;;        ;041205
        if test eq 1 then begin
            quiet = 0
            print,'parinfo[*].limits'
            print,parinfo[*].limits
            print,'parinfo[*].value'
            print,parinfo[*].value
        endif

        parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)

        ;041205
        if ((parms[4] gt 360.0/300.0) or (parms[4] lt 360.0/420.0)) and fixed[4] ne 1 then begin
            ;FIT WITH PERIOD FIXED THEN FIT WITH PERIOD ALLOWED TO VARY
            parinfo[*].value = start
            parinfo[4].fixed = 1
            parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
            parinfo[4].fixed = 0
            parinfo[*].value = parms
            parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
        endif
        ;041205


;        if quiet eq 0 then $
;            print,xind,yind,tauind,'parms =',parms,'perror = ',perror
        ;parms = mpfitfun('chirpFun', x, y, sy, start, perror=perror,/quiet)


;        print,'7926 ooEcho:: chirpFitArcs'
;        help,parms,perror
;THIS WILL CRASH IF mpfit.pro IS NOT COMPILED.
        ((*self.fitparms)[*,yind*self.x_dim+xind,tauind]) = [parms,perror]

        parms[1] = self->checkAmp(xind,yind,tauind,tavestate=tavestate)

        self->setfitdisplaymask,xind,yind,tauind,value=1
      endif;total(fixed)


      ;031505
      ;
      ;NOW DO CHECKS TO SEE IF AUTO-MASKING IS APPROPRIATE

      ;1) STATISTICS   m=(moment(sy/y)) & if m[0] gt (threshold) then mask the point
      ;                         *(self.mask2d)[yind*self.x_dim+xind,tauind] = 1
      ;THE REASON THIS CHECK IS AFTER THE FIT IS TO ALLOW THE USER TO EXAMINE THE RESULTS
      ;WITHOUT HAVING TO DO THE REFIT.
      ;
      ;
      ;2) PERIOD       if 360.0/parms[4] gt 420.0 or 360.0/parms[4] lt 300.0 then
      ;                         *(self.mask2d)[yind*self.x_dim+xind,tauind] = 1
      ;
      ;3) CHISQ        if chisq


    endif;mask2d

    return,parms
end;chirpFitArcs
pro ooEcho::readOneAmpFonFoff,all=all,t=t,_Extra=extra
;
;NAME:
;           ooEcho::readOneAmp
;
;PURPOSE:
;           Read the parameters for I(Q,t) calculations from an Igor writtten file.
;
;PARAMETERS:
;           none
;KEYWORDS:
;           t   The Fourier Time where the amplitude should be read in.
;           all An option to read in all amps from the file if available.
    ;;self->addTreatment,'ooEcho::readOneAmpFonFoff'


    self->readOneAmp,all=all,t=t
    self->readOneFon,all=all,t=t
    self->readOneFoff,all=all,t=t


end;readOneAmpFonFoff
pro ooEcho::readOneAmp,t=t,all=all
;
;NAME:
;           ooEcho::readOneAmp
;
;PURPOSE:
;           Read a single fitparms[1,*,t] into this file.
;           The use of this is to easily compare calculations
;           with those of Igor.
;
;PARAMETERS:
;           none
;KEYWORDS:
;           t   The Fourier Time where the amplitude should be read in.
;           all An option to read in all amps from the file if available.
    ;;self->addTreatment,'ooEcho::readOneAmp'


    fn = dialog_pickfile(path = self.workdir,/read,title=self.filename+':'+self.comment+' Amp')
    if n_elements(all) eq 0 then all = 0
    if n_elements(t) eq 0 then t = -1

    ;DISABLE METHOD IF NEITHER all NOR t IS SET.
    if all eq 0 and t eq -1 then fn = ''

    catch, error_status
        if (error_status ne 0) then begin
            print,'THERE WAS A PROBLEM READING THE DATA FROM THE Igor FILE.'
            free_lun,lun,/force
            catch,/cancel
            return
        endif

    if fn ne '' then begin
        sz = size(*self.fitparms)
        if t ne -1 then begin
            a = dblarr(sz[2])
            openr,lun,fn,/get_lun
            readf,lun,a
            free_lun,lun
            (*self.fitparms)[1,*,t] = a
        endif else begin
            a = dblarr(sz[2],sz[3])
            openr,lun,fn,/get_lun
            readf,lun,a
            free_lun,lun
            ;help,a
            ;help,(*self.fitparms)[1,*,*]
            (*self.fitparms)[1,*,*] = a
            ;print,reform(a[*,*]-(*self.fitparms)[1,*,*],16,16,14)

        endelse
    endif else begin
        print,'No file selected or bad keywords entered.'
    endelse


end;readOneAmp
pro ooEcho::readOneFon,t=t,all=all,_Extra=extra
;
;NAME:
;           ooEcho::readOneFon
;
;PURPOSE:
;           Read a single Idown[*,t] into this file.
;           The use of this is to easily compare calculations
;           with those of Igor.
;
;PARAMETERS:
;           none
;KEYWORDS:
;           t   The Fourier Time where the Idown should be read in.
;           all An option to read in all Idown's from the file if available.
    ;;self->addTreatment,'ooEcho::readOneFon'


    fn = dialog_pickfile(path = self.workdir,/read,title=self.filename+':'+self.comment+' Fon')
    if n_elements(all) eq 0 then all = 0
    if n_elements(t) eq 0 then t = -1

    ;DISABLE METHOD IF NEITHER all NOR t IS SET.
    if all eq 0 and t eq -1 then fn = ''

    catch, error_status
        if (error_status ne 0) then begin
            print,'THERE WAS A PROBLEM READING THE DATA FROM THE Igor FILE.'
            free_lun,lun,/force
            catch,/cancel
            return
        endif

    if fn ne '' then begin
        sz = size(*self.Idown)
        if t ne -1 then begin
            a = dblarr(sz[1])
            openr,lun,fn,/get_lun
            readf,lun,a
            free_lun,lun
            (*self.Idown)[*,t] = a
        endif else begin
            a = dblarr(sz[1],sz[2])
            openr,lun,fn,/get_lun
            readf,lun,a
            free_lun,lun
            ;help,a
            ;help,(*self.Idown)
            (*self.Idown)[*,*] = a
        endelse
    endif else begin
        print,'No file selected or bad keywords entered.'
    endelse


end;readOneFon
pro ooEcho::readOneFoff,t=t,all=all,_Extra=extra
;
;NAME:
;           ooEcho::readOneFoff
;
;PURPOSE:
;           Read a single Iup[*,t] into this file.
;           The use of this is to easily compare calculations
;           with those of Igor.
;
;PARAMETERS:
;           none
;KEYWORDS:
;           t   The Fourier Time where the Iup should be read in.
;           all An option to read in all Iup's from the file if available.
    ;;self->addTreatment,'ooEcho::readOneFoff'



    fn = dialog_pickfile(path = self.workdir,/read,title=self.filename+':'+self.comment+' Foff')
    if n_elements(all) eq 0 then all = 0
    if n_elements(t) eq 0 then t = -1

    ;DISABLE METHOD IF NEITHER all NOR t IS SET.
    if all eq 0 and t eq -1 then fn = ''

    catch, error_status
        if (error_status ne 0) then begin
            print,'THERE WAS A PROBLEM READING THE DATA FROM THE Igor FILE.'
            free_lun,lun,/force
            catch,/cancel
            return
        endif

    if fn ne '' then begin
        sz = size(*self.Iup)
        if t ne -1 then begin
            a = dblarr(sz[1])
            openr,lun,fn,/get_lun
            readf,lun,a
            free_lun,lun
            (*self.Iup)[*,t] = a
        endif else begin
            a = dblarr(sz[1],sz[2])
            openr,lun,fn,/get_lun
            readf,lun,a
            free_lun,lun
            ;help,a
            ;help,(*self.Iup)
            (*self.Iup)[*,*] = a
        endelse
    endif else begin
        print,'No file selected or bad keywords entered.'
    endelse


end;readOneFoff

function ooEcho::checkAmp,xind,yind,tauind,hydrogenated = hydrogenated,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::checkAmp
;
;PURPOSE:
;           Check that the amplitude is at least as large as the mean of the
;           signal, and if not set it to that.
;PARAMETERS:
;           xind        The indices of the given echo.
;           yind
;           tauind
;KEYWORDS:
;           hydrogenated
;RETURN VALUE:
;           mean of the echo
;
    ;self->addTreatment,'ooEcho::checkAmp'
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    amp = ((*self.fitparms)[1,yind*self.x_dim+xind,tauind])

;051205
;ELIMINATE THE FOLLOWING BLOCK OF CODE.
;WORT OUT THIS CHECK LATER ON.

;    ;051005
;    ;FOR TESTING REMOVE THE NEXT LINES TO SEE IF THE GROWTH AT HIGH t STILL
;    ;OCCURS WHEN THE AMP GETS SMALL.
;    ;
;    ;THIS IS IMPORTANT WHEN THE SAMPLE OBJECT DECAYS RAPIDLY.
;
;    ;USE 1-SIGMA METHOD OF SETTING AMPLITUDE ONLY FOR CELL OBJECTS.
;    if self.type eq 3 then begin

;        echo = self->chirpMasked(xind,yind,tauind)
;
;        theMean = mean(echo)
;
;        meanDiff = sqrt((echo-theMean)^2.0d)
;
;
;        if mean(meanDiff) gt amp then begin
;            amp = mean(meanDiff)
;        endif
;        ((*self.fitparms)[1,yind*self.x_dim+xind,tauind]) = amp
;    endif

    if n_elements(hydrogenated) eq 0 then begin
        hydrogenated = 0
        dum_up = self->chirpIup(xind,yind,tauind,tavestate=tavestate)
        dum_down = self->chirpIdown(xind,yind,tauind,tavestate=tavestate)
        if dum_up gt dum_down then hydrogenated = 1
    endif

    if hydrogenated eq 0 then begin
        if abs(amp) lt 1.0 then begin
;            print,'TESTING!!!!!!! amp=',amp
            amp = self->chirpAmplitude(xind,yind,tauind,hydrogenated=hydrogenated)
        endif
    endif else begin
        ;081406
        if -abs(amp) gt -1.0 then begin
;            print,'TESTING!!!!!!! -amp=',amp
            amp = self->chirpAmplitude(xind,yind,tauind,hydrogenated=hydrogenated)
        endif
    endelse

    return,amp
end;checkAmp
pro ooEcho::checkQArcs,fit=fit,fixed=fixed,parinfo=parinfo,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::checkQArcs
;
;PURPOSE:
;       Check that phases on a give Q arc are within 180deg.
;PARAMETERS:
;       none
;KEYWORDS:
;       fit
;       fixed
;       parinfo

    ;self->addTreatment,'ooEcho::checkQArcs'



;
;101804
;
;CHECK PHASE VALUES BASED ON Q VALUES RELATIVE TO
;CENTER LINE OF DETECTOR.
;
;
;ONLY COMPUTE A FIT IF FIT=1, OTHERWISE JUST RESET THE PHASE.
;

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 


    if n_elements(fixed) eq 6 then begin
        for iii = 0,5 do begin
            (*self.fixed)[iii,*,*] = fixed[iii]
        endfor;iii
    endif



    print,'6075 ooEcho::checkQArcs self.filename=',self.filename
    if n_elements(fit) eq 0 then fit = 0

    self->calculateIndexMatrix,mat=mat
    ;print,'ooEcho::checkQArcs mat=',mat

    ;help,*self.fitparms

    for k=0,self.no_of_fourier_times-1 do begin
        for i=0,self.x_dim-1 do begin
            jcen = self.y_dim/2
            for j=0,self.y_dim-1 do begin
                if j ne jcen then begin
                    phase = ((*self.fitparms)[2,j*self.x_dim+i,k])
                    phasecomp = $
                            ((*self.fitparms)[2,jcen*self.x_dim+i,k])
                    if (phase - phasecomp) gt 180.0 then $
                        phase = phasecomp
                    ((*self.fitparms)[2,j*self.x_dim+i,k]) = phase

                    if fit eq 1 then begin

                        temp = $
                            self->chirpFit(i,j,k,fixed=fixed,$
                                            parinfo=parinfo,tavestate=tavestate)

                    endif;fit

                endif
           endfor;j
       endfor;i
    endfor;k


end;checkQArcs





pro ooEcho::check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo,noborrow=noborrow,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::check180Fit
;
;PURPOSE:
;       Check that phases in neighboring pixels are within 180 degrees of each other and
;       refit if necessary.
;PARAMETERS:
;       io  Central pixel indices
;       jo
;       k   Fourier time index
;KEYWORDS:
;       fixed
;       parinfo

    ;self->addTreatment,'ooEcho::check180Fit'
;print,'ooEcho::check180Fit'
;help,fixed
if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

if n_elements(noborrow) eq 0 then noborrow = 0

;print,'check180Fit'



;AS OF 112404 THIS IS USED FOR FITTING.


;061604
;
;ATTEMPT TO OPTIMIZE THE SPEED OF THIS METHOD
;


    ;CHECK THAT NEIGHBORING PHASES ARE WITHIN 180 deg
    ;OF EACH OTHER AND REFIT AFTER CHANGING PHASE
if noborrow eq 0 then begin

    to = systime(1,/seconds)
        ;LOOP THROUGH SELECT SET OF LAYERS
        dummy = 0
        ;EXTRACT MATRIX FROM fitparms
        parms = reform((*self.fitparms)[*,*,k],$
                                  12,self.x_dim,self.y_dim)
        parmso = parms

    ;print,systime(1,/seconds) - to

        ;
        ;
        ;IS THIS LOOP THE SLOW PART?
        ;
        ;
        for layer=1,fix(self.x_dim/2) do begin
    ;print,systime(1,/seconds) - to

            ;SET MIN AND MAX INDICES RESTRICTED BY DATA INDEX RANGE
            maxi = min([io+layer,self.x_dim-1])
            mini = max([io-layer,0])
            maxj = min([jo+layer,self.y_dim-1])
            minj = max([jo-layer,0])

            theMaxDiff = 180.0
    ;print,systime(1,/seconds) - to

            for i=mini,maxi do begin
                for j = minj,maxj do begin
                    ;INCLUDE ALL OF CENTER OF AREA
                    if(((i le maxi) and (i ge mini)) and $
                       ((j le maxj) and (j ge minj))) then begin
                        ;print,i,j,layer
                        ;BUT EXCLUDE ALL BUT EDGE OF AREA
                        if((( (i eq mini)) and $
                                ((j le maxj) or (j ge minj))) or $
                           (( (i eq maxi)) and $
                                ((j le maxj) or (j ge minj))) or $
                           (( (j eq minj)) and $
                                ((i le maxi) or (i ge mini))) or $
                           (( (j eq maxj)) and $
                                ((i le maxi) or (i ge mini)))) then begin
                            ;print,i,j,layer,'Selected'

                            ;SELECT PHASE FOR COMPARISON
                            if (layer eq 1) then begin
                                phaseo = parms[2,io,jo]
                            endif else begin
                                if (i eq io) then ip = i
                                if (i lt io) then ip = i+1
                                if (i gt io) then ip = i-1
                                if (j eq jo) then jp = j
                                if (j lt jo) then jp = j+1
                                if (j gt jo) then jp = j-1
                                phaseo = parms[2,ip,jp]
                            endelse


                            ;DECREASE PHASE IF GE 180 FROM NEIGHBOR
                            if((parms[2,i,j]-phaseo) gt theMaxDiff) then begin
                                parms[2,i,j] = parms[2,i,j] - 360.0D
                                ;temp = self->chirpFit(i,j,k,fixed=fixed)
                            endif
                            ;INCREASE PHASE IF LE -180 OFF FROM NEIGHBOR
                            if((parms[2,i,j]-phaseo) lt -1.0*theMaxDiff) $
                                               then begin
                                parms[2,i,j] = parms[2,i,j] + 360.0D
                                ;temp = self->chirpFit(i,j,k,fixed=fixed)
                            endif
            (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
            if ((*(self.mask2d))[j*self.x_dim+i,k] ne 0) then begin





;chirpFit RESETS THE STORED PARMS,
;fitAllUnpeg CALLS chirpFit, THEREFORE IT STORES PARMS TOO.
;BUT NONE OF THAT MATTERS SINCE THE PARMS AND chisq ARE NOW STORED
;AT THE END OF THIS METHOD!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


;NOTE: fitaAllUnpeg CHECKS THE SIZE OF fixed.
                if n_elements(fixed) eq 0 then begin
                    ;THIS SHOULD NEVER EXECUTE.
                    print,i,j,'ooEcho::check180Fit  THIS SHOULD NEVER EXECUTE'
                    temp = self->chirpFit(i,j,k,fixed=fixed,parinfo=parinfo,tavestate=tavestate)
                    self->fitAllUnpeg,io,jo,i,j,k,fixed,limited,parmlims,tavestate=tavestate
                end

                ;IF THE FIXED ARRAY HAS MORE THEN 6 ELEMENTS:
                if n_elements(fixed) eq 6 then begin
                    print,i,j,'ooEcho::check180Fit  THIS SHOULD NEVER EXECUTE'
                    temp = self->chirpFit(i,j,k,fixed=fixed,parinfo=parinfo,tavestate=tavestate)
                    self->fitAllUnpeg,io,jo,i,j,k,fixed,limited,parmlims,tavestate=tavestate
                endif;fixed has 6 elements

                ;IF THE FIXED ARRAY HAS MORE THEN 6 ELEMENTS:
                if n_elements(fixed) gt 6 then begin
                    ;THIS SHOULD ALWAYS BE EXECUTED
                    temp = self->chirpFit(i,j,k,$
                                            fixed=fixed[*,i+j*self.x_dim,k],$
                                            parinfo=parinfo,tavestate=tavestate)
                    self->fitAllUnpeg,io,jo,i,j,k,$
                                fixed[*,i+j*self.x_dim,k],limited,parmlims,tavestate=tavestate
                endif;fixed has more then 6 elements


        ;082304
        ;STICK THIS HERE TO CHECK THAT PARAMETERS ARE NOT PEGGED.

                ;121604
                ;WHAT ABOUT FIXED HERE???
                self->fitAllUnpeg,io,jo,i,j,k,fixed,limited,parmlims,tavestate=tavestate
            endif;mask2d

                        endif;exclude center of area
                    endif;include area
                endfor;j
            endfor;i
    ;print,systime(1,/seconds) - to

            ;RESET FIT PARAMETERS BASED ON THIS CHECK
            ;print,parms[2,*,*]

;************************************************
;
;11/27/06
;
;
;
;A-HAH!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
;
;ALL OF THE PARAMETERS ARE SET RIGHT HERE!!!!!!!!!!!!!!!!!!!!!!
;
;BT THE CHISQ VALUES ARE NOT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;************************************************

            (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)



            ;STORE THE CHI-SQUARED VALUES
            for i = 0,self.x_dim-1 do begin
                for j = 0,self.y_dim-1 do begin
                    if ((*(self.mask2d))[j*self.x_dim+i,k] ne 0) then begin

                        x = self->chirpPhasesMasked(k)
                        y = self->chirpMasked(i,j,k)
                        sy= sqrt(double(y))
                        nfree = 6 - total((*self.fixed)[*,j*self.x_dim + i,k])
                        chsq = self->chisqtest(y,sy,k,reform(parms[0:5,i,j],6),nfree)
                        (*self.chisq)[i+j*self.x_dim,k] = chsq
                    endif
                endfor;j
            endfor;i


    ;        temp = self->chirpFit(i,j,k,fixed=fixed)
            ;print,reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)

        endfor;layer
endif;noborrow
end;check180Fit

;;
;A STRIPPED-DOWN VERSION OF THE fitAll METHOD
;WHICH ELIMINATES THE CHECK OF PHASE vs TAU
;
;;;
pro ooEcho::fitAll3,chiswitch,$;,tauind=tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            sigma=sigma,$
                            obj=obj,noborrow=noborrow,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::fitAll3
;
;PURPOSE:
;       Fit everything.
;PARAMETERS:
;       chiswitch   Decide if Chisq calculated.
;KEYWORDS:
;       fixed
;       limited
;       startparms
;       parmlims
;       sigma
;       obj     The display object to update.
;       noborrow    Flag to not borrow phases from neighboring t

    ;self->addTreatment,'ooEcho::fitAll3'

;print,'fitAll3'

;AS OF 112404 THIS IS STILL USED.

;print,'ooEcho::fitAll3'


    ;062204
    ;
    ;THIS FITALL ROUTINE NEEDS WORK.  IT SHOULD BE SIMPLE
    ;AND EFFECTIVE.  IF IT IS NOT PERFECT THAT IS FINE,
    ;JUST SO IT IS ADEQUATELY FAST.
    ;
    ;THERE SHOULD BE A DIFFERENT fitAll ROUTINE THAT WILL
    ;DO THE WHOLE FIT CORRECTLY MOST OF THE TIME, BUT
    ;THIS SIMPLE ONE SHOULD BE THE DEFAULT UNTIL ADVANCES
    ;ARE MADE.
    ;
    ;
    ;OR . . .
    ;
    ;GIVE OPTIONS OF CHECKS ON THE PHASE AND LET THE USER
    ;STRING THEM TOGETHER!
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(noborrow) eq 0 then noborrow = 0

    if n_elements(fixed) eq 6 then begin
        for k=0,5 do begin
            (*(self.fixed))[k,*,*] = fixed[k]
        endfor;k
    endif
    if n_elements(sigma) ne 0 then begin
        (*(self.fitparms))[3,*,*] = sigma
        ;dum=dialog_message('sigma='+string(sigma))
    endif


    sz = size(*(self.e))
    kend = sz[3]-1 & kbegin = 0


    parinfo = replicate({value:0.0d,$
                        fixed:0,$
                        limited:[1,1], $
                        limits:[0.0d,0.0d],$
                        parname:'',tied:''},$
                        6)


    ;FIT k=0 CENTRAL PIXEL --- THIS IS DONE IN THE IGOR SOFTWARE.
    io = fix(self.x_dim/2) & jo = fix(self.y_dim/2)
;print,'1',transpose((*self.fitparms)[2,self.x_dim*jo+io,*])
if noborrow eq 0 then begin
    if chiswitch gt 0 then begin
        parms = self->startparms(io,jo,0,fixed=fixed,startparms=startparms,tavestate=tavestate)
        temp = self->chirpFit9ChiSq(io,jo,0,fixed=fixed,$
                startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,0],$
                parinfo=parinfo,tavestate=tavestate)


            ;FIT OTHER k's CENTRAL PIXELS
            for k = 1,kend do begin
                if n_elements(fixed) eq 6 then begin
                    fixed = fixed
                endif else begin
                    fixed = [0,0,0,1,1,1]
                endelse

                parms = self->startparms(io,jo,k,$
                                fixed=fixed,startparms=startparms,tavestate=tavestate)

                startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k]
                temp = self->chirpFit9ChiSq(io,jo,k,fixed=fixed,$
                    startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,0],$
                    parinfo=parinfo,tavestate=tavestate)

            endfor;k
    endif;chiswitch
endif;noborrow


    ;FIT ALL PIXELS



;    vals = [1000,1000]
;    labels = ['I1','I2']
;
;    id = nseprogress(vals,labels=labels,title='STOP!!!!!',/stopbutton)
;
;    sum = 0
;    stopped = 0
;    for i=0,vals[0]-1 do begin
;        nseprogress_step,id,index=0
;        for j=0,vals[1]-1 do begin
;            nseprogress_step,id,index=1
;            nseprogress_stopcheck,id,stopped=stopped
;            sum = sum + stopped
;            if stopped ne 0 then break
;        endfor;j
;        if stopped ne 0 then break
;    endfor;i
;
;    nseprogress_close,id





;    ;PROGRESS BAR
;    b1 = widget_base(title='Phase v Pixel',xsize=200, $
;                             xoffset=400,yoffset=400)
;    p1 = cw_progress(b1,value=[kend],title=['Tau Index ='])
;    widget_control,b1,/realize


    p1 = nseprogress([kend],start=[kbegin],labels=['Tau Index ='],$
                        title='Expand  (ooEcho::Fitall3)',stopbutton=0);,dialog_parent=self.atlb)
    stopped = 0


to = systime(1,/seconds)
;print,'2',transpose((*self.fitparms)[2,self.x_dim*jo+io,*])
    ;BEGIN FIT LOOP
    for k=kbegin,kend do begin
            nseprogress_step,p1,index=0
;            nseprogress_stopcheck,p1,stopped=stopped
            if stopped ne 0 then break
;print,'3',transpose((*self.fitparms)[2,self.x_dim*jo+io,*])
;            if widget_info(p1,/valid_id) gt 0 then $
;                widget_control,p1,set_value=[k]
            self->fitAll3a,tauind=k,$
                    fixed=fixed,$
                    limited=limited,$
                    startparms=startparms,$
                    parmlims=parmlims,$
                    obj=obj,parinfo=parinfo,noborrow=noborrow,$
                    stopped=stopped,tavestate=tavestate

            ;print,'ooEcho::fitAll3 HEY, stopped=',stopped
;print,systime(1,/seconds)-to

    endfor;k

;print,'4',transpose((*self.fitparms)[2,self.x_dim*jo+io,*])

    nseprogress_close,p1

;    if widget_info(b1,/valid_id) gt 0 then $
;                        widget_control,b1,/destroy


    self.reduced = 1    ;INDICATE THAT THE FILE HAS BEEN REDUCED



end;fitAll3



pro ooEcho::fitAll3a,tauind=tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            obj=obj,parinfo=parinfo,$
                            noborrow=noborrow,$
                            stopped=stopped,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::fitAll3a
;
;PURPOSE:
;           Fit everything at a given Fourier time.
;PARAMETERS:
;           none
;KEYWORDS:
;       tauind
;       fixed
;       limited
;       startparms
;       parmlims
;       obj     The diplayobject to update.
;       parinfo
;       stopped Flag to indicate whether user pressed button to stop fitting process

;print,'ooEcho::fitAll3a'
    ;self->addTreatment,'ooEcho::fitAll3a'

;AS OF 112404 THIS IS STILL USED.


    ;;
    ;START FITTING AT CENTER AND THEN MOVE
    ;OUT FROM THERE USING EACH FIT RESULTS AS
    ;THE STARTING PARAMETERS FOR THE NEXT FIT.
    ;;;




    if n_elements(noborrow) eq 0 then noborrow = 0

    if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)
    endif



    sz = size(*(self.e))
    if (n_elements(tauind) gt 0) then begin
        kend = tauind & kbegin = tauind
    endif else begin
        kend = sz[3]-1 & kbegin = 0
    endelse




    for k=kbegin,kend do begin
;print,'3a',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;TAKE A STEP BACK AND JUST PUT THE STARTING
        ;FIT PARMS IN THE FIT PARM MATRIX BASED ON THE
        ;amplitude, offset and

;        print,'GETTING ROUGH FIT PARAMETERS',k,': using self->startParms'
        io = self.x_dim/2-1 & jo = self.y_dim/2-1



        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                ;GET ROUGH STARTING PARAMETERS FROM DATA
                if i eq io and j eq jo then begin
                endif else begin
                    parms = self->startparms(i,j,k,fixed=fixed,startparms=startparms,tavestate=tavestate)
                endelse
            endfor;j
        endfor;i

        ;UPDATE OBJECT DISPLAY OF AVAILABLE
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

;print,'3b',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])
        ;void = dialog_message('Pause')
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        ;FIT CENTRAL PIXEL AND ASSIGN TO startparms FOR NEXT LAYER
        ;LET chirpFit CHOOSE startparms
        io = self.x_dim/2-1 & jo = self.y_dim/2-1
        temp = self->chirpFit(io,jo,k,fixed=fixed,$
                                limited=limited,$)
                                parmlims=parmlims,tavestate=tavestate)

;print,'3b1',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])
    ;082304
    ;STICK THIS HERE TO CHECK THAT PARAMETERS ARE NOT PEGGED.
        self->fitAllUnpeg,io,jo,io,jo,k,fixed,limited,parmlims,noborrow=noborrow,tavestate=tavestate
;print,'3b2',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

        self->check180,io,jo,k,noborrow=noborrow
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
;print,'3b3',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

        ;void = dialog_message('Pause')
;        print,'READJUSTING ROUGH FIT PARAMETERS',k,': using self->check180'
        self->check180,io,jo,k,noborrow=noborrow
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
;print,'3b4',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])


        ;void = dialog_message('Pause')
;print,'3c',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

;        print,'FITTING ECHOS FROM READJUSTED PARAMETERS',k,': using self->chirpFit'

        if checkforobjinstance('oodisplayecho',ref=notifyobj) then begin
            notify_id = notifyobj->getproperty(/atlb)
            ;print,'ooEcho::fitAll3a notify_id=',notify_id
        endif else notify_id = 0L

;print,'3d',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

        if kbegin eq kend then begin
;            beven = widget_base(xoffset=200,yoffset=200)
;            peven = cw_progress(beven,value=[self.x_dim-1,self.y_dim-1,4],$
;                            title=['X Index =','Y Index =','Check ='],notify_id=notify_id)
;            widget_control,beven,/realize

            peven = nseprogress([self.x_dim-1,self.y_dim-1,4],start = [0,0,0],$
                                xoffset=450,$
                                labels=['X Index= ','Y Index= ','Check= '],$
                                title='Expand  (ooEcho::Fitall3)',/stopbutton);,dialog_parent=self.atlb)
            stopped = 0

        endif;kbegin eq kend
;print,'3e',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

        for i=0,self.x_dim-1 do begin
            nseprogress_checkprogress,peven,index=0,stopped=stopped
            if stopped ne 0 then begin
                return
            endif

            for j=0,self.y_dim-1 do begin

                nseprogress_checkprogress,peven,index=1,stopped=stopped
                if stopped ne 0 then begin
                    return
                endif


                if i eq io and j eq jo then begin
                endif else begin
                    if ((*(self.mask2d))[j*self.x_dim+i,k] ne 0) then begin
;print,'3f0',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])
if noborrow eq 1 then fixed[2] = 1
                        temp = self->chirpFit(i,j,k,fixed=fixed,$
                                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                                    parinfo=parinfo,noborrow=noborrow,tavestate=tavestate)


    ;082304
    ;STICK THIS HERE TO CHECK THAT PARAMETERS ARE NOT PEGGED.
;print,'3f1',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])
        self->fitAllUnpeg,io,jo,i,j,k,fixed,limited,parmlims,noborrow=noborrow,tavestate=tavestate
;print,'3f2',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*]);

;;;                    ;temp = self->chirpAmpReFit(i,j,k,fixed=fixed)
;;;                            choke = 0
;;;                            while( ((*self.chisq)[j*self.x_dim + i,k] gt 100.0) $
;;;                                    or ((*(self.fitparms))[1,j*self.x_dim + i,k] lt 1.0) $
;;;                                        or (abs((*(self.fitparms))[2,j*self.x_dim + i,k]) gt 1000.0) $
;;;                                        and choke lt 10) $
;;;                                        do begin;then begin
;;;                                        choke = choke + 1
;;;                                ;JUST CORRECT AMPLITUDE IF FIT IS STILL BAD
;;;                                startparms = (*(self.fitparms))[0:5,j*self.x_dim + i,k]
;;;                                ;IN CASE CONSTANT IS PEGGED
;;;                                if ((*(self.fitparms))[6,j*self.x_dim + i,k] eq 0.0) or $
;;;                                   ((*(self.fitparms))[0,j*self.x_dim + i,k] eq 5.0) then $
;;;                                        startparms[0] = self->chirpMean(i,j,k)
;;;                                ;IN CASE AMPLITUDE PEGGED
;;;                                if ((*(self.fitparms))[7,j*self.x_dim + i,k] eq 0.0) or $
;;;                                   ((*(self.fitparms))[1,j*self.x_dim + i,k] eq 0.1) then $
;;;                                        startparms[1] = self->chirpMean(i,j,k)
;;;;                                ;IN CASE AMPLITUDE PEGGED
;;;;                                startparms[1] = 100.0
;;;                                ;IN CASE PHASE PEGGED
;;;                                if abs((*(self.fitparms))[2,j*self.x_dim + i,k]) gt 1000.0 then $
;;;                                     startparms[2] = (*(self.fitparms))[2,jo*self.x_dim + io,k]
;;;
;;;                                ;print,i,j,k
;;;                                temp = self->chirpFit(i,j,k,fixed=fixed,$
;;;                                                        limited=limited,$
;;;                                                        parmlims=parmlims,$
;;;                                                        startparms=startparms)
;;;
;;;                        endwhile
                    endif;mask2d
                    ;UPDATE POSSIBLE STATUS BAR
                    if widget_info(peven,/valid_id) ne 0 then begin
                        widget_control,peven,set_value=[i,j,0]
                    endif;peven valid

                endelse
            endfor;j
        endfor;i
        ;UPDATE OBJECT DISPLAY OF AVAILABLE
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

        ;void = dialog_message('Pause')



    ;
    ;
    ;
    ;CHECK180FIT IS VERY SLOW!!!!!!!!
    ;
    ;
;        print,'ADJUSTING FITTED ECHO POINTS AND REFITTING AS NECESSARY',k,': using self->check180Fit'
        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo,noborrow=noborrow,tavestate=tavestate
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
;print,'3g',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

        ;UPDATE POSSIBLE STATUS BAR
        nseprogress_checkprogress,peven,index=2,stopped=stopped
        if stopped ne 0 then begin
            return
        endif
;        if widget_info(peven,/valid_id) ne 0 then begin
;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,1]
;        endif;peven valid


;        print,'DOUBLE-CHECKING AND REFITTING AS NECESSARY',k,': using self->check180Fit'
        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo,noborrow=noborrow,tavestate=tavestate
;print,'3h',transpose((*self.fitparms)[2,self.x_dim*self.y_dim/2+self.x_dim/2,*])

        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
        ;UPDATE POSSIBLE STATUS BAR
        nseprogress_checkprogress,peven,index=2,stopped=stopped
        if stopped ne 0 then begin
            return
        endif
;        if widget_info(peven,/valid_id) ne 0 then begin
;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,2]
;        endif;peven valid
;        print,'TRIPLE-CHECKING AND REFITTING AS NECESSARY',k,': using self->check180Fit'
        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo,noborrow=noborrow,tavestate=tavestate
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
        ;UPDATE POSSIBLE STATUS BAR
        nseprogress_checkprogress,peven,index=2,stopped=stopped
        if stopped ne 0 then begin
            return
        endif
;        if widget_info(peven,/valid_id) ne 0 then begin
;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,3]
;        endif;peven valid

;        print,'FOURPLE-CHECKING AND REFITTING AS NECESSARY',k,': using self->check180Fit'
        self->check180Fit,io,jo,k,fixed=fixed,parinfo=parinfo,noborrow=noborrow,tavestate=tavestate
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
        ;UPDATE POSSIBLE STATUS BAR
        nseprogress_checkprogress,peven,index=2,stopped=stopped
        if stopped ne 0 then begin
            return
        endif
;        if widget_info(peven,/valid_id) ne 0 then begin
;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,4]
;        endif;peven valid



        ;READJUST WITH NO FIT
        self->check180,io,jo,k,noborrow=noborrow,tavestate=tavestate
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

;        print,'FITTING ECHOS FROM READJUSTED PARAMETERS',k,': using self->chirpFit'
        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                if i eq io and j eq jo then begin
                endif else begin
                    temp = self->chirpFit(i,j,k,fixed=fixed,$
                                startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                                parinfo=parinfo,tavestate=tavestate)
    ;082304
    ;STICK THIS HERE TO CHECK THAT PARAMETERS ARE NOT PEGGED.
        self->fitAllUnpeg,io,jo,i,j,k,fixed,limited,parmlims,noborrow=noborrow,tavestate=tavestate

                endelse
            endfor;j
        endfor;i

        ;DESTROY POSSIBLE STATUS WINDOW
        nseprogress_close,peven
;        if widget_info(beven,/valid_id) gt 0 then begin
;            widget_control,beven,/destroy
;        endif
    endfor;k


    self.reduced = 1    ;INDICATE THAT THE FILE HAS BEEN REDUCED

end;fitAll3a
pro ooEcho::fitAll,tauind=tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,$
                            obj=obj,parinfo=parinfo,$
                            minus360 = minus360,$
                            plus360=plus360,$
                            tavestate=tavestate,$
                            _Extra=extra
;
;NAME:
;        ooEcho::fitAll
;
;PURPOSE:
;       Fit everything.  THIS VERSION IS USED FOR "smooth T" FUNCTIONALITY.
;PARAMETERS:
;
;KEYWORDS:
;

    ;self->addTreatment,'ooEcho::fitAll'

    ;;
    ;START FITTING AT CENTER AND THEN MOVE
    ;OUT FROM THERE USING EACH FIT RESULTS AS
    ;THE STARTING PARAMETERS FOR THE NEXT FIT.
    ;;;


if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 
;120204
;
;THIS METHOD IS USED FOR THE 't' FIT BUTTON IN ooDisplayEcho
;
;072805
;AND FOR THE shiftFit

    if n_elements(minus360) ne 0 then begin
        ;SHIFT ALL PHASES BY -360
        self->lower360,tauind=tauind
    endif

    if n_elements(plus360) ne 0 then begin
        self->raise360,tauind=tauind
    endif





    if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                fixed:0,$
                                limited:[1,1], $
                                limits:[0.0d,0.0d],$
                                parname:'',tied:''},$
                                6)
    endif


    ;TOMORROW:
    ;UPDATE FITALL TO:
    ;
    ;   1) FIT CENTRAL PIXEL FOR ALL TAUS
    ;   2) CORRECT phase v. tau FOR ALWAYS DECREASE
    ;   3) FIT ALL PIXELS AS BEFORE





    sz = size(*(self.e))
    if (n_elements(tauind) gt 0) then begin
        kend = tauind & kbegin = tauind
    endif else begin
        kend = sz[3]-1 & kbegin = 0
    endelse

    for k=kbegin,kend do begin
        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                (*(self.fixed))[*,i+j*self.x_dim,k] = fixed
            endfor;j
        endfor;i
    endfor;k



    io = fix(self.x_dim/2) & jo = fix(self.y_dim/2)

    ;;
    ;AT END APPLY THIS TEST TO ALL PIXELS AND THE PROGRAM
    ;SHOULD BE HOME FREE
    ;;;
    ;FIT k=0 CENTRAL PIXEL


    if kbegin ne kend then begin
        parms = self->startparms(io,jo,0,fixed=fixed,startparms=startparms,tavestate=tavestate)
;        temp = self->chirpFit(io,jo,0,fixed=fixed,$
;                        startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,0])
        temp = self->chirpFit9ChiSq(io,jo,0,fixed=fixed,$
                startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,0],$
                parinfo=parinfo,tavestate=tavestate)

        ;FIT OTHER k's
        for k = 1,sz[3]-1 do begin
            fixed = [0,0,0,1,1,1]

            parms = self->startparms(io,jo,k,fixed=fixed,startparms=startparms,tavestate=tavestate)

            startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k]
            ;startparms[2] = (*self.fitparms)[2,self.x_dim*jo+io,k-1]
;            temp = self->chirpFit(io,jo,k,fixed=fixed,$
;                        startparms = startparms);(*self.fitparms)[0:5,self.x_dim*jo+io,k])
            temp = self->chirpFit9ChiSq(io,jo,k,fixed=fixed,$
                startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,0],$
                parinfo=parinfo,tavestate=tavestate)



;TRY MINIMIZING CHI-SQUARED FOR ALL TAUS AND CHOOSING THE
;PHASE THAT IS CLOSEST TO THE PREVIOUS ONE.





            ;IF PHASES ARE NOT DECREASING, MAKE THEM AND REFIT
            if ((*self.fitparms)[2,self.x_dim*jo+io,k] gt $
                ((*self.fitparms)[2,self.x_dim*jo+io,k-1]+180.0)) then begin
                    (*self.fitparms)[2,self.x_dim*jo+io,k] = $
                        (*self.fitparms)[2,self.x_dim*jo+io,k] - 360.0
;                    (*self.fitparms)[2,self.x_dim*jo+io,k] = $
;                        (*self.fitparms)[2,self.x_dim*jo+io,k-1]
                    temp = self->chirpFit(io,jo,k,fixed=fixed,$
                            startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k],$
                            parinfo=parinfo,tavestate=tavestate)
            endif
            ;IF PHASES ARE TOO FAR APART, MAKE THEM CLOSER AND REFIT
            if (sqrt(((*self.fitparms)[2,self.x_dim*jo+io,k] - $
                     (*self.fitparms)[2,self.x_dim*jo+io,k-1])^2) gt $
                            180.0) then begin
                    (*self.fitparms)[2,self.x_dim*jo+io,k] = $
                        (*self.fitparms)[2,self.x_dim*jo+io,k-1]
                    temp = self->chirpFit(io,jo,k,fixed=fixed,$
                        startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k],$
                        parinfo=parinfo,tavestate=tavestate)
            endif
;
;            ;IF PHASES ARE TOO FAR APART THEN IGNORE chisq AND USE
;            ;THE CONTINUITY OF phase v tau AS A TEST
;            if ((*self.fitparms)[2,self.x_dim*jo+io,k] lt $
;                ((*self.fitparms)[2,self.x_dim*jo+io,k-1]-180.0)) then begin
;                    (*self.fitparms)[2,self.x_dim*jo+io,k] = $
;                        (*self.fitparms)[2,self.x_dim*jo+io,k] + 360.0
;                    temp = self->chirpFit(io,jo,k,fixed=fixed,$
;                        startparms = (*self.fitparms)[0:5,self.x_dim*jo+io,k])
;            endif

        endfor

    endif;kbegin ne kend


    for k=kbegin,kend do begin
;        print,'ooEcho::fitAll: tauind = ',k
;        if (n_elements(startparms) lt 6) then $
;                    startparms =[200.0d,100.0d,200.0d,702.0d,1.0d,0.0d]

        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;TAKE A STEP BACK AND JUST PUT THE STARTING
        ;FIT PARMS IN THE FIT PARM MATRIX BASED ON THE
        ;amplitude, offset and

;        print,'GETTING ROUGH FIT PARAMETERS',k,': using self->startParms'
        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                ;GET ROUGH STARTING PARAMETERS FROM DATA
                if i eq io and j eq jo then begin
                endif else begin
                    parms = self->startparms(i,j,k,$
                                fixed=fixed,startparms=startparms,tavestate=tavestate)
                endelse
            endfor;j
        endfor;i

        ;UPDATE OBJECT DISPLAY OF AVAILABLE
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

        ;void = dialog_message('Pause')
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        ;FIT CENTRAL PIXEL AND ASSIGN TO startparms FOR NEXT LAYER
        ;LET chirpFit CHOOSE startparms
;        temp = self->chirpFit(io,jo,k,fixed=fixed,$
;                                limited=limited,$)
;                                parmlims=parmlims)

        ;check180 INCORPORATES PROPER LOOPING OVER ALL PHASES
        ;IN A LAYER BY LAYER METHOD FROM DETECTOR CENTER
        ;
        ;THIS STEP GETS ALL OF THE PHASES INTO A SMOOTH VARIATION
        ;MOVING OUT FROM CENTER PIXEL
;        print,'ADJUSTING ROUGH FIT PARAMETERS',k,': using self->check180'
        self->check180,io,jo,k,tavestate=tavestate
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
        ;void = dialog_message('Pause')
;        print,'READJUSTING ROUGH FIT PARAMETERS',k,': using self->check180'
        self->check180,io,jo,k,tavestate=tavestate
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
        ;void = dialog_message('Pause')


;    surf = reform((*self.fitparms)[2,*,k],$
;                              self.x_dim,self.y_dim)
;
;    ;APPLY AN APPROXIMATE ERROR VALUE
;    ssurf = surf-surf+0.05*15.0 ;EQUAL WEIGHTS
;



;    newSurf = tryfit3a(surf,ssurf,1,14,1,14)
;    (*self.fitparms)[2,*,k] = reform(newSurf,self.x_dim*self.y_dim)
;
;    if (n_elements(obj) gt 0) then begin
;        obj->draw
;    endif

;    window,0
;    wset,0
;    ;plot,surf[0,*]
;    print,max(surf,maxIndex)
;    thisxindex = maxIndex/self.x_dim
;    thisyindex = maxIndex mod self.x_dim
;    print,'INDICES'
;    print,thisxindex,thisyindex
;    plot,surf[thisxindex,*]

;        print,'FITTING ECHOS FROM READJUSTED PARAMETERS',k,': using self->chirpFit'
        if kbegin eq kend then begin
;            beven = widget_base(xoffset=200,yoffset=200)
;            ;060305
;            ;SUBSTITUTE A PROGRESS BAR WITH ONLY ONE PASS SINCE THIS IS ONLY USED FOR smooth t.
;;            peven = cw_progress(beven,value=[self.x_dim-1,self.y_dim-1],$
;;                            title=['X Index =','Y Index ='])
;;            peven = cw_progress(beven,value=[self.x_dim-1,self.y_dim-1,2],$
;;                            title=['X Index =','Y Index =','Check ='])
;            peven = nse_progress(beven,value=[self.x_dim-1,self.y_dim-1,2],$
;                                 title=['X Index =','Y Index =','Check =']);,dialog_parent=self.atlb)
;
;
;            widget_control,beven,/realize
;

            duh = checkforobjinstance('oodisplayecho',ref=ref)
            if duh ge 1 then begin
              dialog_parent = ref[0]->getproperty(/atlb)
            endif
            prog = nse_cwo_progress(labels=['X Index','Y Index','Check'],$
                                   startvalues=[0,0,0L],$
                                   endvalues=[self.x_dim,self.y_dim,2],$
                                   values=[0,0,0L],$
                                   steps=[1L,1L,1L],$
                                   obj=progobj,$
                                   title='Fit with Imported Phases:   ',$
                                   dialog_parent=dialog_parent)

        endif;kbegin eq kend


        for i=0,self.x_dim-1 do begin
            for j=0,self.y_dim-1 do begin
                if i eq io and j eq jo then begin
                endif else begin
                    temp = self->chirpFit(i,j,k,$;fixed=fixed,$
                                fixed = (*self.fixed)[*,i+j*self.x_dim,k],$
                                startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                                parinfo=parinfo,tavestate=tavestate)
                    temp = self->chirpAmpReFit(i,j,k,$
                                fixed=(*self.fixed)[*,i+j*self.x_dim,k],tavestate=tavestate)

;                    ;UPDATE POSSIBLE STATUS BAR    
;                    if widget_info(peven,/valid_id) ne 0 then begin
;;                        ;060305
;;                        ;SUBSTITUTE A PROGRESS BAR WITH ONLY ONE PASS SINCE THIS IS ONLY USED FOR smooth t.
;;                        widget_control,peven,set_value=[i,j]
;                         widget_control,peven,set_value=[i,j,0]
;                    endif;peven valid
                    if obj_valid(progobj) gt 0 then begin  
                      progobj->set,0,i
                      progobj->set,1,j
                      progobj->set,2,0
                      stopped = progobj->checkstop()
                      if stopped ne 0 then begin
                        widget_control,prog,/destroy
                        return
                      endif
                    endif


                endelse
            endfor;j
        endfor;i
        ;UPDATE OBJECT DISPLAY OF AVAILABLE
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif

;        ;UPDATE POSSIBLE STATUS BAR
;        if widget_info(peven,/valid_id) ne 0 then begin
;            ;060305
;            ;SUBSTITUTE A PROGRESS BAR WITH ONLY ONE PASS SINCE THIS IS ONLY USED FOR smooth t.
;;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1]
;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,1]
;        endif;peven valid
          if obj_valid(progobj) gt 0 then begin  
            progobj->set,0,self.x_dim
            progobj->set,1,self.y_dim
            progobj->set,2,1
            stopped = progobj->checkstop()
            if stopped ne 0 then begin
              widget_control,prog,/destroy
              return
            endif
          endif

    ;
    ;
    ;
    ;CHECK180FIT IS VERY SLOW!!!!!!!!
    ;
    ;
;121605
;IT SEEMS LIKE I NEED TO SEND THE ENTIRE fixed ARRAY FOR A
;GIVEN FOURIER TIME, AND SORT IT OUT IN check180Fit
;SINCE THE for LOOP IS IN THE METHOD.
        self->check180Fit,io,jo,k, $
                fixed=(*self.fixed)[*,*,*], $;fixed=(*self.fixed)[*,i+j*self.x_dim,k],$
                parinfo=parinfo,tavestate=tavestate

        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
        ;UPDATE POSSIBLE STATUS BAR
;        if widget_info(peven,/valid_id) ne 0 then begin
;            ;060305
;            ;SUBSTITUTE A PROGRESS BAR WITH ONLY ONE PASS SINCE THIS IS ONLY USED FOR smooth t.
;;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1]
;            widget_control,peven,set_value=[self.x_dim-1,self.y_dim-1,2]
;        endif;peven valid
;;        print,'DOUBLE-CHECKING AND REFITTING AS NECESSARY',k,': using self->check180Fit'
          if obj_valid(progobj) gt 0 then begin  
            progobj->set,0,self.x_dim
            progobj->set,1,self.y_dim
            progobj->set,2,2
            stopped = progobj->checkstop()
            if stopped ne 0 then begin
              widget_control,prog,/destroy
              return
            endif
          endif





;THE NEXT TWO OPERATIONS, IN SEQUENCE OR INDIVIDUALLY DO NOT
;IMPROVE THE PHASE SURFACE.
;
;THE NEXT STEP SHOULD BE TO FIT THE PHASE SURFACE USING A 2D
;FIT AND AN ELLIPSOID FUNCTION.
;
;
;NONE OF THE GRADIENT FITS HELP.  WHILE THEY FIX THE PROBLEM
;AREAS THEY TEND TO ALTER THE GOOD AREAS OF THE PHASE SURFACE.
;
;
;
;APPLY THE MASK THEN DO THE SURFACE FIT.
;
;PASSIVE MASK SHOULD BE APPLIED VIA THE STATISTICS TEST
;THAT SELECTS WHICH ECHOES TO FIT
;
;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;                ;NOW NEED TO FIT OUTWARD FROM CENTER
;;;;;                ;TO ENCOURAGE SMOOTH VARIATION IN
;;;;;                ;PHASE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;

;        self->surfFit,io,jo,k,2,13,2,13,obj = obj
;        ;UPDATE OBJECT DISPLAY OF AVAILABLE
;        if (n_elements(obj) gt 0) then begin
;            obj->draw
;        endif

        ;self->layerFit,io,jo,k,obj=obj

;        ;DESTROY POSSIBLE STATUS WINDOW
;        if widget_info(beven,/valid_id) gt 0 then begin
;            widget_control,beven,/destroy
;        endif



    endfor;k

    for k=kbegin,kend do begin
        if kbegin ne kend then begin
            for i=0,self.x_dim-1 do begin
                for j=0,self.y_dim-1 do begin
                    if i eq io and j eq jo then begin
                    endif else begin

                        self->phiVTauTest,i,j,parinfo=parinfo,tavestate=tavestate
                        self->phiVTauTest,i,j,parinfo=parinfo,tavestate=tavestate

;                        temp = self->chirpFit(i,j,k,fixed=fixed,$
;                                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k])
;                        temp = self->chirpAmpReFit(i,j,k,fixed=fixed)
                    endelse
                endfor;j
            endfor;i
        endif;kbegin ne kend
    endfor;k

    ;DESTROY POSSIBLE STATUS WINDOW
    
;    if widget_info(beven,/valid_id) gt 0 then begin
;        widget_control,beven,/destroy
;    endif
    if widget_info(prog,/valid_id) gt 0 then begin
        widget_control,prog,/destroy
    endif


;    self.reduced = 1    ;INDICATE THAT THE FILE HAS BEEN REDUCED

end;fitAll
pro ooEcho::phiVTauTest,i,j,parinfo=parinfo,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::phiVTauTest
;
;PURPOSE:
;       Check for smoothness of phase as a function of Fourier Time.
;PARAMETERS:
;       i       Pixel indices
;       j
;KEYWORDS:
;       parinfo parinfo for fitting

    ;self->addTreatment,'ooEcho::phiVTauTest'

    sz = size(*(self.e))
    io = fix(self.x_dim/2) & jo = fix(self.y_dim/2)

    ;;
    ;AT END APPLY THIS TEST TO ALL PIXELS AND THE PROGRAM
    ;SHOULD BE HOME FREE
    ;;;
    ;FIT k=0 CENTRAL PIXEL
if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 


    ;FIT OTHER k's
    for k = 1,sz[3]-1 do begin
        fixed = [0,0,0,1,1,1]


        ;IF PHASES ARE NOT DECREASING, MAKE THEM AND REFIT
        if ((*self.fitparms)[2,self.x_dim*j+i,k] gt $
            ((*self.fitparms)[2,self.x_dim*j+i,k-1]+15.0)) then begin

                (*self.fitparms)[2,self.x_dim*j+i,k] = $
                    (*self.fitparms)[2,self.x_dim*j+i,k] - 360.0

                temp = self->chirpFit(i,j,k,fixed=fixed,$
                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                    parinfo=parinfo,tavestate=tavestate)
        endif
        if ((*self.fitparms)[2,self.x_dim*j+i,k] lt $
            ((*self.fitparms)[2,self.x_dim*j+i,k-1]-270.0)) then begin

                (*self.fitparms)[2,self.x_dim*j+i,k] = $
                    (*self.fitparms)[2,self.x_dim*j+i,k] + 360.0

                temp = self->chirpFit(i,j,k,fixed=fixed,$
                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                    parinfo=parinfo,tavestate=tavestate)
        endif


    ;ADD THIS CHECK
        ;IF PHASES ARE TOO FAR APART, MAKE THEM CLOSER AND REFIT
;        if (sqrt(((*self.fitparms)[2,self.x_dim*j+i,k] - $
;                 (*self.fitparms)[2,self.x_dim*j+i,k-1])^2) gt $
;                        180.0) then begin
;                (*self.fitparms)[2,self.x_dim*j+i,k] = $
;                    (*self.fitparms)[2,self.x_dim*j+i,k-1]
;                temp = self->chirpFit(i,j,k,fixed=fixed,$
;                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k])
;        endif
        if (((*self.fitparms)[2,self.x_dim*j+i,k] - $
                 (*self.fitparms)[2,self.x_dim*j+i,k-1]) gt $
                        180.0) then begin
                (*self.fitparms)[2,self.x_dim*j+i,k] = $
                    (*self.fitparms)[2,self.x_dim*j+i,k]-360.0
                temp = self->chirpFit(i,j,k,fixed=fixed,$
                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                    parinfo=parinfo,tavestate=tavestate)
        endif
;        ;IF PHASES ARE TOO FAR APART, MAKE THEM CLOSER AND REFIT
;        if (sqrt(((*self.fitparms)[2,self.x_dim*j+i,k] - $
;                 (*self.fitparms)[2,self.x_dim*j+i,k-1])^2) gt $
;                        180.0) then begin
;                (*self.fitparms)[2,self.x_dim*j+i,k] = $
;                    (*self.fitparms)[2,self.x_dim*j+i,k-1]
;                temp = self->chirpFit(i,j,k,fixed=fixed,$
;                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k])
;        endif
        if (sqrt(((*self.fitparms)[2,self.x_dim*j+i,k-1] - $
                 (*self.fitparms)[2,self.x_dim*j+i,k])^2) gt $
                        180.0) then begin
                (*self.fitparms)[2,self.x_dim*j+i,k] = $
                    (*self.fitparms)[2,self.x_dim*j+i,k]+360.0
                temp = self->chirpFit(i,j,k,fixed=fixed,$
                    startparms = (*self.fitparms)[0:5,self.x_dim*j+i,k],$
                    parinfo=parinfo,tavestate=tavestate)
        endif

    endfor


end;phiVTauTest
function ooEcho::chiSqCheck,xind,yind,tauind,$
                            fixed=fixed,$
                            limited=limited,$
                            startparms=startparms,$
                            parmlims=parmlims,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::chiSqCheck
;
;PURPOSE:
;       Check the chiSquared values.  NOTE: Seems unused.
;PARAMETERS:
;
;KEYWORDS:
;
;RETURN VALUE:
;       ????
    ;self->addTreatment,'ooEcho::chiSqCheck'


;        chirpFit9ChiSq,xind,yind,tauind,$
;                            fixed=fixed,$
;                            limited=limited,$
;                            startparms=startparms,$
;                            parmlims=parmlims

if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

end;chiSqCheck
pro ooEcho::checkLineFit,io,jo,k,fixed=fixed,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::checkLineFit
;
;PURPOSE:
;       Check the fit phases along a line.
;PARAMETERS:
;       io  The central indices
;       jo
;       k   The Fourier time index
;KEYWORDS:
;       fixed   The fixed array for fitting.
    ;self->addTreatment,'ooEcho::checkLineFit'

if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    ;CHECK THAT ALL PHASES ALONG A HORIZONTAL OR VERTICAL LINE ON
    ;THE PHASE SURFACE ARE CONTINUOUS

    ;LOOP THROUGH SELECT SET OF LAYERS
    dummy = 0
    ;EXTRACT MATRIX FROM fitparms
    parms = reform((*self.fitparms)[*,*,k],$
                              12,self.x_dim,self.y_dim)

    parmso = parms


    if n_elements(fixed) eq 6 then begin
        for iii = 0,5 do begin
            (*self.fixed)[iii,*,k] = fixed[iii]
        endfor;iii
    endif




    for j=0,self.y_dim-1 do begin

        ;SELECT LINE FROM IMAGE
        line = parms[2,*,j]
;        print,j,'line = ',reform(line,n_elements(line))
        for i=0,self.x_dim/2-2 do begin
            rindex = self.x_dim/2+i
            lindex = self.x_dim/2-i
            if (rindex+1 lt self.x_dim) then begin
                dlNext = line[rindex+1] - line[rindex]
                dl = line[rindex] - line[rindex-1]
                dlPrev = line[rindex-1] - line[rindex-2]
                if (dlNext ge dl and dl ge dlPrev) then begin
                endif else begin
                    if (dlNext le dl and dl le dlPrev) then begin
                    endif else begin
                        if (dlNext lt dl and dl gt dlPrev) then begin
                            parms[2,i,j] = parms[2,i,j] - 360.0
                        endif
                        if (dlNext gt dl and dl lt dlPrev) then begin
                            parms[2,i,j] = parms[2,i,j] + 360.0
                        endif
                    endelse

                endelse

;                if (dl lt 0 and $
;                        line[rindex+1] gt line[rindex]) then begin
;                    parms[2,i,j] = parms[2,i,j] - 360.0
;                endif
;                if (dl gt 0 and $
;                        line[rindex+1] lt line[rindex]) then begin
;                    parms[2,i,j] = parms[2,i,j] + 360.0
;                endif
            endif;rindex+1


;FIX DERIVATIVE CHECK
            if (lindex-2 ge 0) then begin
                dlNext = line[lindex+1] - line[lindex]
                dl = line[lindex] - line[lindex-1]
                dlPrev = line[lindex-1] - line[lindex-2]

                if (dlNext ge dl and dl ge dlPrev) then begin
                endif else begin
                    if (dlNext le dl and dl le dlPrev) then begin
                    endif else begin
                        if (dlNext lt dl and dl gt dlPrev) then begin
                            parms[2,i,j] = parms[2,i,j] - 360.0
                        endif
                        if (dlNext gt dl and dl lt dlPrev) then begin
                            parms[2,i,j] = parms[2,i,j] + 360.0
                        endif
                    endelse

                endelse



;                if (dl lt 0 and $
;                        line[lindex-1] lt line[lindex]) then begin
;                    parms[2,i,j] = parms[2,i,j] + 360.0
;                endif
;
;                if (dl gt 0 and $
;                        line[lindex-1] gt line[lindex]) then begin
;                    parms[2,i,j] = parms[2,i,j] - 360.0
;                endif
            endif;lindex-1

            line = parms[2,*,j]
;            dl = deriv(line)
            (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
            ;temp = self->chirpFit(i,j,k,fixed=fixed)

        endfor;i
    endfor;j

end;checkLineFit

pro ooEcho::check180,io,jo,k,noborrow=noborrow,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::check180
;
;PURPOSE:
;       Check that neighboring phases are within 180deg.
;PARAMETERS:
;   io
;   jo
;   k
;   noborrow    Flag to do nothing
;KEYWORDS:
;   none
    ;self->addTreatment,'ooEcho::check180'


    ;CHECK THAT NEIGHBORING PHASES ARE WITHIN 180 deg
    ;OF EACH OTHER
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(noborrow) eq 0 then noborrow = 0

    if noborrow eq 0 then begin
        ;LOOP THROUGH SELECT SET OF LAYERS
        dummy = 0
        ;EXTRACT MATRIX FROM fitparms
        parms = reform((*self.fitparms)[*,*,k],$
                                  12,self.x_dim,self.y_dim)

        parmso = parms

        for layer=1,fix(self.x_dim/2) do begin

            ;SET MIN AND MAX INDICES RESTRICTED BY DATA INDEX RANGE
            maxi = min([io+layer,self.x_dim-1])
            mini = max([io-layer,0])
            maxj = min([jo+layer,self.y_dim-1])
            minj = max([jo-layer,0])

            for i=mini,maxi do begin
                for j = minj,maxj do begin
                    ;INCLUDE ALL OF CENTER OF AREA
                    if(((i le maxi) and (i ge mini)) and $
                       ((j le maxj) and (j ge minj))) then begin
                        ;print,i,j,layer
                        ;BUT EXCLUDE ALL BUT EDGE OF AREA
                        if((( (i eq mini)) and $
                                ((j le maxj) or (j ge minj))) or $
                           (( (i eq maxi)) and $
                                ((j le maxj) or (j ge minj))) or $
                           (( (j eq minj)) and $
                                ((i le maxi) or (i ge mini))) or $
                           (( (j eq maxj)) and $
                                ((i le maxi) or (i ge mini)))) then begin
                            ;print,i,j,layer,'Selected'

                            ;SELECT PHASE FOR COMPARISON
                            if (layer eq 1) then begin
                                phaseo = parms[2,io,jo]
                            endif else begin
                                if (i eq io) then ip = i
                                if (i lt io) then ip = i+1
                                if (i gt io) then ip = i-1
                                if (j eq jo) then jp = j
                                if (j lt jo) then jp = j+1
                                if (j gt jo) then jp = j-1
                                phaseo = parms[2,ip,jp]
                            endelse

    ;                        if abs(j-jo) eq 1 then begin
    ;                            print,i,j,phaseo,parms[2,i,j]
    ;                        endif

                            theMaxDiff = 170.0
                            ;DECREASE PHASE IF GE 180 FROM NEIGHBOR
                            if((parms[2,i,j]-phaseo) gt theMaxDiff) then begin
                                parms[2,i,j] = parms[2,i,j] - 360.0D
                                ;print,i,j,'changed'
                            endif
                            ;INCREASE PHASE IF LE -180 OFF FROM NEIGHBOR
                            if((parms[2,i,j]-phaseo) lt -1.0*theMaxDiff) $
                                                then begin
                                parms[2,i,j] = parms[2,i,j] + 360.0D
                                ;print,i,j,'changed'
                            endif
    ;                        print,i,j,parms[2,i,j],phaseo

                        endif;exclude center of area
                    endif;include area
                endfor;j
            endfor;i

            ;RESET FIT PARAMETERS BASED ON THIS CHECK
            ;print,parms[2,*,*]
            (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
            ;print,reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)

        endfor;layer
    endif;noborrow
;        print,'Parms'
;        aa = fix(reform(parms[2,*,*],self.x_dim,self.y_dim))
;        cc = fix(reform(parmso[2,*,*],self.x_dim,self.y_dim))
;        print,aa
;        ;print,'Fitparms'
;        bb = fix(reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim))
;        ;print,bb
;        print,'Old Diff'
;        print,cc-bb
;        ;print,'New Diff'
;        ;print,aa-bb
end;check180
pro ooEcho::check90Fit,io,jo,k,fixed=fixed,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::check90Fit
;
;PURPOSE:
;       Check that the fit is with 90 degrees of the neighbor.
;PARAMETERS:
;   io
;   jo
;   k
;KEYWORDS:
;   fixed


    ;self->addTreatment,'ooEcho::check90Fit'
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 



    ;CHECK THAT NEIGHBORING PHASES ARE WITHIN 180 deg
    ;OF EACH OTHER AND REFIT AFTER CHANGING PHASE

    ;LOOP THROUGH SELECT SET OF LAYERS
    dummy = 0
    ;EXTRACT MATRIX FROM fitparms
    parms = reform((*self.fitparms)[*,*,k],$
                              12,self.x_dim,self.y_dim)

    parmso = parms


    if n_elements(fixed) eq 6 then begin
        for iii = 0,5 do begin
            (*self.fixed)[iii,*,k] = fixed[iii]
        endfor;iii
    endif



    for layer=1,fix(self.x_dim/2) do begin

        ;SET MIN AND MAX INDICES RESTRICTED BY DATA INDEX RANGE
        maxi = min([io+layer,self.x_dim-1])
        mini = max([io-layer,0])
        maxj = min([jo+layer,self.y_dim-1])
        minj = max([jo-layer,0])

        for i=mini,maxi do begin
            for j = minj,maxj do begin
                ;INCLUDE ALL OF CENTER OF AREA
                if(((i le maxi) and (i ge mini)) and $
                   ((j le maxj) and (j ge minj))) then begin
                    ;print,i,j,layer
                    ;BUT EXCLUDE ALL BUT EDGE OF AREA
                    if((( (i eq mini)) and $
                            ((j le maxj) or (j ge minj))) or $
                       (( (i eq maxi)) and $
                            ((j le maxj) or (j ge minj))) or $
                       (( (j eq minj)) and $
                            ((i le maxi) or (i ge mini))) or $
                       (( (j eq maxj)) and $
                            ((i le maxi) or (i ge mini)))) then begin
                        ;print,i,j,layer,'Selected'

                        ;SELECT PHASE FOR COMPARISON
                        if (layer eq 1) then begin
                            phaseo = parms[2,io,jo]
                        endif else begin
                            if (i eq io) then ip = i
                            if (i lt io) then ip = i+1
                            if (i gt io) then ip = i-1
                            if (j eq jo) then jp = j
                            if (j lt jo) then jp = j+1
                            if (j gt jo) then jp = j-1
                            phaseo = parms[2,ip,jp]
                        endelse


                        theMaxDiff = 90.0
                        ;DECREASE PHASE IF GE 180 FROM NEIGHBOR
                        if((parms[2,i,j]-phaseo) gt theMaxDiff) then begin
                            parms[2,i,j] = parms[2,i,j] - 360.0D
                            ;temp = self->chirpFit(i,j,k,fixed=fixed)
                        endif
                        ;INCREASE PHASE IF LE -180 OFF FROM NEIGHBOR
                        if((parms[2,i,j]-phaseo) lt -1.0*theMaxDiff) $
                                            then begin
                            parms[2,i,j] = parms[2,i,j] + 360.0D
                            ;temp = self->chirpFit(i,j,k,fixed=fixed)
                        endif
        (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
        temp = self->chirpFit(i,j,k,fixed=fixed,tavestate=tavestate)

                    endif;exclude center of area
                endif;include area
            endfor;j
        endfor;i

        ;RESET FIT PARAMETERS BASED ON THIS CHECK
        ;print,parms[2,*,*]
        (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
;        temp = self->chirpFit(i,j,k,fixed=fixed)
        ;print,reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)

    endfor;layer
end;check90Fit
function ooEcho::gradDotRSurface,phaseSurf,_Extra=extra
;
;NAME:
;        ooEcho::gradDotRSurface
;
;PURPOSE:
;       Return the gradient dotted into r, the unit vector toward the center.
;PARAMETERS:
;       phaseSurf
;KEYWORDS:
;       none
;RETURN VALUE:
;       gradDotR
    ;self->addTreatment,'ooEcho::gradDotRSurface'

    ;CALCULATE AND RETURN A (GRADIENT).(UNIT VECTOR) SURFACE
    ;FOR EACH POINT IN A MATRIX, WHERE THE UNIT VECTOR POINTS DIRECTLY
    ;AWAY FROM THE CENTER PIXEL

    ;CALCULATE GRADIENT COMPONENTS OF SURFACE
    gradxPhaseSurf = phaseSurf-phaseSurf
    gradyPhaseSurf = phaseSurf-phaseSurf
    for i=0,self.x_dim-1 do begin
        gradxPhaseSurf[*,i] = deriv(phaseSurf[*,i])
    endfor
    for i=0,self.y_dim-1 do begin
        gradyPhaseSurf[i,*] = deriv(phaseSurf[i,*])
    endfor

    uxPhaseSurf = phaseSurf-phaseSurf
    uyPhaseSurf = phaseSurf-phaseSurf
    uPhaseSurfNorm = phaseSurf-phaseSurf
    gradDotR = phaseSurf-phaseSurf


    for j=0,self.x_dim-1 do begin
        for i=0,self.y_dim-1 do begin
            uxPhaseSurf[i,j] = self.x_dim/2 - i
            uyPhaseSurf[i,j] = self.y_dim/2 - j
            uPhaseSurfNorm[i,j] = sqrt(uxPhaseSurf[i,j]^2 $
                                      +uyPhaseSurf[i,j]^2)
            if (uPhaseSurfNorm[i,j] eq 0.0) then uPhaseSurfNorm[i,j] = 1.0

            ;NORMALIZE UNIT VECTOR COMPONENTS
            uxPhaseSurf[i,j] = uxPhaseSurf[i,j]/uPhaseSurfNorm[i,j]
            uyPhaseSurf[i,j] = uyPhaseSurf[i,j]/uPhaseSurfNorm[i,j]

            gradDotR[i,j] = uxPhaseSurf[i,j]*gradxPhaseSurf[i,j] +$
                            uyPhaseSurf[i,j]*gradyPhaseSurf[i,j]


        endfor;i
    endfor;j


    return,gradDotR

end;gradDotRSurface
function ooEcho::gradDotUSurface,phaseSurf,_Extra=extra
;
;NAME:
;        ooEcho::gradDotUSurface
;
;PURPOSE:
;       Return the gradient dotted into u, the diagonal toward the center.
;PARAMETERS:
;       phaseSurf
;KEYWORDS:
;       none
;RETURN VALUE:
;       gradDotU
    ;self->addTreatment,'ooEcho::gradDotUSurface'


    ;CALCULATE AND RETURN A (GRADIENT).(UNIT VECTOR) SURFACE
    ;FOR EACH POINT IN A MATRIX, WHERE THE UNIT VECTOR RUNS
    ;ALONG A DIAGONAL MORE OR LESS IN THE DIRECTION OF THE
    ;CENTRAL PIXEL

    prevPtU = self->previousPointU(phaseSurf)
    prev2PtU = self->twoPointsPreviousU(phaseSurf)
    gradDotU = phaseSurf-phaseSurf
    for j=0,self.x_dim-1 do begin
        for i=0,self.y_dim-1 do begin
            gradDotU[i,j] = phaseSurf[i,j] -$
                    phaseSurf[prevPtU[0,i,j],prevPtU[1,i,j]] ;- $
                    ;phaseSurf[prev2PtU[0,i,j],prev2PtU[1,i,j]]

        endfor;i
    endfor;j

    return,gradDotU
end;gradDotUSurface
function ooEcho::previousPointU,phaseSurf,_Extra=extra
;
;NAME:
;        ooEcho::previousPointU
;
;PURPOSE:
;       Get the next closer point along the direct line to the center
;PARAMETERS:
;       phaseSurf
;KEYWORDS:
;       none
;RETURN VALUE:
;   The index of the previous point.
    ;self->addTreatment,'ooEcho::previousPointU'

    ;CALCULATE AND RETURN A VECTOR SURFACE
    ;FOR EACH POINT IN A MATRIX, WHERE THE UNIT VECTOR RUNS
    ;ALONG A DIAGONAL MORE OR LESS IN THE DIRECTION OF THE
    ;CENTRAL PIXEL

    uxPhaseSurf = phaseSurf-phaseSurf
    uyPhaseSurf = phaseSurf-phaseSurf
    iprevU = intarr(2,self.x_dim,self.y_dim)

    for j=0,self.x_dim-1 do begin
        for i=0,self.y_dim-1 do begin
            if i gt self.x_dim/2 then uxPhaseSurf[i,j] = -1
            if i eq self.x_dim/2 then uxPhaseSurf[i,j] = 0
            if i lt self.x_dim/2 then uxPhaseSurf[i,j] = 1

            if j gt self.y_dim/2 then uyPhaseSurf[i,j] = -1
            if j eq self.y_dim/2 then uyPhaseSurf[i,j] = 0
            if j lt self.y_dim/2 then uyPhaseSurf[i,j] = 1

            iprevU[0,i,j] = i + uxPhaseSurf[i,j]
            iprevU[1,i,j] = j + uyPhaseSurf[i,j]

        endfor;i
    endfor;j

    return,iprevU
end;previousPointU
function ooEcho::twoPointsPreviousU,phaseSurf,_Extra=extra
;
;NAME:
;        ooEcho::twoPointsPreviousU
;
;PURPOSE:
;       Get the pixel two points closer to the center along the direct line.
;PARAMETERS:
;   phaseSurf
;KEYWORDS:
;   none
;RETURN VALUE:
;   The index
    ;self->addTreatment,'ooEcho::twoPointsPreviousU'


    ;CALCULATE AND RETURN A VECTOR SURFACE
    ;FOR EACH POINT IN A MATRIX, WHERE THE UNIT VECTOR RUNS
    ;ALONG A DIAGONAL MORE OR LESS IN THE DIRECTION OF THE
    ;CENTRAL PIXEL

    uxPhaseSurf = phaseSurf-phaseSurf
    uyPhaseSurf = phaseSurf-phaseSurf
    iprevU = intarr(2,self.x_dim,self.y_dim)

    for j=0,self.x_dim-1 do begin
        for i=0,self.y_dim-1 do begin
            if i gt self.x_dim/2 then uxPhaseSurf[i,j] = -2
            if i eq self.x_dim/2 then uxPhaseSurf[i,j] = 0
            if i lt self.x_dim/2 then uxPhaseSurf[i,j] = 2

            if j gt self.y_dim/2 then uyPhaseSurf[i,j] = -2
            if j eq self.y_dim/2 then uyPhaseSurf[i,j] = 0
            if j lt self.y_dim/2 then uyPhaseSurf[i,j] = 2

            iprevU[0,i,j] = i + uxPhaseSurf[i,j]
            iprevU[1,i,j] = j + uyPhaseSurf[i,j]

        endfor;i
    endfor;j

    return,iprevU
end;twoPointsPreviousU

function ooEcho::previousPoint,phaseSurf,_Extra=extra
;
;NAME:
;        ooEcho::previousPoint
;
;PURPOSE:
;   Get the index of the next closer point to the center.
;PARAMETERS:
;   phaseSurf
;KEYWORDS:
;   none
;RETURN VALUE:
;   The index of the next closer point to the center.
    ;self->addTreatment,'ooEcho::previousPoint'

    ;CALCULATE THE 'PREVIOUS POINT', I.E. THE VALUE
    ;OF THE NEXT POINT CLOSER TO THE CENTER FROM
    ;THE CURRENT POINT.


    ;PERHAPS THIS COULD BE DONE AS A MATRIX CONTAINING
    ;SETS OF INDICES.

    uxPhaseSurf = phaseSurf-phaseSurf
    uyPhaseSurf = phaseSurf-phaseSurf
    uPhaseSurfNorm = phaseSurf-phaseSurf

    ;GENERATE ARRAY OF 1x2 MATRICES
    ;THESE WILL BE THE COORDINATES OF THE 'PREVIOUS POINTS'
    ;AT EACH POSITION ON THE IMAGE

    iprev = indgen(2,self.x_dim,self.y_dim)

    iprev[*,self.x_dim/2,self.y_dim/2] = [self.x_dim/2,self.y_dim/2]

    for j=0,self.x_dim-1 do begin
        for i=0,self.y_dim-1 do begin

            ;EACH COMPONENT IS DISTANCE TO CENTER ALONG
            ;THAT AXIS
            uxPhaseSurf[i,j] = i - self.x_dim/2
            uyPhaseSurf[i,j] = j - self.y_dim/2
            uPhaseSurfNorm[i,j] = sqrt(uxPhaseSurf[i,j]^2 $
                                      +uyPhaseSurf[i,j]^2)

            ;SET NORMALIZATION FACTOR TO 1.0 IF AT CENTER OF DETECTOR
            ;TO PREVENT DIVIDE-BY-ZERO
            if (uPhaseSurfNorm[i,j] eq 0.0) then uPhaseSurfNorm[i,j] = 1.0

            ;NORMALIZE UNIT VECTOR COMPONENTS
            uxPhaseSurf[i,j] = uxPhaseSurf[i,j]/uPhaseSurfNorm[i,j]
            uyPhaseSurf[i,j] = uyPhaseSurf[i,j]/uPhaseSurfNorm[i,j]

            iprevInit = i - uxPhaseSurf[i,j]
            jprevInit = j - uyPhaseSurf[i,j]

                ;SET IMAGE PIXEL INDICES FROM THE DATA COORDINATES
            xindex = fix(iprevInit)
            yindex = fix(jprevInit)

            ;ENSURE THAT THE IMAGE PIXEL INDICES ARE IN THE
            ;RANGE OF THE IMAGE DIMENSIONS
            if (xindex ge self.x_dim) then $
                xindex = self.x_dim-1
            if (xindex le 0) then xindex = 0
            if (yindex ge self.y_dim) then $
                    yindex = self.y_dim-1
            if (yindex le 0) then yindex = 0

            if (not ((i eq self.x_dim/2) and (j eq self.y_dim/2))) then $
                        iprev[*,i,j] = [xindex,yindex]
        endfor;i
    endfor;j

    return,iprev

end;previousPoint
function ooEcho::twoPointsPrevious,phaseSurf,_Extra=extra
;
;NAME:
;        ooEcho::twoPointsPrevious
;
;PURPOSE:
;       Get the index of the chosen point.
;PARAMETERS:
;       phaseSurf
;KEYWORDS:
;       none
;RETURN VALUE:
;       The index of the selected point.

    ;self->addTreatment,'ooEcho::twoPointsPrevious'


    ;CALCULATE THE 'POINT BEFORE THE PREVIOUS POINT', I.E. THE VALUE
    ;OF THE POINT TWO UNITS CLOSER TO THE CENTER FROM
    ;THE CURRENT POINT.


    ;PERHAPS THIS COULD BE DONE AS A MATRIX CONTAINING
    ;SETS OF INDICES.

    uxPhaseSurf = phaseSurf-phaseSurf
    uyPhaseSurf = phaseSurf-phaseSurf
    uPhaseSurfNorm = phaseSurf-phaseSurf

    ;GENERATE ARRAY OF 1x2 MATRICES
    ;THESE WILL BE THE COORDINATES OF THE 'PREVIOUS POINTS'
    ;AT EACH POSITION ON THE IMAGE

    iprev = intarr(2,self.x_dim,self.y_dim)

    iprev[*,(self.x_dim/2)+1,(self.y_dim/2)+1]  = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2)+1,(self.y_dim/2)]    = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2)+1,(self.y_dim/2)-1]  = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2),(self.y_dim/2)+1]    = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2),(self.y_dim/2)]      = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2),(self.y_dim/2)-1]    = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2)-1,(self.y_dim/2)+1]  = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2)-1,(self.y_dim/2)]    = [self.x_dim/2,self.y_dim/2]
    iprev[*,(self.x_dim/2)-1,(self.y_dim/2)-1]  = [self.x_dim/2,self.y_dim/2]

    for j=0,self.x_dim-1 do begin
        for i=0,self.y_dim-1 do begin

            if ((abs(self.x_dim/2 - i) gt 1) and $
                (abs(self.y_dim/2 - j) gt 1)) then begin
                ;EACH COMPONENT IS DISTANCE TO CENTER ALONG
                ;THAT AXIS
                uxPhaseSurf[i,j] = i - self.x_dim/2
                uyPhaseSurf[i,j] = j - self.y_dim/2
                uPhaseSurfNorm[i,j] = sqrt(uxPhaseSurf[i,j]^2 $
                                          +uyPhaseSurf[i,j]^2)

                ;SET NORMALIZATION FACTOR TO 1.0 IF AT CENTER OF DETECTOR
                ;TO PREVENT DIVIDE-BY-ZERO
                if (uPhaseSurfNorm[i,j] eq 0.0) then uPhaseSurfNorm[i,j] = 1.0

                ;NORMALIZE UNIT VECTOR COMPONENTS
                uxPhaseSurf[i,j] = uxPhaseSurf[i,j]/uPhaseSurfNorm[i,j]
                uyPhaseSurf[i,j] = uyPhaseSurf[i,j]/uPhaseSurfNorm[i,j]

                ;GO TWO STEPS ALONG UNIT VECTOR TOWARD CENTER
                iprevInit = i - 2.0*uxPhaseSurf[i,j]
                jprevInit = j - 2.0*uyPhaseSurf[i,j]

                ;SET IMAGE PIXEL INDICES FROM THE DATA COORDINATES
                xindex = fix(iprevInit)
                yindex = fix(jprevInit)

                ;ENSURE THAT THE IMAGE PIXEL INDICES ARE IN THE
                ;RANGE OF THE IMAGE DIMENSIONS
                if (xindex ge self.x_dim) then $
                                xindex = self.x_dim-1
                if (xindex le 0) then xindex = 0
                if (yindex ge self.y_dim) then $
                                yindex = self.y_dim-1
                if (yindex le 0) then yindex = 0

                ;if (not ((i eq self.x_dim/2) and (j eq self.y_dim/2))) then $
                iprev[*,i,j] = [xindex,yindex]
                ;print,i,j,iprev[*,i,j]
            endif;(abs() gt 1)
        endfor;i
    endfor;j

    return,iprev

end;twoPointsPrevious

pro ooEcho::checkGradientFit,io,jo,k,fixed=fixed,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::checkGradientFit
;
;PURPOSE:
;       Check phases in a gradient out from the center.  I don't know if this is used.
;       The treatment pointer should confirm this.
;PARAMETERS:
;       io
;       jo
;       k
;KEYWORDS:
;       fixed   The array of 1s & 0s for fixing parameters.
    ;self->addTreatment,'ooEcho::checkGradientFit'

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    ;THIS METHOD IS MEANT TO CHECK THE SLOPE OF
    ;THE PHASE SURFACE ALONG A DIAGONAL AND CHECK
    ;FOR CONTINUOUS VARIATION, ESPECIALLY IN CASES
    ;WHERE THE 180deg TEST FAILS.

    ;LOOP THROUGH SELECT SET OF LAYERS
    dummy = 0
    ;EXTRACT MATRIX FROM fitparms
    parms = reform((*self.fitparms)[*,*,k],$
                              12,self.x_dim,self.y_dim)


    if n_elements(fixed) eq 6 then begin
        for iii = 0,5 do begin
            (*self.fixed)[iii,*,k] = fixed[iii]
        endfor;iii
    endif




    ;MAKE SEPARATE PHASE SURFACE
    phaseSurf = reform(parms[2,*,*],self.x_dim,self.y_dim)

    gradDotR = self->gradDotRSurface(phaseSurf)
    gradDotU = self->gradDotUSurface(phaseSurf)

    ;USE THE GRADIENT DOTTED WITH THE UNIT VECTOR AT EACH
    ;POINT AND SELECT THE PREVIOUS POINT ALONG UNIT VECTOR

    ;WHY NOT ALSO CREATE A 'PREVIOUS POINT' MATRIX!!!
    ;THIS WOULD BE A FUNCTION TO SELECT THE PREVIOUS
    ;POINT ALONG A UNIT VECTOR TOWARD THE CENTER OF THE
    ;DETECTOR

    prevPt = self->previousPoint(phaseSurf)
    prevPt = self->previousPointU(phaseSurf)
    prev2Pt = self->twoPointsPrevious(phaseSurf)

    ;NOW RUN THROUGH LAYERS AND FLIP PHASES AS NECESSARY
    ;AND ALSO ALTER THE gradDotU MATRIX AS NECESSARY
    ;
    ;DON'T WORRY ABOUT EFFICIENCY YET.


    for layer=4,fix(self.x_dim/2) do begin

        ;SET MIN AND MAX INDICES RESTRICTED BY DATA INDEX RANGE
        maxi = min([io+layer,self.x_dim-1])
        mini = max([io-layer,0])
        maxj = min([jo+layer,self.y_dim-1])
        minj = max([jo-layer,0])

        for i=mini,maxi do begin
            for j = minj,maxj do begin
                ;INCLUDE ALL OF CENTER OF AREA
                if(((i le maxi) and (i ge mini)) and $
                   ((j le maxj) and (j ge minj))) then begin
                    ;BUT EXCLUDE ALL BUT EDGE OF AREA
                    if((( (i eq mini)) and $
                            ((j le maxj) or (j ge minj))) or $
                       (( (i eq maxi)) and $
                            ((j le maxj) or (j ge minj))) or $
                       (( (j eq minj)) and $
                            ((i le maxi) or (i ge mini))) or $
                       (( (j eq maxj)) and $
                            ((i le maxi) or (i ge mini)))) then begin


;                       print,layer,i,j,prevPt[*,i,j],$
;                            'gradDotU =',gradDotU[i,j],$
;                            ' phaseSurf=',phaseSurf[i,j],$
;                            ' prevPt phaseSurf=',$
;                            phaseSurf[prevPt[0,i,j],prevPt[1,i,j]]
                        ;print,prevPt[*,i,j]
                        if ((gradDotU[prevPt[0,i,j],prevPt[1,i,j]] gt 0) and $
                           (phaseSurf[i,j] lt $
                            phaseSurf[prevPt[0,i,j],prevPt[1,i,j]]))$
                            then begin
                                ;if (gradDotU[prevPt[0,i,j],prevPt[1,i,j]] gt 0) then begin
                                    ;if (phaseSurf[i,j] gt phaseSurf[prev2Pt[0,i,j],prev2Pt[1,i,j]]) then begin
                                        ;print,i,j,'phaseSurf+360'
                                        ;NEXT:
                                        ;   1) CHANGE phaseSurf[i,j]
                                        ;   2) REFIT POINT
                                        ;
                                        ;   3) RECALCULATE gradDotU MATRIX FOR
                                        ;      phaseSurf --- JUST USE ALTERED
                                        ;      phaseSurf, DON'T USE RESET FITPARMS
                                        phaseSurf[i,j] = phaseSurf[i,j] + 360.0
                                        ;print,parms[2,i,j]
                                        parms[2,i,j] = parms[2,i,j] + 360.0
                                        ;print,parms[2,i,j]
                                        (*self.fitparms)[2,*,k] = reform(parms[2,*,*],self.x_dim*self.y_dim)
                                        temp = self->chirpFit(i,j,k,fixed=fixed,tavestate=tavestate)
                                        gradDotU = self->gradDotUSurface(phaseSurf)
                                    ;endif
                                ;endif
                            endif else begin
                                if ((gradDotU[prevPt[0,i,j],prevPt[1,i,j]] lt 0) and $
                                    (phaseSurf[i,j] gt $
                                    phaseSurf[prevPt[0,i,j],prevPt[1,i,j]]))$
                                    then begin
                                        ;if (gradDotU[prevPt[0,i,j],prevPt[1,i,j]] lt 0) then begin
                                            ;if (phaseSurf[i,j] lt phaseSurf[prev2Pt[0,i,j],prev2Pt[1,i,j]]) then begin
                                                ;print,i,j,'phaseSurf-360'
                                                phaseSurf[i,j] = phaseSurf[i,j] - 360.0
                                                ;print,parms[2,i,j]
                                                parms[2,i,j] = parms[2,i,j] - 360.0
                                                ;print,parms[2,i,j]
                                                (*self.fitparms)[2,*,k] = reform(parms[2,*,*],self.x_dim*self.y_dim)
                                                temp = self->chirpFit(i,j,k,fixed=fixed,tavestate=tavestate)
                                                gradDotU = self->gradDotUSurface(phaseSurf)
                                            ;endif
                                        ;endif
                                endif
                            endelse


                    endif;exclude center of area
                endif;include area
            endfor;j
        endfor;i
    endfor;layer


   (*self.fitparms)[2,*,k] = reform(parms[2,*,*],self.x_dim*self.y_dim)
;    ;FOR COMPARISON FOR POSSIBLE 360deg PHASE CHANGE
;    for layer=2,fix(self.x_dim/2) do begin
;
;        ;SET MIN AND MAX INDICES RESTRICTED BY DATA INDEX RANGE
;        maxi = min([io+layer,self.x_dim-1])
;        mini = max([io-layer,0])
;        maxj = min([jo+layer,self.y_dim-1])
;        minj = max([jo-layer,0])
;
;        for i=mini,maxi do begin
;            for j = minj,maxj do begin
;                ;INCLUDE ALL OF CENTER OF AREA
;                if(((i le maxi) and (i ge mini)) and $
;                   ((j le maxj) and (j ge minj))) then begin
;                    ;BUT EXCLUDE ALL BUT EDGE OF AREA
;                    if((( (i eq mini)) and $
;                            ((j le maxj) or (j ge minj))) or $
;                       (( (i eq maxi)) and $
;                            ((j le maxj) or (j ge minj))) or $
;                       (( (j eq minj)) and $
;                            ((i le maxi) or (i ge mini))) or $
;                       (( (j eq maxj)) and $
;                            ((i le maxi) or (i ge mini)))) then begin
;
;
;        (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
;        temp = self->chirpFit(i,j,k,fixed=fixed)
;
;
;                    endif;exclude center of area
;                endif;include area
;            endfor;j
;        endfor;i
;
;        ;RESET FIT PARAMETERS BASED ON THIS CHECK
;        (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
;
;    endfor;layer
;
;
;    if (self.x_dim/2 gt 7 and self.y_dim/2 gt 7) then begin
;    for layer=2,fix(self.x_dim/2) do begin
;
;        ;SET MIN AND MAX INDICES RESTRICTED BY DATA INDEX RANGE
;        maxi = min([io+layer,self.x_dim-1])
;        mini = max([io-layer,0])
;        maxj = min([jo+layer,self.y_dim-1])
;        minj = max([jo-layer,0])
;
;        for i=mini,maxi do begin
;            for j = minj,maxj do begin
;                ;INCLUDE ALL OF CENTER OF AREA
;                if(((i le maxi) and (i ge mini)) and $
;                   ((j le maxj) and (j ge minj))) then begin
;                    ;print,i,j,layer
;                    ;BUT EXCLUDE ALL BUT EDGE OF AREA
;                    if((( (i eq mini)) and $
;                            ((j le maxj) or (j ge minj))) or $
;                       (( (i eq maxi)) and $
;                            ((j le maxj) or (j ge minj))) or $
;                       (( (j eq minj)) and $
;                            ((i le maxi) or (i ge mini))) or $
;                       (( (j eq maxj)) and $
;                            ((i le maxi) or (i ge mini)))) then begin
;                        ;print,i,j,layer,'Selected'
;
;
;                        ;SELECT PIXEL INDICES FOR
;                        ;GRADIENT CALCULATION
;                        width = 2
;                        unit = [0.0,0.0]
;                        ig = intarr(2)
;                        if ((i ge io-width) and (i le io+width)) then begin
;                            ig[0] = i & ig[1] = i
;                            ip = i
;                            unit[0] = 0.0
;                        endif
;                        if (i lt io-width) then begin
;                            ig[0] = i+1 & ig[1] = i+2
;                            ip = i+1
;                            unit[0] = -1.0
;                        endif
;                        if (i gt io+width) then begin
;                            ig[0] = i-2 & ig[1] = i-1
;                            ip = i-1
;                            unit[0] = 1.0
;                        endif
;
;                        jg = intarr(2)
;                        if ((j ge jo-width) and (j le jo+width)) then begin
;                            jg[0] = j & jg[1] = j
;                            jp = j
;                            unit[1] = 0.0
;                        endif
;                        if (j lt jo-width) then begin
;                            jg[0] = j+1 & jg[1] = j+2
;                            jp = j+1
;                            unit[1] = -1.0
;                        endif
;                        if (j gt jo+width) then begin
;                            jg[0] = j-2 & jg[1] = j-1
;                            jp = j-1
;                            unit[1] = 1.0
;                        endif
;                        unitSize = sqrt(unit[0]^2 + unit[1]^2)
;                        unit = unit/unitSize
;
;                        ;CALCULATE GRADIENT
;                        grad = dblarr(2)
;                        grad[0] = parms[2,ig[1],jg[0]] - parms[2,ig[0],jg[0]]
;                        grad[1] = parms[2,ig[0],jg[1]] - parms[2,ig[0],jg[0]]
;
;                        ;CALCULATE DIVERGENCE ALONG UNIT DIRECTION
;                        divergence = total(grad*unit)
;
;                        if ((divergence gt 0) and $
;                            parms[2,i,j] lt parms[2,ip,jp]) then $
;                                parms[2,i,j] = parms[2,i,j]+360.0
;                        if ((divergence lt 0) and $
;                            parms[2,i,j] gt parms[2,ip,jp]) then $
;                                parms[2,i,j] = parms[2,i,j]-360.0
;        (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
;        temp = self->chirpFit(i,j,k,fixed=fixed)
;
;
;                    endif;exclude center of area
;                endif;include area
;            endfor;j
;        endfor;i
;
;        ;RESET FIT PARAMETERS BASED ON THIS CHECK
;        (*self.fitparms)[*,*,k] = reform(parms,12,self.x_dim*self.y_dim)
;        ;temp = self->chirpFit(i,j,k,fixed=fixed)
;
;        ;print,reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)
;
;    endfor;layer
;    endif else begin
;        print,'THE PHASE SURFACE DIMENSIONS ARE TOO SMALL FOR AN '$
;                +'EFFECTIVE GRADIENT CHECK'
;    endelse

end;checkGradientFit

pro ooEcho::surfFit,io,jo,k,x1,x2,y1,y2,obj=obj,_Extra=extra
;
;NAME:
;        ooEcho::surfFit
;
;PURPOSE:
;           Do a surface fit for the phases.    Note:   Never quite worked out
;                                                       and I don't think it is used.
;PARAMETERS:
;       io
;       jo
;       k
;       x1
;       x2
;       y1
;       y2
;KEYWORDS:
;       obj     Display object to update.

    ;self->addTreatment,'ooEcho::surfFit'

    ;THE PURPOSE OF THIS METHOD IS TO FIT A SINGLE SURFACE
    ;OF PHASE VALUES

    dummy = 0

    ;GET MIN AND MAX INDICES BASED ON LAYER NUMBER
;    maxi = min([io+layer,self.x_dim])
;    mini = max([io-layer,0])
;    maxj = min([jo+layer,self.y_dim])
;    minj = max([jo-layer,0])
    ;FIT THE PHASE SURFACE FOR THIS LAYER

    ;SAVE A 2D COPY OF DATA AT THIS SCOPE
    matNew = reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)

    ;PERFORM NEXT BLOCK ONLY ON LAYERS WHERE THE
    ;RETURNED MATRIX WILL FIT IN THE

;        ;GET INDICES FOR SELECTED AREA OF PHASE SURFACE
;        x1 = max([io-layer,0])
;        x2 = min([io+layer,self.x_dim-1])
;        y1 = max([io-layer,0])
;        y2 = min([jo+layer,self.y_dim-1])

    ;STORE CENTER RANGE OF SELECTED AREA TO BE REPLACED
    matNewCen = matNew[x1:x2,y1:y2]

    ;GET ENTIRE PHASE MATRIX AND ERROR BARS IN 2D FORM
    mat = reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)
    smat = reform((*self.fitparms)[8,*,k],self.x_dim,self.y_dim)
    ;FIT THE CURRENT AREA AND GET A NEW AREA WITH ADDED LAYER
    ;dummy = tryfit2(self,x1,x2,y1,y2,k,mat,smat)
    dummy = tryfit3(self,x1,x2,y1,y2,k,mat,smat)

    ;CREATE MATRIX OF FIT VALUES -- dummy

    ;OVERWRITE CENTER OF dummy WITH THE SAVED CENTER
    szdummy = size(dummy)
    ;REPLACE SELECTED AREA OF ORIGINAL MATRIX WITH
    matNew[x1-1:x2+1,y1-1:y2+1] = dummy



    ;RESTORE FITPARM'S PHASE ARRAY WITH POSSIBLY ALTERED
    ;PHASE ARRAY (NOTE CONVERSION FROM 2D TO 1D)
    ;
    (*self.fitparms)[2,*,k] = reform(matNew,self.x_dim*self.y_dim)

;    if (n_elements(obj) gt 0) then begin
;        obj->draw
;    endif


end;surfFit
pro ooEcho::layerFit,io,jo,k,obj=obj,_Extra=extra
;
;NAME:
;        ooEcho::layerFit
;
;PURPOSE:
;        Fit in layers out from center.
;PARAMETERS:
;       io  indices of x,y, center.
;       jo
;       k   Fourier time index
;KEYWORDS:
;       obj     An optional diplay object reference to update.
    ;self->addTreatment,'ooEcho::layerFit'


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;                ;NOW NEED TO FIT OUTWARD FROM CENTER
;;;;;                ;TO ENCOURAGE SMOOTH VARIATION IN
;;;;;                ;PHASE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


    ;LOOP THROUGH SELECT SET OF LAYERS
    dummy = 0
    for layer=1,fix(self.x_dim/2) do begin
        ;print,'Layer = ',layer

        ;layery = fix(self.y_dim/2) ;NEED TO FIX layery BEFORE ALLOWING
        ;                           ;UNEQUAL X AND Y DIMENSIONS
        ;newtemp = 0.0
        ;newtemp2 = 0.0

        maxi = min([io+layer,self.x_dim])
        mini = max([io-layer,0])
        maxj = min([jo+layer,self.y_dim])
        minj = max([jo-layer,0])

        for i=mini,maxi do begin
            temp = 0.0
            for j = minj,maxj do begin
                ;INCLUDE ALL OF CENTER OF AREA
;                if((not (i ge self.x_dim)) and (not (i lt 0)) and $
;                   (not (j ge self.y_dim)) and (not (j lt 0))) then begin
                if((not (i ge maxi)) and (not (i lt mini)) and $
                   (not (j ge maxj)) and (not (j lt minj))) then begin
                    ;EXCLUDE ALL BUT EDGE OF AREA
                    if((( (i le mini+1)) and $
                            ((j le maxj-1) or (j gt minj-1))) or $
                       (( (i ge maxi-1)) and $
                            ((j le maxj-1) or (j gt minj-1))) or $
                       (( (j le minj+1)) and $
                            ((i le maxi-1) or (i gt mini-1))) or $
                       (( (j ge maxj-1)) and $
                            ((i le maxi-1) or (i gt mini-1)))) then begin

                        ;EXTRACT MATRIX FROM fitparms
                        parms = reform((*self.fitparms)[*,*,k],$
                                                12,self.x_dim,self.y_dim)

                        ;SELECT PARMS AT THIS PIXEL FOR STARTPARMS
                        if (layer eq 1) then begin
                            startparms = parms[0:5,io,jo]
                        endif else begin
                            startparms = parms[0:5,i,j]
                        endelse

                        ;print,i,j,startparms,(*self.chisq)[j*self.x_dim+i,k]

                        ;FIT THIS ECHO
                        temp = self->chirpFit(i,j,k,fixed=fixed,$
                                            limited=limited,$
                                            parmlims=parmlims)

                        ;CHECK THAT CURRENT PHASE IS CLOSE TO PREVIOUS
                        ;PHASE AND IF NOT, REFIT WITH PREVIOUS PHASE
                        ;AS STARTING VALUE
;                        temp = self->checkAndRefit(i,j,k,temp,$
;                                                startparms,$
;                                                fixed = fixed,$
;                                                limited = limited,$
;                                                parmlims = parmlims,$
;                                                io,jo,dummy=dummy)
                    endif;exclude center of area
                endif;include area

            endfor;j
        endfor;i

        ;;RESET STARTING FIT PARAMETER
        ;if (n_elements(newtemp2) gt 1) then startparms = newtemp2[0:5]

        ;BEFORE MOVING TO NEXT LAYER, FIT THE
        ;PHASE SURFACE FOR THIS ONE AND SET THE
        ;fitparms MATRIX EDGES TO PREPARE
        ;STARTING PARAMETERS FOR THE NEXT LAYER


        ;SAVE A 2D COPY OF DATA AT THIS SCOPE
        matNew = reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)


        ;THE BODY OF THE FOLLOWING if STATEMENT SEEMS
        ;TO BE PERFECTLY GENERAL FOR ALL LAYERS > 0

        ;PERFORM NEXT BLOCK ONLY ON LAYERS WHERE THE
        ;RETURNED MATRIX WILL FIT IN THE
        if((layer ge 1) and (layer lt io-1)) then begin

            ;GET INDICES FOR SELECTED AREA OF PHASE SURFACE
            x1 = max([io-layer,0])
            x2 = min([io+layer,self.x_dim-1])
            y1 = max([io-layer,0])
            y2 = min([jo+layer,self.y_dim-1])

            ;STORE CENTER RANGE OF SELECTED AREA TO BE REPLACED
            matNewCen = matNew[x1:x2,y1:y2]

            ;GET ENTIRE PHASE MATRIX AND ERROR BARS IN 2D FORM
            mat = reform((*self.fitparms)[2,*,k],self.x_dim,self.y_dim)
            smat = reform((*self.fitparms)[8,*,k],self.x_dim,self.y_dim)

            ;FIT THE CURRENT AREA AND GET A NEW AREA WITH ADDED LAYER
            ;dummy = tryfit2(self,x1,x2,y1,y2,k,mat,smat)
            dummy = tryfit3(self,x1,x2,y1,y2,k,mat,smat)

            ;;print,'dummy'
            ;;print,dummy
            ;CREATE MATRIX OF FIT VALUES -- dummy

            ;OVERWRITE CENTER OF dummy WITH THE SAVED CENTER
            szdummy = size(dummy)
            ;dummy[1:szdummy[1]-2,1:szdummy[2]-2] = matNewCen

            ;REPLACE SELECTED AREA OF ORIGINAL MATRIX WITH
            matNew[x1-1:x2+1,y1-1:y2+1] = dummy

            ;THEN PUT RESULTING dummy INTO THE PHASE SURFACE ARRAY
            ;TO BEGIN NEXT FIT CYCLE.

        endif else begin;if 1<=layer<io-1
            dummy = 0
        endelse
        if (n_elements(obj) gt 0) then begin
            obj->draw
        endif
    endfor;layer

    ;RESTORE FITPARM'S PHASE ARRAY WITH POSSIBLY ALTERED
    ;PHASE ARRAY (NOTE CONVERSION FROM 2D TO 1D)
    ;
    ;NOTE:  matNew DOES NOT CHANGE IF THE ABOVE if BLOCK
    ;       IS NOT EXECUTED.
    (*self.fitparms)[2,*,k] = reform(matNew,self.x_dim*self.y_dim)


end;layerFit

function ooEcho::checkAndRefit,i,j,k,temp,startparms,$
                                fixed=fixed,$
                                limited=limited,$
                                parmlims=parmlims,$
                                io,jo,dummy=dummy,$
                                tavestate=tavestate,$
                                _Extra=extra
;
;NAME:
;        ooEcho::checkAndRefit
;
;PURPOSE:
;           Check the phase differences and refit as necessary.
;PARAMETERS:
;           i           the x,y pixel indices.
;           j
;           k           the Fourier time index
;           temp        temporary startparm variable
;           startparms  The starting parameters for the fit
;           io          The center indices
;           jo
;KEYWORDS:
;           fixed
;           limited
;           parmlims
;           dummy
;RETURN VALUE:
;
    ;self->addTreatment,'ooEcho::checkAndRefit'

    ;print,(*self.chisq)[j*self.x_dim + i,k]

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 


    if n_elements(temp) lt 6 then temp = startparms
    absdiffmax = 45.0
    ;CHECK THAT CURRENT PHASE IS CLOSE TO PREVIOUS
    ;PHASE AND REFIT WITH PREVIOUS PHASE AS
    ;STARTING PHASE IF NOT
    absdiff = abs(temp[2] - startparms[2])
    if (absdiff gt absdiffmax) then begin
        ;GET CONST ESTIMATE FROM DATA FOR THIS ECHO
        temp[0] = self->chirpOffset(i,j,k)
        ;GET AMPLITUDE ESTIMATE FROM DATA FOR THIS ECHO
        temp[1] = self->chirpAmplitude(i,j,k,tavestate=tavestate)
        ;USE ORIGINAL STARTING PHASE FOR THIS VALUE
        temp[2] = startparms[2]
        temp = temp[0:5]
        temp = self->chirpFit(i,j,k,fixed=fixed,$
                            limited=limited,$
                            startparms=temp,$
                            parmlims=parmlims,tavestate=tavestate)
    endif

    newdiff = abs(temp[2] - (self->fitvals(i,j,k))[2])
    if (newdiff gt 180.0) then begin
        temp[0] = self->chirpOffset(i,j,k)
        temp[1] = self->chirpAmplitude(i,j,k,tavestate=tavestate)
        temp[2] = (self->fitvals(i,j,k))[2]
        temp = temp[0:5]
        temp = self->chirpFit(i,j,k,fixed=fixed,$
                            limited=limited,$
                            startparms=temp,$
                            parmlims=parmlims,tavestate=tavestate)
    endif


end;checkAndRefit

;;
;SURFACE FITTING METHODS (FOR GLOBAL PHASE FITS)
;;;
;;;USE tryfit.pro, tryfit2.pro, tryfit3.pro FOR NOW.

;;;;;;;;;;;;;;;;;;;;;
;;
;UTILITY METHODS
;
;set1DMask
;set2DMask
;proximity1D
;;;
pro ooEcho::grabPhasesFrom,obj,_Extra=extra
;
;NAME:
;        ooEcho::grabPhasesFrom
;
;PURPOSE:
;       Get phases from obj.
;PARAMETERS:
;       obj     The object to get the phases from
;KEYWORDS:
;       none
    ;self->addTreatment,'ooEcho::grabPhasesFrom'


    ;IMPORT PHASES FROM ANOTHER ooEcho OBJECT
    ;WITH THE SAME DIMENSIONS.

    if obj_valid(obj) then begin
        newParms = *(obj->getProperty(tag='fitparms'))
        sz1 = size(newParms)
        sz2 = size(*self.fitparms)
        ;print,sz1
        ;print,sz2

        if n_elements(sz1) eq n_elements(sz2) then begin
            if ((sz1[0] eq sz2[0]) and $
                (sz1[1] eq sz2[1]) and $
                (sz1[2] eq sz2[2]) and $
                (sz1[3] eq sz2[3]) and $
                (sz1[4] eq sz2[4]) and $
                (sz1[5] eq sz2[5])) then begin
                (*self.fitparms)[2,*,*] = newParms[2,*,*]
            endif else begin
                print,'8289 ooEcho::grabPhasesFrom ARRAY SIZES DON"T MATCH!!!'
            endelse
        endif else begin
            print,'8292 ooEcho::grabPhasesFrom ARRAY SIZES DON"T MATCH!!!'
        endelse
    endif else begin
        print,'8295 ooEcho::grabPhasesFrom  INVALID DATA OBJECT'
    endelse

end;grabPhasesFrom
function ooEcho::closestTau,x,_Extra=extra
;
;NAME:
;        ooEcho::closestTau
;
;PURPOSE:
;           Return the closest Fourier Time to x.
;PARAMETERS:
;           x
;KEYWORDS:
;           none
;RETURN VALUE:
;   The closest Fourier time.
    ;self->addTreatment,'ooEcho::closestTau'

    ;RETURN THE CLOSEST FOURIER TIME TO THE
    ;INPUT VALUE

    tauVals = *self.fourierTime
    xvals = x + 0.0*tauvals

    dist = (xvals - tauVals)^2

    temp = min(dist,minIndex)

    return,tauVals[minIndex]
end;closestTau
function ooEcho::closestTauIndex,x,_Extra=extra
;
;NAME:
;        ooEcho::closestTauIndex
;
;PURPOSE:
;           Get the closest Fourier time index to x.
;PARAMETERS:
;           x
;KEYWORDS:
;           none
;RETURN VALUE:
;       The closest Fourier time index.
    ;self->addTreatment,'ooEcho::closestTauIndex'

    ;RETURN THE CLOSEST FOURIER TIME TO THE
    ;INPUT VALUE

    tauVals = *self.fourierTime
    xvals = x + 0.0*tauvals

    dist = (xvals - tauVals)^2

    temp = min(dist,minIndex)

    return,minIndex
end;closestTauIndex
function ooEcho::proximity1D,x,y,xind,yind,tauind,xrange,yrange,_Extra=extra
;
;NAME:
;        ooEcho::proximity1D
;
;PURPOSE:
;       Get the closest index to x,y
;PARAMETERS:
;       x
;       y
;       xind
;       yind
;       tauind
;       xrange
;       yrange
;KEYWORDS:
;
;RETURN VALUE:
;       The closest index to x,y
    ;self->addTreatment,'ooEcho::proximity1D'

    ;CALCULATE THE DISTANCES BETWEEN THE PHASE VALUES AND
    ;THE INPUT x VALUE.  RETURN THE INDEX OF THE CLOSEST
    ;PHASE VALUE.
    ;
    ;THIS WILL BE USED TO DETERMINE WHICH POINT IS CLOSEST
    ;TO A MOUSE CLICK ON A PLOT SO THE 1D MASK VALUE
    ;AT THAT POSITION CAN BE UPDATED.
    ;

;    print,'ooEcho::proximity1D xrange=',xrange
;    print,'ooEcho::proximity1D yrange=',yrange

    phases = self->chirpPhases(tauind)
    intensity = self->chirp(xind,yind,tauind)

    ;CONVERT BOTH DIMENSIONS TO DEVICE COORDINATES
    phases = (phases - xrange[0])/(xrange[1]-xrange[0])
    x = (x - xrange[0])/(xrange[1]-xrange[0])

    intensity = (intensity - yrange[0])/(yrange[1]-yrange[0])
    y = (y - yrange[0])/(yrange[1]-yrange[0])


    distances = dblarr(n_elements(phases))

    distances = sqrt((phases - x)^2); + (intensity - y)^2)

    dum = min(distances,minInd)

    return,minInd
end;proximity1D
function ooEcho::proximity1DAll,x,y,xind,yind,tauind,xrange,yrange,_Extra=extra
;
;NAME:
;        ooEcho::proximity1DAll
;
;PURPOSE:
;       Get the closest index to x,y in the case when all data are used.
;PARAMETERS:
;       x
;       y
;       xind
;       yind
;       tauind
;       xrange
;       yrange
;KEYWORDS:
;           none
;RETURN VALUE:
;   The index to the x,y
    ;self->addTreatment,'ooEcho::proximity1DAll'


    ;CALCULATE THE DISTANCES BETWEEN THE PHASE VALUES AND
    ;THE INPUT x VALUE.  RETURN THE INDEX OF THE CLOSEST
    ;PHASE VALUE.
    ;
    ;THIS WILL BE USED TO DETERMINE WHICH POINT IS CLOSEST
    ;TO A MOUSE CLICK ON A PLOT SO THE 1D MASK VALUE
    ;AT THAT POSITION CAN BE UPDATED.
    ;

    ;121604
    ;THE PROBLEM HERE IS THAT X,Y DIMENSIONS CAN DIFFER BY
    ;ORDERS OF MAGNITUDE, SO THE DISTANCE CALCULATION MAY
    ;NOT REFLECT THE CLOSEST POINT VISUALLY!!!
    ;
    ;TO SOLVE THIS COMPUTE ALL DISTANCES USING DEVICE COORDINATES.

;    print,'ooEcho::proximity1DAll xrange=',xrange
;    print,'ooEcho::proximity1DAll yrange=',yrange

;print,'x=',x
;print,'y=',y
;print,'xind=',xind
;print,'yind=',yind
;print,'tauind=',tauind
;print,'xrange=',xrange
;print,'yrange=',yrange
    phases = double(self->chirpPhasesAll(tauind))
    intensity = double(self->chirpAll(xind,yind,tauind))

    ;CONVERT BOTH DIMENSIONS TO NORMALIZED COORDINATES
    phases = (phases - double(xrange[0]))/double(xrange[1]-xrange[0])
    x = (x - double(xrange[0]))/double(xrange[1]-xrange[0])

    intensity = (intensity - double(yrange[0]))/double(yrange[1]-yrange[0])
    y = (y - double(yrange[0]))/double(yrange[1]-yrange[0])


    distances = dblarr(n_elements(phases))

    distances = sqrt((phases - x)^2); + (intensity - y)^2)


;
;    print,'121604'
;    print,'ooecho::proximity1DAll distances=',distances
    dum = min(distances,minInd)

    return,minInd
end;proximity1DAll
pro ooEcho::setMask1D,phaseInd,tauind, value = value,_Extra=extra
;
;NAME:
;        ooEcho::setMask1D
;
;PURPOSE:
;       Set the 1d Mask
;PARAMETERS:
;       phaseInd    The phase index
;       tauind      The Fourier time index
;KEYWORDS:
;       value       A value to use in place of 1,0
    ;self->addTreatment,'ooEcho::setMask1D'


    ;SET MASK VALUE IF value PROVIDED, OTHERWISE
    ;TOGGLE VALUE

    io = (*self.mask1d)[phaseInd,tauind]
;print,*p
;print,'In ooecho::setMask1D'
;help,value
;    print,phaseind
;print,'help,(*self.mask1d)'
;    help,(*self.mask1d)
;print,'help,(*self.e)'

;    help,(*self.e)
;    print,(*self.mask1d)[phaseInd,tauind]
;    print,'n_elements(phaseind)=',n_elements(phaseind)
    if n_elements(value) eq 0 then begin
        if io eq 1 then begin
            (*self.mask1d)[phaseInd,tauind] = 0
        endif else begin
            (*self.mask1d)[phaseInd,tauind] = 1
        endelse
    endif else begin
        (*self.mask1d)[phaseInd,tauind] = value
    endelse
;    print,(*self.mask1d)[phaseInd,tauind]
;    print,transpose((*self.mask1d)[*,tauind]),format='(31i4)'
    ;041505
    ;PREVENT USER FROM CRASHING LarPloterr BY
    ;REVERTING MASK TO ALL UNMASKED IF ALL BUT ONE POINT IS MASKED

    if total((*self.mask1d)[*,tauind]) le 2 then (*self.mask1d)[*,tauind] = 1

end;setMask1D
function ooEcho::getMask1D,tauind,_Extra=extra
;
;NAME:
;        ooEcho::getMask1D
;
;PURPOSE:
;       Get the 1d mask.
;PARAMETERS:
;       tauind  The Fourier time index
;KEYWORDS:
;       none
;RETURN VALUE:
;       The 1d mask.

    ;GET MASK VALUE IF value PROVIDED, OTHERWISE
    ;TOGGLE VALUE

    return,(*self.mask1d)[*,tauind]

end;getMask1D

function ooEcho::getMask2d,tauind,value=value,_Extra=extra
;
;NAME:
;        ooEcho::getMask2d
;
;PURPOSE:
;       Get the 2dMask.
;PARAMETERS:
;       tauind  The Fourier time.
;KEYWORDS:
;       value   Not sure why this is here except for blind copying.
;RETURN VALUE:
;   io      The 2d mask.

    ;SET MASK VALUE IF value PROVIDED, OTHERWISE
    ;TOGGLE VALUE

    sz = size((*self.mask2d))
    io = (*self.mask2d)[*,*,tauind]

    return,io

end;getMask2d

pro ooEcho::setMask2d,xind,yind,tauind,value=value,_Extra=extra
;
;NAME:
;        ooEcho::setMask2d
;
;PURPOSE:
;       Set the 2d mask directly without using setProperty.
;PARAMETERS:
;       xind    The indices.
;       yind
;       tauind
;KEYWORDS:
;       value   The value
    ;self->addTreatment,'ooEcho::setMask2d'


    ;SET MASK VALUE IF value PROVIDED, OTHERWISE
    ;TOGGLE VALUE

;    io = (*self.mask2d)[xind+yind*self.xdim-1,tauind]
    io = (*self.mask2d)[xind,yind,tauind]
    if n_elements(value) eq 0 then begin
        if io eq 1 then begin
            (*self.mask2d)[xind,yind,tauind] = 0
        endif else begin
            (*self.mask2d)[xind,yind,tauind] = 1
        endelse
    endif else begin
        (*self.mask2d)[xind,yind,tauind] = value
    endelse


end;setMask2d



function ooEcho::getfitdisplaymask,tauind,_Extra=extra
;
;NAME:
;        ooEcho::getfitdisplaymask
;
;PURPOSE:
;       Get the fit display mask for the selected Fourier timee without using setProperty.
;PARAMETERS:
;       tauind  The Fourier time index
;KEYWORDS:
;       none
;RETURN VALUE:
;       io  The 2d mask

    ;SET MASK VALUE IF value PROVIDED, OTHERWISE
    ;TOGGLE VALUE

    ;fixit
    sz = size((*self.fitdisplaymask))
;    io = (*self.fitdisplaymask)[*,*,tauind]
    io = (*self.fitdisplaymask)[*,tauind]
    ;help,io
    ;print,self.x_dim,self.y_dim
    io = reform(io,self.x_dim,self.y_dim)

    return,io

end;getfitdisplaymask

pro ooEcho::setfitdisplaymask,xind,yind,tauind,value=value,_Extra=extra
;
;NAME:
;        ooEcho::setfitdisplaymask
;
;PURPOSE:
;       Set the value of the fit display mask at the selected indices
;PARAMETERS:
;       xind        The indices.
;       yind
;       tauind
;KEYWORDS:
;       value       The value to set.
    ;self->addTreatment,'ooEcho::setfitdisplaymask'


    ;SET MASK VALUE IF value PROVIDED, OTHERWISE
    ;TOGGLE VALUE

;    io = (*self.mask2d)[xind+yind*self.xdim-1,tauind]
    ;help,(*self.fitdisplaymask)
;    io = (*self.fitdisplaymask)[xind,yind,tauind]
    io = (*self.fitdisplaymask)[xind+yind*self.x_dim,tauind]
    if n_elements(value) eq 0 then begin
        if io eq 1 then begin
;            (*self.fitdisplaymask)[xind,yind,tauind] = 0
            (*self.fitdisplaymask)[xind+yind*self.x_dim,tauind] = 0
        endif else begin
;            (*self.fitdisplaymask)[xind,yind,tauind] = 1
            (*self.fitdisplaymask)[xind+yind*self.x_dim,tauind] = 1
        endelse
    endif else begin
;        (*self.fitdisplaymask)[xind,yind,tauind] = value
        (*self.fitdisplaymask)[xind+yind*self.x_dim,tauind] = value
    endelse


end;setfitdisplaymask






pro ooEcho::getInterpPhasesFrom,obj,periodimport=periodimport,_Extra=extra
;
;NAME:
;        ooEcho::getInterpPhasesFrom
;
;PURPOSE:
;           Get interpolated phases from obj.
;PARAMETERS:
;           obj     The source of the phases
;KEYWORDS:
;           periodimport    Flag for period import.
    ;self->addTreatment,'ooEcho::getInterpPhasesFrom'


    ;PRODUCE AN INTERPOLATED SET OF PHASES FROM THIS OBJECT
    ;BASED ON THE FOURIER TIMES IN obj.

    ;NOTE:  THIS NO LONGER INTERPOLATES THE PHASES, BUT INSTEAD
    ;       IT ACQUIRES A PHASE ARRAY AT EACH MATCHING FOURIER
    ;       TIME.
    ;       ADDITIONALLY, THE MASK FROM THE RESOLUTION FILE
    ;       WILL BE ACQUIRED.


;print,'AM I HERE????????????????????'

    if n_elements(periodimport) eq 0 then periodimport = 0


    objfp = *(obj->getProperty(tag='fitparms'))

    objsz = size(objfp)

    objmask = *(obj->getProperty(tag='mask2d'))


    phsarr = objfp[2,*,*] ;fp[phasindex,detectorindex,fouriertimeindex]


    objtaus = *(obj->getProperty(tag='fourierTime'))
    mytaus = *self.fourierTime

    ;060304
    ;CHECK THAT objsz AND mysz SHOW THE SAME NUMBER OF
    ;DETECTOR PIXELS.
    mysz = size(*self.fitparms)


    ;DECLARE 1D ARRAYS TO POPULATE THE IMPORTED ARRAYS PIXEL-BY-PIXEL
    ynew = dblarr(n_elements(mytaus))
    masknew = dblarr(n_elements(mytaus))
    pdnew = dblarr(n_elements(mytaus))
;021705
;
;THIS INTERPOLATION APPEARS TO GIVE THE WRONG VALUES IN SOME CASES.
    if mysz[2] eq objsz[2] then begin
        for i=0,objsz[2]-1 do begin  ;RUN OVER PIXEL INDEX


            ;GET THE PHASE AND PERIOD ARRAYS FROM THE obj
            y = reform(objfp[2,i,*],objsz[3])
            pd = reform(objfp[4,i,*],objsz[3])
            maskval = reform(objmask[i,*],objsz[3])

            x = objTaus

            mytaus = *self.fourierTime
;021705
    ;REPLACE ALL OF THIS WITH A SELECTION WHERE abs(mytaus-objtaus)/mytaus < 0.02
            ;print,where(abs(mytaus-x)/mytaus)
            ;ynew = y[where(abs(mytaus-x)/mytaus) lt 0.02]
            for j=0,n_elements(ynew)-1 do begin
                ;print,where(abs(mytaus[j]-x)/mytaus[j] lt 0.02)

                ;GET MATCHING FOURIER TIME INDICES


                ;111406 CHANGE THE NEXT LINE TO 4%
                ;theindex = where(abs(mytaus[j]-x)/mytaus[j] lt 0.02)
                theindex = where(abs(mytaus[j]-x)/mytaus[j] lt 0.04,whindexcount)
;                print,string(theindex) + string(x[theindex])+ $
;                        string(y[theindex]) + string(mytaus[j])
                
                ;POPULATE THE 1D ARRAYS.
                ;if theindex ne -1 then begin
                if whindexcount ne 0 then begin
                    ynew[j] = y[theindex[0]]
                    masknew[j] = maskval[theindex[0]]
                    if periodimport eq 1 then pdnew[j] = pd[theindex[0]]
                endif else begin
                    ;IF NO MATCHING FOURIER TIME:
                    if i eq 0 then begin
                        ;LRK - 12/01/09
                        ;UPDATING THE NEXT STATEMENT TO BE A PRINT INSTEAD OF A DIALOG TO 
                        ;FACILITATE AUTO-FITTING OF MULTIPLE DATA SETS
                        print,'No matching import Fourier time for t='+string(mytaus[j])+', making substitution.'
;                        msg = dialog_message('No matching import Fourier time for t='+string(mytaus[j]) $
;                                           +', making substitution.')
                    endif;i
                    if j gt 0 then begin
                        ynew[j] = ynew[j-1]
                        if periodimport eq 1 then pdnew[j] = 360.0d
                    endif else begin
                        ynew[j] = 200.0d
                       if periodimport eq 1 then pdnew[j] = 360.0d
                    endelse
                endelse
            endfor;j

;021705
;REPLACE THE NEXT COMMAND WITH THE ONE ABOVE.
;            ;INTERPOLATE PHASE ARRAY TO self'S TAU VALUES
;            ynew = interpol(y,x,mytaus)

            ;PUT INTERPOLATED PHASE VALUES INTO THE

            ;PUT THE 1D ARRAYS INTO THE SELECTED PIXEL ARRAY.
            (*self.fitparms)[2,i,*] = ynew
            (*self.mask2d)[i,*] = masknew

;111105
;FIXED THE NEXT LINE???????
;WHY DID I NEED TO CHANGE THIS???????  IS IT AN ooEchoMagnetic CONVENTION FLIP????
            if periodimport eq 1 then (*self.fitparms)[4,i,*] = pdnew;360.0/pdnew

        endfor;i
    endif else begin;mysz[2] eq objsz[2]
        ;THE PROGRAM SHOULD NEVER GET HERE UNLESS IT THE
        ;USER IS MANIPULATING THE DATA OBJECTS DIRECTLY.
        dummy = dialog_message('DETECTOR SIZE OF PHASE ' $
                               +'IMPORT FILE IS DIFFERENT!')
    endelse
end;getInterpPhasesFrom
;function ooEcho::interpPhases,obj
;    ;PRODUCE AN INTERPOLATED SET OF PHASES FROM THIS OBJECT
;    ;BASED ON THE FOURIER TIMES IN obj.
;
;    objfp = *(obj->getProperty(tag='fitparms'))
;
;    phsarr = objfp[2,*,*] ;fp[phasindex,detectorindex,fouriertimeindex]
;
;    sz = size(objfp)
;
;    newphsarr = dblarr(sz[2],sz[3])
;
;    newtaus = *(obj->getProperty(tag='fourierTime'))
;
;
;    for i=0,sz[2]-1 do begin  ;RUN OVER PIXEL INDEX
;
;        mysz = size(*self.fitparms)
;
;        y = reform((*self.fitparms)[2,i,*],mysz[3])
;
;        x = *self.fourierTime
;
;        ynew = interpol(y,x,newtaus)
;
;        newphsarr[i,*] = ynew[*]
;
;    endfor;i
;
;    return,newphsarr
;end;interpPhases




;;;;;;;;;;;;;;;;;;;;;

;;
;ACCESSOR METHODS
;
;getProperty
;setProperty
;;;

;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::addTreatment,s,_Extra=extra
;
;NAME:
;        ooEcho::addTreatment
;
;PURPOSE:
;       Add s to the treatment pointer.
;PARAMETERS:
;       s   The treatment string to add.
;KEYWORDS:
;       none

    treatment = [*self.treatment,String(s)]
    if ptr_valid(self.treatment) gt 0 then ptr_free,self.treatment
    self.treatment = ptr_new(treatment)

end;addTreatment
pro ooEcho::setWidth,width,_Extra=extra
;
;NAME:
;        ooEcho::setWidth
;
;PURPOSE:
;       Directly set the width instead of using setproperty.  Useful for
;       updating only this fit parameter when needed by the display
;       object.  This avoids the hassle of using setproperty to directly
;       manipulate the multidimensional array.
;PARAMETERS:
;       width   The new width
;KEYWORDS:
;       none
    ;self->addTreatment,'ooEcho::setProperty'

    self.width = width
    (*(self.fitparms))[3,*,*] = width
    (*(self.fitparms))[9,*,*] = 0.0
end;setWidth
pro ooEcho::setPeriod,period,_Extra=extra
;
;NAME:
;        ooEcho::setPeriod
;
;PURPOSE:
;       Directly set the period instead of using setProperty
;PARAMETERS:
;       period  The new period value
;KEYWORDS:
;       none
    ;self->addTreatment,'ooEcho::setwidth'

    self.period = period
    (*(self.fitparms))[4,*,*] = 360.0/period
    (*(self.fitparms))[10,*,*] = 0.0
end;setPeriod
pro ooEcho::setParms,parms,x,y,t,parmindex=parmindex,_Extra=extra
;
;NAME:
;        ooEcho::setParms
;
;PURPOSE:
;       Directly set the parms at a specific pixel.
;PARAMETERS:
;       parms   The new parm values
;       x       The indices of the parms to set
;       y
;       t
;KEYWORDS:
;       parmindex   Optional index to select which parm to set.
    ;self->addTreatment,'ooEcho::setParms'

    if n_elements(parmindex) eq 0 then parmindex = -1
    pixel = x+y*self.x_dim

    if parmindex ne -1 then begin
        if n_elements(parms) eq 1 then begin
            (*(self.fitparms))[parmindex,pixel,t] = parms
            (*(self.fitparms))[parmindex+6,pixel,t] = 0.0
        endif
    endif else begin
        if n_elements(parms) eq 6 then begin

            ;CHECK FOR PERIOD v. OMEGA ISSUE
            if parms[4] gt 10.0 then parms[4] = 360.0/parms[4]

            (*(self.fitparms))[0:5,pixel,t] = parms
            (*(self.fitparms))[6:*,pixel,t] = 0.0*parms
        endif
    endelse

end;setParms



function ooEcho::getProperty,tag=tag,_Extra=extra
;
;NAME:
;        ooEcho::getProperty
;
;PURPOSE:
;           getProperty method
;           Note:   This style was decided on early on in my IDL programming.  The goal
;                   was to allow a for loop to loop over the member variables via the tag
;                   parameter.  It is still used this way because so much of the NSE code
;                   relies on this impementation.  It would be better to go through the code
;                   at some point and implement either myproperties or the standard IDL
;                   keyword style setProperty.
;PARAMETERS:
;           none
;KEYWORDS:
;           tag     The name of the tag to get.  Note that this is case sensitive!
;RETURN VALUE:
;           The value of the selected tag.


;101105
;MAKE THIS CASE INSENSITIVE!!!

    if n_elements(tag) eq 0 then tag = ''
    tag = strlowcase(tag)

    case tag of
        'filename':                 return,self.filename
        'workdir':                  return,self.workdir
        'datadir':                  return,self.datadir
        'type':                     return,self.type
        'reduced':                  return,self.reduced
        ;'reducedOld':               return,self.reducedOld
        'reducedold':               return,self.reducedOld
        'e':                        return,self.e
        'emask':                    return,self.emask
        'eorig':                    return,self.eorig
        'mask2d':                   return,self.mask2d
        ;'mask2dOld':                return,self.mask2dOld
        'mask2dold':                return,self.mask2dOld
        'fitdisplaymask':           return,self.fitdisplaymask
        ;'fitdisplaymaskOld':        return,self.fitdisplaymaskOld
        'fitdisplaymaskold':        return,self.fitdisplaymaskOld
        'mask1d':                   return,self.mask1d
        ;'mask1dPixels':             return,self.mask1dPixels
        ;'mask1dpixels':             return,self.mask1dPixels
        'lambda':                   return,self.lambda
        'dlambda':                  return,self.dlambda
        'comment':                  return,self.comment
        'fixed':                    return,self.fixed
        'fitparms':                 return,self.fitparms
        ;'fitparmsOld':              return,self.fitparmsOld
        'fitparmsold':              return,self.fitparmsOld
        'chisq':                    return,self.chisq
        ;'chisqOld':                 return,self.chisqOld
        'chisqold':                 return,self.chisqOld
        ;'Iup':                      return,self.Iup
        'iup':                      return,self.Iup
        ;'Idown':                    return,self.Idown
        'idown':                    return,self.Idown
        ;'sIup':                     return,self.sIup
        'siup':                     return,self.sIup
        ;'sIdown':                   return,self.sIdown
        'sidown':                   return,self.sIdown
        ;'IupdownSwitch':            return,self.IupdownSwitch
        'iupdownswitch':            return,self.IupdownSwitch
        ;'S':                        return,self.S
        's':                        return,self.S
        ;'sS':                       return,self.sS
        'ss':                       return,self.sS
        ;'IQTInfo':                  return,self.IQTInfo
        'iqtinfo':                  return,self.IQTInfo
        ;'IQT':                      return,self.IQT
        'iqt':                      return,self.IQT
        ;'sIQT':                     return,self.sIQT
        'siqt':                     return,self.sIQT
        ;'IQTFitparms':              return,self.IQTFitparms
        'iqtfitparms':              return,self.IQTFitparms
        'treatment':                return,self.treatment
        ;'QVals':                    return,self.QVals
        'qvals':                    return,self.QVals
        ;'QValsSwitch':              return,self.QValsSwitch
        'qvalsswitch':              return,self.QValsSwitch
        'narcs':                    return,self.narcs
        'qarcs':                    return,self.qarcs
        'phase':                    return,self.phase
        ;'currentPhaseIndex':        return,self.currentPhaseIndex
        'currentphaseindex':        return,self.currentPhaseIndex
        'meters':                   return,self.meters
        'counters':                 return,self.counters
        'monitors':                 return,self.monitors
        'preset':                   return,self.preset
        'no_of_phases':             return,self.no_of_phases
        'point_to_down':            return,self.point_to_down
        'point_to_up':              return,self.point_to_up
        'phase_step':               return,self.phase_step
        'no_of_fourier_times':      return,self.no_of_fourier_times
        'no_of_pixels':             return,self.no_of_pixels
        'beam_cen_x':               return,self.beam_cen_x
        'beam_cen_y':               return,self.beam_cen_x
        'transmission':             return,self.transmission
        'volfrac':                  return,self.volfrac
        'x_dim':                    return,self.x_dim
        'y_dim':                    return,self.y_dim
        'x_dim_orig':               return,self.x_dim_orig
        'y_dim_orig':               return,self.y_dim_orig
        'x_cen':                    return,self.x_cen
        'y_cen':                    return,self.y_cen
        'x_cen_orig':               return,self.x_cen_orig
        'y_cen_orig':               return,self.y_cen_orig
        'width':                    return,self.width
        'period':                   return,self.period
        ;'colorTable':               return,self.colorTable
        'colortable':               return,self.colorTable
        'q':                        return,self.q
        'qactual':                  return,self.qactual
        'qy':                       return,self.qy
        ;'fourierTime':              return,self.fourierTime
        'fouriertime':              return,self.fourierTime
        ;'currentFourierTimeIndex':  return,self.currentFourierTimeIndex
        'currentfouriertimeindex':  return,self.currentFourierTimeIndex
        ;'scanHeader':               return,self.scanHeader
        'scanheader':               return,self.scanHeader
        ;'sampleHeader':             return,self.sampleHeader
        'sampleheader':             return,self.sampleHeader
        ;'techHeader':               return,self.techHeader
        'techheader':               return,self.techHeader
        ;'physicsHeader':            return,self.physicsHeader
        'physicsheader':            return,self.physicsHeader
        ;'physicsParametersHeader':  return,self.physicsParametersHeader
        'physicsparametersheader':  return,self.physicsParametersHeader
        ;'phaseHeader':              return,self.phaseHeader
        'phaseheader':              return,self.phaseHeader
        'tags':                     return,self.tags
        else:begin
            void = dialog_message('Tag not found!  Returning ooEcho Object!');,/warning)
            return,self
        endelse

    endcase

end;ooEcho::getProperty
;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::setProperty,tag,value,_Extra=extra
;
;NAME:
;        ooEcho::setProperty
;
;PURPOSE:
;           setProperty method.
;           Note:   This style was decided on early on in my IDL programming.  The goal
;                   was to allow a for loop to loop over the member variables via the tag
;                   parameter.  It is still used this way because so much of the NSE code
;                   relies on this impementation.  It would be better to go through the code
;                   at some point and implement either myproperties or the standard IDL
;                   keyword style setProperty.
;
;PARAMETERS:
;           tag     The name of the tag/element to set.  CASE SENSITIVE!!!
;           value   The value to set it to.
;KEYWORDS:
;           none


;101105
;MAKE THE CALL TO setProperty CASE INSENSITIVE!!!

    tag = strlowcase(tag)

    case tag of
        'filename':                 self.filename = value
        'workdir':                  self.workdir = value
        'datadir':                  self.datadir = value
        'type':                     self.type = value
        'reduced':                  self.reduced = value
        ;'reducedOld':               self.reducedOld = value
        'reducedold':               self.reducedOld = value
        'e':                        self.e = value
        'emask':                    self.emask = value
        'eorig':                    self.eorig = value
        'mask2d':                   self.mask2d = value
        ;'mask2dOld':                self.mask2dOld = value
        'mask2dold':                self.mask2dOld = value
        'fitdisplaymask':           self.fitdisplaymask = value
        ;'fitdisplaymaskOld':        self.fitdisplaymaskOld = value
        'fitdisplaymaskold':        self.fitdisplaymaskOld = value
        'mask1d':                   self.mask1d = value
;;082205
;        'mask1dPixels':             self.mask1dPixels = value
        'lambda':                   self.lambda = value
        'dlambda':                  self.dlambda = value
        'comment':                  self.comment = value
        'fixed':                    self.fixed = value
        'fitparms':                 self.fitparms = value
        ;'fitparmsOld':              self.fitparmsOld = value
        'fitparmsold':              self.fitparmsOld = value
        'chisq':                    self.chisq = value
        ;'chisqOld':                 self.chisqOld = value
        'chisqold':                 self.chisqOld = value
        ;'Iup':                      self.Iup = value
        'iup':                      self.Iup = value
        ;'Idown':                    self.Idown = value
        'idown':                    self.Idown = value
        ;'sIup':                     self.sIup = value
        'siup':                     self.sIup = value
        ;'sIdown':                   self.sIdown = value
        'sidown':                   self.sIdown = value
        ;'IupdownSwitch':            self.IupdownSwitch = value
        'iupdownswitch':            self.IupdownSwitch = value
        ;'S':                        self.S = value
        's':                        self.S = value
        ;'sS':                       self.sS = value
        'ss':                        self.sS = value
        ;'IQTInfo':                  self.IQTInfo = value
        'iqtinfo':                  self.IQTInfo = value
        ;'IQT':                      self.IQT = value
        'iqt':                      self.IQT = value
        ;'sIQT':                     self.sIQT = value
        'siqt':                     self.sIQT = value
        ;'IQTFitparms':              self.IQTFitparms = value
        'iqtfitparms':              self.IQTFitparms = value
        'treatment':                self.treatment = value
        'qarcs':                    self.qarcs = value
        ;'QVals':                    self.QVals = value
        'qvals':                    self.QVals = value
        ;'QValsSwitch':              self.QValsSwitch = value
        'qvalsswitch':              self.QValsSwitch = value
        'narcs':                    self.narcs = value
        'phase':                    self.phase = value
        ;'currentPhaseIndex':        self.currentPhaseIndex = value
        'currentphaseindex':        self.currentPhaseIndex = value
        'meters':                   self.meters = value
        'counters':                 self.counters = value
        'monitors':                 self.monitors = value
        'preset':                   self.preset = value
        'no_of_phases':             self.no_of_phases = value
        'point_to_down':            self.point_to_down = value
        'point_to_up':              self.point_to_up = value
        'phase_step':               self.phase_step = value
        'no_of_fourier_times':      self.no_of_fourier_times = value
        'no_of_pixels':             self.no_of_pixels = value
        'beam_cen_x':               self.beam_cen_x = value
        'beam_cen_y':               self.beam_cen_x = value
        'transmission':             self.transmission = value
        'volfrac':                  self.volfrac = value
        'x_dim':                    self.x_dim = value
        'y_dim':                    self.y_dim = value
        'x_dim_orig':               self.x_dim_orig = value
        'y_dim_orig':               self.y_dim_orig = value
        'x_cen':                    self.x_cen = value
        'y_cen':                    self.y_cen = value
        'x_cen_orig':               self.x_cen_orig = value
        'y_cen_orig':               self.y_cen_orig = value
        'width':                    self.width = value
        'period':                   self.period = value
        ;'colorTable':               self.colorTable = value
        'colortable':               self.colorTable = value
        'q':                        self.q = value
        'qactual':                  self.qactual = value
        'qy':                       self.qy = value
        ;'fourierTime':              self.fourierTime = value
        'fouriertime':              self.fourierTime = value
        ;'currentFourierTimeIndex':  self.currentFourierTimeIndex = value
        'currentfouriertimeindex':  self.currentFourierTimeIndex = value
        ;'scanHeader':               self.scanHeader = value
        'scanheader':               self.scanHeader = value
        ;'sampleHeader':             self.sampleHeader = value
        'sampleheader':             self.sampleHeader = value
        ;'techHeader':               self.techHeader = value
        'techheader':               self.techHeader = value
        ;'physicsHeader':            self.physicsHeader = value
        'physicsheader':            self.physicsHeader = value
        ;'physicsParametersHeader':  self.physicsParametersHeader = value
        'physicsparametersheader':  self.physicsParametersHeader = value
        ;'phaseHeader':              self.phaseHeader = value
        'phaseheader':              self.phaseHeader = value
        'tags':                     self.tags = value
        else: begin
            print,'12930 NO VALID TAG SELECTED FOR ooEcho::setProperty.'
            print,'tag=',tag,'value=',value
        end;else
    endcase

end;ooEcho::setProperty
;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::cleanup,_Extra=extra
;
;NAME:
;        ooEcho::cleanup
;
;PURPOSE:
;           Clean up memory on object destruction.
;PARAMETERS:
;           none
;KEYWORDS:
;           none

    print,'ooEcho::Cleanup'
    ptr_free,self.e
    ptr_free,self.emask
    ptr_free,self.eorig
    ptr_free,self.mask2d
    ptr_free,self.mask2dOld
    ptr_free,self.fitdisplaymask
    ptr_free,self.fitdisplaymaskOld
    ptr_free,self.mask1d
;;082205
;    ptr_free,self.mask1dpixels
    ptr_free,self.fixed
    ptr_free,self.fitparms
    ptr_free,self.fitparmsOld
    ptr_free,self.chisq
    ptr_free,self.chisqOld
    ptr_free,self.Iup
    ptr_free,self.Idown
    ptr_free,self.sIup
    ptr_free,self.sIdown
    ptr_free,self.S
    ptr_free,self.sS
    ptr_free,self.IQTInfo
    ptr_free,self.IQT
    ptr_free,self.sIQT
    ptr_free,self.IQTFitparms
    ptr_free,self.treatment
    ptr_free,self.qarcs
    ptr_free,self.QVals
    ptr_free,self.phase
    ptr_free,self.meters
    ptr_free,self.counters
    ptr_free,self.monitors
    ptr_free,self.fourierTime
    ptr_free,self.scanHeader
    ptr_free,self.sampleHeader
    ptr_free,self.techHeader
    ptr_free,self.physicsHeader
    ptr_free,self.physicsParametersHeader
    ptr_free,self.phaseHeader
end;cleanup
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;   MERGESET
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
function ooEcho::orderEm,tau1,tau2,order,i,j,oi,_Extra=extra
;
;NAME:
;        ooEcho::orderEm
;
;PURPOSE:
;           Create an ordering by Fourier time to be available for merging objects.  Recursive.
;PARAMETERS:
;           tau1
;           tau2
;           order
;           i
;           j
;           oi
;KEYWORDS:
;           none
;RETURN VALUE:
;           order The ordering array.

    ;CREATE AN ORDERING ARRAY CALLED order TO
    ;SORT ELEMENTS OF TWO ARRAYS IN TO A SINGLE
    ;ORDERED ARRAY.  THIS WILL BE USED BY THE
    ;MERGE FUNCTION TO PROPERLY SHUFFLE IN SLICES
    ;OF THE 3D DATA ARRAY BY TAU VALUE.
    ;(NOTE: THE 3D ARRAY CONSISTS OF [#detPixels,nPhases,nTau])

    treatment = [*self.treatment,'ooEcho::orderEm']
    if ptr_valid(self.treatment) gt 0 then ptr_free,self.treatment
    self.treatment = ptr_new(treatment)

    if oi ge n_elements(order) then begin
        return,order    ;THIS ENDS RECURSION
    endif else begin
        inew = min([i,n_elements(tau1)-1])
        jnew = min([j,n_elements(tau2)-1])
        if (tau1[inew] le tau2[jnew]) then begin
            order[oi] = 1
            if i ge n_elements(tau1) then order[oi] = 2
            i = i + 1
        endif else begin
            order[oi] = 2
            if j ge n_elements(tau2) then order[oi] = 1
            j = j + 1
        endelse
        return,self->orderEm(tau1,tau2,order,i,j,oi+1)
    endelse

end;orderEm

;function ooEcho::blankObj;,obj
pro ooEcho::blankObj,nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin,_Extra=extra;,obj
;
;NAME:
;        ooEcho::blankObj
;
;PURPOSE:
;           Populate self as a blank ooEcho object.
;PARAMETERS:
;           none
;KEYWORDS:
;           nft
;           nphs
;           xdim
;           ydim
;           bin


    ;101304
    ;CREATE A BLANK OBJECT WITH ARRAYS OF PROPER SIZES
    ;BUT NO VALUES.

    ;THIS OBJECT WILL BE USED TO INITIALIZE THE
    ;ooDisplayEcho GUI.

    ;TAKE CARE ON DETAILS LIKE point_to_up AND point_to_down
    ;etc.


    ;011105
    ;
    ;SET UP A BLANK OBJECT WITH A SPECIFIC NUMBER OF FOURIER TIMES
    ;TO FACILITATE DELETION OF A SINGLE FOURIER TIME.

    if n_elements(nft) eq 0 then nft = 14
    if n_elements(nphs) eq 0 then nphs = 27
    if n_elements(xdim) eq 0 then xdim = 32
    if n_elements(ydim) eq 0 then ydim = 32
    if n_elements(bin) eq 0 then bin = 4

    linbinned = (xdim*ydim)/(bin*bin)
    linnobin =  (xdim*ydim)

    treatment = [*self.treatment,'ooEcho::blankObj']
    if ptr_valid(self.treatment) gt 0 then ptr_free,self.treatment
    self.treatment = ptr_new(treatment)



   tags= [ 'filename',$
            'workdir',$
            'datadir',$
            'type',$
            'reduced',$
            'reducedOld',$
            'e',$
            'emask',$
            'eorig',$
            'mask2d',$
            'mask2dOld',$
            'fitdisplaymask',$
            'fitdisplaymaskOld',$
            'mask1d',$
;;082205
;            'mask1dPixels',$
            'lambda',$
            'dlambda',$
            'comment',$
            'fixed',$
            'fitparms',$
            'fitparmsOld',$
            'chisq',$
            'chisqOld',$
            'Iup',$
            'Idown',$
            'sIup',$
            'sIdown',$
            'IupdownSwitch',$
            'S',$
            'sS',$
            'IQTInfo',$
            'IQT',$
            'sIQT',$
            'QVals',$
            'QValsSwitch',$
            'narcs',$
            'qarcs',$
            'phase',$
            'currentPhaseIndex',$
            'meters',$
            'counters',$
            'monitors',$
            'preset',$
            'no_of_phases',$
            'point_to_down',$
            'point_to_up',$
            'phase_step',$
            'no_of_fourier_times',$
            'no_of_pixels',$
            'beam_cen_x',$
            'beam_cen_y',$
            'transmission',$
            'volfrac',$
            'x_dim',$
            'y_dim',$
            'x_cen',$
            'y_cen',$
            'x_dim_orig',$
            'y_dim_orig',$
            'x_cen_orig',$
            'y_cen_orig',$
            'width',$
            'period',$
            'colorTable',$
            'q',$
            'qactual',$
            'qy',$
            'fourierTime',$
            'currentFourierTimeIndex',$
            'scanHeader',$
            'sampleHeader',$
            'techHeader',$
            'physicsHeader',$
            'physicsParametersHeader',$
            'phaseHeader',$
            'treatment',$
            'IQTFitparms',$
            'tags']

self.tags = tags
self.filename = 'null'
self.workdir = ''
self.datadir = ''
self.type = 0
self.reduced = 0
self.reducedOld = 0
self.e = ptr_new(lonarr(linbinned, nphs, nft))
self.emask = ptr_new(lonarr(linbinned, nphs, nft))
self.eorig = ptr_new(lonarr(linnobin, nphs, nft))
self.mask2d = ptr_new(intarr(linbinned,nft))
self.fitdisplaymask = ptr_new(intarr(linbinned,nft))
self.mask2dOld = ptr_new(intarr(linbinned,nft))
self.fitdisplaymaskOld = ptr_new(intarr(linbinned,nft))
self.mask1d = ptr_new(intarr(nphs,nft))

;;082205
;self.mask1dPixels = ptr_new(intarr(64,nphs,nft))

self.lambda = double(1.0e-10)
self.dlambda = double(1.0e-10)
self.comment = 'none'
self.fixed = ptr_new(intarr(6,linbinned,nft))
self.fitparms = ptr_new(dblarr(12,linbinned,nft))
self.fitparmsOld = ptr_new(dblarr(12,linbinned,nft))
self.chisq = ptr_new(dblarr(linbinned,nft))
self.chisqOld = ptr_new(dblarr(linbinned,nft))
self.Iup = ptr_new(dblarr(linbinned,nft))
self.Idown = ptr_new(dblarr(linbinned,nft))
self.sIup = ptr_new(dblarr(linbinned,nft))
self.sIdown = ptr_new(dblarr(linbinned,nft))
self.IupdownSwitch = 0
self.S = ptr_new(dblarr(linbinned,nft))
self.sS = ptr_new(dblarr(linbinned,nft))
self.IQTInfo = ptr_new('')
self.IQT = ptr_new(dblarr(5,nft))
self.sIQT = ptr_new(dblarr(5,nft))
self.IQTFitparms = ptr_new(dblarr(5,2))


self.QVals = ptr_new(dblarr(linbinned,nft))
self.QValsSwitch = 0
self.narcs = 7
self.qarcs = ptr_new(dblarr(5))
self.phase = ptr_new(fltarr(nphs,nft))
self.currentPhaseIndex = 0

        iec_multimeter = {$
            Temperatur:0.0,$
            BSpiy:0.0,$
            BSpi21x:0.0,$
            BSpi21z:0.0,$
            BSpi22y:0.0,$
            BSpix:0.0,$
            BSpiz:0.0,$
            BSpi21y:0.0,$
            BSpi22x:0.0,$
            BSpi22z:0.0 $
            }
        meters=replicate(iec_multimeter,nphs,nft)


self.meters = ptr_new(meters)
;<PtrHeapVar219663>
;                STRUCT    = -> <Anonymous> Array[nphs, nft]
self.counters = ptr_new(dblarr(10,nphs,nft))
self.monitors = ptr_new()
;<PtrHeapVar219665>
;                STRUCT    = -> <Anonymous> Array[nft]
self.preset = 10000
self.no_of_phases = nphs
self.point_to_down = 19
self.point_to_up = 24
self.phase_step = 45
self.no_of_fourier_times = nft
self.no_of_pixels = linnobin
self.beam_cen_x = 16.00
self.beam_cen_y = 16.00
self.transmission = 1.0
self.volfrac = 0.0
self.x_dim = 8
self.y_dim = 8
self.x_cen = 4.0
self.y_cen = 3.75
self.x_dim_orig = 32
self.y_dim_orig = 32
self.x_cen_orig = 16.0
self.y_cen_orig = 15.0
self.width = 702.0
self.period = 373.0
self.colorTable = 3
self.q = 0.0
self.qactual = 0.0
self.qy = 0.0
self.fourierTime = ptr_new(fltarr(nft))
self.currentFourierTimeIndex = 0
self.scanHeader = ptr_new(strarr(nphs))
self.sampleHeader = ptr_new(strarr(17))
self.techHeader = ptr_new(strarr(54,nft))
self.physicsHeader = ptr_new(strarr(16,nft))
self.physicsParametersHeader = ptr_new(strarr(44,nft))
self.phaseHeader = ptr_new(strarr(4,nphs,nft))
self.tags = tags

end;blankObj
function ooEcho::mergeSet,obj,_Extra=extra
;
;NAME:
;        ooEcho::mergeSet
;
;PURPOSE:
;               Produce a merging of self and obj.
;PARAMETERS:
;               obj     The object to merge with self.
;RETURN VALUE:
;               onew    The new merged object.


    ;SET VALUES IN OBJECT'S CLONE

    ;CREATE A NEW DATA OBJECT AND SET UP ITS DATA
    ;MEMBERS AS THE MERGE OF THE TWO DATA OBJECTS.

    ;print,'TEST'
    ;CREATE A NEW ooecho OBJECT (REPLACE VALUES IN THIS METHOD)
    ;PROBLEM HERE IS THAT I NEED setProperty TO ACCESS THE DATA
    ;MEMBERS --- AND THIS IS THE DATA CLASS SO THE ACCESSOR
    ;METHODS ARE ALREADY AVAILABLE.
    ;onew = self->blankObj(obj)
    onew = self->clone()    ;PRESET, self.qactual, etc ARE NOW SET

    myType = self.type
    myQ = self.q
    myX_dim = self.x_dim
    myY_dim = self.y_dim
    myPreset = self.preset

    objType = obj->getProperty(tag='type')
    objQ = obj->getProperty(tag='q')
    objX_dim = obj->getProperty(tag='x_dim')
    objY_dim = obj->getProperty(tag='y_dim')
    objPreset = obj->getProperty(tag='preset')

;    print,'myPreset,objPreset=',myPreset,objPreset

    yn = 'YES'
    if objPreset ne myPreset then $
        yn = dialog_message('The objects have different monitor/preset values! Procede with merge?',/question)
    yn = strupcase(yn)

    if yn eq 'YES' then begin
        presetscaling = double(mypreset)/double(objpreset)
        if presetscaling ne 1.0d then $
            void = dialog_message('Scaling all counts for preset = '+strtrim(string(mypreset),2))
        ;presetscaling = mypreset/objpreset
    endif





    if (mytype eq objtype) and $
        (myQ eq objQ) and $
        (myX_dim eq objX_dim) and $
        (myY_dim eq objY_dim) and $
        (yn eq 'YES') then begin


            fn1 = self.filename
            fn2 = obj->getProperty(tag='filename')
            workdir = self.workdir
            datadir = self.datadir

            version = float(!version.release)
            if version ge 6.0 then begin
                fn = file_basename(fn1)+'+'+file_basename(fn2)
            endif else begin
                fn = fn1+'+'+fn2
            endelse
            ;print,'fn=',fn
            onew->setProperty,'filename',fn
            onew->setproperty,'workdir',workdir
            onew->setproperty,'datadir',datadir

    ;040805
    ;I THINK THIS WAS OMITTED PREVIOUSLY!!!
            onew->setProperty,'preset',mypreset

            type1 = self.type
            type2 = obj->getProperty(tag='type')
            if type1 eq type2 then begin
                type = type1
            endif else begin
                print,'9298 ooecho::mergeset WARNING: TYPES DO NOT MATCH! CONTINUING ANYWAY.'
            endelse
            onew->setProperty,'type',self.type
            ;self.reduced = obj->getProperty(tag='reduced')

            ;GET THE FOURIER TIMES FOR BOTH OBJECTS
            tau1 = *self.fourierTime
            tau2 = *(obj->getProperty(tag='fourierTime'))
            taunewtemp = [tau1,tau2]

            phase1 = *self.phase
            phase2 = *(obj->getProperty(tag='phase'))
            szphs1 = size(phase1)
            szphs2 = size(phase2)
            phasenewtemp = fltarr(max([szphs1[1],szphs2[1]]), $
                                       szphs1[2]+szphs2[2])

            ;help,phasenewtemp

            ;CREATE ORDERING ARRAY FOR ALL OF THE MERGING OPERATIONS.
            order = intarr(n_elements(tau1) + n_elements(tau2))
            order = self->orderEm(tau1,tau2,order,0,0,0)



            etemp1 = *self.eorig

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                etemp2 = long(presetscaling*(*(obj->getProperty(tag='eorig'))))
            endif else begin
                etemp2 = *(obj->getProperty(tag='eorig'))
            endelse
            sz1 = size(etemp1)
            sz2 = size(etemp2)
            ;INITIALIZE A NEW COMBINED DATA ARRAY
            etempnew = lonarr( sz1[1], $
                                max([sz1[2],sz2[2]]), $
                                sz1[3]+sz2[3])

            ;MERGE THE TWO DATA ARRAYS
            if (sz1[1] eq sz2[1]) then begin

                ;INTERLEAVE THE TWO DATA ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        taunewtemp[i] = tau1[i1]
                        phasenewtemp[*,i] = phase1[*,i1]
                        etempnew[*,0:sz1[2]-1,i] = etemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        taunewtemp[i] = tau2[i2]
                        phasenewtemp[*,i] = phase2[*,i2]
                        etempnew[*,0:sz2[2]-1,i] = etemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i

                ;help,etempnew
                ;help,taunewtemp
                ;help,phasenewtemp

                ;PUT THE NEW DATA SET INTO THE NEW DATA OBJECT
                if ptr_valid(onew->getProperty(tag='eorig')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='eorig'))
                onew->setProperty,'eorig',ptr_new(etempnew)

                if ptr_valid(onew->getProperty(tag='fourierTime')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='fourierTime'))
                onew->setProperty,'fourierTime',ptr_new(taunewtemp)

                if ptr_valid(onew->getProperty(tag='phase')) gt 0 then begin
                    ;print,'FREEING THE onew POINTER.'
                    ptr_free,(onew->getProperty(tag='phase'))
                endif

                onew->setProperty,'phase',ptr_new(phasenewtemp)

                ;help,onew->getProperty(tag='phase')
                ;help,*(onew->getProperty(tag='phase'))

                onew->setProperty,'no_of_fourier_times',szphs1[2]+szphs2[2]

                iec_multimeter = {$
                    Temperatur:0.0,$
                    BSpiy:0.0,$
                    BSpi21x:0.0,$
                    BSpi21z:0.0,$
                    BSpi22y:0.0,$
                    BSpix:0.0,$
                    BSpiz:0.0,$
                    BSpi21y:0.0,$
                    BSpi22x:0.0,$
                    BSpi22z:0.0 $
                    }

            meterstemp1 = *self.meters
            meterstemp2 = *(obj->getProperty(tag='meters'))
            szmt1 = size(*self.meters)
            szmt2 = size(*(obj->getProperty(tag='meters')))


        ;    meterstempnew = [meterstemp1,meterstemp2]
            meterstempnew=replicate(iec_multimeter,szmt1[1],szmt1[2]+szmt2[2])
                ;INTERLEAVE THE TWO meters ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        meterstempnew[*,i] = meterstemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        meterstempnew[*,i] = meterstemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,meterstempnew
                if ptr_valid(onew->getProperty(tag='meters')) gt 0 then $
                    ptr_free,onew->getProperty(tag='meters')
                onew->setProperty,'meters',$
                    ptr_new(meterstempnew)


                counterstemp1 = *self.counters
                counterstemp2 = *(obj->getProperty(tag='counters'))
                szct1 = size(*self.counters)
                szct2 = size(*(obj->getProperty(tag='counters')))
        ;        counterstempnew = [counterstemp1,counterstemp2]
                counterstempnew=dblarr(10,szct1[2],szct1[3]+szct2[3])
                ;INTERLEAVE THE TWO counters ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        counterstempnew[*,*,i] = counterstemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        counterstempnew[*,*,i] = counterstemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,counterstempnew
                if ptr_valid(onew->getProperty(tag='counters')) gt 0 then $
                    ptr_free,onew->getProperty(tag='counters')
                onew->setProperty,'counters',$
                    ptr_new(counterstempnew)



                monitor_struct = {m1:0.0,m2:0.0,m3:0.0}

                monitorstemp1 = *self.monitors
                ;help,monitorstemp1
                monitorstemp2 = *(obj->getProperty(tag='monitors'))
                ;help,monitorstemp2
                szmon1 = size(*self.monitors)
                szmon2 = size(*(obj->getProperty(tag='monitors')))
        ;        counterstempnew = [counterstemp1,counterstemp2]
                monitorstempnew=replicate(monitor_struct,szmon1[1]+szmon2[1])
        ;        monitorstempnew=replicate(monitor_struct,szmon1[1],$
        ;                                    szmon1[2]+szmon2[2])

                ;help,monitorstempnew
                print,'n_elements(order)=',n_elements(order)
                ;INTERLEAVE THE TWO counters ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        monitorstempnew[i] = monitorstemp1[i1]
                        ;monitorstempnew[*,*,i] = monitorstemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        monitorstempnew[i] = monitorstemp2[i2]
                        ;monitorstempnew[*,*,i] = monitorstemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,counterstempnew
                if ptr_valid(onew->getProperty(tag='monitors')) gt 0 then $
                    ptr_free,onew->getProperty(tag='monitors')
                onew->setProperty,'monitors',$
                    ptr_new(monitorstempnew)

;        ;THERE IS A PROBLEM HERE SINCE THE "PRESET" VALUE IS LIKELY TO
;        ;DIFFER BETWEEN THE TWO MERGED FILES.  I SINGLE PRESET SHOULD BE
;        ;CHOSEN AND THE OTHER FILE SCALED FOR THAT.
;        print,'9897 ooEcho::MergeSet WARNING!   WARNING!    WARNING!    WARNING!'
;        print,'9898 ooEcho::MergeSet THERE IS AN ISSUE WITH SETTING preset FOR'
;        print,'9899 ooEcho::MergeSet TWO DIFFERENT SETS.'
;        print,'9900 ooEcho::MergeSet NEED TO SCALE ONE SET TO THE OTHER.'


                ;DO REST OF MERGING HERE SO THAT IT ONLY OCCURS IF
                ;THE ORIGINAL DATA ARRAY DETECTORS ARE THE SAME SIZE

            etemp1 = *self.e

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                etemp2 = long(presetscaling*(*(obj->getProperty(tag='e'))))
            endif else begin
                etemp2 = *(obj->getProperty(tag='e'))
            endelse
            ;etemp2 = *(obj->getProperty(tag='e'))

            szx1 = size(etemp1)
            szx2 = size(etemp2)
            ;INITIALIZE A NEW COMBINED DATA ARRAY
            etempnew = lonarr( szx1[1], $
                                max([szx1[2],szx2[2]]), $
                                szx1[3]+szx2[3])


                ;INTERLEAVE THE TWO DATA ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        etempnew[*,0:szx1[2]-1,i] = etemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        etempnew[*,0:szx2[2]-1,i] = etemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i

                ;help,etempnew
                ;PUT THE NEW DATA SET INTO THE NEW DATA OBJECT
                if ptr_valid(onew->getProperty(tag='e')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='e'))
                onew->setProperty,'e',ptr_new(etempnew)


            etemp1 = *self.emask

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                etemp2 = long(presetscaling*(*(obj->getProperty(tag='emask'))))
            endif else begin
                etemp2 = *(obj->getProperty(tag='emask'))
            endelse
;            etemp2 = *(obj->getProperty(tag='emask'))
            szm1 = size(etemp1)
            szm2 = size(etemp2)
            ;INITIALIZE A NEW COMBINED DATA ARRAY
            etempnew = lonarr( szm1[1], $
                                max([szm1[2],szm2[2]]), $
                                szm1[3]+szm2[3])


                ;INTERLEAVE THE TWO DATA ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        etempnew[*,0:szm1[2]-1,i] = etemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        etempnew[*,0:szm2[2]-1,i] = etemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i

                ;help,etempnew
                ;PUT THE NEW DATA SET INTO THE NEW DATA OBJECT
                if ptr_valid(onew->getProperty(tag='emask')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='emask'))
                onew->setProperty,'emask',ptr_new(etempnew)



                mask2dtemp1 = *self.mask2d
                mask2dtemp2 = *(obj->getProperty(tag='mask2d'))
                szfp1 = size(*self.mask2d)
                szfp2 = size(*(obj->getProperty(tag='mask2d')))
                mask2dtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,mask2dtempnew
                ;INTERLEAVE THE TWO mask2d ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        mask2dtempnew[*,i] = mask2dtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        mask2dtempnew[*,i] = mask2dtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,mask2dtempnew
                if ptr_valid(onew->getProperty(tag='mask2d')) gt 0 then $
                    ptr_free,onew->getProperty(tag='mask2d')
                onew->setProperty,'mask2d',$
                    ptr_new(mask2dtempnew)


                mask2dOldtemp1 = *self.mask2dOld
                mask2dOldtemp2 = *(obj->getProperty(tag='mask2dOld'))
                szfp1 = size(*self.mask2dOld)
                szfp2 = size(*(obj->getProperty(tag='mask2dOld')))
                mask2dOldtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,mask2dOldtempnew
                ;INTERLEAVE THE TWO mask2dOld ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        mask2dOldtempnew[*,i] = mask2dOldtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        mask2dOldtempnew[*,i] = mask2dOldtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,mask2dOldtempnew
                if ptr_valid(onew->getProperty(tag='mask2dOld')) gt 0 then $
                    ptr_free,onew->getProperty(tag='mask2dOld')
                onew->setProperty,'mask2dOld',$
                    ptr_new(mask2dOldtempnew)






                ;INTERLEAVE THE TWO fitdisplaymask ARRAYS
                fitdisplaymasktemp1 = *self.fitdisplaymask
                fitdisplaymasktemp2 = *(obj->getProperty(tag='fitdisplaymask'))
                szfp1 = size(*self.fitdisplaymask)
                szfp2 = size(*(obj->getProperty(tag='fitdisplaymask')))
                fitdisplaymasktempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,fitdisplaymasktempnew
                ;INTERLEAVE THE TWO fitdisplaymask ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        fitdisplaymasktempnew[*,i] = fitdisplaymasktemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        fitdisplaymasktempnew[*,i] = fitdisplaymasktemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,fitdisplaymasktempnew
                if ptr_valid(onew->getProperty(tag='fitdisplaymask')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitdisplaymask')
                onew->setProperty,'fitdisplaymask',$
                    ptr_new(fitdisplaymasktempnew)


                ;INTERLEAVE THE TWO fitdisplaymaskOld ARRAYS
                fitdisplaymaskOldtemp1 = *self.fitdisplaymaskOld
                fitdisplaymaskOldtemp2 = *(obj->getProperty(tag='fitdisplaymaskOld'))
                szfp1 = size(*self.fitdisplaymaskOld)
                szfp2 = size(*(obj->getProperty(tag='fitdisplaymaskOld')))
                fitdisplaymaskOldtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,fitdisplaymaskOldtempnew
                ;INTERLEAVE THE TWO fitdisplaymaskOld ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        fitdisplaymaskOldtempnew[*,i] = fitdisplaymaskOldtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        fitdisplaymaskOldtempnew[*,i] = fitdisplaymaskOldtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,fitdisplaymaskOldtempnew
                if ptr_valid(onew->getProperty(tag='fitdisplaymaskOld')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitdisplaymaskOld')
                onew->setProperty,'fitdisplaymaskOld',$
                    ptr_new(fitdisplaymaskOldtempnew)



        ;;
        ;mask1d NEEDS TO HAVE THE SAME NUMBER OF ELEMENTS FOR BOTH SETS.
        ;AND IT MUST BE INTERLEAVED
        ;;;
        ;;    mask1dtemp = *(obj->getProperty(tag='mask1d'))
        ;;    if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
        ;;    self.mask1d = ptr_new(mask1dtemp)
        ;;

                mask1dtemp1 = *self.mask1d
                mask1dtemp2 = *(obj->getProperty(tag='mask1d'))
                szfp1 = size(*self.mask1d)
                szfp2 = size(*(obj->getProperty(tag='mask1d')))
                mask1dtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,mask1dtempnew
                ;INTERLEAVE THE TWO mask1d ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        mask1dtempnew[*,i] = mask1dtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        mask1dtempnew[*,i] = mask1dtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,mask1dtempnew
                if ptr_valid(onew->getProperty(tag='mask1d')) gt 0 then $
                    ptr_free,onew->getProperty(tag='mask1d')
                onew->setProperty,'mask1d',$
                    ptr_new(mask1dtempnew)

;;082205
;                mask1dpixelstemp1 = *self.mask1dpixels
;                mask1dpixelstemp2 = *(obj->getProperty(tag='mask1dPixels'))
;                szfp1 = size(*self.mask1dPixels)
;                szfp2 = size(*(obj->getProperty(tag='mask1dPixels')))
;                mask1dpixelstempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
;                ;help,mask1dpixelstempnew
;                ;INTERLEAVE THE TWO mask1dpixels ARRAYS
;                i1 = 0 & i2 = 0
;                for i=0,n_elements(order)-1 do begin
;
;                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;                    ;DATA ARRAYS
;                    if order[i] eq 1 then begin
;                        mask1dpixelstempnew[*,i] = mask1dpixelstemp1[*,i1]
;                        i1 = i1 + 1
;                    endif else begin
;                        mask1dpixelstempnew[*,i] = mask1dpixelstemp2[*,i2]
;                        i2 = i2 + 1
;                    endelse
;                endfor;i
;                ;help,mask1dpixelstempnew
;                if ptr_valid(onew->getProperty(tag='mask1dPixels')) gt 0 then $
;                    ptr_free,onew->getProperty(tag='mask1dPixels')
;                onew->setProperty,'mask1dPixels',$
;                    ptr_new(mask1dpixelstempnew)
;;########################




            onew->setProperty,'lambda', $
                        obj->getProperty(tag='lambda')
            onew->setProperty,'dlambda', $
                        obj->getProperty(tag='dlambda')
            onew->setProperty,'comment', $
                        'MERGED FILES'

            treatmentnew = ['MERGED FILES']
            if ptr_valid(onew->getProperty(tag='treatment')) gt 0 then $
                ptr_free,onew->getProperty(tag='treatment')
            onew->setProperty,'treatment',ptr_new(treatmentnew)




        ;;    fitparmstemp = *(obj->getProperty(tag='fitparms'))
        ;;    if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        ;;    self.fitparms = ptr_new(fitparmstemp)
        ;;
                fixedtemp1 = *self.fixed
                help,fixedtemp1
                fixedtemp2 = *(obj->getProperty(tag='fixed'))
                help,fixedtemp2

                fitparmstemp1 = *self.fitparms
                fitparmstemp2 = *(obj->getProperty(tag='fitparms'))
                fitparmstemp2[0,*,*] = presetscaling*fitparmstemp2[0,*,*]
                fitparmstemp2[6,*,*] = presetscaling*fitparmstemp2[6,*,*]
                fitparmstemp2[1,*,*] = presetscaling*fitparmstemp2[1,*,*]
                fitparmstemp2[7,*,*] = presetscaling*fitparmstemp2[7,*,*]

                fitparmstemp1Old = *self.fitparmsOld
                fitparmstemp2Old = *(obj->getProperty(tag='fitparmsOld'))
                fitparmstemp2Old[0,*,*] = presetscaling*fitparmstemp2Old[0,*,*]
                fitparmstemp2Old[6,*,*] = presetscaling*fitparmstemp2Old[6,*,*]
                fitparmstemp2Old[1,*,*] = presetscaling*fitparmstemp2Old[1,*,*]
                fitparmstemp2Old[7,*,*] = presetscaling*fitparmstemp2Old[7,*,*]


                szfp1 = size(*self.fitparms)
                szfp2 = size(*(obj->getProperty(tag='fitparms')))
;                print,'ooEcho::mergeSet  szfp1=',szfp1
;                print,'ooEcho::mergeSet  szfp2=',szfp2
                szfp1Old = size(*self.fitparmsOld)
                szfp2Old = size(*(obj->getProperty(tag='fitparmsOld')))
                fixedtempnew = intarr(6,szfp1[2],szfp1[3]+szfp2[3])
;                help,fixedtempnew

                fitparmstempnew = dblarr(12,szfp1[2],szfp1[3]+szfp2[3])
                fitparmstempOldnew = dblarr(12,szfp1[2],szfp1[3]+szfp2[3])
                ;help,fitparmstempnew
                ;INTERLEAVE THE TWO fitparms ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        fixedtempnew[*,*,i] = fixedtemp1[*,*,i1]
                        fitparmstempnew[*,*,i] = fitparmstemp1[*,*,i1]
                        fitparmstempOldnew[*,*,i] = fitparmstemp1Old[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        fixedtempnew[*,*,i] = fixedtemp2[*,*,i2]
                        fitparmstempnew[*,*,i] = fitparmstemp2[*,*,i2]
                        fitparmstempOldnew[*,*,i] = fitparmstemp2Old[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,fitparmstempnew
                if ptr_valid(onew->getProperty(tag='fixed')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fixed')
                onew->setProperty,'fixed',$
                    ptr_new(fixedtempnew)

                if ptr_valid(onew->getProperty(tag='fitparms')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitparms')
                onew->setProperty,'fitparms',$
                    ptr_new(fitparmstempnew)

                if ptr_valid(onew->getProperty(tag='fitparmsOld')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitparmsOld')
                onew->setProperty,'fitparmsOld',$
                    ptr_new(fitparmstempOldnew)


        ;;    Iuptemp = *(obj->getProperty(tag='Iup'))
        ;;    if ptr_valid(self.Iup) gt 0 then ptr_free,self.Iup
        ;;    self.Iup = ptr_new(Iuptemp)
                Iuptemp1 = *self.Iup

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                Iuptemp2 = presetscaling*(*(obj->getProperty(tag='Iup')))
            endif else begin
                Iuptemp2 = *(obj->getProperty(tag='Iup'))
            endelse


                szfp1 = size(*self.Iup)
                szfp2 = size(*(obj->getProperty(tag='Iup')))
                Iuptempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,Iuptempnew
                ;INTERLEAVE THE TWO Iup ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        Iuptempnew[*,i] = Iuptemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        Iuptempnew[*,i] = Iuptemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,Iuptempnew
                if ptr_valid(onew->getProperty(tag='Iup')) gt 0 then $
                    ptr_free,onew->getProperty(tag='Iup')
                onew->setProperty,'Iup',$
                    ptr_new(Iuptempnew)



                Idowntemp1 = *self.Idown
            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                Idowntemp2 = presetscaling*(*(obj->getProperty(tag='Idown')))
            endif else begin
                Idowntemp2 = *(obj->getProperty(tag='Idown'))
            endelse
                szfp1 = size(*self.Idown)
                szfp2 = size(*(obj->getProperty(tag='Idown')))
                Idowntempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,Idowntempnew
                ;INTERLEAVE THE TWO Idown ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        Idowntempnew[*,i] = Idowntemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        Idowntempnew[*,i] = Idowntemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,Idowntempnew
                if ptr_valid(onew->getProperty(tag='Idown')) gt 0 then $
                    ptr_free,onew->getProperty(tag='Idown')
                onew->setProperty,'Idown',$
                    ptr_new(Idowntempnew)


        ;ARE THESE ERROR BARS CALCULATED WHEN Iup/down ARE CALCULATED??!!??

                sIuptemp1 = *self.sIup
            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                sIuptemp2 = presetscaling*(*(obj->getProperty(tag='sIup')))
            endif else begin
                sIuptemp2 = *(obj->getProperty(tag='sIup'))
            endelse
                szfp1 = size(*self.sIup)
                szfp2 = size(*(obj->getProperty(tag='sIup')))
                sIuptempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,sIuptempnew
                ;INTERLEAVE THE TWO sIup ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        sIuptempnew[*,i] = sIuptemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        sIuptempnew[*,i] = sIuptemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,sIuptempnew
                if ptr_valid(onew->getProperty(tag='sIup')) gt 0 then $
                    ptr_free,onew->getProperty(tag='sIup')
                onew->setProperty,'sIup',$
                    ptr_new(sIuptempnew)



                sIdowntemp1 = *self.sIdown
            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                sIdowntemp2 = presetscaling*(*(obj->getProperty(tag='sIdown')))
            endif else begin
                sIdowntemp2 = *(obj->getProperty(tag='sIdown'))
            endelse
                szfp1 = size(*self.sIdown)
                szfp2 = size(*(obj->getProperty(tag='sIdown')))
                sIdowntempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,sIdowntempnew
                ;INTERLEAVE THE TWO sIdown ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        sIdowntempnew[*,i] = sIdowntemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        sIdowntempnew[*,i] = sIdowntemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,sIdowntempnew
                if ptr_valid(onew->getProperty(tag='sIdown')) gt 0 then $
                    ptr_free,onew->getProperty(tag='sIdown')
                onew->setProperty,'sIdown',$
                    ptr_new(sIdowntempnew)



            onew->setProperty,'IupdownSwitch',obj->getProperty(tag='IupdownSwitch')




        ;;
        ;ARE THE DIMENSIONS CORRECT FOR S???????

        ;    Stemp = $
        ;        *(obj->getProperty(tag='S'))
        ;    if ptr_valid(onew->getProperty(tag='S')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='S')
        ;    onew->setProperty,'S',$
        ;        ptr_new(Stemp)

                Stemp1 = *self.S
                Stemp2 = *(obj->getProperty(tag='S'))
                szfp1 = size(*self.S)
                szfp2 = size(*(obj->getProperty(tag='S')))
                Stempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,S
                ;INTERLEAVE THE TWO S ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        Stempnew[*,i] = Stemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        Stempnew[*,i] = Stemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,Stempnew
                if ptr_valid(onew->getProperty(tag='S')) gt 0 then $
                    ptr_free,onew->getProperty(tag='S')
                onew->setProperty,'S',$
                    ptr_new(Stempnew)



        ;    sStemp = $
        ;        *(obj->getProperty(tag='sS'))
        ;    if ptr_valid(onew->getProperty(tag='sS')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='sS')
        ;    onew->setProperty,'sS',$
        ;        ptr_new(sStemp)



                sStemp1 = *self.sS
                sStemp2 = *(obj->getProperty(tag='sS'))
                szfp1 = size(*self.sS)
                szfp2 = size(*(obj->getProperty(tag='sS')))
                sStempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,sS
                ;INTERLEAVE THE TWO sS ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        sStempnew[*,i] = sStemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        sStempnew[*,i] = sStemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,sStempnew
                if ptr_valid(onew->getProperty(tag='sS')) gt 0 then $
                    ptr_free,onew->getProperty(tag='sS')
                onew->setProperty,'sS',$
                    ptr_new(sStempnew)







            IQTInfotemp = $
                *(obj->getProperty(tag='IQTInfo'))
            if ptr_valid(onew->getProperty(tag='IQTInfo')) gt 0 then $
                ptr_free,onew->getProperty(tag='IQTInfo')
            onew->setProperty,'IQTInfo',$
                ptr_new(IQTInfotemp)





        ;    IQTtemp = $
        ;        *(obj->getProperty(tag='IQT'))
        ;    if ptr_valid(onew->getProperty(tag='IQT')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='IQT')
        ;    onew->setProperty,'IQT',$
        ;        ptr_new(IQTtemp)

            ;IQT = DOUBLE  Array[narcs, no_of_fourier_times]
            IQTtemp1 = *self.IQT
            IQTtemp2 = *(obj->getProperty(tag='IQT'))
            szfp1 = size(*self.IQT)
            szfp2 = size(*(obj->getProperty(tag='IQT')))
            IQTtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])

;041305
;DO NOT INTERLEAVE THESE ARRAYS SINCE THE VALUES WILL NEVER BE ACCESSED UNTIL
;CALCULATED FOR DISPLAYIQT.,
;;;;;
;;;;;
;;;;;            ;help,IQT
;;;;;            ;INTERLEAVE THE TWO IQT ARRAYS
;;;;;            i1 = 0 & i2 = 0
;;;;;            for i=0,n_elements(order)-1 do begin
;;;;;
;;;;;                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;;;;;                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;;;;;                ;DATA ARRAYS
;;;;;                if order[i] eq 1 then begin
;;;;;                    IQTtempnew[*,i] = IQTtemp1[*,i1]
;;;;;                    i1 = i1 + 1
;;;;;                endif else begin
;;;;;                    IQTtempnew[*,i] = IQTtemp2[*,i2]
;;;;;                    i2 = i2 + 1
;;;;;                endelse
;;;;;            endfor;i
            ;help,IQTtempnew
            if ptr_valid(onew->getProperty(tag='IQT')) gt 0 then $
                ptr_free,onew->getProperty(tag='IQT')
            onew->setProperty,'IQT',$
                ptr_new(IQTtempnew)





        ;    sIQTtemp = $
        ;        *(obj->getProperty(tag='sIQT'))
        ;    if ptr_valid(onew->getProperty(tag='sIQT')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='sIQT')
        ;    onew->setProperty,'sIQT',$
        ;        ptr_new(sIQTtemp)


            sIQTtemp1 = *self.sIQT
            sIQTtemp2 = *(obj->getProperty(tag='sIQT'))
            szfp1 = size(*self.sIQT)
            szfp2 = size(*(obj->getProperty(tag='sIQT')))
            sIQTtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])

;;;;;            ;help,IQT
;;;;;            ;INTERLEAVE THE TWO IQT ARRAYS
;;;;;            i1 = 0 & i2 = 0
;;;;;            for i=0,n_elements(order)-1 do begin
;;;;;
;;;;;                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;;;;;                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;;;;;                ;DATA ARRAYS
;;;;;                if order[i] eq 1 then begin
;;;;;                    sIQTtempnew[*,i] = sIQTtemp1[*,i1]
;;;;;                    i1 = i1 + 1
;;;;;                endif else begin
;;;;;                    sIQTtempnew[*,i] = sIQTtemp2[*,i2]
;;;;;                    i2 = i2 + 1
;;;;;                endelse
;;;;;            endfor;i
;;;;;            ;help,IQTtempnew
            if ptr_valid(onew->getProperty(tag='sIQT')) gt 0 then $
                ptr_free,onew->getProperty(tag='sIQT')
            onew->setProperty,'sIQT',$
                ptr_new(sIQTtempnew)

            IQTFitparmsnew = dblarr(szfp1[1],2)
            if ptr_valid(onew->getProperty(tag='IQTFitparms')) gt 0 then $
                ptr_free,onew->getProperty(tag='IQTFitparms')
            onew->setProperty,'IQTFitparms',ptr_new(IQTFitparmsnew)



            narcs = obj->getProperty(tag='narcs')
            onew->setProperty,'narcs',narcs

            qarcstemp = $
                *(obj->getProperty(tag='qarcs'))
            if ptr_valid(onew->getProperty(tag='qarcs')) gt 0 then $
                ptr_free,onew->getProperty(tag='qarcs')
            onew->setProperty,'qarcs',$
                ptr_new(qarcstemp)



        ;    QValstemp = $
        ;        *(obj->getProperty(tag='QVals'))
        ;    if ptr_valid(onew->getProperty(tag='QVals')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='QVals')
        ;    onew->setProperty,'QVals',$
        ;        ptr_new(QValstemp)



            QValstemp1 = *self.QVals
            QValstemp2 = *(obj->getProperty(tag='QVals'))
            szfp1 = size(*self.QVals)
            szfp2 = size(*(obj->getProperty(tag='QVals')))
            QValstempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
            ;help,IQT
            ;INTERLEAVE THE TWO IQT ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    QValstempnew[*,i] = QValstemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    QValstempnew[*,i] = QValstemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i
            ;help,IQTtempnew
            if ptr_valid(onew->getProperty(tag='QVals')) gt 0 then $
                ptr_free,onew->getProperty(tag='QVals')
            onew->setProperty,'QVals',$
                ptr_new(QValstempnew)




            ;THIS MAKES SURE THAT ALL QVals ARE CALCULATED
            onew->setProperty,'QValsSwitch',obj->getProperty(tag='QValsSwitch')*self.QValsSwitch

            chisqtemp1 = (*self.chisq)
            chisqtemp2 = *(obj->getProperty(tag='chisq'))
            szchsq1 = size(chisqtemp1)
            szchsq2 = size(chisqtemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            chisqtempnew = dblarr(szchsq1[1],szchsq1[2]+szchsq2[2])
            ;help,chisqtempnew
            ;INTERLEAVE THE TWO chisq ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    chisqtempnew[*,i] = chisqtemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    chisqtempnew[*,i] = chisqtemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='chisq')) gt 0 then $
                ptr_free,onew->getProperty(tag='chisq')
            onew->setProperty,'chisq',$
                ptr_new(chisqtempnew)



         ;DOUBLE    = Array[self.detxdim*self.detydim, no_of_fourier_times]
            chisqOldtemp1 = (*self.chisqOld)
            chisqOldtemp2 = *(obj->getProperty(tag='chisqOld'))
            szchsq1 = size(chisqOldtemp1)
            szchsq2 = size(chisqOldtemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            chisqOldtempnew = dblarr(szchsq1[1],szchsq1[2]+szchsq2[2])
            ;help,chisqOldtempnew
            ;INTERLEAVE THE TWO chisqOld ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    chisqOldtempnew[*,i] = chisqOldtemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    chisqOldtempnew[*,i] = chisqOldtemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='chisqOld')) gt 0 then $
                ptr_free,onew->getProperty(tag='chisqOld')
            onew->setProperty,'chisqOld',$
                ptr_new(chisqOldtempnew)





            onew->setProperty,'currentPhaseIndex', $
                        obj->getProperty(tag='currentPhaseIndex')




        ;CAN THE no_of_phases,point_to_down, point_to_up AND
        ;phase_step CHANGE FROM SET TO SET????
            onew->setProperty,'no_of_phases',obj->getProperty(tag='no_of_phases')
            onew->setProperty,'point_to_down',obj->getProperty(tag='point_to_down')
            onew->setProperty,'point_to_up',obj->getProperty(tag='point_to_up')
            onew->setProperty,'phase_step',obj->getProperty(tag='phase_step')

            ;THE NEW NUMBER OF FOURIER TIMES IS THE SUM OF THE
            ;NUMBERS OF FOURIER TIMES FOR THE MERGED SETS.
            onew->setProperty,'no_of_fourier_times', $
                (obj->getProperty(tag='no_of_fourier_times')+ $
                    self.no_of_fourier_times)


            onew->setProperty,'no_of_pixels', $
                                obj->getProperty(tag='no_of_pixels')

            onew->setProperty,'x_dim',obj->getProperty(tag='x_dim')
            onew->setProperty,'y_dim',obj->getProperty(tag='y_dim')
            onew->setProperty,'x_dim_orig',obj->getProperty(tag='x_dim_orig')
            onew->setProperty,'y_dim_orig',obj->getProperty(tag='y_dim_orig')

;031705
;TAKE THE NEXT VALUES FROM SELF!!!

;            onew->setProperty,'x_cen',obj->getProperty(tag='x_cen')
;            onew->setProperty,'y_cen',obj->getProperty(tag='y_cen')
;            onew->setProperty,'x_cen_orig',obj->getProperty(tag='x_cen_orig')
;            onew->setProperty,'y_cen_orig',obj->getProperty(tag='y_cen_orig')
;
;            onew->setProperty,'colorTable',obj->getProperty(tag='colorTable')
;            onew->setProperty,'q',obj->getProperty(tag='q')
;            onew->setProperty,'qactual',obj->getProperty(tag='qactual')
;            onew->setProperty,'qy',obj->getProperty(tag='qy')
;            onew->setProperty,'currentFourierTimeIndex', $
;                        obj->getProperty(tag='currentFourierTimeIndex')

            onew->setProperty,'x_cen',self->getProperty(tag='x_cen')
            onew->setProperty,'y_cen',self->getProperty(tag='y_cen')
            onew->setProperty,'x_cen_orig',self->getProperty(tag='x_cen_orig')
            onew->setProperty,'y_cen_orig',self->getProperty(tag='y_cen_orig')

            onew->setProperty,'colorTable',self->getProperty(tag='colorTable')
            onew->setProperty,'q',self->getProperty(tag='q')
            onew->setProperty,'qactual',self->getProperty(tag='qactual')
            onew->setProperty,'qy',self->getProperty(tag='qy')
            onew->setProperty,'currentFourierTimeIndex', $
                        self->getProperty(tag='currentFourierTimeIndex')


        ;; FILL IN THE HEADER POINTERS WITH DATA FROM THE INPUT OBJECT.
            scanHeadertemp = $
                *(obj->getProperty(tag='scanHeader'))
            if ptr_valid(onew->getProperty(tag='scanHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='scanHeader')
            onew->setProperty,'scanHeader',$
                ptr_new(scanHeadertemp)


            sampleHeadertemp = $
                *(obj->getProperty(tag='sampleHeader'))
            if ptr_valid(onew->getProperty(tag='sampleHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='sampleHeader')
            onew->setProperty,'sampleHeader',$
                ptr_new(sampleHeadertemp)


            ;STRING    = Array[54, no_of_fourier_times]
        ;    techHeadertemp = $
        ;        *(obj->getProperty(tag='techHeader'))
        ;    if ptr_valid(onew->getProperty(tag='techHeader')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='techHeader')
        ;    onew->setProperty,'techHeader',$
        ;        ptr_new(techHeadertemp)
        ;

            techHeadertemp1 = (*self.techHeader)
            techHeadertemp2 = *(obj->getProperty(tag='techHeader'))
            szchsq1 = size(techHeadertemp1)
            szchsq2 = size(techHeadertemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            techHeadertempnew = strarr(max([szchsq1[1],szchsq2[1]]),szchsq1[2]+szchsq2[2])
            ;help,techHeadertempnew
            ;INTERLEAVE THE TWO techHeader ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    techHeadertempnew[0:szchsq1[1]-1,i] = techHeadertemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    techHeadertempnew[0:szchsq2[1]-1,i] = techHeadertemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='techHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='techHeader')
            onew->setProperty,'techHeader',$
                ptr_new(techHeadertempnew)









            ;STRING    = Array[16, no_of_fourier_times]
        ;    physicsHeadertemp = $
        ;        *(obj->getProperty(tag='physicsHeader'))
        ;    if ptr_valid(onew->getProperty(tag='physicsHeader')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='physicsHeader')
        ;    onew->setProperty,'physicsHeader',$
        ;        ptr_new(physicsHeadertemp)
        ;


            physicsHeadertemp1 = (*self.physicsHeader)
            physicsHeadertemp2 = *(obj->getProperty(tag='physicsHeader'))
            szchsq1 = size(physicsHeadertemp1)
            szchsq2 = size(physicsHeadertemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            physicsHeadertempnew = strarr(max([szchsq1[1],szchsq2[1]]),szchsq1[2]+szchsq2[2])
            ;help,physicsHeadertempnew
            ;INTERLEAVE THE TWO physicsHeader ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    physicsHeadertempnew[0:szchsq1[1]-1,i] = physicsHeadertemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    physicsHeadertempnew[0:szchsq2[1]-1,i] = physicsHeadertemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='physicsHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='physicsHeader')
            onew->setProperty,'physicsHeader',$
                ptr_new(physicsHeadertempnew)









            ;STRING    = Array[44, no_of_fourier_times]
        ;    physicsParametersHeadertemp = $
        ;        *(obj->getProperty(tag='physicsParametersHeader'))
        ;    if ptr_valid(onew->getProperty(tag='physicsParametersHeader')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='physicsParametersHeader')
        ;    onew->setProperty,'physicsParametersHeader',$
        ;        ptr_new(physicsParametersHeadertemp)
        ;


            physicsParametersHeadertemp1 = (*self.physicsParametersHeader)
            physicsParametersHeadertemp2 = *(obj->getProperty(tag='physicsParametersHeader'))
            szchsq1 = size(physicsParametersHeadertemp1)
            szchsq2 = size(physicsParametersHeadertemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            physicsParametersHeadertempnew = strarr(max([szchsq1[1],szchsq2[1]]),szchsq1[2]+szchsq2[2])
            ;help,physicsParametersHeadertempnew
            ;INTERLEAVE THE TWO physicsParametersHeader ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    physicsParametersHeadertempnew[0:szchsq1[1]-1,i] = physicsParametersHeadertemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    physicsParametersHeadertempnew[0:szchsq2[1]-1,i] = physicsParametersHeadertemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='physicsParametersHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='physicsParametersHeader')
            onew->setProperty,'physicsParametersHeader',$
                ptr_new(physicsParametersHeadertempnew)







            ; STRING    = Array[4, no_of_phases, no_of_fourier_times]
            phaseHeadertemp = *(obj->getProperty(tag='phaseHeader'))
            if ptr_valid(onew->getProperty(tag='phaseHeader')) gt 0 then $
                                ptr_free,onew->getProperty(tag='phaseHeader')
            onew->setProperty,'phaseHeader',ptr_new(phaseHeadertemp)



            phaseHeadertemp1 = (*self.phaseHeader)
            phaseHeadertemp2 = *(obj->getProperty(tag='phaseHeader'))
            szchsq1 = size(phaseHeadertemp1)
            szchsq2 = size(phaseHeadertemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            phaseHeadertempnew = strarr(szchsq1[1],szchsq1[2],szchsq1[3]+szchsq2[3])
            ;help,phaseHeadertempnew
            ;INTERLEAVE THE TWO phaseHeader ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    phaseHeadertempnew[*,i] = phaseHeadertemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    phaseHeadertempnew[*,i] = phaseHeadertemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='phaseHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='phaseHeader')
            onew->setProperty,'phaseHeader',$
                ptr_new(phaseHeadertempnew)



            ;help,*(onew->getProperty(tag='phase'))
            return,onew
            endif else begin
                print,'14560 ooecho::mergeset THE OBJECTS HAVE DIFFERENT DETECTOR/BINNING SIZES!!!!!'
                return,0
            endelse

        ;NOW DO OTHER 3D ARRAYS
        ;---011805 WHICH OTHER 3D ARRAYS???
    endif else begin
        void = dialog_message('The sizes, types and/or q values do not match.  No merge.')
    endelse


end;mergeSet
;;;;;;;;;;;;;;;;;;;;;
function ooEcho::merge,obj,_Extra=extra
;
;NAME:
;        ooEcho::merge
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;

    ;CHECK THE DIMENSIONS OF obj TO SEE THAT THEY
    ;MATCH self, AND IF THEY DO THEN
        return,self->mergeSet(obj)   ;NOTE THAT THIS "mergeSet" REFERS TO DATA SETS, AND NOT A SET OF DATA OBJECTS.
    ;ELSE

    ;

    ;return,obj_new('ooEcho',obj=self)
end;merge
;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::removeFourierTime,t,_Extra=extra
;
;NAME:
;        ooEcho::removeFourierTime
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.


    print,'You have asked me to remove Fourier time '+string(strtrim(t*(10.0^9)))+' ns.'
    print,'I will remove Fourier times when you teach me how!!!'
    print,'Try to adapt ooEcho::mergset to this task.'


    fourierTime = *(self->getProperty(tag='fourierTime'))

    removalIndex = where(fourierTime eq t)
    print,fourierTime(removalIndex)


    ;IF I FOLLOW THE mergeSet MODEL FOR REMOVING FOURIER TIMES,
    ;I WILL SIMPLY CREATE A NEW OBJECT WITH THE FOURIER TIME
    ;MISSING AND LET THE DISPLAY PROGRAM SORT OUT WHICH OBJECT TO
    ;KEEP.


end;removeFourierTime
;;;;;;;;;;;;;;;;;;;;;
function ooEcho::clone,_Extra=extra
;
;NAME:
;        ooEcho::clone
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;
;    o = obj_new('ooEcho',obj=self)
;    return,o
    return,obj_new('ooEcho',obj=self)
end
;;;;;;;;;;;;;;;;;;;;;
;pro ooEcho::writeIQTASCII,work_dir
;;
;;NAME:
;;        ooEcho::writeIQTASCII
;;
;;PURPOSE:
;;
;;PARAMETERS:
;;
;;KEYWORDS:
;;
;;_EXTRA - is used to pass keywords meant for the superclass.
;
;
;    tempfn = dialog_pickfile(/write,$
;                            title='I(Q,t) ASCII export file:',$
;                            path=work_dir,$
;                            /overwrite_prompt)
;
;    if tempfn ne '' then begin
;        ;work_dir = file_dirname(tempfn,/mark_directory)
;        openw,lun,tempfn,/get_lun
;
;        iqtinfo = *(self.IQTInfo)
;        iqt = *(self.IQT)
;        diqt = *(self.sIQT)
;        t = *(self.fouriertime)
;        q = *(self.qarcs)
;
;        ;091504
;        ;
;        ;SET UP ASCII OUTPUT HERE.
;        ;
;        ;NEED FOR LOOP AND Q,t INFORMATION
;        for ii = 0,n_elements(iqtinfo)-1 do begin
;            printf,lun,iqtinfo[ii]
;        endfor;ii
;        printf,lun,'# Q     t(ns)       I(Q,t)      sI(Q,t)'
;
;        sz = size(iqt)
;
;        for i=0,sz[1]-1 do begin
;            for j=0,sz[2]-1 do begin
;                printf,lun,(q[i]),'   ',$
;                            (10.0^9)*t[j],'   ',$
;                            iqt[i,j],'   ',$
;                            diqt[i,j]
;            endfor;j
;        endfor;i
;
;        free_lun,lun,/force
;    endif else begin
;        void = dialog_message('No file selected.')
;    endelse
;
;
;end;writeIQTASCII
pro ooEcho::writeIQTASCII,work_dir,group_leader=group_leader,_Extra=extra
;
;NAME:
;        ooEcho::writeIQTASCII
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

group_leader = (keyword_set(group_leader))? group_leader : 0L
iqt = *(self.IQT)
diqt = *(self.sIQT)
t = *(self.fouriertime)
q = *(self.qarcs)
logBuf = *(Self.iqtinfo)


;LRK - 07/14/09
;ELIMINATE ARCS THAT ARE ENTIRELY NaN's
sz = size(iqt)
print,sz
dowrite = intarr(sz[1])+1
for i=0,sz[1]-1 do begin
  ;DON'T WRITE DATA TO FILE IF THE CAME FROM AN ENTIRELY MASKED Q ARC
  if total(finite(iqt[i,*],/nan)) eq n_elements(iqt[i,*]) then dowrite[i] = 0
endfor;i

;IF THERE ARE NO DATA TO WRITE THEN exit
if (total(dowrite) le 0) then begin
  void = dialog_message('No valid I(Q,t) available', dialog_parent=group_leader,/error)
  return
endif
  
newiqt = dblarr(total(dowrite),sz[2]) 
newdiqt = dblarr(total(dowrite),sz[2]) 
newq = dblarr(total(dowrite))
pos = 0
for i=0,sz[1]-1 do begin
  if dowrite[i] eq 1 then begin
    newiqt[pos,*] = iqt[i,*]
    newdiqt[pos,*] = diqt[i,*]
    newq[pos] = q[i]
    pos++
  endif
endfor;i
iqt = newiqt
diqt = newdiqt
q = newq

; suggest a filename from the original signal raw dataset name
sugg_filename = Self.filename
if ((!version.os_family ne 'Windows') && (Stregex(sugg_filename,'\\') gt 0)) then begin
  ; if we are on a unix but this this was a restored session with raw filename pointing to a Windows file path, 
  ; then file_basename() will not function properly to retrieve the base filename.
  ; Hence need to perform this extra processing to retrieve the basename.
  toks = strsplit(sugg_filename,'\',count=ntoks,/extract)
  sugg_filename = (ntoks eq 1)? sugg_filename : toks[ntoks-1]
endif
if (stregex(sugg_filename,'.echo.dat.nse') gt 0) then $
  sugg_filename = File_basename(sugg_filename,'.echo.dat.nse')+'_iqt.txt'  ; replace .echo.dat.nse with .txt
if (Stregex(sugg_filename,'.echo') gt 0) then $
  sugg_filename = File_basename(sugg_filename,'.echo')+'_iqt.txt'          ; replace .echo with .txt

filepath = File_test(self.workdir)? self.workdir : ''
filename = Dialog_pickfile(/write,$
  title='Select file to save I(Q,t) in ASCII format',$
  file=sugg_filename, $
  filter=[['*.txt'],['*.*']], $
  default_extension='txt', $
  path=filepath,$
  get_path=newpath, dialog_parent=group_leader, $
  /overwrite_prompt)

if (Strtrim(filename) eq '') then Return
if Isa(newpath) then self.workdir = newpath

;openw,infolun,tempfn+'_info',/get_lun
;for ii = 0,n_elements(iqtinfo)-1 do begin
;    printf,infolun,iqtinfo[ii]
;endfor;ii
;free_lun,infolun

sz = size(iqt)
nQ = sz[1]
nT = sz[2]
logfilename = file_dirname(filename)+path_sep()+File_basename(filename,'.txt',/fold_case)+'.log'

;; Prepare and save I(Q,t) to file
header = '# A supplementary log file was produced during the creation of the reduced data below.'
header = [header,'# Please review the log file for all data reduction parameters used in processing this result']
header = [header,'# Log filename: '+logfilename]
line = '# t(ns)'
for i =0,nQ-1 do begin
  line = [line, 'I('+string(q[i],format='(F5.3)')+',t)','error']
endfor
nCols = n_elements(line) - 1
fmt1 = '(A7,'+strtrim(string(nCols,format='(I2)'),2)+'A15)'
Openw,lun,filename,/get_lun
printf,lun,header
printf,lun,line,format=fmt1
fmt1 = '(F7.4,'+Strtrim(String(nCols,format='(I2)'),2)+'G15.7)'
for j=0,nT-1 do begin
    line = (10.0^9)*t[j]
    for i=0,nQ-1 do begin
        line = [line,iqt[i,j],diqt[i,j]]
    endfor;i
    printf,lun,line,format=fmt1
endfor;j
free_lun,lun,/force

;; Save treatment history or log to file as well
Openw,lun,logfilename,/get_lun
printf,lun,logBuf,format='(A)'
Free_lun,lun,/force

msg = ['Reduced I(Q,t) data stored in:',filename,'']
msg = [msg,'Supplementary treatment details saved in:',logfilename] 
void = dialog_message(msg,/information,dialog_parent=group_leader)
end;writeIQTASCII

;function strendsub,s,ssub,n,_Extra=extra
;;###############################################################################
;;
;;NAME:
;;        strendsub
;;
;;PURPOSE:
;;           Substitute the last n letters of s with ssub and return the new string.
;;           This is more generally useful than just for the addheader methods.
;;PARAMETERS:
;;           s       The string.
;;           ssub    The text used to replace the selected substring.
;;           n       The length from the end of s of the substring to replace.
;;KEYWORDS:
;;           none
;;
;;RETURN VALUE:
;;           snew    The new string with the sustituted substring.
;;###############################################################################
;    ;SUBSTITUTE THE LAST n LETTERS OF s WITH ssub
;
;    snew = strarr(n_elements(s))
;    lens = strlen(s)
;
;    for i=0,n_elements(s)-1 do begin
;        stemp = strmid(s[i],0,lens[i]-n)
;        snew[i] =  stemp + ssub
;    endfor;i
;
;    return,snew
;end;strendsub


;
;NAME:
;        ooEcho::writeIQTASCII
;
;PURPOSE:
;           Write ASCII files without the Q information for easy import to PAN.
;PARAMETERS:
;           work_dir    The current working directory.
;KEYWORDS:
;           none
pro ooEcho::writeIQT3ColASCII,work_dir,group_leader=group_leader,_Extra=extra
group_leader = (Keyword_set(group_leader))? group_leader : 0L
iqt = *(self.iqt)
diqt = *(self.siqt)
t = *(self.fouriertime)
q = *(self.qarcs)
logBuf = *(Self.iqtinfo)

;ELIMINATE ARCS THAT ARE ENTIRELY NaN's
sz = Size(iqt)
;Print,sz
dowrite = Intarr(sz[1])+1
for i=0,sz[1]-1 do begin
  ;DON'T WRITE DATA TO FILE IF THE CAME FROM AN ENTIRELY MASKED Q ARC
  if Total(Finite(iqt[i,*],/nan)) eq N_elements(iqt[i,*]) then dowrite[i] = 0
endfor;i

;IF THERE ARE NO DATA TO WRITE THEN exit
if (Total(dowrite) le 0) then begin
  void = Dialog_message('No valid I(Q,t) available!', dialog_parent=group_leader,/ERROR)
  Return
endif

dir = dialog_pickfile(/write, dialog_parent=group_leader,$
                        title='Select DIRECTORY to save I(Q,t) in 3-Column ASCII format',$
                        /directory,$
                        path=self.workdir)

if (dir eq '') then Return
if (~file_test(dir)) then return

; suggest a filename from the original signal raw dataset name
base_filename = Self.filename
if ((!version.os_family ne 'Windows') && (Stregex(base_filename,'\\') gt 0)) then begin
  ; if we are on a unix but this this was a restored session with raw filename pointing to a Windows file path,
  ; then file_basename() will not function properly to retrieve the base filename.
  ; Hence need to perform this extra processing to retrieve the basename.
  toks = Strsplit(base_filename,'\',count=ntoks,/extract)
  base_filename = (ntoks eq 1)? base_filename : toks[ntoks-1]
endif
if (Stregex(base_filename,'.echo.dat.nse') gt 0) then $
  base_filename = File_basename(base_filename,'.echo.dat.nse')+'_iqt'  ; remove .echo.dat.nse ext
if (Stregex(base_filename,'.echo') gt 0) then $
  base_filename = File_basename(base_filename,'.echo')+'_iqt'          ; remove .echo ext
base_filename = dir+base_filename         ; add the directory selected by user
log_filename = base_filename+'.log'       ; use for saving the log file
out_msg  = 'Reduced I(Q,t) for each Q stored in:'

header = '# A supplementary log file was produced during the creation of the reduced data below.'
header = [header,'# Please review the log file for all data reduction parameters used in processing this result']
header = [header,'# Log filename: '+log_filename]

ctitles = Strarr(4)
ctitles[0]='#'
ctitles[1]='t(ns)'
ctitles[2]='I(Q,t)'
ctitles[3]='Error'
for i=0,sz[1]-1 do begin
  if (dowrite[i] eq 0) then continue

  sqval = String(format='(f6.4)',q[i])
  this_header = ['# Reduced I(Q,t) for Q = '+sqval+' 1/A',header]
  filename = base_filename+sqval+'.txt'
  Openw,lun,filename,/get_lun
  printf,lun,this_header, format='(A)'
  Printf,lun,ctitles,format='(A1,3A13)'
  for j=0,sz[2]-1 do Printf,lun,(1.0e9)*t[j],iqt[i,j],diqt[i,j], format = '(3f14.7)'
  Free_lun,lun,/force
  out_msg = [out_msg,filename]
endfor;i

;; Save treatment history or log to file as well
Openw,lun,log_filename,/get_lun
Printf,lun,logBuf,format='(A)'
Free_lun,lun,/force
out_msg = [out_msg,'','Supplementary treatment details were also generated']
out_msg = [out_msg,'These are saved in the following log file for your review:',log_filename]
void = Dialog_message(out_msg,/information,dialog_parent=group_leader)

end;writeIQT3ColASCII


;
;NAME:
;        ooEcho::writeIQTIgor
;
;PURPOSE:
;               Write Igor style ascii files with the same filename style.
;PARAMETERS:
;               none
;KEYWORDS:
;               work_dir    The directory for selecting a file name.
;RETURN VALUE:
;               1 for success 0 for failure.
function ooEcho::writeIQTIgor,work_dir=work_dir,group_leader=group_leader,_Extra=extra
group_leader = (Keyword_set(group_leader))? group_leader : 0L
iqt = *(self.iqt)
diqt = *(self.siqt)
t = *(self.fouriertime)
q = *(self.qarcs)
logBuf = *(Self.iqtinfo)

;ELIMINATE ARCS THAT ARE ENTIRELY NaN's
sz = Size(iqt)
Print,sz
dowrite = Intarr(sz[1])+1
for i=0,sz[1]-1 do begin
  ;DON'T WRITE DATA TO FILE IF THE CAME FROM AN ENTIRELY MASKED Q ARC
  if Total(Finite(iqt[i,*],/nan)) eq N_elements(iqt[i,*]) then dowrite[i] = 0
endfor;i

;IF THERE ARE NO DATA TO WRITE THEN exit
if (Total(dowrite) le 0) then begin
  void = Dialog_message('No valid I(Q,t) available!', dialog_parent=group_leader,/ERROR)
  Return, 0
endif

dir = dialog_pickfile(/write, dialog_parent=group_leader,$
                        title='Select DIRECTORY to save I(Q,t) in Igor format',$
                        /directory,$
                        path=self.workdir)

if (dir eq '') then Return,0
if (~file_test(dir)) then return, 0

; suggest a filename from the original signal raw dataset name
base_filename = Self.filename
if ((!version.os_family ne 'Windows') && (Stregex(base_filename,'\\') gt 0)) then begin
  ; if we are on a unix but this this was a restored session with raw filename pointing to a Windows file path,
  ; then file_basename() will not function properly to retrieve the base filename.
  ; Hence need to perform this extra processing to retrieve the basename.
  toks = Strsplit(base_filename,'\',count=ntoks,/extract)
  base_filename = (ntoks eq 1)? base_filename : toks[ntoks-1]
endif
if (Stregex(base_filename,'.echo.dat.nse') gt 0) then $
  base_filename = File_basename(base_filename,'.echo.dat.nse')+'_iqt'  ; remove .echo.dat.nse ext
if (Stregex(base_filename,'.echo') gt 0) then $
  base_filename = File_basename(base_filename,'.echo')+'_iqt'          ; remove .echo ext
base_filename = dir+base_filename         ; add the directory selected by user
log_filename = base_filename+'.log'       ; use for saving the log file
out_msg  = 'Reduced I(Q,t) for each Q stored in:'
sz = size(iqt)
for i=0,sz[1]-1 do begin
  if (dowrite[i] eq 0) then continue
;  if total(finite(iqt[i,*],/nan)) ne n_elements(finite(iqt[i,*],/nan)) then begin
;    ;CREATE FILENAME FOR EACH Q VALUE
;    newfn = ''
;    if q[i] ne double('infinity') and $
;        q[i] ne double('nan') then begin
;            sqval = string(format='(f6.4)',q[i])
;    endif else begin
;        sqval = 'NaN'
;    endelse

  sqval = string(format='(f6.4)',q[i])
  filename = base_filename+sqval+'.dat'
  openw,lun,filename,/get_lun

  ;CREATE COLUMN HEADERS
  snum = strtrim(string(i+1),2)
  ctitles = strarr(4)
  ctitles[0]='q'+snum
  ctitles[1]='ft_ns'
  ctitles[2]='IQT_'+snum
  ctitles[3]='IQT_'+snum+'e'
  printf,lun,ctitles,format='(4a14)'
  for j=0,sz[2]-1 do begin
      printf,lun,(q[i]),(10.0^9)*t[j],$
                  iqt[i,j],diqt[i,j], $
                  format = '(4f14.7)'
  endfor;j
  free_lun,lun,/force
  out_msg = [out_msg,filename]
endfor;i

;; Save treatment history or log to file as well
Openw,lun,log_filename,/get_lun
Printf,lun,logBuf,format='(A)'
Free_lun,lun,/force
out_msg = [out_msg,'','Supplementary treatment details were also generated']
out_msg = [out_msg,'These are saved in the following log file for your review:',log_filename]
void = Dialog_message(out_msg,/information,dialog_parent=group_leader)

return, 1

end;writeIQTIgor


;###############################################################################
;
;NAME:
;        cwo_mergeIQTToDave::getExt
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function ooEcho::getExt,s,_Extra=extra
        iext = strpos(s,'.',/reverse_search)

        if iext ne -1 then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
        endif else begin
            ext = ''
        endelse
        return,ext

end;cwo_mergeIQTToDave::getExt



;
;NAME:
;        ooEcho::writeDave
;
;PURPOSE:
;               Write a Dave pointer of the I(Q,t) data to a file.
;PARAMETERS:
;               filename        The output filename
;KEYWORDS:
;               work_dir        The working directory for the output file
;RETURN VALUE:
;               1 for success 0 for failure
function ooEcho::writeDave,filename,work_dir=work_dir,group_leader=group_leader $
                          ,exportToDAVEDM=exportToDAVEDM, fitInPAN=fitInPAN, $
                          DAVETool=DAVETool,_Extra=extra ; ,dialog_parent=dialog_parent

if n_elements(group_leader) eq 0 then group_leader = 0L
writeToDisk = (keyword_set(exportToDAVEDM) || keyword_set(fitInPAN))? 0 : 1

; suggest a filename from the original signal raw dataset name
sugg_filename = Self.filename
if ((!version.os_family ne 'Windows') && (Stregex(sugg_filename,'\\') gt 0)) then begin
  ; if we are on a unix but this this was a restored session with raw filename pointing to a Windows file path,
  ; then file_basename() will not function properly to retrieve the base filename.
  ; Hence need to perform this extra processing to retrieve the basename.
  toks = Strsplit(sugg_filename,'\',count=ntoks,/extract)
  sugg_filename = (ntoks eq 1)? sugg_filename : toks[ntoks-1]
endif
if (Stregex(sugg_filename,'.echo.dat.nse') gt 0) then $
  sugg_filename = File_basename(sugg_filename,'.echo.dat.nse')+'_iqt'
if (Stregex(sugg_filename,'.echo') gt 0) then $
  sugg_filename = File_basename(sugg_filename,'.echo')+'_iqt'

if (writeToDisk && (n_elements(filename) eq 0)) then begin
  filename = dialog_pickfile(/write,$
                  title='Select file to save I(Q,t) in DAVE format',$
                  file=sugg_filename+'.dave', $
                 path=work_dir,$
                  /overwrite_prompt,$
                  filter='*.dave',dialog_parent=group_leader)
  if filename eq '' then Return, 0
  ext = self->Getext(filename)
  if Strcmp(ext,'DAVE',/fold_case) eq 0 then filename = filename+'.dave'
endif

instrument = 'NSE'
qty = transpose(*self.iqt)
dqty = transpose(*self.siqt);0d*qty
x = *self.fouriertime
y = *self.qarcs

;LRK - 07/14/09
;ELIMINATE ARCS THAT ARE ENTIRELY NaN's
sz = size(qty)
dowrite = intarr(sz[2])+1
for i=0,sz[2]-1 do begin
  if total(finite(qty[*,i],/nan)) eq n_elements(qty[*,i]) then dowrite[i] = 0
endfor;i

;IF THERE ARE NO DATA TO WRITE THEN 
if total(dowrite) gt 0 then begin
  newqty = dblarr(sz[1],total(dowrite)) 
  newdqty = dblarr(sz[1],total(dowrite)) 
  newy = dblarr(total(dowrite))
  pos = 0
  for i=0,sz[2]-1 do begin
    if dowrite[i] eq 1 then begin
      newqty[*,pos] = qty[*,i]
      newdqty[*,pos] = dqty[*,i]
      newy[pos] = y[i]
      pos++
    endif
  endfor;i
  qty = newqty
  dqty = newdqty
  y = newy
endif else begin
  void = dialog_message('NO VALID DATA TO WRITE.',title='NO DATA:')
  return,0
endelse 

;MODIFY DAVE OUTPUT TO PLACE ZEROs IN THE FIELDS WHERE
;THE DATA ARE NaN OR Infinity AND SET THE ERROR BARS
;TO INFINITY TO FORCE ZERO WEIGHTING
wh = where(finite(qty) eq 0,whcount)
if whcount gt 0 then qty[wh] = 0.0;double('NaN')
wh = where(finite(dqty) eq 0,whcount)
if whcount gt 0 then dqty[wh] = double('Infinity')

xlabel = 'time'
ylabel = 'Q'
xunits = 's'
yunits = '$\AA^{-1}$'
histlabel = 'I'
histunits = 'arbitrary units'
specificstr = {x:x}
logBuf = (*self.iqtinfo)
ret = create_dave_pointer( $
        daveptr,              $
        instrument = instrument,    $
        qty = qty,            $
        qtunits = histunits,       $
        qtlabel = histlabel,       $
        err = dqty,            $
        xvals = x,          $
        xtype = 'point',          $
        xunits = xunits,         $
        xlabel = xlabel,         $
        yvals = y,          $
        ytype = 'point',          $
        yunits = yunits,         $
        ylabel = ylabel,         $
        specificstr = specificstr,  $
        treatment = logBuf );,   $
        ;dname = dname,          $
        ;dunits = dunits,         $
        ; dlegend = dlegend,       $
        ;dqty = dqty,          $
        ;derr = derr,          $
        ;ermsg = errmsg              )
        ;
if (writeToDisk) then begin
  Save,filename=filename,daveptr
  
  ;; Save treatment history or log to file as well
  logfilename = file_dirname(filename)+path_sep()+File_basename(filename,'.dave',/fold_case)+'.log'
  Openw,lun,logfilename,/get_lun
  Printf,lun,(*self.iqtinfo),format='(A)'
  Free_lun,lun,/force

  msg = ['Reduced I(Q,t) data stored in:',filename,'']
  msg = [msg,'Supplementary treatment details saved in:',logfilename]
  void = Dialog_message(msg,/information,dialog_parent=group_leader)
endif else begin
  if (keyword_set(exportToDAVEDM)) then begin
    ; Send data to DAVE Data Manager Folder
    DAVEtool->Adddaveptrtodatamanager, davePtr, sugg_filename
  endif
  if (keyword_set(fitInPAN)) then begin
    oVoid = Obj_new('OPAN',notifyID=[group_leader,group_leader] $;,group_leader=group_leader $
      ,davePtr=davePtr,workDir=work_Dir,daveTool=DAVEtool)
  endif
  Heap_free, davePtr
endelse

return,1
end;writeDave



;
;NAME:
;        ooEcho::writeComparisonData
;
;PURPOSE:
;           Write data to a file to compare to Igor results.
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;
pro ooEcho::writeComparisonData,_Extra=extra


    case self.type of
    0:  theType = '_noType'
    1:  theType = '_res'
    2:  theType = '_sample'
    3:  theType = '_cell'
    else:thetype = '_noType'
    endcase

    theQ = '_Q'+strtrim(string(self.q),2)


    path = 'C:\Documents and Settings\kneller\My Documents\DAVE_SOURCEFORGE\dave\programs\NSE\'

    tempfn = dialog_pickfile(/write,$
                            file='DefaultFileForDirCapture',$
                            title='I(Q,t) Igor export file: Enter a dummy filename to capture dir name (filenames are defaulted.)',$
                            path=path,$;work_dir,$
                            /overwrite_prompt)

    if path ne '' then begin
        path = file_dirname(tempfn,/mark_directory)


        self.workdir = path

        filename = file_basename(self.filename)+theType+theQ+'.txt'
        filename = path+filename
        print,filename

        openw,lun,filename,/get_lun

    ;print,filename
        signal = (*(self.fitparms))[1,*,*]
        fon = (*(self.Idown))[*,*]
        foff = (*(self.Iup))[*,*]


        format = '(%"%5s%5s%5s%18s%18s%18s")'
        printf,lun,'i','j','k','signal','fon','foff',format=format
        format = '(%"%5d%5d%5d%18.7e%18.7e%18.7e")'

        for k=0,self.no_of_fourier_times-1 do begin
            for i=0,self.x_dim-1 do begin
                for j=0,self.y_dim-1 do begin
                    printf,lun,i,j,k,signal[0,i+j*self.x_dim,k],fon[i+j*self.x_dim,k],foff[i+j*self.x_dim,k]
                endfor;j
            endfor;i
        endfor;k


        free_lun,lun
    endif else begin
        print,'Invalid/no directory selected.'
    endelse


end;writeComparisonData


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   READ AND WRITE STATES
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ooEcho::readState,file=file,lun=lun,totallunlines=totallunlines,_Extra=extra
;
;NAME:
;        ooEcho::readState
;
;PURPOSE:
;               Read an ooEcho object from a state file.
;PARAMETERS:
;               none.
;KEYWORDS:
;               file
;               lun     The file handle to read from.
;RETURN VALUE:
;               1 for success

    ;THIS PROCEDURE WILL READ THE STATE FROM A FILE GIVEN
    ;A LUN.  IT SHOULD BE SET UP TO BE RUN FROM THE init
    ;METHOD SO THAT A CALL LIKE o=obj_new('ooecho',lun=lun,/read)
    ;
;RESTORE
;
;RESTORE SHOULD BE A FUNCTION THAT RETURNS AN ooEcho OBJECT
;TO THE PERSON WHO INVOKED THE ooEcho METHOD.
;
;THE INVOKER WILL NEED TO READ POSSIBLE "<session>" AND "<nobj>"
;LINES IF THEY ARE THERE.


    ;OPEN A STATE FILE
;;;;;    openr,lun,fn,/get_lun

    ;CREATE A BLANK OBJECT

;;;;;    oblank=obj_new('ooecho',/blank)

;FOR NOW ASSUME THE OBJECT WILL BE CREATED AND THEN
;RUN obj->readstate,lun=lun




CATCH, Error_status
   ;HANDLE ERRORS IN READING THE STATE FILE.
   IF (Error_status NE 0) THEN BEGIN
        print,Error_status
        print,!error_state
      free_lun,lun,/force
      print,'15975 ooEcho::readState PROBLEM OCCURRED.'
      print,objtag
      print,proptag
      CATCH, /CANCEL
      return,0
   ENDIF

    if n_elements(totallunlines) eq 0 then totallunlines = 10000000
    tags = self->getproperty(tag='tags')
    s_tags = '<'+self.tags+'>'
    e_tags = '</'+self.tags+'>'

    objtag = ''
    expr = ''
    proptag = ''
    endprop =''
    sqpointer = ''
    qpointer = 0
    type=''
    sizes=''
    start_obj = '<ooecho>' & end_obj = '</ooecho>'


        iec_multimeter = {NSE_METERS_STRUCT,$
            Temperatur:0.0,$
            BSpiy:0.0,$
            BSpi21x:0.0,$
            BSpi21z:0.0,$
            BSpi22y:0.0,$
            BSpix:0.0,$
            BSpiz:0.0,$
            BSpi21y:0.0,$
            BSpi22x:0.0,$
            BSpi22z:0.0 $
            }
        monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}


    readf,lun,objtag
    if stregex(objtag,'xml',/fold_case,/boolean) then $
                readf,lun,objtag
    if stregex(objtag,'<!--',/fold_case,/boolean) then $
                readf,lun,objtag
    if stregex(objtag,'<!--',/fold_case,/boolean) then $
                readf,lun,objtag
    if stregex(objtag,'session',/fold_case,/boolean) then $
                readf,lun,objtag
;if n_elements(lun) ne 0 then begin
;print,'HERE1'
;    help,/files,lun,output=out
;print,'HERE2'
;    segs = strsplit(out[1],/extract)
;print,'HERE3'
;
;    ;totallunlines = file_lines(segs[n_elements(segs)-1])
;print,'HERE4'
;    print,segs[n_elements(segs)-1],totallunlines
;print,'HERE5'
;endif
    readf,lun,expr
    expr = strtrim(expr,2)
    ;print,expr
    while expr ne end_obj do begin
        ;SELECT THE DATA ELEMENT BASED ON THE FIRST TAG.
        ;SET UP TO READ IN ANY ORDER REGARDLESS OF THE
        ;ORDER IN THE tags ARRAY.

        ;GET THE FIRST DATA MEMBER IN THE FILE
        iexpr = where(s_tags eq expr)
        ;print,expr,iexpr
        if iexpr ge 0 then begin
            this_tag = tags[iexpr]
            this_e_tag = e_tags[iexpr]
        endif else begin
            this_tag = expr
            this_e_tag = '</'+strmid(expr,1)
        endelse

        ;DEFINE SOME NEEDED PARAMETERS
        qpointer = 0
        type = 'UNTYPED'
        sz = [0]

        ;READ IN EACH OF THE PROPERTY TAGS UNTIL THE EXPR TAG IS CLOSED.
        readf,lun,proptag
        prop = strtrim(proptag,2)
        ;print,prop
;        while prop ne e_tags[iexpr] do begin
        thelinecount = 0

        while prop ne this_e_tag do begin
            thelinecount = thelinecount + 1
            if thelinecount gt totallunlines then begin
                print,this_e_tag
                return,0
            endif
            ;print,prop,this_e_tag
            if stregex(prop,'pointer',/fold_case,/boolean) then begin
                readf,lun,sqpointer  ;READ VALUE
                readf,lun,endprop   ;READ CLOSING TAG
                ;print,'sqpointer=',sqpointer


                qpointer = fix(sqpointer[0])
            endif;pointer
            if stregex(prop,'dtype',/fold_case,/boolean) then begin
                readf,lun,type
                readf,lun,endprop
                type = strtrim(type,2)
            endif;type
            if stregex(prop,'size',/fold_case,/boolean) then begin
                ;print,'prop=',prop
                readf,lun,sizes
                ;print,'sizes=',sizes
                ;print,sizes
                szsegs = strsplit(sizes,/extract)
                sz = fix(szsegs)
                readf,lun,endprop
            endif;size
            if stregex(prop,'data',/fold_case,/boolean) then begin
                    ;READ THE DATA HERE.
                    if type ne 'POINTER' then begin
                        ;print,this_tag[0],sz,type
                        dat = self->NSE_createtempvar(this_tag[0],sz,type)

                        readf,lun,dat
                        self->NSE_createvar,self,this_tag[0],dat
                        readf,lun,endprop
                    endif
            endif;value
            readf,lun,proptag
            prop = strtrim(proptag,2)
        endwhile;e_tags
;        print,'<'+this_tag
;        print,'    qpointer= ',qpointer
;        print,'    type    = ',type
;        print,'    sz      = ',sz
;        print,'></'+this_tag+'>'


        ;THERE WILL HAVE TO BE <value></value> PAIR
        ;TO CONTAIN THE DATA.  THE FOLLOWING SECTION WILL
        ;NEED TO CREATE A VARIABLE FOR A DIRECT READ OF THE
        ;DATA IN THE <value></value> SECTION.


        ;USE A TEMPORARY VARIABLE TO READ THE DATA AND THEN PASS
        ;TO createvar,obj,tag,sz,data


        ;FINALLY READ THE NEXT PROPERTY START TAG OR END THE DATA OBJECT
        readf,lun,expr
        ;CHECK FOR BLANK LINES
        while strtrim(expr,2) eq '' do begin
            readf,lun,expr
        endwhile

        expr = strtrim(expr,2)
    endwhile;end_of_obj
    ;ONCE THE OBJECT IS CREATED, ADD IT TO THE
    ;ooDisplayEcho DATA CONTAINER.

    ;UPDATE LATER WITH ERROR HANDLING.
    return,1

end;readState
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ooecho::nse_createtempvar,tag,sz,type,_Extra=extra
;
;NAME:
;        ooecho::nse_createtempvar
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;

        ;CREATES THE NEEDED TEMPORARY VARIABLE TO
        ;READ IN THE CURRENT DATA MEMBER FROM THE
        ;SAVED STATE FILE.

        ;DEFINE STRUCTURES
        iec_multimeter = {NSE_METERS_STRUCT,$
            Temperatur:0.0,$
            BSpiy:0.0,$
            BSpi21x:0.0,$
            BSpi21z:0.0,$
            BSpi22y:0.0,$
            BSpix:0.0,$
            BSpiz:0.0,$
            BSpi21y:0.0,$
            BSpi22x:0.0,$
            BSpi22z:0.0 $
            }
        monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}

    ;print,sz
    ;print,type

    case sz[0] of
    0:begin
        case type of
            'POINTER':begin
                tempvar = 0
            end
            'STRING':begin
                tempvar = ''
            end
            'INT':begin
                tempvar = 0
            end
            'DOUBLE':begin
                tempvar = 0.0d
            end
            'FLOAT':begin
                tempvar = 0.0
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar = iec_multimeter
                endif else begin
                    tempvar = monitor_struct
                endelse
            end
            'LONG':begin
                tempvar = 0L
            end
            else:begin
                tempvar = ''    ;READ IN A LINE OF 'DATA'
            end
        endcase
    end        ;0
    1:begin
        case type of
            'POINTER':begin    ;CAN'T HAVE A SAVED PTRARR.
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1])
            end
            'INT':begin
                tempvar = intarr(sz[1])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1])
            end
        endcase
    end        ;1
    2:begin
        case type of
            'POINTER':begin    ;CAN'T HAVE A SAVED POINTER ARRAY
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1],sz[2])
            end
            'INT':begin
                tempvar = intarr(sz[1],sz[2])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1],sz[2])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1],sz[2])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1],sz[2])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1],sz[2])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1],sz[2])
            end
        endcase
    end        ;2
    3:begin
        case type of
            'POINTER':begin
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1],sz[2],sz[3])
            end
            'INT':begin
                tempvar = intarr(sz[1],sz[2],sz[3])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1],sz[2],sz[3])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1],sz[2],sz[3])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1],sz[2],sz[3])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1],sz[2],sz[3])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1],sz[2],sz[3])
            end
        endcase
    end        ;3
    4:begin
        case type of
            'POINTER':begin
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1],sz[2],sz[3],sz[4])
            end
            'INT':begin
                tempvar = intarr(sz[1],sz[2],sz[3],sz[4])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1],sz[2],sz[3],sz[4])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1],sz[2],sz[3],sz[4])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1],sz[2],sz[3],sz[4])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1],sz[2],sz[3],sz[4])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1],sz[2],sz[3],sz[4])
            end
        endcase
    end        ;4
    endcase;sz[0]


    return,tempvar
end;createtempvar
;PROGRAM TO PUT VALUES INTO MEMBER VARIABLES IN AN ECHO OBJECT.

pro ooecho::NSE_createvar,obj,tag,data,_Extra=extra
;
;NAME:
;        ooecho::NSE_createvar
;
;PURPOSE:
;               Populate an obj with data at the selected tag.
;PARAMETERS:
;               obj     The object to operate on.
;               tag     The tag to populate.
;               data    The data to put into variable named tag.
;KEYWORDS:
;               none


    ;SETS THE VALUE OF THE DATA MEMBER FOR THE OBJECT
    ;JUST READ IN.

    case tag of
    'filename':begin
        obj->setproperty,tag,data
    end
    'workdir':begin
        obj->setproperty,tag,data
    end
    'datadir':begin
        obj->setproperty,tag,data
    end
    'type':begin
        obj->setproperty,tag,data
    end
    'reduced':begin
        obj->setproperty,tag,data
    end
    'reducedOld':begin
        obj->setproperty,tag,data
    end
    'e':begin
        ;print,tag
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'emask':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'eorig':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'mask2d':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'mask2dOld':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'fitdisplaymask':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'fitdisplaymaskOld':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'mask1d':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
;;082205
;    'mask1dPixels':begin
;        if ptr_valid(obj->getproperty(tag=tag)) then $
;                    ptr_free,obj->getproperty(tag=tag)
;        obj->setproperty,tag,ptr_new(data)
;    end
;;######
    'lambda':begin
        obj->setproperty,tag,data
    end
    'dlambda':begin
        obj->setproperty,tag,data
    end
    'comment':begin
        obj->setproperty,tag,data
    end
    'fixed':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'fitparms':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'fitparmsOld':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'chisq':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'chisqOld':begin
        ;print,'nse_createvar   line 88'
        ;help,data
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'Iup':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'Idown':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sIup':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sIdown':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'IupdownSwitch':begin
        obj->setproperty,tag,data
    end
    'S':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sS':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'IQTInfo':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'treatment':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'IQTFitparms':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end

    'IQT':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sIQT':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'QVals':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'QValsSwitch':begin
        obj->setproperty,tag,data
    end
    'narcs':begin
        obj->setproperty,tag,data
    end
    'qarcs':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'phase':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'currentPhaseIndex':begin
        obj->setproperty,tag,data
    end
    'meters':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'counters':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'monitors':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'preset':begin
        obj->setproperty,tag,data
    end
    'no_of_phases':begin
        obj->setproperty,tag,data
    end
    'point_to_down':begin
        obj->setproperty,tag,data
    end
    'point_to_up':begin
        obj->setproperty,tag,data
    end
    'phase_step':begin
        obj->setproperty,tag,data
    end
    'no_of_fourier_times':begin
        obj->setproperty,tag,data
    end
    'no_of_pixels':begin
        obj->setproperty,tag,data
    end
    'beam_cen_x':begin
        obj->setproperty,tag,data
    end
    'beam_cen_y':begin
        obj->setproperty,tag,data
    end
    'transmission':begin
        obj->setproperty,tag,data
    end
    'volfrac':begin
        obj->setproperty,tag,data
    end
    'x_dim':begin
        obj->setproperty,tag,data
    end
    'y_dim':begin
        obj->setproperty,tag,data
    end
    'x_cen':begin
        obj->setproperty,tag,data
    end
    'y_cen':begin
        obj->setproperty,tag,data
    end
    'x_dim_orig':begin
        obj->setproperty,tag,data
    end
    'y_dim_orig':begin
        obj->setproperty,tag,data
    end
    'x_cen_orig':begin
        obj->setproperty,tag,data
    end
    'y_cen_orig':begin
        obj->setproperty,tag,data
    end
    'width':begin
        obj->setproperty,tag,data
    end
    'period':begin
        obj->setproperty,tag,data
    end
    'colorTable':begin
        obj->setproperty,tag,data
    end
    'q':begin
        obj->setproperty,tag,data
    end
    'qactual':begin
        obj->setproperty,tag,data
    end
    'qy':begin
        obj->setproperty,tag,data
    end
    'fourierTime':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'currentFourierTimeIndex':begin
        obj->setproperty,tag,data
    end
    'scanHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sampleHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'techHeader':begin
            if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'physicsHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'physicsParametersHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'phaseHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'tags':begin
        obj->setproperty,tag,data
    end
    else:begin
        print,'10965 ooecho::NSE_createvar:  tag = '+tag+' is unknown.'
    end
    endcase

end;NSE_createvar

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ooEcho::writeState,file=file,lun=lun,_Extra=extra
;
;NAME:
;        ooEcho::writeState
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;

    ;WRITE THE DATA MEMBERS TO A FILE GIVEN BY lun
    ;
    ;UPDATE LATER TO DEAL WITH THE FILE KEYWORD.


    printf,lun,'<ooecho>'
    tags = self.tags
    for i=0,n_elements(tags)-1 do begin

        tag_start = '<'+tags[i]+'>'
        tag_end =  '</'+tags[i]+'>'
;        print,'  '+tag_start
        printf,lun,'  '+tag_start
        help,self->getproperty(tag=tags[i]),output=out,struct=0

        segs = strsplit(out,/extract)

        if stregex(out,'POINTER',/fold_case,/boolean) then begin
;            print,'    <pointer>'
;            print,1
;            print,'    </pointer>'
            printf,lun,'    <pointer>'
            printf,lun,'    ',1
            printf,lun,'    </pointer>'

            if stregex(out,'NULL',/fold_case,/boolean) then begin
                sz = size((self->getproperty(tag=tags[i])))
                ;sz = [0]
                the_type = 'POINTER'
                ouputdata=0
            endif else begin
;                print,tags[i]
;                help,(self->getproperty(tag=tags[i]))


                ;COULD ALSO USE THE COMMAND type=size(*ptr,/tname)
                help,*(self->getproperty(tag=tags[i])),output=pout,struct=0
                if n_elements(pout) gt 1 then begin ;THIS HAPPENS FOR STRUCTS
                    spout = pout[0]+' '+pout[1]
                endif else begin
                    spout = pout
                endelse

;NOTE THAT THE tag 'type' REFERRING TO THE
;TYPE OF DATA FILE MAY BE CONFUSED WITH THE
;DATA 'type' OF A GIVEN VARIABLE.

                psegs = strsplit(spout,/extract)
                the_type = psegs[1]
                type = psegs[1]
                sz = size(*(self->getproperty(tag=tags[i])))
                if stregex(psegs[1],'STRUCT',/fold_case,/boolean) then begin
                    ;WRITE STRUCTURES WITHOUT BRACKETS.
                    nsel = sz[n_elements(sz)-1]-1
                    outputdata = ''
                    for sii = 0,nsel do begin
                        for sjj = 0,n_elements(tag_names((*(self->getproperty(tag=tags[i])))))-1 do begin
                        outputdata = outputdata + ' ' + $
                            string((*(self->getproperty(tag=tags[i])))[sii].(sjj))
                        endfor;sjj
                    endfor;sii

                endif else begin
                    if stregex(psegs[1],'STRING',/fold_case,/boolean) then begin
                        ;TREAT POINTERS TO STRING ARRAYS SPECIALLY
                        sarr = (*(self->getproperty(tag=tags[i])))
                        sarrsz = size(sarr)
                        if sarrsz[0] ne 0 then begin
                            ;if tags[i] eq 'IQTInfo' then print,transpose(sarr)
                            sarr = (reform(sarr,(size(sarr))[n_elements(size(sarr))-1]))
                            outputdata = $
                                transpose(reform(sarr,sarrsz[n_elements(sarrsz)-1]))
                        endif else begin
                            outputdata = transpose(strarr(2));sarr
                        endelse

                    endif else begin
                        outputdata = (*(self->getproperty(tag=tags[i])))
                    endelse

                endelse

            endelse
            ;print,tags[i]+' '+type,sz
            ;print the values
        endif else begin
            the_type = segs[1]
            sz = size((self->getproperty(tag=tags[i])))
            ;print,tags[i],' '+segs[1]+' '+segs[3]
            if stregex(out,'STRING',/fold_case,/boolean) and $
                stregex(out,'ARRAY',/fold_case,/boolean) then begin
                ;TREAT STRING ARRAYS SPECIALLY.
                        sarr = self->getproperty(tag=tags[i])
                        sarrsz = size(sarr)
                        if sarrsz[0] ne 0 then begin
                            sarr = (reform(sarr,(size(sarr))[n_elements(size(sarr))-1]))
                            outputdata = $
                                transpose(reform(sarr,sarrsz[n_elements(sarrsz)-1]))
                        endif else begin
                            outputdata = sarr
                        endelse

            endif else begin
                    outputdata = (self->getproperty(tag=tags[i]))
            endelse

        endelse
;        print,'    <dtype>'
;        print,'    '+the_type
;        print,'    </dtype>
;        print,'    <size>'
;        print,'    ',sz
;        print,'    </size>'
;        print,'    <data>'
;        print,'    </data>'

        printf,lun,'    <dtype>'    ;dtype may still be a problem due to
        printf,lun,'    '+the_type  ;stregex()ing the tags.
        printf,lun,'    </dtype>
        printf,lun,'    <size>'
        printf,lun,'    ',sz
        printf,lun,'    </size>'

;        print,'    <data>'

        printf,lun,'    <data>'
        printf,lun,outputdata
        printf,lun,'    </data>'
;        print,'    </data>'
;
;        print,'  '+tag_end
        printf,lun,'  '+tag_end
    endfor;i

;    print,'</ooecho>'
    printf,lun,'</ooecho>'
;    free_lun,lun,/force


    ;SHOULD RUN SOME ERROR HANDLING
    return,1
end;writeState
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEcho::cloneSet,obj,tremove=tremove,_Extra=extra;RemoveT,obj,tremove=tremove
;
;NAME:
;        ooEcho::cloneSet
;
;PURPOSE:
;           Populate a cloned object, and do it with a Fourier time removed
;           if desired.
;PARAMETERS:
;           obj     The object to clone.
;KEYWORDS:
;           tremove The Fourier time to remove.


    ;011205
    ;
    ;SET VALUES IN CLONE OF obj CREATED IN ooEcho::init(obj=ref)
    ;
    ;
    ;ARGUMENTS:
    ;
    ;   obj - THE OBJECT TO BE CLONED
    ;
    ;
    ;KEYWORDS
    ;
    ;   tremove -   THE FOURIER TIME TO BE REMOVED. IF IT IS AVAILABLE IN obj.
    ;               WHEN THE tremove KEYWORD IS PRESENT, THE CLONE IS DEFINED WITH
    ;               THE FOURIER TIME REMOVED, IF IT MATCHES ONE OF THE FOURIER TIMES
    ;               IN obj.
    ;


    self.filename = obj->getProperty(tag='filename')
    self.workdir = obj->getProperty(tag='workdir')
    self.datadir = obj->getProperty(tag='datadir')


;011205
;
;DON'T LET NUMBER OF FOURIER TIMES DROP BELOW 2!!!!!
;ooDisplayEcho CANNOT CURRENTLY HANDLE THAT.
;ALSO ooDisplayEcho IS HAVING A PROBLEM SELECTING THE CORRECT
;SET OF FOURIER TIMES.
;
;
;ALSO, LOOK FOR THE COMMENTS BELOW: "WHY ISN'T THIS BINNED?"



    ;NOW SELECT REMOVAL index FOR t:
    if n_elements(tremove) ne 0 then begin


;        print,'ooecho::cloneset   tremove=',tremove
        fourierTimes = *(obj->getProperty(tag='fourierTime'))
;        print,'ooecho::cloneset   fourierTime=',fourierTimes

;        aindex = where(*(obj->getProperty(tag='fourierTime')) eq tremove)
;print,abs(fourierTimes-tremove)/tremove

        if tremove ne 0.0 then begin

            ;081406
            ;TIGHTEN TOLERANCE IN CASE OF MULTIPLE SELECTIONS.
            ;IF THIS TOLERANCE IS NOT ADEQUATE, SIMPLY TAKE FIRST
            ;INDEX.
            aindex = where(abs(fourierTimes-tremove)/tremove lt 0.001)
            if n_elements(aindex) gt 1 then begin
                aindex = where(abs(fourierTimes-tremove)/tremove lt 0.0001)
                if n_elements(aindex) gt 1 then begin
                    aindex = where(abs(fourierTimes-tremove)/tremove lt 0.00001)
                endif
            endif
        endif else begin
            aindex = where(fourierTimes eq tremove)
        endelse

;print,aindex
        ntimes = n_elements(*(obj->getProperty(tag='fourierTime')))
        if ntimes le 2 then aindex[0] = -2

        index = aindex[0]
        if index eq -1 then begin
            dum = dialog_message('Invalid Fourier time selected for removal.'+ $
                                     string(13b)+" ooEcho::cloneSetRemoveT")
            remove = 0
        endif else begin
            if index eq -2 then begin
                dum = dialog_message("Currently can't support less than 2 Fourier times." + $
                                     string(13b)+" ooEcho::cloneSetRemoveT")
                remove = 0
            endif else begin
;                print,'REMOVAL INDEX = ',index
                remove = 1
            endelse

        endelse
    endif else begin
        remove = 0
    endelse




    ;ITEMS UNCHANGED BY t REMOVAL
    self.type = obj->getProperty(tag='type')
    self.reduced = obj->getProperty(tag='reduced')
    self.reducedOld = obj->getProperty(tag='reducedOld')
    self.lambda = obj->getProperty(tag='lambda')
    self.dlambda = obj->getProperty(tag='dlambda')
    narcs = obj->getProperty(tag='narcs')
    if narcs lt 1 then narcs = 1
    if narcs gt 16 then narcs = 16
    self.narcs = narcs
    self.QValsSwitch = obj->getProperty(tag='QValsSwitch')
    self.IupdownSwitch = obj->getProperty(tag='IupdownSwitch')
    self.currentPhaseIndex = obj->getProperty(tag='currentPhaseIndex')
    self.preset = (obj->getProperty(tag='preset'))
    self.no_of_phases = obj->getProperty(tag='no_of_phases')
    self.point_to_down = obj->getProperty(tag='point_to_down')
    self.point_to_up = obj->getProperty(tag='point_to_up')
    self.phase_step = obj->getProperty(tag='phase_step')
    self.no_of_pixels = obj->getProperty(tag='no_of_pixels')
    self.transmission = obj->getProperty(tag='transmission')
    self.volfrac = obj->getProperty(tag='volfrac')
    self.x_dim = obj->getProperty(tag='x_dim')
    self.y_dim = obj->getProperty(tag='y_dim')
    self.x_dim_orig = obj->getProperty(tag='x_dim_orig')
    self.y_dim_orig = obj->getProperty(tag='y_dim_orig')
    self.x_cen = obj->getProperty(tag='x_cen')
    self.y_cen = obj->getProperty(tag='y_cen')
    self.x_cen_orig = obj->getProperty(tag='x_cen_orig')
    self.y_cen_orig = obj->getProperty(tag='y_cen_orig')
    self.colorTable = obj->getProperty(tag='colorTable')
    self.width = obj->getProperty(tag='width')
    self.period = obj->getProperty(tag='period')
    self.q = obj->getProperty(tag='q')
    self.qactual = obj->getProperty(tag='qactual')
    self.qy = obj->getProperty(tag='qy')

;110305
;DO I REALLY NEED TO SET TAGS HERE??? CHECK init --- DON'T NEED IT, BUT LEAVE IT FOR nonMAGNETIC CASE.

    if n_elements(self.tags) eq n_elements(obj->getProperty(tag='tags')) then begin
            self.tags = obj->getProperty(tag='tags')
    endif ;else begin
;            if n_elements(self.tags) eq n_elements(obj->ooEcho::getProperty(tag='tags'))
;    endelse

    ;THE IQTInfo POINTER WILL NOT CHANGE WITH THE NUMBER OF FOURIER TIMES.
    IQTInfotemp = *(obj->getProperty(tag='IQTInfo'))
        if ptr_valid(self.IQTInfo) gt 0 then ptr_free,self.IQTInfo
        self.IQTInfo = ptr_new(IQTInfotemp)


    treatmentTemp = *(obj->getProperty(tag='treatment'));['ooEcho::cloneSet tremove='+string(tremove)];
        if ptr_valid(self.treatment) gt 0 then ptr_free,self.treatment
        self.treatment = ptr_new(treatmentTemp)



    ;011205
    ;THE SIZE OF THE SCAN HEADER IS RELATED TO THE NUMBER OF PHASES FOR SOME REASON.
    ;WHY IS THAT?????
    scanHeadertemp = *(obj->getProperty(tag='scanHeader'))
        if ptr_valid(self.scanHeader) gt 0 then ptr_free,self.scanHeader
        self.scanHeader = ptr_new(scanHeaderTemp)

    sampleHeadertemp = *(obj->getProperty(tag='sampleHeader'))
        if ptr_valid(self.sampleHeader) gt 0 then ptr_free,self.sampleHeader
        self.sampleHeader = ptr_new(sampleHeadertemp)




    ;ITEMS CHANGED BY t REMOVAL
    if remove eq 0 then begin
        ;NO REMOVAL, REGULAR cloneSet
        self.comment = obj->getProperty(tag='comment')

        self.no_of_fourier_times = obj->getProperty(tag='no_of_fourier_times')
        self.currentFourierTimeIndex = $
                    obj->getProperty(tag='currentFourierTimeIndex')




        etemp = *(obj->getProperty(tag='e'))
        if ptr_valid(self.e) gt 0 then ptr_free,self.e
        self.e = ptr_new(etemp)
        emasktemp = *(obj->getProperty(tag='emask'))
        if ptr_valid(self.emask) gt 0 then ptr_free,self.emask
        self.emask = ptr_new(emasktemp)
        eorigtemp = *(obj->getProperty(tag='eorig'))
        if ptr_valid(self.eorig) gt 0 then ptr_free,self.eorig
        self.eorig = ptr_new(eorigtemp)
        mask2dtemp = *(obj->getProperty(tag='mask2d'))
        if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
        self.mask2d = ptr_new(mask2dtemp)
        mask2dtempOld = *(obj->getProperty(tag='mask2dOld'))
        if ptr_valid(self.mask2dOld) gt 0 then ptr_free,self.mask2dOld
        self.mask2dOld = ptr_new(mask2dtempOld)
        fitdisplaymasktemp = *(obj->getProperty(tag='fitdisplaymask'))
        if ptr_valid(self.fitdisplaymask) gt 0 then ptr_free,self.fitdisplaymask
        self.fitdisplaymask = ptr_new(fitdisplaymasktemp)
        fitdisplaymasktempOld = *(obj->getProperty(tag='fitdisplaymaskOld'))
        if ptr_valid(self.fitdisplaymaskOld) gt 0 then ptr_free,self.fitdisplaymaskOld
        self.fitdisplaymaskOld = ptr_new(fitdisplaymasktempOld)
        mask1dtemp = *(obj->getProperty(tag='mask1d'))
        if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
        self.mask1d = ptr_new(mask1dtemp)


;;082205
;        ;CHECK THAT THE OBJECT HAS THE NEW MASK, IF NOT
;        ;THE OBJECT IS FROM AN OLD RESTORED FILE AND THIS
;        ;STEP MUST BE SET UP WITH A DUMMY MASK BASED ON THE
;        ;mask1d.
;        tags = (obj->getProperty(tag='tags'))
;        wtags = where(tags eq 'mask1dPixels')
;        if wtags[0] ne -1 then begin
;            mask1dpixelstemp = *(obj->getProperty(tag='mask1dPixels'))
;            if ptr_valid(self.mask1dpixels) gt 0 then ptr_free,self.mask1dpixels
;            self.mask1d = ptr_new(mask1dpixelstemp)
;        endif else begin
;            mask1dpixelstemp = intarr(self.x_dim*self.y_dim,self.no_of_phases,self.no_of_fourier_times)
;            for ii=0,self.x_dim*self.y_dim-1 do begin
;                mask1dpixelstemp[ii,*,*] = mask1dtemp
;            endfor;ii
;            if ptr_valid(self.mask1dpixels) gt 0 then ptr_free,self.mask1dpixels
;            self.mask1dpixels = ptr_new(mask1dpixelstemp)
;        endelse
;;##########

        fixedtemp = *(obj->getProperty(tag='fixed'))
        if ptr_valid(self.fixed) gt 0 then ptr_free,self.fixed
        self.fixed = ptr_new(fixedtemp)
        fitparmstemp = *(obj->getProperty(tag='fitparms'))
        if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        self.fitparms = ptr_new(fitparmstemp)
        fitparmstempOld = *(obj->getProperty(tag='fitparmsOld'))
        if ptr_valid(self.fitparmsOld) gt 0 then ptr_free,self.fitparmsOld
        self.fitparmsOld = ptr_new(fitparmstempOld)
        Iuptemp = *(obj->getProperty(tag='Iup'))
        if ptr_valid(self.Iup) gt 0 then ptr_free,self.Iup
        self.Iup = ptr_new(Iuptemp)
        Idowntemp = *(obj->getProperty(tag='Idown'))
        if ptr_valid(self.Idown) gt 0 then ptr_free,self.Idown
        self.Idown = ptr_new(Idowntemp)
        sIuptemp = *(obj->getProperty(tag='sIup'))
        if ptr_valid(self.sIup) gt 0 then ptr_free,self.sIup
        self.sIup = ptr_new(sIuptemp)
        sIdowntemp = *(obj->getProperty(tag='sIdown'))
        if ptr_valid(self.sIdown) gt 0 then ptr_free,self.sIdown
        self.sIdown = ptr_new(sIdowntemp)
        Stemp = *(obj->getProperty(tag='S'))
        if ptr_valid(self.S) gt 0 then ptr_free,self.S
        self.S = ptr_new(Stemp)
        sStemp = *(obj->getProperty(tag='sS'))
        if ptr_valid(self.sS) gt 0 then ptr_free,self.sS
        self.sS = ptr_new(sStemp)
        IQTInfotemp = *(obj->getProperty(tag='IQTInfo'))
        if ptr_valid(self.IQTInfo) gt 0 then ptr_free,self.IQTInfo
        self.IQTInfo = ptr_new(IQTInfotemp)
        IQTtemp = *(obj->getProperty(tag='IQT'))
        if ptr_valid(self.IQT) gt 0 then ptr_free,self.IQT
        self.IQT = ptr_new(IQTtemp)
        sIQTtemp = *(obj->getProperty(tag='sIQT'))
        if ptr_valid(self.sIQT) gt 0 then ptr_free,self.sIQT
        self.sIQT = ptr_new(sIQTtemp)

        IQTFitparmstemp = *(obj->getProperty(tag='IQTFitparms'))
        if ptr_valid(self.IQTFitparms) gt 0 then ptr_free,self.IQTFitparms
        self.IQTFitparms = ptr_new(IQTFitparmstemp)

        qarcstemp = *(obj->getProperty(tag='qarcs'))
        if ptr_valid(self.qarcs) gt 0 then ptr_free,self.qarcs
        self.qarcs = ptr_new(qarcstemp)
        QValstemp = *(obj->getProperty(tag='QVals'))
        if ptr_valid(self.QVals) gt 0 then ptr_free,self.QVals
        self.QVals = ptr_new(QValstemp)
        ;HOW DOES self.chisq BECOME DEREFERENCED?!?
        chisqtemp = *(obj->getProperty(tag='chisq'))
        ;chisqtemp = (*self.chisq)
        if ptr_valid(self.chisq) gt 0 then ptr_free,self.chisq
        self.chisq = ptr_new(chisqtemp)
        chisqtempOld = *(obj->getProperty(tag='chisqOld'))
        if ptr_valid(self.chisqOld) gt 0 then ptr_free,self.chisqOld
        self.chisqOld = ptr_new(chisqtempOld)
        phasetemp = *(obj->getProperty(tag='phase'))
        if ptr_valid(self.phase) gt 0 then ptr_free,self.phase
        self.phase = ptr_new(phasetemp)
        meterstemp = *(obj->getProperty(tag='meters'))
        if ptr_valid(self.meters) gt 0 then ptr_free,self.meters
        self.meters = ptr_new(meterstemp)
        counterstemp = *(obj->getProperty(tag='counters'))
        if ptr_valid(self.counters) gt 0 then ptr_free,self.counters
        self.counters = ptr_new(counterstemp)
        monitorstemp = *(obj->getProperty(tag='monitors'))
        if ptr_valid(self.monitors) gt 0 then ptr_free,self.monitors
        self.monitors = ptr_new(monitorstemp)
        fourierTimetemp = *(obj->getProperty(tag='fourierTime'))
        if ptr_valid(self.fourierTime) gt 0 then ptr_free,self.fourierTime
        self.fourierTime = ptr_new(fourierTimetemp)
        sampleHeadertemp = *(obj->getProperty(tag='sampleHeader'))
        if ptr_valid(self.sampleHeader) gt 0 then ptr_free,self.sampleHeader
        self.sampleHeader = ptr_new(sampleHeadertemp)
        techHeadertemp = *(obj->getProperty(tag='techHeader'))
        if ptr_valid(self.techHeader) gt 0 then ptr_free,self.techHeader
        self.techHeader = ptr_new(techHeadertemp)
        physicsHeadertemp = *(obj->getProperty(tag='physicsHeader'))
        if ptr_valid(self.physicsHeader) gt 0 then ptr_free,self.physicsHeader
        self.physicsHeader = ptr_new(physicsHeadertemp)
        physicsParametersHeadertemp = *(obj->getProperty(tag='physicsParametersHeader'))
        if ptr_valid(self.physicsParametersHeader) gt 0 then ptr_free,self.physicsParametersHeader
        self.physicsParametersHeader = ptr_new(physicsParametersHeadertemp)
        phaseHeadertemp = *(obj->getProperty(tag='phaseHeader'))
        if ptr_valid(self.phaseHeader) gt 0 then ptr_free,self.phaseHeader
        self.phaseHeader = ptr_new(phaseHeadertemp)


    endif else begin

        ;NOW REMOVE EVERYTHING WHERE THE FOURIER TIME IS
        ;AT THE SELECTED INDEX.
;        self.comment = obj->getProperty(tag='comment') + $
;                        ' Removed t = ' + $
;                        strtrim(string(tremove*(10.0^9)),2) + ' ns. '
;121905
;ADDING A FORMAT TO THE FOLLOWING COMMAND TO MINIMIZE THE ADDED TEXT
        self.comment = obj->getProperty(tag='comment') + $
                        ' Removed t = ' + $
                        strtrim(string(tremove*(10.0^9),format='(f3.1)'),2) + ' ns. '


        nftorig = obj->getProperty(tag='no_of_fourier_times')
        self.no_of_fourier_times = nftorig - 1
        self.currentFourierTimeIndex = 0


        bin = self.x_dim_orig/self.x_dim
        linbinned = (self.x_dim_orig*self.y_dim_orig)/(bin*bin)         ;SET ABOVE
        linnobin  = self.no_of_pixels                                   ;SET ABOVE
        nphs = self.no_of_phases                                        ;SET ABOVE
        nft = self.no_of_fourier_times                                  ;SET ABOVE




        ;CREATE POINTERS TO THE NEW-SIZED ARRAYS
        if ptr_valid(self.e) gt 0 then ptr_free,self.e
        self.e = ptr_new(lonarr(linbinned, nphs, nft))

        if ptr_valid(self.emask) gt 0 then ptr_free,self.emask
        self.emask = ptr_new(lonarr(linbinned, nphs, nft))

        if ptr_valid(self.eorig) gt 0 then ptr_free,self.eorig
        self.eorig = ptr_new(lonarr(linnobin, nphs, nft))

        if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
        self.mask2d = ptr_new(intarr(linbinned,nft))

        if ptr_valid(self.fitdisplaymask) gt 0 then ptr_free,self.fitdisplaymask
        self.fitdisplaymask = ptr_new(intarr(linbinned,nft))




        ;GET SIZE OF SAVED PARAMETER IN CASE THE BINNING HAS CHANGED SINCE
        ;THE LAST SAVE.
        mask2dtempOld = *(obj->getProperty(tag='mask2dOld'))
        sz = size(mask2dtempOld)
        if ptr_valid(self.mask2dOld) gt 0 then ptr_free,self.mask2dOld
        self.mask2dOld = ptr_new(intarr(sz[1],nft))

        fitdisplaymaskTempOld = *(obj->getProperty(tag='fitdisplaymaskOld'))
        sz = size(fitdisplaymaskTempOld)
        if ptr_valid(self.fitdisplaymaskOld) gt 0 then ptr_free,self.fitdisplaymaskOld
        self.fitdisplaymaskOld = ptr_new(intarr(sz[1],nft))

        if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
        self.mask1d = ptr_new(intarr(nphs,nft))


;;082205
;        if ptr_valid(self.mask1dPixels) gt 0 then ptr_free,self.mask1dPixels
;        self.mask1dPixels = ptr_new(intarr(sz[1],nphs,nft))



        if ptr_valid(self.fixed) gt 0 then ptr_free,self.fixed
        self.fixed = ptr_new(intarr(6,linbinned,nft))

        if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        self.fitparms = ptr_new(dblarr(12,linbinned,nft))

        fitparmsTempOld =  *(obj->getProperty(tag='fitparmsOld'))
        sz = size(fitparmsTempOld)
        if ptr_valid(self.fitparmsOld) gt 0 then ptr_free,self.fitparmsOld
        self.fitparmsOld = ptr_new(dblarr(12,sz[2],nft))
        ;self.fitparmsOld = ptr_new(dblarr(12,linbinned,nft))

        if ptr_valid(self.chisq) gt 0 then ptr_free,self.chisq
        self.chisq = ptr_new(dblarr(linbinned,nft))


        chisqOld =  *(obj->getProperty(tag='chisqOld'))
        sz = size(chisqOld)
        if ptr_valid(self.chisqOld) gt 0 then ptr_free,self.chisqOld
        self.chisqOld = ptr_new(dblarr(sz[1],nft))
        ;self.chisqOld = ptr_new(dblarr(linbinned,nft))

        if ptr_valid(self.Iup) gt 0 then ptr_free, self.Iup
        self.Iup = ptr_new(dblarr(linbinned,nft))

        if ptr_valid(self.Idown) gt 0 then ptr_free, self.Idown
        self.Idown = ptr_new(dblarr(linbinned,nft))

        sIuptemp = *(obj->getProperty(tag='sIup'))
        sz = size(sIuptemp)
        if ptr_valid(self.sIup) gt 0 then ptr_free, self.sIup
        self.sIup = ptr_new(dblarr(sz[1],nft))

        sIdowntemp = *(obj->getProperty(tag='sIdown'))
        sz = size(sIuptemp)
        if ptr_valid(self.sIdown) gt 0 then ptr_free, self.sIdown
        self.sIdown = ptr_new(dblarr(sz[1],nft))


        stemp = *(obj->getProperty(tag='S'))
        sz = size(stemp)
        if ptr_valid(self.S) gt 0 then ptr_free, self.S
        self.S = ptr_new(dblarr(sz[1],nft))

        sstemp = *(obj->getProperty(tag='sS'))
        sz = size(sstemp)
        if ptr_valid(self.sS) gt 0 then ptr_free, self.sS
        self.sS = ptr_new(dblarr(sz[1],nft))

        if ptr_valid(self.IQT) gt 0 then ptr_free,self.IQT
        self.IQT = ptr_new(dblarr(self.narcs,nft))

        if ptr_valid(self.sIQT) gt 0 then ptr_free,self.sIQT
        self.sIQT = ptr_new(dblarr(self.narcs,nft))

        if ptr_valid(self.QVals) gt 0 then ptr_free,self.QVals
        self.QVals = ptr_new(dblarr(linbinned,nft))

        if ptr_valid(self.qarcs) gt 0 then ptr_free,self.qarcs
        self.qarcs = ptr_new(dblarr(self.narcs))

        if ptr_valid(self.phase) gt 0 then ptr_free,self.phase
        self.phase = ptr_new(fltarr(nphs,nft))

        iec_multimeter = {$
            Temperatur:0.0,$
            BSpiy:0.0,$
            BSpi21x:0.0,$
            BSpi21z:0.0,$
            BSpi22y:0.0,$
            BSpix:0.0,$
            BSpiz:0.0,$
            BSpi21y:0.0,$
            BSpi22x:0.0,$
            BSpi22z:0.0 $
            }
        meters=replicate(iec_multimeter,nphs,nft)
        if ptr_valid(self.meters) gt 0 then ptr_free,self.meters
        self.meters = ptr_new(meters)

        if ptr_valid(self.counters) gt 0 then ptr_free,self.counters
        self.counters = ptr_new(dblarr(10,nphs,nft))


        monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}
        monitors=replicate(monitor_struct,nft)
        if ptr_valid(self.monitors) gt 0 then ptr_free,self.monitors
        self.monitors = ptr_new(monitors)


        self.fourierTime = ptr_new(fltarr(nft))

        self.sampleHeader = ptr_new(strarr(17))
        self.techHeader = ptr_new(strarr(54,nft))
        self.physicsHeader = ptr_new(strarr(16,nft))

;070605
;NEED TO ALLOW FOR POSSIBLE EXTRA LINES DUE TO TEMPERATURE PROBE
        physicsParametersHeadertemp = *(obj->getProperty(tag='physicsParametersHeader'))
        szppht = size(physicsParametersHeadertemp)
        self.physicsParametersHeader = ptr_new(strarr(szppht[1],nft))
;        self.physicsParametersHeader = ptr_new(strarr(44,nft))

        self.phaseHeader = ptr_new(strarr(4,nphs,nft))




        ;ASSIGN THE VALUES TO THE ARRAYS AT THE POINTERS.
        etemp = *(obj->getProperty(tag='e'))
        ;help,etemp
        ;help,*self.e
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.e))[*,*,j] = etemp[*,*,i]
                j++
            endif
        endfor;i



        emasktemp = *(obj->getProperty(tag='emask'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.emask))[*,*,j] = emasktemp[*,*,i]
                j++
            endif
        endfor;i


        eorigtemp = *(obj->getProperty(tag='eorig'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.eorig))[*,*,j] = eorigtemp[*,*,i]
                j++
            endif
        endfor;i



        mask2dtemp = *(obj->getProperty(tag='mask2d'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.mask2d))[*,j] = mask2dtemp[*,i]
                j++
            endif
        endfor;i


        mask2dtempOld = *(obj->getProperty(tag='mask2dOld'))
        ;help,mask2dtempOld
        ;help,*self.mask2dOld
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.mask2dOld))[*,j] = mask2dtempOld[*,i]
                j++
            endif
        endfor;i


        fitdisplaymasktemp = *(obj->getProperty(tag='fitdisplaymask'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitDisplayMask))[*,j] = fitDisplayMasktemp[*,i]
                j++
            endif
        endfor;i

        fitdisplaymasktempOld = *(obj->getProperty(tag='fitdisplaymaskOld'))
        ;help,fitdisplaymasktempOld
        ;help,*self.fitdisplaymask
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitDisplayMaskOld))[*,j] = fitDisplayMasktempOld[*,i]
                j++
            endif
        endfor;i


        mask1dtemp = *(obj->getProperty(tag='mask1d'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.mask1d))[*,j] = mask1dtemp[*,i]
                j++
            endif
        endfor;i

;;082205
;        mask1dpixelstemp = *(obj->getProperty(tag='mask1dPixels'))
;        j=0
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
;                (*(self.mask1dPixels))[*,*,j] = mask1dpixelstemp[*,*,i]
;                j++
;            endif
;        endfor;i
;;########

        fixedtemp = *(obj->getProperty(tag='fixed'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fixed))[*,*,j] = fixedtemp[*,*,i]
                j++
            endif
        endfor;i


        fitparmstemp = *(obj->getProperty(tag='fitparms'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitparms))[*,*,j] = fitparmstemp[*,*,i]
                j++
            endif
        endfor;i


        fitparmstempOld = *(obj->getProperty(tag='fitparmsOld'))
        ;help,fitparmstempOld
        ;help,*(self.fitparmsOld)
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitparmsOld))[*,*,j] = fitparmstempOld[*,*,i]
                j++
            endif
        endfor;i


        Iuptemp = *(obj->getProperty(tag='Iup'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.Iup))[*,j] = Iuptemp[*,i]
                j++
            endif
        endfor;i


        Idowntemp = *(obj->getProperty(tag='Idown'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.Idown))[*,j] = Idowntemp[*,i]
                j++
            endif
        endfor;i


        ;WHY ISN'T THIS BINNED????? ---- IT APPEARS TO BE BINNED NOW (011805).
        sIuptemp = *(obj->getProperty(tag='sIup'))
        ;help,sIuptemp
        ;help,*self.sIup
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.sIup))[*,j] = sIuptemp[*,i]
                j++
            endif
        endfor;i



        sIdowntemp = *(obj->getProperty(tag='sIdown'))
        ;help,sIuptemp
        ;help,*self.sIup
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.sIdown))[*,j] = sIdowntemp[*,i]
                j++
            endif
        endfor;i





;011405
;PROGRAM CRASHES HERE WHEN FOURIER TIME REMOVED FROM MERGED FILES!
;
;S MUST BE HANDLED INCORRRECTLY IN THE MERGE!!!

;GO TO LINE 10410 ;AND FIX INTERLEAVING OF S AND FOLLOWING DATA MEMBERS!!!!



        stemp = *(obj->getProperty(tag='S'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.S))[*,j] = stemp[*,i]
                j++
            endif
        endfor;i


        sstemp = *(obj->getProperty(tag='sS'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.sS))[*,j] = sstemp[*,i]
                j++
            endif
        endfor;i


        iqttemp = *(obj->getProperty(tag='IQT'))

        j=0
        if ptr_valid(self.IQT) ne 0 then ptr_free,self.IQT
        newIQT = iqttemp[*,1:*]
        self.IQT = ptr_new(newIQT)
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
;;042105
;;PROGRAM CRASHED HERE BECAUSE I(Q,t) WAS THE WRONG SIZE.
;;FIX THIS BY ELIMINATING THIS LOOP.  I(Q,t) IS CALCULATED AS NEEDED.
;                (*(self.IQT))[*,j] = iqttemp[*,i]
;                j++
;            endif
;        endfor;i


        siqttemp = *(obj->getProperty(tag='sIQT'))
        j=0
        if ptr_valid(self.sIQT) ne 0 then ptr_free,self.sIQT
        newsIQT = siqttemp[*,1:*]
        self.sIQT = ptr_new(newsIQT)

;042105
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
;                (*(self.sIQT))[*,j] = siqttemp[*,i]
;                j++
;            endif
;        endfor;i


        qarcstemp = *(obj->getProperty(tag='qarcs'))
;        j=0
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
                (*(self.qarcs)) = $;[*] = $
                                qarcstemp;[*]
;                j++
;            endif
;        endfor;i


        qvalstemp = *(obj->getProperty(tag='QVals'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.qvals))[*,j] = qvalstemp[*,i]
                j++
            endif
        endfor;i


        phasetemp = *(obj->getProperty(tag='phase'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.phase))[*,j] = phasetemp[*,i]
                j++
            endif
        endfor;i



        meterstemp = *(obj->getProperty(tag='meters'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.meters))[*,j] = meterstemp[*,i]
                j++
            endif
        endfor;i


        counterstemp = *(obj->getProperty(tag='counters'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.counters))[*,*,j] = counterstemp[*,*,i]
                j++
            endif
        endfor;i


        monitorstemp = *(obj->getProperty(tag='monitors'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.monitors))[j] = monitorstemp[i]
                j++
            endif
        endfor;i


        chisqtemp = *(obj->getProperty(tag='chisq'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.chisq))[*,j] = chisqtemp[*,i]
                j++
            endif
        endfor;i


        chisqtempOld = *(obj->getProperty(tag='chisqOld'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.chisqOld))[*,j] = chisqtempOld[*,i]
                j++
            endif
        endfor;i


        fourierTimetemp = *(obj->getProperty(tag='fourierTime'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fourierTime))[j] = fourierTimetemp[i]
                j++
            endif
        endfor;i


        techHeadertemp = *(obj->getProperty(tag='techHeader'))
        if (size(techheadertemp))[0] ne 2 then begin
            if ptr_valid(self.techheader) gt 0 then ptr_free,self.techheader
            self.techheader = ptr_new(['TECH REMOVED ON t REMOVAL.'])

        endif else begin
            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    (*(self.techHeader))[*,j] = techHeadertemp[*,i]
                    j++
                endif
            endfor;i
        endelse


        physicsHeadertemp = *(obj->getProperty(tag='physicsHeader'))
        if (size(physicsheadertemp))[0] ne 2 then begin
            if ptr_valid(self.physicsheader) gt 0 then ptr_free,self.physicsheader
            self.physicsheader = ptr_new(['physics REMOVED ON t REMOVAL.'])

        endif else begin
            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    (*(self.physicsHeader))[*,j] = physicsHeadertemp[*,i]
                    j++
                endif
            endfor;i
        endelse

;070605
;NEED TO MAKE SURE THIS SIZE IS FLEXIBLE TO ALLOW FOR POSSIBLE EXTRA LINE(S) FROM
;THE TEMPERATURE SENSOR/CONTROLLER
        physicsParametersHeadertemp = *(obj->getProperty(tag='physicsParametersHeader'))
        if (size(physicsParametersheadertemp))[0] ne 2 then begin
            if ptr_valid(self.physicsParametersheader) gt 0 then ptr_free,self.physicsParametersheader
            self.physicsParametersheader = ptr_new(['physicsParameters REMOVED ON t REMOVAL.'])

        endif else begin

            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    (*(self.physicsParametersHeader))[*,j] = physicsParametersHeadertemp[*,i]
                    j++
                endif
            endfor;i
        endelse

        phaseHeadertemp = *(obj->getProperty(tag='phaseHeader'))
        ;help,phaseHeaderTemp
        print," remove ne 0"
        phsz = size(phaseHeaderTemp)
        if (size(phaseheadertemp))[0] ne 3 then begin
            if ptr_valid(self.phaseheader) gt 0 then ptr_free,self.phaseheader
            self.phaseheader = ptr_new(['Phase Headers REMOVED ON t REMOVAL.'])

        endif else begin

            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    for kk = 0,phsz[2]-1 do begin
                        (*(self.phaseHeader))[*,kk,j] = phaseHeadertemp[*,kk,i]
                    endfor;kk
                    j++
                endif
            endfor;i
        endelse


    endelse; cloneSetRemoveT LOOP
end;cloneSet   ;RemoveT





function ooEcho::removeT,t,firstread=firstread,_Extra=extra
;
;NAME:
;        ooEcho::removeT
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;           firstread   If the time removal is at the initial read, set this switch.
;                       Typically you would use this to remove t=0.0 for incomplete files.
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;
        ;THIS FUNCTION CREATES A NEW OBJECT WITH THE SELECTED FOURIER TIME
        ;REMOVED.
        ;
        ;ooEcho::init WILL CALL THE NEW METHOD, ooEcho::cloneSetRemoveT


        if n_elements(firstread) eq 0 then firstread=0

        nft = self.no_of_fourier_times
        nphs = self.no_of_phases
        xdim = self.x_dim_orig
        ydim = self.y_dim_orig
        bin = self.x_dim_orig/self.y_dim_orig

        ;pro ooEcho::cloneSetRemoveT,obj,tremove=tremove

        ;070605
        ;CHECK IF t = 0.  IF SO, REMOVE ALL t eq 0.
        if t eq 0.0 then begin
            otemp = obj_new('ooecho',nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,removetobj=self,tremove=t,blank=1)
            oft = *(otemp->getProperty(tag='fourierTime'))
            whr = where(t eq oft)
;            multicom = 'Removed t = 0.00000000 ns.'
            multicom = 'Removed t = 0.0 ns.'
            while whr[0] ne -1 do begin
                ;CLEAN UP THE COMMENT SO ONLY ONE 0.0 ns IS LISTED
                com = otemp->getproperty(tag='comment')
print,com
                pos = strpos(com,multicom)
print,pos
;                if pos ne -1 then begin
                    com = strmid(com,0,pos);,strlen(multicom))
;                endif else begin

;                endelse
;
                ;print,'com = ',com
                otemp->setproperty,'comment',com

                ;CREATE A NEW OBJECT WITH ANOTHER t=0.0 REMOVED
                o = obj_new('ooecho',nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,removetobj=otemp,tremove=t,blank=1)

                ;DESTROY THE PREVIOUS OBJECT
                obj_destroy,otemp


                ;TEST FOR MORE t=0.0
                oft = *(o->getProperty(tag='fourierTime'))
                whr = where(t eq oft)

                otemp = o
            endwhile
            o = otemp
        endif else begin
            o = obj_new('ooecho',nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,removetobj=self,tremove=t,blank=1)
        endelse

        ;print,oft
        return,o
end;removeT

;;;;;;;;;;;;;;;;;;;;;
function ooEcho::init,filename=filename,obj = obj, $
                      blank = blank, mobj = mobj, $
                      nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin, $ ;BLANK OBJECT PARAMETERS
                      removetobj=removetobj, tremove=tremove,$ ;TO CREATE A CLONE OF AN OBJECT WITH A FOURIER TIME REMOVED.
                      narcs = narcs,$
                      magnetic=magnetic,$
                      _Extra=extra;ADDED 102705
;
;NAME:
;        ooEcho::init
;
;PURPOSE:
;           To initialize an ooEcho object.
;PARAMETERS:
;
;KEYWORDS:
;           filename
;           obj
;           blank       Option to create an empty object
;           mobj
;           nft         The number of Fourier times
;           nphs        The number of phases
;           xdim
;           ydim
;           bin         The binning factor
;           removetobj  An object to clone with a Fourier time removed
;           tremove     The fourier time (index?) to remove.
;           narcs       The number of q arcs.
;
;RETURN VALUE:
;           1 for success
;           0 for failure

    theTreatment = ['ooEcho::init']
    self.treatment = ptr_new(theTreatment)

    ;print,"obj_isa(self.'ooEchoMagnetic') = ",obj_isa(self,'ooEchoMagnetic')
    magnetic = obj_isa(self,'ooEchoMagnetic')

    tags= [ 'filename',$
            'workdir',$
            'datadir',$
            'type',$
            'reduced',$
            'reducedOld',$
            'e',$
            'emask',$
            'eorig',$
            'mask2d',$
            'mask2dOld',$
            'fitdisplaymask',$
            'fitdisplaymaskOld',$
            'mask1d',$
;            'mask1dPixels',$    ;082205
            'lambda',$
            'dlambda',$
            'comment',$
            'fixed',$
            'fitparms',$
            'fitparmsOld',$
            'chisq',$
            'chisqOld',$
            'Iup',$
            'Idown',$
            'sIup',$
            'sIdown',$
            'IupdownSwitch',$
            'S',$
            'sS',$
            'IQTInfo',$
            'IQT',$
            'sIQT',$
            'QVals',$
            'QValsSwitch',$
            'narcs',$
            'qarcs',$
            'phase',$
            'currentPhaseIndex',$
            'meters',$
            'counters',$
            'monitors',$
            'preset',$
            'no_of_phases',$
            'point_to_down',$
            'point_to_up',$
            'phase_step',$
            'no_of_fourier_times',$
            'no_of_pixels',$
            'beam_cen_x',$
            'beam_cen_y',$
            'transmission',$
            'volfrac',$
            'x_dim',$
            'y_dim',$
            'x_cen',$
            'y_cen',$
            'x_dim_orig',$
            'y_dim_orig',$
            'x_cen_orig',$
            'y_cen_orig',$
            'width',$
            'period',$
            'colorTable',$
            'q',$
            'qactual',$
            'qy',$
            'fourierTime',$
            'currentFourierTimeIndex',$
            'scanHeader',$
            'sampleHeader',$
            'techHeader',$
            'physicsHeader',$
            'physicsParametersHeader',$
            'phaseHeader',$
            'treatment',$
            'IQTFitparms',$
            'tags']

    self.tags = tags

    if n_elements(narcs) eq 0 then narcs = 7
    if n_elements(blank) eq 0 then blank = 0

    ;102705 CHANGE THE NEXT TEST
    if blank ne 0 then begin;(n_elements(blank)) gt 0 then begin
        ;print,'TEST BLANK'
        self->blankObj,nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin

        if obj_valid(removetobj) then begin
            ;self->cloneSetRemoveT,removetobj,tremove=tremove
            self->cloneSet,removetobj,tremove=tremove
        endif


        if (n_elements(obj) gt 0) and (obj_valid(mobj) gt 0) then begin
            ;print,'TEST INIT'
            return,0
        endif

    endif else begin

        if (n_elements(obj) ne 0) then begin
            ;COPY OBJECT HERE FOR CLONE METHOD AND INITIALIZATION WITH
            ;OTHER OBJECT
            self->cloneSet,obj
        endif else begin
            if (n_elements(filename) ne 0) then begin
                print,'READING DATA FROM '+filename
                ret = self->read(filename=filename)
            endif else begin
                ret = self->read()
            endelse

            if ret eq 1 then begin
                if (ptr_valid(self.e) ne 0) then begin
                    if ptr_valid(self.emask) gt 0 then ptr_free,self.emask
                    if ptr_valid(self.eorig) gt 0 then ptr_free,self.eorig
                    self->setProperty,'emask',ptr_new(*(self->getProperty(tag='e')))
                    self->setProperty,'eorig',ptr_new(*(self->getProperty(tag='e')))
                    sz = size(*(self.e))
                    if ptr_valid(self.fixed) gt 0 then ptr_free,self.fixed
                    self->setProperty,'fixed',$
                                ptr_new(intarr(6,sz[1],sz[3]))
                    (*(self.fixed))[0,*,*] = 0    ;VARY p1
                    (*(self.fixed))[1,*,*] = 0
                    (*(self.fixed))[2,*,*] = 0
                    (*(self.fixed))[3,*,*] = 1    ;FIX p4
                    (*(self.fixed))[4,*,*] = 0
                    (*(self.fixed))[5,*,*] = 1

                    if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
                    self->setProperty,'fitparms',$
                                ptr_new(dblarr(12,sz[1],sz[3])+1.0)
                    (*self.fitparms)[0,*,*] = (*self.fitparms)[0,*,*] + 199.0
                    (*self.fitparms)[1,*,*] = (*self.fitparms)[1,*,*] + 99.0
                    (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] + 199.0
                    (*self.fitparms)[3,*,*] = (*self.fitparms)[3,*,*] + 702.0
                    (*self.fitparms)[4,*,*] = (*self.fitparms)[4,*,*] + 0.0
                    (*self.fitparms)[5,*,*] = (*self.fitparms)[5,*,*] - 1.0


                    if ptr_valid(self.chisq) gt 0 then ptr_free,self.chisq
                    self->setProperty,'chisq',$
                                    ptr_new(dblarr(sz[1],sz[3]))

                    ;FOR SOME REASON AN OPERATION IS REQUIRED TO
                    ;MAKE self.chisq A VALID POINTER.
                    (*self.chisq)[*,*,*] = (*self.chisq)[*,*,*] + 100000000.0
                    ;;help,self.fitparms
                    ;;help,self.chisq
                    ;;help,*self.chisq

                    if ptr_valid(self.mask1D) then ptr_free,self.mask1D
                    self.mask1D = ptr_new(intarr(self.no_of_phases,self.no_of_fourier_times)+1)

;                    ;082205
;                    if ptr_valid(self.mask1DPixels) then ptr_free,self.mask1DPixels
;                    self.mask1DPixels = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_phases,self.no_of_fourier_times)+1)



                    if ptr_valid(self.mask2D) then ptr_free,self.mask2D
                    if ptr_valid(self.fitdisplaymask) then ptr_free,self.fitdisplaymask
                    self.x_dim = sqrt(sz[1])
                    self.y_dim = sqrt(sz[1])
                    ;print,self.x_dim
                    ;print,self.y_dim
                    ;print,self.no_of_fourier_times
                    self.mask2D = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1)
                    self.mask2DOld = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1)
                    self.fitdisplaymask = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+0)
                    self.fitdisplaymaskOld = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+0)
                    self.Iup = ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                    self.Idown=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                    self.sIup = ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                    self.sIdown=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                    self.IupdownSwitch = 0
                    self.S=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                    self.sS=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                    self.QVals = ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                    self.QValsSwitch = 0
                    self.narcs = narcs
                    self.qarcs = ptr_new(dblarr(5))
                    self.IQTInfo = ptr_new(['#','#'])
                    self.IQT = ptr_new(dblarr(self.narcs,self.no_of_fourier_times))
                    self.sIQT = ptr_new(dblarr(self.narcs,self.no_of_fourier_times))
                    self.IQTFitparms = ptr_new(dblarr(self.narcs,2))

                    self.transmission=1.0
                    self.width=702.0
                    self.period = 373.0
                endif else begin
                    print,'11313 ooecho::init THE DATA ARRAY WAS NOT INITIALIZED!!!'
                endelse
                ;THESE NEXT LINES NEED TO BE GENERALIZED
                ;SO OTHER TYPES OF DETECTORS CAN BE USED
                self->setProperty,'x_dim',sqrt(self.no_of_pixels)
                self->setProperty,'y_dim',sqrt(self.no_of_pixels)
                self->setProperty,'x_dim_orig',sqrt(self.no_of_pixels)
                self->setProperty,'y_dim_orig',sqrt(self.no_of_pixels)

                self->setProperty,'x_cen',16.0
                self->setProperty,'y_cen',15.0
                self->setProperty,'x_cen_orig',16.0
                self->setProperty,'y_cen_orig',15.0
                self->setProperty,'colorTable',3


            endif else begin
                print,'11328 ooecho::init INSUFFICIENT DATA IN FILE: OBJECT NOT CREATED.'
                return,0
            endelse;ret eq 1 or 0

        endelse;NO OBJECT TO COPY
    endelse;NOT BLANK

    return,1
end;init
;;;;;;;;;;;;;;;;;;;;;
pro ooEcho__define,_Extra=extra
;
;NAME:
;        ooEcho__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

    tags= [ 'filename',$
            'workdir',$
            'datadir',$
            'type',$
            'reduced',$
            'reducedOld',$
            'e',$
            'emask',$
            'eorig',$
            'mask2d',$
            'mask2dOld',$
            'fitdisplaymask',$
            'fitdisplaymaskOld',$
            'mask1d',$
;            'mask1dPixels',$    ;082205
            'lambda',$
            'dlambda',$
            'comment',$
            'fixed',$
            'fitparms',$
            'fitparmsOld',$
            'chisq',$
            'chisqOld',$
            'Iup',$
            'Idown',$
            'sIup',$
            'sIdown',$
            'IupdownSwitch',$
            'S',$
            'sS',$
            'IQTInfo',$
            'IQT',$
            'sIQT',$
            'QVals',$
            'QValsSwitch',$
            'narcs',$
            'qarcs',$
            'phase',$
            'currentPhaseIndex',$
            'meters',$
            'counters',$
            'monitors',$
            'preset',$
            'no_of_phases',$
            'point_to_down',$
            'point_to_up',$
            'phase_step',$
            'no_of_fourier_times',$
            'no_of_pixels',$
            'beam_cen_x',$
            'beam_cen_y',$
            'transmission',$
            'volfrac',$
            'x_dim',$
            'y_dim',$
            'x_cen',$
            'y_cen',$
            'x_dim_orig',$
            'y_dim_orig',$
            'x_cen_orig',$
            'y_cen_orig',$
            'width',$
            'period',$
            'colorTable',$
            'q',$
            'qactual',$
            'qy',$
            'fourierTime',$
            'currentFourierTimeIndex',$
            'scanHeader',$
            'sampleHeader',$
            'techHeader',$
            'physicsHeader',$
            'physicsParametersHeader',$
            'phaseHeader',$
            'treatment',$
            'IQTFitparms',$
            'tags']

    class = {ooEcho,$
            filename:'',$
            workdir:'',$
            datadir:'',$
            type:0,$                ;TYPE OF FILE (RES, DAT, BCK)
            reduced:0,$             ;BOOLEAN FOR REDUCED OR NOT.
            reducedOld:0,$
            e:ptr_new(),$;/allocate_heap),$ ;4-D DATA ARRAY
            emask:ptr_new(),$
            eorig:ptr_new(),$
            mask2d:ptr_new(),$
            mask2dOld:ptr_new(),$
            fitdisplaymask:ptr_new(),$ ;MASK ALLOWING DISPLAY OF FIT CURVES
            fitdisplaymaskOld:ptr_new(),$ ;STORE fitdisplaymask FOR RECOVERY
            mask1d:ptr_new(),$
;            mask1dPixels:ptr_new(),$    ;PIXEL-BY-PIXEL 1d MASK --- NEW 082205
            lambda:0.0D,$           ;WAVELENGTH AND DISTRIBUTION
            dlambda:0.0D,$
            comment:'',$            ;COMMENT LINE FROM THE DATA FILE
            fixed:ptr_new(),$
            fitparms:ptr_new(),$    ;FIT PARAMETERS WITH AMPLITUDES
            fitparmsOld:ptr_new(),$ ;SAVE fitparms TO REVERT AFTER BAD FIT.
            chisq:ptr_new(),$       ;CHI-SQUAREDS FOR FITS
            chisqOld:ptr_new(),$
            Iup:ptr_new(),$         ;FLIPPER ON AND FLIPPER OFF
            Idown:ptr_new(),$       ;INTENSITIES
            sIup:ptr_new(),$        ;FLIPPER ON AND FLIPPER OFF
            sIdown:ptr_new(),$      ;ERROR BARS
            IupdownSwitch:0,$       ;TELLS IF Iup,down ARE CALCULATED
            S:ptr_new(),$           ;THE INTERMEDIATE SCATTERING FUNCTION
            sS:ptr_new(),$          ;ERROR BARS
            IQTInfo:ptr_new(),$     ;INFORMATION FOR AN IQT ASCII FILE
            IQT:ptr_new(),$
            sIQT:ptr_new(),$
            QVals:ptr_new(),$       ;THE QVALUES FOR ALL OF THE DATA
            QValsSwitch:0,$         ;TELLS IF QVals ARE CALCULATED
            narcs:7,$               ;NUMBER OF Q ARCS ON DETECTOR
            qarcs:ptr_new(),$
            phase:ptr_new(),$
            currentPhaseIndex:0,$
            meters:ptr_new(),$      ;METERS STRUCTURE
            counters:ptr_new(),$    ;COUNTERS STRUCTURE
            preset:0L,$             ;THE "PRESET" OR MONITOR VALUE FOR THE FILE.
            monitors:ptr_new(),$    ;MONITORS STRUCTURE
            no_of_phases:0,$
            point_to_down:0,$
            point_to_up:0,$
            phase_step:0,$
            no_of_fourier_times:0,$
            no_of_pixels:0,$
            beam_cen_x:6.0,$
            beam_cen_y:6.0,$
            transmission:1.0,$
            volfrac:1.0,$
            x_cen:16.0,$
            y_cen:15.0,$
            x_dim:32,$
            y_dim:32,$
            x_cen_orig:16.0,$
            y_cen_orig:15.0,$
            x_dim_orig:32,$
            y_dim_orig:32,$
            width:702.0,$
            period:373.0,$
            colorTable:3,$
            q:0.0,$         ;TYPICALLY qx WILL BE q
            qactual:0.0,$
            qy:0.0,$        ;IN CASE THERE IS A qy COMPONENT
            fourierTime:ptr_new(),$;/allocate_heap),$
            currentFourierTimeIndex:0,$
            scanHeader:ptr_new(),$;/allocate_heap),$
            sampleHeader:ptr_new(),$;/allocate_heap),$
            techHeader:ptr_new(),$;/allocate_heap),$      ;STRING ARRAYS CONTAINING
            physicsHeader:ptr_new(),$;/allocate_heap),$   ;HEADERS
            physicsParametersHeader:ptr_new(),$;/allocate_heap),$
            phaseHeader:ptr_new(),$;/allocate_heap),$     ;PHASEHEADER IS 2-D STRING ARRAY
            treatment:ptr_new(),$           ;RECORD OF DATA TREATMENT
            IQTFitparms:ptr_new(),$         ;FITPARAMETERS FOR I(Q,t) FITS.
            tags:strarr(n_elements(tags))}

end;ooEcho

