; $Id$
;###############################################################################
;
;CLASS NAME:
;    pro ooDisplayEcho__restoresession
;
;PURPOSE:
;               To save the sessions and individual objects.
;CATEGORY:
;               Data Visualization, Analysis and Manipulation.
;SUPERCLASSES:
;               myProperties
;
;METHODS:
;    ooDisplayEcho::restoreSession
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; July 25,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
function ooDisplayEcho::restoreSession,object=object,testdata=testdata
;
;NAME:
;        ooDisplayEcho::restoreSession
;
;PURPOSE:
;           Encapsulate all restore session functionality into one method
;           to be used from file.
;PARAMETERS:
;           none
;KEYWORDS:
;           object  Flag to indicate if only one object will be read from file.
;RETURN VALUE
;           1/0 TO INDICATE SUCCESS/FAILURE

                    if n_elements(object) eq 0 then object = 0
                    if n_elements(testdata) eq 0 then testdata = 0
;void = dialog_message('Restore session test 1')

                    if testdata eq 0 then  begin

                      fn = dialog_pickfile(/read,/must_exist,$
                                              path=self.work_dir,$
                                              filter=['*.sav','*.xml'],dialog_parent=self.atlb)
                    endif else begin
                      defsysv,'!DAVE_AUXILIARY_DIR',exists=exists
                      if exists ne 0 then begin
                        fn = !dave_auxiliary_dir+path_sep()+'NSETestSession.sav'
                      endif else begin
                        void = dialog_message('!DAVE_AUXILIARY_DIR NOT FOUND.',dialog_parent=self.atlb)
                        return,0
                      endelse
                      
                      if file_test(fn) eq 0 then begin
                        void = dialog_message('NSE TEST DATA NOT FOUND.',dialog_parent=self.atlb)
                        return,0
                      endif

                    endelse

;void = dialog_message('Restore session test 2')


                    if fn eq '' then begin
                        ;void = dialog_message('NO INPUT FILE SELECTED.',dialog_parent=self.atlb)
                        return,0
                    endif else begin

                            ;if testdata eq 0 then begin
                            ;  self.work_dir = file_dirname(fn);,/mark_directory)
                            ;endif
                             

                            ;FIRST CHECK FOR VALID FILE EXTENSIONS, .xml and .sav
                            ;AND ESTABLISH WHICH TYPE IS BEING READ.
                            length = strlen(fn)
                            if length gt 4 then begin
                                ext = strmid(fn,length-4,4)
                                ;pos = stregex(fn,'.xml',/foldcase)
;                                if stregex(ext,'.sav',/fold_case) ne -1 then print,'.sav file'
;                                if stregex(ext,'.xml',/fold_case) ne -1 then print,'.xml file'
                                extension = strlowcase(ext)
                                ;FOR TESTING
                                ;return,0
                            endif else begin
                                void = dialog_message('FILE MUST HAVE A ".xml" OR A ".sav" EXTENSION.',dialog_parent=self.atlb)
                                return,0
                            endelse



                            ;if extension eq '.xml' then begin
                            case extension of
                            '.xml':begin
                                totallunlines = file_lines(fn)

                                ;self.work_dir = file_dirname(fn);,/mark_directory)

                                if object eq 0 then begin
                                    ;031805
                                    ;DELETE ALL ACTIVE OBJECTS BEFORE RESTORING FROM FILE.
                                    killref = self.datacontainer->get(/all)
                                    self.datacontainer->remove,/all
                                    if obj_valid(killref[0]) then obj_destroy,killref
                                endif

    ;031805
    ;NEED TO ADD ERROR CHECKING HERE FOR THE DATA IN THE FILE.
    ;
    ;NO TIME TODAY...
    CATCH, Error_status
       ;HANDLE ERRORS IN READING THE STATE FILE.
       IF (Error_status NE 0) THEN BEGIN
          free_lun,lun,/force
          print,'4605 ooDisplayEcho::restoreSession PROBLEM OCCURRED.'
          print,readResult
          CATCH, /CANCEL
          if widget_info(b1,/valid_id) gt 0 then $
              widget_control,b1,/destroy
          return,0
       ENDIF
                                ;self.work_dir = file_dirname(fn)

                                openr,lun,fn,/get_lun

                                ;
                                line=''
                                readf,lun,line  ;GET <xml>
                                readf,lun,line  ;GET THE WARNING MESSAGES.
                                readf,lun,line
                                readf,lun,line  ;GET "<session>"
                                if stregex(line,'<session>',/fold_case,/boolean) then begin
                                    readf,lun,line  ;GET "<nobj>"
                                    segs = strsplit(line,/extract)
                                    count = fix(segs[1])

                                    ;120304
                                    ;PROGRESS BAR
                                    b1 = widget_base(title='Session Import',xsize=200, $
                                        xoffset=400,yoffset=400,/floating,group_leader=self.atlb)
;                                    p1 = cw_progress(b1,value=[count], $
;                                                        title=['Obj # ='])
                                    p1 = nse_progress(b1,value=[count], $
                                                        title=['Obj # ='],dialog_parent=self.atlb)
                                    widget_control,b1,/realize

                                    readf,lun,line ;GET "<gaussianwidth>"
                                    print,line
                                    segs = strsplit(line,/extract)
                                    ;print,'Gaussian width ='+segs[1]
                                    widget_control,self.atwwidth,$
                                                set_value = double(segs[1])

    ;MAYBE point_lun CAN MAKE THIS BACKWARD COMPATIBLE.
    ;TO CREATE BACKWARD COMPATIBILITY, ADD FUTURE NEW VALUES
    ;TO THE END OF THE FILE ON SAVE COMMANDS.
    ;THEN OLDER VERSIONS OF THE READER WILL NOT SEE THESE.
    ;ONCE IDL 6.1 IS USED FOR DAVE, THESE VALUES WILL BE
    ;RETRIEVED USING THE IDLffXMLDOM CLASSES.

                                    readf,lun,line ;GET "<period>"
;                                    print,line
                                    if stregex(line,'period',/fold_case,/boolean) then begin
                                        segs = strsplit(line,/extract)
                                        self.periodvalue = double(segs[1])
                                    endif
    ;060605
;                                    print,'self.periodvalue=',self.periodvalue
                                    widget_control,self.atwperiod,$
                                                set_value = strtrim(string(self.periodvalue),2)

                                    readf,lun,line ;GET "<data_dir>"
;                                    print,line
                                    segs = strsplit(line,/extract)
                                    self.data_dir = strtrim(segs[1],2)

                                    readf,lun,line ;GET "<work_dir>"
                                    segs = strsplit(line,/extract)

                            ;ELIMINATE THE NEXT LINE AND LET THE work_dir BE DETERMINED BY THE LOCATION OF THE DATA FILE.
                                    ;self.work_dir = strtrim(segs[1],2)

                                    for io = 0,count-1 do begin
                                        ;oblank = obj_new('ooecho',/blank)
                                        oblank = obj_new('ooechoMagnetic',/blank)
                                        readResult = oblank->readstate(lun=lun,totallunlines=totallunlines)
                                        ccount = self.datacontainer->count()
                                        if readResult eq 1 then begin
                                            self.datacontainer->add,oblank, $
                                                                position=ccount
                                        endif else begin
                                            free_lun,lun,/force
                                            if widget_info(b1,/valid_id) gt 0 then $
                                                widget_control,b1,/destroy

                                            void = dialog_message('Problem reading file: '+fn,dialog_parent=self.atlb)
                                            return,0
                                        endelse
                                        if widget_info(p1,/valid_id) gt 0 then $
                                            widget_control,p1,set_value=[io+1]
                                    endfor;io
                                    readf,lun,line
                                    if not stregex(line,'</session>',/fold_case,/boolean) then $
                                        void = dialog_message('"</session>" NOT OBSERVED, '+ $
                                                                'MORE OBJECTS POSSIBLE.',dialog_parent=self.atlb)
                                    free_lun,lun
                                    if widget_info(b1,/valid_id) gt 0 then $
                                        widget_control,b1,/destroy
                                newcount = self.datacontainer->count()
                                self.QChoiceIndex = 0

;                               MOVE NEXT 3 LINES TO CALLING ROUTINE
;                                self->reDefineWidgets,newcount,t=0,/newsize
;                                self->redefineTree
;                                self->draw

                                return,1
                            endif else begin


                                void = dialog_message('FILE FORMAT QUESTIONABLE: ' + $
                                                    'FIRST TAG NE "<session>".',dialog_parent=self.atlb)

                                return,0
                            endelse
                        end;.xml
                        '.sav':begin
                            print,'RESTORING A .sav FILE.'
                            CATCH, Error_status
                               ;HANDLE ERRORS IN READING THE STATE FILE.
                               IF (Error_status NE 0) THEN BEGIN
                                  free_lun,lun,/force
                                  print,'4827 ooDisplayEcho::restoreSession PROBLEM OCCURRED.'
                                  print,readResult
                                  CATCH, /CANCEL
                                  if widget_info(b1,/valid_id) gt 0 then $
                                      widget_control,b1,/destroy
                                  return,0
                               ENDIF


                            prog = nse_cwo_progress(labels=['STEP:'],$
                                                   startvalues=[0L],$
                                                   endvalues=[1L],$
                                                   values=[0L],$
                                                   steps=[1L],$
                                                   obj=progobj,$
                                                   title='Restoring session, please wait . . .',$
                                                   dialog_parent=self.atlb,/nostop)
                            

                            modtime = (file_info(fn)).mtime

                            if !version.release ge 6.1 then begin
                                restore,fn,/RELAXED_STRUCTURE_ASSIGNMENT;,description=description
                                ;print,'Session file description = ',description
                            endif else begin
                                restore,fn,/RELAXED_STRUCTURE_ASSIGNMENT
                            endelse
                            if obj_valid(progobj) then progobj->step,0

                            print,obj_valid(nse_container)
                            if obj_valid(nse_container) eq 0 then begin
                                message = dialog_message('.sav FILE MAY NOT BE VALID SESSION FILE.',dialog_parent=self.atlb)
                                if widget_info(b1,/valid_id) ne 0 then widget_control,b1,/destroy
                                return,0
                            endif



                            if object eq 0 then begin
                                self.xindex = xindex
                                self.yindex = yindex
                                self.qchoiceindex = 0;qchoiceindex
                                if (((!version.os_family eq 'Windows') && (Stregex(data_dir,'C:\\',/fold) ge 0)) || $
                                    ((!version.os_family eq 'unix')    && (Stregex(data_dir,'/',/fold) ge 0))  ) then begin
                                  ; Only record the restored session path if it is from the same os_family we are currently using
                                  self.data_dir = data_dir
                                endif
                                if (((!version.os_family eq 'Windows') && (Stregex(work_dir,'C:\\',/fold) ge 0)) || $
                                   ((!version.os_family eq 'unix')     && (Stregex(work_dir,'/',/fold) ge 0))  ) then begin
                                  ; Only record the restored session path if it is from the same os_family we are currently using
                                  self.work_dir = work_dir
                                endif


                                ;DELETE ALL ACTIVE OBJECTS BEFORE RESTORING FROM FILE.
                                killref = self.datacontainer->get(/all)
                                self.datacontainer->remove,/all
                                if obj_valid(killref[0]) then obj_destroy,killref
                                if obj_valid(self.datacontainer) then obj_destroy,self.datacontainer


                                self.datacontainer = nse_container

                            endif else begin
                                nobjects = nse_container->count()
                                if nobjects gt 1 then begin
                                    void = dialog_message('Multiple objects in file, extracting only the first.',dialog_parent=self.atlb)
                                endif
;                                ref = nse_container->get(position=0)
                                ref = (nse_container->get(position=0))->clone()

                                killref = nse_container->get(/all)
                                if obj_valid(killref[0]) gt 0 then obj_destroy,killref
                                obj_destroy,nse_container
                                count = self.datacontainer->count()
                                self.datacontainer->add,ref,position=count
                                self.QChoiceIndex = count
                            endelse

                            ; Loop through restored datasets and ensure the workdir and datadir properties no longer make sense
                            ; If not replace them with sane values from the current reduction setting
                            nObj = self.datacontainer->Count()
                            for i=0,nObj-1 do begin
                              obj = self.datacontainer->Get(position=i)
                              value = obj->Getproperty(tag='workdir')
                              if (file_test(value) eq 0) then obj->Setproperty, 'workdir',Self.work_dir
                              value = obj->Getproperty(tag='datadir')
                              if (File_test(value) eq 0) then obj->Setproperty, 'datadir',Self.data_dir
                            endfor
                            
                            ; On unix, file_basename() and file_dirname() cannot properly resolve Windows paths
                            ; so remove the dirname from the filename if this was a session created on Windows containing Windows paths
                            if (!version.os_family ne 'Windows') then begin
                              for i=0,nObj-1 do begin
                                obj = self.datacontainer->get(position=i)
                                fname = obj->getproperty(tag='filename')
                                if (Stregex(fname,'C:\\',/fold) ne -1) then begin
                                  toks = Strsplit(fname,'\',count=ntoks,/extract)
                                  fname = (ntoks eq 1)? fname : toks[ntoks-1]
                                  obj->Setproperty, 'filename', fname
                                endif
                              endfor
                             endif

                            ;if widget_info(b1,/valid_id) ne 0 then widget_control,b1,/destroy
                            if widget_info(prog,/valid_id) ne 0 then widget_control,prog,/destroy

                            return,1
                        end;'.sav'
                        else:begin
                            void = dialog_message('FILE MUST HAVE A ".xml" OR A ".sav" EXTENSION.',dialog_parent=self.atlb)
                            return,0
                        end;else
                        endcase
                    endelse

end;restoreSession
