

pro nseprogress_checkprogress,id,index=index,stopped=stopped

            if n_elements(index) eq 0 then index = 0
            nseprogress_step,id,index=index
            nseprogress_stopcheck,id,stopped=stopped
            if stopped ne 0 then begin
                nseprogress_close,id
            endif
end;nseprogress_checkprogress


pro nseprogress_stopcheck,id,stopped=stopped


    if widget_info(id,/valid_id) gt 0 then begin

        stopped = nse_progress_checkstop(id)

    endif

end;nseprogress_stopcheck

pro nseprogress_step,id,index=index

    if widget_info(id,/valid_id) gt 0 then begin
        widget_control,id,get_value = val
        ;print,val

        if n_elements(index) eq 0 then index = -1

        if index ne -1 then begin
            val[index] = val[index] + 1
        endif else begin
            val = val + 1
        endelse
        if widget_info(id,/valid_id) gt 0 then $
                        widget_control,id,set_value=val
    endif

end;nseprogress_step

pro nseprogress_close,id

    if widget_info(id,/valid_id) gt 0 then begin
        base = widget_info(id,/parent)
        widget_control,base,/destroy
    endif
end;nseprogress_close

pro nseprogress_cleanup,id

    base = widget_info(id,/parent)
    widget_control,base,/destroy

end;nseprogress_cleanup


function nseprogress,vals,  title=title,labels=labels,xsize=xsize,$
                            xoffset=xoffset, yoffset=yoffset,$
                            stopbutton=stopbutton,$
                            start=start,group_leader=group_leader,$
                            dialog_parent=dialog_parent


    if n_elements(xoffset) eq 0 then xoffset = 300
    if n_elements(yoffset) eq 0 then yoffset = 300
    if n_elements(stopbutton) eq 0 then stopbutton=1
    if n_elements(start) ne n_elements(vals) then start = 0*vals
    if n_elements(group_leader) eq 0 then group_leader = 0L

    floating = 0
    if n_elements(dialog_parent) ne 0 then begin
      if dialog_parent ne 0L then begin
        floating = 1
        pgeom = widget_info(dialog_parent,/geom)
        xoffset = pgeom.xoffset + pgeom.xsize/3
        yoffset = pgeom.yoffset + pgeom.ysize/3
      endif
    endif
    


    base = widget_base(title=title,xoffset=xoffset,yoffset=yoffset,xsize=xsize,$;floating=floating
                       group_leader=group_leader)
    ;print,'base=',base
;    prog = cw_progress(base,value=vals,title=labels,stopbutton=stopbutton);,$
;                       ;kill_notify='progress_cleanup');[nfiles])
    prog = nse_progress(base,value=vals,title=labels,stopbutton=stopbutton);,dialog_parent=dialog_parent);,$
                       ;kill_notify='progress_cleanup');[nfiles])


    centertlb,base


    widget_control,prog,set_value=start
    widget_control,base,/realize

    return,prog

end;nseprogress
