; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_displayD_class__define
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    inherits myproperties
;
;
;METHODS:
;    cwo_displayD
;    cwo_displayD_class::draw
;    cwo_displayD_class::resize
;    cwo_displayD_class_event
;    cwo_displayD_class::changeData
;    cwo_displayD_realize
;    cwo_displayD_class::realize
;    cwo_displayD_class::cleanup
;    cwo_displayD_cleanup
;    cwo_displayD_class::init
;    cwo_displayD_class__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri May 06 19:02:06 2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        cwo_displayD_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_class::draw

    device,get_decomposed=dc
    device,decomposed = 1

    white = 255L+256L*(255L +256L*255L)
    black = 0L

    wset,self.winpix
    plot,*self.x,*self.y,xtitle = 'Q', ytitle = 'D(Q)',$
            color = black,background=white,$
            psym = 8,/ylog,yrange = [min(*self.y),max(*self.y)],$
            xrange = [min(*self.x),max(*self.x)]

    wset,self.winvis
    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.winpix]


    device,decomposed = dc
end;draw
;###############################################################################
;
;NAME:
;        cwo_displayD_class::resize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_class::resize
    geom = widget_info(self.id,/geom)
    xsize = geom.xsize
    ysize = geom.ysize

    widget_control,self.draw,xsize = xsize,ysize = ysize
    widget_control,self.winvis,xsize = xsize,ysize = ysize

    wdelete,winpix
    window,/free,/pixmap,xsize=xsize,ysize=ysize
    self.winpix = !d.window

    self->draw


end;resize
;###############################################################################
;
;NAME:
;        cwo_displayd_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_displayd_event,event

    print,event.handler
    widget_control,event.handler,get_uvalue=self
    self->resize

end;cwo_displayd_event

;###############################################################################
;
;NAME:
;        cwo_displayD_class::changeData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_class::changeData,x,y

    ;COPY DATA SO THAT IT IS NOT DESTROYED WHEN POINTERS ARE.
    xnew = x
    ynew = y

    if ptr_valid(self.x) gt 0 then ptr_free,self.x
    if ptr_valid(self.y) gt 0 then ptr_free,self.y

    self.x = ptr_new(xnew)
    self.y = ptr_new(ynew)

    self->draw
end;changeData
;###############################################################################
;
;NAME:
;        cwo_displayD_realize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_realize,id

    print,'cwo_displayD_realize'

    widget_control,id,get_uvalue=self
    self->realize

end;cwo_displayD_realize
;###############################################################################
;
;NAME:
;        cwo_displayD_class::realize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_class::realize

    print,'cwo_displayD_class::realize'

    widget_control,self.draw,get_value = val
    print,val
    self.winvis = val

    geom = widget_info(self.draw,/geom)
    window,/free,/pixmap,xsize=geom.xsize,ysize=geom.ysize
    self.winpix = !d.window
    x = findgen(10) & y = sin(x)

    wset,self.winpix
    plot,x,y
    wset,self.winvis
    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.winpix]

end;cwo_displayD_class::realize
;###############################################################################
;
;NAME:
;        cwo_displayD_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_class::cleanup

    ptr_free,self.x
    ptr_free,self.y

end;cleanup
;###############################################################################
;
;NAME:
;        cwo_displayD_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_cleanup,id

    print,'cwo_displayD_cleanup'
    widget_control,id,get_uvalue=self
    obj_destroy,self
end;cleanup
;###############################################################################
;
;NAME:
;        cwo_displayD_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_displayD_class::init,parent,x,y,xsize=xsize,ysize=ysize,obj=obj,_Extra=_Extra

    if widget_info(parent,/valid_id) gt 0 then begin
        if n_elements(xsize) eq 0 then xsize=200
        if n_elements(ysize) eq 0 then ysize=200

        if widget_info(parent,/valid_id) gt 0 then begin
            self.id = widget_base(parent,event_func='cwo_displayd_event',$
                                    tlb_size_events=1,uvalue=self)
            self.draw = widget_draw(self.id,xsize = xsize, ysize = ysize,$
                                    notify_realize='cwo_displayD_realize',$
                                    kill_notify = 'cwo_displayD_cleanup',$
                                    uvalue=self)

            obj=self
            return,1
        endif else begin
            return,0
        endelse
    endif else begin
        return,0
    endelse
end;cwo_displayD_class::init

;###############################################################################
;
;NAME:
;        cwo_displayD_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayD_class__define,class

    class = {   cwo_displayD_class,       $
                inherits myproperties, $
                parent : 0L,        $
                id : 0L,            $
                draw : 0L,          $
                winvis : 0L,        $
                winpix : 0L,        $
                x : ptr_new(),      $
                y : ptr_new()       $
            }

end;cwo_displayD_class__define


;###############################################################################
;
;NAME:
;        cwo_displayD
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_displayD,parent,obj=obj,xsize=xsize,ysize=ysize,_Extra=_Extra


    obj = obj_new('cwo_displayD_class',parent,xsize=xsize,ysize=ysize,_Extra=_Extra)

    return,obj->getProperty(/id)
end;cwo_displayD

