; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    NSEDiffractionViewerMagnetic_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;METHODS:
;    NSEDiffractionViewerMagnetic_data::calculate
;    NSEDiffractionViewerMagnetic_data::draw
;    NSEDiffractionViewerMagnetic_data::legend
;    NSEDiffractionViewerMagnetic_data::xrange
;    NSEDiffractionViewerMagnetic_data::yrange
;    NSEDiffractionViewerMagnetic_data::toggleHide
;    NSEDiffractionViewerMagnetic_data::hide
;    NSEDiffractionViewerMagnetic_data::show
;    NSEDiffractionViewerMagnetic_data::hideLegend
;    NSEDiffractionViewerMagnetic_data::showLegend
;    NSEDiffractionViewerMagnetic_data::getproperty
;    NSEDiffractionViewerMagnetic_data::setproperty
;    NSEDiffractionViewerMagnetic_data::cleanup
;    NSEDiffractionViewerMagnetic_data::init
;    NSEDiffractionViewerMagnetic_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data::calculate,_ref_extra=extra

;THIS METHOD WILL BE OVERRIDDEN IN THE SUBCLASSES TO BE APPROPRIATE FOR
;THE GIVEN DATA TYPE.
;
;e.g.
;1) IN THE CASE OF A CRYSTAL LATTICE, IT WILL CALCULATE THE LATTICE POSITIONS AND
;STRUCTURE FACTORS.  IN THAT CASE THERE WILL ALSO BE A 3d SET OF COORDINATES
;FROM WHICH Qx,y,z WILL BE DERIVED.
;
;2) IN THE CASE OF AN EXPERIMENTAL DATA SET, THESE VALUES WILL BE SUBMITTED
;AT THE TIME OF OBJECT CREATION AND calculate WILL DO NOTHING.
;


end;calculate


;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data::draw,win,_ref_extra=extra

;print,'NSEDiffractionViewerMagnetic_data::draw  HEY WTF!!!!'

        self->calculate,_extra=extra
        wset,win

        device,get_decomposed=dc
        device,decomposed=1


        self->getproperty,  x=px,y=py,sy=psy,$
                            coh=coh,scoh=scoh,$
                            nonmagnetic=nonmagnetic,$
                            mag=mag,smag=smag,$
                            incoh=incoh,$
                            sincoh=sincoh,$
                            tot=tot,$
                            stot=stot,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            legend=legend,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            thesymsize=symsize
        ;nonmagnetic = self.nonmagnetic

        if showdata ne 0 then begin
            x = *px
;            y = *py
;            sy = *psy
;

            tot=*tot
            stot=*stot
            coh = *coh
            scoh = *scoh
            incoh=*incoh
            sincoh=*sincoh

            cup = coh + scoh
            cdn = coh - scoh
            iup = incoh + sincoh
            idn = incoh - sincoh
            tup = tot + stot
            tdn = tot - stot


            if nonmagnetic eq 0 then begin
                mag=*mag
                smag=*smag
                mup = mag + smag
                mdn = mag - smag
            endif

            ;USE SAME SYMBOL AND DIFFERENT COLORS.
            oplot,x,coh,color = self.blue,psym =  psym,linestyle=linestyle,symsize=symsize
            if ebshow gt 0 then errplot,x,cdn,cup,color = self.blue
            oplot,x,incoh,color = self.green,psym =  psym,linestyle=linestyle,symsize=symsize
            if ebshow gt 0 then errplot,x,idn,iup,color = self.green
            oplot,x,tot,color = self.black,psym =  psym,linestyle=linestyle,symsize=symsize
            if ebshow gt 0 then errplot,x,tdn,tup,color = self.black

            if nonmagnetic eq 0 then begin
                oplot,x,mag,color = self.red,psym =  psym,linestyle=linestyle,symsize=symsize
                if ebshow gt 0 then errplot,x,mdn,mup,color = self.red
            endif;nonmagnetic eq 0

        endif;show

        device, decomposed = dc

end;NSEDiffractionViewerMagnetic_data::draw

;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::legend
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data::legend,win,xlegend,ylegend,symsize=symsize,_ref_extra=extra

    self->cwo_drawplot_data::legend,win,xlegend,ylegend,symsize=symsize,_extra=extra

end;NSEDiffractionViewerMagnetic_data::legend

;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function NSEDiffractionViewerMagnetic_data::yrange

    ymin = [*self.y-*self.sy,$
            *self.tot-*self.stot,$
            *self.incoh-*self.sincoh,$
            *self.coh-*self.scoh,$
            *self.mag-*self.smag]
    ymax = [*self.y+*self.sy,$
            *self.tot+*self.stot,$
            *self.incoh+*self.sincoh,$
            *self.coh+*self.scoh,$
            *self.mag+*self.smag]

;print,'NSEDiffractionViewerMagnetic_data::yrange'
;print,[min(ymin),max(ymax)]
    return,[min(ymin),max(ymax)]

end;yrange
;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data::writeASCII


        fn = dialog_pickfile(title='DATA: '+self.legend,$
                             /overwrite_prompt,$
                             path=self.workdir)


        if fn ne '' then begin

            self.workdir = file_dirname(fn)

;            px = self.x
;            py = self.y
;            coh = self.coh
;            scoh = self.scoh
;            incoh = self.incoh
;            sincoh = self.sincoh
;            mag = self.mag
;            smag = self.smag
;            tot = self.tot
;            stot = self.stot
            self->getproperty,  x=px,y=py,sy=psy,$
                                coh=coh,scoh=scoh,$
                                nonmagnetic=nonmagnetic,$
                                mag=mag,smag=smag,$
                                incoh=incoh,$
                                sincoh=sincoh,$
                                tot=tot,$
                                stot=stot

            nonmagnetic = self.nonmagnetic
            x = *px

            tot=*tot
            stot=*stot
            coh = *coh
            scoh = *scoh
            incoh=*incoh
            sincoh=*sincoh


            format = '(7g15.7)'
            header = string('Q','tot','stot','coh','scoh','incoh','sincoh',format='(7A15)')
            if nonmagnetic eq 0 then begin
                mag=*mag
                smag=*smag
                mup = mag + smag
                mdn = mag - smag
                format = '(9g15.7)'
                header = string('Q','tot','stot','coh','scoh',$
                                'incoh','sincoh','mag','smag',$
                                format='(9A15)')
            endif

            openw,lun,fn,/get_lun
            printf,lun,header
            for i=0,n_elements(x)-1 do begin
                if nonmagnetic eq 0 then begin
                    printf,lun,x[i],tot[i],stot[i],$
                                    coh[i],scoh[i],$
                                    incoh[i],sincoh[i],$
                                    mag[i],smag[i],$
                                    format=format
                endif else begin
                    printf,lun,x[i],tot[i],stot[i],$
                                    coh[i],scoh[i],$
                                    incoh[i],sincoh[i],$
                                    format=format
                endelse
            endfor;i
            free_lun,lun

        endif;fn ne ''

end;NSEDiffractionViewerMagnetic_data::writeASCII
;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            coh=coh,scoh=scoh,$
                            nonmagnetic=nonmagnetic,$
                            mag=mag,smag=smag,$
                            incoh=incoh,$
                            sincoh=sincoh,$
                            tot=tot,$
                            stot=stot,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _ref_extra=extra


                if arg_present(coh) gt 0 then coh=self.coh
                if arg_present(scoh) gt 0 then scoh=self.scoh

                if arg_present(nonmagnetic) gt 0 then nonmagnetic = self.nonmagnetic

                if arg_present(mag) gt 0 then mag = self.mag
                if arg_present(smag) gt 0 then smag =self.smag
                if arg_present(incoh) gt 0 then incoh=self.incoh
                if arg_present(sincoh) gt 0 then sincoh=self.sincoh
                if arg_present(tot) gt 0 then tot=self.tot
                if arg_present(stot) gt 0 then stot=self.stot

                self->cwo_drawplot_data::getproperty,$
                                        x=x,$
                                        y=y,$
                                        sy=sy,$
                                        legend=legend,$
                                        color=color,$
                                        psym=psym,$
                                        linestyle=linestyle,$
                                        thesymsize=thesymsize,$
                                        showdata=showdata,$
                                        showlegend=showlegend,$
                                        ebshow=ebshow,$
                                        id=id,$
                                        _extra=extra

end;getproperty
;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data::setproperty,$
                            coh=coh,scoh=scoh,$
                            mag=mag,smag=smag,$
                            incoh=incoh,$
                            sincoh=sincoh,$
                            tot=tot,$
                            stot=stot,$
                            nonmagnetic=nonmagnetic,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _ref_extra=extra

                if n_elements(coh) gt 0 then self.coh=coh
                if n_elements(scoh) gt 0 then self.scoh=scoh

                if n_elements(nonmagnetic) gt 0 then self.nonmagnetic=nonmagnetic

                if n_elements(mag) gt 0 then self.mag=mag
                if n_elements(smag) gt 0 then self.smag=smag
                if n_elements(incoh) gt 0 then self.incoh=incoh
                if n_elements(sincoh) gt 0 then self.sincoh=sincoh
                if n_elements(tot) gt 0 then self.tot=tot
                if n_elements(stot) gt 0 then self.stot=stot

                self->cwo_drawplot_data::setproperty,$
                                        x=x,$
                                        y=y,$
                                        sy=sy,$
                                        legend=legend,$
                                        color=color,$
                                        psym=psym,$
                                        linestyle=linestyle,$
                                        thesymsize=thesymsize,$
                                        showdata=showdata,$
                                        showlegend=showlegend,$
                                        ebshow=ebshow,$
                                        id=id,$
                                        _extra=extra

end;setproperty




;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data::cleanup
    ;print,'NSEDiffractionViewerMagnetic_data::cleanup'
    self->cwo_drawplot_data::cleanup
    ptr_free,self.incoh
    ptr_free,self.sincoh
    ptr_free,self.coh
    ptr_free,self.scoh
    ptr_free,self.mag
    ptr_free,self.smag
    ptr_free,self.tot
    ptr_free,self.stot


end;NSEDiffractionViewerMagnetic_data::cleanup
;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function NSEDiffractionViewerMagnetic_data::init,x,y,sy,$
                                                coh=coh,scoh=scoh,$
                                                mag=mag,smag=smag,$
                                                incoh=incoh,$
                                                sincoh=sincoh,$
                                                tot=tot,$
                                                stot=stot,$
                                                nonmagnetic=nonmagnetic,$
                                                legend=legend,psym=psym,color=color,$
                                                linestyle=linestyle,showdata=showdata,ebshow=ebshow,$
                                                showlegend=showlegend,thesymsize=symsize,id=id,$
                                                _ref_extra=extra


;print,mag
;print,smag
;print,'nonmagnetic=',nonmagnetic
;help,/traceback
    ;INCOHERENT
    if n_elements(y) eq 0 then begin
        y = 0.0*x
        sy = 0.0*x
    endif


    ;CHECK IF NONMAGNETIC.  IF NONMAGNETIC, THEN MAG WILL NOT BE USED IN THE DRAW METHOD.
    if n_elements(nonmagnetic) eq 0 then nonmagnetic = 0
    self.nonmagnetic = nonmagnetic

    ret = self->cwo_drawplot_data::init( x,y,sy,$
                                    legend=legend,psym=psym,color=color,$
                                    linestyle=linestyle,showdata=showdata,ebshow=ebshow,$
                                    showlegend=showlegend,thesymsize=symsize,id=id,$
                                    _extra=extra)



    ;TOTAL
    if n_elements(tot) gt 0 then begin

;print,'init: tot'
        self.tot  = ptr_new([tot])
        if n_elements(stot) ne n_elements(tot) then stot = 0.0*[tot]
        self.stot = ptr_new([stot])
    endif else begin
        self.tot  = ptr_new(0.0*(*self.x))
        self.stot = ptr_new(0.0*(*self.tot))
    endelse


    ;MAGNETIC
    if n_elements(mag) gt 0 then begin
        self.mag  = ptr_new([mag])
        if n_elements(smag) ne n_elements(mag) then smag = 0.0*[mag]
        self.smag = ptr_new([smag])
    endif else begin
        self.mag  = ptr_new(0.0*(*self.x))
        self.smag = ptr_new(0.0*(*self.mag))
    endelse

    ;COHERENT
    if n_elements(coh) gt 0 then begin
;print,'init: coh'
        self.coh  = ptr_new([coh])
        if n_elements(scoh) ne n_elements(coh) then scoh = 0.0*[coh]
        self.scoh = ptr_new([scoh])
    endif else begin
        self.coh  = ptr_new(0.0*(*self.x))
        self.scoh = ptr_new(0.0*(*self.coh))
    endelse

    ;INCOHERENT
    if n_elements(incoh) gt 0 then begin
;print,'init: incoh'

        self.incoh  = ptr_new([incoh])
        if n_elements(sincoh) ne n_elements(incoh) then sincoh = 0.0*[incoh]
        self.sincoh = ptr_new([sincoh])
    endif else begin
        self.incoh  = ptr_new(0.0*(*self.x))
        self.sincoh = ptr_new(0.0*(*self.incoh))
    endelse


    return,1
end;NSEDiffractionViewerMagnetic_data

;###############################################################################
;
;NAME:
;        NSEDiffractionViewerMagnetic_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro NSEDiffractionViewerMagnetic_data__define,class

    class = {   NSEDiffractionViewerMagnetic_data,$
                inherits cwo_drawplot_data,$
                coh:ptr_new(),$
                scoh:ptr_new(),$
                mag:ptr_new(),$
                smag:ptr_new(),$
                incoh:ptr_new(),$
                sincoh:ptr_new(),$
                tot:ptr_new(),$
                stot:ptr_new(),$
                nonmagnetic:0}

end;NSEDiffractionViewerMagnetic_data__define
