;
; NAME:
; Workup_AC_Squid_Data
; DATE of WORKING VERSION: 1 May 2009
;
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;
;
;
; INPUT FIELDS:
;
;
; EXAMPLES FOR POTENTIALS (must use IDL syntax as shown below):
;
;
; DISCLAIMER
;
;     This software is provided as is without any warranty whatsoever.
;     Permission to use, copy, modify, and distribute modified or
;     unmodified copies is granted, provided this disclaimer
;     is included unchanged.
;
; MODIFICATION HISTORY:
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Workup_AC_Squid_Data_cleanup,tlb
widget_control,tlb,get_uvalue = pState
wdelete,(*pState).winState.winPixchip
wdelete,(*pState).winState.winPixchidp
wdelete,(*pState).winState.winPixArgand
wdelete,(*pState).winState.winPixArrhenius
heap_free,pState
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Workup_AC_Squid_Data_quit,event
widget_control,event.top,get_uvalue = pState
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_save,event
widget_control,event.top,get_uvalue = pstate

widget_control,(*pstate).MolarMass_Field,get_value=MolarMass
widget_control,(*pstate).SampleMass_Field,get_value=SampleMass
widget_control,(*pstate).StartTime_Field,get_value=StartTime
widget_control,(*pstate).StaticFields_Field,get_value=StaticField
widget_control,(*pstate).Amplitude_Field,get_value=Amplitude_Field
widget_control,(*pState).purgeChi,get_value = PurgeChi
widget_control,(*pState).MouseActionChip,get_value = MouseActionChip
widget_control,(*pState).MouseActionChidp,get_value = MouseActionChidp
widget_control,(*pState).MouseActionArgand,get_value = MouseActionArgand
widget_control,(*pState).MouseActionArrhenius,get_value = MouseActionArrhenius
widget_control,(*pState).ArgandTemperatureValues_Field,get_value = ArgandTemperatureValues
widget_control,(*pState).Tau0_Field,get_value = Tau0
widget_control,(*pState).Delta_Field,get_value = Delta
weight=(*pstate).weight
duration=(*pstate).duration
DataMaskArraychi=*(*pState).DataMaskArraychi
DataMaskArrayArrhenius=*(*pState).DataMaskArrayArrhenius
indices=*(*pstate).indices
temperature=*(*pstate).temperature
frequency=*(*pstate).frequency
mprime=*(*pstate).mprime
mdprime=*(*pstate).mdprime
n_freq=(*pstate).n_freq
Source_File=(*pstate).Source_File

Save_Info = { Source_File:Source_File, $
         n_freq:n_freq, $
         mdprime:mdprime, $
         mprime:mprime, $
         frequency:frequency, $
         temperature:temperature, $
         indices:indices, $
         DataMaskArrayArrhenius:DataMaskArrayArrhenius, $
         DataMaskArraychi:DataMaskArraychi, $
         duration:duration, $
         weight:weight, $
         Delta:Delta, $
         Tau0:Tau0, $
         ArgandTemperatureValues:ArgandTemperatureValues, $
         MouseActionArrhenius:MouseActionArrhenius, $
         MouseActionArgand:MouseActionArgand, $
         MouseActionChidp:MouseActionChidp, $
         MouseActionChip:MouseActionChip, $
         PurgeChi:PurgeChi, $
         Amplitude_Field:Amplitude_Field, $
         StaticField:StaticField, $
         StartTime:StartTime, $
         SampleMass:SampleMass, $
         MolarMass:MolarMass }


  textLen = strlen((*pstate).Source_File)
    pos=strpos((*pstate).Source_File,(*pstate).delim,/reverse_Search)
textLen-=pos
  FileTitle = strmid((*pstate).Source_File,textLen-2,/reverse_offset)
  dir = strmid((*pstate).Source_File,0,pos)
    pos=strpos(FileTitle,'.')
FileTitle=strmid(FileTitle,0,pos)
FileTitle+='_AC.mac'


filename = DIALOG_PICKFILE(title = 'Save Settings',file=FileTitle,path=dir,/write,filter="*.mac",/fix_filter)

if filename eq '' then return
save, filename=filename, Save_Info

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_restore,event
widget_control,event.top,get_uvalue = pstate
filename=dialog_pickfile(/read,filter="*.mac",/fix_filter,path=(*pstate).workdir)

if filename eq '' then return
restore,filename=filename

widget_control,(*pstate).MolarMass_Field,set_value=Save_Info.MolarMass
widget_control,(*pstate).SampleMass_Field,set_value=Save_Info.SampleMass
widget_control,(*pstate).StartTime_Field,set_value=Save_Info.StartTime
widget_control,(*pstate).StaticFields_Field,set_value=Save_Info.StaticField
widget_control,(*pstate).Amplitude_Field,set_value=Save_Info.Amplitude_Field
widget_control,(*pState).purgeChi,set_value = Save_Info.PurgeChi
widget_control,(*pState).MouseActionChip,set_value = Save_Info.MouseActionChip
widget_control,(*pState).MouseActionChidp,set_value = Save_Info.MouseActionChidp
widget_control,(*pState).MouseActionArgand,set_value = Save_Info.MouseActionArgand
widget_control,(*pState).MouseActionArrhenius,set_value = Save_Info.MouseActionArrhenius
widget_control,(*pState).ArgandTemperatureValues_Field,set_value = Save_Info.ArgandTemperatureValues
widget_control,(*pState).Tau0_Field,set_value = Save_Info.Tau0
widget_control,(*pState).Delta_Field,set_value = Save_Info.Delta

(*pstate).weight=Save_Info.weight
(*pstate).duration=Save_Info.duration
*(*pState).DataMaskArraychi=Save_Info.DataMaskArraychi
*(*pState).DataMaskArrayArrhenius=Save_Info.DataMaskArrayArrhenius
*(*pstate).indices=Save_Info.indices
*(*pstate).temperature=Save_Info.temperature
*(*pstate).frequency=Save_Info.frequency
*(*pstate).mprime=Save_Info.mprime
*(*pstate).mdprime=Save_Info.mdprime
(*pstate).n_freq=Save_Info.n_freq
(*pstate).Source_File=Save_Info.Source_File


if (Save_Info.MolarMass eq '') or (Save_Info.SampleMass eq '') then begin
msg=strarr(1)
msg[0]='Please enter values for Molar Mass and Sample Mass'
    void=dialog_message(dialog_parent=event.top,/error,msg)
return
endif


Workup_AC_Squid_Data_PlotChip,event
Workup_AC_Squid_Data_PlotChidp,event
AC_Squid_Data_PlotArgand,event
AC_Squid_Data_PlotArrhenius,event

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_Squid_Data_PlotArrhenius,event,to_window = to_window

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
widget_control,(*pstate).Tau0_Field,set_value = 'Fit'
widget_control,(*pstate).delta_Field,set_value = 'Fail'
return
endif

widget_control,event.top,get_uvalue = pState

lnTau=fltarr((*pstate).n_freq)
Trec=fltarr((*pstate).n_freq)

m=0
for i = 0, (*pstate).n_freq-1 do begin
mask=where((*(*pstate).DataMaskArraychi)[m:(*(*pstate).indices)[i]] eq 1)
mask+=m
;
xwin=(*(*pstate).temperature)[mask]
ywin=(*(*pstate).mdprime)[mask]
;
A0=max((*(*pstate).mdprime)[mask],Max_Subscript)
A1=(((*(*pstate).temperature)[mask])[Max_Subscript])
xmin_max=max(xwin, min=xwin_min)
;A1=((xmin_max-xwin_min)/2.0)+xwin_min ;midpoint
A2=((max(xwin)-min(xwin))/12.0) ;width
;print,'A2 = ',A2
A3=0.0
A4=0.0
estimates=[A0,A1,A2,A3,A4]
yfit=gaussfit(xwin,ywin,coeff,chisq=chisq,estimates=estimates,sigma=sigma,nterms=5)
;
Trec[i]=1/coeff[1]
;
;void=max((*(*pstate).mdprime)[mask],Max_Subscript)
;Trec[i]=1/(((*(*pstate).temperature)[mask])[Max_Subscript])
lnTau[i]=alog(1/(*(*pstate).frequency)[m])
m=(*(*pstate).indices)[i]+1
endfor

mask=where(*(*pstate).DataMaskArrayArrhenius eq 1)
Trec=Trec[mask]
lnTau=lnTau[mask]

if (*pState).winState.autoscaleArrhenius eq 1 then begin
  xlo = min(Trec, max = xhi)
  ylo = min(lnTau, max = yhi)
  (*pState).winState.xrangeArrhenius = [xlo,xhi]
  (*pState).winState.yrangeArrhenius = [ylo,yhi]
endif


    if NOT keyword_set(to_window) then wset,(*pState).winState.winPixArrhenius

    plot,Trec,lnTau,title='Arrhenius Plot.  Tau vs. 1/T', $
      xrange = (*pstate).winState.xrangeArrhenius,yrange = (*pstate).winState.yrangeArrhenius, $
      xstyle = 1,ystyle = 1,thick = 3.0,psym=-1,xtitle='1 / T',ytitle='ln(Tau)'

coeff=poly_fit(Trec,lnTau,1,Chisq=Chisq,Sigma=Sigma,Status=Status,yfit=yfit)

if Status ne 0 then begin
;msg=strarr(1)
;msg[0]=''
;    void=dialog_message(dialog_parent=event.top,/error,msg)
widget_control,(*pstate).Tau0_Field,set_value = 'Fit'
widget_control,(*pstate).delta_Field,set_value = 'Fail'
return
endif

oplot,Trec,yfit,linestyle = 0, thick = 3.0, psym=-4, symsize=1.0,color=fsc_color('blue')
;Sigma[0]=exp(-coeff[0]-Sigma[0])-exp(-coeff[0])
tau0=strtrim(string(exp(coeff[0])),2)+'+-'+strtrim(string(exp(coeff[0])*(-sigma[0]/coeff[0])),2)
;print,exp(-sigma[0])
delta=strtrim(string(coeff[1]),2)+'+-'+strtrim(string(Sigma[1]),2)
widget_control,(*pstate).Tau0_Field,set_value = tau0
widget_control,(*pstate).delta_Field,set_value = delta

xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.6
ypos=ylims[0]+(ylims[1]-ylims[0])*0.9
xyouts,xpos,ypos,"Chisq = "+strtrim(string(chisq),2) ,color=fsc_color('red')

ArrheniusStruc={Trec:Trec, $
                lnTau:lnTau, $
                Chisq:Chisq, $
                yfit:yfit}
                
*(*pstate).ArrheniusStruc=ArrheniusStruc

if NOT keyword_set(to_window) then begin
wset,(*pState).winState.winVisArrhenius
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
endif
        (*pState).pix = 4

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_Squid_Data_PlotArgand,event,to_window = to_window
widget_control,event.top,get_uvalue = pState

mask=where(*(*pstate).DataMaskArraychi eq 1)

widget_control,(*pstate).ArgandTemperatureValues_Field,get_value = ArgandTemperature

Temperature_SH=strsplit(ArgandTemperature,',',/extract)
Temperature_SH=float(Temperature_SH)

mprime=(*(*pstate).mprime)[mask]
mdprime=(*(*pstate).mdprime)[mask]
temperature=(*(*pstate).temperature)[mask]
;temp_orig=temperature
n_temperature=n_elements(temperature)
n_temperature_SH=n_elements(temperature_SH)
ut=1+bytarr(n_temperature)
utSH=1+bytarr(n_temperature_SH)
diff=abs(ut#temperature_SH-temperature#utSH)
index_map=intarr(n_temperature)
for i=0,n_temperature-1 do begin
void=min(diff[i,*],ind)
index_map[i]=ind
endfor
for i = 0, n_temperature-1 do begin
temperature[i]=temperature_SH[index_map[i]]
;print,temp_orig[i],temperature_SH[index_map[i]],temperature[i]
endfor



temperaturesort=sort(temperature)
temperature=temperature[temperaturesort]
mprime=mprime[temperaturesort]
mdprime=mdprime[temperaturesort]
indices=uniq(temperature)
n_temp=n_elements(indices)
m=0
new_temperature=dblarr(n_temperature)
new_mprime=dblarr(n_temperature)
new_mdprime=dblarr(n_temperature)

for j = 0, n_temp-1 do begin
array=temperature[m:indices[j]]
sorttemp=sort(array)
array=array[sorttemp]
new_temperature[m:indices[j]]=array
array=mprime[m:indices[j]]
array=array[sorttemp]
new_mprime[m:indices[j]]=array
array=mdprime[m:indices[j]]
array=array[sorttemp]
new_mdprime[m:indices[j]]=array
m=indices[j]+1
endfor


if (*pState).winState.autoscaleArgand eq 1 then begin
  xlo = min(*(*pstate).mprime, max = xhi)
  ylo = min(*(*pstate).mdprime, max = yhi)
  (*pState).winState.xrangeArgand = [xlo,xhi]
  (*pState).winState.yrangeArgand = [ylo,yhi]
endif

    if NOT keyword_set(to_window) then wset,(*pState).winState.winPixArgand

xpos=0.7
ypos=0.95
charsize=1.0

x=new_mprime[0:indices[0]]
ind=sort(x)
x=x[ind]
y=(new_mdprime[0:indices[0]])[ind]

    plot,x,y,title='Cole-Cole Argand Plot.  Chi'''' vs. Chi''', $
      xrange = (*pstate).winState.xrangeArgand,yrange = (*pstate).winState.yrangeArgand, $
      xstyle = 1,ystyle = 1,psym=-1,xtitle='Chi'' / mole',ytitle='Chi'''' / mole'

legend_text=strtrim(string(temperature[0]),2)+' K'
mylegend_orig, xpos,ypos,legend_text,psym=1,charsize=charsize


m=indices[0]+1
k=-1
for j = 1, n_temp -1 do begin
x=new_mprime[m:indices[j]]
ind=sort(x)
x=x[ind]
y=(new_mdprime[m:indices[j]])[ind]
k-=1
if k eq -3 then k=-4
if k eq -7 then k=-1
;print,'k = ',k
;print,'x ',x
;print,'y ',y
oplot,x,y,psym=k
legend_text=strtrim(string(temperature[m]),2)+' K'
mylegend_orig, xpos,ypos-0.05*j,legend_text,psym=-k,charsize=charsize
m=indices[j]+1
endfor




if NOT keyword_set(to_window) then begin
wset,(*pState).winState.winVisArgand
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
endif
        (*pState).pix = 3
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Workup_AC_Squid_Data_PlotChidp,event,to_window = to_window

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
msg=strarr(1)
msg[0]='Too few data points to complete chi'''' plot '
    void=dialog_message(dialog_parent=event.top,/error,msg)
return
endif

widget_control,event.top,get_uvalue = pState



mask=where((*(*pstate).DataMaskArraychi)[0:(*(*pstate).indices)[0]] eq 1)

x=(*(*pstate).temperature)[mask]
y=(*(*pstate).mdprime)[mask]

if (*pState).winState.autoscaleChidp eq 1 then begin
  xlo = min(*(*pstate).temperature, max = xhi)
  ylo = min(*(*pstate).mdprime, max = yhi)
  (*pState).winState.xrangeChidp = [xlo,xhi]
  (*pState).winState.yrangeChidp = [ylo,yhi]
endif

    if NOT keyword_set(to_window) then wset,(*pState).winState.winPixChidp

xpos=0.7
ypos=0.95
charsize=1.0

    plot,x,y,title='Chi'''' vs. Temperature', $
      xrange = (*pstate).winState.xrangeChidp,yrange = (*pstate).winState.yrangeChidp, $
      xstyle = 1,ystyle = 1,psym=-1,xtitle='Temperature / K',ytitle='Chi'''' / mole'

legend_text=strtrim(string((*(*pstate).frequency)[0]),2)+' Hz'
mylegend_orig, xpos,ypos,legend_text,psym=1,charsize=charsize;,shape=0,fill=0,CONVERT_SYMBOL=0

m=(*(*pstate).indices)[0]+1
k=-1
for j = 1, (*pState).n_freq -1 do begin
mask=where((*(*pstate).DataMaskArraychi)[m:(*(*pstate).indices)[j]] eq 1)
mask+=m
x=(*(*pstate).temperature)[mask]
y=(*(*pstate).mdprime)[mask]
k-=1
if k eq -3 then k=-4
if k eq -7 then k=-1
;print,'k = ',k
oplot,x,y,psym=k
legend_text=strtrim(string((*(*pstate).frequency)[m]),2)+' Hz'
mylegend_orig, xpos,ypos-0.05*j,legend_text,psym=-k,charsize=charsize
m=(*(*pstate).indices)[j]+1
endfor

if NOT keyword_set(to_window) then begin
wset,(*pState).winState.winVisChidp
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
endif
        (*pState).pix = 2
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Workup_AC_Squid_Data_PlotChip,event,to_window = to_window

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
msg=strarr(1)
msg[0]='Too few data points to complete chi'' plot '
    void=dialog_message(dialog_parent=event.top,/error,msg)
    ACReset,event
return
endif

widget_control,event.top,get_uvalue = pState


;*(*pstate).indices=indices
;*(*pstate).temperature=new_temperature
;*(*pstate).frequency=new_freq
;*(*pstate).mprime=new_mprime
;*(*pstate).mdprime=new_mdprime

;print,'*(*pstate).indices[0] ',*(*pstate).indices[0]
;print,'(*(*pstate)).indices[0] ',(*(*pstate)).indices[0]
;print,'(*(*pstate).indices)[0] ',(*(*pstate).indices)[0]
;print,'*(*pstate).temperature[0:*(*pstate).indices[0]]] ',(*(*pstate).temperature)[0:(*(*pstate).indices)[0]]
;print,'*(*pstate).mprime[0:*(*pstate).indices[0]]] ',(*(*pstate).mprime)[0:(*(*pstate).indices)[0]]

mask=where((*(*pstate).DataMaskArraychi)[0:(*(*pstate).indices)[0]] eq 1)

;temperature=(*(*pstate).temperature)[where(*(*pstate).DataMaskArraychi eq 1)]
;mprime=(*(*pstate).mprime)[where(*(*pstate).DataMaskArraychi eq 1)]

x=(*(*pstate).temperature)[mask]
y=(*(*pstate).mprime)[mask]

;for j = 0, n_freq-1 do begin
;array=temperature[m:indices[j]]
;sorttemp=sort(array)
;array=array[sorttemp]
;new_temperature[m:indices[j]]=array
;array=frequency[m:indices[j]]
;array=array[sorttemp]
;new_freq[m:indices[j]]=array
;array=mprime[m:indices[j]]
;array=array[sorttemp]
;new_mprime[m:indices[j]]=array
;array=mdprime[m:indices[j]]
;array=array[sorttemp]
;new_mdprime[m:indices[j]]=array
;m=indices[j]+1
;endfor



if (*pState).winState.autoscaleChip eq 1 then begin
  xlo = min(*(*pstate).temperature, max = xhi)
  ylo = min(*(*pstate).mprime, max = yhi)
  (*pState).winState.xrangeChip = [xlo,xhi]
  (*pState).winState.yrangeChip = [ylo,yhi]
endif

    if NOT keyword_set(to_window) then wset,(*pState).winState.winPixChip

xpos=0.7
ypos=0.95
charsize=1.0

    plot,x,y,title='Chi'' vs. Temperature', $
      xrange = (*pstate).winState.xrangeChip,yrange = (*pstate).winState.yrangeChip, $
      xstyle = 1,ystyle = 1,psym=-1,xtitle='Temperature / K',ytitle='Chi'' / mole'

legend_text=strtrim(string((*(*pstate).frequency)[0]),2)+' Hz'
mylegend_orig, xpos,ypos,legend_text,psym=1,charsize=charsize;,shape=0,fill=0,CONVERT_SYMBOL=0

m=(*(*pstate).indices)[0]+1
k=-1
for j = 1, (*pState).n_freq -1 do begin
mask=where((*(*pstate).DataMaskArraychi)[m:(*(*pstate).indices)[j]] eq 1)
mask+=m
x=(*(*pstate).temperature)[mask]
y=(*(*pstate).mprime)[mask]
k-=1
if k eq -3 then k=-4
if k eq -7 then k=-1
;print,'k = ',k
oplot,x,y,psym=k
legend_text=strtrim(string((*(*pstate).frequency)[m]),2)+' Hz'
mylegend_orig, xpos,ypos-0.05*j,legend_text,psym=-k,charsize=charsize
m=(*(*pstate).indices)[j]+1
endfor

if NOT keyword_set(to_window) then begin
wset,(*pState).winState.winVisChip
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
endif

        (*pState).pix = 1

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ArrheniusReset,event
widget_control,event.top,get_uvalue = pState
(*(*pState).DataMaskArrayArrhenius)[*]=1
(*pState).winState.autoscaleArrhenius=1
AC_Squid_Data_PlotArrhenius,event

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ACReset,event
widget_control,event.top,get_uvalue = pState



(*(*pState).DataMaskArraychi)[*]=1
(*(*pState).DataMaskArrayArrhenius)[*]=1
;Workup_AC_Squid_Data_PlotChip,event
;Workup_AC_Squid_Data_PlotChidp,event
widget_control,(*pState).purgeChi,set_value = ''
(*pState).winState.autoscaleChip=1
(*pState).winState.autoscaleChidp=1
(*pState).winState.autoscaleArgand=1
(*pState).winState.autoscaleArrhenius=1
Workup_AC_Squid_Data_PlotChip,event
Workup_AC_Squid_Data_PlotChidp,event
AC_Squid_Data_PlotArgand,event
AC_Squid_Data_PlotArrhenius,event
(*pState).winState.mouse = 0B


end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Arrhenius_remove_points,event
widget_control,event.top,get_uvalue = pState

xrangedel=(*pState).winState.xrangedelArrhenius
yrangedel=(*pState).winState.yrangedelArrhenius
DataMaskArray=*(*pState).DataMaskArrayArrhenius

y=fltarr((*pstate).n_freq)
x=fltarr((*pstate).n_freq)

m=0
for i = 0, (*pstate).n_freq-1 do begin
mask=where((*(*pstate).DataMaskArraychi)[m:(*(*pstate).indices)[i]] eq 1)
mask+=m
void=max((*(*pstate).mdprime)[mask],Max_Subscript)
x[i]=1/(((*(*pstate).temperature)[mask])[Max_Subscript])
y[i]=alog(1/(*(*pstate).frequency)[m])
m=(*(*pstate).indices)[i]+1
endfor

Newmask=(x ge xrangedel[0]) and $
    (x le xrangedel[1]) and $
    (y ge yrangedel[0]) and $
    (y le yrangedel[1])

DataMaskArray-=Newmask
whereneg=where(DataMaskArray lt 0,count)
if count ne 0 then DataMaskArray[whereneg]=0
wherezero=where(DataMaskArray eq 0,count)
num=n_elements(y)-count

if num le 2 then begin
ACReset,event
return
endif

*(*pState).DataMaskArrayArrhenius=DataMaskArray

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_remove_points,event
widget_control,event.top,get_uvalue = pState


case (*pState).pix of
1:   $
begin
xrangedel=(*pState).winState.xrangedelChip
yrangedel=(*pState).winState.yrangedelChip
x=*(*pState).temperature
y=*(*pState).mprime
DataMaskArray=*(*pState).DataMaskArraychi
end
2:   $
begin
xrangedel=(*pState).winState.xrangedelChidp
yrangedel=(*pState).winState.yrangedelChidp
x=*(*pState).temperature
y=*(*pState).mdprime
DataMaskArray=*(*pState).DataMaskArraychi
end
3:   $
begin
xrangedel=(*pState).winState.xrangedelArgand
yrangedel=(*pState).winState.yrangedelArgand
x=*(*pState).mprime
y=*(*pState).mdprime
DataMaskArray=*(*pState).DataMaskArraychi
end
;4:   $
;begin
;end
else:  $
return
endcase

Newmask=(x ge xrangedel[0]) and $
    (x le xrangedel[1]) and $
    (y ge yrangedel[0]) and $
    (y le yrangedel[1])

DataMaskArray-=Newmask
whereneg=where(DataMaskArray lt 0,count)
if count ne 0 then DataMaskArray[whereneg]=0
wherezero=where(DataMaskArray eq 0,count)
num=n_elements(y)-count
if num le 2 then begin
ACReset,event
return
endif

n=n_elements(wherezero)

*(*pState).DataMaskArraychi=DataMaskArray
widget_control,(*pState).purgeChi,set_value = strtrim(string(n),2)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ACChip_MouseEvents,event

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
return
endif


widget_control,event.top,get_uvalue = pState

if strlowcase(size(*(*pstate).temperature,/tname)) eq 'undefined' then return

if (*pState).pix ne 1 then begin
        Workup_AC_Squid_Data_PlotChip,event
(*pState).pix = 1
endif


widget_control,(*pState).MouseActionChip,get_value = val
IF val EQ 0 THEN BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleChip = 1
        wset,(*pState).winState.winPixChip
        Workup_AC_Squid_Data_PlotChip,event
        wset,(*pState).winState.winvischip
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxChip[0] = event.x
        (*pState).winState.yboxchip[0] = event.y
        wset,(*pState).winState.winvischip
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
        empty
        (*pState).winState.autoscaleChip = 0
        widget_control,(*pState).winState.winchip,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxChip[0] < (*pState).winState.xboxChip[1]
      yll = (*pState).winState.yboxchip[0] < (*pState).winState.yboxchip[1]
      w = abs((*pState).winState.xboxChip[1] - (*pState).winState.xboxChip[0])
      h = abs((*pState).winState.yboxchip[1] - (*pState).winState.yboxchip[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).winState.xrangechip = [ll[0],ur[0]]
      (*pState).winState.yrangechip = [ll[1],ur[1]]
      wset,(*pState).winState.winPixChip
        Workup_AC_Squid_Data_PlotChip,event
      wset,(*pState).winState.winvischip
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixChip
         Workup_AC_Squid_Data_PlotChip,event
      wset,(*pState).winState.winvischip
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion


      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxChip[1] = event.x
       (*pState).winState.yboxchip[1] = event.y
       xc = [(*pState).winState.xboxChip[0],event.x,event.x,$
             (*pState).winState.xboxChip[0],$
             (*pState).winState.xboxChip[0]]
       yc = [(*pState).winState.yboxchip[0],(*pState).winState.yboxchip[0],$
             event.y,event.y,$
             (*pState).winState.yboxchip[0]]
       wset,(*pState).winState.winvischip
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
ENDIF ELSE BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleChip = 1
        wset,(*pState).winState.winPixChip
        Workup_AC_Squid_Data_PlotChip,event
        wset,(*pState).winState.winvischip
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxChip[0] = event.x
        (*pState).winState.yboxchip[0] = event.y
        wset,(*pState).winState.winvischip
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
        empty
        (*pState).winState.autoscaleChip = 0
        widget_control,(*pState).winState.winChip,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxChip[0] < (*pState).winState.xboxChip[1]
      yll = (*pState).winState.yboxchip[0] < (*pState).winState.yboxchip[1]
      w = abs((*pState).winState.xboxChip[1] - (*pState).winState.xboxChip[0])
      h = abs((*pState).winState.yboxchip[1] - (*pState).winState.yboxchip[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)

            ;Here we add some new code
      (*pState).winState.xrangedelchip = [ll[0],ur[0]]
      (*pState).winState.yrangedelchip = [ll[1],ur[1]]


      AC_remove_points,event
      Workup_AC_Squid_Data_PlotChidp,event
      Workup_AC_Squid_Data_PlotChip,event
      AC_Squid_Data_PlotArgand,event
      AC_Squid_Data_PlotArrhenius,event
      (*pState).winState.mouse = 0B
      ;widget_control,(*pState).winState.win,draw_motion_events = 0

     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixChip
         Workup_AC_Squid_Data_PlotChip,event
      wset,(*pState).winState.winvischip
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
      (*pState).winState.mouse = 0B
      widget_control,(*pState).winState.winChip,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion

      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxChip[1] = event.x
       (*pState).winState.yboxchip[1] = event.y
       xc = [(*pState).winState.xboxChip[0],event.x,event.x,$
             (*pState).winState.xboxChip[0],$
             (*pState).winState.xboxChip[0]]
       yc = [(*pState).winState.yboxChip[0],(*pState).winState.yboxChip[0],$
             event.y,event.y,$
             (*pState).winState.yboxChip[0]]
       wset,(*pState).winState.winvisChip
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChip]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase

ENDELSE


;case event.type of
;0:  begin       ; button press
;      (*pState).Winstate.mouse = event.press
;      if (*pState).Winstate.mouse eq 4 then begin
;        (*pState).Winstate.autoscaleChip = 1
;        Workup_AC_Squid_Data_PlotChip,event
;      endif
;      if (*pState).Winstate.mouse eq 1 then begin
;        (*pState).Winstate.xboxChip[0] = event.x
;        (*pState).Winstate.yboxChip[0] = event.y
;        wset,(*pState).Winstate.winVisChip
;        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).Winstate.winPixChip]
;        empty
;        (*pState).Winstate.autoscaleChip = 0
;        widget_control,(*pState).Winstate.winChip,/draw_motion_events
;      endif
;    end
;1:  begin    ; button release
;     if (*pState).Winstate.mouse eq 1 then begin
;      xll = (*pState).Winstate.xboxchip[0] < (*pState).Winstate.xboxchip[1]
;      yll = (*pState).Winstate.yboxchip[0] < (*pState).Winstate.yboxchip[1]
;      w = abs((*pState).Winstate.xboxchip[1] - (*pState).Winstate.xboxchip[0])
;      h = abs((*pState).Winstate.yboxchip[1] - (*pState).Winstate.yboxchip[0])
;      xur = xll + w
;      yur = yll + h
;      ll = convert_coord(xll,yll,/device,/to_data)
;      ur = convert_coord(xur,yur,/device,/to_data)
;      (*pState).Winstate.xrangeChip = [ll[0],ur[0]]
;      (*pState).Winstate.yrangeChip = [ll[1],ur[1]]
;        Workup_AC_Squid_Data_PlotChip,event
;      (*pState).Winstate.mouse = 0B
;      widget_control,(*pState).Winstate.winChip,draw_motion_events = 0
;     endif
;     if (*pState).Winstate.mouse eq 4 then begin
;        Workup_AC_Squid_Data_PlotChip,event
;      (*pState).Winstate.mouse = 0B
;      widget_control,(*pState).Winstate.winChip,draw_motion_events = 0
;     endif
;    end
;2:  begin    ; mouse motion
;      if (*pState).Winstate.mouse eq 1 then begin
;       (*pState).Winstate.xboxchip[1] = event.x
;       (*pState).Winstate.yboxchip[1] = event.y
;       xc = [(*pState).Winstate.xboxchip[0],event.x,event.x,$
;             (*pState).Winstate.xboxchip[0],$
;             (*pState).Winstate.xboxchip[0]]
;       yc = [(*pState).Winstate.yboxchip[0],(*pState).Winstate.yboxchip[0],$
;             event.y,event.y,$
;             (*pState).Winstate.yboxchip[0]]
;       wset,(*pState).Winstate.winVisChip
;       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).Winstate.winPixchip]
;       plots,xc,yc,/device
;       empty
;      endif
;    end
;else:
;endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ACChidp_MouseEvents,event

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
return
endif


widget_control,event.top,get_uvalue = pState

if strlowcase(size(*(*pstate).temperature,/tname)) eq 'undefined' then return


if (*pState).pix ne 2 then begin
        Workup_AC_Squid_Data_PlotChidp,event
(*pState).pix = 2
endif


widget_control,(*pState).MouseActionChidp,get_value = val
IF val EQ 0 THEN BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleChidp = 1
        wset,(*pState).winState.winPixChidp
        Workup_AC_Squid_Data_PlotChidp,event
        wset,(*pState).winState.winvisChidp
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxChidp[0] = event.x
        (*pState).winState.yboxChidp[0] = event.y
        wset,(*pState).winState.winvisChidp
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
        empty
        (*pState).winState.autoscaleChidp = 0
        widget_control,(*pState).winState.winChidp,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxChidp[0] < (*pState).winState.xboxChidp[1]
      yll = (*pState).winState.yboxChidp[0] < (*pState).winState.yboxChidp[1]
      w = abs((*pState).winState.xboxChidp[1] - (*pState).winState.xboxChidp[0])
      h = abs((*pState).winState.yboxChidp[1] - (*pState).winState.yboxChidp[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).winState.xrangeChidp = [ll[0],ur[0]]
      (*pState).winState.yrangeChidp = [ll[1],ur[1]]
      wset,(*pState).winState.winPixChidp
        Workup_AC_Squid_Data_PlotChidp,event
      wset,(*pState).winState.winvisChidp
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixChidp
         Workup_AC_Squid_Data_PlotChidp,event
      wset,(*pState).winState.winvisChidp
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion

      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxChidp[1] = event.x
       (*pState).winState.yboxChidp[1] = event.y
       xc = [(*pState).winState.xboxChidp[0],event.x,event.x,$
             (*pState).winState.xboxChidp[0],$
             (*pState).winState.xboxChidp[0]]
       yc = [(*pState).winState.yboxChidp[0],(*pState).winState.yboxChidp[0],$
             event.y,event.y,$
             (*pState).winState.yboxChidp[0]]
       wset,(*pState).winState.winvisChidp
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
ENDIF ELSE BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleChidp = 1
        wset,(*pState).winState.winPixChidp
        Workup_AC_Squid_Data_PlotChidp,event
        wset,(*pState).winState.winvisChidp
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxChidp[0] = event.x
        (*pState).winState.yboxChidp[0] = event.y
        wset,(*pState).winState.winvisChidp
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
        empty
        (*pState).winState.autoscaleChidp = 0
        widget_control,(*pState).winState.winChidp,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxChidp[0] < (*pState).winState.xboxChidp[1]
      yll = (*pState).winState.yboxChidp[0] < (*pState).winState.yboxChidp[1]
      w = abs((*pState).winState.xboxChidp[1] - (*pState).winState.xboxChidp[0])
      h = abs((*pState).winState.yboxChidp[1] - (*pState).winState.yboxChidp[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)

            ;Here we add some new code
      (*pState).winState.xrangedelChidp = [ll[0],ur[0]]
      (*pState).winState.yrangedelChidp = [ll[1],ur[1]]


      AC_remove_points,event
      Workup_AC_Squid_Data_PlotChip,event
      Workup_AC_Squid_Data_PlotChidp,event
      AC_Squid_Data_PlotArgand,event
      AC_Squid_Data_PlotArrhenius,event
      (*pState).winState.mouse = 0B
      ;widget_control,(*pState).winState.win,draw_motion_events = 0

     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixChidp
         Workup_AC_Squid_Data_PlotChidp,event
      wset,(*pState).winState.winvisChidp
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
      (*pState).winState.mouse = 0B
      widget_control,(*pState).winState.winChidp,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion

      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxChidp[1] = event.x
       (*pState).winState.yboxChidp[1] = event.y
       xc = [(*pState).winState.xboxChidp[0],event.x,event.x,$
             (*pState).winState.xboxChidp[0],$
             (*pState).winState.xboxChidp[0]]
       yc = [(*pState).winState.yboxChidp[0],(*pState).winState.yboxChidp[0],$
             event.y,event.y,$
             (*pState).winState.yboxChidp[0]]
       wset,(*pState).winState.winvisChidp
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixChidp]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase

ENDELSE

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ACArrhenius_MouseEvents,event

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
return
endif


widget_control,event.top,get_uvalue = pState
if strlowcase(size(*(*pstate).temperature,/tname)) eq 'undefined' then return

if (*pState).pix ne 4 then begin
        AC_Squid_Data_PlotArrhenius,event
(*pState).pix = 4
endif


widget_control,(*pState).MouseActionArrhenius,get_value = val
IF val EQ 0 THEN BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleArrhenius = 1
        wset,(*pState).winState.winPixArrhenius
        AC_Squid_Data_PlotArrhenius,event
        wset,(*pState).winState.winvisArrhenius
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxArrhenius[0] = event.x
        (*pState).winState.yboxArrhenius[0] = event.y
        wset,(*pState).winState.winvisArrhenius
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
        empty
        (*pState).winState.autoscaleArrhenius = 0
        widget_control,(*pState).winState.winArrhenius,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxArrhenius[0] < (*pState).winState.xboxArrhenius[1]
      yll = (*pState).winState.yboxArrhenius[0] < (*pState).winState.yboxArrhenius[1]
      w = abs((*pState).winState.xboxArrhenius[1] - (*pState).winState.xboxArrhenius[0])
      h = abs((*pState).winState.yboxArrhenius[1] - (*pState).winState.yboxArrhenius[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).winState.xrangeArrhenius = [ll[0],ur[0]]
      (*pState).winState.yrangeArrhenius = [ll[1],ur[1]]
      wset,(*pState).winState.winPixArrhenius
        AC_Squid_Data_PlotArrhenius,event
      wset,(*pState).winState.winvisArrhenius
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixArrhenius
         AC_Squid_Data_PlotArrhenius,event
      wset,(*pState).winState.winvisArrhenius
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion

      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxArrhenius[1] = event.x
       (*pState).winState.yboxArrhenius[1] = event.y
       xc = [(*pState).winState.xboxArrhenius[0],event.x,event.x,$
             (*pState).winState.xboxArrhenius[0],$
             (*pState).winState.xboxArrhenius[0]]
       yc = [(*pState).winState.yboxArrhenius[0],(*pState).winState.yboxArrhenius[0],$
             event.y,event.y,$
             (*pState).winState.yboxArrhenius[0]]
       wset,(*pState).winState.winvisArrhenius
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
ENDIF ELSE BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleArrhenius = 1
        wset,(*pState).winState.winPixArrhenius
        AC_Squid_Data_PlotArrhenius,event
        wset,(*pState).winState.winvisArrhenius
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxArrhenius[0] = event.x
        (*pState).winState.yboxArrhenius[0] = event.y
        wset,(*pState).winState.winvisArrhenius
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
        empty
        (*pState).winState.autoscaleArrhenius = 0
        widget_control,(*pState).winState.winArrhenius,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxArrhenius[0] < (*pState).winState.xboxArrhenius[1]
      yll = (*pState).winState.yboxArrhenius[0] < (*pState).winState.yboxArrhenius[1]
      w = abs((*pState).winState.xboxArrhenius[1] - (*pState).winState.xboxArrhenius[0])
      h = abs((*pState).winState.yboxArrhenius[1] - (*pState).winState.yboxArrhenius[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)

            ;Here we add some new code
      (*pState).winState.xrangedelArrhenius = [ll[0],ur[0]]
      (*pState).winState.yrangedelArrhenius = [ll[1],ur[1]]


      Arrhenius_remove_points,event
      Workup_AC_Squid_Data_PlotChip,event
      Workup_AC_Squid_Data_PlotChidp,event
      AC_Squid_Data_PlotArgand,event
      AC_Squid_Data_PlotArrhenius,event
      (*pState).winState.mouse = 0B
      ;widget_control,(*pState).winState.win,draw_motion_events = 0

     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixArrhenius
         AC_Squid_Data_PlotArrhenius,event
      wset,(*pState).winState.winvisArrhenius
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
      (*pState).winState.mouse = 0B
      widget_control,(*pState).winState.winArrhenius,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion

      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxArrhenius[1] = event.x
       (*pState).winState.yboxArrhenius[1] = event.y
       xc = [(*pState).winState.xboxArrhenius[0],event.x,event.x,$
             (*pState).winState.xboxArrhenius[0],$
             (*pState).winState.xboxArrhenius[0]]
       yc = [(*pState).winState.yboxArrhenius[0],(*pState).winState.yboxArrhenius[0],$
             event.y,event.y,$
             (*pState).winState.yboxArrhenius[0]]
       wset,(*pState).winState.winvisArrhenius
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArrhenius]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase

ENDELSE


end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ACArgand_MouseEvents,event

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
return
endif


widget_control,event.top,get_uvalue = pState
if strlowcase(size(*(*pstate).temperature,/tname)) eq 'undefined' then return

if (*pState).pix ne 3 then begin
        AC_Squid_Data_PlotArgand,event
(*pState).pix = 3
endif


widget_control,(*pState).MouseActionArgand,get_value = val
IF val EQ 0 THEN BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleArgand = 1
        wset,(*pState).winState.winPixArgand
        AC_Squid_Data_PlotArgand,event
        wset,(*pState).winState.winvisArgand
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxArgand[0] = event.x
        (*pState).winState.yboxArgand[0] = event.y
        wset,(*pState).winState.winvisArgand
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
        empty
        (*pState).winState.autoscaleArgand = 0
        widget_control,(*pState).winState.winArgand,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxArgand[0] < (*pState).winState.xboxArgand[1]
      yll = (*pState).winState.yboxArgand[0] < (*pState).winState.yboxArgand[1]
      w = abs((*pState).winState.xboxArgand[1] - (*pState).winState.xboxArgand[0])
      h = abs((*pState).winState.yboxArgand[1] - (*pState).winState.yboxArgand[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).winState.xrangeArgand = [ll[0],ur[0]]
      (*pState).winState.yrangeArgand = [ll[1],ur[1]]
      wset,(*pState).winState.winPixArgand
        AC_Squid_Data_PlotArgand,event
      wset,(*pState).winState.winvisArgand
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixArgand
         AC_Squid_Data_PlotArgand,event
      wset,(*pState).winState.winvisArgand
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
      (*pState).winState.mouse = 0B
;      widget_control,(*pState).winState.win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion

      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxArgand[1] = event.x
       (*pState).winState.yboxArgand[1] = event.y
       xc = [(*pState).winState.xboxArgand[0],event.x,event.x,$
             (*pState).winState.xboxArgand[0],$
             (*pState).winState.xboxArgand[0]]
       yc = [(*pState).winState.yboxArgand[0],(*pState).winState.yboxArgand[0],$
             event.y,event.y,$
             (*pState).winState.yboxArgand[0]]
       wset,(*pState).winState.winvisArgand
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
ENDIF ELSE BEGIN
case event.type of
0:  begin       ; button press
      (*pState).winState.mouse = event.press
      if (*pState).winState.mouse eq 4 then begin
        (*pState).winState.autoscaleArgand = 1
        wset,(*pState).winState.winPixArgand
        AC_Squid_Data_PlotArgand,event
        wset,(*pState).winState.winvisArgand
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
      endif
      if (*pState).winState.mouse eq 1 then begin
        (*pState).winState.xboxArgand[0] = event.x
        (*pState).winState.yboxArgand[0] = event.y
        wset,(*pState).winState.winvisArgand
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
        empty
        (*pState).winState.autoscaleArgand = 0
        widget_control,(*pState).winState.winArgand,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).winState.mouse eq 1 then begin
      xll = (*pState).winState.xboxArgand[0] < (*pState).winState.xboxArgand[1]
      yll = (*pState).winState.yboxArgand[0] < (*pState).winState.yboxArgand[1]
      w = abs((*pState).winState.xboxArgand[1] - (*pState).winState.xboxArgand[0])
      h = abs((*pState).winState.yboxArgand[1] - (*pState).winState.yboxArgand[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)

            ;Here we add some new code
      (*pState).winState.xrangedelArgand = [ll[0],ur[0]]
      (*pState).winState.yrangedelArgand = [ll[1],ur[1]]


      AC_remove_points,event
      Workup_AC_Squid_Data_PlotChip,event
      Workup_AC_Squid_Data_PlotChidp,event
      AC_Squid_Data_PlotArgand,event
      AC_Squid_Data_PlotArrhenius,event
      (*pState).winState.mouse = 0B
      ;widget_control,(*pState).winState.win,draw_motion_events = 0

     endif
     if (*pState).winState.mouse eq 4 then begin
      wset,(*pState).winState.winPixArgand
         AC_Squid_Data_PlotArgand,event
      wset,(*pState).winState.winvisArgand
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
      (*pState).winState.mouse = 0B
      widget_control,(*pState).winState.winArgand,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion

      if (*pState).winState.mouse eq 1 then begin
       (*pState).winState.xboxArgand[1] = event.x
       (*pState).winState.yboxArgand[1] = event.y
       xc = [(*pState).winState.xboxArgand[0],event.x,event.x,$
             (*pState).winState.xboxArgand[0],$
             (*pState).winState.xboxArgand[0]]
       yc = [(*pState).winState.yboxArgand[0],(*pState).winState.yboxArgand[0],$
             event.y,event.y,$
             (*pState).winState.yboxArgand[0]]
       wset,(*pState).winState.winvisArgand
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winState.winPixArgand]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase

ENDELSE

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Workup_AC_Squid_Data_read,event
widget_control,event.top,get_uvalue = pState

widget_control,(*pstate).MolarMass_Field,get_value=MolarMass
widget_control,(*pstate).SampleMass_Field,get_value=SampleMass
if (MolarMass eq '') or (SampleMass eq '') then begin
msg=strarr(1)
msg[0]='Please enter values for Molar Mass and Sample Mass'
    void=dialog_message(dialog_parent=event.top,/error,msg)
return
endif
MolarMass=float(MolarMass[0])
SampleMass=float(SampleMass[0])
MassFactor=(MolarMass/SampleMass)*1000



delim=(*pstate).delim
Source_File = DIALOG_PICKFILE(title = 'Select Input File',/read,path=(*pstate).workdir)

if Source_File eq '' then return
(*pstate).Source_File=Source_File

nlines=file_lines(Source_File)
weight=''
str=''
line=''
i=0
openr,lun,Source_File,/get_lun
while str ne '[Data]' do begin 
i+=1
readf,lun,line
str=strtrim(line,2)
ind=strpos(str, 'WEIGHT')
if ind[0] ne -1 then begin
Weight=(strsplit(str,',',/extract))[2]
Weight=strtrim(weight,2)
endif
if i eq nlines then return
endwhile
free_lun,lun,/force
;print,'weight: ',weight
(*pstate).weight=weight
data = read_ascii(Source_File,delimiter=',',data_start=i+1)


temperature = reform(data.field01[3,*])
mprime = reform(data.field01[4,*])
mdprime = reform(data.field01[6,*])
frequency = reform(data.field01[14,*])

frequencysort=sort(frequency)
frequency=frequency[frequencysort]
temperature=temperature[frequencysort]
mprime=mprime[frequencysort]
mdprime=mdprime[frequencysort]
n=n_elements(temperature)
indices=uniq(frequency)
n_freq=n_elements(indices)
m=0
new_freq=dblarr(n)
new_temperature=dblarr(n)
new_mprime=dblarr(n)
new_mdprime=dblarr(n)

for j = 0, n_freq-1 do begin
array=temperature[m:indices[j]]
sorttemp=sort(array)
array=array[sorttemp]
new_temperature[m:indices[j]]=array
array=frequency[m:indices[j]]
array=array[sorttemp]
new_freq[m:indices[j]]=array
array=mprime[m:indices[j]]
array=array[sorttemp]
new_mprime[m:indices[j]]=array
array=mdprime[m:indices[j]]
array=array[sorttemp]
new_mdprime[m:indices[j]]=array
m=indices[j]+1
endfor
new_mprime*=MassFactor
new_mdprime*=MassFactor

*(*pstate).indices=indices
*(*pstate).temperature=new_temperature
*(*pstate).frequency=new_freq
*(*pstate).mprime=new_mprime
*(*pstate).mdprime=new_mdprime
(*pstate).n_freq=n_freq


*(*pState).DataMaskArraychi=bytarr(n)+1
*(*pState).DataMaskArrayArrhenius=bytarr(n_freq)+1


widget_control,(*pstate).StartTime_Field,set_value=systime(0,reform(data.field01[0,0]))
(*pstate).Duration=strtrim(string((reform(data.field01[0,n-1])-reform(data.field01[0,0]))/3600.0),2)+' hours'

;
StaticField=reform(data.field01[2,*])
StaticField=StaticField[sort(StaticField)]
UniqueFields=StaticField[uniq(StaticField)]
for i=0,n_elements(UniqueFields)-1 do begin
if i eq 0 then begin
FieldString=strtrim(string(UniqueFields[0]),2)
endif else begin
FieldString+=','+strtrim(string(UniqueFields[i]),2)
endelse
endfor
widget_control,(*pstate).StaticFields_Field,set_value=FieldString
;
Amplitude=reform(data.field01[13,*])
Amplitude=Amplitude[sort(Amplitude)]
UniqueAmplitude=Amplitude[uniq(Amplitude)]
for i=0,n_elements(UniqueAmplitude)-1 do begin
if i eq 0 then begin
AmplitudeString=strtrim(string(UniqueAmplitude[0]),2)
endif else begin
AmplitudeString+=','+strtrim(string(UniqueAmplitude[i]),2)
endelse
endfor
widget_control,(*pstate).Amplitude_Field,set_value=AmplitudeString

Workup_AC_Squid_Data_PlotChip,event
Workup_AC_Squid_Data_PlotChidp,event
AC_Squid_Data_PlotArgand,event
AC_Squid_Data_PlotArrhenius,event

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_SaveArgand,event
widget_control,event.top,get_uvalue = pState

  textLen = strlen((*pstate).Source_File)
    pos=strpos((*pstate).Source_File,(*pstate).delim,/reverse_Search)
textLen-=pos
  FileTitle = strmid((*pstate).Source_File,textLen-2,/reverse_offset)
  dir = strmid((*pstate).Source_File,0,pos)
    pos=strpos(FileTitle,'.')
FileTitle=strmid(FileTitle,0,pos)
FileTitle+='_Argand.txt'
OutputFile = DIALOG_PICKFILE(title = 'Select Output File',file=FileTitle,path=dir,/write)
if OutputFile eq '' then return


;OutputFile=dir+delim+FileTitle


mask=where(*(*pstate).DataMaskArraychi eq 1)

widget_control,(*pstate).ArgandTemperatureValues_Field,get_value = ArgandTemperature

Temperature_SH=strsplit(ArgandTemperature,',',/extract)
Temperature_SH=float(Temperature_SH)


mprime=(*(*pstate).mprime)[mask]
mdprime=(*(*pstate).mdprime)[mask]
temperature=(*(*pstate).temperature)[mask]
frequency=(*(*pstate).frequency)[mask]
;temp_orig=temperature
n_temperature=n_elements(temperature)
n_temperature_SH=n_elements(temperature_SH)
ut=1+bytarr(n_temperature)
utSH=1+bytarr(n_temperature_SH)
diff=abs(ut#temperature_SH-temperature#utSH)
index_map=intarr(n_temperature)
for i=0,n_temperature-1 do begin
void=min(diff[i,*],ind)
index_map[i]=ind
endfor
for i = 0, n_temperature-1 do begin
temperature[i]=temperature_SH[index_map[i]]
;print,temp_orig[i],temperature_SH[index_map[i]],temperature[i]
endfor

temperaturesort=sort(temperature)
temperature=temperature[temperaturesort]
mprime=mprime[temperaturesort]
mdprime=mdprime[temperaturesort]
frequency=frequency[temperaturesort]
n=n_elements(temperature)
indices=uniq(temperature)
n_temp=n_elements(indices)
m=0
new_temperature=dblarr(n)
new_mprime=dblarr(n)
new_mdprime=dblarr(n)
new_frequency=dblarr(n)

for j = 0, n_temp-1 do begin
array=temperature[m:indices[j]]
sorttemp=sort(array)
array=array[sorttemp]
new_temperature[m:indices[j]]=array
array=frequency[m:indices[j]]
array=array[sorttemp]
new_frequency[m:indices[j]]=array
array=mprime[m:indices[j]]
array=array[sorttemp]
new_mprime[m:indices[j]]=array
array=mdprime[m:indices[j]]
array=array[sorttemp]
new_mdprime[m:indices[j]]=array
m=indices[j]+1
endfor

temperature=new_temperature
frequency=new_frequency
mprime=new_mprime
mdprime=new_mdprime

m=0
for j = 0, n_temp-1 do begin
array=mprime[m:indices[j]]
sortmprime=sort(array)
array=array[sortmprime]
new_mprime[m:indices[j]]=array
array=temperature[m:indices[j]]
array=array[sortmprime]
new_temperature[m:indices[j]]=array
array=frequency[m:indices[j]]
array=array[sortmprime]
new_frequency[m:indices[j]]=array
array=mprime[m:indices[j]]
array=array[sortmprime]
new_mprime[m:indices[j]]=array
array=mdprime[m:indices[j]]
array=array[sortmprime]
new_mdprime[m:indices[j]]=array
m=indices[j]+1
endfor

format_float = '(e-15.5,2x,e-15.5,2x,e-15.5,2x,e-15.5)'

widget_control,(*pstate).MolarMass_Field,get_value=MolarMass
widget_control,(*pstate).SampleMass_Field,get_value=SampleMass
widget_control,(*pstate).Amplitude_Field,get_value=AmplitudeString
widget_control,(*pstate).StaticFields_Field,get_value=FieldString

nx=n_elements(temperature)
    openw,lun,OutputFile,/get_lun
printf,lun,'# SQUID File: '+(*pstate).Source_File              
printf,lun,'# Sample Mass Entered in Program: '+SampleMass             
printf,lun,'# Sample Mass Entered in SQUID File: '+(*pstate).weight             
printf,lun,'# Molar Mass: '+MolarMass              
printf,lun,'# Static Fields / Oe: '+FieldString              
printf,lun,'# Amplitude Fields / Oe: '+AmplitudeString              
printf,lun,'# Measurement Duration: '+(*pstate).duration              
printf,lun,'# Temperature values have been binned'              
    printf,lun,'temperature          Chi''             Chi''''        Frequency / Hz   '              
    for i = 0, nx-1 do begin
    printf,lun,new_temperature[i],new_mprime[i],new_mdprime[i],new_frequency[i],format = format_float
    endfor
    free_lun,lun,/force


end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_SaveArrhenius,event
widget_control,event.top,get_uvalue = pState

  textLen = strlen((*pstate).Source_File)
    pos=strpos((*pstate).Source_File,(*pstate).delim,/reverse_Search)
textLen-=pos
  FileTitle = strmid((*pstate).Source_File,textLen-2,/reverse_offset)
  dir = strmid((*pstate).Source_File,0,pos)
    pos=strpos(FileTitle,'.')
FileTitle=strmid(FileTitle,0,pos)
FileTitle+='_Arrhenius.txt'
OutputFile = DIALOG_PICKFILE(title = 'Select Output File',file=FileTitle,path=dir,/write)
if OutputFile eq '' then return


;ArrheniusStruc={Trec:Trec, $
;                lnTau:lnTau, $
;                Chisq:Chisq, $
;                yfit:yfit}

widget_control,(*pstate).Tau0_Field,get_value = Tau0
widget_control,(*pstate).delta_Field,get_value = delta

format_float = '(e-15.5,2x,e-15.5,2x,e-15.5)'


widget_control,(*pstate).MolarMass_Field,get_value=MolarMass
widget_control,(*pstate).SampleMass_Field,get_value=SampleMass
widget_control,(*pstate).Amplitude_Field,get_value=AmplitudeString
widget_control,(*pstate).StaticFields_Field,get_value=FieldString

nx=n_elements(temperature)
    openw,lun,OutputFile,/get_lun
printf,lun,'# SQUID File: '+(*pstate).Source_File              
printf,lun,'# Sample Mass Entered in Program: '+SampleMass             
printf,lun,'# Sample Mass Entered in SQUID File: '+(*pstate).weight             
printf,lun,'# Molar Mass: '+MolarMass              
printf,lun,'# Static Fields / Oe: '+FieldString              
printf,lun,'# Amplitude Fields / Oe: '+AmplitudeString              
printf,lun,'# Measurement Duration: '+(*pstate).duration              
printf,lun,'# Tau0 / seconds: '+Tau0
printf,lun,'# Delta / K: '+delta
printf,lun,'# Chisq: '+strtrim(string((*(*pstate).ArrheniusStruc).Chisq),2)
    printf,lun,'1 / T             ln(Tau)          ln(Tau)-Fit'              
    for i = 0, n_elements((*(*pstate).ArrheniusStruc).Trec)-1 do begin
    printf,lun,((*(*pstate).ArrheniusStruc).Trec)[i], $
    ((*(*pstate).ArrheniusStruc).lnTau)[i], $
    ((*(*pstate).ArrheniusStruc).yfit)[i],format = format_float
    endfor
    free_lun,lun,/force

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_Save_Image,event,Chip=Chip,Chidp=Chidp,Argand=Argand,Arrhenius=Arrhenius, $
                        jpeg=jpeg,gif=gif,tiff=tiff
widget_control,event.top,get_uvalue = pState


if keyword_set(Chip) then Workup_AC_Squid_Data_PlotChip,event
if keyword_set(Chidp) then Workup_AC_Squid_Data_PlotChidp,event
if keyword_set(Argand) then AC_Squid_Data_PlotArgand,event
if keyword_set(Arrhenius) then AC_Squid_Data_PlotArrhenius,event
if keyword_set(jpeg) then FileEnd='.jpg'
if keyword_set(gif) then FileEnd='.gif'
if keyword_set(tiff) then FileEnd='.tiff'

  textLen = strlen((*pstate).Source_File)
    pos=strpos((*pstate).Source_File,(*pstate).delim,/reverse_Search)
textLen-=pos
  FileTitle = strmid((*pstate).Source_File,textLen-2,/reverse_offset)
  dir = strmid((*pstate).Source_File,0,pos)
    pos=strpos(FileTitle,'.')
FileTitle=strmid(FileTitle,0,pos)

if keyword_set(Chip) then FileTitle+='_Chip'
if keyword_set(Chidp) then FileTitle+='_Chidp'
if keyword_set(Argand) then FileTitle+='_Argand'
if keyword_set(Arrhenius) then FileTitle+='_Arrhenius'


FileTitle+=FileEnd
;OutputFile = DIALOG_PICKFILE(title = 'Select Output File',file=FileTitle,path=dir,/write,filter='*'+FileEnd)


device, decomposed = 1
image24 = tvrd(True=1)
device, decomposed = 0

if keyword_set(tiff) then begin
image24=reverse(image24,3)
ok = dialog_write_image(image24,type='tiff',/fix_type,dialog_parent=event.top,path=dir,file=FileTitle)
endif


if keyword_set(gif) then ok = dialog_write_image(image24,type='gif',/fix_type,dialog_parent=event.top,path=dir,file=FileTitle)
if keyword_set(jpeg) then ok = dialog_write_image(image24,type='jpeg',/fix_type,dialog_parent=event.top,path=dir,file=FileTitle)

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_SaveChi,event
widget_control,event.top,get_uvalue = pState

  textLen = strlen((*pstate).Source_File)
    pos=strpos((*pstate).Source_File,(*pstate).delim,/reverse_Search)
textLen-=pos
  FileTitle = strmid((*pstate).Source_File,textLen-2,/reverse_offset)
  dir = strmid((*pstate).Source_File,0,pos)
    pos=strpos(FileTitle,'.')
FileTitle=strmid(FileTitle,0,pos)
FileTitle+='_AC.txt'
OutputFile = DIALOG_PICKFILE(title = 'Select Output File',file=FileTitle,path=dir,/write)

if OutputFile eq '' then return

;OutputFile=dir+delim+FileTitle

format_float = '(e-15.5,2x,e-15.5,2x,e-15.5,2x,e-15.5)'

temperature=(*(*pstate).temperature)[where(*(*pstate).DataMaskArraychi eq 1)]
mprime=(*(*pstate).mprime)[where(*(*pstate).DataMaskArraychi eq 1)]
mdprime=(*(*pstate).mdprime)[where(*(*pstate).DataMaskArraychi eq 1)]
frequency=(*(*pstate).frequency)[where(*(*pstate).DataMaskArraychi eq 1)]


widget_control,(*pstate).MolarMass_Field,get_value=MolarMass
widget_control,(*pstate).SampleMass_Field,get_value=SampleMass
widget_control,(*pstate).Amplitude_Field,get_value=AmplitudeString
widget_control,(*pstate).StaticFields_Field,get_value=FieldString

nx=n_elements(temperature)
    openw,lun,OutputFile,/get_lun
printf,lun,'# SQUID File: '+(*pstate).Source_File              
printf,lun,'# Sample Mass Entered in Program: '+SampleMass             
printf,lun,'# Sample Mass Entered in SQUID File: '+(*pstate).weight             
printf,lun,'# Molar Mass: '+MolarMass              
printf,lun,'# Static Fields / Oe: '+FieldString              
printf,lun,'# Amplitude Fields / Oe: '+AmplitudeString              
printf,lun,'# Measurement Duration: '+(*pstate).duration              
    printf,lun,'temperature          Chi''             Chi''''        Frequency / Hz   '              
    for i = 0, nx-1 do begin
    printf,lun,temperature[i],mprime[i],mdprime[i],frequency[i],format = format_float
    endfor
    free_lun,lun,/force


end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_PrintImage,event,Chip=Chip,Chidp=Chidp,Argand=Argand,Arrhenius=Arrhenius
widget_control,event.top,get_uvalue = pState
thisDevice = !d.name
  SET_PLOT, 'printer',/copy
    result = dialog_printersetup(dialog_parent = event.top)
      if result ne 0 then begin
if keyword_set(Chip) then Workup_AC_Squid_Data_PlotChip,event,/to_window
if keyword_set(Chidp) then Workup_AC_Squid_Data_PlotChidp,event,/to_window
if keyword_set(Argand) then AC_Squid_Data_PlotArgand,event,/to_window
if keyword_set(Arrhenius) then AC_Squid_Data_PlotArrhenius,event,/to_window
      endif
  DEVICE, /CLOSE
  set_plot,thisDevice
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro AC_Save_PS,event,Chip=Chip,Chidp=Chipd,Argand=Argand,Arrhenius=Arrhenius
widget_control,event.top,get_uvalue = pState

thisDevice = !d.name

FileEnd='.ps'

  textLen = strlen((*pstate).Source_File)
    pos=strpos((*pstate).Source_File,(*pstate).delim,/reverse_Search)
textLen-=pos
  FileTitle = strmid((*pstate).Source_File,textLen-2,/reverse_offset)
  dir = strmid((*pstate).Source_File,0,pos)
    pos=strpos(FileTitle,'.')
FileTitle=strmid(FileTitle,0,pos)

if keyword_set(Chip) then FileTitle+='_Chip'
if keyword_set(Chidp) then FileTitle+='_Chidp'
if keyword_set(Argand) then FileTitle+='_Argand'
if keyword_set(Arrhenius) then FileTitle+='_Arrhenius'

FileTitle+=FileEnd

deviceKeywords = PSConfig(Cancel=canceled,directory = dir,group_leader = event.top,filename=FileTitle)
if canceled ne 1 then begin
  SET_PLOT, 'PS'
  DEVICE, _Extra = deviceKeywords
if keyword_set(Chip) then Workup_AC_Squid_Data_PlotChip,event,/to_window
if keyword_set(Chidp) then Workup_AC_Squid_Data_PlotChidp,event,/to_window
if keyword_set(Argand) then AC_Squid_Data_PlotArgand,event,/to_window
if keyword_set(Arrhenius) then AC_Squid_Data_PlotArrhenius,event,/to_window
  DEVICE, /CLOSE_FILE
  set_plot,thisDevice
endif

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Workup_AC_Squid_Data_events,event
widget_control,event.top,get_uvalue = pState

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
    void=dialog_message(dialog_parent=event.top,/error, $
    !ERROR_STATE.MSG)
return
endif


uname=widget_info(event.id,/uname)
case uname of
'AC_Read':   $
begin
Workup_AC_Squid_Data_read,event
end
;'Browse_InputFile':   $
;begin
;Workup_AC_Squid_Data_browse,event
;end
'AC_quit':   $
begin
Workup_AC_Squid_Data_quit,event
end
'RestoreData_Chi':   $
begin
ACReset,event
end
'RestoreData_Arrhenius':   $
begin
ArrheniusReset,event
end
'Save_Chi':   $
begin
AC_SaveChi,event
end
'Save_Argand':   $
begin
AC_SaveArgand,event
end
'Save_Arrhenius':   $
begin
AC_SaveArrhenius,event
end
'Argand_TempUpdate':   $
begin
AC_Squid_Data_PlotArgand,event
end
'AC_Save_Chip_jpeg':   $
begin
AC_Save_Image,event,/Chip,/jpeg
end
'AC_Save_Chip_gif':   $
begin
AC_Save_Image,event,/Chip,/gif
end
'AC_Save_Chip_tiff':   $
begin
AC_Save_Image,event,/Chip,/tiff
end
'AC_Save_Chip_ps':   $
begin
AC_Save_PS,event,/Chip
end
'AC_Save_Chidp_jpeg':   $
begin
AC_Save_Image,event,/Chidp,/jpeg
end
'AC_Save_Chidp_gif':   $
begin
AC_Save_Image,event,/Chidp,/gif
end
'AC_Save_Chidp_tiff':   $
begin
AC_Save_Image,event,/Chidp,/tiff
end
'AC_Save_Chidp_ps':   $
begin
AC_Save_PS,event,/Chidp
end
'AC_Save_Argand_jpeg':   $
begin
AC_Save_Image,event,/Argand,/jpeg
end
'AC_Save_Argand_gif':   $
begin
AC_Save_Image,event,/gif,/Argand
end
'AC_Save_Argand_tiff':   $
begin
AC_Save_Image,event,/tiff,/Argand
end
'AC_Save_Argand_ps':   $
begin
AC_Save_PS,event,/Argand
end
'AC_Save_Arrhenius_jpeg':   $
begin
AC_Save_Image,event,/Arrhenius,/jpeg
end
'AC_Save_Arrhenius_gif':   $
begin
AC_Save_Image,event,/Arrhenius,/gif
end
'AC_Save_Arrhenius_tiff':   $
begin
AC_Save_Image,event,/Arrhenius,/tiff
end
'AC_Save_Arrhenius_ps':   $
begin
AC_Save_PS,event,/Arrhenius
end
'AC_Print_Chip':   $
begin
AC_PrintImage,event,/Chip
end
'AC_Print_Chidp':   $
begin
AC_PrintImage,event,/Chidp
end
'AC_Print_Argand':   $
begin
AC_PrintImage,event,/Argand
end
'AC_Print_Arrhenius':   $
begin
AC_PrintImage,event,/Arrhenius
end
'AC_SaveSession':   $
begin
AC_Save,event
end
'AC_RestoreSession':   $
begin
AC_restore,event
end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Workup_AC_Squid_Data,tlb,group_leader = group_leader, $
        register_name = register_name,workDir = workDir,ExternalEvent = ExternalEvent, $
        ExternalProgramName=ExternalProgramName

;pro Mag_Workup_MagProp,tlb,group_leader = group_leader,notify_ids = notify_ids,  $
;        register_name = register_name,workDir = workDir,ExternalEvent = ExternalEvent, $
;        ExternalProgramName=ExternalProgramName



delim=path_sep()

if not keyword_set(workdir) then workdir = 'c:'+delim

if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(ExternalProgramName) eq 0 then ExternalProgramName=''
if n_elements(register_name) eq 0 then register_name='Mag_Workup_MagProp'

if xregistered(register_name) then return

if n_elements(ExternalEvent) eq 0 then begin
ExternalEvent={ID:-1}
tlb = widget_base(title = 'Squid AC data Workup',mbar=bar,/col,group_leader = group_leader)
endif else begin

tlb = widget_base(title = 'Squid AC Data Workup Started from '+ExternalProgramName,mbar=bar,/col,group_leader = group_leader)

endelse


 tlb = widget_base(title = 'Squid AC Workup',mbar=bar,/col,group_leader = group_leader)



       filebuttons=widget_button(bar,value='File',/menu)
          read=widget_button(filebuttons,$
              value='Workup AC SQUID File',uname='AC_Read')
          Savesession=widget_button(filebuttons,$
              value='Save Session',uname='AC_SaveSession')
          RestoreSession=widget_button(filebuttons,$
              value='Restore Session',uname='AC_RestoreSession')
           SaveData=widget_button(filebuttons,$
              value='Save Data',/menu)
          SaveDataChi=widget_button(SaveData,$
              value='Save Susceptibility Data in Frequency Groups as Ascii',uname='Save_Chi')
          SaveArgand=widget_button(SaveData,$
              value='Save Argand Plot as Ascii',uname='Save_Argand')
          SaveArrhenius=widget_button(SaveData,$
              value='Save Arrhenius Plot as Ascii',uname='Save_Arrhenius')              
          doneb=widget_button(filebuttons,$
              value='EXIT',uname='AC_quit')
              
       saveimagebuttons=widget_button(bar,value='Save Image',/menu)
          SaveChip=widget_button(saveimagebuttons,$
              value='Save Chi''' ,/menu)
          void=widget_button(SaveChip,$
              value='Save jpeg',uname='AC_Save_Chip_jpeg')
          void=widget_button(SaveChip,$
              value='Save gif',uname='AC_Save_Chip_gif')
          void=widget_button(SaveChip,$
              value='Save tiff',uname='AC_Save_Chip_tiff')
          void=widget_button(SaveChip,$
              value='Save PS',uname='AC_Save_Chip_ps')
          SaveChidp=widget_button(saveimagebuttons,$
              value='Save Chi''''' ,/menu)
          void=widget_button(SaveChidp,$
              value='Save jpeg',uname='AC_Save_Chidp_jpeg')
          void=widget_button(SaveChidp,$
              value='Save gif',uname='AC_Save_Chidp_gif')
          void=widget_button(SaveChidp,$
              value='Save tiff',uname='AC_Save_Chidp_tiff')
          void=widget_button(SaveChidp,$
              value='Save PS',uname='AC_Save_Chidp_ps')
          SaveImageArgand=widget_button(saveimagebuttons,$
              value='Save Argand Plot',/menu)
          void=widget_button(SaveImageArgand,$
              value='Save jpeg',uname='AC_Save_Argand_jpeg')
          void=widget_button(SaveImageArgand,$
              value='Save gif',uname='AC_Save_Argand_gif')
          void=widget_button(SaveImageArgand,$
              value='Save tiff',uname='AC_Save_Argand_tiff')
          void=widget_button(SaveImageArgand,$
              value='Save PS',uname='AC_Save_Argand_ps')
          SaveImageArrhenius=widget_button(saveimagebuttons,$
              value='Save Arrhenius Plot' ,/menu)
          void=widget_button(SaveImageArrhenius,$
              value='Save jpeg',uname='AC_Save_Arrhenius_jpeg')
          void=widget_button(SaveImageArrhenius,$
              value='Save gif',uname='AC_Save_Arrhenius_gif')
          void=widget_button(SaveImageArrhenius,$
              value='Save tiff',uname='AC_Save_Arrhenius_tiff')
          void=widget_button(SaveImageArrhenius,$
              value='Save PS',uname='AC_Save_Arrhenius_ps')
              
       printbuttons=widget_button(bar,value='Print Image',/menu)
          void=widget_button(printbuttons,$
              value='Print Chi'' Plot',uname='AC_Print_Chip')
          void=widget_button(printbuttons,$
              value='Print Chi'''' Plot',uname='AC_Print_Chidp')
          void=widget_button(printbuttons,$
              value='Print Argand Plot',uname='AC_Print_Argand')
          void=widget_button(printbuttons,$
              value='Print Arrhenius Plot',uname='AC_Print_Arrhenius')
;       helpbuttons=widget_button(bar,value='Help',/menu)
;          void=widget_button(helpbuttons,$
;              value='Launch Help File',uname='AC_LaunchHelp')



tab_base=widget_tab(tlb)

RawData_base=widget_base(tab_base,title='Chi'', Chi''''',/col)
Processed_Data=widget_base(tab_base,title='Argand and Arrhenius Plots',/col)


base1=widget_base(RawData_base,/align_left,/row)
base2=widget_base(base1,/align_center,/col)
base2a=widget_base(base2,/align_center,/row)
base2b=widget_base(base2,/align_center,/row)


;InputFile_Field=cw_field(base2a,xsize=40,/row, $
;                 title='Input File',value='')





;OutputFile_Field=cw_field(base2a,xsize=47,/row, $
;                 title='Output File',value='')


MolarMass_Field=cw_field(base2b,xsize=7,/row, $
                 title='Molar Mass / grams',value='')

SampleMass_Field=cw_field(base2b,xsize=7,/row, $
                 title='Sample Mass / mg',value='')

StartTime_Field=cw_field(base2b,xsize=21,/row, $
                 title='Start time of measurement',value='',/noedit)

StaticFields_Field=cw_field(base2b,xsize=21,/row, $
                 title='Static Fields / Oe',value='',/noedit)

Amplitude_Field=cw_field(base2b,xsize=21,/row, $
                 title='Amplitude / Oe',value='',/noedit)


GoldenRatio=0.5*(1.0+sqrt(5.0))

GraphicBase_1=widget_base(RawData_base,/align_center,/row)
GraphicBase_1a=widget_base(GraphicBase_1,/align_center,/col)
GraphicBase_1b=widget_base(GraphicBase_1,/align_center,/col)


xsize = 500 & ysize =xsize/GoldenRatio

winChip = widget_draw(GraphicBase_1a,xsize = xsize,ysize = ysize,/button_events,/motion_events, $
      event_pro = 'ACChip_MouseEvents')

winChidp = widget_draw(GraphicBase_1b,xsize = xsize,ysize = ysize,/button_events,/motion_events, $
      event_pro = 'ACChidp_MouseEvents')
MouseAction_Field=['Zoom','Purge']
;
Graphical_Base_1a_row=widget_base(GraphicBase_1a,/row,/align_center,/frame)
MouseActionChip = cw_bgroup(Graphical_Base_1a_row,MouseAction_Field,/row, $
          /exclusive,label_top='Mouse Action', $
           set_value = 0,/return_index,/no_release,/frame)
purgeChi=cw_field(Graphical_Base_1a_row,/col, $
                 title='Number of Purged Points',value='',xsize=20,/noedit)
void = widget_button(Graphical_Base_1a_row,value = 'Restore Original Data', uname='RestoreData_Chi')
;
Graphical_Base_1b_row=widget_base(GraphicBase_1b,/row,/align_center)


MouseActionChidp = cw_bgroup(Graphical_Base_1b_row,MouseAction_Field,/row, $
          /exclusive,label_top='Mouse Action', $
           set_value = 0,/return_index,/no_release,/frame)


GraphicBase_2=widget_base(Processed_Data,/align_center,/row)
GraphicBase_2a=widget_base(GraphicBase_2,/align_center,/col)
GraphicBase_2b=widget_base(GraphicBase_2,/align_center,/col)

Base_2a=widget_base(GraphicBase_2a,/align_center,/row)

ArgandTemperatureValues_Field=cw_field(Base_2a,xsize=70,/col, $
                 title='Temperature Bins',value='2.0,2.3,2.8,3.0,3.4,3.9,4.4,5.0,6.0', $
                 uname='Argand_TempUpdate',/return_events)


Base_2b=widget_base(GraphicBase_2b,/align_center,/row)

Tau0_Field=cw_field(Base_2b,xsize=30,/col, $
                 title='Tau 0 / s',value='')

Delta_Field=cw_field(Base_2b,xsize=30,/col, $
                 title='Delta / K',value='')


winArgand = widget_draw(GraphicBase_2a,xsize = xsize,ysize = ysize,/button_events,/motion_events, $
      event_pro = 'ACArgand_MouseEvents')

winArrhenius = widget_draw(GraphicBase_2b,xsize = xsize,ysize = ysize,/button_events,/motion_events, $
      event_pro = 'ACArrhenius_MouseEvents')

Graphical_Base_2a_row=widget_base(GraphicBase_2a,/row,/align_center)

MouseActionArgand = cw_bgroup(Graphical_Base_2a_row,MouseAction_Field,/row, $
          /exclusive,label_top='Mouse Action', $
           set_value = 0,/return_index,/no_release,/frame)

Graphical_Base_2b_row=widget_base(GraphicBase_2b,/row,/align_center)
MouseActionArrhenius = cw_bgroup(Graphical_Base_2b_row,MouseAction_Field,/row, $
          /exclusive,label_top='Mouse Action', $
           set_value = 0,/return_index,/no_release,/frame)

void = widget_button(Graphical_Base_2b_row,value = 'Restore Original Data', uname='RestoreData_Arrhenius')

centertlb,tlb
widget_control,tlb,/realize

widget_control,winChip,get_value = winVisChip
window,/free,/pixmap,xsize = xsize,ysize = ysize
winPixChip = !d.window

widget_control,winChidp,get_value = winVisChidp
window,/free,/pixmap,xsize = xsize,ysize = ysize
winPixChidp = !d.window

widget_control,winArgand,get_value = winVisArgand
window,/free,/pixmap,xsize = xsize,ysize = ysize
winPixArgand = !d.window

widget_control,winArrhenius,get_value = winVisArrhenius
window,/free,/pixmap,xsize = xsize,ysize = ysize
winPixArrhenius = !d.window


winState={mouse:0B, $
         winChip:winChip, $
         winVisChip:winVisChip, $
         winPixchip:winPixchip, $
         xboxChip:[0.0,0.0], $
         yboxChip:[0.0,0.0], $
         autoscaleChip:1, $
         xrangeChip:[0.0,1.0], $
         yrangeChip:[0.0,1.0], $
         xrangedelChip:[0.0,1.0], $
         yrangedelChip:[0.0,1.0], $
         winArgand:winArgand, $
         winVisArgand:winVisArgand, $
         winPixArgand:winPixArgand, $
         xboxArgand:[0.0,0.0], $
         yboxArgand:[0.0,0.0], $
         autoscaleArgand:1, $
         xrangeArgand:[0.0,1.0], $
         yrangeArgand:[0.0,1.0], $
         xrangedelArgand:[0.0,1.0], $
         yrangedelArgand:[0.0,1.0], $
         winArrhenius:winArrhenius, $
         winVisArrhenius:winVisArrhenius, $
         winPixArrhenius:winPixArrhenius, $
         xboxArrhenius:[0.0,0.0], $
         yboxArrhenius:[0.0,0.0], $
         autoscaleArrhenius:1, $
         xrangeArrhenius:[0.0,1.0], $
         yrangeArrhenius:[0.0,1.0], $
         xrangedelArrhenius:[0.0,1.0], $
         yrangedelArrhenius:[0.0,1.0], $
         winChidp:winChidp, $
         winVisChidp:winVisChidp, $
         winPixchidp:winPixchidp, $
         xboxChidp:[0.0,0.0], $
         yboxChidp:[0.0,0.0], $
         autoscaleChidp:1, $
         xrangeChidp:[0.0,1.0], $
         yrangeChidp:[0.0,1.0], $
         xrangedelChidp:[0.0,1.0], $
         yrangedelChidp:[0.0,1.0] $
         
         }

state =  {MolarMass_Field:MolarMass_Field, $
      SampleMass_Field:SampleMass_Field, $
      temperature:ptr_new(/allocate_heap), $
      frequency:ptr_new(/allocate_heap), $
      mprime:ptr_new(/allocate_heap), $
      mdprime:ptr_new(/allocate_heap), $
       indices:ptr_new(/allocate_heap), $
       DataMaskArraychi:ptr_new(/allocate_heap), $
       DataMaskArrayArrhenius:ptr_new(/allocate_heap), $
       ArrheniusStruc:ptr_new(/allocate_heap), $
       n_freq:0, $
       winState:winState, $
       workDir:workDir, $
       delim:delim, $
       MouseActionChip:MouseActionChip, $
       MouseActionChidp:MouseActionChidp, $
       purgeChi:purgeChi, $
       StartTime_Field:StartTime_Field, $
       StaticFields_Field:StaticFields_Field, $
       Amplitude_Field:Amplitude_Field, $
       MouseActionArgand:MouseActionArgand, $
       MouseActionArrhenius:MouseActionArrhenius, $
       ArgandTemperatureValues_Field:ArgandTemperatureValues_Field, $
       Tau0_Field:Tau0_Field, $
       Delta_Field:Delta_Field, $
       weight:'', $
       Duration:'', $
       Source_File:'', $
       pix:1 $
       }



pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState


xmanager,'Workup_AC_Squid_Data',tlb,event_handler = 'Workup_AC_Squid_Data_events',cleanup= 'Workup_AC_Squid_Data_cleanup'

end