; $Id$
;###############################################################################
;
; NAME:
;  MARSDETGROUPWIDGET
;
; PURPOSE:
;  Dialog widget that returns an array of detector numbers.
;
; CATEGORY:
;  DAVE, mars, utility
;
; AUTHOR:
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;Based on the Program  HFBSDETGROUPWIDGET.pro by:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; marsDetGroupWidget.pro
;
; Function widget that allows user to select grouping of detectors
; for mars.
;
; HFBSDETGROUPWIDGET.pro Written by R.M.Dimeo (11/19/01)
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro marsDetGroupQuit,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet
good_det = (*pState).good_det
case event.id of
(*pState).accept:     begin
                      end
(*pState).cancel:     begin
                      detarray = intarr(10,10)
                      if n_elements(good_det) eq 10 then begin
;                      for i = 0,ndet-1 do begin
;                      detArray[i,i] = 1
;                      endfor
                      detArray[0,*] = 1 ;group all
                      endif else begin
;                      k=0
;                      for i = 0, 9 do begin
;                      present=where(i eq good_det)
;                      if present ne -1 then begin ;present
;                       detArray[k,i]=1
;                       k+=1
;                       endif


                      for i = 0, 9 do begin   ;group all
                      present=where(i eq good_det)
                      if present ne -1 then begin ;present
                       detArray[0,i]=1
                       endif
                      endfor
                      endelse
                      *(*pState).selDetPtr = detarray
                      end
else:
endcase
wdelete,(*pState).winPix
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro MARS_group_angles,event
widget_control,event.top,get_uvalue = pState
good_det = (*pState).good_det
; do not assume all detectors are present
ndet = (*pState).ndet
num=0
thisArray = intarr(10,10)
thisArray[0,[4,5]]=1
thisArray[1,[3,6]]=1
thisArray[2,[2,7]]=1
thisArray[3,[1,8]]=1
thisArray[4,[0,9]]=1
IF n_elements(good_det) eq 10 THEN BEGIN ;all detectors are present
num=5
ENDIF ELSE BEGIN
for i = 0, 9 do begin
missing=where (i eq good_det)
    if missing eq -1 then begin
       if i le 4 then begin
       thisArray[i,i]=0
       endif else begin
       thisArray[i-5,i]=0
       endelse
    endif
endfor
;what if two detectors from the same angle are dead?
wheregtzero=where(total(thisArray,2) gt 0,num)
thisArray[0:num-1,*]=temporary(thisArray[wheregtzero,*])
;the previous two lines replace the following commented code
;for i = 0,4 do begin
;    if total(thisArray[i,*]) eq 0 then begin
;    if n_elements(blank) eq 0 then blank = i else blank = [blank,i]
;    endif
;endfor
;if n_elements(blank) ne 0 then begin
;k=0
;temparrayPtr=ptr_new(intarr(ndet,ndet))
;for i = 0,4 do begin
;    whereblank=where(i eq blank)
;    if whereblank eq -1 then begin;not blank
;    (*temparrayPtr)[k,*]=thisArray[i,*]
;    k+=1
;    endif
;endfor
;thisArray=*temparrayPtr
;ptr_free,temparrayPtr
;endif
;num=5-n_elements(blank)
ENDELSE

*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det1,set_value = (*(*pState).selDetPtr)[grpValue,0]
  widget_control,(*pState).det2,set_value = (*(*pState).selDetPtr)[grpValue,1]
  widget_control,(*pState).det3,set_value = (*(*pState).selDetPtr)[grpValue,2]
  widget_control,(*pState).det4,set_value = (*(*pState).selDetPtr)[grpValue,3]
  widget_control,(*pState).det5,set_value = (*(*pState).selDetPtr)[grpValue,4]
  widget_control,(*pState).det6,set_value = (*(*pState).selDetPtr)[grpValue,5]
  widget_control,(*pState).det7,set_value = (*(*pState).selDetPtr)[grpValue,6]
  widget_control,(*pState).det8,set_value = (*(*pState).selDetPtr)[grpValue,7]
  widget_control,(*pState).det9,set_value = (*(*pState).selDetPtr)[grpValue,8]
  widget_control,(*pState).det10,set_value = (*(*pState).selDetPtr)[grpValue,9]

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro marsDetGroupAll,event
widget_control,event.top,get_uvalue = pState
ndet = (*pState).ndet
good_det = (*pState).good_det

thisArray = intarr(ndet,ndet)
thisArray[0,0:ndet-1] = 1

for i = 0, 9 do begin
    absent=where(i eq good_det)
    if absent eq -1 then begin ;absent
    thisArray[0,i]=0
    endif
endfor


*(*pState).selDetPtr = thisArray
num=1
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det1,set_value = (*(*pState).selDetPtr)[grpValue,0]
  widget_control,(*pState).det2,set_value = (*(*pState).selDetPtr)[grpValue,1]
  widget_control,(*pState).det3,set_value = (*(*pState).selDetPtr)[grpValue,2]
  widget_control,(*pState).det4,set_value = (*(*pState).selDetPtr)[grpValue,3]
  widget_control,(*pState).det5,set_value = (*(*pState).selDetPtr)[grpValue,4]
  widget_control,(*pState).det6,set_value = (*(*pState).selDetPtr)[grpValue,5]
  widget_control,(*pState).det7,set_value = (*(*pState).selDetPtr)[grpValue,6]
  widget_control,(*pState).det8,set_value = (*(*pState).selDetPtr)[grpValue,7]
  widget_control,(*pState).det9,set_value = (*(*pState).selDetPtr)[grpValue,8]
  widget_control,(*pState).det10,set_value = (*(*pState).selDetPtr)[grpValue,9]

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro marsspecifiedvalue,event
widget_control,event.top,get_uvalue = pState
  widget_control,(*pState).specific,get_value = specific
ndet=(*pState).ndet
good_det = (*pState).good_det
;print,specific
temparray=opan_mars_selectgroups(specific,ndet)
;purge
for i = 0, 9 do begin
    absent=where(i eq good_det)
    if absent eq -1 then begin ;absent
    temparray[*,i]=0
    endif
endfor
;print,'temparray: ',temparray
  *(*pState).selDetPtr=temparray
    widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det1,set_value = (*(*pState).selDetPtr)[grpValue,0]
  widget_control,(*pState).det2,set_value = (*(*pState).selDetPtr)[grpValue,1]
  widget_control,(*pState).det3,set_value = (*(*pState).selDetPtr)[grpValue,2]
  widget_control,(*pState).det4,set_value = (*(*pState).selDetPtr)[grpValue,3]
  widget_control,(*pState).det5,set_value = (*(*pState).selDetPtr)[grpValue,4]
  widget_control,(*pState).det6,set_value = (*(*pState).selDetPtr)[grpValue,5]
  widget_control,(*pState).det7,set_value = (*(*pState).selDetPtr)[grpValue,6]
  widget_control,(*pState).det8,set_value = (*(*pState).selDetPtr)[grpValue,7]
  widget_control,(*pState).det9,set_value = (*(*pState).selDetPtr)[grpValue,8]
  widget_control,(*pState).det10,set_value = (*(*pState).selDetPtr)[grpValue,9]
;print,total(dets,2)
;print,'outputdets =',dets
void=where(total((*(*pState).selDetPtr),2) gt 0,num)
widget_control,(*pState).num,set_value = num
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro marsDetGroupWidget_event,event
widget_control,event.top,get_uvalue = pState
; Update the check-boxes after changing the slider bar position
if event.id eq (*pState).grpSlider then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
   grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det1,set_value = (*(*pState).selDetPtr)[grpValue,0]
  widget_control,(*pState).det2,set_value = (*(*pState).selDetPtr)[grpValue,1]
  widget_control,(*pState).det3,set_value = (*(*pState).selDetPtr)[grpValue,2]
  widget_control,(*pState).det4,set_value = (*(*pState).selDetPtr)[grpValue,3]
  widget_control,(*pState).det5,set_value = (*(*pState).selDetPtr)[grpValue,4]
  widget_control,(*pState).det6,set_value = (*(*pState).selDetPtr)[grpValue,5]
  widget_control,(*pState).det7,set_value = (*(*pState).selDetPtr)[grpValue,6]
  widget_control,(*pState).det8,set_value = (*(*pState).selDetPtr)[grpValue,7]
  widget_control,(*pState).det9,set_value = (*(*pState).selDetPtr)[grpValue,8]
  widget_control,(*pState).det10,set_value = (*(*pState).selDetPtr)[grpValue,9]
return
endif

if event.id eq (*pState).specific then begin
marsspecifiedvalue,event
return
endif

if event.id eq (*pState).det1 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det1,get_value = val
  (*(*pState).selDetPtr)[grpValue,0] = val
endif
if event.id eq (*pState).det2 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det2,get_value = val
  (*(*pState).selDetPtr)[grpValue,1] = val
endif
if event.id eq (*pState).det3 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det3,get_value = val
  (*(*pState).selDetPtr)[grpValue,2] = val
endif
if event.id eq (*pState).det4 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det4,get_value = val
  (*(*pState).selDetPtr)[grpValue,3] = val
endif
if event.id eq (*pState).det5 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det5,get_value = val
  (*(*pState).selDetPtr)[grpValue,4] = val
endif
if event.id eq (*pState).det6 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det6,get_value = val
  (*(*pState).selDetPtr)[grpValue,5] = val
endif
if event.id eq (*pState).det7 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det7,get_value = val
  (*(*pState).selDetPtr)[grpValue,6] = val
endif
if event.id eq (*pState).det8 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det8,get_value = val
  (*(*pState).selDetPtr)[grpValue,7] = val
endif
if event.id eq (*pState).det9 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det9,get_value = val
  (*(*pState).selDetPtr)[grpValue,8] = val
endif
if event.id eq (*pState).det10 then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).det10,get_value = val
  (*(*pState).selDetPtr)[grpValue,9] = val
endif

sumcol=total((*(*pState).selDetPtr),2)
wherezero=where(sumcol eq 0,count)
num=(*pState).ndet-count
widget_control,(*pState).num,set_value = num

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function marsDetGroupWidget,group_leader = group_leader,selDetPtr,good_det
; Widget definition module

;print,'good_det: ',good_det

SensitiveArray=intarr(10)+1
for i = 0, 9 do begin
absent=where(i eq good_det)
if absent eq -1 then SensitiveArray[i]=0 ;absent
endfor


  ndet = 10
  detArray = *selDetPtr
void=where(total(detArray,2) gt 0,numb)



if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,tlb_frame_attr = 1,title = 'Group Detectors',/base_align_right)
endif else begin
  tlb = widget_base(/modal,/col,tlb_frame_attr = 1,title = 'Group Detectors',group_leader = group_leader)
endelse
base1 = widget_base(tlb,/row)
void = widget_button(base1,value = 'Group all',event_pro = 'marsDetGroupAll')
void=widget_button(base1,value = 'Group Angles',event_pro = 'MARS_group_angles')
specific=cw_field(base1,title = 'Specify Grouping:',value='1,3-5,7',/return_events,/col)
num=cw_field(base1,xsize=4,title = 'Number of Groups:',value=numb,/noedit,/col)
grpSlider = widget_slider(base1,value = 1,minimum = 1,maximum = ndet,title = 'Display Group')
accept = widget_button(base1,value = 'Accept',event_pro = 'marsDetGroupQuit')
cancel = widget_button(base1,value = 'Cancel',event_pro = 'marsDetGroupQuit')
base2 = widget_base(tlb)

times_mediumfont = get_font_name(/medium, /times,/bold)

base2_1 = widget_base(base2,xoffset=181,yoffset=88,sensitive=SensitiveArray[0])
base2_2 = widget_base(base2,xoffset=236,yoffset=37,sensitive=SensitiveArray[1])
base2_3 = widget_base(base2,xoffset=350,yoffset=12,sensitive=SensitiveArray[2])
base2_4 = widget_base(base2,xoffset=460,yoffset=37,sensitive=SensitiveArray[3])
base2_5 = widget_base(base2,xoffset=517,yoffset=88,sensitive=SensitiveArray[4])
base2_6 = widget_base(base2,xoffset=517,yoffset=290,sensitive=SensitiveArray[5])
base2_7 = widget_base(base2,xoffset=460,yoffset=342,sensitive=SensitiveArray[6])
base2_8 = widget_base(base2,xoffset=350,yoffset=367,sensitive=SensitiveArray[7])
base2_9 = widget_base(base2,xoffset=236,yoffset=342,sensitive=SensitiveArray[8])
base2_10 = widget_base(base2,xoffset=181,yoffset=290,sensitive=SensitiveArray[9])


det1 = cw_bgroup(base2_1,'150',/nonexclusive,set_value = (*selDetPtr)[0,0],font = times_mediumfont)
det2 = cw_bgroup(base2_2,'120',/nonexclusive,set_value = (*selDetPtr)[0,1],font = times_mediumfont)
det3 = cw_bgroup(base2_3,'90',/nonexclusive,set_value = (*selDetPtr)[0,2],font = times_mediumfont)
det4 = cw_bgroup(base2_4,'60',/nonexclusive,set_value = (*selDetPtr)[0,3],font = times_mediumfont)
det5 = cw_bgroup(base2_5,'30',/nonexclusive,set_value = (*selDetPtr)[0,4],font = times_mediumfont)
det6 = cw_bgroup(base2_6,'30',/nonexclusive,set_value = (*selDetPtr)[0,5],font = times_mediumfont)
det7 = cw_bgroup(base2_7,'60',/nonexclusive,set_value = (*selDetPtr)[0,6],font = times_mediumfont)
det8 = cw_bgroup(base2_8,'90',/nonexclusive,set_value = (*selDetPtr)[0,7],font = times_mediumfont)
det9 = cw_bgroup(base2_9,'120',/nonexclusive,set_value = (*selDetPtr)[0,8],font = times_mediumfont)
det10 = cw_bgroup(base2_10,'150',/nonexclusive,set_value = (*selDetPtr)[0,9],font = times_mediumfont)



delim=path_Sep()
;xysize=get_screen_size()
;    winxsize = xysize[0]*0.42
;    winysize = xysize[1]*0.42

winysize=429
read_jpeg,!DAVE_AUXILIARY_DIR+'PSI'+delim+'MARS'+delim+'MarsDetGroup_Schematic.jpg',Image
s = size(image)
sx = s[2] & sy = s[3]
aspect = 1.0*sx/sy              ; find the aspect ratio of the image...
picysize = winysize & picxsize = fix(aspect*picysize)

win = widget_draw(base2,xsize = picxsize,ysize = picysize)



centertlb,tlb
widget_control,tlb,/realize

widget_control,win,get_value = winVis

window,/free,/pixmap,xsize = picxsize,ysize = picysize
winPix = !d.window

wset,winPix
tvimage,Image
wset,winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPix]



state = {accept:accept,$
            cancel:cancel,$
            det1:det1,$
            det2:det2,$
            det3:det3,$
            det4:det4,$
            det5:det5,$
            det6:det6,$
            det7:det7,$
            det8:det8,$
            det9:det9,$
            det10:det10,$
            ndet:ndet,$
            grpSlider:grpSlider,$
            selDetPtr:selDetPtr,$
            winPix:winPix, $
            good_det:good_det, $
            num:num, $
            specific:specific}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
xmanager,'marsDetGroupWidget',tlb
selDetPtr = (*pState).selDetPtr
ptr_free,pState
thisSize = size(*selDetPtr)
nx = thisSize[1] & ny = thisSize[2]
yout = 0*intarr(nx,ny)
for i = 0,nx-1 do begin
  yout[i,0:ny-1] = (*selDetPtr)[i,0:ny-1]
endfor
return,yout
end

