; $Id$
@MACS_qmap
pro vMACS_plotfiles, files, bgfil=bgfil, ind=ind, dep=dep, $
                    xdata=xdata, ydata=ydata, dydata=dydata, $
                    dptai=dptai, shiftptai=shiftptai, monitor=monitor, $
                    binsz=binsz, fgbinsz=fgbinsz, bgbinsz=bgbinsz, fgsc=fgsc, bgsc=bgsc, $
                    lsfit=lsfit, fitfunc=fitfunc, xfitr=xfitr, parms=parms, pmima=pmima, chimin=chimin, $
                    op=op, color=color, psym=psym, no_plot=no_plot, jpg=jpg, $
                    errthick=errthick, _extra=_extra  
   
   if n_elements(psym)    ne 1 then psym  = 4
   if n_elements(color)   ne 1 then color = 0
   if n_elements(back)    ne 1 then back  = fsc_color("white", !d.table_size-1)

   if keyword_set(binsz) and not keyword_set(fgbinsz) then fgbinsz=binsz 
   if keyword_set(binsz) and not keyword_set(bgbinsz) then bgbinsz=binsz 
   
   vMACS_readfile, files[0], macsptr, titles=titles, indep_var=indep_var, dep_var=dep_var
   titles = strupcase(titles)
   if not keyword_set(ind) then ind = titles[indep_var - 1] else ind = strupcase(ind)
   if not keyword_set(dep) then dep = titles[dep_var - 1]   else dep = strupcase(dep)
   if strupcase(dep) eq 'SPEC' or strupcase(dep) eq 'DIFF' then devs = ind else devs = [ind, dep]
   
   if not keyword_set(monitor) then no_norm = 'False'
   vMACS_extract, files, data, columns, devs=devs, bin_size=fgbinsz, scale=fgsc, no_norm=no_norm, shiftptai=shiftptai, _extra=_extra
   if keyword_set(bgfil) then begin
      vMACS_extract, bgfil, bgdata, columns, devs=devs, bin_size=bgbinsz, scale=bgsc, no_norm=no_norm, shiftptai=shiftptai, _extra=_extra
      vMACS_bgsub, data, bgdata, columns, devs=ind, bin_size=binsz, _extra=_extra 
   endif
   
   ind_col = where(columns eq ind)
   xdata   = data[ind_col,*] 
   ydata   = data[where(columns eq dep),*]
   if (strmid(dep,0,4) eq 'SPEC') or (strmid(dep,0,4) eq 'DIFF') then begin
      dydata_col = 'ERR_' + dep
      dydata = data[where(columns eq dydata_col),*]
   endif else dydata = 0.0
       
   if keyword_set(shiftptai) then ytit =  'Spec(shiftptai) ' + strtrim(string(shiftptai),2)
       
   if keyword_set(dptai) then begin
      ytit  =  'Spec(ptai)-Spec(ptai+dptai)'
      ndptai  =  n_elements(dptai)
      for i=0, ndptai-1 do begin
         vMACS_extract, files, bgdata, columns, devs=devs, bin_size=fgbinsz, scale=fgsc, no_norm=no_norm, shiftptai=dptai[i], _extra=_extra
         ydata -= bgdata[where(columns eq dep),*]
         dydata = sqrt(dydata^2 + bgdata[where(columns eq dydata_col),*]^2)
      endfor
   endif
   
   if n_elements(no_plot) eq 1 then return
   if n_elements(ytit)    eq 0 then ytit = dep
   if n_elements(xtit)    eq 0 then xtit = ind
   if n_elements(tit)     eq 0 then tit  = ind
   
   xdata=reform(xdata)  &  ydata=reform(ydata)  &  dydata=reform(dydata)
   if n_elements(xfitr) eq 2 then begin
      lis=where(xdata ge xfitr[0] and xdata le xfitr[1],nlis)
      if nlis gt 0 then begin
         xdata=xdata[lis]  &  ydata=ydata[lis]  &  dydata=dydata[lis]
        endif
   endif
     
   if not keyword_Set(xr) then xr=[min(xdata), max(xdata)]
   if not keyword_Set(yr) then yr=[min(ydata)-1.2*max(dydata), max(ydata)+1.2*max(dydata)]

   if keyword_set(op) then begin
      oplot, xdata, ydata, psym=psym, color=color, _extra=_extra
      errplot, xdata, ydata-dydata, ydata+dydata, color=color
   endif $
   else begin 
      if keyword_set(lsfit) then begin
         if not keyword_set(fitfunc) then fitfunc = 'gaussian'
         if not keyword_set(parms) then begin
            parms=fltarr(5)
            parms[1]=0. & parms[4]=0.1*(max(xdata) - min(xdata))
            parms[2]=(max(ydata, nmax, min=xmin) - xmin)*parms[4]
            parms[3]=xdata(nmax) & parms(0)=xmin
         endif
         for i=0,9 do lsfit, xdata, ydata, dydata, fitfunc, parms, _extra=_extra
         lsfit, xdata, ydata, dydata, fitfunc, parms, chimin=chimin, pmima=pmima, _extra=_extra
         xc = min(xdata) + ( max(xdata) - min(xdata) ) * findgen(100)/99
         call_procedure, fitfunc, xc, parms, yc
         
         subtitle = 'C='  + num2string(parms[3]) + ' W=' + num2string(parms[4]) + ' Area=' + num2string(parms[2]) + $
                    ' B=' + num2string(parms[0]) + ' Slope=' + num2string(parms[1])
         plot, xdata, ydata, tit=tit, xtit=xtit, ytit=ytit, subtitle=subtitle, $
               psym=psym, color=color, back=back, xr=xr, yr=yr, /xst, /yst, _extra=_extra 
         errplot, xdata, ydata-dydata, ydata+dydata, color=color, thi=errthick
         oplot, xc, yc, color=color
         
         print, 'Fitting Parameters: ' + ind + ' vs. ' + dep
         print, subtitle
      endif $
      else begin 
         plot, xdata, ydata, tit=tit, xtit=xtit, ytit=ytit, psym=psym, color=color, back=back, xr=xr, yr=yr, /xst, /yst, _extra=_extra 
         errplot, xdata, ydata-dydata, ydata+dydata, color=color, thi=errthick
      endelse
   endelse
   
end;vMACS_plotfiles

