; $Id$
;--------------------------------------------------------------------------------------------------------
; This function takes data as an array input whose columns are specified by the vector columns
; The devices which are compared for concatenation are specified by the vector devs
; 
; Input :
;     data    : data array to be concatenated
;     devs    : devices to be compared for concatenation
;     columns : data array columns
;     
; Output :
;     data    : concatenated data array
;     
; Written by : Vivek Thampy (01/05/2010)     
;--------------------------------------------------------------------------------------------------------
function MACS_concat_data, data, devs, columns 

   n_data  = n_elements(data[0,*])
   n_devs  = n_elements(devs)
   dev_ran = fltarr(n_devs,2)
   dev_col = intarr(n_devs)
   binsize = fltarr(n_devs)
   n_dets  = n_elements(where(strmid(columns,0,4) eq 'SPEC'))
   
   ;-----------------------------------------------------------------------------------------------------
   ; Similar to bkg_sub routine. Binsize and ranges for devices calculated
   ; Index the data on the devices (dev_inds).
   ; The n-dimensional indices (for n devices) are converted into 1-dimensional indices (inds)
   ;-----------------------------------------------------------------------------------------------------
   for i = 0, n_devs-1 do begin
      dev_col[i]   = where(columns eq strupcase(devs[i]))
      binsize[i]   = MACS_calc_binsize(data[dev_col[i],*])
      dev_ran[i,0] = [[min(data[dev_col[i],*]) - binsize[i]/2], [max(data[dev_col[i],*]) + binsize[i]/2]]  
   end 
   
   dev_inds  = long(fix((data[dev_col,*] - rebin(dev_ran[*,0], n_devs, n_data))/rebin(reform(binsize), n_devs, n_data)))
   dev_bins  = round((dev_ran[*,1] - dev_ran[*,0])/binsize)
   
   inds      = dev_inds[0,*]
   for j = 1, n_devs-1 do inds += dev_inds[j,*] * MACS_cmproduct(dev_bins[0:j-1])
   
   ;-----------------------------------------------------------------------------------------------------
   ; Histogram the indices to bin together data with the same indices, i.e. have the same values of devs.
   ; Sum all the data points that lie within the same bin into first element of bin. Return first element
   ; of all occupied bins. 
   ;-----------------------------------------------------------------------------------------------------
   uniq_inds = (inds[sort(inds)])[uniq(inds[sort(inds)])]
   binsize  = min((uniq_inds - shift(uniq_inds,1))[1:*]) 
   h = histogram(inds, binsize=binsize, min=min(inds), reverse_indices=ri)
   
   rep = where(h gt 1, nrep)
   if nrep gt 0 then for i = 0, n_elements(rep)-1 do $ 
      for k = 1, h[rep[i]] - 1 do data[0:2*n_dets, ri[ri[rep[i]]]] += data[0:2*n_dets, ri[ri[rep[i]] + k]]
   
   uniq_inds = where(h gt 0)
   return, data[*, ri[ri[uniq_inds]]]
   
end;MACS_concat_data
