; opan_vanCalProb_widget.pro,v 1.0 11th October 206 tregenna Exp $
;###############################################################################
;
; NAME:
;  opan_vanCalProb_widget
;
; PURPOSE:
;  This widget dialog appears when the vanadium calibration has failed.  The user has the option of
;purging the data set of the troublesome detector groups or to abort the vanadium calibration.
; CATEGORY:
;  TOF Utilities
;
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan_tof_vanCalProb_widget_Events,event
widget_control,event.top,get_uvalue = pState
uname=widget_info(event.id,/uname)
case uname of
'Purge':    $
begin
(*pState).command=1
widget_control,event.top,/destroy
return
end
'Abort':    $
begin
(*pState).command=0
widget_control,event.top,/destroy
return
end
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan_tof_vanCalProb_widget,Faultystring,event=main_event
delim=path_Sep()
read_jpeg,!DAVE_AUXILIARY_DIR+'PSI'+delim+'FOCUS'+delim+'straessle_pic.jpg',image

;
; Centre it.

geom = widget_info(main_event.top, /geometry)
xpos = geom.xoffset + geom.xsize/2 - 100
ypos = geom.yoffset + geom.ysize/2 - 50

msg=strarr(4)
msg[0]='Unable to obtain a reasonable fit of the elastic line'
msg[1]='from '+Faultystring+'.'
msg[2]='Please decide whether to purge the data sets of these detectors'
msg[3]= 'or to abort the vanadium calibration'

tlb = widget_base(title='Trouble with the vanadium calibration',/col,group_leader=main_event.top,xoffset=xpos,yoffset=ypos, $
      tlb_frame_attr = 3,/modal)
Base1=widget_base(tlb,/row)

    s = size(image)
    sx = s[2] & sy = s[3]
aspect = 1.0*sy/sx              ; find the aspect ratio of the image...

picxsize = 55 & picysize = fix(aspect*picxsize)

picbase = widget_base(Base1,xsize = picxsize,ysize = picysize)

picwin = widget_draw(picbase,xsize = picxsize,ysize = picysize)
    dispimage = image

void = widget_text(Base1,value = msg,xsize = 52,ysize=4)
void = widget_button(tlb,value = 'Purge',uname='Purge')
void = widget_button(tlb,value = 'Abort',uname='Abort')

widget_control,tlb,/realize

widget_control,picwin,get_value = picVis


window,/free,/pixmap,xsize = picxsize,ysize = picysize
winpix_straessle = !d.window

wset,winpix_straessle
tvimage,dispImage
wset,picVis

device,copy = [0,0,!d.x_size,!d.y_size,0,0,winpix_straessle]
command=0
state={winpix_straessle:winpix_straessle, $
       command:command}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
xmanager, 'opan_tof_vanCalProb_widget',tlb,event_handler = 'opan_tof_vanCalProb_widget_Events' ;register with the xmanager
command=(*pState).command
wdelete,(*pState).winpix_straessle
ptr_free,pState
return,command
end
