;+
; NAME:
;      TOF_PlotDiffractionData.pro
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;Based on Programs written by:
;       Robert M. Dimeo, Ph.D.
;     NIST Center for Neutron Research
;       100 Bureau Drive
;     Gaithersburg, MD 20899
;       Phone: (301) 975-8135
;       E-mail: robert.dimeo@nist.gov
;       http://www.ncnr.nist.gov/staff/dimeo
;
; CATEGORY:
;
;       Focus Utilities
;
; CALLING SEQUENCE:
;
;      TOF_PlotDiffractionData.pro
;
;
; INPUT FIELDS:
;
;
; EXAMPLES FOR POTENTIALS (must use IDL syntax as shown below):
;
;
; DISCLAIMER
;
;     This software is provided as is without any warranty whatsoever.
;     Permission to use, copy, modify, and distribute modified or
;     unmodified copies is granted, provided this disclaimer
;     is included unchanged.
;
; MODIFICATION HISTORY:
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro TOF_pddClose,event
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro TOF_pddPlot,event
widget_control,event.top,get_uvalue = pState
x = (*pState).x
y = (*pState).y
dy = (*pState).dy
if (*pState).autoscale eq 1 then begin
  xlo = min(x) & xhi = max(x)
  ylo = min(y) & yhi = max(y)
  (*pState).xrange = [xlo,xhi]
  (*pState).yrange = [ylo,yhi]
endif

widget_control,(*pState).XAxis,get_value = val
if val eq 0 then begin
xtitle = '2 Theta / degrees'
title = 'Intensity vs. 2 Theta'
endif
if val eq 1 then begin
xtitle = 'Sin(Theta)/Lambda'
title = 'Intensity vs. Sin(Theta)/Lambda'
endif
if val eq 2 then begin
xtitle = 'Detector Number'
title = 'Intensity vs. Detector Number'
endif


plot,x,y,xrange = (*pState).xrange,yrange = (*pState).yrange, $
     xstyle = 1,ystyle = 1,xtitle = xtitle, $
     ytitle = 'Intensity', title = title,linestyle = 0, $
     thick = 3.0
errplot,x,y-dy,y+dy,width = 0.0

end
;widget_control,(*pState).info,set_value = strout
;
;wset,(*pState).winPix
;sePlot,event
;wset,(*pState).winVis
;device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro TOF_pdddraw,event
widget_control,event.top,get_uvalue = pState
case event.type of
0:  begin       ; button press
      (*pState).mouse = event.press
      if (*pState).mouse eq 4 then begin
        (*pState).autoscale = 1

        wset,(*pState).winPix
        TOF_pddPlot,event
        wset,(*pState).winVis
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
      endif
      if (*pState).mouse eq 1 then begin
        (*pState).xbox[0] = event.x
        (*pState).ybox[0] = event.y
        wset,(*pState).winVis
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
        empty
        (*pState).autoscale = 0
        widget_control,(*pState).win,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).mouse eq 1 then begin
      xll = (*pState).xbox[0] < (*pState).xbox[1]
      yll = (*pState).ybox[0] < (*pState).ybox[1]
      w = abs((*pState).xbox[1] - (*pState).xbox[0])
      h = abs((*pState).ybox[1] - (*pState).ybox[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).xrange = [ll[0],ur[0]]
      (*pState).yrange = [ll[1],ur[1]]
      wset,(*pState).winPix
      TOF_pddplot,event
      wset,(*pState).winVis
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
     if (*pState).mouse eq 4 then begin
      wset,(*pState).winPix
      TOF_pddplot,event
      wset,(*pState).winVis
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion
      if (*pState).mouse eq 1 then begin
       (*pState).xbox[1] = event.x
       (*pState).ybox[1] = event.y
       xc = [(*pState).xbox[0],event.x,event.x,$
             (*pState).xbox[0],$
             (*pState).xbox[0]]
       yc = [(*pState).ybox[0],(*pState).ybox[0],$
             event.y,event.y,$
             (*pState).ybox[0]]
       wset,(*pState).winVis
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro TOF_pddEvents,event
widget_control,event.top,get_uvalue = pState
if event.id eq (*pState).XAxis then begin
widget_control,(*pState).XAxis,get_value = val
if val eq 0 then (*pState).x = (*pState).twotheta
if val eq 1 then (*pState).x = (*pState).sintholam
if val eq 2 then (*pState).x = (*pState).xdet
x=(*pState).x
y= (*pState).y
  xlo = min(x) & xhi = max(x)
  ylo = min(y) & yhi = max(y)
  (*pState).xrange = [xlo,xhi]
  (*pState).yrange = [ylo,yhi]
         wset,(*pState).winPix
   TOF_pddplot,event
   wset,(*pState).winVis
   device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
   return
endif
; Handle the resizing events
ctrlgeom = widget_info((*pState).base,/geometry)
tlbgeom = widget_info(event.top,/geometry)
xsize = event.x
ysize = event.y

newxsize = xsize-ctrlgeom.xsize
newysize = ysize

widget_control,(*pState).win,draw_xsize = newxsize, $
               draw_ysize = newysize
wdelete,(*pState).winPix
window,/free,/pixmap,xsize = newxsize,ysize = newysize
(*pState).winPix = !d.window

wset,(*pState).winPix
TOF_pddplot,event
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function TOF_PlotDiffractionData,data,error,twotheta,lambda,group_leader=group_leader
loadct,0,/silent
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/row,title = 'Plot Diffraction Data Utility')
endif else begin
  tlb = widget_base(group_leader = group_leader, /row,/modal, $
        title = 'Plot Diffraction Data Utility')
endelse



;sum over the time channels
SumData=data
;x is a vector of the phi values
x=twotheta
sintholam=sin((!dtor*twotheta/2.0)/lambda[0])
;print,sintholam
xdet=1+findgen(n_elements(x))
xlo=min(x)
xhi=max(x)
nx=n_elements(SumData)
ylo=min(SumData)
yhi=max(SumData)
y=SumData
dy=error
;ny=n_elements(y)
;remdet=[0]

;if !d.name eq 'WIN' then begin
;  thisFont = "Comic Sans MS*16"
;  bigFont = "Comic Sans MS*20*Bold"
;;endif else begin
;  thisFont = -1
;  bigFont = -1
;endelse

base = widget_base(tlb,/row)
thisbase = widget_base(base,/col)



XAxis_Types = ['2 Theta',$
              'Sin(theta)/Lambda', $
              'Detector Number']
XAxis = cw_bgroup(thisbase,XAxis_Types,/col,/exclusive, $
           set_value = 0,/return_index,/no_release)



void = widget_button(thisbase,value = 'Close',event_pro = 'TOF_pddClose')

xsize = 500 & ysize = 400
win = widget_draw(base,xsize = xsize,ysize = ysize,/button_events, $
      event_pro = 'TOF_pdddraw')

geom = widget_info(base,/geometry)
newysize = geom.ysize
widget_control,win,draw_ysize = newysize
widget_control,tlb,/realize


widget_control,win,get_value = winVis
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPix = !d.window



state = {winVis:winVis, $
         winPix:winPix, $
         autoscale:1, $
         xrange:[xlo,xhi], $
         yrange:[ylo,yhi], $
         xrangedel:[0.0,1.0], $
         yrangedel:[0.0,1.0], $
         xbox:[xlo,xhi], $
         ybox:[ylo,yhi], $
         mouse:0B, $
         win:win, $
         xlo:xlo, $
         xhi:xhi, $
         ylo:ylo, $
         yhi:yhi, $
         XAxis:XAxis, $
         x:x, $
         twotheta:twotheta, $
         sintholam:sintholam, $
         xdet:xdet, $
         y:y, $
         dy:dy, $
         base:base $
         }


pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState

plot,x,y,xrange = (*pState).xrange,yrange = (*pState).yrange, $
     xstyle = 1,ystyle = 1,xtitle = '2 Theta / degrees', $
     ytitle = 'Intensity', title = 'Intensity vs. 2 Theta',linestyle = 0, $
     thick = 3.0

errplot,x,y-dy,y+dy,width = 0.0

wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]


xmanager,'TOF_PlotDiffractionData',tlb,event_handler = 'TOF_pddEvents'

wdelete,(*pState).winPix
ptr_free,pState
return,0
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;