;$Id$
;###############################################################################
;
; NAME:
;  LOAD_SCAN
;
; PURPOSE:
;  Loads in a fixed-window scan file.
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;+
; NAME:
;       LOAD_SCAN
;
; PURPOSE:
;
;		Simple function wrapper for the HSCN_DATA object class.  User can
;		type this function at a command line and the object references
;		are returned in an object array.
;
; AUTHOR:
;
;       Robert M. Dimeo, Ph.D.
;		NIST Center for Neutron Research
;       100 Bureau Drive
;		Gaithersburg, MD 20899
;       Phone: (301) 975-8135
;       E-mail: robert.dimeo@nist.gov
;       http://www.ncnr.nist.gov/staff/dimeo
;
; CATEGORY:
;
;       Data reduction, DAVE project, HFBS
;
; CALLING SEQUENCE:
;
;		OARRAY = LOAD_SCAN	(	FILENAME				$
;								EVENT = event			)
;
; PARAMETERS:
;
;		FILENAME:	Fully path qualified file names of the HSCN files to be loaded.
;					If this parameter is not present then a file selection dialog
;					is launched prompting user to select multiple files.
;
; KEYWORDS:
;
;		EVENT:		Optional input keyword that should be used when this function
;					is called from a widget program.  Otherwise this keyword should
;					not be set.
;
; COMMON BLOCKS:
;
;		None
;
; REQUIREMENTS:
;
;		None
;
; MODIFICATION HISTORY:
;
;       Written by Rob Dimeo, July 10, 2003
;-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function load_scan,filename,event = event
if n_params() eq 0 then begin
	cd,current = this_dir
	main_level = 1
	if n_elements(routine_names('dat_dir',fetch = main_level)) gt 1 then begin
		value = routine_names('dat_dir',fetch = main_level)
	endif else begin
		value = this_dir
	endelse
	cd,value
;	Use the dialog file selection
	if n_elements(event) ne 0 then parent = event.top else parent = 0L
	filename = dialog_pickfile(/read,filter = '*.hscn',dialog_parent = parent, $
		title = 'Select HSCN file(s)',/multiple_files)
	nfiles = n_elements(filename)
	if filename[0] eq '' then return,0
endif
nfiles = n_elements(filename)
for i = 0,nfiles-1 do begin
	if not(file_test(filename[i])) then return,0
endfor
oarray = objarr(nfiles)
for i = 0,nfiles-1 do begin
	o = obj_new('hscn_data',file = filename[i])
	oarray[i] = o
endfor
cd,this_dir
if n_elements(oarray) eq 1 then return,oarray[0] else $
	return,oarray
end