; $Id$
;###############################################################################
;
; NAME:
;  HFBSDETGROUPWIDGET
;
; PURPOSE:
;  Dialog widget that returns an array of detector numbers.
;
; CATEGORY:
;  DAVE, HFBS, utility
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; hfbsDetGroupWidget.pro
;
; Function widget that allows user to select grouping of detectors
; for HFBS.
;
; Written by R.M.Dimeo (11/19/01)
;
; Modification history
; -----------------------
; 11/30/01 (RMD): Fixed an annoying bug that zeroed all detector
; groups out.
;
; 01/17/02 (RMD): Fixed another annoying quirk that caused the
; widget NOT to display the saved grouping values until an event
; was generated.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbsDetGroupQuit,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet
case event.id of
(*pState).accept:		begin
  								end
(*pState).cancel:		begin
								detArray = 0*indgen(ndet,ndet)
								for i = 0,ndet-1 do begin
  									detArray[i,i] = 1
  									*(*pState).selDetPtr = detArray
								endfor
  						end
else:
endcase
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbsDetGroupFours,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet

thisArray = 0*indgen(ndet,ndet)
for i = 0,ndet-1 do begin
  if 4*i lt ndet-1 then begin
    thisArray[i,4*i:4*i+3] = 1
  endif
endfor
*(*pState).selDetPtr = thisArray

widget_control,(*pState).grpSlider,get_value = grpValue, set_slider_max = ndet/4
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState,/no_copy
return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbsDetGroupTwos,event
  widget_control,event.top,get_uvalue = pState,/no_copy
  ndet = (*pState).ndet

  thisArray = 0*indgen(ndet,ndet)
  for i = 0,ndet-1 do begin
    if 2*i lt ndet-1 then begin
      thisArray[i,2*i:2*i+1] = 1
    endif
  endfor
  *(*pState).selDetPtr = thisArray

  widget_control,(*pState).grpSlider,get_value = grpValue, set_slider_max = ndet/2
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

  widget_control,event.top,set_uvalue = pState,/no_copy
  return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbsDetGroupAll,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet

thisArray = 0*indgen(ndet,ndet)
thisArray[0,0:ndet-1] = 1
*(*pState).selDetPtr = thisArray

widget_control,(*pState).grpSlider,get_value = grpValue, set_slider_max = ndet
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbsDetGroupWidget_event,event
; Update the check-boxes after changing the slider bar position
widget_control,event.top,get_uvalue = pState,/no_copy
if event.id eq (*pState).grpSlider then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]
endif
if event.id eq (*pState).group then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).group,get_value = thisArray
  (*(*pState).selDetPtr)[grpValue,*] = thisArray
endif
widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function hfbsDetGroupWidget,group_leader = group_leader,selDetPtr
; Widget definition module


if n_elements(*selDetPtr) eq 0 then begin
  ndet = 16
  selDetPtr = ptr_new(/allocate_heap)
  detArray = 0*indgen(ndet,ndet)
  for i = 0,ndet-1 do begin
    detArray[i,i] = 1
  ;  *selDetPtr = detArray
  endfor

  *selDetPtr = detArray
endif else begin
  ptrSize = size(*selDetPtr)
  ndet = ptrSize[1]
  detArray = *selDetPtr
endelse



if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,tlb_frame_attr = 1,title = 'Group Detectors',/base_align_right)
endif else begin
  tlb = widget_base(/modal,/col,tlb_frame_attr = 1,title = 'Group Detectors',group_leader = group_leader)
endelse
base1 = widget_base(tlb,/row,/base_align_right)
void = widget_button(base1,value = 'Group every two',event_pro = 'hfbsDetGroupTwos')
void = widget_button(base1,value = 'Group every four',event_pro = 'hfbsDetGroupFours')
void = widget_button(base1,value = 'Group all',event_pro = 'hfbsDetGroupAll')
base2 = widget_base(tlb,/row)
base3 = widget_base(tlb,/row)
groupType = string(1+indgen(ndet))
group = cw_bgroup(base2,groupType,row = 4,/nonexclusive,label_top = 'Detector',$
            frame = 1,set_value = detArray[0,*])
grpSlider = widget_slider(base3,value = 1,minimum = 1,maximum = ndet,title = 'Group')
accept = widget_button(base3,value = 'Accept',event_pro = 'hfbsDetGroupQuit')
cancel = widget_button(base3,value = 'Cancel',event_pro = 'hfbsDetGroupQuit')
centertlb,tlb
widget_control,tlb,/realize

state = {accept:accept,$
            cancel:cancel,$
            group:group,$
            ndet:ndet,$
            grpSlider:grpSlider,$
            selDetPtr:selDetPtr}

pState = ptr_new(state)
widget_control,tlb,set_uvalue = pState
xmanager,'hfbsDetGroupWidget',tlb
selDetPtr = (*pState).selDetPtr
ptr_free,pState
thisSize = size(*selDetPtr)
nx = thisSize[1] & ny = thisSize[2]
yout = 0*intarr(nx,ny)
for i = 0,nx-1 do begin
  yout[i,0:ny-1] = (*selDetPtr)[i,0:ny-1]
endfor
return,yout
end

