; returns a value of type that is
;    1) defined as either string, float, integer, string
;
;
;CALLING:  value=getvalue(type='float',Group_leader=gl,title='somevalue')

PRO getvalue_CenterTLB, tlb

; Center the top-level base widget.

screenSize = Get_Screen_Size()
Device, Get_Screen_Size=screenSize
IF screenSize[0] GT 2000 THEN screenSize[0] = screenSize[0]/2
xCenter = screenSize(0) / 2
yCenter = screenSize(1) / 2

geom = Widget_Info(tlb, /Geometry)
xHalfSize = geom.Scr_XSize / 2
yHalfSize = geom.Scr_YSize / 2

Widget_Control, tlb, XOffset = xCenter-xHalfSize, $
   YOffset = yCenter-yHalfSize

END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro getvalue_event,event
  Widget_Control, event.top, Get_UValue=info, /No_Copy

   ; Which button is this?
Widget_Control, event.id, Get_Value=buttonValue
   ; Branch on button value.
CASE string(buttonValue) OF
   'Cancel': BEGIN
              Widget_Control, event.top, /Destroy
             END
   'Accept': BEGIN
         ; Get the value.
         winput=WIDGET_INFO(event.top, FIND_BY_UNAME = 'value')
         ; Save the new color and name in the pointer.
         widget_control,winput,get_value=index
         *(info.ptr) = {index:index}
         ; Destoy the widget.
         Widget_Control, event.top, /Destroy
           END
     else: begin
          *(info.ptr) = {index:buttonvalue}
          Widget_Control, event.top, /Destroy
          end
ENDCASE

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FUNCTION getvalue,$
   Group_Leader=group_leader, $            ; The group leader of the TLB. Required for modal operation.
   type=type,$                             ; What type do you want returned? integer, float?
   Index=index, $                          ; The number where the final selected color should be loaded.
   Title=title                             ; The title of the top-level base widget.

   ; Error handling for this program module.
;
;
;catch,errno
;if (errno ne 0) then begin
;  catch,/cancel
;  void = dialog_message(parent = event.top,/error,["Unknown error detected",!err_string])
;  return,-99
;endif

   ; Check argument values. All arguments are optional.
IF N_Elements(title) EQ 0 THEN title='Input a Value'
IF N_Elements(type) EQ 0 THEN type='float'
IF N_Elements(group_leader) EQ 0 THEN BEGIN
   tlb = Widget_Base(Title=title, Column=1, /Base_Align_Center)
ENDIF ELSE BEGIN
   tlb = Widget_Base(Title=title, Column=1, /Base_Align_Center, /Modal, $
      Group_Leader=group_leader)
ENDELSE

baseID = Widget_Base(tlb, /Column, Event_Pro='getvalue_event')

;type
case type of
   'float' : Result = CW_FIELD( baseID,/floating,uname='value',/return_events,UValue=tlb);tab_mode=2,UValue=tlb)
   'string' : Result = CW_FIELD( baseID,/string,uname='value',/return_events,UValue=tlb);tab_mode=2,UValue=tlb)
   'long' : Result = CW_FIELD( baseID,/long,uname='value',/return_events,UValue=tlb);tab_mode=2,UValue=tlb)
   'integer' : Result = CW_FIELD( baseID,/integer,uname='value',/return_events,UValue=tlb);tab_mode=2,UValue=tlb)
else:Result = CW_FIELD( baseID,/floating,uname='value',/return_events,UValue=tlb);tab_mode=2,UValue=tlb)
endcase
   ; CANCEL and ACCEPT buttons.

buttonbase = Widget_Base(tlb, ROW=1, Align_Center=1, Event_Pro='getvalue_event')
cancelID = Widget_Button(buttonbase, VALUE='Cancel')
acceptID = Widget_Button(buttonbase, VALUE='Accept')

   ; Center the TLB.
getvalue_CenterTLB, tlb
Widget_Control, tlb, /Realize
   ; Set up program event loop. This will be blocking widget
   ; if called from the IDL command line. Program operation
   ; will stop here until widget interface is destroyed.

ptr = Ptr_New({index:-99})
info = { ptr:ptr}
Widget_Control, tlb, Set_UValue=info, /No_Copy

XManager, 'getvalue', tlb

Info = *ptr
Ptr_Free, ptr
   ; Return the value.
RETURN, Info.index
END
