; $Id$
;
;Create a model containing all the sticks associated with the
;given bonds in the model.  If the bonds are too long (i.e. cross
;unit cells) then hide them.  There should be a filter to select
;out the ones that should not be drawn and elminate them before they
;are created as polyline objects.
;

pro threeDenPro_createBondSticks,sticksModel,list,bonds,datapath=currentpath

    sticksmodel = obj_new('idlgrmodel',name='sticksmodel')

    if n_elements(bonds) gt 0 then begin

        sticks = objarr(n_elements(bonds))
    
        for i = 0,n_elements(sticks)-1 do begin
    
          ;FIRST GET XBEGIN AND XEND
          whbeg = -1
          for j=0,n_elements(list)-1 do begin
            ;VERIFY SAME LENGTHS.  IF LENGTHS SAME THEN DO stregex TEST.
            if strlen(list[j]._atom_site_label) eq strlen(bonds[i]._geom_bond_atom_site_label_1) then begin
              if stregex(strlowcase(list[j]._atom_site_label),strlowcase(bonds[i]._geom_bond_atom_site_label_1),/boolean,/fold_case) gt 0 then begin
                  whbeg = j
                  break
              endif
            endif
          endfor;j
    
          whend = -1
          for j=0,n_elements(list)-1 do begin
            ;VERIFY SAME LENGTHS.  IF LENGTHS SAME THEN DO stregex TEST.
            if strlen(list[j]._atom_site_label) eq strlen(bonds[i]._geom_bond_atom_site_label_2) then begin
              if stregex(list[j]._atom_site_label,bonds[i]._geom_bond_atom_site_label_2,/boolean,/fold_case) gt 0 then begin
                  whend = j
                  break
              endif
            endif
          endfor;j
    ;print,'whbeg,whend=',whbeg,whend
          xbond = [list[whbeg].x,list[whend].x]
          ybond = [list[whbeg].y,list[whend].y]
          zbond = [list[whbeg].z,list[whend].z]
    
          calclen = sqrt((xbond[0]-xbond[1])^2 + (ybond[0]-ybond[1])^2 + (zbond[0]-zbond[1])^2)
          diff = calclen-bonds[i]._geom_bond_distance
    
          ;HIDE BONDS THAT CROSS THE UNIT CELL BORDER
          if abs(diff) lt 0.1 then hide = 0 else hide = 1
    
            ; make the sticks
            bondcolor = [10,10,10]
            sticks[i] = obj_new('IDLgrPolyline', xbond,ybond,zbond, color=bondcolor, thick=6.5,hide=hide,name='sticks')
            if hide eq 1 then sticks[i]->setproperty,name='hiddensticks'
            sticksmodel->add,sticks[i]
            
    
        endfor;i
    endif;n_elements(bonds)
    sticksmodel->setproperty,hide=0

    
end;threeDenPro_createBondSticks    
    