; $Id$
;
;Converts one XYZ point from orthogonal coordinates to 
;unit cell coordinates.
;
;Orthogonal coordinates assumes abg = [90,90,90],
;but in reality it is not, so there is a more complicated
;transformation that needs to happen.
;
;
function threeDenPro_convertGRDIsosurfaceCoords,xyz,abc,abg,xvals,yvals,zvals,vol


;
;
;
;THIS NEEDS TO BE VECTORIZED TO OPTIMIZE SPEED.
;
;
;
;

  sz = size(vol)

;  help,vol
;  help,sz



  ;INITIALLY, THE GRID POINTS ARE POSITIONED IN TERMS OF FRACTIONS OF a1,a2,a3
  ;HOWEVER AT THIS POINT THEY HAVE BEEN SCALED TO xvals,yvals,zvals,
  ;
  ;FOR NOW I WILL CONVERT THEM BACK HERE AND THEN DO THE MULTIPLICATION BY a1,a2,a3
  xyz[0] =   (xyz[0] - min(xvals))*(float(sz[1])/(max(xvals)-min(xvals)))/float(sz[1])
  xyz[1] =   (xyz[1] - min(yvals))*(float(sz[2])/(max(yvals)-min(yvals)))/float(sz[2])
  xyz[2] =   (xyz[2] - min(zvals))*(float(sz[3])/(max(zvals)-min(zvals)))/float(sz[3])


  ;BORROWED CALCULATIONS FROM readcifspecial.pro
  ;CONVERTING abc,abg, xyz TO CRYSTALLOGRAPHIC COORDINATES.

  ;CALCULATE ANGLES IN RADIANS
  alpha = !dtor*abg[0]
  beta  = !dtor*abg[1]
  gamma = !dtor*abg[2]
  delta = acos(sqrt( (cos(beta) + cos(alpha)*cos(gamma))^2 + (cos(alpha)*sin(gamma))^2))

  ;CALCULATE PRIMITIVE LATTICE COMPONENTS
  a1 = [abc[0],0,0]
  a2 = abc[1]*[cos(gamma),sin(gamma),0]
  a3 = abc[2]*[cos(beta)+cos(alpha)*cos(gamma),cos(alpha)*sin(gamma),sin(delta)]

  result = xyz[0]*a1 + xyz[1]*a2 + xyz[2]*a3

  return,result


end;threeDenPro_convertCoords
