; $Id$
;
;
;Read data from a CIF file and return the information via
;keywords and arguments.
;
;Return values in 1 for success, 0 for failure.

function threeDenPro_readCIF,$
                        atoms,x,y,z,$
                        list=list,bonds=bonds,$
                        symmetry=symmetry,$
                        ucboxpoints=ucboxpoints,$
                        abc=abc,abg=abg,$
                        datapath=datapath,$
                        filename=filename

;void = dialog_message('STARTING threeDenPro_readCIF')
	;cfn = 'C:\Documents and Settings\kneller\Desktop\GRID\Ce_MOF.cif'
	;cfn = dialog_pickfile(filter='*.cif',path='C:\Documents and Settings\kneller\Desktop\GRID',title='PLEASE SELECT A .cif FILE:')
 
  if n_elements(datapath) eq 0 then datapath = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\'

  ;if n_elements(filename) eq 0 then filename = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\4LarrySpecial.cif'
;	cfn = 'C:\Documents and Settings\kneller\Desktop\GRID\4LarrySpecial.cif'
  if n_elements(filename) ne 0 then begin
    cfn = filename;'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\4LarrySpecial.cif'
  endif else begin
    cfn = dialog_pickfile(filter='*.cif',path=datapath,title='Select a CIF file:') 
    filename = cfn   
  endelse
  if file_test(cfn) ne 1 then begin
    return,0
;    cfn = dialog_pickfile(filter='*.cif',path=datapath,title='Select a CIF file:')
;    print,cfn
;    if cfn ne '' then datapath = file_dirname(cfn)
    
  endif
  
	if cfn ne '' then begin

		natoms = -1
		nbonds = -1
    nsymmetries = -1
		atomstart = -1
		atomend = -1
		bondstart = -1
		bondend = -1
    symmetryStart = -1
    symmetryEnd = -1
    

		print,'cfn=',cfn

		;
		;	;READ THE FILE INTO A STRING ARRAY
			nlines = file_lines(cfn)
			line = ''
			s = strarr(nlines)
			openr,lun,cfn,/get_lun
			readf,lun,s
			free_lun,lun


			;GET THE NUMBER OF ATOMS AND BONDS

			ucboxpoints = dblarr(8,3)


      ;loop_ 
      ;JUST USE A STRING ARRAY INSTEAD. (SEE BELOW).
      sym = {_symmetry_equiv_pos_as_xyz:''} 

			;loop_
			unit = { _atom_site_label:'',$
		 			 _atom_site_type_symbol:'',$
					 _atom_site_fract_x:0d,$
					 _atom_site_fract_y:0d,$
					 _atom_site_fract_z:0d,$
					 _atom_site_U_iso_or_equiv:0d,$
					 _atom_site_adp_type:'',$
					 _atom_site_occupancy:0d,$
					 _atom_site_symmetry_multiplicity:0,$
					 _atom_site_calc_flag:'',$
					 _atom_site_refinement_flags:'',$
					 _atom_site_disorder_assembly:'',$
					 _atom_site_disorder_group:'',$
					 color:[0,0,0],$
					 radius:0d,$
					 x:0d,$
					 y:0d,$
					 z:0d}

		;	list = replicate(unit,201)

		;NEXT GET THE BOND INFO
				;bondstart = 442
				;nbonds = 138


		;TO DEFINE THIS STRUCTURE, COULD PARSE FOR ITEMS BEGINNING WITH AN
		;UNDERSCORE.  ONCE THAT IS SET, THE FIRST NON-UNDERSCORE LINE BEGINS THE DATA
		;WITH THE SAME NUMBER OF SEGMENTS PER LINE AS THE NUMBER OF TAGS IN THE
		;STRUCTURE.

				bond = {_geom_bond_atom_site_label_1:'',$
		 				_geom_bond_atom_site_label_2:'',$
		 				_geom_bond_distance:0.0d,$
		 				_geom_bond_site_symmetry_2:0.0d,$
		 				_geom_bond_publ_flag:''}



		;		bonds = replicate(bond,nbonds)



			;LATTICE ANGLES AND SIDE LENGTHS
			abc = dblarr(3)
			abg = dblarr(3)


			;PRIMITIVE LATTICE
			a1 = dblarr(3)
			a2 = dblarr(3)
			a3 = dblarr(3)

			for i=0,nlines-1 do begin
				line = s[i]

				if stregex(line,'cell_length_a',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abc[0] = double(segs[1])
				endif
				if stregex(line,'cell_length_b',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abc[1] = double(segs[1])
				endif
				if stregex(line,'cell_length_c',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abc[2] = double(segs[1])
				endif
				if stregex(line,'cell_angle_alpha',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abg[0] = double(segs[1])
				endif
				if stregex(line,'cell_angle_beta',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abg[1] = double(segs[1])
				endif
				if stregex(line,'cell_angle_gamma',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abg[2] = double(segs[1])
				endif



				;NOW GET istart_atoms, istart_bonds, n_atoms, n_bonds
				;AND TRY TO GET THE LABELS
				;SHOULD I BOTHER WITH THE SPECIES?????  THE INFORMATION WILL BE READ FROM A DATA FILE.


				if stregex(line,'loop_',/fold_case,/boolean) gt 0 then begin

		;			print,'LOOP!'
		;			print,s[i+1]


          ;HERE ARE THE SYMMETRY EQUIVALENT POSITIONS
          ;NOTE: THIS IS OFTEN HOW THE MAJORITY OF ATOMIC POSITIONS ARE SPECIFIED
          if (strsplit(s[i+1],/extract))[0] eq '_symmetry_equiv_pos_as_xyz' then begin
            symmetryStart = i+2
            j = i+2
            while(n_elements(strsplit(s[j],/extract)) gt 1) do begin
              j++
            endwhile
            symmetryEnd = j-1
            nsymmetries = symmetryEnd-symmetryStart+1
          endif;_symmetry_equiv_pos_as_xyz

					if (strsplit(s[i+1],/extract))[0] eq '_atom_site_label' then begin
						;print,'HERE ARE THE ATOMS!'
						j = i+1
						scheck = s[j]
						while(stregex(s[j],'_atom_site',/fold_case,/boolean)) do begin
							j++
						endwhile
						atomstart = j

						while(n_elements(strsplit(s[j],/extract)) gt 1) do begin
							j++
						endwhile
						atomend = j-1

						print,'atomstart,atomend=',atomstart,atomend
						;print,s[atomstart]
						;print,s[atomend]
						natoms = atomend-atomstart+1
						print,'natoms=',natoms

					endif
					if (strsplit(s[i+1],/extract))[0] eq '_geom_bond_atom_site_label_1' then begin
						;print,'HERE ARE THE BONDS!'
						j = i+1
						scheck = s[j]
						while(stregex(s[j],'_geom_bond',/fold_case,/boolean)) do begin
							j++
						endwhile
						bondstart = j

						while(n_elements(strsplit(s[j],/extract)) gt 1 and (j lt n_elements(s)-1)) do begin

							j++

						endwhile
						bondend = j-1
						print,'bondstart,bondend=',bondstart,bondend
						;print,s[bondstart]
						;print,s[bondend]
						nbonds = bondend-bondstart+1
						;print,'nbonds=',nbonds
					endif
				endif

		endfor;i


		if	atomstart eq atomend or $
			bondstart eq bondend or $
      symmetrystart eq symmetryend or $      
			atomstart eq -1	     or $
			atomend   eq -1		 or $
			bondstart eq -1 	 or	$
			bondend   eq -1		 or $
      symmetryStart eq -1    or $
      symmetryEnd   eq -1    then begin

			return,0

		endif




		;
		;
		;		loop_
		;		 _atom_site_label
		;		 _atom_site_type_symbol
		;		 _atom_site_fract_x
		;		 _atom_site_fract_y
		;		 _atom_site_fract_z
		;		 _atom_site_U_iso_or_equiv
		;		 _atom_site_adp_type
		;		 _atom_site_occupancy
		;		 _atom_site_symmetry_multiplicity
		;		 _atom_site_calc_flag
		;		 _atom_site_refinement_flags
		;		 _atom_site_disorder_assembly
		;		 _atom_site_disorder_group



		;		loop_
		;		 _geom_bond_atom_site_label_1
		;		 _geom_bond_atom_site_label_2
		;		 _geom_bond_distance
		;		 _geom_bond_site_symmetry_2
		;		 _geom_bond_publ_flag


		list = replicate(unit,natoms)

		bonds = replicate(bond,nbonds)

    if nsymmetries gt 0 then begin
      ;symmetry  = '';strarr(nSymmetries);replicate(sym,nSymmetries)
  
      symmetry  = strarr(nSymmetries);replicate(sym,nSymmetries)
      istart = symmetryStart
      for i=istart,istart+nsymmetries-1 do begin
        symmetry[i-istart] = s[i]
      endfor;i
    endif else begin
      symmetry = ''
    endelse



		segs = strsplit(line,/extract)
		istart = atomstart

	;;;Ce1 Ce 0.08344(3) 0.70617(11) 0.33337(14) 0.0301(3) Uani 1 1 d . . .
		atoms = strarr(natoms)
		x = dblarr(natoms)
		y = dblarr(natoms)
		z = dblarr(natoms)


		;if i ge istart and i lt istart+natoms then begin
		for i=istart,istart+natoms-1 do begin

			segs = strsplit(s[i],/extract)

			;ASSUME NOW THAT abc,abg ARE AVAILABLE


			;CALCULATE ANGLES IN RADIANS
			alpha = !dtor*abg[0]
			beta  = !dtor*abg[1]
			gamma = !dtor*abg[2]
			delta = acos(sqrt( (cos(beta) + cos(alpha)*cos(gamma))^2 + (cos(alpha)*sin(gamma))^2))

			;CALCULATE PRIMITIVE LATTICE COMPONENTS
			a1 = [abc[0],0,0]
			a2 = abc[1]*[cos(gamma),sin(gamma),0]
			a3 = abc[2]*[cos(beta)+cos(alpha)*cos(gamma),cos(alpha)*sin(gamma),sin(delta)]


			ucboxpoints[0,*] = [0,0,0]
			ucboxpoints[1,*] = a1
			ucboxpoints[2,*] = a2
			ucboxpoints[3,*] = a3
			ucboxpoints[4,*] = a1+a2
			ucboxpoints[5,*] = a2+a3
			ucboxpoints[6,*] = a1+a3
			ucboxpoints[7,*] = a1+a2+a3




			;CONVERT THE COORDINATES FROM PRIMITIVE LATTICE CORRDS TO XYZ.
			atoms[i-istart] = segs[1]
			coords = a1*double(segs[2]) + a2*double(segs[3]) + a3*double(segs[4])
			;print,'coords=',coords
			x[i-istart] = coords[0]
			y[i-istart] = coords[1]
			z[i-istart] = coords[2]


			list[i-istart]._atom_site_label = segs[0]
			list[i-istart]._atom_site_type_symbol = segs[1]
			list[i-istart]._atom_site_fract_x = double(segs[2])
			list[i-istart]._atom_site_fract_y = double(segs[3])
			list[i-istart]._atom_site_fract_z = double(segs[4])
			list[i-istart]._atom_site_U_iso_or_equiv = double(segs[5])
			if n_elements(segs) gt 6 then list[i-istart]._atom_site_adp_type = segs[6]
			if n_elements(segs) gt 7 then list[i-istart]._atom_site_occupancy = double(segs[7])
			if n_elements(segs) gt 8 then list[i-istart]._atom_site_symmetry_multiplicity = fix(segs[8])
			if n_elements(segs) gt 9 then list[i-istart]._atom_site_calc_flag = segs[9]
			if n_elements(segs) gt 10 then list[i-istart]._atom_site_refinement_flags = segs[10]
			if n_elements(segs) gt 11 then list[i-istart]._atom_site_disorder_assembly = segs[11]
			if n_elements(segs) gt 12 then list[i-istart]._atom_site_disorder_group = segs[12]
			list[i-istart].color = cifcolor(segs[1])
			list[i-istart].radius = cifradius(segs[1])
			list[i-istart].x = x[i-istart]
			list[i-istart].y = y[i-istart]
			list[i-istart].z = z[i-istart]


		endfor;i 	(atoms)



		;segs = strsplit(line,/extract)
		for i = bondstart, bondstart+nbonds-1 do begin
			segs = strsplit(s[i],/extract)
			bonds[i-bondstart]._geom_bond_atom_site_label_1 = segs[0]
			bonds[i-bondstart]._geom_bond_atom_site_label_2 = segs[1]
			bonds[i-bondstart]._geom_bond_distance = double(segs[2])
;			bonds[i-bondstart]._geom_bond_site_symmetry_2 = double(segs[3])
			if n_elements(segs) gt 4 then bonds[i-bondstart]._geom_bond_publ_flag = segs[4]
		endfor;i	(bonds)
		;endfor;i

		return,1
	endif else begin
		return,0
	endelse
end;threeDenPro_readCIF

