; $Id$

function create3DenProMoleculeHierarchy_GetParent,oTool
;GET THE PARENT VIS GROUP FOR THIS TOOL AND RETURN IT.
if n_elements(oTool) eq 0 then oTool = getDenProTool()
          ;ADD ORB OPERATION ID 
          addOpID = 'Operations/Insert/Add Orb'
          
          ;GET THE Add Orb DESCRIPTOR OBJECT
          opDescOrb = oTool->getByIdentifier(addOpID)
          if (~obj_valid(opDescOrb)) then return,obj_new()
          
          
          ;GET THE Add Orb OBJECT ---- THIS WILL BE USED TO 
          oAddOpOrb = opDescOrb->getObjectInstance()
          if (~obj_valid(oAddOpOrb)) then return,obj_new()
          
          ;GET THE CURRENT SETTING OF THE show_execution VARIABLE
          ;showUiSetting WILL HOLD THE CURRENT STATE
          oAddOpOrb->getProperty, show_execution_ui=showUiSetting
          
          ;SET THE show_execution VARIABLE TO 0 SO NO DIALOG IS DISPLAYED
          oAddOpOrb->setProperty, show_execution_ui=0 ; switch off ui - no user interation required
          
          ; Create a sphere
          oAddOpOrb->setProperty, radius=0.16, color=[255,0,0],label='Na_GetParent',xpos=-0.3,ypos=0.3,zpos=0.1
          
          ;THE NEXT LINE CREATES THE SPHERE AND RETURNS ITS iTools IDENTIFIER IN THE DATA HIERARCHY
          void = oAddOpOrb->doAction(oTool,identifier=id)
          
          ;GET THE ACTUAL IDLitVisOrb(?) OBJECT
          sodium = oTool->getByIdentifier(id)
          
          ;FIRST ADD THE GROUP TO THE VISUALIZATION HIERARCHY
          ;NEED TO ACQUIRE THE parent OBJECT:
          sodium->getProperty,_parent=oParent          
          ;oparent->getproperty,_parent=parentsparent
          oParent->remove,sodium  ;REMOVE THIS DUMMY ATOM SINCE WE ARE ONLY INTERESTED  
                                  ;IN ACQUIRING ITS PARENT
          obj_destroy,sodium

  return,oParent
end;create3DenProMoleculeHierarchy_GetParent


pro create3DenProMoleculeHiearchy_getvdWRadius,info,symbol,radius,vdwRadius
  print,symbol
  wh = where(strupcase(info[*].symbol) eq strupcase(symbol))
  if wh[0] eq -1 then begin
    radius = 0.0
    vdwradius = 0.0
  endif else begin
    radius = info[wh[0]].radius
    vdwradius = info[wh[0]].vdwradius
  endelse
  return
end;create3DenProMoleculeHiearchy_getvdWRadius

pro create3DenProMoleculeHiearchy_AtomInfo,info

; Periodic Table Period List
;Element Name  Symbol  Period  Group Block Atomic Number Atomic Weight Covalent Radius vdW Radius
element = {Name:'',Symbol:'',period:'',group:'',Block:'',number:0,weight:'',radius:0.0,vdWRadius:0.0}

s = ['Hydrogen  H 1 1 s 1 1.008   0.23  1.20',$  
     'Deuterium  D 1 1 s 1 2.008   0.23  1.20',$ ;USING HYDROGEN INFORMATION
     'Helium  He  1 18  p 2 4.003   1.50  1.40',$  
     'Lithium Li  2 1 s 3 6.941   0.68  1.82',$  
     'Beryllium Be  2 2 s 4 9.012   0.35  2.00',$  
     'Boron   B 2 13  p 5 10.811  0.83  2.00',$  
     'Carbon  C 2 14  p 6 12.011  0.68  1.70',$  
     'Nitrogen  N 2 15  p 7 14.007  0.68  1.55',$  
     'Oxygen  O 2 16  p 8 15.999  0.68  1.52',$  
     'Fluorine  F 2 17  p 9 18.998  0.64  1.47',$  
     'Neon    Ne  2 18  p 10  20.180  1.50  1.54',$  
     'Sodium  Na  3 1 s 11  22.991  0.97  2.27',$  
     'Magnesium Mg  3 2 s 12  24.305  1.10  1.73',$  
     'Aluminium Al  3 13  p 13  26.982  1.35  2.00',$  
     'Silicon Si  3 14  p 14  28.086  1.20  2.10',$  
     'Phosphorus  P 3 15  p 15  30.974  1.05  1.80',$  
     'Sulphur S 3 16  p 16  32.066  1.02  1.80',$  
     'Chlorine  Cl  3 17  p 17  35.453  0.99  1.75',$  
     'Argon   Ar  3 18  p 18  39.948  1.51  1.88',$  
     'Potassium K 4 1 s 19  39.098  1.33  2.75',$  
     'Calcium Ca  4 2 s 20  40.078  0.99  2.00',$  
     'Scandium  Sc  4 3 d 21  44.956  1.44  2.00',$  
     'Titanium  Ti  4 4 d 22  47.867  1.47  2.00',$  
     'Vanadium  V 4 5 d 23  50.942  1.33  2.00',$  
     'Chromium  Cr  4 6 d 24  51.996  1.35  2.00',$  
     'Manganese Mn  4 7 d 25  54.938  1.35  2.00',$  
     'Iron    Fe  4 8 d 26  55.845  1.34  2.00',$  
     'Cobalt  Co  4 9 d 27  58.933  1.33  2.00',$  
     'Nickel  Ni  4 10  d 28  58.693  1.50  1.63',$  
     'Copper  Cu  4 11  d 29  63.546  1.52  1.40',$  
     'Zinc    Zn  4 12  d 30  65.390  1.45  1.39',$  
     'Gallium Ga  4 13  p 31  69.723  1.22  1.87',$  
     'Germanium Ge  4 14  p 32  72.610  1.17  2.00',$  
     'Arsenic As  4 15  p 33  74.922  1.21  1.85',$  
     'Selenium  Se  4 16  p 34  78.960  1.22  1.90',$  
     'Bromine Br  4 17  p 35  79.904  1.21  1.85',$  
     'Krypton Kr  4 18  p 36  83.800  1.50  2.02',$  
     'Rubidium  Rb  5 1 s 37  85.468  1.47  2.00',$  
     'Strontium Sr  5 2 s 38  87.620  1.12  2.00',$  
     'Yttrium Y 5 3 d 39  88.906  1.78  2.00',$  
     'Zirconium Zr  5 4 d 40  91.224  1.56  2.00',$  
     'Niobium Nb  5 5 d 41  92.906  1.48  2.00',$  
     'Molybdenum  Mo  5 6 d 42  95.940  1.47  2.00',$  
     'Technetium  Tc  5 7 d 43  [98]    1.35  2.00',$  
     'Ruthenium Ru  5 8 d 44  101.070 1.40  2.00',$  
     'Rhodium Rh  5 9 d 45  102.906 1.45  2.00',$  
     'Palladium Pd  5 10  d 46  106.420 1.50  1.63',$  
     'Silver  Ag  5 11  d 47  107.868 1.59  1.72',$  
     'Cadmium Cd  5 12  d 48  112.411 1.69  1.58',$  
     'Indium  In  5 13  p 49  114.818 1.63  1.93',$  
     'Tin   Sn  5 14  p 50  118.71  1.46  2.17',$  
     'Antimony  Sb  5 15  p 51  121.760 1.46  2.00',$  
     'Tellurium Te  5 16  p 52  127.600 1.47  2.06',$  
     'Iodine  I 5 17  p 53  126.904 1.40  1.98',$  
     'Xenon   Xe  5 18  p 54  131.290 1.50  2.16',$
     'Cesium Cs  6 1 s 55  132.905 1.67  2.00',$  
     'Barium  Ba  6 2 s 56  137.327 1.34  2.00',$  
     'Lutetium  Lu  6 3 d 71  174.967 1.72  2.00',$  
     'Hafnium Hf  6 4 d 72  178.490 1.57  2.00',$  
     'Tantalum  Ta  6 5 d 73  180.948 1.43  2.00',$  
     'Tungsten  W 6 6 d 74  183.840 1.37  2.00',$  
     'Rhenium Re  6 7 d 75  186.207 1.35  2.00',$  
     'Osmium  Os  6 8 d 76  190.230 1.37  2.00',$  
     'Iridium Ir  6 9 d 77  192.217 1.32  2.00',$  
     'Platinum  Pt  6 10  d 78  195.078 1.50  1.72',$  
     'Gold    Au  6 11  d 79  196.967 1.50  1.66',$  
     'Mercury Hg  6 12  d 80  200.590 1.70  1.55',$  
     'Thallium  Tl  6 13  p 81  204.383 1.55  1.96',$  
     'Lead    Pb  6 14  p 82  207.200 1.54  2.02',$  
     'Bismuth Bi  6 15  p 83  208.980 1.54  2.00',$  
     'Polonium  Po  6 16  p 84  [210]   1.68  2.00',$  
     'Astatine  At  6 17  p 85  [210]   1.21  2.00',$  
     'Radon   Rn  6 18  p 86  [222]   1.50  2.00',$  
     'Cerium  Ce  6Lan  19  f 58  140.116 1.83  2.00',$  
     'Dysprosium  Dy  6Lan  19  f 66  162.500 1.75  2.00',$  
     'Erbium  Er  6Lan  19  f 68  167.260 1.73  2.00',$  
     'Europium  Eu  6Lan  19  f 63  151.964 1.99  2.00',$  
     'Gadolinium  Gd  6Lan  19  f 64  157.250 1.79  2.00',$  
     'Holmium Ho  6Lan  19  f 67  164.930 1.74  2.00',$  
     'Lanthanum La  6Lan  19  f 57  138.906 1.87  2.00',$  
     'Neodymium Nd  6Lan  19  f 60  144.240 1.81  2.00',$  
     'Promethium  Pm  6Lan  19  f 61  [145]   1.80  2.00',$  
     'Praseodymium Pr 6Lan  19  f 59  140.908 1.82  2.00',$  
     'Samarium  Sm  6Lan  19  f 62  150.360 1.80  2.00',$  
     'Terbium Tb  6Lan  19  f 65  158.925 1.76  2.00',$  
     'Thulium Tm  6Lan  19  f 69  168.934 1.72  2.00',$  
     'Ytterbium Yb  6Lan  19  f 70  173.040 1.94  2.00',$  
     'Francium  Fr  7 1 s 87  [223]   1.50  2.00',$  
     'Radium  Ra  7 2 s 88  [226]   1.90  2.00',$  
     'Lawrencium  Lr  7 3 d 103 [262]   1.50  2.00',$  
     'Lawrencium  Lw  7 3 d 103 [262]   1.50  2.00',$  
     'Rutherfordium Rf  7 4 d 104 [261]   1.50  2.00',$  
     'Dubnium Db  7 5 d 105 [262]   1.50  2.00',$  
     'Seaborgium  Sg  7 6 d 106 [266]   1.50  2.00',$  
     'Bohrium Bh  7 7 d 107 [264]   1.50  2.00',$  
     'Hassium Hs  7 8 d 108 [269]   1.50  2.00',$  
     'Meitnerium  Mt  7 9 d 109 [268]   1.50  2.00',$  
     'Darmstadtium Ds 7 10  d 110 [271]   1.50  2.00',$  
     'Actinium  Ac  7Act  20  f 89  [227]   1.88  2.00',$  
     'Americium Am  7Act  20  f 95  [243]   1.51  2.00',$  
     'Berkelium Bk  7Act  20  f 97  [247]   1.54  2.00',$  
     'Californium Cf  7Act  20  f 98  [251]   1.83  2.00',$  
     'Curium  Cm  7Act  20  f 96  [247]   0.99  2.00',$  
     'Einsteinium Es  7Act  20  f 99  [252]   1.50  2.00',$  
     'Fermium Fm  7Act  20  f 100 [257]   1.50  2.00',$  
     'Mendelevium Md  7Act  20  f 101 [258]   1.50  2.00',$  
     'Nobelium  No  7Act  20  f 102 [259]   1.50  2.00',$  
     'Neptunium Np  7Act  20  f 93  [237]   1.55  2.00',$  
     'Protactinium Pa 7Act  20  f 91  231.036 1.61  2.00',$  
     'Plutonium Pu  7Act  20  f 94  [244]   1.53  2.00',$  
     'Thorium Th  7Act  20  f 90  232.038 1.79  2.00',$  
     'Uranium U 7Act  20  f 92  238.029 1.58  1.86']
     
     nElements = n_elements(s)
     info = replicate(element,nElements)
     
     for i=0,nElements-1 do begin
       segs = strsplit(s[i],/extract)

       info[i].name = segs[0]
       info[i].symbol = segs[1]
       info[i].period = segs[2]
       info[i].group = segs[3]
       info[i].block = segs[4]
       info[i].number = fix(segs[5])
       info[i].weight = segs[6]
       info[i].radius = float(segs[7])
       info[i].vdWRadius = float(segs[8])
       
       ;print,info[i].symbol,info[i].vdwRadius
     endfor;i


end;create3DenProMoleculeHiearchy_AtomInfo



;____________________________________________________________________________________________________________________

pro create3DenProMoleculeHierarchy_AddAtoms,oTool,oGroupAtoms,oParent,list

to = systime(1,/seconds)
oParent = create3DenProMoleculeHierarchy_GetParent()

        ;ADD ORB OPERATION ID 
        addOpID = 'Operations/Insert/Add Orb'
        
        
        ;GET THE Add Orb DESCRIPTOR OBJECT
        opDescOrb = oTool->getByIdentifier(addOpID)
        if (~obj_valid(opDescOrb)) then return
        
        
        ;GET THE Add Orb OBJECT ---- THIS WILL BE USED TO 
        oAddOpOrb = opDescOrb->getObjectInstance()
        if (~obj_valid(oAddOpOrb)) then return
        
        ;GET THE CURRENT SETTING OF THE show_execution VARIABLE
        ;showUiSetting WILL HOLD THE CURRENT STATE
        oAddOpOrb->getProperty, show_execution_ui=showUiSetting
        
        ;SET THE show_execution VARIABLE TO 0 SO BNO DIALOG IS DISPLAYED
        oAddOpOrb->setProperty, show_execution_ui=0 ; switch off ui - no user interation required
        
        ;SEE 3denprro_createomAtomBalls.pro
  
  ;LRK - 061108
        dum = obj_new('idlitvisualization')
        dummyarr = objarr(n_elements(list))
        for i=0,n_elements(list)-1 do begin
        ;for i=0,(5 < (n_elements(list)-1)) do begin
          ;oAddOpOrb->setProperty, radius=0.01, color=[0,0,255],label='dum',xpos=x[i],ypos=y[i],zpos=z[i]
 
 
 ;:NOW INSTEAD OF CREATING A VISUALIZATION INSIDE THE TOOL, CREATE INDIVIDUAL
 ;IDLgrSurfaces AND PUT THOSE INTO THE oGroupAtoms DIRECTLY
 
          dummyarr[i] = obj_new('orb',pos=[list[i].x,list[i].y,list[i].z],$
                              color = list[i].color,radius=list[i].radius,$
                              label=list[i]._ATOM_SITE_TYPE_SYMBOL,$
                              name=list[i]._ATOM_SITE_TYPE_SYMBOL)
; FUNCTION Orb::Init, POS=pos, RADIUS=radius, DENSITY=density, $
;                       TEX_COORDS=tex_coords, _EXTRA=e


;ORIGINAL STUFF IS IN THE VERSIONS SAVED OTHER PLACES.
 
;THE NEXT SEVERAL LINES WERE THE ORIGINAL WHERE THE insert_orb OPERATION WAS REPEATEDLY CALLED. 
;          oAddOpOrb->setProperty,xpos=list[i].x,ypos=list[i].y,zpos=list[i].z,$
;                              color = list[i].color,radius=list[i].radius,label=list[i]._ATOM_SITE_TYPE_SYMBOL;'balls'  
;          void = oAddOpOrb->doAction(oTool,identifier=id)
;          dum = oTool->getByIdentifier(id)
;          oParent->remove,dum
;
;
;;
;
;          oGroupAtoms->add,dum
          dum->add,dummyarr[i],/aggregate
        endfor;i
        ;dum->add,dummyarr;,/aggregate
;help,oGroupAtoms
        oGroupAtoms->add,dum
        ;oParent->add,oGroupAtoms
;        help,oParent
        oGroupAtoms->getProperty,_parent=oParent
;        help,oParent          
        
        
        ;RESTORE THE ORIGINAL show_execution SETTING
        oAddOpOrb->setProperty, show_execution_ui=showUiSetting ; revert to original setting
  
        ;oGroupAtoms->UpdateSelectionVisual
  print,'THIS IS HOW LONG THE ATOMS TOOK:'
  print,systime(1,/seconds)-to

end;create3DenProMoleculeHierarchy_AddAtoms,oTool
;____________________________________________________________________________________________________________________

pro create3DenProMoleculeHierarchy_AddSpaceFillAtoms,oTool,oGroupSpaceFillAtoms,oParent,list

to = systime(1,/seconds)
oParent = create3DenProMoleculeHierarchy_GetParent()

        ;ADD ORB OPERATION ID 
        addOpID = 'Operations/Insert/Add Orb'
        
        
        ;GET THE Add Orb DESCRIPTOR OBJECT
        opDescOrb = oTool->getByIdentifier(addOpID)
        if (~obj_valid(opDescOrb)) then return
        
        
        ;GET THE Add Orb OBJECT ---- THIS WILL BE USED TO 
        oAddOpOrb = opDescOrb->getObjectInstance()
        if (~obj_valid(oAddOpOrb)) then return
        
        ;GET THE CURRENT SETTING OF THE show_execution VARIABLE
        ;showUiSetting WILL HOLD THE CURRENT STATE
        oAddOpOrb->getProperty, show_execution_ui=showUiSetting
        
        ;SET THE show_execution VARIABLE TO 0 SO BNO DIALOG IS DISPLAYED
        oAddOpOrb->setProperty, show_execution_ui=0 ; switch off ui - no user interation required
        
        ;SEE 3denpro_createAtomBalls.pro

        create3DenProMoleculeHiearchy_AtomInfo,info
        
help,info
  
  ;LRK - 061108
        dum = obj_new('idlitvisualization')
        dummyarr = objarr(n_elements(list))
        for i=0,n_elements(list)-1 do begin
        ;for i=0,(5 < (n_elements(list)-1)) do begin
 
 ;:NOW INSTEAD OF CREATING A VISUALIZATION INSIDE THE TOOL, CREATE INDIVIDUAL
 ;IDLgrSurfaces AND PUT THOSE INTO THE oGroupSpaceFillAtoms DIRECTLY
          create3DenProMoleculeHiearchy_getvdWRadius,info,list[i]._ATOM_SITE_TYPE_SYMBOL,radius,vdwradius
print,'Radius=',radius
          ;print,list[i]._ATOM_SITE_TYPE_SYMBOL,radius
;          dummy = obj_new('orb',pos=[list[i].x,list[i].y,list[i].z],$
;                          color = list[i].color,radius=radius,$
;                          label=list[i]._ATOM_SITE_TYPE_SYMBOL,$
;                          name=list[i]._ATOM_SITE_TYPE_SYMBOL)
;          oGroupSpaceFillAtoms->add,dummy
          dummyarr[i] = obj_new('orb',pos=[list[i].x,list[i].y,list[i].z],$
                              color = list[i].color,radius=vdwradius,$;radius,$
                              label=list[i]._ATOM_SITE_TYPE_SYMBOL,$
                              name=list[i]._ATOM_SITE_TYPE_SYMBOL)

          dum->add,dummyarr[i],/aggregate

        endfor;i

        ;dum->add,dummyarr;,/aggregate

;help,oGroupSpaceFillAtoms
        oGroupSpaceFillAtoms->add,dum
        ;oParent->add,oGroupSpaceFillAtoms
        help,oParent
        oGroupSpaceFillAtoms->getProperty,_parent=oParent
        help,oParent          
        
        
        ;RESTORE THE ORIGINAL show_execution SETTING
        oAddOpOrb->setProperty, show_execution_ui=showUiSetting ; revert to original setting
  
        ;oGroupSpaceFillAtoms->UpdateSelectionVisual
  print,'{{{{{{{{{{{{{{{{{{{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}'
  print,'THIS IS HOW LONG THE SPACEFILL ATOMS TOOK:'
  print,systime(1,/seconds)-to
  print,'{{{{{{{{{{{{{{{{{{{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}'

end;create3DenProMoleculeHierarchy_AddSpaceFillAtoms,oTool
;____________________________________________________________________________________________________________________



pro create3DenProMoleculeHierarchy_AddBonds,oTool,oGroupBonds,oParent,bonds,list,symmetries

print,'create3DenProMoleculeHierarchy_AddBonds'
print,'symmetries=',symmetries
help,list
help,bonds


oParent = create3DenProMoleculeHierarchy_GetParent()
to = systime(1,/seconds)
addOpID = 'Operations/Insert/Add Bond'
opDescBond = oTool->getByIdentifier(addOpID)
if (~obj_valid(opDescBond)) then begin
  print,'opDesc = oTool->getByIdentifier("Operations/Insert/Add Bond"): not found!'
  return
endif  
;print,'Got Add Bond Descriptor'  
oAddOpBond = opDescBond->getObjectInstance()
if (~obj_valid(oAddOpBond)) then begin
  print,'oAddOpBond = opDescBond->getObjectInstance(): Operation not found!'
  return
endif  
;print,'Got Add Bond Operation'  
  
oAddOpBond->getProperty, show_execution_ui=showUiSetting
oAddOpBond->setProperty, show_execution_ui=0 ; switch off ui - no user interation required

;help,list
;help,bonds
;    print,'ATOM LIST'
;    print,'__________________________________________________________________________________'
;    print,list[*]._atom_site_label
;    print,'BOND LIST1'
;    print,bonds[*]._geom_bond_atom_site_label_1
;    print,'BOND LIST2'
;    print,bonds[*]._geom_bond_atom_site_label_2
;    print,'__________________________________________________________________________________'

    dum = obj_new('idlitvisualization')
    dummyarr = objarr(n_elements(bonds))
    if n_elements(bonds) gt 0 then begin
;        PRINT,'i have entered the bonds loop!!!!!'
        ;LRK - 061108
        for i = 0,n_elements(bonds)-1 do begin
        ;for i = 0,(100 < n_elements(bonds)-1) do begin
          ;print,bonds[i]._geom_bond_atom_site_label_1,bonds[i]._geom_bond_atom_site_label_2
          

          ;FIRST GET XBEGIN AND XEND

          if bonds[i]._geom_bond_atom_site_label_1 ne '' then begin
            ;THE NEXT LINES REPLACE THE LOOP OVER list
                      whbeg = [-1]
                      dumarr = list[*]._atom_site_label
                      whbeg = where(stregex(strlowcase(dumarr),$
                                     strlowcase(bonds[i]._geom_bond_atom_site_label_1),$
                                     /boolean,/fold_case) gt 0)
                print,'create3DenProMoleculeHierarchy_AddBonds    whbeg=',whbeg
                      whend = [-1]
                        dumarr = list[*]._atom_site_label
                        whend = where(stregex(strlowcase(dumarr),$
                                     strlowcase(bonds[i]._geom_bond_atom_site_label_2),$
                                     /boolean,/fold_case) gt 0)
                print,'create3DenProMoleculeHierarchy_AddBonds    whend=',whend
            
            
            
            
                if whbeg[0] ne -1 and whend[0] ne -1 then begin
                  for ibeg=0,n_elements(whbeg)-1 do begin
                    for iend=0,n_elements(whend)-1 do begin
                                ;print,'whbeg,whend=',whbeg,whend
                                      xbond = [list[whbeg[ibeg]].x,list[whend[iend]].x]
                                      ybond = [list[whbeg[ibeg]].y,list[whend[iend]].y]
                                      zbond = [list[whbeg[ibeg]].z,list[whend[iend]].z]
                                
                                      calclen = sqrt((xbond[0]-xbond[1])^2 + (ybond[0]-ybond[1])^2 + (zbond[0]-zbond[1])^2)
                                      diff = calclen - bonds[i]._geom_bond_distance
                                      ;print,'create3DenProMoleculeHierarchy whbeg,whend,diff=',whbeg,whend,diff
                                
                                      ;HIDE BONDS THAT CROSS THE UNIT CELL BORDER
                                      if abs(diff) lt 2.0 then begin;lt 0.1 then begin  ;hide = 0 else hide = 1  (hide mechanism was for obj graphics version)
                                
                                        
                                          dummyarr[i] = obj_new('idlitvisualization')
                                          ; make the sticks
                                          bondcolor = [50,50,50]
                      
                                          bondbegin = [xbond[0],ybond[0],zbond[0]]
                                          bondend = [xbond[1],ybond[1],zbond[1]]
                                          radius = 0.2
                                          color = bondcolor
                                          p1=20
                                          objs = denPro_g3dviewmakeTube( bondbegin,bondend,radius,color, p1);, _extra=e)
                                          
                                          oPoly = objs[0]
                                          oLine = objs[1]
                                          dummyarr[i]->add,oPoly
                                          dummyarr[i]->add,oLine
                      
                      ;ORIGINAL STUFF IS IN THE VERSIONS SAVED OTHER PLACES.
                                        
                                          dum->add,dummyarr[i];,/aggregate
                                      endif;abs(diff)
                           endfor;iend  
                         endfor;ibeg   
                       endif;whbeg/whend
          endif;bonds[i]._geom_bond_atom_site_label_1 ne ''
        endfor;i
        oGroupBonds->add,dum;,/aggregate
        help,oParent
        oGroupBonds->getProperty,_parent=oParent
        help,oParent          
    endif;n_elements(bonds)


  oAddOpBond->setProperty, show_execution_ui=showUiSetting ; revert to original setting

  print,'THIS IS HOW LONG THE BONDS TOOK:'
  print,systime(1,/seconds)-to
  
end;   create3DenProMoleculeHierarchy_AddBonds
;____________________________________________________________________________________________________________________


function create3DenProMoleculeHierarchy_isContained,dum,container=container,pos=pos
print,'create3DenProMoleculeHierarchy_isContained'
      yn = 0

      c = obj_valid()
      wh = where(obj_isa(c,'idl_container'),count)
      help,wh
      if count gt 0 then cwh = c[wh]
      for i=0,count-1 do begin
        yn = cwh[i]->isContained(dum,position=pos)
      endfor;i

print,'create3DenProMoleculeHierarchy_isContained returning'

      return,yn

end;create3DenProMoleculeHierarchy_checkContained

pro create3DenProMoleculeHierarchy_removeDum,dum;,container=container,ncontainers=ncontainers
  ;IF THE OBJECT dum IS IN A CONTAINER OF ANY KIND, REMOVE IT SO IT CAN BE RE-PARENTED.

      yn = 0

      c = obj_valid()
      wh = where(obj_isa(c,'idl_container'),count)
      ;help,wh
      if count gt 0 then cwh = c[wh]

      och = containsme(dum,count=ccount)
      
      for i=0,ccount-1 do begin
          och[i]->remove,dum
      endfor;i


end;create3DenProMoleculeHierarchy_removeDum


pro create3DenProMoleculeHierarchy_addOneBar,radius,color,label,$
                                             xpos,ypos,zpos,$
                                             xbeg,ybeg,zbeg,$
                                             xend,yend,zend,$
                                             oAddOpUC,oTool,oGroupUC
                                             
    oAddOpUC->setProperty, radius=radius,$ 
                           color=color,$
                           label=label,$
                           xpos=xpos,ypos=ypos,zpos=zpos,$
                           xbeg=xbeg,ybeg=ybeg,zbeg=zbeg,$
                           xend=xend,yend=yend,zend=zend
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id[0])

    create3DenProMoleculeHierarchy_removeDum,dum    
    oGroupUC->add,dum
end;create3DenProMoleculeHierarchy_addOneBar


pro create3DenProMoleculeHierarchy_AddUCOutline,oTool,oGroupUC,oParent,abc,abg,nx,ny,nz


  
        ;NOW ADD THE UNIT CELL OUTLINE USING op_addunitcelloutline
        print,'NOW ADD THE UNIT CELL OUTLINE USING op_addunitcelloutline'
        
    addOpID = 'Operations/Insert/Add Unit Cell Outline'
    opDescUC = oTool->getByIdentifier(addOpID)
    if (~obj_valid(opDescUC)) then begin
      print,'opDescUC = oTool->getByIdentifier("Operations/Insert/Add Unit Cell Outline"): not found!'
      return
    endif  
    ;print,'Got Add Unit Cell Outline Descriptor'  
    oAddOpUC = opDescUC->getObjectInstance()
    if (~obj_valid(oAddOpUC)) then begin
      print,'oAddOpUC = opDescUC->getObjectInstance(): Operation not found!'
      return
    endif  
    ;print,'Got Add Bond Operation'  
      
    oAddOpUC->getProperty, show_execution_ui=showUISetting
    oAddOpUC->setProperty, show_execution_ui=0 ; switch off ui - no user interation required

    print,abc,abg

    duh = ThreeDenPro_createVolVertices(abc,abg,nx,ny,nz,corners=corners)


    n1 = 4
    n2 = 3
    colors = bytarr(3,n2)
    colors[*,0] = [240,0,0]
    colors[*,1] = [0,240,0]
    colors[*,2] = [0,0,240]

    labels = ['UCX','UCY','UCZ']
    i1 = [[0,3,4,7],[0,1,4,5],[0,1,3,2]]
    i2 = [[1,2,5,6],[3,2,7,6],[4,5,7,6]]

    for i=0,n1-1 do begin
      for j = 0,n2-1 do begin
        create3DenProMoleculeHierarchy_addOneBar,0.1,colors[*,j],labels[j],$
                                                 corners[0,i1[i,j]],corners[1,i1[i,j]],corners[2,i1[i,j]],$
                                                 corners[0,i1[i,j]],corners[1,i1[i,j]],corners[2,i1[i,j]],$
                                                 corners[0,i2[i,j]],corners[1,i2[i,j]],corners[2,i2[i,j]],$
                                                 oAddOpUC,oTool,oGroupUC
      endfor;j
    endfor;i

    oAddOpUC->setProperty, show_execution_ui=showUISetting ; switch off ui - no user interation required

end;create3DenProMoleculeHierarchy_AddUCOutline

pro create3DenProMoleculeHierarchy_BuildSymmetries,list

print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
help,list,/structure
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'
print,'create3DenProMoleculeHierarchy_BuildSymmetries'

  
end;create3DenProMoleculeHierarchy_BuildSymmetries

pro createGRD, oTool,oParent,oGroupGRD,nodata=nodata
        compile_opt idl2


;help,oParent
;help,oGroupGRD

        opID = 'Operations/Insert/Add GRD'
        opDesc = oTool->getByIdentifier(opID)
        if (~obj_valid(opDesc)) then return
        oOp = opDesc->getObjectInstance()
        if (~obj_valid(oOp)) then return

        oOp->setProperty, show_execution_ui=1


        void = oOp->doAction(oTool,filename=filename,nodata=nodata); adds GRD + isosurface
        ;void = oOp->doAction(oTool,identifier=id) ; adds GRD + isosurface
        ;dum = oTool->getByIdentifier(id)
        ;oParent->remove,dum
        ;oGroupGRD->add,dum
        
        
        
        ; Retrieve isosurface and make it semi-transparent
        ids = oTool->findIdentifiers('*isosurface*',/visualization,count=cnt)
        if (cnt eq 1) then begin
            ; expect a single isosurface!
        
            ;THIS COULE BE DONE IN TWO STEPS
            void = oTool->doSetProperty(ids[0],'transparency', 50) ; set transparency to 55%
        endif

        

end;createGRD

pro createCIF,oTool,nodata=nodata,oData=oData,oVis=oVis,oHierarchy=oHierarchy,oParmSet=oParmSet

if n_elements(oTool) eq 0 then oTool = getDenProTool()


;NOW GET THE DATA FROM THE oData OBJECT
if n_elements(oData) ne 0 then begin
          print,'CreateCIF: RECEIVED oData'
          ;EXTRACT THE DATA FROM oData
          oatoms = oData->getByName('atoms')
          ox = oData->getByName('x')
          oy = oData->getByName('y')
          oz = oData->getByName('z')
          olist = oData->getByName('list')
          obonds = oData->getByName('bonds')
          oucboxpoints = oData->getByName('ucboxpoints')
          oabc = oData->getByName('abc')
          oabg = oData->getByName('abg')          
          odatapath = oData->getByName('datapath')
          osymmetries = oData->getByName('symmetry')
          

;          help,oatoms,ox,oy,oz,olist,odata,obonds,oucboxpoints,oabc,oabg,odatapath

          dum = oAtoms->getData(atoms)
          dum = ox->getData(x)
          dum = oy->getData(y)
          dum = oz->getData(z)
          dum = olist->getData(list)
          dum = oBonds->getData(bonds)
          dum = oucboxpoints->getdata(ucboxpoints)
          dum = oabc->getData(abc)
          dum = oabg->getData(abg)
          dum = oDataPath->getData(dataPath)
          dum = oSymmetries->getData(symmetries)

tempabc=abc
tempabg=abg
          oParmSet = OBJ_NEW('IDLitParameterSet',NAME='Unit Cell INFO SET',ICON='volume', $
                  DESCRIPTION='UNIT CELL INFORMATION')

          oParm = OBJ_NEW('IDLitDataIDLVector', $
                           tempabc,$
                           NAME='ABC', TYPE='IDLVector')
          oParmSet->add, oParm, PARAMETER_NAME="ABC"

          oParm = OBJ_NEW('IDLitDataIDLVector', $
                           tempabg,$
                           NAME='ABG', TYPE='IDLVector')                
          oParmSet->add, oParm, PARAMETER_NAME="ABG"




          oParent = create3DenProMoleculeHierarchy_GetParent(oTool)
          
          
          
          
;print,'obj_isa(oparent,"idlitvisualization")=',obj_isa(oparent,"idlitvisgroup")
          nodata = 1
                        ;filename = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\4LarrySpecial.cif'
  
            ;print,CIFReadResult
            
            
            ;SET UP THE HIERARCHY OF THE VISUAL ELEMENTS OF THE SYSTEM.
            if n_elements(list) ne 0 then begin
                  ;IDLitVisGroup is a subclass of IDLitVisualization 
                  oGroupHierarchy = obj_new('IDLitvisGroup',name='Hierarchy',/manipulator_target)
                  oHierarchy=oGroupHierarchy
                  oVis = oGroupHierarchy
  
                  oGroupMolecule = obj_new('IDLitvisGroup',name='Molecule',/manipulator_target)
                  oGroupAtoms = obj_new('IDLitvisGroup',name='MoleculeAtoms',/manipulator_target)
                  oGroupSpaceFillAtoms = obj_new('IDLitvisGroup',name='MoleculeSpaceFillAtoms',/manipulator_target,show=0)
                  oGroupBonds = obj_new('IDLitvisGroup',name='MoleculeBonds',/manipulator_target)
                  oGroupUC = obj_new('IDLitvisGroup',name='MoleculeUC',/manipulator_target)
                  oGroupGRD = obj_new('IDLitvisGroup',name='DensityGRD',/manipulator_target)

                  oParent->add, oGroupHierarchy
                  oGroupHierarchy->add,oGroupGRD
                  oGroupHierarchy->add,oGroupMolecule
                  oGroupMolecule->add, oGroupAtoms
                  oGroupMolecule->add, oGroupSpaceFillAtoms
                  oGroupMolecule->add, oGroupBonds
                  oGroupHierarchy->add, oGroupUC


                 ;create3DenProMoleculeHierarchy_BuildSymmetries,list
                 create3DenProMoleculeHierarchy_AddAtoms,oTool,oGroupAtoms,oParent,list      
    
                 print,'createCIF - ADDING BONDS'
                 
                 yn = dialog_message('Do you want to add bonds?',/question)

                 if yn eq 'Yes' then begin
                   create3DenProMoleculeHierarchy_AddBonds,oTool,oGroupBonds,oParent,bonds,list,symmetries
                 endif;bonds
                 create3DenProMoleculeHierarchy_AddSpaceFillAtoms,oTool,oGroupSpaceFillAtoms,oParent,list

        
;                ;READ IN A GRID FILE HERE, ALTHOUGH THIS WILL EVENTUALLY BE DONE IN A READ_GRID FILE READER
;                ;AT THIS STAGE THE GRD FILE IS ONLY FOR PRACTICE AND TO GET REASONABLE NUMBERS FOR nx,ny,nz
;              
                 nx = n_elements(x);128
                 ny = n_elements(y);64
                 nz = n_elements(z);64
;                 create3DenProMoleculeHierarchy_AddUCOutline,oTool,oGroupUC,oParent,abc,abg,nx,ny,nz
                 nodata = 0
           endif

          return

endif else begin

          oParent = create3DenProMoleculeHierarchy_GetParent(oTool)
          ;print,'create3DenProMoleculeHierarchy---- createCIF'
          ;help,oParent
          nodata = 1
  ;help,/traceback
          filename = dialog_pickfile(path='C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\',$
                                     filter = '*.cif',title='Select a CIF file:')

          ;READ IN THE DATA FROM A CIF FILE
          CIFReadResult = threeDenPro_readCIF2(atoms,x,y,z,$
                                  list=list,bonds=bonds,$
                                  ucboxpoints=ucboxpoints,$
                                  abc=abc,abg=abg,$
                                  datapath=datapath,$
                                  filename= filename)

          
          ;if n_elements(filename) eq 0 then begin
          if CIFReadResult eq 0 then begin
            nodata = 1
            return;NO CIF FILE AT BEGINNING
          endif else begin
          
                        ;filename = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\4LarrySpecial.cif'
  
            ;print,CIFReadResult
            
            
            ;SET UP THE HIERARCHY OF THE VISUAL ELEMENTS OF THE SYSTEM.
            if n_elements(list) ne 0 then begin
                  ;IDLitVisGroup is a subclass of IDLitVisualization 
                  oGroupHierarchy = obj_new('IDLitvisGroup',name='Hierarchy',/manipulator_target)
                  oGroupMolecule = obj_new('IDLitvisGroup',name='Molecule',/manipulator_target)
                  oGroupAtoms = obj_new('IDLitvisGroup',name='MoleculeAtoms',/manipulator_target)
                  oGroupBonds = obj_new('IDLitvisGroup',name='MoleculeBonds',/manipulator_target)
                  oGroupUC = obj_new('IDLitvisGroup',name='MoleculeUC',/manipulator_target)
                  oGroupGRD = obj_new('IDLitvisGroup',name='DensityGRD',/manipulator_target)
        
                  oParent->add, oGroupHierarchy
                  oGroupHierarchy->add,oGroupGRD
                  oGroupHierarchy->add,oGroupMolecule
                  oGroupMolecule->add, oGroupAtoms
                  oGroupMolecule->add, oGroupBonds
                  oGroupHierarchy->add, oGroupUC
        
                 create3DenProMoleculeHierarchy_AddAtoms,oTool,oGroupAtoms,oParent,list      
    
                 print,'createCIF - ADDING BONDS'
                 
                 create3DenProMoleculeHierarchy_AddBonds,oTool,oGroupBonds,oParent,bonds,list
        
;                ;READ IN A GRID FILE HERE, ALTHOUGH THIS WILL EVENTUALLY BE DONE IN A READ_GRID FILE READER
;                ;AT THIS STAGE THE GRD FILE IS ONLY FOR PRACTICE AND TO GET REASONABLE NUMBERS FOR nx,ny,nz
;                 nx = 128
;                 ny = 64
;                 nz = 64
;                 create3DenProMoleculeHierarchy_AddUCOutline,oTool,oGroupUC,oParent,abc,abg,nx,ny,nz
                 nodata = 0
           endif else begin    ;list
             nodata = 1
           endelse
         endelse
endelse

end;createCIF
pro create3DenProMoleculeHierarchy,oTool,filename=filename,nodata=nodata
    compile_opt idl2

    ;NEED THE VISUALIZATION GROUP PARENT FOR EVERYTHING ELSE THAT IS DONE
    oParent = create3DenProMoleculeHierarchy_GetParent(oTool)

    createCIF,oTool,nodata=nocifdata
    createGRD, oTool,oParent,oGroupGRD,nodata=nogrddata
    if ((nocifdata eq 1) and (nogrddata eq 1)) then nodata = 1 else nodata = 0

end;create3DenProMoleculeHierarchy
