
;===============================================================================
function Op_AddOrbs::DoAction, oTool, identifier=idorb
compile_opt idl2

;print,'Op_AddOrbs::DoAction'

; Run UI if switched on
self->GetProperty, show_execution_ui=doUI
if (doUI) then begin    
    ;; Record initial value for the offset property of this operation.
    ;if (~self->RecordInitialValues(oCmdSet,self,'')) then begin
    ;    obj_destroy, oCmdSet
    ;    return, obj_new()
    ;endif

    ;; Use the build-in 'PropertySheet' UI service to let the user
    ;; customize the operation's property.
    result =  oTool->DoUIService('PropertySheet',self)
    if (~result) then begin
        ;obj_destroy, oCmdSet
        return, obj_new()
    endif
    
    ;; Record final value for the offset property of this operation.
    ;if (~self->RecordFinalValues(oCmdSet,self,'')) then begin
    ;    obj_destroy, oCmdSet
    ;    return, obj_new()
    ;endif
endif

; Grap current orb parameters
pos = [self._xpos,self._ypos,self._zpos]
radius = self._radius
label = self._label
color = self._color
style=self._style
;print,label

;get the create viz operation:
oCreateVis = oTool->GetService("CREATE_VISUALIZATION")
if (~obj_valid(oCreateVis)) then return, obj_new()

; create an object descriptor for an orb
orbDesc = oTool->getVisualization('ORB')
if (~obj_valid(orbDesc)) then return, obj_new()

; Generate the orb:
oCommand = oCreateVis->_Create(orbDesc,name=label,color=color,style=style,radius=radius,pos=pos $
                               ,id_visualization=idOrb,isotropic=1)
obj_destroy, oCommand           ; no undo/redo for this implementation

; Get the object ref for the created orb
;oVisOrb = oTool->GetByIdentifier(idOrb)
; Retrieve the dataspace
;if (obj_valid(oVisOrb) then begin
;    oDataSpace = oVisOrb->getDataSpace()
;
;endif


return, obj_new()               ; don't bother with undo/redo
end




;===============================================================================
pro Op_AddOrbs::GetProperty, xpos=xpos, ypos=ypos, zpos=zpos, radius=radius, label=label, color=color, style=style, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(label)) then $
   label =  self._label

if (arg_present(color)) then $
   color =  self._color

if (arg_present(style)) then $
   style =  self._style

if (arg_present(xpos)) then $
   xpos =  self._xpos

if (arg_present(ypos)) then $
   ypos =  self._ypos

if (arg_present(zpos)) then $
   zpos =  self._zpos

if (arg_present(radius)) then $
   radius =  self._radius

; call base class accessor
if(n_elements(etc) gt 0) then $
  self->IDLitOperation::GetProperty, _EXTRA=etc



end


;===============================================================================
pro Op_AddOrbs::SetProperty, xpos=xpos, ypos=ypos, zpos=zpos, radius=radius,label=label, color=color, style=style, _EXTRA=etc

if (n_elements(label) gt 0) then $
  self._label = label

if (n_elements(color) gt 0) then $
  self._color = color

if (n_elements(radius) gt 0) then $
  self._radius = radius

if (n_elements(style) gt 0) then $
  self._style = style

if (n_elements(xpos) gt 0) then $
  self._xpos = xpos

if (n_elements(ypos) gt 0) then $
  self._ypos = ypos

if (n_elements(zpos) gt 0) then $
  self._zpos = zpos

; Call base class mutator
if(n_elements(etc) gt 0) then $
  self->IDLitOperation::SetProperty, _EXTRA=etc 

end


;===============================================================================
function Op_AddOrbs::Init, _REF_EXTRA=etc
compile_opt idl2

;print,'Beginning:      Op_AddOrbs::Init'

; call superclass init
if (~self->IDLitOperation::Init(NAME='Add Orb' $
                                ,_EXTRA=etc)) then return, 0

; Unhide the SHOW_EXECUTION_UI property
self->SetPropertyAttribute, 'SHOW_EXECUTION_UI', hide=0

; This operation is reversible
; This operation is not expensive
;self->SetProperty, reversible_operation=1, expensive_operation=0

; Register an operation properties for this operation
self->RegisterProperty, 'label', /string, description='Orb label' $
  ,name='Label',sensitive=1
self->RegisterProperty, 'radius', /float, description='Radius of Orb' $
  ,name='Radius',sensitive=1
self->RegisterProperty, 'color', /color, description='Orb Color' $
  ,name='Color',sensitive=1
self->RegisterProperty, 'style', description='Orb Style',enumlist=['0','1','2'] $
  ,name='Style',sensitive=1
self->RegisterProperty, 'xpos', /float, description='X Location of Orb' $
  ,name='X Position',sensitive=1
self->RegisterProperty, 'ypos', /float, description='Y Location of Orb' $
  ,name='Y Position',sensitive=1
self->RegisterProperty, 'zpos', /float, description='Z Location of Orb' $
  ,name='Z Position',sensitive=1

self._label = ''
self._color=[0b,0b,0b]
self._style=2
; init location to origin
self._xpos = 0.0
self._ypos = 0.0
self._zpos = 0.0

;init radius to 5
self._radius = 5

;print,'Ending:      Op_AddOrbs::Init'

; return success
return, 1

end


;===============================================================================
pro Op_AddOrbs__define
compile_opt idl2

struc = {Op_AddOrbs $
         ,inherits IDLitOperation $
         ,_radius:0.0 $         ;
         ,_xpos:0.0 $           ;
         ,_ypos:0.0 $           ;
         ,_zpos:0.0 $           ;
         ,_label:'' $
         ,_style:0 $
         ,_color:[0b,0b,0b] $
        }

end
