; $Id$
;
;Following Richard's manual p. 31ff.
;
;

function DAVEReadCIF::IsA,strFilename
compile_opt idl2


  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif
;PRINT,'THIS VERSION IS CURRENT AS OF 5/30/08'
;  print,'DAVEReadCIF::IsA   -   Checking '+strFilename

  ;CALL THE BASE CLASS READER TO DETERMINE IF THE EXTENSION IS RIGHT.
  if (~self->IDLitReader::IsA(strFilename)) then return,0

;  print,'DAVEReadCIF::IsA    -    There is a CIF or cif EXTENSION.'
  ;FOR THE REAL CHECK I MAY NEED TO SIMPLY READ THE FILE AND SEE WHAT HAPPENS.


  return,1
end;DAVEReadCIF::IsA


;DAVEreadCIF::getData  IS SUPPOSED TO DO ALL OF THE WORK OF READING THE DATA. 
function DAVEreadCIF::getData,oData
compile_opt idl2

;print,'DAVEreadCIF::getData'

  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif

  oTool = self->getTool()
  if (not obj_valid(oTool)) then return,0
  
  filename = self->getFilename()

print,'Before threeDenPro_readCIF'
  ;NOW I NEED TO CALL threeDenPro_readCIF
;  ret =  threeDenPro_readCIF(atoms,x,y,z,$
;                             list=list,bonds=bonds,$
;                             symmetry=symmetry,$
;                             ucboxpoints=ucboxpoints,$
;                             abc=abc,abg=abg,$
;                             datapath=datapath,$
;                             filename=filename)

  ret =  threeDenPro_readCIF2(atoms,x,y,z,$
                             list=list,bonds=bonds,$
                             symmetry=symmetry,$
                             ucboxpoints=ucboxpoints,$
                             abc=abc,abg=abg,$
                             datapath=datapath,$
                             filename=filename)


  listdata = obj_new('idlitdata',list,name='list')
  atomsdata = obj_new('idlitdata',atoms,name='atoms')
  bondsdata = obj_new('idlitdata',bonds,name='bonds')
  xdata = obj_new('idlitDataIDLVector',x,name='x')
  ydata = obj_new('idlitDataIDLVector',y,name='y')
  zdata = obj_new('idlitDataIDLVector',z,name='z')
  symmetrydata = obj_new('IDLitData',symmetry,name='symmetry')
  ucboxpointsdata = obj_new('IDLitData',ucboxpoints,name='ucboxpoints')
  abcdata = obj_new('idlitDataIDLVector',abc,name='abc',type='IDLVECTOR')
  abgdata = obj_new('idlitDataIDLVector',abg,name='abg',type='IDLVECTOR')
  datapathdata = obj_new('idlitdata',datapath,name='datapath',type='STRING')
  filenamedata = obj_new('idlitdata',filename,name='filename',type='STRING')
  
  ;NOW I NEED TO CONVERT THIS TO AN OBJECT 
  ;THE DATA WILL BE PUT INTO oData.

  ;oData = obj_new('IDLitDataContainer',name=filename,identifier='id_'+filename,type='DAVECIFDATASET') 
;  oData = obj_new('IDLitParameterSet',name=file_basename(filename),identifier='id_'+filename,type='DAVECIFDATASET')
  oData = obj_new('IDLitParameterSet',name=file_basename(filename),identifier='id_'+file_basename(filename),type='DAVECIFDATASET')

  ;NOTE: DAVE2 DOES NOT WORK WITH AN ARRAY OF STRUCTURES, BUT IT DOES NOT CRASH ON THEM EITHER.
  oData->add,listdata,parameter_name='list'
  oData->add,atomsdata,parameter_name='atoms'
  oData->add,bondsdata,parameter_name='bonds'
  oData->add,xdata,parameter_name='x'
  oData->add,ydata,parameter_name='y'
  oData->add,zdata,parameter_name='z'
  oData->add,symmetrydata,parameter_name='symmetry'
  oData->add,ucboxpointsdata,parameter_name='ucboxpoints'
  oData->add,abcdata,parameter_name='abc'
  oData->add,abgdata,parameter_name='abg'
  odata->add,datapathdata,parameter_name='datapath'
  oData->add,filenamedata,parameter_name='filename'


  return,ret

end;DAVEreadCIF::getData
;;---------------------------------------------------------------------------
;; DAVEReadCIF::GetData
;;
;; Purpose:
;; Read the image file and return the data in the data object.
;;
;; Parameters:
;;
;; Returns 1 for success, 0 otherwise.
;;
;function DAVEReadCIF::GetData, oCIFData
;
;    compile_opt idl2, hidden
;
;
;print,'DAVEReadCIF::GetData'
;
;    strFilename = self->GetFilename()
;
;    if (self->Isa(strFilename) eq 0) then $
;        return, 0
;
;    status = threeDenPro_readCIF( atoms,x,y,z,$
;                                  list=list,bonds=bonds,$
;                                  symmetry=symmetry,$
;                                  ucboxpoints=ucboxpoints,$
;                                  abc=abc,abg=abg,$
;                                  filename=strFilename)
;    if(status eq 0)then return, status
;
;    help,atoms,x,y,z,list,bonds,symmetry,ucboxpoints,abc,abg
;    
;    oCIFData = OBJ_NEW('IDLitData',NAME=FILE_BASENAME(strFileName))
;    result = oCIFData->SetData(list,'list',/no_copy)
;
;
;
;
;    return, result
;
;end;DAVEReadCIF::GetData


;----------------------------------------------------------------------------
; Purpose:
;   This reader reads CIF data.
;
function DAVEReadCIF::Init, _Ref_Extra=etc
    compile_opt idl2, hidden

  print,'DAVEReadCIF::Init'
    ; Init superclass
    if (self->IDLitReader::Init(['cif','CIF'], $
        NAME='Crystallographic Information File', $
        DESCRIPTION="Crystallographic Information File (CIF)", $
        _EXTRA=_extra) eq 0) then $
        return, 0

    if n_elements(etc) gt 0 then self->setProperty,_Extra=etc

    return, 1
end;DAVEReadCIF::Init



;;;---------------------------------------------------------------------------
;;; DAVEReadCIF::Isa
;;;
;;; Purpose:
;;;   Method that will return true if the given file a CIF.
;;;
;;; Paramter:
;;;   strFilename  - The file to check
;
;function DAVEReadCIF::Isa, strFilename
;   compile_opt idl2, hidden
;
;  print,'DAVEReadCIF::Isa'
;  help,strFilename
;  ;print,strFilename
;   return,1;query_jpeg(strFilename);
;
;end;DAVEReadCIF::Isa

;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; DAVEReadCIF__Define
;
; Purpose:
; Class definition for the DAVEReadCIF class
;

pro DAVEReadCIF__Define
  ; Pragmas
  compile_opt idl2, hidden
print,'DAVEReadCIF__Define'

  void = {DAVEReadCIF, $
          inherits IDLitReader}
end;DAVEReadCIF__Define


