; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
pro dcs_renormalizeDAVEfile,event
;************************************************************************************************
;
compile_opt strictarr
;
; This is a procedure that reads a set of DAVE files, renormalizes the quantities qty and err,
; and writes new versions with "_n" appended to the root file name.
;
if (n_elements(event) eq 0) then begin
	group_leader=0
endif else begin
	widget_control,event.top,sensitive=0
	group_leader=event.top
	if (widget_info(event.id,find_by_uname="help") ne 0) then begin
		res=dialog_message([$
			'Renormalize one or more DAVE files','',$
			'This is a procedure that reads a set of DAVE files,',$
			'renormalizes the quantities qty and err, and writes',$
			'new versions with "_n" appended to the root file name.',$
			'','Do you wish to proceed?'],$
			/question)
		if (res eq "No") then goto,sensitize
	endif
endelse
;
; Get multiplicative factor.
renorm=1.e6
renorm=string(renorm)
dave_get_values,"Enter multiplicative factor","Factor",renorm,$
	cancel=cancel,group_leader=group_leader
if (cancel) then goto,sensitize
renorm=float(renorm[0])
;
; Get files to be processed.
inputfilenames=dialog_pickfile(path="C:\DCS data\Price\",$
	title="Select one or more files",filter="*.dave",get_path=gpath,/multiple_files)
if (inputfilenames[0] eq "") then goto,sensitize
inputfilenames=inputfilenames[sort(inputfilenames)]
;
; Read each file, modify it, and write a new file.
nfiles=n_elements(inputfilenames)
print,"There are ",nfiles," files to be processed."
;
for k=0,nfiles-1 do begin
	inputfilename=inputfilenames[k]
;
	outputfilename=strmid(inputfilename,0,strlen(inputfilename)-5)+"_n.dave"
;
	print,"Reading "+inputfilename
	restore,inputfilename
;
	(*(*(*daveptr).datastrptr).commonstr.histptr).qty=$
		(*(*(*daveptr).datastrptr).commonstr.histptr).qty*renorm
	(*(*(*daveptr).datastrptr).commonstr.histptr).err=$
		(*(*(*daveptr).datastrptr).commonstr.histptr).err*renorm
	*(*(*daveptr).datastrptr).commonstr.treatmentptr=$
		[*(*(*daveptr).datastrptr).commonstr.treatmentptr,$
		"Qty and err arrays multiplied by"+strcompress(renorm)+"."]
	save,filename=outputfilename,davePtr
	print,"File "+outputfilename+" written."
	print,""
endfor
;
res=dialog_message(["Normal exit"],/information)
;
sensitize:
if (n_elements(event) gt 0) then widget_control,event.top,sensitive=1
free_all_ptrs,davePtr
close,/all
;
end