; Written by J.R.D. Copley.
;************************************************************************************************
pro dcs_idlsummary,interactive=interactive
;************************************************************************************************
;
compile_opt strictarr
;
if (n_elements(interactive) eq 0) then interactive=1
;
; Choose a directory.
if (interactive) then begin
	directory=dialog_pickfile(path="g:",title = 'Select a run file directory',/directory)
endif else begin
	directories=file_search("\\Solo\DCS data\*",/test_directory)
	directories=directories[reverse(where(strmatch(directories,'*200*')))]
	directory=directories[0]+"\"
endelse
;
; Generate a string array containing the names of the files in the chosen directory.
files=file_search(directory+"*.dcs*")
if (files[0] eq '' or files[0] eq ' ') then begin
	if (interactive) then res=dialog_message("No files found.")
	return
endif
;
nfiles=n_elements(files)
res="Yes"
if (interactive) then res=dialog_message(strcompress(nfiles)+" files found.  Proceed?",/question)
if (res eq "No") then return
;
files=files[sort(files)]
;
; Generate an array containing the file names in "short form", e.g. '20031109_023'
shortform_files=files
for k=0,nfiles-1 do begin
	file=files[k]
	ending=strpos(file,".dcs")
	startname=strpos(strmid(file,0,ending),"_",/reverse_search)-8
	file=strmid(file,startname,ending-startname)
	shortform_files[k]=file
endfor
;
; These labels identify the quantities to be stored in the output file.
labels=["Start date","Stop date","Comments","Users","Wavelength","Master speed","Speed ratio","Resolution","tsdmin","Duration",$
	"Shutter status","Collimator status","Setpoint temperature","Number of cycles","Cycle time","Motors","Phases","Delays","Check flags"]
;
; A bunch of string arrays, one per quantity.
startdate=strarr(nfiles)
stopdate=strarr(nfiles)
comments=strarr(nfiles)
users=strarr(nfiles)
wls=strarr(nfiles)
mss=strarr(nfiles)
srs=strarr(nfiles)
res=strarr(nfiles)
tsdmin=strarr(nfiles)
duration=strarr(nfiles)
shutter=strarr(nfiles)
collimator=strarr(nfiles)
tsetpoint=strarr(nfiles)
ncycles=strarr(nfiles)
cycletime=strarr(nfiles)
motors=strarr(nfiles)
phases=strarr(nfiles)
delays=strarr(nfiles)
checks=strarr(nfiles)
;
; These lines required by DCS raw data read routine.
dave_makeDavePtr,davePtr=davePtr
dcs_definedavestructure,davePtr=davePtr
defsysv,'!debug',0
nofirstline=0
printinfo=0
omithisto=3
filetype="binary"
;
; Loop over runs,
for irun=0,nfiles-1 do begin
	if (interactive) then print,'Processing run ',irun+1,' of ',nfiles
	dcs_readdatafile,files[irun],omithisto,printinfo,filetype,davePtr=davePtr
;
; Start populating string arrays.
; Start and stop dates.
	startdate[irun]=' '+(*(*(*davePtr).dataStrPtr).specificPtr).start_date
	stopdate[irun]=' '+(*(*(*davePtr).dataStrPtr).specificPtr).stop_date
;
; Comment and user entries (user was unknown pre-November 2003)
	comments[irun]=' '+(*(*(*davePtr).dataStrPtr).specificPtr).comments
	user=(*(*(*davePtr).dataStrPtr).specificPtr).user
	if (user eq "xxx") then users[irun]=" Unknown" else users[irun]=' '+user
;
; Wavelength and master speed.
	wls[irun]=string((*(*(*davePtr).dataStrPtr).specificPtr).ch_wl,format='(f8.3)')+' A'
	mss[irun]=string(fix(0.5+(*(*(*davePtr).dataStrPtr).specificPtr).ch_ms),format='(i8)')+' rpm'
;
; Chopper speed ratio.
	if ((*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom gt 1) then begin
		if ((*(*(*davePtr).dataStrPtr).specificPtr).ch_srmode eq 1) then begin
			srs[irun]=' 1/'+strcompress(string((*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom),/remove_all)
		endif else begin
			srs[irun]=' '+string((*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom-1)+"/"+$
				strcompress(string((*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom),/remove_all)
		endelse
	endif else begin
		srs[irun]=' 1/1'
	endelse
;
; Resolution mode.
	ires=(*(*(*davePtr).dataStrPtr).specificPtr).ch_res
	if (ires eq 1) then res[irun]=" LOW"
	if (ires eq 2) then res[irun]=" MEDIUM"
	if (ires eq 3) then res[irun]=" HIGH"
;
; 'tsdmin' and run duration.
	tsdmin[irun]=string(fix(0.5+(*(*(*davePtr).dataStrPtr).specificPtr).tsdmin),format='(i8)')+' us'
	duration[irun]=string(fix(0.5+(*(*(*davePtr).dataStrPtr).specificPtr).duration),format='(i8)')+' s'
;
; Local shutter staus.
	shut=(*(*(*davePtr).dataStrPtr).specificPtr).shutter_stat
	if (shut eq -1) then shutter[irun]=" Unknown"
	if (shut eq 0) then shutter[irun]=" Closed"
	if (shut eq 1) then shutter[irun]=" Open"
;
; Collimator status.
	coll=(*(*(*davePtr).dataStrPtr).specificPtr).coll_osc
	if (coll eq 0) then collimator[irun]=" Stopped"
	if (coll eq 1) then collimator[irun]=" Oscillating"
;
; Temperature set point.
	tsetpoint[irun]=string((*(*(*davePtr).dataStrPtr).specificPtr).temp_setpoint,format='(f9.2)')+' K'
;
; Number of cycles and cycle time (unknown pre-November 2003)
	ncycles[irun]=(*(*(*davePtr).dataStrPtr).specificPtr).runinfo[0]
	if (ncycles[irun] eq -1) then ncycles[irun]=" Unknown"
	ctime=(*(*(*davePtr).dataStrPtr).specificPtr).runinfo[1]
	if (ctime eq -1) then cycletime[irun]=" Unknown" else cycletime[irun]=string(fix(0.5+ctime),format='(i8)')+' s'
;
; Motor positions
	motors[irun]=strjoin(string((*(*(*davePtr).dataStrPtr).specificPtr).motor_pos,format='(f8.2)'),',   ')
;
; Chopper phases
	phases[irun]=strjoin(string(0.01*(*(*(*davePtr).dataStrPtr).specificPtr).ch_phase,format='(f8.2)'),',   ')
;
; Chopper delays
	delays[irun]=strjoin(string(fix(0.5+(*(*(*davePtr).dataStrPtr).specificPtr).ch_delay),format='(i8)'),',   ')
;
;	Checkstats flag (unknown pre-November 2003)
	checkstat=(*(*(*davePtr).dataStrPtr).specificPtr).runinfo[2]
	if (checkstat eq -1) then checks[irun]=" Checkstats unknown"
	if (checkstat eq 0) then checks[irun]=" Checkstats OFF"
	if (checkstat eq 1) then checks[irun]=" Checkstats ON"
;
;	Rectemp flag (unknown pre-November 2003)
	rectemp=(*(*(*davePtr).dataStrPtr).specificPtr).runinfo[3]
	if (rectemp eq -1) then checks[irun]=checks[irun]+", Rectemp unknown"
	if (rectemp eq 0) then checks[irun]=checks[irun]+", Rectemp OFF"
	if (rectemp eq 1) then checks[irun]=checks[irun]+", Rectemp ON"
endfor
;
; This file information structure contains all the information generated above.
fileinfo={$
	startdate:startdate,$
	stopdate:stopdate,$
	comments:comments,$
	users:users,$
	wls:wls,$
	mss:mss,$
	srs:srs,$
	res:res,$
	tsdmin:tsdmin,$
	duration:duration,$
	shutter:shutter,$
	collimator:collimator,$
	tsetpoint:tsetpoint,$
	ncycles:ncycles,$
	cycletime:cycletime,$
	motors:motors,$
	phases:phases,$
	delays:delays,$
	checks:checks}
;
; Generate output file name and save labels,short form file names and file information structure.
if (interactive) then begin
	outfilename='C:\dave_cvs\dave\programs\summaryfiles\dcs\DCSfilesummary_'+strmid(directory,strpos(directory,'200'),6)+'.sav'
	instrument="DCS"
	save,/compress,filename=outfilename,instrument,labels,shortform_files,fileinfo
endif
;
free_all_ptrs,davePtr
if (interactive) then print,'File ',outfilename,' has been created.'
;
end
