;************************************************************************************************
pro getlattice_params_cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
end

;************************************************************************************************
pro getlattice_params_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'getlattice_params_handler: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue=pst
;
if (event.id eq (*pst).quit) then begin
	widget_control,event.top,/destroy
	return
endif
;
; This is where we do the calculation.
; Get a,b,c.
a=0.0
b=0.0
c=0.0
widget_control,(*pst).getabc,get_value=res
res=strsplit(res,' ,',/extract)
nres=n_elements(res)
if (nres le 0) then widget_control,(*pst).answer,set_value="No good"
a=float(res[0])
if (nres gt 1) then b=float(res[1])
if (nres gt 2) then c=float(res[2])
;
; Get al,be,ga.
al=0.0
be=0.0
ga=0.0
widget_control,(*pst).getalbega,get_value=res
res=strsplit(res,' ,',/extract)
nres=n_elements(res)
if (nres le 0) then widget_control,(*pst).answer,set_value="No good"
al=float(res[0])
if (nres gt 1) then be=float(res[1])
if (nres gt 2) then ga=float(res[2])
;
if (a le 0.0) then a=1.0
if (b le 0.0) then b=a
if (c le 0.0) then c=b
if (al le 0.0) then al=90.0
if (be le 0.0) then be=al
if (ga le 0.0) then ga=be
;
; Determine crystal system (this may not be quite right).
; See International Tables (brief teaching edition) volume A, section 2.1.
system="TRICLINIC"
if ((al eq ga or al eq be) and al eq 90.0) then system="MONOCLINIC"
if (al eq be and be eq ga and a eq b and b eq c) then system="TRIGONAL"
if (al eq 90.0 and be eq 90.0 and ga eq 120.0 and a eq b) then system="HEXAGONAL"
if (al eq 90.0 and be eq 90.0 and ga eq 90.0) then begin
	system="ORTHORHOMBIC"
	if (a eq b) then system="TETRAGONAL"
	if (b eq c) then system="CUBIC"
endif
;
; Get wavelength.
widget_control,(*pst).getlambda,get_value=res
lambda=float(res)
;
; Write out results.
f='(f7.3)'
widget_control,(*pst).getabc,set_value=strcompress(string(a,format=f)+","+string(b,format=f)+","+string(c,format=f))
widget_control,(*pst).getalbega,set_value=strcompress(string(al,format=f)+","+string(be,format=f)+","+string(ga,format=f))
widget_control,(*pst).getlambda,set_value=strcompress(string(lambda,format=f))
(*pst).quans[0]=a
(*pst).quans[1]=b
(*pst).quans[2]=c
(*pst).quans[3]=al
(*pst).quans[4]=be
(*pst).quans[5]=ga
(*pst).quans[6]=lambda
;
end


;************************************************************************************************
pro getlattice_params,pst,abc,lambda0,group_leader=group_leader
;************************************************************************************************
;
compile_opt strictarr
;
; Generate the widget.
tlb=widget_base(title="Lattice params",$
	/col,group_leader = group_leader,/modal)
	base1=widget_base(tlb,/col)
	font="TIMESROMAN*16"
	if (abc.a eq 0) then begin
		abcstr='4.05'
		albegastr='90.0'
	endif else begin
		abcstr=strcompress(string(abc.a)+string(abc.b)+string(abc.c))
		albegastr=strcompress(string(abc.al)+string(abc.be)+string(abc.ga))
	endelse
	getabc=cw_field(base1,/string,fieldfont=font,font=font,$
		/column,title="a,  b,  c (A)",value=abcstr,/return_events)
	getalbega=cw_field(base1,/string,fieldfont=font,font=font,$
		/column,title="alpha,  beta,  gamma (deg)",value=albegastr,/return_events)
	docalc=widget_button(tlb,value='Reformat')
	getlambda=cw_field(base1,/string,fieldfont=font,font=font,$
			/column,title="lambda (A)",value=strcompress(string(lambda0)),/return_events)
	quit=widget_button(tlb,value='Proceed')
centertlb,tlb
widget_control,tlb,/realize
;
state={$
	getabc:getabc,$
	getalbega:getalbega,$
	getlambda:getlambda,$
	docalc:docalc,$
	quans:fltarr(7),$
	quit:quit}
;
pst=ptr_new(state)
widget_control,tlb,set_uvalue=pst
;
; Initial calculation using default lattice parameters.
getlattice_params_handler,{top:tlb,id:docalc,handler:0l}
;
; Manage the widget.
xmanager,'getlattice_params',tlb,/no_block,cleanup='getlattice_params_cleanup',$
	event_handler='getlattice_params_handler'
;
end
