;************************************************************************************************
pro dcs_multiplot_detectors_by_module,shuffle
;************************************************************************************************
compile_opt strictarr
;
; Sort detectors by input module.
; 'shuffle' is a 912-element vector as follows:
;  0  31  62  93 124 155 186 217 248 279 310 341 372 403 434 465 496 527 558 589 620 651 682 713 744 775 806 837 868 899
;  1  32  63  94 125 156 187 218 249 280 311 342 373 404 435 466 497 528 559 590 621 652 683 714 745 776 807 838 869 900
; ...
; 13  44  75 106 137 168 199 230 261 292 323 354 385 416 447 478 509 540 571 602 633 664 695 726 757 788 819 850 881 912
; 14  45  76 107 138 169 200 231 262 293 324 355 386 417 448 479 510 541 572 603 634 665 696 727 758 789 820 851 882
; 15  46  77 108 139 170 201 232 263 294 325 356 387 418 449 480 511 542 573 604 635 666 697 728 759 790 821 852 883
; ...
; 29  60  91 122 153 184 215 246 277 308 339 370 401 432 463 494 525 556 587 618 649 680 711 742 773 804 835 866 897
; 30  61  92 123 154 185 216 247 278 309 340 371 402 433 464 495 526 557 588 619 650 681 712 743 774 805 836 867 898
;
k=indgen(899)
k=reform(k,31,29)
k=transpose(k)
k=[k,transpose([indgen(14)+899,replicate(999,17)])]
k1=reform(k[*,0:13],420)
print,''
k2=reform(k[0:28,14:30],493)
shuffle=[k1,k2]
;print,shuffle
end;


;************************************************************************************************
pro dcs_multiplot_getmask,mask,filename,pState,bnk
;************************************************************************************************
; This routine allows the user to mask two of the three banks of detectors.
compile_opt strictarr
;
mask=bytarr(913)+1
bank=999
if ((*pState).dmask) then begin
	answer=dialog_message([filename,' ',"Mask lower and middle banks?"],/question)
	if (answer eq "Yes") then begin
		bank=1
	endif else begin
		answer=dialog_message([filename,' ',"Mask lower and upper banks?"],/question)
		if (answer eq "Yes") then begin
			bank=0
		endif else begin
			bank=-1
		endelse
	endelse
	dcs_getangles,nhedet=913,angles,banks,azim_angles,racks
	mask=bytarr(913)
	mask[where(banks eq bank)]=1
endif
;
case bank of
	-1: bnk=" (Lo bnk)"
	 0: bnk=" (Midbnk)"
	 1: bnk=" (Hi bnk)"
	 else: bnk=""
endcase
;
end


;************************************************************************************************
pro dcs_multiplot_populate,filename,addingtofile,pState=pState,davePtr=davePtr
;************************************************************************************************
; This routine populates portions of the structure (*pState).
compile_opt strictarr
;
not_addingtofile=1-addingtofile
;
bnk=""
;
; Determine whether the file is or is to be treated as a background file
averaging=0
if (strpos(strlowcase(filename),'bgdsum') gt 0) then begin
	answer=dialog_message(['This file appears to be a background file.',$
		'If so, it will be averaged over time channels.',$
		'Is that acceptable?'],/question)
	averaging=(answer eq "Yes")
endif
not_averaging=1-averaging
;
; If this is the first dataset, populate all relevant fields.
if ((*pState).ndatasets eq 1 and not_addingtofile) then begin
; Reading histohigh in DCS raw data files
	if((*pState).ReadingDCShigh) then begin
; If the x array is 2-dimensional, set the number of datasets = 0 and return
		ndx=size(total( (*(*(*davePtr).dataStrPtr).specificPtr).histohigh,2 ),/n_dimensions)
		if (ndx gt 1) then begin
			res=dialog_message('The x array must be 1-dimensional.',/error)
				(*pState).ndatasets=0
			return
		endif
; If the y array is 2-dimensional, set the number of datasets = 0 and return.
		ndy=size(total( (*(*(*davePtr).dataStrPtr).specificPtr).histohigh,1 ),/n_dimensions)
		if (ndy gt 1) then begin
			res=dialog_message('The y array must be 1-dimensional.',/error)
				(*pState).ndatasets=0
			return
		endif
;
		*(*pState).pqty=(*(*(*davePtr).dataStrPtr).specificPtr).histohigh
		*(*pState).perr=sqrt((*(*(*davePtr).dataStrPtr).specificPtr).histohigh)
		*(*pState).px=((*(*(*davePtr).dataStrPtr).commonStr.histPtr).x)
		*(*pState).py=findgen(18)
		(*pState).xlabel=(*(*davePtr).dataStrPtr).commonStr.xlabel
		(*pState).ylabel="High end number"
		(*pState).histlabel=(*(*davePtr).dataStrPtr).commonStr.histlabel
		(*pState).xunits=(*(*davePtr).dataStrPtr).commonStr.xunits
		(*pState).yunits=(*(*davePtr).dataStrPtr).commonStr.yunits
		(*pState).histunits=(*(*davePtr).dataStrPtr).commonStr.histunits
		(*pState).xtype=(*(*davePtr).dataStrPtr).commonStr.xtype
		(*pState).ytype=(*(*davePtr).dataStrPtr).commonStr.ytype
		*(*pState).activePtr=1
		*(*pState).hilitePtr=1
		*(*pState).multiplierPtr=1.0
		*(*pState).constantsPtr=0.0
		*(*pState).filesPtr=filename
		*(*pState).durationsPtr=(*(*(*davePtr).dataStrPtr).specificPtr).duration
		*(*pState).srdenomsPtr=(*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom
		if ((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_control[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_setpoint[0] eq 300.0) then begin
			*(*pState).temperaturesPtr=10000.0
		endif else begin
			ntemps=min(where((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample eq -1.1))
			if (ntemps eq -1) then begin
				*(*pState).temperaturesPtr=10000.0
			endif else begin
				*(*pState).temperaturesPtr=$
					total((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample[0:ntemps-1])/ntemps
			endelse
		endelse
		*(*pState).commentsPtr=(*(*(*davePtr).dataStrPtr).specificPtr).comments+$
			((*pState).dnumb ? "-ADN" : "")+bnk
;
; If what's to be plotted is histogrammed in x, convert it to points format.
		if (strlowcase((*pState).xtype) eq "histogram") then begin
			npx=0.5*((*(*pState).px)[0:n_elements(*(*pState).px)-2]+$
				(*(*pState).px)[1:n_elements(*(*pState).px)-1])
			ptr_free,(*pState).px
			(*pState).px=ptr_new(npx)
		endif
;
; If it's histogrammed in y, convert it to points format.
		if (strlowcase((*pState).ytype) eq "histogram") then begin
			npy=0.5*((*(*pState).py)[0:n_elements(*(*pState).py)-2]+$
			(*(*pState).py)[1:n_elements(*(*pState).py)-1])
			ptr_free,(*pState).py
			(*pState).py=ptr_new(npy)
		endif
;
		return
;
  endif else begin
; The rest of Data: ReadDCS and ReadDAVE
; If the x array is 2-dimensional, set the number of datasets = 0 and return.
		ndx=size(((*(*(*davePtr).dataStrPtr).commonStr.histPtr).x),/n_dimensions)
		if (ndx gt 1) then begin
			res=dialog_message('The x array must be 1-dimensional.',/error)
			(*pState).ndatasets=0
			return
		endif
; If the y array is 2-dimensional, set the number of datasets = 0 and return.
		ndy=size(((*(*(*davePtr).dataStrPtr).commonStr.histPtr).y),/n_dimensions)
		if (ndy gt 1) then begin
			res=dialog_message('The y array must be 1-dimensional.',/error)
			(*pState).ndatasets=0
			return
		endif
;
		if (not_averaging) then begin
			if((*pState).ReadingDCS) then begin
				dcs_multiplot_getmask,mask,filename,pState,bnk
				dims=size((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty,/dimensions)
				mask=rebin(1#mask,dims[0],dims[1])
				*(*pState).pmask=mask
				*(*pState).pqty=((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty)*mask
				*(*pState).perr=((*(*(*davePtr).dataStrPtr).commonStr.histPtr).err)*mask
			endif else begin
				*(*pState).pqty=((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty)
				*(*pState).perr=((*(*(*davePtr).dataStrPtr).commonStr.histPtr).err)
			endelse
		endif else begin
			dims=size((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty,/dimensions)
			*(*pState).pqty=(intarr(dims[0])+1)#total((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty,1)/dims[0]
			*(*pState).perr=intarr(dims[0],dims[1])
		endelse
		*(*pState).px=((*(*(*davePtr).dataStrPtr).commonStr.histPtr).x)
		*(*pState).py=((*(*(*davePtr).dataStrPtr).commonStr.histPtr).y)
		(*pState).xlabel=(*(*davePtr).dataStrPtr).commonStr.xlabel
		(*pState).ylabel=(*(*davePtr).dataStrPtr).commonStr.ylabel
		(*pState).histlabel=(*(*davePtr).dataStrPtr).commonStr.histlabel
		(*pState).xunits=(*(*davePtr).dataStrPtr).commonStr.xunits
		(*pState).yunits=(*(*davePtr).dataStrPtr).commonStr.yunits
		(*pState).histunits=(*(*davePtr).dataStrPtr).commonStr.histunits
		(*pState).xtype=(*(*davePtr).dataStrPtr).commonStr.xtype
		(*pState).ytype=(*(*davePtr).dataStrPtr).commonStr.ytype
		*(*pState).activePtr=1
		*(*pState).hilitePtr=1
		*(*pState).multiplierPtr=1.0
		*(*pState).constantsPtr=0.0
		*(*pState).filesPtr=filename
		*(*pState).durationsPtr=(*(*(*davePtr).dataStrPtr).specificPtr).duration
		*(*pState).srdenomsPtr=(*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom
		if ((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_control[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_setpoint[0] eq 300.0) then begin
			*(*pState).temperaturesPtr=10000.0
		endif else begin
			ntemps=min(where((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample eq -1.1))
			if (ntemps eq -1) then begin
				*(*pState).temperaturesPtr=10000.0
			endif else begin
				*(*pState).temperaturesPtr=$
					total((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample[0:ntemps-1])/ntemps
			endelse
		endelse
		*(*pState).commentsPtr=(*(*(*davePtr).dataStrPtr).specificPtr).comments+$
			((*pState).dnumb ? "-ADN" : "")+bnk
;
; If what's to be plotted is histogrammed in x, convert it to points format.
		if (strlowcase((*pState).xtype) eq "histogram") then begin
			npx=0.5*((*(*pState).px)[0:n_elements(*(*pState).px)-2]+$
				(*(*pState).px)[1:n_elements(*(*pState).px)-1])
			ptr_free,(*pState).px
			(*pState).px=ptr_new(npx)
		endif
;
; If it's histogrammed in y, convert it to points format.
		if (strlowcase((*pState).ytype) eq "histogram") then begin
			npy=0.5*((*(*pState).py)[0:n_elements(*(*pState).py)-2]+$
				(*(*pState).py)[1:n_elements(*(*pState).py)-1])
			ptr_free,(*pState).py
			(*pState).py=ptr_new(npy)
		endif
		return
	endelse
endif
;
; If this is not the first dataset, populate the qty, err, active, hilite
;   and file fields, but first do some compatibility tests.
;
; First of all, if the dimensions of qty do not match, decrement the number of
; datasets and return.
; if high end calculatio skip to "all is well"
; Treat the case ReadingDCShigh

if((*pState).ReadingDCShigh) then begin
	dims=size((*(*(*davePtr).dataStrPtr).specificPtr).histohigh,/dimensions)
	if ((dims[0] ne long((*pState).xdim)) or (dims[1] ne long((*pState).ydim))) then begin
		res=dialog_message('Dataset dimensions do not match.',/error)
		(*pState).ndatasets=(*pState).ndatasets-1
		return
	endif
endif else begin
	dims=size((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty,/dimensions)
	if ((dims[0] ne long((*pState).xdim)) or (dims[1] ne long((*pState).ydim))) then begin
		res=dialog_message('Dataset dimensions do not match.',/error)
		(*pState).ndatasets=(*pState).ndatasets-1
		return
	endif
endelse
;
; If the x arrays do not match, decrement the number of datasets and return.
; If necessary, convert to points format before making the comparison.
; An exception is made if the run is a background run.
new=(*(*(*davePtr).dataStrPtr).commonStr.histPtr).x
if (strlowcase((*pState).xtype) eq "histogram") then $
	new=0.5*(new[0:n_elements(new)-2]+new[1:n_elements(new)-1])
	nmatch=total(*(*pState).px eq new)
	if (nmatch ne dims[0]) then begin
		if (not_averaging) then begin
		res=dialog_message('x values do not match.',/error)
		(*pState).ndatasets=(*pState).ndatasets-1
		return
	endif
endif
;
; If the y arrays do not match, decrement the number of datasets and return.
; If necessary, convert to points format before making the comparison.
; Treat Case ReadingDCShigh for y arrays

if((*pState).ReadingDCShigh) then begin
	new=findgen(18)
	if (strlowcase((*pState).ytype) eq "histogram") then $
		new=0.5*(new[0:n_elements(new)-2]+new[1:n_elements(new)-1])
		nmatch=total(*(*pState).py eq new)
	if (nmatch ne dims[1]) then begin
		res=dialog_message('y values do not match.',/error)
		(*pState).ndatasets=(*pState).ndatasets-1
		return
	endif
endif else begin
	new=(*(*(*davePtr).dataStrPtr).commonStr.histPtr).y
	if (strlowcase((*pState).ytype) eq "histogram") then $
		new=0.5*(new[0:n_elements(new)-2]+new[1:n_elements(new)-1])
		nmatch=total(*(*pState).py eq new)
	if (nmatch ne dims[1]) then begin
		res=dialog_message('y values do not match.',/error)
		(*pState).ndatasets=(*pState).ndatasets-1
		return
	endif
endelse
;
; Since all is well, either append to the appropriate arrays or increment final contributions.
;
if (not_addingtofile) then begin
; Case ReadingDCShigh
	if((*pState).ReadingDCShigh) then begin
		oldptrs=[(*pState).pqty,$
			(*pState).perr,$
			(*pState).activePtr,$
			(*pState).hilitePtr,$
			(*pState).multiplierPtr,$
			(*pState).constantsPtr,$
			(*pState).filesPtr,$
			(*pState).durationsPtr,$
			(*pState).srdenomsPtr,$
			(*pState).temperaturesPtr,$
			(*pState).commentsPtr]
		(*pState).pqty=ptr_new([[[*(*pState).pqty]],$
			[[(*(*(*davePtr).dataStrPtr).specificPtr).histohigh]]],/no_copy)
		(*pState).perr=ptr_new([[[*(*pState).perr]],$
			[[sqrt((*(*(*davePtr).dataStrPtr).specificPtr).histohigh)]]],/no_copy)
		(*pState).activePtr=ptr_new([*(*pState).activePtr,1])
		(*pState).hilitePtr=ptr_new([*(*pState).hilitePtr,1])
		(*pState).multiplierPtr=ptr_new([*(*pState).multiplierPtr,1.0])
		(*pState).constantsPtr=ptr_new([*(*pState).constantsPtr,0.0])
		(*pState).filesPtr=ptr_new([*(*pState).filesPtr,filename])
		duration=(*(*(*davePtr).dataStrPtr).specificPtr).duration
		srdenom=(*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom
		(*pState).durationsPtr=ptr_new([*(*pState).durationsPtr,duration])
		(*pState).srdenomsPtr=ptr_new([*(*pState).srdenomsPtr,srdenom])
		if ((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_control[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_setpoint[0] eq 300.0) then begin
			temperature=10000.0
		endif else begin
			temperature=(*(*(*davePtr).dataStrPtr).specificPtr).temp_setpoint
		endelse
		(*pState).temperaturesPtr=ptr_new([*(*pState).temperaturesPtr,temperature])
		(*pState).commentsPtr=ptr_new([*(*pState).commentsPtr,$
			(*(*(*davePtr).dataStrPtr).specificPtr).comments])
		ptr_free,oldptrs
	endif else begin
		oldptrs=[(*pState).pqty,$
			(*pState).perr,$
			(*pState).activePtr,$
			(*pState).hilitePtr,$
			(*pState).multiplierPtr,$
			(*pState).constantsPtr,$
			(*pState).filesPtr,$
			(*pState).durationsPtr,$
			(*pState).srdenomsPtr,$
			(*pState).temperaturesPtr,$
			(*pState).commentsPtr]
		if (not_averaging) then begin
			if((*pState).ReadingDCS) then begin
				dcs_multiplot_getmask,mask,filename,pState,bnk
				dims=size((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty,/dimensions)
				mask=rebin(1#mask,dims[0],dims[1])
				*(*pState).pmask=mask
				(*pState).pqty=ptr_new([[[*(*pState).pqty]],$
					[[((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty)*mask]]],/no_copy)
				(*pState).perr=ptr_new([[[*(*pState).perr]],$
					[[((*(*(*davePtr).dataStrPtr).commonStr.histPtr).err)*mask]]],/no_copy)
			endif else begin
				(*pState).pqty=ptr_new([[[*(*pState).pqty]],$
					[[((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty)]]],/no_copy)
				(*pState).perr=ptr_new([[[*(*pState).perr]],$
					[[((*(*(*davePtr).dataStrPtr).commonStr.histPtr).err)]]],/no_copy)
			endelse
		endif else begin
			(*pState).pqty=ptr_new([[[*(*pState).pqty]],$
				[[(intarr(dims[0])+1)#$
				total((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty,1)/dims[0]]]],/no_copy)
			(*pState).perr=ptr_new([[[*(*pState).perr]],[[intarr(dims[0],dims[1])]]],/no_copy)
		endelse
		(*pState).activePtr=ptr_new([*(*pState).activePtr,1])
		(*pState).hilitePtr=ptr_new([*(*pState).hilitePtr,1])
		(*pState).multiplierPtr=ptr_new([*(*pState).multiplierPtr,1.0])
		(*pState).constantsPtr=ptr_new([*(*pState).constantsPtr,0.0])
		(*pState).filesPtr=ptr_new([*(*pState).filesPtr,filename])
		duration=(*(*(*davePtr).dataStrPtr).specificPtr).duration
		srdenom=(*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom
		(*pState).durationsPtr=ptr_new([*(*pState).durationsPtr,duration])
		(*pState).srdenomsPtr=ptr_new([*(*pState).srdenomsPtr,srdenom])
		if ((*(*(*davePtr).dataStrPtr).specificPtr).temp_sample[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_control[0] eq 300.0 and $
			(*(*(*davePtr).dataStrPtr).specificPtr).temp_setpoint[0] eq 300.0) then begin
			temperature=10000.0
		endif else begin
			temperature=(*(*(*davePtr).dataStrPtr).specificPtr).temp_setpoint
		endelse
		(*pState).temperaturesPtr=ptr_new([*(*pState).temperaturesPtr,temperature])
		(*pState).commentsPtr=ptr_new([*(*pState).commentsPtr,$
		(*(*(*davePtr).dataStrPtr).specificPtr).comments+((*pState).dnumb ? "-ADN" : "")+bnk])
		ptr_free,oldptrs
	endelse
endif
;
; All is well, so append to the appropriate arrays.
if (addingtofile) then begin
	n=(*pState).ndatasets
	if((*pState).ReadingDCS) then begin
		mask=*(*pState).pmask
		(*(*pState).pqty)[*,*,n-1]=(*(*pState).pqty)[*,*,n-1]+$
			(*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty*mask
		(*(*pState).perr)[*,*,n-1]=sqrt(((*(*pState).perr)[*,*,n-1])^2+$
			((*(*(*davePtr).dataStrPtr).commonStr.histPtr).err*mask)^2)
	endif else begin
		(*(*pState).pqty)[*,*,n-1]=(*(*pState).pqty)[*,*,n-1]+$
			(*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty
		(*(*pState).perr)[*,*,n-1]=sqrt(((*(*pState).perr)[*,*,n-1])^2+$
			((*(*(*davePtr).dataStrPtr).commonStr.histPtr).err)^2)
	endelse
	part=strmid(filename,strpos(filename,!delimiter,/reverse_search)+1)
	(*(*pState).filesPtr)[n-1]=(*(*pState).filesPtr)[n-1]+","+part
	duration=(*(*(*davePtr).dataStrPtr).specificPtr).duration
  ; srdenom=(*(*(*davePtr).dataStrPtr).specificPtr).ch_srdenom   (surely not needed)
	(*(*pState).durationsPtr)[n-1]=(*(*pState).durationsPtr)[n-1]+duration
	(*(*pState).commentsPtr)[n-1]=(*(*pState).commentsPtr)[n-1]+","+$
	(*(*(*davePtr).dataStrPtr).specificPtr).comments+((*pState).dnumb ? "-ADN" : "")+bnk
endif
;
end


;************************************************************************************************
pro dcs_multiplot_Read,event
;************************************************************************************************
; This routine reads a DAVE file or a DCS raw data file.
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'dcs_multiplot_read: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue = pState
;
; Obtain IDs of menu items.
readDAVE=widget_info(event.top,find_by_uname="readDAVE")
readDCS=widget_info(event.top,find_by_uname="readDCS")
readDCShigh=widget_info(event.top,find_by_uname="readDCShigh")
readDAVEsum=widget_info(event.top,find_by_uname="readDAVEsum")
readDCSsum=widget_info(event.top,find_by_uname="readDCSsum")
;
; Determine whether reading DCS or DAVE files, and whether or not not_ files.
readingDCS=(event.id eq readDCS) or (event.id eq readDCSsum)
readingDCShigh=event.id eq readDCShigh
readingDAVE=(event.id eq readDAVE) or (event.id eq readDAVEsum)
summingfiles=(event.id eq readDCSsum) or (event.id eq readDAVEsum)
not_summingfiles=1-summingfiles
;
(*pState).readingDCS=readingDCS
(*pState).readingDCShigh=readingDCShigh
;
use_yiming=1
use_yiming=0
not_use_yiming=1-use_yiming
;
; Get the names of one or more DAVE files to be read.
if (readingDAVE) then begin
    widget_control,readDCS,sensitive=0
    widget_control,readDCSsum,sensitive=0
    widget_control,readDCShigh,sensitive=0
;
    if (not_use_yiming) then begin
       filenames=dialog_pickfile(filter="*.dave",path=(*pState).workdir,$
         /multiple_files)
    endif else begin
       limitfrom=(*pState).limitfrom_DAVE
       limitto=(*pState).limitto_DAVE
       obj=obj_new('dm_filesel',/limitfile,limitfrom=limitfrom,limitto=limitto,$
         xsize=500,ysize=20,/multi,filter="dave",path=(*pState).workdir) ;(*!dave_defaults).workdir
       obj->getproperty,file=file,path=path,sep=sep,limitfrom=limitfrom,limitto=limitto
       (*pState).limitfrom_DAVE=limitfrom
       (*pState).limitto_DAVE=limitto
       obj_destroy,obj
       if n_elements(file) ne 0 then filenames=path+sep+file else filenames=''
    endelse
endif
;
; Get the names of one or more DCS raw data files to be read.
if (readingDCS or readingDCShigh) then begin
    widget_control,readDAVE,sensitive=0
    widget_control,readDAVEsum,sensitive=0
    widget_control,(*pState).rawxmenu,sensitive = (*pState).plot_vs_x
    widget_control,(*pState).rawymenu,sensitive = (*pState).plot_vs_y
;
    if (not_use_yiming) then begin
       filenames=dialog_pickfile(filter="*.dcs*",path=(*pState).datadir,$
         /multiple_files)
    endif else begin
       limitfrom=(*pState).limitfrom_dcs
       limitto=(*pState).limitto_dcs
       obj=obj_new('dm_filesel',/limitfile,limitfrom=limitfrom,limitto=limitto,$
         xsize=500,ysize=20,/multi,filter="dcs",path=(*pState).datadir) ;(*!dave_defaults).datdir)
       obj->getproperty,file=file,path=path,sep=sep,limitfrom=limitfrom,limitto=limitto
       (*pState).limitfrom_dcs=limitfrom
       (*pState).limitto_dcs=limitto
       obj_destroy,obj
       if n_elements(file) ne 0 then filenames=path+sep+file else filenames=''
    endelse
endif

; Particular cases readingDCS and readingDCShigh
if(readingDCS) then begin
    widget_control,readDCShigh,sensitive=0
endif

if(readingDCShigh) then begin
    widget_control,readDCS,sensitive=0
    widget_control,readDCSsum,sensitive=0
endif
;
; If there is no file (e.g. the "Cancel" button was pushed), and if
; no files have yet been read, clear the plot. If there is no file
; but at least one file has been read, return.
if (filenames[0] eq "") then begin
    if ((*pState).ndatasets eq 0) then begin
       widget_control,event.top,set_uvalue = pState
       dcs_multiplot_Clear,event
    endif else widget_control,event.top,set_uvalue = pState
    return
endif
;
filenames=filenames[sort(filenames)]
nfiles=n_elements(filenames)
;
; Read one or more files.
for kfile=0,nfiles-1 do begin
    filename=filenames[kfile]
    if (readingDAVE) then restore,filename
    if (readingDCS or readingDCShigh) then begin
       dave_makeDavePtr,davePtr=davePtr
       dcs_definedavestructure,davePtr=davePtr
       dcs_read_binaryOctavefile,filename,0,0,variables_read,davePtr=davePtr,$
         histodata_floating=1
    endif
;
; If this is the first time around, define some additional quantities
; that may be needed at a later stage: time channel widths, times T_SD,
; and energy transfers. Also define the elastic channel and the
; corresponding time-of-flight T_SD(elastic).
    if (readingDCS) then begin
;
; Optionally correct data for bitflips.
		if ((*pState).dobitflips eq 1) then begin
			hdata=(*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty
			hhigh=(*(*(*davePtr).dataStrPtr).specificptr).histohigh
			dsum=(*(*(*davePtr).dataStrPtr).specificptr).detsum
			tsum=(*(*(*davePtr).dataStrPtr).specificptr).timsum
			result=dcs_bitflip_correct(hdata,hhigh,dsum,tsum,$
				maxbf=10,inputfilename='',onlydetect=0,printlevel=1)
			(*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty=hdata
			(*(*(*davePtr).dataStrPtr).specificptr).histohigh=hhigh
			(*(*(*davePtr).dataStrPtr).specificptr).detsum=dsum
			(*(*(*davePtr).dataStrPtr).specificptr).timsum=tsum
		endif

		  if ((*pState).dnumb) then begin
; 			Reorganize the detectors so that they are ordered according to input module.
			  dcs_multiplot_detectors_by_module,shuffle
				(*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty=(*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty[*,shuffle]
			endif

			if ((*pState).ndatasets eq 0) then begin
	      *(*pState).tchansPtr=transpose($
	        (*(*(*davePtr).dataStrPtr).specificPtr).tchanlook[0,0:999])*0.05
	      *(*pState).timesPtr=$
	        (*(*(*(*davePtr).dataStrPtr).specificPtr).time_propsPtr)[0:999]
	      *(*pState).energiesPtr=$
	        (*(*(*(*davePtr).dataStrPtr).specificPtr).energy_propsPtr)[0:999]
	      elastic_channel=$
	        where(abs(*(*pState).energiesPtr) eq min(abs(*(*pState).energiesPtr)))
	      (*pState).elastic_time=(*(*pState).timesPtr)[elastic_channel]
	      (*pState).tsdmin=(*(*(*davePtr).dataStrPtr).specificPtr).tsdmin
	      dummy=where(*(*pState).tchansPtr ne (*(*pState).tchansPtr)[0],count)
	      (*pState).equaltimes=(count eq 0)
	      (*pState).e0=!dcs_hsq2mn/(*(*(*davePtr).dataStrPtr).specificPtr).ch_wl^2
	      (*pState).lambda0=(*(*(*davePtr).dataStrPtr).specificPtr).ch_wl
	    endif
	  endif

    if (readingDCShigh and (*pState).ndatasets eq 0) then begin
       *(*pState).tchansPtr=transpose($
         (*(*(*davePtr).dataStrPtr).specificPtr).tchanlook[0,0:999])*0.05
       *(*pState).timesPtr=$
         (*(*(*(*davePtr).dataStrPtr).specificPtr).time_propsPtr)[0:999]
       *(*pState).energiesPtr=$
         (*(*(*(*davePtr).dataStrPtr).specificPtr).energy_propsPtr)[0:999]
       elastic_channel=$
         where(abs(*(*pState).energiesPtr) eq min(abs(*(*pState).energiesPtr)))
       (*pState).elastic_time=(*(*pState).timesPtr)[elastic_channel]
       (*pState).tsdmin=(*(*(*davePtr).dataStrPtr).specificPtr).tsdmin
       dummy=where(*(*pState).tchansPtr ne (*(*pState).tchansPtr)[0],count)
       (*pState).equaltimes=(count eq 0)
       (*pState).e0=!dcs_hsq2mn/(*(*(*davePtr).dataStrPtr).specificPtr).ch_wl^2
    endif
;
; Having read in a file, sensitize most of the widgets.
    widget_control,(*pState).filebutton_print,/sensitive
    widget_control,(*pState).filebutton_splot,/sensitive
    widget_control,(*pState).filebutton_sdata,/sensitive
    widget_control,(*pState).abscmenu,/sensitive
    widget_control,(*pState).grupmenu,/sensitive
    widget_control,(*pState).gnopmenu,/sensitive
    widget_control,(*pState).rawxmenu,sensitive=((*pState).readingDCS and (*pState).plot_vs_x)
    widget_control,(*pState).rawymenu,sensitive=((*pState).readingDCS and (*pState).plot_vs_y)
    widget_control,(*pState).dsetmenu,/sensitive
    widget_control,(*pState).dsetbutton_rotate,sensitive=(*pState).readingDCS and (*pState).equaltimes
    widget_control,(*pState).dsetbutton_temper,sensitive=(*pState).readingDCS
    widget_control,(*pState).showmenu,/sensitive
;
    widget_control,(*pState).butt_abscrebin,/sensitive
;
; If appropriate, increment the number of datasets read in.
    if ((not_summingfiles) or (summingfiles and kfile eq 0)) then $
       (*pState).ndatasets=(*pState).ndatasets+1
    ndatasets=(*pState).ndatasets
;
; Call "dcs_multiplot_populate" to populate pState.
    addingtofile=(kfile ne 0) and summingfiles
    dcs_multiplot_populate,filename,addingtofile,pState=pState,davePtr=davePtr
    if (ptr_valid(davePtr)) then heap_free, davePtr    ;free_all_ptrs,davePtr
;
; If the number of datasets has been decremented within the
; procedure "dcs_multiplot_populate" (e.g. because dimensions
; do not match), return.
;   NEXT 4 LINES REMOVED 9/24/03.
;   if ((*pState).ndatasets lt ndatasets) then begin
;     widget_control,event.top,set_uvalue = pState
;     return
;   endif
;
    dims=size(*(*pState).pqty,/dimensions)
;
    ndatasets=(*pState).ndatasets
;
; If appropriate, populate the file information box.
    n=n_elements(*(*pState).filesPtr)
    information="no information"
    if (not_summingfiles) then $
       information="  "+strcompress(string(indgen(n)+1))+$
         "  "+*(*pState).filesPtr+"  "+*(*pState).commentsPtr
    if (summingfiles and (kfile eq nfiles-1)) then $
       information="  "+strcompress(string(indgen(n)+1))+$
         "  "+*(*pState).filesPtr+"  "+*(*pState).commentsPtr
   if (information[0] ne "no information") then begin
    	widget_control,(*pState).infowindow,set_value=information
	 		if (ptr_valid((*pState).informationPtr)) then *(*pState).informationPtr=information
	    widget_control,(*pState).infowindow,set_text_top_line=(n-4) > 0
	  endif
;
; Fill in information for "Abscissa" menu items.
    widget_control,(*pState).abscbutton_x,set_value='['+(*pState).xlabel+']'
    widget_control,(*pState).abscbutton_y,set_value=(*pState).ylabel
;
; Use the x and y dimensions to set maximum slider values.
    plotx=(*pState).plot_vs_x
    widget_control,(*pState).butt_groupcenter,set_slider_max=dims[plotx]
    widget_control,(*pState).butt_grouphwidth,set_slider_max=dims[plotx]/2
    widget_control,(*pState).butt_abscrebin,set_slider_max=dims[1-plotx]/10 > 6
    widget_control,(*pState).butt_numgroups,set_slider_max=dims[plotx]; (used to be 31)
    widget_control,(*pState).butt_numgroups,get_value=tmp
    widget_control,(*pState).butt_groupnumber,set_slider_max=tmp
;
    (*pState).xdim=dims[0]
    (*pState).ydim=dims[1]
;
;
endfor
;
; Update the plot.
;wset,(*pState).winstate.winPix
widget_control,event.top,set_uvalue = pState
dcs_multiplot_Plot,event
widget_control,event.top,get_uvalue = pState
;wset,(*pState).winstate.winVis
;device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winstate.winPix]
if (*pState).objectgraphics eq 0 then $
   wshow,(*pState).winstate.winVis
widget_control,event.top,set_uvalue = pState
;
return
;
end


