; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_write_asciiOfile,filename,datafile_ptr=davePtr,compress=compressed,$
	choice=choice,tagnames=tagnames,shortnames=shortnames
;************************************************************************************************
;
compile_opt strictarr
;
; This is a procedure that writes an ascii Octave file.
;
if (filename eq "") then stop
;
on_ioerror, no_file
;
openw,unit,filename,compress=compressed,/get_lun
;
nvars=n_elements(tagnames)
;
linefeed=string(10b)
;
for ivar=0,nvars-1 do begin
	if (choice[ivar]) then begin
		name=tagnames[ivar]
		result=execute("data="+name)
		nsize=size(data)
		ns0=nsize[0]
		nst=nsize[ns0+1]
		if (ns0 eq 0) then begin
			case nst of
				7: dt=5; string
				else: dt=1; scalar
			endcase
		endif
		if (ns0 eq 1) then begin
			case nst of
				7: dt=7; string array
				else: dt=2
			endcase
			if (dt eq 2) then begin & n1=nsize[1] & n2=1 & end
		endif
		if (ns0 eq 2) then begin
			case nst of
				7: dt=0
				else: dt=2
			endcase
			if (dt eq 2) then begin & n1=nsize[1] & n2=nsize[2] & end
		endif
;
		writeu,unit,"# name: "+strlowcase(shortnames[ivar])+linefeed
		case dt of
			1: begin; write scalar
				writeu,unit,"# type: scalar"+linefeed
				printf,unit,data
				writeu,unit,linefeed
			end
			2: begin; write matrix
				writeu,unit,"# type: matrix"+linefeed
				writeu,unit,"# rows:"+strcompress(n2)+linefeed
				writeu,unit,"# columns:"+strcompress(n1)+linefeed
				printf,unit,data
				writeu,unit,linefeed
			end
			5: begin; write string
				nchars=strlen(data)
				writeu,unit,"# type: string array"+linefeed
				writeu,unit,"# elements: 1"+linefeed
				writeu,unit,"# length:"+strcompress(nchars)+linefeed
				printf,unit,data
				writeu,unit,linefeed
			end
			7: begin; write string array
				writeu,unit,"# type: string array"+linefeed
				nstrgs=nsize[1]
				writeu,unit,"# elements:"+strcompress(nstrgs)+linefeed
				for j=0,nstrgs-1 do begin
					nchars=strlen(data[j])
					writeu,unit,"# length:"+strcompress(nchars)+linefeed
					printf,unit,data[j]
					writeu,unit,linefeed
				endfor
			end
			else: stop,"No good."
		endcase
	endif
endfor
;
free_lun,unit
return
;
no_file: begin
	free_lun,unit
	error="There is no file named "+filename
end
;
end
