; $Id$
;#######################################################################
;
; NAME:
;  dm_widget_droplist
;
; PURPOSE:
;  this program creates a widget_droplist for IDL5.5 or before, or a widget_combobox for IDL5.6 or later
;
; CATEGORY:
;  widget
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  July, 2011
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

;parameter:
;   parent:         the widget ID of the parent for the new button widget
;keyword:
;   select:         the item number selected at creation
;   usedroplist:    force to use widget_droplist due to a problem in unix with modal base
;   all keywords available for widget_droplist and widget_combobox
function dm_widget_droplist,parent,select=select,_extra=extra,usedroplist=usedroplist
    if (float(!version.release) ge 5.6) and (~ keyword_set(usedroplist)) then begin
       id = call_function('widget_combobox',parent,_extra=extra)
       if n_elements(select) ne 0 then widget_control,id,set_combobox_select=select
    endif else begin
       id = widget_droplist(parent,_extra=extra)
       if n_elements(select) ne 0 then widget_control,id,set_droplist_select=select
    endelse
    return,id
end