; $Id: dm_to_fit.pro,v 1.14 2016/02/25 21:56:29 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_to_fit
;
; PURPOSE:
;  send the cut data to PAN for fitting
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  November, 2019
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

;This program sends the cut or slice data to PAN
;keyword:
;   slice: if set, send slice data, otherwise send cut data to PAN

pro dcs_mslice::dm_to_fit,slice=slice
    if (~ self->pd_valid()) then return
    opan = 0
    widget_control,/hourglass
    
    ;error handling
    catch, myerror
    if myerror ne 0 then begin
       catch,/cancel
       ok = dialog_message(dialog_parent=self.tlb,!error_state.msg,/error)
       if obj_valid(opan) then obj_destroy,opan
       return
    end

    if keyword_set(slice) then begin    ;slice
       ;get grouped slice data in davePtr
       self->save_slice,dPtr=dPtr,error=error
       if keyword_set(error) then return

       ;make sure that there's no 0's in the error bar
       index = where((*(*(*dPtr).dataStrPtr).commonStr.histPtr).err eq 0.0,count,complement=index1,ncomplement=count1)
       if count ne 0 then begin
          if count1 eq 0 then err=0.01 $
          else err=min(abs((*(*(*dPtr).dataStrPtr).commonStr.histPtr).err[index1]))
          (*(*(*dPtr).dataStrPtr).commonStr.histPtr).err[index] = err
       endif
       
       ;to PAN
       opan = obj_new('opan',davePtr=dPtr,group_leader=self.tlb,workDir=self.dirs[1],davetool=self.DAVETool)
    endif else begin                    ;cut
       ;select data
       self->dm_choose_cutdata,xdat=xdat,ydat=ydat,yerr=yerr,xtit=xtit,ytit=ytit,error=error
       if keyword_set(error) then return
       
       ;replace \AA with string('c5'XB)
       pos = strpos(xtit,'\AA') 
       if pos ne -1 then xtit = strmid(xtit,0,pos)+string('c5'XB)+strmid(xtit,pos+3)
       pos = strpos(ytit,'\AA') 
       if pos ne -1 then ytit = strmid(ytit,0,pos)+string('c5'XB)+strmid(ytit,pos+3)
       
       if n_elements(yerr) ne n_elements(ydat) then begin
          ok  =dialog_message('No yerr. 0.1*y is used as yerr.',dialog_parent=self.tlb)
          yerr=0.1*ydat
       endif

       yerr = abs(yerr)

       ;make sure that there's no 0's in yerr
       index = where(yerr eq 0.0,count,complement=index1,ncomplement=count1)
       if count ne 0 then begin
          if count1 eq 0 then err=0.01 $
          else err=min(abs(yerr[index1]))
          yerr[index] = err
       endif

       info = 'Cut from Mslice'+((self.samp_typ lt 0)?'':(' for '+(*self.ftypename)[self.ftype]))
       if self.samp_typ ge 0 then info = [info,'data file name: '+((n_elements(*self.file_recent) eq 2)?(*self.file_recent)[1]:(*self.file_recent)[1]+' to '+(*self.file_recent)[-1]),$
                                          'data directory: '+(*self.file_recent)[0]]
       
       ;to PAN
       opan = obj_new('opan',mydata=ydat,error=yerr,xval=xdat,yval=0,xtit=xtit,ztit=ytit,header=info,group_leader=self.tlb,workDir=self.dirs[1],davetool=self.DAVETool)
    endelse
    if ptr_valid(dPtr) then heap_free,dPtr
end